'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('../../core/utils/units-converters/rem.cjs');
require('react');
var getSize = require('../../core/utils/get-size/get-size.cjs');
require('@mantine/hooks');
var createVarsResolver = require('../../core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
require('clsx');
var getThemeColor = require('../../core/MantineProvider/color-functions/get-theme-color/get-theme-color.cjs');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var useStyles = require('../../core/styles-api/use-styles/use-styles.cjs');
var Box = require('../../core/Box/Box.cjs');
var factory = require('../../core/factory/factory.cjs');
require('../../core/DirectionProvider/DirectionProvider.cjs');
require('../CloseButton/CloseIcon.cjs');
var CloseButton = require('../CloseButton/CloseButton.cjs');
var Loader = require('../Loader/Loader.cjs');
var Notification_module = require('./Notification.module.css.cjs');

const defaultProps = {
  withCloseButton: true
};
const varsResolver = createVarsResolver.createVarsResolver((theme, { radius, color }) => ({
  root: {
    "--notification-radius": radius === void 0 ? void 0 : getSize.getRadius(radius),
    "--notification-color": color ? getThemeColor.getThemeColor(color, theme) : void 0
  }
}));
const Notification = factory.factory((_props, ref) => {
  const props = useProps.useProps("Notification", defaultProps, _props);
  const {
    className,
    color,
    radius,
    loading,
    withCloseButton,
    withBorder,
    title,
    icon,
    children,
    onClose,
    closeButtonProps,
    classNames,
    style,
    styles,
    unstyled,
    variant,
    vars,
    mod,
    loaderProps,
    role,
    attributes,
    ...others
  } = props;
  const getStyles = useStyles.useStyles({
    name: "Notification",
    classes: Notification_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  return /* @__PURE__ */ jsxRuntime.jsxs(
    Box.Box,
    {
      ...getStyles("root"),
      mod: [{ "data-with-icon": !!icon || loading, "data-with-border": withBorder }, mod],
      ref,
      variant,
      role: role || "alert",
      ...others,
      children: [
        icon && !loading && /* @__PURE__ */ jsxRuntime.jsx("div", { ...getStyles("icon"), children: icon }),
        loading && /* @__PURE__ */ jsxRuntime.jsx(Loader.Loader, { size: 28, color, ...loaderProps, ...getStyles("loader") }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { ...getStyles("body"), children: [
          title && /* @__PURE__ */ jsxRuntime.jsx("div", { ...getStyles("title"), children: title }),
          /* @__PURE__ */ jsxRuntime.jsx(Box.Box, { ...getStyles("description"), mod: { "data-with-title": !!title }, children })
        ] }),
        withCloseButton && /* @__PURE__ */ jsxRuntime.jsx(
          CloseButton.CloseButton,
          {
            iconSize: 16,
            color: "gray",
            ...closeButtonProps,
            unstyled,
            onClick: onClose,
            ...getStyles("closeButton")
          }
        )
      ]
    }
  );
});
Notification.classes = Notification_module;
Notification.displayName = "@mantine/core/Notification";

exports.Notification = Notification;
//# sourceMappingURL=Notification.cjs.map
