'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var rem = require('../../core/utils/units-converters/rem.cjs');
require('react');
var getDefaultZIndex = require('../../core/utils/get-default-z-index/get-default-z-index.cjs');
var getSize = require('../../core/utils/get-size/get-size.cjs');
require('@mantine/hooks');
var createVarsResolver = require('../../core/styles-api/create-vars-resolver/create-vars-resolver.cjs');
require('clsx');
require('../../core/MantineProvider/Mantine.context.cjs');
require('../../core/MantineProvider/default-theme.cjs');
require('../../core/MantineProvider/MantineProvider.cjs');
require('../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.cjs');
var useProps = require('../../core/MantineProvider/use-props/use-props.cjs');
require('../../core/MantineProvider/MantineCssVariables/MantineCssVariables.cjs');
var useStyles = require('../../core/styles-api/use-styles/use-styles.cjs');
require('../../core/Box/Box.cjs');
var factory = require('../../core/factory/factory.cjs');
require('../../core/DirectionProvider/DirectionProvider.cjs');
var ModalBase = require('../ModalBase/ModalBase.cjs');
require('../ModalBase/ModalBaseBody.cjs');
require('../ModalBase/ModalBaseCloseButton.cjs');
require('../ModalBase/ModalBaseContent.cjs');
require('../ModalBase/ModalBaseHeader.cjs');
require('../ModalBase/ModalBaseOverlay.cjs');
require('../ModalBase/ModalBaseTitle.cjs');
var ScrollArea = require('../ScrollArea/ScrollArea.cjs');
var Modal_context = require('./Modal.context.cjs');
var Modal_module = require('./Modal.module.css.cjs');

const defaultProps = {
  __staticSelector: "Modal",
  closeOnClickOutside: true,
  withinPortal: true,
  lockScroll: true,
  trapFocus: true,
  returnFocus: true,
  closeOnEscape: true,
  keepMounted: false,
  zIndex: getDefaultZIndex.getDefaultZIndex("modal"),
  transitionProps: { duration: 200, transition: "fade-down" },
  yOffset: "5dvh"
};
const varsResolver = createVarsResolver.createVarsResolver(
  (_, { radius, size, yOffset, xOffset }) => ({
    root: {
      "--modal-radius": radius === void 0 ? void 0 : getSize.getRadius(radius),
      "--modal-size": getSize.getSize(size, "modal-size"),
      "--modal-y-offset": rem.rem(yOffset),
      "--modal-x-offset": rem.rem(xOffset)
    }
  })
);
const ModalRoot = factory.factory((_props, ref) => {
  const props = useProps.useProps("ModalRoot", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    yOffset,
    scrollAreaComponent,
    radius,
    fullScreen,
    centered,
    xOffset,
    __staticSelector,
    attributes,
    ...others
  } = props;
  const getStyles = useStyles.useStyles({
    name: __staticSelector,
    classes: Modal_module,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    attributes,
    vars,
    varsResolver
  });
  return /* @__PURE__ */ jsxRuntime.jsx(Modal_context.ModalProvider, { value: { yOffset, scrollAreaComponent, getStyles, fullScreen }, children: /* @__PURE__ */ jsxRuntime.jsx(
    ModalBase.ModalBase,
    {
      ref,
      ...getStyles("root"),
      "data-full-screen": fullScreen || void 0,
      "data-centered": centered || void 0,
      "data-offset-scrollbars": scrollAreaComponent === ScrollArea.ScrollArea.Autosize || void 0,
      unstyled,
      ...others
    }
  ) });
});
ModalRoot.classes = Modal_module;
ModalRoot.displayName = "@mantine/core/ModalRoot";

exports.ModalRoot = ModalRoot;
//# sourceMappingURL=ModalRoot.cjs.map
