/*
 * Copyright (c) 2018, Daniel Gultsch All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors
 * may be used to endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package eu.siacs.conversations.ui;

import android.app.Activity;
import android.app.Fragment;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.LifecycleOwner;

import java.util.Set;

import eu.siacs.conversations.ui.interfaces.OnBackendConnected;
import eu.siacs.conversations.xmpp.Jid;

public abstract class XmppFragment extends Fragment implements OnBackendConnected, LifecycleOwner {

	protected LifecycleRegistry lifecycle = new LifecycleRegistry(this);

	abstract protected void refresh();
	public void refreshForNewCaps(final Set<Jid> newCapsJids) { }

	protected void runOnUiThread(Runnable runnable) {
		final Activity activity = getActivity();
		if (activity != null) {
			activity.runOnUiThread(runnable);
		}
	}

	@Override
	public void onStart() {
		super.onStart();
		lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_START);
	}

	@Override
	public void onResume() {
		super.onResume();
		lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
	}

	@Override
	public void onPause() {
		lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
		super.onPause();
	}

	@Override
	public void onStop() {
		lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
		super.onStop();
	}

	@Override
	public void onDestroy() {
		if (lifecycle.getCurrentState().isAtLeast(Lifecycle.State.CREATED)) {
			try {
				lifecycle.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
			} catch (IllegalStateException e) {  }
		}
		super.onDestroy();
	}

	@Override
	public Lifecycle getLifecycle() {
		return lifecycle;
	}
}
