## Rethink DNS + Firewall + VPN for Android
A [WireGuard](https://github.com/wireguard/wireguard-go) client, an [OpenSnitch](https://github.com/evilsocket/opensnitch)-inspired firewall and network monitor + a [pi-hole](https://github.com/pi-hole/pi-hole)-inspired DNS over HTTPS client with blocklists.

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
     alt="Get it on F-Droid"
     height="70">](https://f-droid.org/packages/com.celzero.bravedns/)
[<img src="https://play.google.com/intl/en_us/badges/images/generic/en-play-badge.png"
     alt="Get it on Google Play"
     height="70">](https://play.google.com/store/apps/details?id=com.celzero.bravedns)

<sup>*Release certificate SHA-256 digest*: `1f32d432e81a1dc5c00aafeb0c6636cd7819965d174420e59db9675dff7a88e9`.</sup>

In other words, Rethink DNS + Firewall has three primary modes, VPN, DNS, and Firewall. The VPN (proxifier) mode supports multiple WireGuard upstreams in a split-tunnel configuration. The DNS mode routes all DNS traffic generated by apps to _any_ user chosen DNS-over-HTTPS or DNSCrypt resolver. The Firewall mode lets the user deny internet-access to entire applications based on events like screen-on / screen-off, app-foreground / app-background, unmetered-connection / metered-connection; or based on play-store defined categories like Social, Games, Utility, Productivity; or additionally, based on user-defined denylists.

![2](https://github.com/celzero/rethink-app/assets/56958445/618bb47c-586c-41b9-ba1c-f62c2bbc9649)
![3](https://github.com/celzero/rethink-app/assets/56958445/c74f3485-7197-4e5b-860f-c2b11c556cee)
![4](https://github.com/celzero/rethink-app/assets/56958445/a2032d44-f07c-45e9-801b-7abe0cac0ead)
![5](https://github.com/celzero/rethink-app/assets/56958445/b9973e69-d45e-4be9-bd42-b80fb2768ec5)

### VPN / Proxifier
Rethink supports forwarding TCP and UDP connections over SOCKS5, HTTP CONNECT, and WireGuard tunnels. Split-tunneling further helps run multiple such tunnels at the same time and lets users route different apps over different tunnels. For example, one could route Firefox over SOCKS5 connecting to Tor, Netflix over WireGuard connecting through any popular VPN provider, and Telegram or WhatsApp over censorship-resistant HTTP CONNECT endpoints at the same time.

### Firewall
The firewall doesn't really care about the connections per se rather what's making those connections. This is different from the traditional firewalls but in-line with [Little Snitch](https://www.obdev.at/products/littlesnitch/index.html), [LuLu](https://objective-see.com/products/lulu.html), [Glasswire](https://glasswire.com/) and others.

Currently, per-app connection mapping is implemented by capturing `udp` and `tcp` connections managed by [`firestack`](https://github.com/celzero/firestack) (written in golang) and asking [ConnectivityService for the owner](https://developer.android.com/about/versions/10/privacy/changes#proc-net-filesystem), an API available only on Android 10 or higher. `procfs` (`/proc/net/tcp` and `/proc/net/udp`) is read on-demand to track per-app connections like [NetGuard](https://github.com/M66B/NetGuard/) or OpenSnitch do, on Android 9 and lower versions.

### Network Monitor
A network monitor is a per-app report-card of sorts on when connections were made, how many were made, and to where. Tracking TCP has turned out to be so far straight-forward. DNS packets are trickier to track, and so a rough heuristic is used for now, which may not hold good in all cases.

### DNS over HTTPS client
Almost all of the network related code (`firestack`), including DNS over HTTPS split-tunnel, is a hard fork of [Jigsaw-Code/outline-go-tun2socks](https://github.com/Jigsaw-Code/outline-go-tun2socks) written in golang. The UI is vastly different but borrows minimally from [Jigsaw-Code/Intra](https://github.com/Jigsaw-Code/Intra/). A split-tunnel traps requests sent to the VPN's DNS endpoint and relays it to a DNS-over-HTTPS / DNSCrypt endpoint of the user's choosing, logging the end-to-end latency, time of request, the dns request query itself and its answer.

### The Rethink DNS Resolver
A malware and ad-blocking DNS over HTTPS resolver at `https://sky.rethinkdns.com/1:IAAgAA==` (deployed to 300+ locations world-wide via Cloudflare Workers) is the default DNS endpoint on the app, though the user is free to change that. A configurable DNS resolver that lets users add or remove denylists and allowlists, add rewrites, analyse DNS requests is launching late 2023. Right now, a free-to-use DNS over HTTPS endpoint with custom blocklists can be setup here: [rethinkdns.com/configure](https://rethinkdns.com/configure).

The resolver is deployed to [Fly.io](https://fly.io/) at `max.rethinkdns.com` and [Deno Deploy](https://deno.com/deploy) at `rdns.deno.dev` too, apart from the default deployment on [Cloudflare Workers](https://workers.dev).

The resolver is open source software: [serverless-dns](https://github.com/serverless-dns/serverless-dns).

### The Rethink Proxy Network
Routing TCP connections over a serverless proxy (hosted on Cloudflare Workers) [will soon be part of Rethink](https://github.com/celzero/rethink-app/issues/946). Users would be able to self-host these
or use the ones run by us for $1 month of unlimited bandwidth. This service is expected to be launching late 2023.

The proxy is open source software: [serverless-proxy](https://github.com/serverless-proxy/serverless-proxy).

### Community
[<img src="https://img.shields.io/github/sponsors/serverless-dns"
     alt="GitHub Sponsors">](https://github.com/sponsors/serverless-dns)
- The telegram community is super active and full of crypto-bros. Kidding. We are generally a welcoming bunch. Feel free to get in touch: [t.me/rethinkdns](https://t.me/rethinkdns).
- Or, if you prefer [Matrix](https://matrix.to/#/!jrTSpJiEkFNNBMhSaE:matrix.org) (which is bridged to Telegram).
- Or, email us: [hello@celzero.com](mailto:hello@celzero.com) (we read all emails immediately and reply once we fix the issues being reported).
- We regularly hangout in our subreddit: [r/rethinkdns](https://reddit.com/r/rethinkdns).
- We're also kind of active on the bird app, mostly nerd-sniping other engs or shit-posting about our tech stack: [twitter/rethinkdns](https://twitter.com/rethinkdns).

### Translation
Help translate Rethink DNS + Firewall on [Weblate](https://weblate.org/):<br>
[![](https://hosted.weblate.org/widgets/rethink-dns-firewall/-/287x66-black.png)](https://hosted.weblate.org/engage/rethink-dns-firewall)

### What Rethink DNS + Firewall is not
Rethink is not an anonymity tool: It helps users tackle unabated censorship and surveillance but doesn't lay claim to protecting a user's identity at all times, if ever.

Rethink doesn't aim to be a feature-rich traditional firewall: It is more in-line with [Little Snitch](https://www.obdev.at/products/littlesnitch/index.html) than IP tables, say.

Rethink is not an anti-virus: Rethink may stop users from phishing attacks, malware, scareware websites through its DNS-based blocklists, but it doesn't actively mitigate threats or even look for them or act on them, otherwise.

### What Rethink DNS + Firewall aspires to be
To turn Android devices into user-agents: Something that users can control as they please without requiring root-access. A big part of this, for an always-on, always-connected devices, is capturing network traffic and reporting it in a way that makes sense to the end-users who can then take a series of actions to limit their exposure but not necessarily eliminate it. Take DNS for example-- for most if not all connections, apps send out a DNS request first, and by tracking just those one can glean a lot of intelligence about what's happening with the phone and which app's responsible.

To deliver the promise of open-internet for all: With the inevitable ESNI standardization and the imminent adoption of DNS over HTTPS and DNS over TLS across operating systems, we're that much closer to an open internet. Of course, *Deep Packet Inspection* remains a credible threat that can't be mitigated with this, but it is one example of delivering maximum impact (circumvent internet censorship in most countries) with minimal effort (not requiring use of a VPN or access via IPFS, for example). Rethink would continue to make these technologies accessible in the most simplest way possible, especially the ones that get 90% of the way there with 10% effort.

## Development
[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/celzero/rethink-app/badge)](https://securityscorecards.dev/viewer/?uri=github.com/celzero/rethink-app)

1. Feel free to fork and send along a pull request for any reproducible bug fixes.
  1. The codebase is raw and is lacking documentation and comprehensive tests. If you need help, feel free to create a Wikipage to highlight the pain with building, testing, writing, committing code.
  2. Write descriptive commit messages that explain concisely the changes made. 
  3. Each commit must reference an open issue on the project. This is to make sure there isn't duplicated effort more than anything else.
2. If you plan to work on a feature, please create a github issue on the project first to kickstart the discussion before committing to doing any work. Again, this is to avoid duplicate work more than anything else. 
3. Prod releases are usually once every 2 months, while betas are released bi-weekly.

## Tenets (unless you know better ones)
We aren't there yet, may never will be but these are some tenets for the project for the foreseeable future.

- Make it right, make it secure, make it resilient, make it fast. In that order.
- Easy to use, no-root, no-gimmicks features that are anti-censorship and anti-surveillance.
  - Easy to use: Any of the 3B+ Android users must be able to use it. Think CleanMaster / Instagram levels of ease-of-use. 
  - no-root: Shouldn't require root-access for any functionality added to it.
  - no-gimmicks: Misleading material bordering on scareware, for example.
  - anti-censorship: Features focused on helping bring an open internet to everyone, preferably in the most efficient way possible (both monetarily and technically).
 - Anti-surveillance: As above, but features that further limit (may not necessarily eliminate) surveillance by apps.
- Incremental changes in balance with newer features.
  - For example, work on nagging UI issues or OEM specific bugs, must be taken up on equal weight to newer features, and a release must probably establish a good balance between the two. However; working on only incremental changes for a release is fine.
- Opinionated. Chip-away complexity. Do not expect users to require a PhD in Computer Science to use the app.
  - No duplicate functionality.
  - A concerted effort to not provide too many tunable knobs and settings. To err on the side of easy over simple.
- Ignore all tenets.
  - Common sense always takes over when tenets get in the way.
- Must be distributable on the PlayStore, at least some toned down version of it. 
  - This unfortunately means on-device blocklists aren't possible; however, [Cloudflare Gateway](https://www.cloudflare.com/teams-gateway/)-esque cloud-based per-user blocklists get us the same functionality.
- Practice what you preach: Be obsessively private and secure.

## Backstory
[<img src="https://raw.githubusercontent.com/fossunited/Branding/main/asset/FOSS%20United%20Logo/Extra/Extra%20Logo%20white%20on%20black.jpg"
     alt="FOSS United"
     height="40">](https://fossunited.org/grants)&emsp;
[<img src="https://rethinkdns.com/ico/moz-builders-2000x550.png"
     alt="Mozilla Builders"
     height="40">](https://builders.mozilla.community/old/alumni.html)&emsp;

Internet censorship (sometimes ISP-enforced and often times government-enforced), unabated dragnet surveillance (by pretty much every company and app) stirred us upon this path. The three of us university classmates, [Mohammed](https://www.linkedin.com/in/hussain-mohammed-2525a626/), [Murtaza](https://www.linkedin.com/in/murtaza-aliakbar/), [Santhosh](https://www.linkedin.com/in/santhosh-ponnusamy-2b781244/) got together in late 2019 in the sleepy town of Coimbatore, India to do something about it. Our main gripe was there were all these wonderful tools that people could use but couldn't, either due to cost or due to inability to grok Computer-specific jargon. A lot has happened since we started and a lot has changed but our focus has always been on Android and its 2B+ unsuspecting users. The current idea has been in the works for since May 2020, with the pandemic derailing a bit of progress, and a bit of snafu with abandoning our previous version in favour of the current fork, which we aren't proud of yet, but it is a start. All's good now that we've won a grant from the [Mozilla Builders MVP program](https://builders.mozilla.community/) to go ahead and build this thing that we wanted to... do so faster... and not simply sleep our way through the execution. I hope you're excited but not as much as us that you quit your jobs for this like we did.

