package com.jocmp.capy.accounts

import kotlinx.serialization.Serializable

@Serializable
enum class Source(val value: String) {
    LOCAL("local"),
    FEEDBIN("feedbin"),
    FRESHRSS("freshrss"),

    /** Miniflux with username/password combination */
    MINIFLUX("miniflux"),

    /** Miniflux with API Token */
    MINIFLUX_TOKEN("miniflux_token"),
    READER("reader");

    val hasCustomURL
        get() = this == FRESHRSS ||
                this == MINIFLUX ||
                this == MINIFLUX_TOKEN ||
                this == READER

    val requiresUsername
        get() = this != MINIFLUX_TOKEN

    val supportsLabels
        get() = this == FRESHRSS

    /**
     * Miniflux's API with delete all feeds within a category
     * instead of reassigning them. This is surprising and
     * destructive behavior so it's unsupported within the app.
     */
    val supportsTagDeletion
        get() = !isMiniflux

    val supportsPages
        get() = this == FEEDBIN

    private val isMiniflux
        get() = this == MINIFLUX || this == MINIFLUX_TOKEN

}
