package com.capyreader.app.ui.theme.colorschemes

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color
import com.capyreader.app.ui.theme.colorschemes.BaseColorScheme

/**
 * Colors for Catppuccin theme
 * MIT License
 * Copyright (c) 2021 Catppuccin
 * https://catppuccin.com
 * M3 colors generated by Material Theme Builder (https://goo.gle/material-theme-builder-web)
 *
 * Key colors (dark):
 * Primary #CBA6F4
 * Secondary #CBA6F4
 * Tertiary #CBA6F4
 * Neutral #181825

 * Key colors (light):
 * Primary #8839EF
 * Secondary #8839EF
 * Tertiary #8839EF
 * Neutral #E6E9EF
 */
internal object CatppuccinColorScheme : BaseColorScheme() {

    override val darkScheme = darkColorScheme(
        primary = Color(0xFFCBA6F7),
        onPrimary = Color(0xFF11111B),
        primaryContainer = Color(0xFFCBA6F7),
        onPrimaryContainer = Color(0xFF11111B),
        secondary = Color(0xFFCBA6F7), // Unread badge
        onSecondary = Color(0xFF11111B), // Unread badge text
        secondaryContainer = Color(0xFF313244), // Navigation bar selector pill & progress indicator (remaining)
        onSecondaryContainer = Color(0xFFCBA6F7), // Navigation bar selector icon
        tertiary = Color(0xFFCBA6F7), // Volume and brightness bars, Downloaded badge
        onTertiary = Color(0xFF11111B), // Downloaded badge text
        tertiaryContainer = Color(0xFF1E1E2E),
        onTertiaryContainer = Color(0xFFCDD6F4),
        error = Color(0xFFF38BA8),
        onError = Color(0xFF11111B),
        errorContainer = Color(0xFFFF0558),
        onErrorContainer = Color(0xFFEF9FB4),
        background = Color(0xFF181825),
        onBackground = Color(0xFFCDD6F4),
        surface = Color(0xFF181825),
        onSurface = Color(0xFFCDD6F4),
        surfaceVariant = Color(0xFF1E1E2E), // Navigation bar background (ThemePrefWidget)
        onSurfaceVariant = Color(0xFFCDD6F4), // Button (unselected)
        outline = Color(0xFFCBA6F7),
        outlineVariant = Color(0xFF585B70), // Outlines for buttons
        scrim = Color(0xFF11111B),
        inverseSurface = Color(0xFFEFF1F5), // Snackbar or whatever they called
        inverseOnSurface = Color(0xFF4C4F69), // Snackbar text
        inversePrimary = Color(0xFF8839EF), // Snackbar accent
        surfaceDim = Color(0xFF181825),
        surfaceBright = Color(0xFF313244),
        surfaceContainerLowest = Color(0xFF181825),
        surfaceContainerLow = Color(0xFF1E1E2E), // Repo cards
        surfaceContainer = Color(0xFF1E1E2E),
        surfaceContainerHigh = Color(0xFF1E1E2E), // Filter menu
        surfaceContainerHighest = Color(0xFF313244), // Untoggleg button bg
    )

    override val lightScheme = lightColorScheme(
        primary = Color(0xFF8839EF),
        onPrimary = Color(0xFFDCE0E8),
        primaryContainer = Color(0xFF8839EF),
        onPrimaryContainer = Color(0xFFDCE0E8),
        secondary = Color(0xFF8839EF), // Unread badge
        onSecondary = Color(0xFFDCE0E8), // Unread badge text
        secondaryContainer = Color(0xFFCDD0DA), // Navigation bar selector pill & progress indicator (remaining)
        onSecondaryContainer = Color(0xFF8839EF), // Navigation bar selector icon
        tertiary = Color(0xFF8839EF), // Volume and brightness bars, Downloaded badge
        onTertiary = Color(0xFFDCE0E8), // Downloaded badge text
        tertiaryContainer = Color(0xFFEFF1F5),
        onTertiaryContainer = Color(0xFF4C4F69),
        error = Color(0xFFD20F39),
        onError = Color(0xFFDCE0E8),
        errorContainer = Color(0xFF68001C),
        onErrorContainer = Color(0xFFD61C41),
        background = Color(0xFFE6E9EF),
        onBackground = Color(0xFF4C4F69),
        surface = Color(0xFFE6E9EF),
        onSurface = Color(0xFF4C4F69),
        surfaceVariant = Color(0xFFEFF1F5), // Navigation bar background (ThemePrefWidget)
        onSurfaceVariant = Color(0xFF4C4F69), // Button (unselected)
        outline = Color(0xFF8839EF),
        outlineVariant = Color(0xFFACB0BE), // Outlines for buttons
        scrim = Color(0xFFDCE0E8),
        inverseSurface = Color(0xFF1E1E2E), // Snackbar
        inverseOnSurface = Color(0xFFCDD6F4), // Snackbar text
        inversePrimary = Color(0xFFCBA6F7), // Snackbar accent
        surfaceDim = Color(0xFFE6E9EF),
        surfaceBright = Color(0xFFCDD0DA),
        surfaceContainerLowest = Color(0xFFE6E9EF),
        surfaceContainerLow = Color(0xFFEFF1F5), // Repo cards
        surfaceContainer = Color(0xFFEFF1F5), // Navigation bar background
        surfaceContainerHigh = Color(0xFFEFF1F5), // Filter menu
        surfaceContainerHighest = Color(0xFFCDD0DA), // Untoggleg bg
    )
}
