package com.jocmp.capy

class OPMLFile(
    val account: Account
) {
    suspend fun opmlDocument(): String {
        val openingText = """
        |<?xml version="1.0" encoding="UTF-8"?>
        |<!-- OPML generated by Capy Reader -->
        |<opml version="1.1">
        |  <head>
        |    <title>Capy Reader Export</title>
        |  </head>
        |  <body>
        |
		""".trimMargin()

        val closingText = """
        |  </body>
        |</opml>
        """.trimMargin()

        return openingText + account.asOPML() + closingText
    }
}
