package com.capyreader.app.ui.articles.detail

import androidx.compose.material3.MaterialTheme.colorScheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.toArgb
import com.jocmp.capy.articles.TemplateColors

@Composable
fun articleTemplateColors() =
    TemplateColors(
        primary = colorScheme.primary.toHTMLColor(),
        surface = colorScheme.surface.toHTMLColor(),
        surfaceContainerHighest = colorScheme.surfaceContainerHighest.toHTMLColor(),
        onSurface = colorScheme.onSurface.toHTMLColor(),
        onSurfaceVariant = colorScheme.onSurfaceVariant.toHTMLColor(),
        surfaceVariant = colorScheme.surfaceVariant.toHTMLColor(),
        primaryContainer = colorScheme.primaryContainer.toHTMLColor(),
        onPrimaryContainer = colorScheme.onPrimaryContainer.toHTMLColor(),
        secondary = colorScheme.secondary.toHTMLColor(),
        surfaceContainer = colorScheme.surfaceContainer.toHTMLColor(),
        surfaceTint = colorScheme.surfaceTint.toHTMLColor(),
    ).asMap()


private fun Color.toHTMLColor(): String {
    val hex = Integer.toHexString(toArgb()).takeLast(6)

    return "#${hex.uppercase()}"
}
