package org.session.libsession.utilities

// String substitution keys for use with the Phrase library.
// Note: The substitution will be to {app_name} etc. in the strings - but do NOT include the curly braces in these keys!
object StringSubstitutionConstants {
    const val ACCOUNT_ID_KEY                 = "account_id"
    const val AUTHOR_KEY                     = "author"
    const val APP_NAME_KEY                   = "app_name"
    const val COMMUNITY_NAME_KEY             = "community_name"
    const val CONVERSATION_COUNT_KEY         = "conversation_count"
    const val CONVERSATION_NAME_KEY          = "conversation_name"
    const val COUNT_KEY                      = "count"
    const val DATE_TIME_KEY                  = "date_time"
    const val DISAPPEARING_MESSAGES_TYPE_KEY = "disappearing_messages_type"
    const val DOWNLOAD_URL_KEY               = "session_download_url" // Used to invite people to download Session
    const val EMOJI_KEY                      = "emoji"
    const val FILE_TYPE_KEY                  = "file_type"
    const val GROUP_NAME_KEY                 = "group_name"
    const val MEMBERS_KEY                    = "members"
    const val MESSAGE_COUNT_KEY              = "message_count"
    const val MESSAGE_SNIPPET_KEY            = "message_snippet"
    const val NAME_KEY                       = "name"
    const val OTHER_NAME_KEY                 = "other_name"
    const val QUERY_KEY                      = "query"
    const val SECONDS_KEY                    = "seconds"
    const val TOTAL_COUNT_KEY                = "total_count"
    const val TIME_KEY                       = "time"
    const val TIME_LARGE_KEY                 = "time_large"
    const val TIME_SMALL_KEY                 = "time_small"
    const val URL_KEY                        = "url"
    const val VERSION_KEY                    = "version"
}