import React, { useEffect, useState } from 'react';
import Themes from '../Utilities/Themes';
import Translations from '../Utilities/Translations';
import { convertGregorianToJalali } from '../Utilities';
export var CalendarType;
(function (CalendarType) {
    CalendarType[CalendarType["Gregorian"] = 0] = "Gregorian";
    CalendarType[CalendarType["Jalali"] = 1] = "Jalali";
})(CalendarType || (CalendarType = {}));
export var DateTimePickerMode;
(function (DateTimePickerMode) {
    DateTimePickerMode[DateTimePickerMode["Date"] = 0] = "Date";
    DateTimePickerMode[DateTimePickerMode["Time"] = 1] = "Time";
    DateTimePickerMode[DateTimePickerMode["DateTime"] = 2] = "DateTime";
})(DateTimePickerMode || (DateTimePickerMode = {}));
export var PickerMode;
(function (PickerMode) {
    PickerMode[PickerMode["Day"] = 0] = "Day";
    PickerMode[PickerMode["Year"] = 1] = "Year";
    PickerMode[PickerMode["Hour"] = 2] = "Hour";
    PickerMode[PickerMode["Minute"] = 3] = "Minute";
})(PickerMode || (PickerMode = {}));
const currentDate = new Date();
export const DateTimePickerContext = React.createContext({
    month: 0,
    year: 2020,
    persianNumber: false,
    theme: Themes.Primary,
    setHour: () => undefined,
    setPickerMode: () => undefined,
    setYear: () => undefined,
    selectedDate: currentDate,
    setMonth: () => undefined,
    setMinute: () => undefined,
    pickerMode: PickerMode.Day,
    setYearMonth: () => undefined,
    setSelectedDate: () => undefined,
    calendar: CalendarType.Gregorian,
    translation: Translations.DEFAULT,
});
const DateTimePickerProvider = ({ children, persianNumber = false, theme = Themes.Primary, initialDate = currentDate, mode = PickerMode.Day, calendar = CalendarType.Gregorian, translation = Translations.DEFAULT, }) => {
    const [DateTimePicker, setDateTimePicker] = useState({
        pickerMode: mode,
        theme: theme,
        calendar: calendar,
        translation: translation,
        selectedDate: initialDate,
        persianNumber: persianNumber,
        month: initialDate.getMonth(),
        year: initialDate.getFullYear(),
    });
    useEffect(() => {
        let date = calendar === CalendarType.Gregorian || initialDate.getFullYear() < 1900
            ? initialDate
            : convertGregorianToJalali(initialDate);
        setDateTimePicker({
            ...DateTimePicker,
            pickerMode: mode,
            theme: theme,
            calendar: calendar,
            selectedDate: date,
            month: date.getMonth(),
            year: date.getFullYear(),
            translation: translation,
            persianNumber: persianNumber,
        });
    }, [calendar, persianNumber, translation, theme, mode]);
    return (React.createElement(DateTimePickerContext.Provider, { value: {
            pickerMode: DateTimePicker.pickerMode,
            year: DateTimePicker.year,
            month: DateTimePicker.month,
            theme: DateTimePicker.theme,
            calendar: DateTimePicker.calendar,
            translation: DateTimePicker.translation,
            selectedDate: DateTimePicker.selectedDate,
            persianNumber: DateTimePicker.persianNumber,
            setYear: (year) => {
                DateTimePicker.selectedDate.setFullYear(year);
                setDateTimePicker({
                    ...DateTimePicker,
                    year: year,
                    pickerMode: PickerMode.Day,
                    selectedDate: DateTimePicker.selectedDate,
                });
            },
            setHour: (hour) => {
                DateTimePicker.selectedDate.setHours(hour);
                setDateTimePicker({
                    ...DateTimePicker,
                    selectedDate: new Date(DateTimePicker.selectedDate),
                });
            },
            setMinute: (minute) => {
                DateTimePicker.selectedDate.setMinutes(minute);
                setDateTimePicker({
                    ...DateTimePicker,
                    selectedDate: new Date(DateTimePicker.selectedDate),
                });
            },
            setPickerMode: (mode) => {
                setDateTimePicker({ ...DateTimePicker, pickerMode: mode });
            },
            setMonth: (month) => {
                setDateTimePicker({ ...DateTimePicker, month: month });
            },
            setSelectedDate: (date) => {
                setDateTimePicker({ ...DateTimePicker, selectedDate: date });
            },
            setYearMonth: (year, month) => {
                setDateTimePicker({ ...DateTimePicker, year: year, month: month });
            },
        } }, children));
};
export default DateTimePickerProvider;
//# sourceMappingURL=DateTimePickerProvider.js.map