import React, { memo } from 'react';
import styles from './styles';
import { Text, View } from 'react-native';
import useDateTimePicker from '../../Hooks/useDateTimePicker';
import { weekDaysGregorian, weekDaysJalali } from '../../Utilities/Contants';
import { CalendarType } from '../../Providers/DateTimePickerProvider';
function WeekDays() {
    const { calendar, theme } = useDateTimePicker();
    return (React.createElement(View, { style: styles.week_days }, [
        ...(calendar === CalendarType.Gregorian
            ? weekDaysGregorian
            : weekDaysJalali),
    ]
        .sort((a, b) => (a.value < b.value ? 1 : -1))
        .map((item) => {
        return (React.createElement(View, { key: item.value, style: styles.week_day },
            React.createElement(Text, { style: { color: theme.WeekDayText } }, item.label.substr(0, 1))));
    })));
}
export default memo(WeekDays);
//# sourceMappingURL=index.js.map