import React, { useEffect, useState } from 'react';
import { Platform, Pressable, TextInput } from 'react-native';
import useDateTimePicker from '../../Hooks/useDateTimePicker';
import styles from './styles';
export default function Input({ value, onChange, selected, onPress }) {
    const { theme } = useDateTimePicker();
    const [Focus, setFocus] = useState(selected);
    const [Value, setValue] = useState(('0' + value).slice(-2));
    useEffect(() => {
        if (value !== parseInt(Value)) {
            setValue(('0' + value).slice(-2));
        }
    }, [value]);
    useEffect(() => setFocus(selected), [selected]);
    return (React.createElement(Pressable, { onPress: onPress },
        React.createElement(TextInput, { value: Value, editable: Focus, keyboardType: "number-pad", onPressIn: Platform.OS === 'ios' ? onPress : undefined, underlineColorAndroid: "transparent", onChangeText: (text) => {
                setValue(text);
                onChange(parseInt(text));
            }, style: [
                styles.input,
                {
                    color: Focus
                        ? theme.TimeInputFocusForeground
                        : theme.TimeInputForeground,
                    backgroundColor: Focus
                        ? theme.TimeInputFocusBackground
                        : theme.TimeInputBackground,
                },
            ] })));
}
//# sourceMappingURL=index.js.map