import React, { useMemo } from 'react';
import styles from './styles';
import Day from '../Day';
import { FlatList } from 'react-native';
import { getDateUTCString, getMonthDays } from '../../Utilities';
import useDateTimePicker from '../../Hooks/useDateTimePicker';
export default function Days({ onPressDay }) {
    const { month, year, persianNumber, selectedDate } = useDateTimePicker();
    const days = useMemo(() => getMonthDays(year, month, persianNumber), [
        year,
        month,
        persianNumber,
    ]);
    return (React.createElement(FlatList, { numColumns: 7, style: styles.days, columnWrapperStyle: styles.content_container, data: days, getItemLayout: (_, index) => {
            return {
                length: 40,
                offset: index * 40,
                index,
            };
        }, renderItem: ({ item }) => (React.createElement(Day, { value: item.value, label: item.label, onPressDay: onPressDay, selected: getDateUTCString(item?.value) === getDateUTCString(selectedDate) })), keyExtractor: (item, i) => getDateUTCString(item.value) ?? `${i}` }));
}
//# sourceMappingURL=index.js.map