import React from 'react';
import styles from './styles';
import { Pressable, Text, View } from 'react-native';
import useDateTimePicker from '../../Hooks/useDateTimePicker';
export default function Buttons({ onOk, onCancel }) {
    const { translation, theme } = useDateTimePicker();
    return (React.createElement(View, { style: styles.buttons_container },
        React.createElement(View, { style: styles.button_container },
            React.createElement(Pressable, { onPress: onCancel, style: [
                    styles.button,
                    styles.button_cancel,
                    { backgroundColor: theme.HeaderBackground },
                ], android_ripple: { borderless: true, color: theme.ButtonRipple } },
                React.createElement(Text, { style: { color: theme.HeaderDay } }, translation?.cancel))),
        React.createElement(View, { style: styles.button_container },
            React.createElement(Pressable, { onPress: onOk, style: [
                    styles.button,
                    styles.button_ok,
                    { backgroundColor: theme.OkBackground },
                ], android_ripple: { borderless: true, color: theme.ButtonRipple } },
                React.createElement(Text, { style: { color: theme.OkText } }, translation?.ok)))));
}
//# sourceMappingURL=index.js.map