/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @lightSyntaxTransform
 * @noflow
 * @nolint
 * @preventMunge
 * @preserve-invariant-messages
 */

"use no memo";
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var t$d = require("@babel/types");
var require$$0$3 = require("tty");
var require$$1$1 = require("util");
var require$$0$4 = require("os");
var require$$0$6 = require("path");
var require$$0$5 = require("fs");
var require$$0$7 = require("buffer");
var crypto$2 = require("crypto");
function _interopNamespaceDefault(e) {
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== "default") {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(
          n,
          k,
          d.get
            ? d
            : {
                enumerable: true,
                get: function () {
                  return e[k];
                },
              },
        );
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}
var t__namespace = _interopNamespaceDefault(t$d);
var commonjsGlobal =
  typeof globalThis !== "undefined"
    ? globalThis
    : typeof window !== "undefined"
      ? window
      : typeof global !== "undefined"
        ? global
        : typeof self !== "undefined"
          ? self
          : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default")
    ? x["default"]
    : x;
}
function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
  if (typeof f == "function") {
    var a = function a() {
      if (this instanceof a) {
        return Reflect.construct(f, arguments, this.constructor);
      }
      return f.apply(this, arguments);
    };
    a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, "__esModule", { value: true });
  Object.keys(n).forEach(function (k) {
    var d = Object.getOwnPropertyDescriptor(n, k);
    Object.defineProperty(
      a,
      k,
      d.get
        ? d
        : {
            enumerable: true,
            get: function () {
              return n[k];
            },
          },
    );
  });
  return a;
}
var lib$t = {};
var file = {};
var lib$s = {};
var lib$r = {};
var visitors$1 = {};
var virtualTypes$1 = {};
var hasRequiredVirtualTypes$1;
function requireVirtualTypes$1() {
  if (hasRequiredVirtualTypes$1) return virtualTypes$1;
  hasRequiredVirtualTypes$1 = 1;
  Object.defineProperty(virtualTypes$1, "__esModule", { value: true });
  virtualTypes$1.Var =
    virtualTypes$1.User =
    virtualTypes$1.Statement =
    virtualTypes$1.SpreadProperty =
    virtualTypes$1.Scope =
    virtualTypes$1.RestProperty =
    virtualTypes$1.ReferencedMemberExpression =
    virtualTypes$1.ReferencedIdentifier =
    virtualTypes$1.Referenced =
    virtualTypes$1.Pure =
    virtualTypes$1.NumericLiteralTypeAnnotation =
    virtualTypes$1.Generated =
    virtualTypes$1.ForAwaitStatement =
    virtualTypes$1.Flow =
    virtualTypes$1.Expression =
    virtualTypes$1.ExistentialTypeParam =
    virtualTypes$1.BlockScoped =
    virtualTypes$1.BindingIdentifier =
      void 0;
  virtualTypes$1.ReferencedIdentifier = ["Identifier", "JSXIdentifier"];
  virtualTypes$1.ReferencedMemberExpression = ["MemberExpression"];
  virtualTypes$1.BindingIdentifier = ["Identifier"];
  virtualTypes$1.Statement = ["Statement"];
  virtualTypes$1.Expression = ["Expression"];
  virtualTypes$1.Scope = ["Scopable", "Pattern"];
  virtualTypes$1.Referenced = null;
  virtualTypes$1.BlockScoped = null;
  virtualTypes$1.Var = ["VariableDeclaration"];
  virtualTypes$1.User = null;
  virtualTypes$1.Generated = null;
  virtualTypes$1.Pure = null;
  virtualTypes$1.Flow = [
    "Flow",
    "ImportDeclaration",
    "ExportDeclaration",
    "ImportSpecifier",
  ];
  virtualTypes$1.RestProperty = ["RestElement"];
  virtualTypes$1.SpreadProperty = ["RestElement"];
  virtualTypes$1.ExistentialTypeParam = ["ExistsTypeAnnotation"];
  virtualTypes$1.NumericLiteralTypeAnnotation = ["NumberLiteralTypeAnnotation"];
  virtualTypes$1.ForAwaitStatement = ["ForOfStatement"];
  return virtualTypes$1;
}
var virtualTypesValidator = {};
var hasRequiredVirtualTypesValidator;
function requireVirtualTypesValidator() {
  if (hasRequiredVirtualTypesValidator) return virtualTypesValidator;
  hasRequiredVirtualTypesValidator = 1;
  Object.defineProperty(virtualTypesValidator, "__esModule", { value: true });
  virtualTypesValidator.isBindingIdentifier = isBindingIdentifier;
  virtualTypesValidator.isBlockScoped = isBlockScoped;
  virtualTypesValidator.isExpression = isExpression;
  virtualTypesValidator.isFlow = isFlow;
  virtualTypesValidator.isForAwaitStatement = isForAwaitStatement;
  virtualTypesValidator.isGenerated = isGenerated;
  virtualTypesValidator.isPure = isPure;
  virtualTypesValidator.isReferenced = isReferenced;
  virtualTypesValidator.isReferencedIdentifier = isReferencedIdentifier;
  virtualTypesValidator.isReferencedMemberExpression =
    isReferencedMemberExpression;
  virtualTypesValidator.isRestProperty = isRestProperty;
  virtualTypesValidator.isScope = isScope;
  virtualTypesValidator.isSpreadProperty = isSpreadProperty;
  virtualTypesValidator.isStatement = isStatement;
  virtualTypesValidator.isUser = isUser;
  virtualTypesValidator.isVar = isVar;
  var _t = t$d;
  const {
    isBinding: isBinding,
    isBlockScoped: nodeIsBlockScoped,
    isExportDeclaration: isExportDeclaration,
    isExpression: nodeIsExpression,
    isFlow: nodeIsFlow,
    isForStatement: isForStatement,
    isForXStatement: isForXStatement,
    isIdentifier: isIdentifier,
    isImportDeclaration: isImportDeclaration,
    isImportSpecifier: isImportSpecifier,
    isJSXIdentifier: isJSXIdentifier,
    isJSXMemberExpression: isJSXMemberExpression,
    isMemberExpression: isMemberExpression,
    isRestElement: nodeIsRestElement,
    isReferenced: nodeIsReferenced,
    isScope: nodeIsScope,
    isStatement: nodeIsStatement,
    isVar: nodeIsVar,
    isVariableDeclaration: isVariableDeclaration,
    react: react,
    isForOfStatement: isForOfStatement,
  } = _t;
  const { isCompatTag: isCompatTag } = react;
  function isReferencedIdentifier(opts) {
    const { node: node, parent: parent } = this;
    if (!isIdentifier(node, opts) && !isJSXMemberExpression(parent, opts)) {
      if (isJSXIdentifier(node, opts)) {
        if (isCompatTag(node.name)) return false;
      } else {
        return false;
      }
    }
    return nodeIsReferenced(node, parent, this.parentPath.parent);
  }
  function isReferencedMemberExpression() {
    const { node: node, parent: parent } = this;
    return isMemberExpression(node) && nodeIsReferenced(node, parent);
  }
  function isBindingIdentifier() {
    const { node: node, parent: parent } = this;
    const grandparent = this.parentPath.parent;
    return isIdentifier(node) && isBinding(node, parent, grandparent);
  }
  function isStatement() {
    const { node: node, parent: parent } = this;
    if (nodeIsStatement(node)) {
      if (isVariableDeclaration(node)) {
        if (isForXStatement(parent, { left: node })) return false;
        if (isForStatement(parent, { init: node })) return false;
      }
      return true;
    } else {
      return false;
    }
  }
  function isExpression() {
    if (this.isIdentifier()) {
      return this.isReferencedIdentifier();
    } else {
      return nodeIsExpression(this.node);
    }
  }
  function isScope() {
    return nodeIsScope(this.node, this.parent);
  }
  function isReferenced() {
    return nodeIsReferenced(this.node, this.parent);
  }
  function isBlockScoped() {
    return nodeIsBlockScoped(this.node);
  }
  function isVar() {
    return nodeIsVar(this.node);
  }
  function isUser() {
    return this.node && !!this.node.loc;
  }
  function isGenerated() {
    return !this.isUser();
  }
  function isPure(constantsOnly) {
    return this.scope.isPure(this.node, constantsOnly);
  }
  function isFlow() {
    const { node: node } = this;
    if (nodeIsFlow(node)) {
      return true;
    } else if (isImportDeclaration(node)) {
      return node.importKind === "type" || node.importKind === "typeof";
    } else if (isExportDeclaration(node)) {
      return node.exportKind === "type";
    } else if (isImportSpecifier(node)) {
      return node.importKind === "type" || node.importKind === "typeof";
    } else {
      return false;
    }
  }
  function isRestProperty() {
    return (
      nodeIsRestElement(this.node) &&
      this.parentPath &&
      this.parentPath.isObjectPattern()
    );
  }
  function isSpreadProperty() {
    return (
      nodeIsRestElement(this.node) &&
      this.parentPath &&
      this.parentPath.isObjectExpression()
    );
  }
  function isForAwaitStatement() {
    return isForOfStatement(this.node, { await: true });
  }
  {
    virtualTypesValidator.isExistentialTypeParam =
      function isExistentialTypeParam() {
        throw new Error(
          "`path.isExistentialTypeParam` has been renamed to `path.isExistsTypeAnnotation()` in Babel 7.",
        );
      };
    virtualTypesValidator.isNumericLiteralTypeAnnotation =
      function isNumericLiteralTypeAnnotation() {
        throw new Error(
          "`path.isNumericLiteralTypeAnnotation()` has been renamed to `path.isNumberLiteralTypeAnnotation()` in Babel 7.",
        );
      };
  }
  return virtualTypesValidator;
}
var hasRequiredVisitors$1;
function requireVisitors$1() {
  if (hasRequiredVisitors$1) return visitors$1;
  hasRequiredVisitors$1 = 1;
  Object.defineProperty(visitors$1, "__esModule", { value: true });
  visitors$1.explode = explode;
  visitors$1.isExplodedVisitor = isExplodedVisitor;
  visitors$1.merge = merge;
  visitors$1.verify = verify;
  var virtualTypes = requireVirtualTypes$1();
  var virtualTypesValidators = requireVirtualTypesValidator();
  var _t = t$d;
  const {
    DEPRECATED_KEYS: DEPRECATED_KEYS,
    DEPRECATED_ALIASES: DEPRECATED_ALIASES,
    FLIPPED_ALIAS_KEYS: FLIPPED_ALIAS_KEYS,
    TYPES: TYPES,
    __internal__deprecationWarning: deprecationWarning,
  } = _t;
  function isVirtualType(type) {
    return type in virtualTypes;
  }
  function isExplodedVisitor(visitor) {
    return visitor == null ? void 0 : visitor._exploded;
  }
  function explode(visitor) {
    if (isExplodedVisitor(visitor)) return visitor;
    visitor._exploded = true;
    for (const nodeType of Object.keys(visitor)) {
      if (shouldIgnoreKey(nodeType)) continue;
      const parts = nodeType.split("|");
      if (parts.length === 1) continue;
      const fns = visitor[nodeType];
      delete visitor[nodeType];
      for (const part of parts) {
        visitor[part] = fns;
      }
    }
    verify(visitor);
    delete visitor.__esModule;
    ensureEntranceObjects(visitor);
    ensureCallbackArrays(visitor);
    for (const nodeType of Object.keys(visitor)) {
      if (shouldIgnoreKey(nodeType)) continue;
      if (!isVirtualType(nodeType)) continue;
      const fns = visitor[nodeType];
      for (const type of Object.keys(fns)) {
        fns[type] = wrapCheck(nodeType, fns[type]);
      }
      delete visitor[nodeType];
      const types = virtualTypes[nodeType];
      if (types !== null) {
        for (const type of types) {
          if (visitor[type]) {
            mergePair(visitor[type], fns);
          } else {
            visitor[type] = fns;
          }
        }
      } else {
        mergePair(visitor, fns);
      }
    }
    for (const nodeType of Object.keys(visitor)) {
      if (shouldIgnoreKey(nodeType)) continue;
      let aliases = FLIPPED_ALIAS_KEYS[nodeType];
      if (nodeType in DEPRECATED_KEYS) {
        const deprecatedKey = DEPRECATED_KEYS[nodeType];
        deprecationWarning(nodeType, deprecatedKey, "Visitor ");
        aliases = [deprecatedKey];
      } else if (nodeType in DEPRECATED_ALIASES) {
        const deprecatedAlias = DEPRECATED_ALIASES[nodeType];
        deprecationWarning(nodeType, deprecatedAlias, "Visitor ");
        aliases = FLIPPED_ALIAS_KEYS[deprecatedAlias];
      }
      if (!aliases) continue;
      const fns = visitor[nodeType];
      delete visitor[nodeType];
      for (const alias of aliases) {
        const existing = visitor[alias];
        if (existing) {
          mergePair(existing, fns);
        } else {
          visitor[alias] = Object.assign({}, fns);
        }
      }
    }
    for (const nodeType of Object.keys(visitor)) {
      if (shouldIgnoreKey(nodeType)) continue;
      ensureCallbackArrays(visitor[nodeType]);
    }
    return visitor;
  }
  function verify(visitor) {
    if (visitor._verified) return;
    if (typeof visitor === "function") {
      throw new Error(
        "You passed `traverse()` a function when it expected a visitor object, " +
          "are you sure you didn't mean `{ enter: Function }`?",
      );
    }
    for (const nodeType of Object.keys(visitor)) {
      if (nodeType === "enter" || nodeType === "exit") {
        validateVisitorMethods(nodeType, visitor[nodeType]);
      }
      if (shouldIgnoreKey(nodeType)) continue;
      if (TYPES.indexOf(nodeType) < 0) {
        throw new Error(
          `You gave us a visitor for the node type ${nodeType} but it's not a valid type`,
        );
      }
      const visitors = visitor[nodeType];
      if (typeof visitors === "object") {
        for (const visitorKey of Object.keys(visitors)) {
          if (visitorKey === "enter" || visitorKey === "exit") {
            validateVisitorMethods(
              `${nodeType}.${visitorKey}`,
              visitors[visitorKey],
            );
          } else {
            throw new Error(
              "You passed `traverse()` a visitor object with the property " +
                `${nodeType} that has the invalid property ${visitorKey}`,
            );
          }
        }
      }
    }
    visitor._verified = true;
  }
  function validateVisitorMethods(path, val) {
    const fns = [].concat(val);
    for (const fn of fns) {
      if (typeof fn !== "function") {
        throw new TypeError(
          `Non-function found defined in ${path} with type ${typeof fn}`,
        );
      }
    }
  }
  function merge(visitors, states = [], wrapper) {
    const mergedVisitor = {};
    for (let i = 0; i < visitors.length; i++) {
      const visitor = explode(visitors[i]);
      const state = states[i];
      let topVisitor = visitor;
      if (state || wrapper) {
        topVisitor = wrapWithStateOrWrapper(topVisitor, state, wrapper);
      }
      mergePair(mergedVisitor, topVisitor);
      for (const key of Object.keys(visitor)) {
        if (shouldIgnoreKey(key)) continue;
        let typeVisitor = visitor[key];
        if (state || wrapper) {
          typeVisitor = wrapWithStateOrWrapper(typeVisitor, state, wrapper);
        }
        const nodeVisitor = mergedVisitor[key] || (mergedVisitor[key] = {});
        mergePair(nodeVisitor, typeVisitor);
      }
    }
    return mergedVisitor;
  }
  function wrapWithStateOrWrapper(oldVisitor, state, wrapper) {
    const newVisitor = {};
    for (const phase of ["enter", "exit"]) {
      let fns = oldVisitor[phase];
      if (!Array.isArray(fns)) continue;
      fns = fns.map(function (fn) {
        let newFn = fn;
        if (state) {
          newFn = function (path) {
            fn.call(state, path, state);
          };
        }
        if (wrapper) {
          newFn = wrapper(state == null ? void 0 : state.key, phase, newFn);
        }
        if (newFn !== fn) {
          newFn.toString = () => fn.toString();
        }
        return newFn;
      });
      newVisitor[phase] = fns;
    }
    return newVisitor;
  }
  function ensureEntranceObjects(obj) {
    for (const key of Object.keys(obj)) {
      if (shouldIgnoreKey(key)) continue;
      const fns = obj[key];
      if (typeof fns === "function") {
        obj[key] = { enter: fns };
      }
    }
  }
  function ensureCallbackArrays(obj) {
    if (obj.enter && !Array.isArray(obj.enter)) obj.enter = [obj.enter];
    if (obj.exit && !Array.isArray(obj.exit)) obj.exit = [obj.exit];
  }
  function wrapCheck(nodeType, fn) {
    const fnKey = `is${nodeType}`;
    const validator = virtualTypesValidators[fnKey];
    const newFn = function (path) {
      if (validator.call(path)) {
        return fn.apply(this, arguments);
      }
    };
    newFn.toString = () => fn.toString();
    return newFn;
  }
  function shouldIgnoreKey(key) {
    if (key[0] === "_") return true;
    if (key === "enter" || key === "exit" || key === "shouldSkip") return true;
    if (key === "denylist" || key === "noScope" || key === "skipKeys") {
      return true;
    }
    {
      if (key === "blacklist") {
        return true;
      }
    }
    return false;
  }
  function mergePair(dest, src) {
    for (const phase of ["enter", "exit"]) {
      if (!src[phase]) continue;
      dest[phase] = [].concat(dest[phase] || [], src[phase]);
    }
  }
  return visitors$1;
}
var cache$1 = {};
var hasRequiredCache$1;
function requireCache$1() {
  if (hasRequiredCache$1) return cache$1;
  hasRequiredCache$1 = 1;
  Object.defineProperty(cache$1, "__esModule", { value: true });
  cache$1.clear = clear;
  cache$1.clearPath = clearPath;
  cache$1.clearScope = clearScope;
  cache$1.getCachedPaths = getCachedPaths;
  cache$1.getOrCreateCachedPaths = getOrCreateCachedPaths;
  cache$1.scope = cache$1.path = void 0;
  let pathsCache = (cache$1.path = new WeakMap());
  cache$1.scope = new WeakMap();
  function clear() {
    clearPath();
    clearScope();
  }
  function clearPath() {
    cache$1.path = pathsCache = new WeakMap();
  }
  function clearScope() {
    cache$1.scope = new WeakMap();
  }
  const nullHub = Object.freeze({});
  function getCachedPaths(hub, parent) {
    var _pathsCache$get, _hub;
    {
      hub = null;
    }
    return (_pathsCache$get = pathsCache.get(
      (_hub = hub) != null ? _hub : nullHub,
    )) == null
      ? void 0
      : _pathsCache$get.get(parent);
  }
  function getOrCreateCachedPaths(hub, parent) {
    var _hub2, _hub3;
    {
      hub = null;
    }
    let parents = pathsCache.get((_hub2 = hub) != null ? _hub2 : nullHub);
    if (!parents)
      pathsCache.set(
        (_hub3 = hub) != null ? _hub3 : nullHub,
        (parents = new WeakMap()),
      );
    let paths = parents.get(parent);
    if (!paths) parents.set(parent, (paths = new Map()));
    return paths;
  }
  return cache$1;
}
var traverseNode = {};
var context$3 = {};
var path$3 = {};
var src$1 = { exports: {} };
var browser$4 = { exports: {} };
var ms;
var hasRequiredMs;
function requireMs() {
  if (hasRequiredMs) return ms;
  hasRequiredMs = 1;
  var s = 1e3;
  var m = s * 60;
  var h = m * 60;
  var d = h * 24;
  var w = d * 7;
  var y = d * 365.25;
  ms = function (val, options) {
    options = options || {};
    var type = typeof val;
    if (type === "string" && val.length > 0) {
      return parse(val);
    } else if (type === "number" && isFinite(val)) {
      return options.long ? fmtLong(val) : fmtShort(val);
    }
    throw new Error(
      "val is not a non-empty string or a valid number. val=" +
        JSON.stringify(val),
    );
  };
  function parse(str) {
    str = String(str);
    if (str.length > 100) {
      return;
    }
    var match =
      /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str,
      );
    if (!match) {
      return;
    }
    var n = parseFloat(match[1]);
    var type = (match[2] || "ms").toLowerCase();
    switch (type) {
      case "years":
      case "year":
      case "yrs":
      case "yr":
      case "y":
        return n * y;
      case "weeks":
      case "week":
      case "w":
        return n * w;
      case "days":
      case "day":
      case "d":
        return n * d;
      case "hours":
      case "hour":
      case "hrs":
      case "hr":
      case "h":
        return n * h;
      case "minutes":
      case "minute":
      case "mins":
      case "min":
      case "m":
        return n * m;
      case "seconds":
      case "second":
      case "secs":
      case "sec":
      case "s":
        return n * s;
      case "milliseconds":
      case "millisecond":
      case "msecs":
      case "msec":
      case "ms":
        return n;
      default:
        return undefined;
    }
  }
  function fmtShort(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return Math.round(ms / d) + "d";
    }
    if (msAbs >= h) {
      return Math.round(ms / h) + "h";
    }
    if (msAbs >= m) {
      return Math.round(ms / m) + "m";
    }
    if (msAbs >= s) {
      return Math.round(ms / s) + "s";
    }
    return ms + "ms";
  }
  function fmtLong(ms) {
    var msAbs = Math.abs(ms);
    if (msAbs >= d) {
      return plural(ms, msAbs, d, "day");
    }
    if (msAbs >= h) {
      return plural(ms, msAbs, h, "hour");
    }
    if (msAbs >= m) {
      return plural(ms, msAbs, m, "minute");
    }
    if (msAbs >= s) {
      return plural(ms, msAbs, s, "second");
    }
    return ms + " ms";
  }
  function plural(ms, msAbs, n, name) {
    var isPlural = msAbs >= n * 1.5;
    return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
  }
  return ms;
}
var common;
var hasRequiredCommon;
function requireCommon() {
  if (hasRequiredCommon) return common;
  hasRequiredCommon = 1;
  function setup(env) {
    createDebug.debug = createDebug;
    createDebug.default = createDebug;
    createDebug.coerce = coerce;
    createDebug.disable = disable;
    createDebug.enable = enable;
    createDebug.enabled = enabled;
    createDebug.humanize = requireMs();
    createDebug.destroy = destroy;
    Object.keys(env).forEach((key) => {
      createDebug[key] = env[key];
    });
    createDebug.names = [];
    createDebug.skips = [];
    createDebug.formatters = {};
    function selectColor(namespace) {
      let hash = 0;
      for (let i = 0; i < namespace.length; i++) {
        hash = (hash << 5) - hash + namespace.charCodeAt(i);
        hash |= 0;
      }
      return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    }
    createDebug.selectColor = selectColor;
    function createDebug(namespace) {
      let prevTime;
      let enableOverride = null;
      let namespacesCache;
      let enabledCache;
      function debug(...args) {
        if (!debug.enabled) {
          return;
        }
        const self = debug;
        const curr = Number(new Date());
        const ms = curr - (prevTime || curr);
        self.diff = ms;
        self.prev = prevTime;
        self.curr = curr;
        prevTime = curr;
        args[0] = createDebug.coerce(args[0]);
        if (typeof args[0] !== "string") {
          args.unshift("%O");
        }
        let index = 0;
        args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
          if (match === "%%") {
            return "%";
          }
          index++;
          const formatter = createDebug.formatters[format];
          if (typeof formatter === "function") {
            const val = args[index];
            match = formatter.call(self, val);
            args.splice(index, 1);
            index--;
          }
          return match;
        });
        createDebug.formatArgs.call(self, args);
        const logFn = self.log || createDebug.log;
        logFn.apply(self, args);
      }
      debug.namespace = namespace;
      debug.useColors = createDebug.useColors();
      debug.color = createDebug.selectColor(namespace);
      debug.extend = extend;
      debug.destroy = createDebug.destroy;
      Object.defineProperty(debug, "enabled", {
        enumerable: true,
        configurable: false,
        get: () => {
          if (enableOverride !== null) {
            return enableOverride;
          }
          if (namespacesCache !== createDebug.namespaces) {
            namespacesCache = createDebug.namespaces;
            enabledCache = createDebug.enabled(namespace);
          }
          return enabledCache;
        },
        set: (v) => {
          enableOverride = v;
        },
      });
      if (typeof createDebug.init === "function") {
        createDebug.init(debug);
      }
      return debug;
    }
    function extend(namespace, delimiter) {
      const newDebug = createDebug(
        this.namespace +
          (typeof delimiter === "undefined" ? ":" : delimiter) +
          namespace,
      );
      newDebug.log = this.log;
      return newDebug;
    }
    function enable(namespaces) {
      createDebug.save(namespaces);
      createDebug.namespaces = namespaces;
      createDebug.names = [];
      createDebug.skips = [];
      let i;
      const split = (typeof namespaces === "string" ? namespaces : "").split(
        /[\s,]+/,
      );
      const len = split.length;
      for (i = 0; i < len; i++) {
        if (!split[i]) {
          continue;
        }
        namespaces = split[i].replace(/\*/g, ".*?");
        if (namespaces[0] === "-") {
          createDebug.skips.push(new RegExp("^" + namespaces.slice(1) + "$"));
        } else {
          createDebug.names.push(new RegExp("^" + namespaces + "$"));
        }
      }
    }
    function disable() {
      const namespaces = [
        ...createDebug.names.map(toNamespace),
        ...createDebug.skips
          .map(toNamespace)
          .map((namespace) => "-" + namespace),
      ].join(",");
      createDebug.enable("");
      return namespaces;
    }
    function enabled(name) {
      if (name[name.length - 1] === "*") {
        return true;
      }
      let i;
      let len;
      for (i = 0, len = createDebug.skips.length; i < len; i++) {
        if (createDebug.skips[i].test(name)) {
          return false;
        }
      }
      for (i = 0, len = createDebug.names.length; i < len; i++) {
        if (createDebug.names[i].test(name)) {
          return true;
        }
      }
      return false;
    }
    function toNamespace(regexp) {
      return regexp
        .toString()
        .substring(2, regexp.toString().length - 2)
        .replace(/\.\*\?$/, "*");
    }
    function coerce(val) {
      if (val instanceof Error) {
        return val.stack || val.message;
      }
      return val;
    }
    function destroy() {
      console.warn(
        "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.",
      );
    }
    createDebug.enable(createDebug.load());
    return createDebug;
  }
  common = setup;
  return common;
}
var hasRequiredBrowser$1;
function requireBrowser$1() {
  if (hasRequiredBrowser$1) return browser$4.exports;
  hasRequiredBrowser$1 = 1;
  (function (module, exports) {
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();
    exports.destroy = (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn(
            "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.",
          );
        }
      };
    })();
    exports.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33",
    ];
    function useColors() {
      if (
        typeof window !== "undefined" &&
        window.process &&
        (window.process.type === "renderer" || window.process.__nwjs)
      ) {
        return true;
      }
      if (
        typeof navigator !== "undefined" &&
        navigator.userAgent &&
        navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)
      ) {
        return false;
      }
      return (
        (typeof document !== "undefined" &&
          document.documentElement &&
          document.documentElement.style &&
          document.documentElement.style.WebkitAppearance) ||
        (typeof window !== "undefined" &&
          window.console &&
          (window.console.firebug ||
            (window.console.exception && window.console.table))) ||
        (typeof navigator !== "undefined" &&
          navigator.userAgent &&
          navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) &&
          parseInt(RegExp.$1, 10) >= 31) ||
        (typeof navigator !== "undefined" &&
          navigator.userAgent &&
          navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/))
      );
    }
    function formatArgs(args) {
      args[0] =
        (this.useColors ? "%c" : "") +
        this.namespace +
        (this.useColors ? " %c" : " ") +
        args[0] +
        (this.useColors ? "%c " : " ") +
        "+" +
        module.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    exports.log = console.debug || console.log || (() => {});
    function save(namespaces) {
      try {
        if (namespaces) {
          exports.storage.setItem("debug", namespaces);
        } else {
          exports.storage.removeItem("debug");
        }
      } catch (error) {}
    }
    function load() {
      let r;
      try {
        r = exports.storage.getItem("debug");
      } catch (error) {}
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {}
    }
    module.exports = requireCommon()(exports);
    const { formatters: formatters } = module.exports;
    formatters.j = function (v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  })(browser$4, browser$4.exports);
  return browser$4.exports;
}
var node$4 = { exports: {} };
var browser$3;
var hasRequiredBrowser;
function requireBrowser() {
  if (hasRequiredBrowser) return browser$3;
  hasRequiredBrowser = 1;
  function getChromeVersion() {
    const matches = /(Chrome|Chromium)\/(?<chromeVersion>\d+)\./.exec(
      navigator.userAgent,
    );
    if (!matches) {
      return;
    }
    return Number.parseInt(matches.groups.chromeVersion, 10);
  }
  const colorSupport =
    getChromeVersion() >= 69
      ? { level: 1, hasBasic: true, has256: false, has16m: false }
      : false;
  browser$3 = { stdout: colorSupport, stderr: colorSupport };
  return browser$3;
}
var hasRequiredNode$1;
function requireNode$1() {
  if (hasRequiredNode$1) return node$4.exports;
  hasRequiredNode$1 = 1;
  (function (module, exports) {
    const tty = require$$0$3;
    const util = require$$1$1;
    exports.init = init;
    exports.log = log;
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.destroy = util.deprecate(
      () => {},
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.",
    );
    exports.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = requireBrowser();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports.colors = [
          20, 21, 26, 27, 32, 33, 38, 39, 40, 41, 42, 43, 44, 45, 56, 57, 62,
          63, 68, 69, 74, 75, 76, 77, 78, 79, 80, 81, 92, 93, 98, 99, 112, 113,
          128, 129, 134, 135, 148, 149, 160, 161, 162, 163, 164, 165, 166, 167,
          168, 169, 170, 171, 172, 173, 178, 179, 184, 185, 196, 197, 198, 199,
          200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 214, 215, 220, 221,
        ];
      }
    } catch (error) {}
    exports.inspectOpts = Object.keys(process.env)
      .filter((key) => /^debug_/i.test(key))
      .reduce((obj, key) => {
        const prop = key
          .substring(6)
          .toLowerCase()
          .replace(/_([a-z])/g, (_, k) => k.toUpperCase());
        let val = process.env[key];
        if (/^(yes|on|true|enabled)$/i.test(val)) {
          val = true;
        } else if (/^(no|off|false|disabled)$/i.test(val)) {
          val = false;
        } else if (val === "null") {
          val = null;
        } else {
          val = Number(val);
        }
        obj[prop] = val;
        return obj;
      }, {});
    function useColors() {
      return "colors" in exports.inspectOpts
        ? Boolean(exports.inspectOpts.colors)
        : tty.isatty(process.stderr.fd);
    }
    function formatArgs(args) {
      const { namespace: name, useColors: useColors } = this;
      if (useColors) {
        const c = this.color;
        const colorCode = "[3" + (c < 8 ? c : "8;5;" + c);
        const prefix = `  ${colorCode};1m${name} [0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(
          colorCode + "m+" + module.exports.humanize(this.diff) + "[0m",
        );
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    function getDate() {
      if (exports.inspectOpts.hideDate) {
        return "";
      }
      return new Date().toISOString() + " ";
    }
    function log(...args) {
      return process.stderr.write(util.format(...args) + "\n");
    }
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    function load() {
      return process.env.DEBUG;
    }
    function init(debug) {
      debug.inspectOpts = {};
      const keys = Object.keys(exports.inspectOpts);
      for (let i = 0; i < keys.length; i++) {
        debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
      }
    }
    module.exports = requireCommon()(exports);
    const { formatters: formatters } = module.exports;
    formatters.o = function (v) {
      this.inspectOpts.colors = this.useColors;
      return util
        .inspect(v, this.inspectOpts)
        .split("\n")
        .map((str) => str.trim())
        .join(" ");
    };
    formatters.O = function (v) {
      this.inspectOpts.colors = this.useColors;
      return util.inspect(v, this.inspectOpts);
    };
  })(node$4, node$4.exports);
  return node$4.exports;
}
var hasRequiredSrc$1;
function requireSrc$1() {
  if (hasRequiredSrc$1) return src$1.exports;
  hasRequiredSrc$1 = 1;
  if (
    typeof process === "undefined" ||
    process.type === "renderer" ||
    process.browser === true ||
    process.__nwjs
  ) {
    src$1.exports = requireBrowser$1();
  } else {
    src$1.exports = requireNode$1();
  }
  return src$1.exports;
}
var scope$1 = {};
var renamer$1 = {};
var lib$q = {};
var hasRequiredLib$q;
function requireLib$q() {
  if (hasRequiredLib$q) return lib$q;
  hasRequiredLib$q = 1;
  Object.defineProperty(lib$q, "__esModule", { value: true });
  lib$q.default = splitExportDeclaration;
  var _t = t$d;
  const {
    cloneNode: cloneNode,
    exportNamedDeclaration: exportNamedDeclaration,
    exportSpecifier: exportSpecifier,
    identifier: identifier,
    variableDeclaration: variableDeclaration,
    variableDeclarator: variableDeclarator,
  } = _t;
  function splitExportDeclaration(exportDeclaration) {
    if (
      !exportDeclaration.isExportDeclaration() ||
      exportDeclaration.isExportAllDeclaration()
    ) {
      throw new Error(
        "Only default and named export declarations can be split.",
      );
    }
    if (exportDeclaration.isExportDefaultDeclaration()) {
      const declaration = exportDeclaration.get("declaration");
      const standaloneDeclaration =
        declaration.isFunctionDeclaration() || declaration.isClassDeclaration();
      const exportExpr =
        declaration.isFunctionExpression() || declaration.isClassExpression();
      const scope = declaration.isScope()
        ? declaration.scope.parent
        : declaration.scope;
      let id = declaration.node.id;
      let needBindingRegistration = false;
      if (!id) {
        needBindingRegistration = true;
        id = scope.generateUidIdentifier("default");
        if (standaloneDeclaration || exportExpr) {
          declaration.node.id = cloneNode(id);
        }
      } else if (exportExpr && scope.hasBinding(id.name)) {
        needBindingRegistration = true;
        id = scope.generateUidIdentifier(id.name);
      }
      const updatedDeclaration = standaloneDeclaration
        ? declaration.node
        : variableDeclaration("var", [
            variableDeclarator(cloneNode(id), declaration.node),
          ]);
      const updatedExportDeclaration = exportNamedDeclaration(null, [
        exportSpecifier(cloneNode(id), identifier("default")),
      ]);
      exportDeclaration.insertAfter(updatedExportDeclaration);
      exportDeclaration.replaceWith(updatedDeclaration);
      if (needBindingRegistration) {
        scope.registerDeclaration(exportDeclaration);
      }
      return exportDeclaration;
    } else if (exportDeclaration.get("specifiers").length > 0) {
      throw new Error("It doesn't make sense to split exported specifiers.");
    }
    const declaration = exportDeclaration.get("declaration");
    const bindingIdentifiers = declaration.getOuterBindingIdentifiers();
    const specifiers = Object.keys(bindingIdentifiers).map((name) =>
      exportSpecifier(identifier(name), identifier(name)),
    );
    const aliasDeclar = exportNamedDeclaration(null, specifiers);
    exportDeclaration.insertAfter(aliasDeclar);
    exportDeclaration.replaceWith(declaration.node);
    return exportDeclaration;
  }
  return lib$q;
}
var lib$p = {};
var hasRequiredLib$p;
function requireLib$p() {
  if (hasRequiredLib$p) return lib$p;
  hasRequiredLib$p = 1;
  Object.defineProperty(lib$p, "__esModule", { value: true });
  lib$p.default = void 0;
  lib$p.requeueComputedKeyAndDecorators = requeueComputedKeyAndDecorators;
  {
    lib$p.skipAllButComputedKey = function skipAllButComputedKey(path) {
      path.skip();
      if (path.node.computed) {
        path.context.maybeQueue(path.get("key"));
      }
    };
  }
  function requeueComputedKeyAndDecorators(path) {
    const { context: context, node: node } = path;
    if (node.computed) {
      context.maybeQueue(path.get("key"));
    }
    if (node.decorators) {
      for (const decorator of path.get("decorators")) {
        context.maybeQueue(decorator);
      }
    }
  }
  const visitor = {
    FunctionParent(path) {
      if (path.isArrowFunctionExpression()) {
        return;
      } else {
        path.skip();
        if (path.isMethod()) {
          requeueComputedKeyAndDecorators(path);
        }
      }
    },
    Property(path) {
      if (path.isObjectProperty()) {
        return;
      }
      path.skip();
      requeueComputedKeyAndDecorators(path);
    },
  };
  var _default = visitor;
  lib$p.default = _default;
  return lib$p;
}
var hasRequiredRenamer$1;
function requireRenamer$1() {
  if (hasRequiredRenamer$1) return renamer$1;
  hasRequiredRenamer$1 = 1;
  Object.defineProperty(renamer$1, "__esModule", { value: true });
  renamer$1.default = void 0;
  var _helperSplitExportDeclaration = requireLib$q();
  var t = t$d;
  var _helperEnvironmentVisitor = requireLib$p();
  var _traverseNode = requireTraverseNode();
  var _visitors = requireVisitors$1();
  const renameVisitor = {
    ReferencedIdentifier({ node: node }, state) {
      if (node.name === state.oldName) {
        node.name = state.newName;
      }
    },
    Scope(path, state) {
      if (
        !path.scope.bindingIdentifierEquals(
          state.oldName,
          state.binding.identifier,
        )
      ) {
        path.skip();
        if (path.isMethod()) {
          (0, _helperEnvironmentVisitor.requeueComputedKeyAndDecorators)(path);
        }
      }
    },
    ObjectProperty({ node: node, scope: scope }, state) {
      const { name: name } = node.key;
      if (
        node.shorthand &&
        (name === state.oldName || name === state.newName) &&
        scope.getBindingIdentifier(name) === state.binding.identifier
      ) {
        var _node$extra;
        node.shorthand = false;
        if ((_node$extra = node.extra) != null && _node$extra.shorthand)
          node.extra.shorthand = false;
      }
    },
    "AssignmentExpression|Declaration|VariableDeclarator"(path, state) {
      if (path.isVariableDeclaration()) return;
      const ids = path.getOuterBindingIdentifiers();
      for (const name in ids) {
        if (name === state.oldName) ids[name].name = state.newName;
      }
    },
  };
  class Renamer {
    constructor(binding, oldName, newName) {
      this.newName = newName;
      this.oldName = oldName;
      this.binding = binding;
    }
    maybeConvertFromExportDeclaration(parentDeclar) {
      const maybeExportDeclar = parentDeclar.parentPath;
      if (!maybeExportDeclar.isExportDeclaration()) {
        return;
      }
      if (maybeExportDeclar.isExportDefaultDeclaration()) {
        const { declaration: declaration } = maybeExportDeclar.node;
        if (t.isDeclaration(declaration) && !declaration.id) {
          return;
        }
      }
      if (maybeExportDeclar.isExportAllDeclaration()) {
        return;
      }
      (0, _helperSplitExportDeclaration.default)(maybeExportDeclar);
    }
    maybeConvertFromClassFunctionDeclaration(path) {
      return path;
    }
    maybeConvertFromClassFunctionExpression(path) {
      return path;
    }
    rename() {
      const { binding: binding, oldName: oldName, newName: newName } = this;
      const { scope: scope, path: path } = binding;
      const parentDeclar = path.find(
        (path) =>
          path.isDeclaration() ||
          path.isFunctionExpression() ||
          path.isClassExpression(),
      );
      if (parentDeclar) {
        const bindingIds = parentDeclar.getOuterBindingIdentifiers();
        if (bindingIds[oldName] === binding.identifier) {
          this.maybeConvertFromExportDeclaration(parentDeclar);
        }
      }
      const blockToTraverse = arguments[0] || scope.block;
      (0, _traverseNode.traverseNode)(
        blockToTraverse,
        (0, _visitors.explode)(renameVisitor),
        scope,
        this,
        scope.path,
        { discriminant: true },
      );
      if (!arguments[0]) {
        scope.removeOwnBinding(oldName);
        scope.bindings[newName] = binding;
        this.binding.identifier.name = newName;
      }
      if (parentDeclar) {
        this.maybeConvertFromClassFunctionDeclaration(path);
        this.maybeConvertFromClassFunctionExpression(path);
      }
    }
  }
  renamer$1.default = Renamer;
  return renamer$1;
}
var binding$1 = {};
var hasRequiredBinding$1;
function requireBinding$1() {
  if (hasRequiredBinding$1) return binding$1;
  hasRequiredBinding$1 = 1;
  Object.defineProperty(binding$1, "__esModule", { value: true });
  binding$1.default = void 0;
  class Binding {
    constructor({
      identifier: identifier,
      scope: scope,
      path: path,
      kind: kind,
    }) {
      this.identifier = void 0;
      this.scope = void 0;
      this.path = void 0;
      this.kind = void 0;
      this.constantViolations = [];
      this.constant = true;
      this.referencePaths = [];
      this.referenced = false;
      this.references = 0;
      this.identifier = identifier;
      this.scope = scope;
      this.path = path;
      this.kind = kind;
      if ((kind === "var" || kind === "hoisted") && isDeclaredInLoop(path)) {
        this.reassign(path);
      }
      this.clearValue();
    }
    deoptValue() {
      this.clearValue();
      this.hasDeoptedValue = true;
    }
    setValue(value) {
      if (this.hasDeoptedValue) return;
      this.hasValue = true;
      this.value = value;
    }
    clearValue() {
      this.hasDeoptedValue = false;
      this.hasValue = false;
      this.value = null;
    }
    reassign(path) {
      this.constant = false;
      if (this.constantViolations.indexOf(path) !== -1) {
        return;
      }
      this.constantViolations.push(path);
    }
    reference(path) {
      if (this.referencePaths.indexOf(path) !== -1) {
        return;
      }
      this.referenced = true;
      this.references++;
      this.referencePaths.push(path);
    }
    dereference() {
      this.references--;
      this.referenced = !!this.references;
    }
  }
  binding$1.default = Binding;
  function isDeclaredInLoop(path) {
    for (
      let { parentPath: parentPath, key: key } = path;
      parentPath;
      { parentPath: parentPath, key: key } = parentPath
    ) {
      if (parentPath.isFunctionParent()) return false;
      if (
        parentPath.isWhile() ||
        parentPath.isForXStatement() ||
        (parentPath.isForStatement() && key === "body")
      ) {
        return true;
      }
    }
    return false;
  }
  return binding$1;
}
var builtin$1 = {
  Array: false,
  ArrayBuffer: false,
  Atomics: false,
  BigInt: false,
  BigInt64Array: false,
  BigUint64Array: false,
  Boolean: false,
  constructor: false,
  DataView: false,
  Date: false,
  decodeURI: false,
  decodeURIComponent: false,
  encodeURI: false,
  encodeURIComponent: false,
  Error: false,
  escape: false,
  eval: false,
  EvalError: false,
  Float32Array: false,
  Float64Array: false,
  Function: false,
  globalThis: false,
  hasOwnProperty: false,
  Infinity: false,
  Int16Array: false,
  Int32Array: false,
  Int8Array: false,
  isFinite: false,
  isNaN: false,
  isPrototypeOf: false,
  JSON: false,
  Map: false,
  Math: false,
  NaN: false,
  Number: false,
  Object: false,
  parseFloat: false,
  parseInt: false,
  Promise: false,
  propertyIsEnumerable: false,
  Proxy: false,
  RangeError: false,
  ReferenceError: false,
  Reflect: false,
  RegExp: false,
  Set: false,
  SharedArrayBuffer: false,
  String: false,
  Symbol: false,
  SyntaxError: false,
  toLocaleString: false,
  toString: false,
  TypeError: false,
  Uint16Array: false,
  Uint32Array: false,
  Uint8Array: false,
  Uint8ClampedArray: false,
  undefined: false,
  unescape: false,
  URIError: false,
  valueOf: false,
  WeakMap: false,
  WeakSet: false,
};
var es5$1 = {
  Array: false,
  Boolean: false,
  constructor: false,
  Date: false,
  decodeURI: false,
  decodeURIComponent: false,
  encodeURI: false,
  encodeURIComponent: false,
  Error: false,
  escape: false,
  eval: false,
  EvalError: false,
  Function: false,
  hasOwnProperty: false,
  Infinity: false,
  isFinite: false,
  isNaN: false,
  isPrototypeOf: false,
  JSON: false,
  Math: false,
  NaN: false,
  Number: false,
  Object: false,
  parseFloat: false,
  parseInt: false,
  propertyIsEnumerable: false,
  RangeError: false,
  ReferenceError: false,
  RegExp: false,
  String: false,
  SyntaxError: false,
  toLocaleString: false,
  toString: false,
  TypeError: false,
  undefined: false,
  unescape: false,
  URIError: false,
  valueOf: false,
};
var es2015$1 = {
  Array: false,
  ArrayBuffer: false,
  Boolean: false,
  constructor: false,
  DataView: false,
  Date: false,
  decodeURI: false,
  decodeURIComponent: false,
  encodeURI: false,
  encodeURIComponent: false,
  Error: false,
  escape: false,
  eval: false,
  EvalError: false,
  Float32Array: false,
  Float64Array: false,
  Function: false,
  hasOwnProperty: false,
  Infinity: false,
  Int16Array: false,
  Int32Array: false,
  Int8Array: false,
  isFinite: false,
  isNaN: false,
  isPrototypeOf: false,
  JSON: false,
  Map: false,
  Math: false,
  NaN: false,
  Number: false,
  Object: false,
  parseFloat: false,
  parseInt: false,
  Promise: false,
  propertyIsEnumerable: false,
  Proxy: false,
  RangeError: false,
  ReferenceError: false,
  Reflect: false,
  RegExp: false,
  Set: false,
  String: false,
  Symbol: false,
  SyntaxError: false,
  toLocaleString: false,
  toString: false,
  TypeError: false,
  Uint16Array: false,
  Uint32Array: false,
  Uint8Array: false,
  Uint8ClampedArray: false,
  undefined: false,
  unescape: false,
  URIError: false,
  valueOf: false,
  WeakMap: false,
  WeakSet: false,
};
var es2017$1 = {
  Array: false,
  ArrayBuffer: false,
  Atomics: false,
  Boolean: false,
  constructor: false,
  DataView: false,
  Date: false,
  decodeURI: false,
  decodeURIComponent: false,
  encodeURI: false,
  encodeURIComponent: false,
  Error: false,
  escape: false,
  eval: false,
  EvalError: false,
  Float32Array: false,
  Float64Array: false,
  Function: false,
  hasOwnProperty: false,
  Infinity: false,
  Int16Array: false,
  Int32Array: false,
  Int8Array: false,
  isFinite: false,
  isNaN: false,
  isPrototypeOf: false,
  JSON: false,
  Map: false,
  Math: false,
  NaN: false,
  Number: false,
  Object: false,
  parseFloat: false,
  parseInt: false,
  Promise: false,
  propertyIsEnumerable: false,
  Proxy: false,
  RangeError: false,
  ReferenceError: false,
  Reflect: false,
  RegExp: false,
  Set: false,
  SharedArrayBuffer: false,
  String: false,
  Symbol: false,
  SyntaxError: false,
  toLocaleString: false,
  toString: false,
  TypeError: false,
  Uint16Array: false,
  Uint32Array: false,
  Uint8Array: false,
  Uint8ClampedArray: false,
  undefined: false,
  unescape: false,
  URIError: false,
  valueOf: false,
  WeakMap: false,
  WeakSet: false,
};
var browser$2 = {
  AbortController: false,
  AbortSignal: false,
  addEventListener: false,
  alert: false,
  AnalyserNode: false,
  Animation: false,
  AnimationEffectReadOnly: false,
  AnimationEffectTiming: false,
  AnimationEffectTimingReadOnly: false,
  AnimationEvent: false,
  AnimationPlaybackEvent: false,
  AnimationTimeline: false,
  applicationCache: false,
  ApplicationCache: false,
  ApplicationCacheErrorEvent: false,
  atob: false,
  Attr: false,
  Audio: false,
  AudioBuffer: false,
  AudioBufferSourceNode: false,
  AudioContext: false,
  AudioDestinationNode: false,
  AudioListener: false,
  AudioNode: false,
  AudioParam: false,
  AudioProcessingEvent: false,
  AudioScheduledSourceNode: false,
  "AudioWorkletGlobalScope ": false,
  AudioWorkletNode: false,
  AudioWorkletProcessor: false,
  BarProp: false,
  BaseAudioContext: false,
  BatteryManager: false,
  BeforeUnloadEvent: false,
  BiquadFilterNode: false,
  Blob: false,
  BlobEvent: false,
  blur: false,
  BroadcastChannel: false,
  btoa: false,
  BudgetService: false,
  ByteLengthQueuingStrategy: false,
  Cache: false,
  caches: false,
  CacheStorage: false,
  cancelAnimationFrame: false,
  cancelIdleCallback: false,
  CanvasCaptureMediaStreamTrack: false,
  CanvasGradient: false,
  CanvasPattern: false,
  CanvasRenderingContext2D: false,
  ChannelMergerNode: false,
  ChannelSplitterNode: false,
  CharacterData: false,
  clearInterval: false,
  clearTimeout: false,
  clientInformation: false,
  ClipboardEvent: false,
  close: false,
  closed: false,
  CloseEvent: false,
  Comment: false,
  CompositionEvent: false,
  confirm: false,
  console: false,
  ConstantSourceNode: false,
  ConvolverNode: false,
  CountQueuingStrategy: false,
  createImageBitmap: false,
  Credential: false,
  CredentialsContainer: false,
  crypto: false,
  Crypto: false,
  CryptoKey: false,
  CSS: false,
  CSSConditionRule: false,
  CSSFontFaceRule: false,
  CSSGroupingRule: false,
  CSSImportRule: false,
  CSSKeyframeRule: false,
  CSSKeyframesRule: false,
  CSSMediaRule: false,
  CSSNamespaceRule: false,
  CSSPageRule: false,
  CSSRule: false,
  CSSRuleList: false,
  CSSStyleDeclaration: false,
  CSSStyleRule: false,
  CSSStyleSheet: false,
  CSSSupportsRule: false,
  CustomElementRegistry: false,
  customElements: false,
  CustomEvent: false,
  DataTransfer: false,
  DataTransferItem: false,
  DataTransferItemList: false,
  defaultstatus: false,
  defaultStatus: false,
  DelayNode: false,
  DeviceMotionEvent: false,
  DeviceOrientationEvent: false,
  devicePixelRatio: false,
  dispatchEvent: false,
  document: false,
  Document: false,
  DocumentFragment: false,
  DocumentType: false,
  DOMError: false,
  DOMException: false,
  DOMImplementation: false,
  DOMMatrix: false,
  DOMMatrixReadOnly: false,
  DOMParser: false,
  DOMPoint: false,
  DOMPointReadOnly: false,
  DOMQuad: false,
  DOMRect: false,
  DOMRectReadOnly: false,
  DOMStringList: false,
  DOMStringMap: false,
  DOMTokenList: false,
  DragEvent: false,
  DynamicsCompressorNode: false,
  Element: false,
  ErrorEvent: false,
  event: false,
  Event: false,
  EventSource: false,
  EventTarget: false,
  external: false,
  fetch: false,
  File: false,
  FileList: false,
  FileReader: false,
  find: false,
  focus: false,
  FocusEvent: false,
  FontFace: false,
  FontFaceSetLoadEvent: false,
  FormData: false,
  frameElement: false,
  frames: false,
  GainNode: false,
  Gamepad: false,
  GamepadButton: false,
  GamepadEvent: false,
  getComputedStyle: false,
  getSelection: false,
  HashChangeEvent: false,
  Headers: false,
  history: false,
  History: false,
  HTMLAllCollection: false,
  HTMLAnchorElement: false,
  HTMLAreaElement: false,
  HTMLAudioElement: false,
  HTMLBaseElement: false,
  HTMLBodyElement: false,
  HTMLBRElement: false,
  HTMLButtonElement: false,
  HTMLCanvasElement: false,
  HTMLCollection: false,
  HTMLContentElement: false,
  HTMLDataElement: false,
  HTMLDataListElement: false,
  HTMLDetailsElement: false,
  HTMLDialogElement: false,
  HTMLDirectoryElement: false,
  HTMLDivElement: false,
  HTMLDListElement: false,
  HTMLDocument: false,
  HTMLElement: false,
  HTMLEmbedElement: false,
  HTMLFieldSetElement: false,
  HTMLFontElement: false,
  HTMLFormControlsCollection: false,
  HTMLFormElement: false,
  HTMLFrameElement: false,
  HTMLFrameSetElement: false,
  HTMLHeadElement: false,
  HTMLHeadingElement: false,
  HTMLHRElement: false,
  HTMLHtmlElement: false,
  HTMLIFrameElement: false,
  HTMLImageElement: false,
  HTMLInputElement: false,
  HTMLLabelElement: false,
  HTMLLegendElement: false,
  HTMLLIElement: false,
  HTMLLinkElement: false,
  HTMLMapElement: false,
  HTMLMarqueeElement: false,
  HTMLMediaElement: false,
  HTMLMenuElement: false,
  HTMLMetaElement: false,
  HTMLMeterElement: false,
  HTMLModElement: false,
  HTMLObjectElement: false,
  HTMLOListElement: false,
  HTMLOptGroupElement: false,
  HTMLOptionElement: false,
  HTMLOptionsCollection: false,
  HTMLOutputElement: false,
  HTMLParagraphElement: false,
  HTMLParamElement: false,
  HTMLPictureElement: false,
  HTMLPreElement: false,
  HTMLProgressElement: false,
  HTMLQuoteElement: false,
  HTMLScriptElement: false,
  HTMLSelectElement: false,
  HTMLShadowElement: false,
  HTMLSlotElement: false,
  HTMLSourceElement: false,
  HTMLSpanElement: false,
  HTMLStyleElement: false,
  HTMLTableCaptionElement: false,
  HTMLTableCellElement: false,
  HTMLTableColElement: false,
  HTMLTableElement: false,
  HTMLTableRowElement: false,
  HTMLTableSectionElement: false,
  HTMLTemplateElement: false,
  HTMLTextAreaElement: false,
  HTMLTimeElement: false,
  HTMLTitleElement: false,
  HTMLTrackElement: false,
  HTMLUListElement: false,
  HTMLUnknownElement: false,
  HTMLVideoElement: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  IdleDeadline: false,
  IIRFilterNode: false,
  Image: false,
  ImageBitmap: false,
  ImageBitmapRenderingContext: false,
  ImageCapture: false,
  ImageData: false,
  indexedDB: false,
  innerHeight: false,
  innerWidth: false,
  InputEvent: false,
  IntersectionObserver: false,
  IntersectionObserverEntry: false,
  Intl: false,
  isSecureContext: false,
  KeyboardEvent: false,
  KeyframeEffect: false,
  KeyframeEffectReadOnly: false,
  length: false,
  localStorage: false,
  location: true,
  Location: false,
  locationbar: false,
  matchMedia: false,
  MediaDeviceInfo: false,
  MediaDevices: false,
  MediaElementAudioSourceNode: false,
  MediaEncryptedEvent: false,
  MediaError: false,
  MediaKeyMessageEvent: false,
  MediaKeySession: false,
  MediaKeyStatusMap: false,
  MediaKeySystemAccess: false,
  MediaList: false,
  MediaQueryList: false,
  MediaQueryListEvent: false,
  MediaRecorder: false,
  MediaSettingsRange: false,
  MediaSource: false,
  MediaStream: false,
  MediaStreamAudioDestinationNode: false,
  MediaStreamAudioSourceNode: false,
  MediaStreamEvent: false,
  MediaStreamTrack: false,
  MediaStreamTrackEvent: false,
  menubar: false,
  MessageChannel: false,
  MessageEvent: false,
  MessagePort: false,
  MIDIAccess: false,
  MIDIConnectionEvent: false,
  MIDIInput: false,
  MIDIInputMap: false,
  MIDIMessageEvent: false,
  MIDIOutput: false,
  MIDIOutputMap: false,
  MIDIPort: false,
  MimeType: false,
  MimeTypeArray: false,
  MouseEvent: false,
  moveBy: false,
  moveTo: false,
  MutationEvent: false,
  MutationObserver: false,
  MutationRecord: false,
  name: false,
  NamedNodeMap: false,
  NavigationPreloadManager: false,
  navigator: false,
  Navigator: false,
  NetworkInformation: false,
  Node: false,
  NodeFilter: false,
  NodeIterator: false,
  NodeList: false,
  Notification: false,
  OfflineAudioCompletionEvent: false,
  OfflineAudioContext: false,
  offscreenBuffering: false,
  OffscreenCanvas: true,
  onabort: true,
  onafterprint: true,
  onanimationend: true,
  onanimationiteration: true,
  onanimationstart: true,
  onappinstalled: true,
  onauxclick: true,
  onbeforeinstallprompt: true,
  onbeforeprint: true,
  onbeforeunload: true,
  onblur: true,
  oncancel: true,
  oncanplay: true,
  oncanplaythrough: true,
  onchange: true,
  onclick: true,
  onclose: true,
  oncontextmenu: true,
  oncuechange: true,
  ondblclick: true,
  ondevicemotion: true,
  ondeviceorientation: true,
  ondeviceorientationabsolute: true,
  ondrag: true,
  ondragend: true,
  ondragenter: true,
  ondragleave: true,
  ondragover: true,
  ondragstart: true,
  ondrop: true,
  ondurationchange: true,
  onemptied: true,
  onended: true,
  onerror: true,
  onfocus: true,
  ongotpointercapture: true,
  onhashchange: true,
  oninput: true,
  oninvalid: true,
  onkeydown: true,
  onkeypress: true,
  onkeyup: true,
  onlanguagechange: true,
  onload: true,
  onloadeddata: true,
  onloadedmetadata: true,
  onloadstart: true,
  onlostpointercapture: true,
  onmessage: true,
  onmessageerror: true,
  onmousedown: true,
  onmouseenter: true,
  onmouseleave: true,
  onmousemove: true,
  onmouseout: true,
  onmouseover: true,
  onmouseup: true,
  onmousewheel: true,
  onoffline: true,
  ononline: true,
  onpagehide: true,
  onpageshow: true,
  onpause: true,
  onplay: true,
  onplaying: true,
  onpointercancel: true,
  onpointerdown: true,
  onpointerenter: true,
  onpointerleave: true,
  onpointermove: true,
  onpointerout: true,
  onpointerover: true,
  onpointerup: true,
  onpopstate: true,
  onprogress: true,
  onratechange: true,
  onrejectionhandled: true,
  onreset: true,
  onresize: true,
  onscroll: true,
  onsearch: true,
  onseeked: true,
  onseeking: true,
  onselect: true,
  onstalled: true,
  onstorage: true,
  onsubmit: true,
  onsuspend: true,
  ontimeupdate: true,
  ontoggle: true,
  ontransitionend: true,
  onunhandledrejection: true,
  onunload: true,
  onvolumechange: true,
  onwaiting: true,
  onwheel: true,
  open: false,
  openDatabase: false,
  opener: false,
  Option: false,
  origin: false,
  OscillatorNode: false,
  outerHeight: false,
  outerWidth: false,
  PageTransitionEvent: false,
  pageXOffset: false,
  pageYOffset: false,
  PannerNode: false,
  parent: false,
  Path2D: false,
  PaymentAddress: false,
  PaymentRequest: false,
  PaymentRequestUpdateEvent: false,
  PaymentResponse: false,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceLongTaskTiming: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceNavigationTiming: false,
  PerformanceObserver: false,
  PerformanceObserverEntryList: false,
  PerformancePaintTiming: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  PeriodicWave: false,
  Permissions: false,
  PermissionStatus: false,
  personalbar: false,
  PhotoCapabilities: false,
  Plugin: false,
  PluginArray: false,
  PointerEvent: false,
  PopStateEvent: false,
  postMessage: false,
  Presentation: false,
  PresentationAvailability: false,
  PresentationConnection: false,
  PresentationConnectionAvailableEvent: false,
  PresentationConnectionCloseEvent: false,
  PresentationConnectionList: false,
  PresentationReceiver: false,
  PresentationRequest: false,
  print: false,
  ProcessingInstruction: false,
  ProgressEvent: false,
  PromiseRejectionEvent: false,
  prompt: false,
  PushManager: false,
  PushSubscription: false,
  PushSubscriptionOptions: false,
  queueMicrotask: false,
  RadioNodeList: false,
  Range: false,
  ReadableStream: false,
  registerProcessor: false,
  RemotePlayback: false,
  removeEventListener: false,
  Request: false,
  requestAnimationFrame: false,
  requestIdleCallback: false,
  resizeBy: false,
  ResizeObserver: false,
  ResizeObserverEntry: false,
  resizeTo: false,
  Response: false,
  RTCCertificate: false,
  RTCDataChannel: false,
  RTCDataChannelEvent: false,
  RTCDtlsTransport: false,
  RTCIceCandidate: false,
  RTCIceGatherer: false,
  RTCIceTransport: false,
  RTCPeerConnection: false,
  RTCPeerConnectionIceEvent: false,
  RTCRtpContributingSource: false,
  RTCRtpReceiver: false,
  RTCRtpSender: false,
  RTCSctpTransport: false,
  RTCSessionDescription: false,
  RTCStatsReport: false,
  RTCTrackEvent: false,
  screen: false,
  Screen: false,
  screenLeft: false,
  ScreenOrientation: false,
  screenTop: false,
  screenX: false,
  screenY: false,
  ScriptProcessorNode: false,
  scroll: false,
  scrollbars: false,
  scrollBy: false,
  scrollTo: false,
  scrollX: false,
  scrollY: false,
  SecurityPolicyViolationEvent: false,
  Selection: false,
  self: false,
  ServiceWorker: false,
  ServiceWorkerContainer: false,
  ServiceWorkerRegistration: false,
  sessionStorage: false,
  setInterval: false,
  setTimeout: false,
  ShadowRoot: false,
  SharedWorker: false,
  SourceBuffer: false,
  SourceBufferList: false,
  speechSynthesis: false,
  SpeechSynthesisEvent: false,
  SpeechSynthesisUtterance: false,
  StaticRange: false,
  status: false,
  statusbar: false,
  StereoPannerNode: false,
  stop: false,
  Storage: false,
  StorageEvent: false,
  StorageManager: false,
  styleMedia: false,
  StyleSheet: false,
  StyleSheetList: false,
  SubtleCrypto: false,
  SVGAElement: false,
  SVGAngle: false,
  SVGAnimatedAngle: false,
  SVGAnimatedBoolean: false,
  SVGAnimatedEnumeration: false,
  SVGAnimatedInteger: false,
  SVGAnimatedLength: false,
  SVGAnimatedLengthList: false,
  SVGAnimatedNumber: false,
  SVGAnimatedNumberList: false,
  SVGAnimatedPreserveAspectRatio: false,
  SVGAnimatedRect: false,
  SVGAnimatedString: false,
  SVGAnimatedTransformList: false,
  SVGAnimateElement: false,
  SVGAnimateMotionElement: false,
  SVGAnimateTransformElement: false,
  SVGAnimationElement: false,
  SVGCircleElement: false,
  SVGClipPathElement: false,
  SVGComponentTransferFunctionElement: false,
  SVGDefsElement: false,
  SVGDescElement: false,
  SVGDiscardElement: false,
  SVGElement: false,
  SVGEllipseElement: false,
  SVGFEBlendElement: false,
  SVGFEColorMatrixElement: false,
  SVGFEComponentTransferElement: false,
  SVGFECompositeElement: false,
  SVGFEConvolveMatrixElement: false,
  SVGFEDiffuseLightingElement: false,
  SVGFEDisplacementMapElement: false,
  SVGFEDistantLightElement: false,
  SVGFEDropShadowElement: false,
  SVGFEFloodElement: false,
  SVGFEFuncAElement: false,
  SVGFEFuncBElement: false,
  SVGFEFuncGElement: false,
  SVGFEFuncRElement: false,
  SVGFEGaussianBlurElement: false,
  SVGFEImageElement: false,
  SVGFEMergeElement: false,
  SVGFEMergeNodeElement: false,
  SVGFEMorphologyElement: false,
  SVGFEOffsetElement: false,
  SVGFEPointLightElement: false,
  SVGFESpecularLightingElement: false,
  SVGFESpotLightElement: false,
  SVGFETileElement: false,
  SVGFETurbulenceElement: false,
  SVGFilterElement: false,
  SVGForeignObjectElement: false,
  SVGGElement: false,
  SVGGeometryElement: false,
  SVGGradientElement: false,
  SVGGraphicsElement: false,
  SVGImageElement: false,
  SVGLength: false,
  SVGLengthList: false,
  SVGLinearGradientElement: false,
  SVGLineElement: false,
  SVGMarkerElement: false,
  SVGMaskElement: false,
  SVGMatrix: false,
  SVGMetadataElement: false,
  SVGMPathElement: false,
  SVGNumber: false,
  SVGNumberList: false,
  SVGPathElement: false,
  SVGPatternElement: false,
  SVGPoint: false,
  SVGPointList: false,
  SVGPolygonElement: false,
  SVGPolylineElement: false,
  SVGPreserveAspectRatio: false,
  SVGRadialGradientElement: false,
  SVGRect: false,
  SVGRectElement: false,
  SVGScriptElement: false,
  SVGSetElement: false,
  SVGStopElement: false,
  SVGStringList: false,
  SVGStyleElement: false,
  SVGSVGElement: false,
  SVGSwitchElement: false,
  SVGSymbolElement: false,
  SVGTextContentElement: false,
  SVGTextElement: false,
  SVGTextPathElement: false,
  SVGTextPositioningElement: false,
  SVGTitleElement: false,
  SVGTransform: false,
  SVGTransformList: false,
  SVGTSpanElement: false,
  SVGUnitTypes: false,
  SVGUseElement: false,
  SVGViewElement: false,
  TaskAttributionTiming: false,
  Text: false,
  TextDecoder: false,
  TextEncoder: false,
  TextEvent: false,
  TextMetrics: false,
  TextTrack: false,
  TextTrackCue: false,
  TextTrackCueList: false,
  TextTrackList: false,
  TimeRanges: false,
  toolbar: false,
  top: false,
  Touch: false,
  TouchEvent: false,
  TouchList: false,
  TrackEvent: false,
  TransitionEvent: false,
  TreeWalker: false,
  UIEvent: false,
  URL: false,
  URLSearchParams: false,
  ValidityState: false,
  visualViewport: false,
  VisualViewport: false,
  VTTCue: false,
  WaveShaperNode: false,
  WebAssembly: false,
  WebGL2RenderingContext: false,
  WebGLActiveInfo: false,
  WebGLBuffer: false,
  WebGLContextEvent: false,
  WebGLFramebuffer: false,
  WebGLProgram: false,
  WebGLQuery: false,
  WebGLRenderbuffer: false,
  WebGLRenderingContext: false,
  WebGLSampler: false,
  WebGLShader: false,
  WebGLShaderPrecisionFormat: false,
  WebGLSync: false,
  WebGLTexture: false,
  WebGLTransformFeedback: false,
  WebGLUniformLocation: false,
  WebGLVertexArrayObject: false,
  WebSocket: false,
  WheelEvent: false,
  window: false,
  Window: false,
  Worker: false,
  WritableStream: false,
  XMLDocument: false,
  XMLHttpRequest: false,
  XMLHttpRequestEventTarget: false,
  XMLHttpRequestUpload: false,
  XMLSerializer: false,
  XPathEvaluator: false,
  XPathExpression: false,
  XPathResult: false,
  XSLTProcessor: false,
};
var worker$1 = {
  addEventListener: false,
  applicationCache: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  Cache: false,
  caches: false,
  clearInterval: false,
  clearTimeout: false,
  close: true,
  console: false,
  fetch: false,
  FileReaderSync: false,
  FormData: false,
  Headers: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  ImageData: false,
  importScripts: true,
  indexedDB: false,
  location: false,
  MessageChannel: false,
  MessagePort: false,
  name: false,
  navigator: false,
  Notification: false,
  onclose: true,
  onconnect: true,
  onerror: true,
  onlanguagechange: true,
  onmessage: true,
  onoffline: true,
  ononline: true,
  onrejectionhandled: true,
  onunhandledrejection: true,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  postMessage: true,
  Promise: false,
  queueMicrotask: false,
  removeEventListener: false,
  Request: false,
  Response: false,
  self: true,
  ServiceWorkerRegistration: false,
  setInterval: false,
  setTimeout: false,
  TextDecoder: false,
  TextEncoder: false,
  URL: false,
  URLSearchParams: false,
  WebSocket: false,
  Worker: false,
  WorkerGlobalScope: false,
  XMLHttpRequest: false,
};
var node$3 = {
  __dirname: false,
  __filename: false,
  Buffer: false,
  clearImmediate: false,
  clearInterval: false,
  clearTimeout: false,
  console: false,
  exports: true,
  global: false,
  Intl: false,
  module: false,
  process: false,
  queueMicrotask: false,
  require: false,
  setImmediate: false,
  setInterval: false,
  setTimeout: false,
  TextDecoder: false,
  TextEncoder: false,
  URL: false,
  URLSearchParams: false,
};
var commonjs$1 = {
  exports: true,
  global: false,
  module: false,
  require: false,
};
var amd$1 = { define: false, require: false };
var mocha$1 = {
  after: false,
  afterEach: false,
  before: false,
  beforeEach: false,
  context: false,
  describe: false,
  it: false,
  mocha: false,
  run: false,
  setup: false,
  specify: false,
  suite: false,
  suiteSetup: false,
  suiteTeardown: false,
  teardown: false,
  test: false,
  xcontext: false,
  xdescribe: false,
  xit: false,
  xspecify: false,
};
var jasmine$1 = {
  afterAll: false,
  afterEach: false,
  beforeAll: false,
  beforeEach: false,
  describe: false,
  expect: false,
  fail: false,
  fdescribe: false,
  fit: false,
  it: false,
  jasmine: false,
  pending: false,
  runs: false,
  spyOn: false,
  spyOnProperty: false,
  waits: false,
  waitsFor: false,
  xdescribe: false,
  xit: false,
};
var jest$1 = {
  afterAll: false,
  afterEach: false,
  beforeAll: false,
  beforeEach: false,
  describe: false,
  expect: false,
  fdescribe: false,
  fit: false,
  it: false,
  jest: false,
  pit: false,
  require: false,
  test: false,
  xdescribe: false,
  xit: false,
  xtest: false,
};
var qunit$1 = {
  asyncTest: false,
  deepEqual: false,
  equal: false,
  expect: false,
  module: false,
  notDeepEqual: false,
  notEqual: false,
  notOk: false,
  notPropEqual: false,
  notStrictEqual: false,
  ok: false,
  propEqual: false,
  QUnit: false,
  raises: false,
  start: false,
  stop: false,
  strictEqual: false,
  test: false,
  throws: false,
};
var phantomjs$1 = {
  console: true,
  exports: true,
  phantom: true,
  require: true,
  WebPage: true,
};
var couch$1 = {
  emit: false,
  exports: false,
  getRow: false,
  log: false,
  module: false,
  provides: false,
  require: false,
  respond: false,
  send: false,
  start: false,
  sum: false,
};
var rhino$1 = {
  defineClass: false,
  deserialize: false,
  gc: false,
  help: false,
  importClass: false,
  importPackage: false,
  java: false,
  load: false,
  loadClass: false,
  Packages: false,
  print: false,
  quit: false,
  readFile: false,
  readUrl: false,
  runCommand: false,
  seal: false,
  serialize: false,
  spawn: false,
  sync: false,
  toint32: false,
  version: false,
};
var nashorn$1 = {
  __DIR__: false,
  __FILE__: false,
  __LINE__: false,
  com: false,
  edu: false,
  exit: false,
  java: false,
  Java: false,
  javafx: false,
  JavaImporter: false,
  javax: false,
  JSAdapter: false,
  load: false,
  loadWithNewGlobal: false,
  org: false,
  Packages: false,
  print: false,
  quit: false,
};
var wsh$1 = {
  ActiveXObject: true,
  Enumerator: true,
  GetObject: true,
  ScriptEngine: true,
  ScriptEngineBuildVersion: true,
  ScriptEngineMajorVersion: true,
  ScriptEngineMinorVersion: true,
  VBArray: true,
  WScript: true,
  WSH: true,
  XDomainRequest: true,
};
var jquery$1 = { $: false, jQuery: false };
var yui$1 = {
  YAHOO: false,
  YAHOO_config: false,
  YUI: false,
  YUI_config: false,
};
var shelljs$1 = {
  cat: false,
  cd: false,
  chmod: false,
  config: false,
  cp: false,
  dirs: false,
  echo: false,
  env: false,
  error: false,
  exec: false,
  exit: false,
  find: false,
  grep: false,
  ln: false,
  ls: false,
  mkdir: false,
  mv: false,
  popd: false,
  pushd: false,
  pwd: false,
  rm: false,
  sed: false,
  set: false,
  target: false,
  tempdir: false,
  test: false,
  touch: false,
  which: false,
};
var prototypejs$1 = {
  $: false,
  $$: false,
  $A: false,
  $break: false,
  $continue: false,
  $F: false,
  $H: false,
  $R: false,
  $w: false,
  Abstract: false,
  Ajax: false,
  Autocompleter: false,
  Builder: false,
  Class: false,
  Control: false,
  Draggable: false,
  Draggables: false,
  Droppables: false,
  Effect: false,
  Element: false,
  Enumerable: false,
  Event: false,
  Field: false,
  Form: false,
  Hash: false,
  Insertion: false,
  ObjectRange: false,
  PeriodicalExecuter: false,
  Position: false,
  Prototype: false,
  Scriptaculous: false,
  Selector: false,
  Sortable: false,
  SortableObserver: false,
  Sound: false,
  Template: false,
  Toggle: false,
  Try: false,
};
var meteor$1 = {
  _: false,
  $: false,
  Accounts: false,
  AccountsClient: false,
  AccountsCommon: false,
  AccountsServer: false,
  App: false,
  Assets: false,
  Blaze: false,
  check: false,
  Cordova: false,
  DDP: false,
  DDPRateLimiter: false,
  DDPServer: false,
  Deps: false,
  EJSON: false,
  Email: false,
  HTTP: false,
  Log: false,
  Match: false,
  Meteor: false,
  Mongo: false,
  MongoInternals: false,
  Npm: false,
  Package: false,
  Plugin: false,
  process: false,
  Random: false,
  ReactiveDict: false,
  ReactiveVar: false,
  Router: false,
  ServiceConfiguration: false,
  Session: false,
  share: false,
  Spacebars: false,
  Template: false,
  Tinytest: false,
  Tracker: false,
  UI: false,
  Utils: false,
  WebApp: false,
  WebAppInternals: false,
};
var mongo$1 = {
  _isWindows: false,
  _rand: false,
  BulkWriteResult: false,
  cat: false,
  cd: false,
  connect: false,
  db: false,
  getHostName: false,
  getMemInfo: false,
  hostname: false,
  ISODate: false,
  listFiles: false,
  load: false,
  ls: false,
  md5sumFile: false,
  mkdir: false,
  Mongo: false,
  NumberInt: false,
  NumberLong: false,
  ObjectId: false,
  PlanCache: false,
  print: false,
  printjson: false,
  pwd: false,
  quit: false,
  removeFile: false,
  rs: false,
  sh: false,
  UUID: false,
  version: false,
  WriteResult: false,
};
var applescript$1 = {
  $: false,
  Application: false,
  Automation: false,
  console: false,
  delay: false,
  Library: false,
  ObjC: false,
  ObjectSpecifier: false,
  Path: false,
  Progress: false,
  Ref: false,
};
var serviceworker$1 = {
  addEventListener: false,
  applicationCache: false,
  atob: false,
  Blob: false,
  BroadcastChannel: false,
  btoa: false,
  Cache: false,
  caches: false,
  CacheStorage: false,
  clearInterval: false,
  clearTimeout: false,
  Client: false,
  clients: false,
  Clients: false,
  close: true,
  console: false,
  ExtendableEvent: false,
  ExtendableMessageEvent: false,
  fetch: false,
  FetchEvent: false,
  FileReaderSync: false,
  FormData: false,
  Headers: false,
  IDBCursor: false,
  IDBCursorWithValue: false,
  IDBDatabase: false,
  IDBFactory: false,
  IDBIndex: false,
  IDBKeyRange: false,
  IDBObjectStore: false,
  IDBOpenDBRequest: false,
  IDBRequest: false,
  IDBTransaction: false,
  IDBVersionChangeEvent: false,
  ImageData: false,
  importScripts: false,
  indexedDB: false,
  location: false,
  MessageChannel: false,
  MessagePort: false,
  name: false,
  navigator: false,
  Notification: false,
  onclose: true,
  onconnect: true,
  onerror: true,
  onfetch: true,
  oninstall: true,
  onlanguagechange: true,
  onmessage: true,
  onmessageerror: true,
  onnotificationclick: true,
  onnotificationclose: true,
  onoffline: true,
  ononline: true,
  onpush: true,
  onpushsubscriptionchange: true,
  onrejectionhandled: true,
  onsync: true,
  onunhandledrejection: true,
  performance: false,
  Performance: false,
  PerformanceEntry: false,
  PerformanceMark: false,
  PerformanceMeasure: false,
  PerformanceNavigation: false,
  PerformanceResourceTiming: false,
  PerformanceTiming: false,
  postMessage: true,
  Promise: false,
  queueMicrotask: false,
  registration: false,
  removeEventListener: false,
  Request: false,
  Response: false,
  self: false,
  ServiceWorker: false,
  ServiceWorkerContainer: false,
  ServiceWorkerGlobalScope: false,
  ServiceWorkerMessageEvent: false,
  ServiceWorkerRegistration: false,
  setInterval: false,
  setTimeout: false,
  skipWaiting: false,
  TextDecoder: false,
  TextEncoder: false,
  URL: false,
  URLSearchParams: false,
  WebSocket: false,
  WindowClient: false,
  Worker: false,
  WorkerGlobalScope: false,
  XMLHttpRequest: false,
};
var atomtest$1 = {
  advanceClock: false,
  fakeClearInterval: false,
  fakeClearTimeout: false,
  fakeSetInterval: false,
  fakeSetTimeout: false,
  resetTimeouts: false,
  waitsForPromise: false,
};
var embertest$1 = {
  andThen: false,
  click: false,
  currentPath: false,
  currentRouteName: false,
  currentURL: false,
  fillIn: false,
  find: false,
  findAll: false,
  findWithAssert: false,
  keyEvent: false,
  pauseTest: false,
  resumeTest: false,
  triggerEvent: false,
  visit: false,
  wait: false,
};
var protractor$1 = {
  $: false,
  $$: false,
  browser: false,
  by: false,
  By: false,
  DartObject: false,
  element: false,
  protractor: false,
};
var webextensions$1 = { browser: false, chrome: false, opr: false };
var greasemonkey$1 = {
  cloneInto: false,
  createObjectIn: false,
  exportFunction: false,
  GM: false,
  GM_addStyle: false,
  GM_deleteValue: false,
  GM_getResourceText: false,
  GM_getResourceURL: false,
  GM_getValue: false,
  GM_info: false,
  GM_listValues: false,
  GM_log: false,
  GM_openInTab: false,
  GM_registerMenuCommand: false,
  GM_setClipboard: false,
  GM_setValue: false,
  GM_xmlhttpRequest: false,
  unsafeWindow: false,
};
var devtools$1 = {
  $: false,
  $_: false,
  $$: false,
  $0: false,
  $1: false,
  $2: false,
  $3: false,
  $4: false,
  $x: false,
  chrome: false,
  clear: false,
  copy: false,
  debug: false,
  dir: false,
  dirxml: false,
  getEventListeners: false,
  inspect: false,
  keys: false,
  monitor: false,
  monitorEvents: false,
  profile: false,
  profileEnd: false,
  queryObjects: false,
  table: false,
  undebug: false,
  unmonitor: false,
  unmonitorEvents: false,
  values: false,
};
var require$$0$2 = {
  builtin: builtin$1,
  es5: es5$1,
  es2015: es2015$1,
  es2017: es2017$1,
  browser: browser$2,
  worker: worker$1,
  node: node$3,
  commonjs: commonjs$1,
  amd: amd$1,
  mocha: mocha$1,
  jasmine: jasmine$1,
  jest: jest$1,
  qunit: qunit$1,
  phantomjs: phantomjs$1,
  couch: couch$1,
  rhino: rhino$1,
  nashorn: nashorn$1,
  wsh: wsh$1,
  jquery: jquery$1,
  yui: yui$1,
  shelljs: shelljs$1,
  prototypejs: prototypejs$1,
  meteor: meteor$1,
  mongo: mongo$1,
  applescript: applescript$1,
  serviceworker: serviceworker$1,
  atomtest: atomtest$1,
  embertest: embertest$1,
  protractor: protractor$1,
  "shared-node-browser": {
    clearInterval: false,
    clearTimeout: false,
    console: false,
    setInterval: false,
    setTimeout: false,
    URL: false,
    URLSearchParams: false,
  },
  webextensions: webextensions$1,
  greasemonkey: greasemonkey$1,
  devtools: devtools$1,
};
var globals$1;
var hasRequiredGlobals$1;
function requireGlobals$1() {
  if (hasRequiredGlobals$1) return globals$1;
  hasRequiredGlobals$1 = 1;
  globals$1 = require$$0$2;
  return globals$1;
}
var hasRequiredScope$1;
function requireScope$1() {
  if (hasRequiredScope$1) return scope$1;
  hasRequiredScope$1 = 1;
  Object.defineProperty(scope$1, "__esModule", { value: true });
  scope$1.default = void 0;
  var _renamer = requireRenamer$1();
  var _index = requireLib$f();
  var _binding = requireBinding$1();
  var _globals = requireGlobals$1();
  var _t = t$d;
  var t = _t;
  var _cache = requireCache$1();
  var _visitors = requireVisitors$1();
  const {
    NOT_LOCAL_BINDING: NOT_LOCAL_BINDING,
    callExpression: callExpression,
    cloneNode: cloneNode,
    getBindingIdentifiers: getBindingIdentifiers,
    identifier: identifier,
    isArrayExpression: isArrayExpression,
    isBinary: isBinary,
    isCallExpression: isCallExpression,
    isClass: isClass,
    isClassBody: isClassBody,
    isClassDeclaration: isClassDeclaration,
    isExportAllDeclaration: isExportAllDeclaration,
    isExportDefaultDeclaration: isExportDefaultDeclaration,
    isExportNamedDeclaration: isExportNamedDeclaration,
    isFunctionDeclaration: isFunctionDeclaration,
    isIdentifier: isIdentifier,
    isImportDeclaration: isImportDeclaration,
    isLiteral: isLiteral,
    isMemberExpression: isMemberExpression,
    isMethod: isMethod,
    isModuleSpecifier: isModuleSpecifier,
    isNullLiteral: isNullLiteral,
    isObjectExpression: isObjectExpression,
    isProperty: isProperty,
    isPureish: isPureish,
    isRegExpLiteral: isRegExpLiteral,
    isSuper: isSuper,
    isTaggedTemplateExpression: isTaggedTemplateExpression,
    isTemplateLiteral: isTemplateLiteral,
    isThisExpression: isThisExpression,
    isUnaryExpression: isUnaryExpression,
    isVariableDeclaration: isVariableDeclaration,
    matchesPattern: matchesPattern,
    memberExpression: memberExpression,
    numericLiteral: numericLiteral,
    toIdentifier: toIdentifier,
    variableDeclaration: variableDeclaration,
    variableDeclarator: variableDeclarator,
    isRecordExpression: isRecordExpression,
    isTupleExpression: isTupleExpression,
    isObjectProperty: isObjectProperty,
    isTopicReference: isTopicReference,
    isMetaProperty: isMetaProperty,
    isPrivateName: isPrivateName,
    isExportDeclaration: isExportDeclaration,
    buildUndefinedNode: buildUndefinedNode,
  } = _t;
  function gatherNodeParts(node, parts) {
    switch (node == null ? void 0 : node.type) {
      default:
        if (isImportDeclaration(node) || isExportDeclaration(node)) {
          var _node$specifiers;
          if (
            (isExportAllDeclaration(node) ||
              isExportNamedDeclaration(node) ||
              isImportDeclaration(node)) &&
            node.source
          ) {
            gatherNodeParts(node.source, parts);
          } else if (
            (isExportNamedDeclaration(node) || isImportDeclaration(node)) &&
            (_node$specifiers = node.specifiers) != null &&
            _node$specifiers.length
          ) {
            for (const e of node.specifiers) gatherNodeParts(e, parts);
          } else if (
            (isExportDefaultDeclaration(node) ||
              isExportNamedDeclaration(node)) &&
            node.declaration
          ) {
            gatherNodeParts(node.declaration, parts);
          }
        } else if (isModuleSpecifier(node)) {
          gatherNodeParts(node.local, parts);
        } else if (
          isLiteral(node) &&
          !isNullLiteral(node) &&
          !isRegExpLiteral(node) &&
          !isTemplateLiteral(node)
        ) {
          parts.push(node.value);
        }
        break;
      case "MemberExpression":
      case "OptionalMemberExpression":
      case "JSXMemberExpression":
        gatherNodeParts(node.object, parts);
        gatherNodeParts(node.property, parts);
        break;
      case "Identifier":
      case "JSXIdentifier":
        parts.push(node.name);
        break;
      case "CallExpression":
      case "OptionalCallExpression":
      case "NewExpression":
        gatherNodeParts(node.callee, parts);
        break;
      case "ObjectExpression":
      case "ObjectPattern":
        for (const e of node.properties) {
          gatherNodeParts(e, parts);
        }
        break;
      case "SpreadElement":
      case "RestElement":
        gatherNodeParts(node.argument, parts);
        break;
      case "ObjectProperty":
      case "ObjectMethod":
      case "ClassProperty":
      case "ClassMethod":
      case "ClassPrivateProperty":
      case "ClassPrivateMethod":
        gatherNodeParts(node.key, parts);
        break;
      case "ThisExpression":
        parts.push("this");
        break;
      case "Super":
        parts.push("super");
        break;
      case "Import":
        parts.push("import");
        break;
      case "DoExpression":
        parts.push("do");
        break;
      case "YieldExpression":
        parts.push("yield");
        gatherNodeParts(node.argument, parts);
        break;
      case "AwaitExpression":
        parts.push("await");
        gatherNodeParts(node.argument, parts);
        break;
      case "AssignmentExpression":
        gatherNodeParts(node.left, parts);
        break;
      case "VariableDeclarator":
        gatherNodeParts(node.id, parts);
        break;
      case "FunctionExpression":
      case "FunctionDeclaration":
      case "ClassExpression":
      case "ClassDeclaration":
        gatherNodeParts(node.id, parts);
        break;
      case "PrivateName":
        gatherNodeParts(node.id, parts);
        break;
      case "ParenthesizedExpression":
        gatherNodeParts(node.expression, parts);
        break;
      case "UnaryExpression":
      case "UpdateExpression":
        gatherNodeParts(node.argument, parts);
        break;
      case "MetaProperty":
        gatherNodeParts(node.meta, parts);
        gatherNodeParts(node.property, parts);
        break;
      case "JSXElement":
        gatherNodeParts(node.openingElement, parts);
        break;
      case "JSXOpeningElement":
        gatherNodeParts(node.name, parts);
        break;
      case "JSXFragment":
        gatherNodeParts(node.openingFragment, parts);
        break;
      case "JSXOpeningFragment":
        parts.push("Fragment");
        break;
      case "JSXNamespacedName":
        gatherNodeParts(node.namespace, parts);
        gatherNodeParts(node.name, parts);
        break;
    }
  }
  const collectorVisitor = {
    ForStatement(path) {
      const declar = path.get("init");
      if (declar.isVar()) {
        const { scope: scope } = path;
        const parentScope =
          scope.getFunctionParent() || scope.getProgramParent();
        parentScope.registerBinding("var", declar);
      }
    },
    Declaration(path) {
      if (path.isBlockScoped()) return;
      if (path.isImportDeclaration()) return;
      if (path.isExportDeclaration()) return;
      const parent =
        path.scope.getFunctionParent() || path.scope.getProgramParent();
      parent.registerDeclaration(path);
    },
    ImportDeclaration(path) {
      const parent = path.scope.getBlockParent();
      parent.registerDeclaration(path);
    },
    ReferencedIdentifier(path, state) {
      state.references.push(path);
    },
    ForXStatement(path, state) {
      const left = path.get("left");
      if (left.isPattern() || left.isIdentifier()) {
        state.constantViolations.push(path);
      } else if (left.isVar()) {
        const { scope: scope } = path;
        const parentScope =
          scope.getFunctionParent() || scope.getProgramParent();
        parentScope.registerBinding("var", left);
      }
    },
    ExportDeclaration: {
      exit(path) {
        const { node: node, scope: scope } = path;
        if (isExportAllDeclaration(node)) return;
        const declar = node.declaration;
        if (isClassDeclaration(declar) || isFunctionDeclaration(declar)) {
          const id = declar.id;
          if (!id) return;
          const binding = scope.getBinding(id.name);
          binding == null || binding.reference(path);
        } else if (isVariableDeclaration(declar)) {
          for (const decl of declar.declarations) {
            for (const name of Object.keys(getBindingIdentifiers(decl))) {
              const binding = scope.getBinding(name);
              binding == null || binding.reference(path);
            }
          }
        }
      },
    },
    LabeledStatement(path) {
      path.scope.getBlockParent().registerDeclaration(path);
    },
    AssignmentExpression(path, state) {
      state.assignments.push(path);
    },
    UpdateExpression(path, state) {
      state.constantViolations.push(path);
    },
    UnaryExpression(path, state) {
      if (path.node.operator === "delete") {
        state.constantViolations.push(path);
      }
    },
    BlockScoped(path) {
      let scope = path.scope;
      if (scope.path === path) scope = scope.parent;
      const parent = scope.getBlockParent();
      parent.registerDeclaration(path);
      if (path.isClassDeclaration() && path.node.id) {
        const id = path.node.id;
        const name = id.name;
        path.scope.bindings[name] = path.scope.parent.getBinding(name);
      }
    },
    CatchClause(path) {
      path.scope.registerBinding("let", path);
    },
    Function(path) {
      const params = path.get("params");
      for (const param of params) {
        path.scope.registerBinding("param", param);
      }
      if (
        path.isFunctionExpression() &&
        path.has("id") &&
        !path.get("id").node[NOT_LOCAL_BINDING]
      ) {
        path.scope.registerBinding("local", path.get("id"), path);
      }
    },
    ClassExpression(path) {
      if (path.has("id") && !path.get("id").node[NOT_LOCAL_BINDING]) {
        path.scope.registerBinding("local", path);
      }
    },
  };
  let uid = 0;
  class Scope {
    constructor(path) {
      this.uid = void 0;
      this.path = void 0;
      this.block = void 0;
      this.labels = void 0;
      this.inited = void 0;
      this.bindings = void 0;
      this.references = void 0;
      this.globals = void 0;
      this.uids = void 0;
      this.data = void 0;
      this.crawling = void 0;
      const { node: node } = path;
      const cached = _cache.scope.get(node);
      if ((cached == null ? void 0 : cached.path) === path) {
        return cached;
      }
      _cache.scope.set(node, this);
      this.uid = uid++;
      this.block = node;
      this.path = path;
      this.labels = new Map();
      this.inited = false;
    }
    get parent() {
      var _parent;
      let parent,
        path = this.path;
      do {
        const shouldSkip = path.key === "key" || path.listKey === "decorators";
        path = path.parentPath;
        if (shouldSkip && path.isMethod()) path = path.parentPath;
        if (path && path.isScope()) parent = path;
      } while (path && !parent);
      return (_parent = parent) == null ? void 0 : _parent.scope;
    }
    get parentBlock() {
      return this.path.parent;
    }
    get hub() {
      return this.path.hub;
    }
    traverse(node, opts, state) {
      (0, _index.default)(node, opts, this, state, this.path);
    }
    generateDeclaredUidIdentifier(name) {
      const id = this.generateUidIdentifier(name);
      this.push({ id: id });
      return cloneNode(id);
    }
    generateUidIdentifier(name) {
      return identifier(this.generateUid(name));
    }
    generateUid(name = "temp") {
      name = toIdentifier(name)
        .replace(/^_+/, "")
        .replace(/[0-9]+$/g, "");
      let uid;
      let i = 1;
      do {
        uid = this._generateUid(name, i);
        i++;
      } while (
        this.hasLabel(uid) ||
        this.hasBinding(uid) ||
        this.hasGlobal(uid) ||
        this.hasReference(uid)
      );
      const program = this.getProgramParent();
      program.references[uid] = true;
      program.uids[uid] = true;
      return uid;
    }
    _generateUid(name, i) {
      let id = name;
      if (i > 1) id += i;
      return `_${id}`;
    }
    generateUidBasedOnNode(node, defaultName) {
      const parts = [];
      gatherNodeParts(node, parts);
      let id = parts.join("$");
      id = id.replace(/^_/, "") || defaultName || "ref";
      return this.generateUid(id.slice(0, 20));
    }
    generateUidIdentifierBasedOnNode(node, defaultName) {
      return identifier(this.generateUidBasedOnNode(node, defaultName));
    }
    isStatic(node) {
      if (isThisExpression(node) || isSuper(node) || isTopicReference(node)) {
        return true;
      }
      if (isIdentifier(node)) {
        const binding = this.getBinding(node.name);
        if (binding) {
          return binding.constant;
        } else {
          return this.hasBinding(node.name);
        }
      }
      return false;
    }
    maybeGenerateMemoised(node, dontPush) {
      if (this.isStatic(node)) {
        return null;
      } else {
        const id = this.generateUidIdentifierBasedOnNode(node);
        if (!dontPush) {
          this.push({ id: id });
          return cloneNode(id);
        }
        return id;
      }
    }
    checkBlockScopedCollisions(local, kind, name, id) {
      if (kind === "param") return;
      if (local.kind === "local") return;
      const duplicate =
        kind === "let" ||
        local.kind === "let" ||
        local.kind === "const" ||
        local.kind === "module" ||
        (local.kind === "param" && kind === "const");
      if (duplicate) {
        throw this.hub.buildError(
          id,
          `Duplicate declaration "${name}"`,
          TypeError,
        );
      }
    }
    rename(oldName, newName) {
      const binding = this.getBinding(oldName);
      if (binding) {
        newName || (newName = this.generateUidIdentifier(oldName).name);
        const renamer = new _renamer.default(binding, oldName, newName);
        {
          renamer.rename(arguments[2]);
        }
      }
    }
    _renameFromMap(map, oldName, newName, value) {
      if (map[oldName]) {
        map[newName] = value;
        map[oldName] = null;
      }
    }
    dump() {
      const sep = "-".repeat(60);
      console.log(sep);
      let scope = this;
      do {
        console.log("#", scope.block.type);
        for (const name of Object.keys(scope.bindings)) {
          const binding = scope.bindings[name];
          console.log(" -", name, {
            constant: binding.constant,
            references: binding.references,
            violations: binding.constantViolations.length,
            kind: binding.kind,
          });
        }
      } while ((scope = scope.parent));
      console.log(sep);
    }
    toArray(node, i, arrayLikeIsIterable) {
      if (isIdentifier(node)) {
        const binding = this.getBinding(node.name);
        if (
          binding != null &&
          binding.constant &&
          binding.path.isGenericType("Array")
        ) {
          return node;
        }
      }
      if (isArrayExpression(node)) {
        return node;
      }
      if (isIdentifier(node, { name: "arguments" })) {
        return callExpression(
          memberExpression(
            memberExpression(
              memberExpression(identifier("Array"), identifier("prototype")),
              identifier("slice"),
            ),
            identifier("call"),
          ),
          [node],
        );
      }
      let helperName;
      const args = [node];
      if (i === true) {
        helperName = "toConsumableArray";
      } else if (typeof i === "number") {
        args.push(numericLiteral(i));
        helperName = "slicedToArray";
      } else {
        helperName = "toArray";
      }
      if (arrayLikeIsIterable) {
        args.unshift(this.hub.addHelper(helperName));
        helperName = "maybeArrayLike";
      }
      return callExpression(this.hub.addHelper(helperName), args);
    }
    hasLabel(name) {
      return !!this.getLabel(name);
    }
    getLabel(name) {
      return this.labels.get(name);
    }
    registerLabel(path) {
      this.labels.set(path.node.label.name, path);
    }
    registerDeclaration(path) {
      if (path.isLabeledStatement()) {
        this.registerLabel(path);
      } else if (path.isFunctionDeclaration()) {
        this.registerBinding("hoisted", path.get("id"), path);
      } else if (path.isVariableDeclaration()) {
        const declarations = path.get("declarations");
        const { kind: kind } = path.node;
        for (const declar of declarations) {
          this.registerBinding(
            kind === "using" || kind === "await using" ? "const" : kind,
            declar,
          );
        }
      } else if (path.isClassDeclaration()) {
        if (path.node.declare) return;
        this.registerBinding("let", path);
      } else if (path.isImportDeclaration()) {
        const isTypeDeclaration =
          path.node.importKind === "type" || path.node.importKind === "typeof";
        const specifiers = path.get("specifiers");
        for (const specifier of specifiers) {
          const isTypeSpecifier =
            isTypeDeclaration ||
            (specifier.isImportSpecifier() &&
              (specifier.node.importKind === "type" ||
                specifier.node.importKind === "typeof"));
          this.registerBinding(
            isTypeSpecifier ? "unknown" : "module",
            specifier,
          );
        }
      } else if (path.isExportDeclaration()) {
        const declar = path.get("declaration");
        if (
          declar.isClassDeclaration() ||
          declar.isFunctionDeclaration() ||
          declar.isVariableDeclaration()
        ) {
          this.registerDeclaration(declar);
        }
      } else {
        this.registerBinding("unknown", path);
      }
    }
    buildUndefinedNode() {
      return buildUndefinedNode();
    }
    registerConstantViolation(path) {
      const ids = path.getBindingIdentifiers();
      for (const name of Object.keys(ids)) {
        var _this$getBinding;
        (_this$getBinding = this.getBinding(name)) == null ||
          _this$getBinding.reassign(path);
      }
    }
    registerBinding(kind, path, bindingPath = path) {
      if (!kind) throw new ReferenceError("no `kind`");
      if (path.isVariableDeclaration()) {
        const declarators = path.get("declarations");
        for (const declar of declarators) {
          this.registerBinding(kind, declar);
        }
        return;
      }
      const parent = this.getProgramParent();
      const ids = path.getOuterBindingIdentifiers(true);
      for (const name of Object.keys(ids)) {
        parent.references[name] = true;
        for (const id of ids[name]) {
          const local = this.getOwnBinding(name);
          if (local) {
            if (local.identifier === id) continue;
            this.checkBlockScopedCollisions(local, kind, name, id);
          }
          if (local) {
            this.registerConstantViolation(bindingPath);
          } else {
            this.bindings[name] = new _binding.default({
              identifier: id,
              scope: this,
              path: bindingPath,
              kind: kind,
            });
          }
        }
      }
    }
    addGlobal(node) {
      this.globals[node.name] = node;
    }
    hasUid(name) {
      let scope = this;
      do {
        if (scope.uids[name]) return true;
      } while ((scope = scope.parent));
      return false;
    }
    hasGlobal(name) {
      let scope = this;
      do {
        if (scope.globals[name]) return true;
      } while ((scope = scope.parent));
      return false;
    }
    hasReference(name) {
      return !!this.getProgramParent().references[name];
    }
    isPure(node, constantsOnly) {
      if (isIdentifier(node)) {
        const binding = this.getBinding(node.name);
        if (!binding) return false;
        if (constantsOnly) return binding.constant;
        return true;
      } else if (
        isThisExpression(node) ||
        isMetaProperty(node) ||
        isTopicReference(node) ||
        isPrivateName(node)
      ) {
        return true;
      } else if (isClass(node)) {
        var _node$decorators;
        if (node.superClass && !this.isPure(node.superClass, constantsOnly)) {
          return false;
        }
        if (
          ((_node$decorators = node.decorators) == null
            ? void 0
            : _node$decorators.length) > 0
        ) {
          return false;
        }
        return this.isPure(node.body, constantsOnly);
      } else if (isClassBody(node)) {
        for (const method of node.body) {
          if (!this.isPure(method, constantsOnly)) return false;
        }
        return true;
      } else if (isBinary(node)) {
        return (
          this.isPure(node.left, constantsOnly) &&
          this.isPure(node.right, constantsOnly)
        );
      } else if (isArrayExpression(node) || isTupleExpression(node)) {
        for (const elem of node.elements) {
          if (elem !== null && !this.isPure(elem, constantsOnly)) return false;
        }
        return true;
      } else if (isObjectExpression(node) || isRecordExpression(node)) {
        for (const prop of node.properties) {
          if (!this.isPure(prop, constantsOnly)) return false;
        }
        return true;
      } else if (isMethod(node)) {
        var _node$decorators2;
        if (node.computed && !this.isPure(node.key, constantsOnly))
          return false;
        if (
          ((_node$decorators2 = node.decorators) == null
            ? void 0
            : _node$decorators2.length) > 0
        ) {
          return false;
        }
        return true;
      } else if (isProperty(node)) {
        var _node$decorators3;
        if (node.computed && !this.isPure(node.key, constantsOnly))
          return false;
        if (
          ((_node$decorators3 = node.decorators) == null
            ? void 0
            : _node$decorators3.length) > 0
        ) {
          return false;
        }
        if (isObjectProperty(node) || node.static) {
          if (node.value !== null && !this.isPure(node.value, constantsOnly)) {
            return false;
          }
        }
        return true;
      } else if (isUnaryExpression(node)) {
        return this.isPure(node.argument, constantsOnly);
      } else if (isTemplateLiteral(node)) {
        for (const expression of node.expressions) {
          if (!this.isPure(expression, constantsOnly)) return false;
        }
        return true;
      } else if (isTaggedTemplateExpression(node)) {
        return (
          matchesPattern(node.tag, "String.raw") &&
          !this.hasBinding("String", { noGlobals: true }) &&
          this.isPure(node.quasi, constantsOnly)
        );
      } else if (isMemberExpression(node)) {
        return (
          !node.computed &&
          isIdentifier(node.object) &&
          node.object.name === "Symbol" &&
          isIdentifier(node.property) &&
          node.property.name !== "for" &&
          !this.hasBinding("Symbol", { noGlobals: true })
        );
      } else if (isCallExpression(node)) {
        return (
          matchesPattern(node.callee, "Symbol.for") &&
          !this.hasBinding("Symbol", { noGlobals: true }) &&
          node.arguments.length === 1 &&
          t.isStringLiteral(node.arguments[0])
        );
      } else {
        return isPureish(node);
      }
    }
    setData(key, val) {
      return (this.data[key] = val);
    }
    getData(key) {
      let scope = this;
      do {
        const data = scope.data[key];
        if (data != null) return data;
      } while ((scope = scope.parent));
    }
    removeData(key) {
      let scope = this;
      do {
        const data = scope.data[key];
        if (data != null) scope.data[key] = null;
      } while ((scope = scope.parent));
    }
    init() {
      if (!this.inited) {
        this.inited = true;
        this.crawl();
      }
    }
    crawl() {
      const path = this.path;
      this.references = Object.create(null);
      this.bindings = Object.create(null);
      this.globals = Object.create(null);
      this.uids = Object.create(null);
      this.data = Object.create(null);
      const programParent = this.getProgramParent();
      if (programParent.crawling) return;
      const state = { references: [], constantViolations: [], assignments: [] };
      this.crawling = true;
      if (
        path.type !== "Program" &&
        (0, _visitors.isExplodedVisitor)(collectorVisitor)
      ) {
        for (const visit of collectorVisitor.enter) {
          visit.call(state, path, state);
        }
        const typeVisitors = collectorVisitor[path.type];
        if (typeVisitors) {
          for (const visit of typeVisitors.enter) {
            visit.call(state, path, state);
          }
        }
      }
      path.traverse(collectorVisitor, state);
      this.crawling = false;
      for (const path of state.assignments) {
        const ids = path.getBindingIdentifiers();
        for (const name of Object.keys(ids)) {
          if (path.scope.getBinding(name)) continue;
          programParent.addGlobal(ids[name]);
        }
        path.scope.registerConstantViolation(path);
      }
      for (const ref of state.references) {
        const binding = ref.scope.getBinding(ref.node.name);
        if (binding) {
          binding.reference(ref);
        } else {
          programParent.addGlobal(ref.node);
        }
      }
      for (const path of state.constantViolations) {
        path.scope.registerConstantViolation(path);
      }
    }
    push(opts) {
      let path = this.path;
      if (path.isPattern()) {
        path = this.getPatternParent().path;
      } else if (!path.isBlockStatement() && !path.isProgram()) {
        path = this.getBlockParent().path;
      }
      if (path.isSwitchStatement()) {
        path = (this.getFunctionParent() || this.getProgramParent()).path;
      }
      const { init: init, unique: unique, kind: kind = "var", id: id } = opts;
      if (
        !init &&
        !unique &&
        (kind === "var" || kind === "let") &&
        path.isFunction() &&
        !path.node.name &&
        isCallExpression(path.parent, { callee: path.node }) &&
        path.parent.arguments.length <= path.node.params.length &&
        isIdentifier(id)
      ) {
        path.pushContainer("params", id);
        path.scope.registerBinding(
          "param",
          path.get("params")[path.node.params.length - 1],
        );
        return;
      }
      if (path.isLoop() || path.isCatchClause() || path.isFunction()) {
        path.ensureBlock();
        path = path.get("body");
      }
      const blockHoist = opts._blockHoist == null ? 2 : opts._blockHoist;
      const dataKey = `declaration:${kind}:${blockHoist}`;
      let declarPath = !unique && path.getData(dataKey);
      if (!declarPath) {
        const declar = variableDeclaration(kind, []);
        declar._blockHoist = blockHoist;
        [declarPath] = path.unshiftContainer("body", [declar]);
        if (!unique) path.setData(dataKey, declarPath);
      }
      const declarator = variableDeclarator(id, init);
      const len = declarPath.node.declarations.push(declarator);
      path.scope.registerBinding(kind, declarPath.get("declarations")[len - 1]);
    }
    getProgramParent() {
      let scope = this;
      do {
        if (scope.path.isProgram()) {
          return scope;
        }
      } while ((scope = scope.parent));
      throw new Error("Couldn't find a Program");
    }
    getFunctionParent() {
      let scope = this;
      do {
        if (scope.path.isFunctionParent()) {
          return scope;
        }
      } while ((scope = scope.parent));
      return null;
    }
    getBlockParent() {
      let scope = this;
      do {
        if (scope.path.isBlockParent()) {
          return scope;
        }
      } while ((scope = scope.parent));
      throw new Error(
        "We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...",
      );
    }
    getPatternParent() {
      let scope = this;
      do {
        if (!scope.path.isPattern()) {
          return scope.getBlockParent();
        }
      } while ((scope = scope.parent.parent));
      throw new Error(
        "We couldn't find a BlockStatement, For, Switch, Function, Loop or Program...",
      );
    }
    getAllBindings() {
      const ids = Object.create(null);
      let scope = this;
      do {
        for (const key of Object.keys(scope.bindings)) {
          if (key in ids === false) {
            ids[key] = scope.bindings[key];
          }
        }
        scope = scope.parent;
      } while (scope);
      return ids;
    }
    getAllBindingsOfKind(...kinds) {
      const ids = Object.create(null);
      for (const kind of kinds) {
        let scope = this;
        do {
          for (const name of Object.keys(scope.bindings)) {
            const binding = scope.bindings[name];
            if (binding.kind === kind) ids[name] = binding;
          }
          scope = scope.parent;
        } while (scope);
      }
      return ids;
    }
    bindingIdentifierEquals(name, node) {
      return this.getBindingIdentifier(name) === node;
    }
    getBinding(name) {
      let scope = this;
      let previousPath;
      do {
        const binding = scope.getOwnBinding(name);
        if (binding) {
          var _previousPath;
          if (
            (_previousPath = previousPath) != null &&
            _previousPath.isPattern() &&
            binding.kind !== "param" &&
            binding.kind !== "local"
          );
          else {
            return binding;
          }
        } else if (
          !binding &&
          name === "arguments" &&
          scope.path.isFunction() &&
          !scope.path.isArrowFunctionExpression()
        ) {
          break;
        }
        previousPath = scope.path;
      } while ((scope = scope.parent));
    }
    getOwnBinding(name) {
      return this.bindings[name];
    }
    getBindingIdentifier(name) {
      var _this$getBinding2;
      return (_this$getBinding2 = this.getBinding(name)) == null
        ? void 0
        : _this$getBinding2.identifier;
    }
    getOwnBindingIdentifier(name) {
      const binding = this.bindings[name];
      return binding == null ? void 0 : binding.identifier;
    }
    hasOwnBinding(name) {
      return !!this.getOwnBinding(name);
    }
    hasBinding(name, opts) {
      var _opts, _opts2, _opts3;
      if (!name) return false;
      if (this.hasOwnBinding(name)) return true;
      {
        if (typeof opts === "boolean") opts = { noGlobals: opts };
      }
      if (this.parentHasBinding(name, opts)) return true;
      if (!((_opts = opts) != null && _opts.noUids) && this.hasUid(name))
        return true;
      if (
        !((_opts2 = opts) != null && _opts2.noGlobals) &&
        Scope.globals.includes(name)
      )
        return true;
      if (
        !((_opts3 = opts) != null && _opts3.noGlobals) &&
        Scope.contextVariables.includes(name)
      )
        return true;
      return false;
    }
    parentHasBinding(name, opts) {
      var _this$parent;
      return (_this$parent = this.parent) == null
        ? void 0
        : _this$parent.hasBinding(name, opts);
    }
    moveBindingTo(name, scope) {
      const info = this.getBinding(name);
      if (info) {
        info.scope.removeOwnBinding(name);
        info.scope = scope;
        scope.bindings[name] = info;
      }
    }
    removeOwnBinding(name) {
      delete this.bindings[name];
    }
    removeBinding(name) {
      var _this$getBinding3;
      (_this$getBinding3 = this.getBinding(name)) == null ||
        _this$getBinding3.scope.removeOwnBinding(name);
      let scope = this;
      do {
        if (scope.uids[name]) {
          scope.uids[name] = false;
        }
      } while ((scope = scope.parent));
    }
  }
  scope$1.default = Scope;
  Scope.globals = Object.keys(_globals.builtin);
  Scope.contextVariables = ["arguments", "undefined", "Infinity", "NaN"];
  return scope$1;
}
var lib$o = {};
var sourceMap$3 = {};
var genMapping_umd = { exports: {} };
var setArray_umd = { exports: {} };
var hasRequiredSetArray_umd;
function requireSetArray_umd() {
  if (hasRequiredSetArray_umd) return setArray_umd.exports;
  hasRequiredSetArray_umd = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(exports);
    })(commonjsGlobal, function (exports) {
      class SetArray {
        constructor() {
          this._indexes = { __proto__: null };
          this.array = [];
        }
      }
      function cast(set) {
        return set;
      }
      function get(setarr, key) {
        return cast(setarr)._indexes[key];
      }
      function put(setarr, key) {
        const index = get(setarr, key);
        if (index !== undefined) return index;
        const { array: array, _indexes: indexes } = cast(setarr);
        const length = array.push(key);
        return (indexes[key] = length - 1);
      }
      function pop(setarr) {
        const { array: array, _indexes: indexes } = cast(setarr);
        if (array.length === 0) return;
        const last = array.pop();
        indexes[last] = undefined;
      }
      function remove(setarr, key) {
        const index = get(setarr, key);
        if (index === undefined) return;
        const { array: array, _indexes: indexes } = cast(setarr);
        for (let i = index + 1; i < array.length; i++) {
          const k = array[i];
          array[i - 1] = k;
          indexes[k]--;
        }
        indexes[key] = undefined;
        array.pop();
      }
      exports.SetArray = SetArray;
      exports.get = get;
      exports.pop = pop;
      exports.put = put;
      exports.remove = remove;
      Object.defineProperty(exports, "__esModule", { value: true });
    });
  })(setArray_umd, setArray_umd.exports);
  return setArray_umd.exports;
}
var sourcemapCodec_umd$2 = { exports: {} };
var hasRequiredSourcemapCodec_umd$2;
function requireSourcemapCodec_umd$2() {
  if (hasRequiredSourcemapCodec_umd$2) return sourcemapCodec_umd$2.exports;
  hasRequiredSourcemapCodec_umd$2 = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(exports);
    })(commonjsGlobal, function (exports) {
      const comma = ",".charCodeAt(0);
      const semicolon = ";".charCodeAt(0);
      const chars =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      const intToChar = new Uint8Array(64);
      const charToInt = new Uint8Array(128);
      for (let i = 0; i < chars.length; i++) {
        const c = chars.charCodeAt(i);
        intToChar[i] = c;
        charToInt[c] = i;
      }
      const td =
        typeof TextDecoder !== "undefined"
          ? new TextDecoder()
          : typeof Buffer !== "undefined"
            ? {
                decode(buf) {
                  const out = Buffer.from(
                    buf.buffer,
                    buf.byteOffset,
                    buf.byteLength,
                  );
                  return out.toString();
                },
              }
            : {
                decode(buf) {
                  let out = "";
                  for (let i = 0; i < buf.length; i++) {
                    out += String.fromCharCode(buf[i]);
                  }
                  return out;
                },
              };
      function decode(mappings) {
        const state = new Int32Array(5);
        const decoded = [];
        let index = 0;
        do {
          const semi = indexOf(mappings, index);
          const line = [];
          let sorted = true;
          let lastCol = 0;
          state[0] = 0;
          for (let i = index; i < semi; i++) {
            let seg;
            i = decodeInteger(mappings, i, state, 0);
            const col = state[0];
            if (col < lastCol) sorted = false;
            lastCol = col;
            if (hasMoreVlq(mappings, i, semi)) {
              i = decodeInteger(mappings, i, state, 1);
              i = decodeInteger(mappings, i, state, 2);
              i = decodeInteger(mappings, i, state, 3);
              if (hasMoreVlq(mappings, i, semi)) {
                i = decodeInteger(mappings, i, state, 4);
                seg = [col, state[1], state[2], state[3], state[4]];
              } else {
                seg = [col, state[1], state[2], state[3]];
              }
            } else {
              seg = [col];
            }
            line.push(seg);
          }
          if (!sorted) sort(line);
          decoded.push(line);
          index = semi + 1;
        } while (index <= mappings.length);
        return decoded;
      }
      function indexOf(mappings, index) {
        const idx = mappings.indexOf(";", index);
        return idx === -1 ? mappings.length : idx;
      }
      function decodeInteger(mappings, pos, state, j) {
        let value = 0;
        let shift = 0;
        let integer = 0;
        do {
          const c = mappings.charCodeAt(pos++);
          integer = charToInt[c];
          value |= (integer & 31) << shift;
          shift += 5;
        } while (integer & 32);
        const shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
          value = -2147483648 | -value;
        }
        state[j] += value;
        return pos;
      }
      function hasMoreVlq(mappings, i, length) {
        if (i >= length) return false;
        return mappings.charCodeAt(i) !== comma;
      }
      function sort(line) {
        line.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[0] - b[0];
      }
      function encode(decoded) {
        const state = new Int32Array(5);
        const bufLength = 1024 * 16;
        const subLength = bufLength - 36;
        const buf = new Uint8Array(bufLength);
        const sub = buf.subarray(0, subLength);
        let pos = 0;
        let out = "";
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          if (i > 0) {
            if (pos === bufLength) {
              out += td.decode(buf);
              pos = 0;
            }
            buf[pos++] = semicolon;
          }
          if (line.length === 0) continue;
          state[0] = 0;
          for (let j = 0; j < line.length; j++) {
            const segment = line[j];
            if (pos > subLength) {
              out += td.decode(sub);
              buf.copyWithin(0, subLength, pos);
              pos -= subLength;
            }
            if (j > 0) buf[pos++] = comma;
            pos = encodeInteger(buf, pos, state, segment, 0);
            if (segment.length === 1) continue;
            pos = encodeInteger(buf, pos, state, segment, 1);
            pos = encodeInteger(buf, pos, state, segment, 2);
            pos = encodeInteger(buf, pos, state, segment, 3);
            if (segment.length === 4) continue;
            pos = encodeInteger(buf, pos, state, segment, 4);
          }
        }
        return out + td.decode(buf.subarray(0, pos));
      }
      function encodeInteger(buf, pos, state, segment, j) {
        const next = segment[j];
        let num = next - state[j];
        state[j] = next;
        num = num < 0 ? (-num << 1) | 1 : num << 1;
        do {
          let clamped = num & 31;
          num >>>= 5;
          if (num > 0) clamped |= 32;
          buf[pos++] = intToChar[clamped];
        } while (num > 0);
        return pos;
      }
      exports.decode = decode;
      exports.encode = encode;
      Object.defineProperty(exports, "__esModule", { value: true });
    });
  })(sourcemapCodec_umd$2, sourcemapCodec_umd$2.exports);
  return sourcemapCodec_umd$2.exports;
}
var traceMapping_umd$1 = { exports: {} };
var sourcemapCodec_umd$1 = { exports: {} };
var hasRequiredSourcemapCodec_umd$1;
function requireSourcemapCodec_umd$1() {
  if (hasRequiredSourcemapCodec_umd$1) return sourcemapCodec_umd$1.exports;
  hasRequiredSourcemapCodec_umd$1 = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(exports);
    })(commonjsGlobal, function (exports) {
      const comma = ",".charCodeAt(0);
      const semicolon = ";".charCodeAt(0);
      const chars =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      const intToChar = new Uint8Array(64);
      const charToInt = new Uint8Array(128);
      for (let i = 0; i < chars.length; i++) {
        const c = chars.charCodeAt(i);
        intToChar[i] = c;
        charToInt[c] = i;
      }
      const td =
        typeof TextDecoder !== "undefined"
          ? new TextDecoder()
          : typeof Buffer !== "undefined"
            ? {
                decode(buf) {
                  const out = Buffer.from(
                    buf.buffer,
                    buf.byteOffset,
                    buf.byteLength,
                  );
                  return out.toString();
                },
              }
            : {
                decode(buf) {
                  let out = "";
                  for (let i = 0; i < buf.length; i++) {
                    out += String.fromCharCode(buf[i]);
                  }
                  return out;
                },
              };
      function decode(mappings) {
        const state = new Int32Array(5);
        const decoded = [];
        let index = 0;
        do {
          const semi = indexOf(mappings, index);
          const line = [];
          let sorted = true;
          let lastCol = 0;
          state[0] = 0;
          for (let i = index; i < semi; i++) {
            let seg;
            i = decodeInteger(mappings, i, state, 0);
            const col = state[0];
            if (col < lastCol) sorted = false;
            lastCol = col;
            if (hasMoreVlq(mappings, i, semi)) {
              i = decodeInteger(mappings, i, state, 1);
              i = decodeInteger(mappings, i, state, 2);
              i = decodeInteger(mappings, i, state, 3);
              if (hasMoreVlq(mappings, i, semi)) {
                i = decodeInteger(mappings, i, state, 4);
                seg = [col, state[1], state[2], state[3], state[4]];
              } else {
                seg = [col, state[1], state[2], state[3]];
              }
            } else {
              seg = [col];
            }
            line.push(seg);
          }
          if (!sorted) sort(line);
          decoded.push(line);
          index = semi + 1;
        } while (index <= mappings.length);
        return decoded;
      }
      function indexOf(mappings, index) {
        const idx = mappings.indexOf(";", index);
        return idx === -1 ? mappings.length : idx;
      }
      function decodeInteger(mappings, pos, state, j) {
        let value = 0;
        let shift = 0;
        let integer = 0;
        do {
          const c = mappings.charCodeAt(pos++);
          integer = charToInt[c];
          value |= (integer & 31) << shift;
          shift += 5;
        } while (integer & 32);
        const shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
          value = -2147483648 | -value;
        }
        state[j] += value;
        return pos;
      }
      function hasMoreVlq(mappings, i, length) {
        if (i >= length) return false;
        return mappings.charCodeAt(i) !== comma;
      }
      function sort(line) {
        line.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[0] - b[0];
      }
      function encode(decoded) {
        const state = new Int32Array(5);
        const bufLength = 1024 * 16;
        const subLength = bufLength - 36;
        const buf = new Uint8Array(bufLength);
        const sub = buf.subarray(0, subLength);
        let pos = 0;
        let out = "";
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          if (i > 0) {
            if (pos === bufLength) {
              out += td.decode(buf);
              pos = 0;
            }
            buf[pos++] = semicolon;
          }
          if (line.length === 0) continue;
          state[0] = 0;
          for (let j = 0; j < line.length; j++) {
            const segment = line[j];
            if (pos > subLength) {
              out += td.decode(sub);
              buf.copyWithin(0, subLength, pos);
              pos -= subLength;
            }
            if (j > 0) buf[pos++] = comma;
            pos = encodeInteger(buf, pos, state, segment, 0);
            if (segment.length === 1) continue;
            pos = encodeInteger(buf, pos, state, segment, 1);
            pos = encodeInteger(buf, pos, state, segment, 2);
            pos = encodeInteger(buf, pos, state, segment, 3);
            if (segment.length === 4) continue;
            pos = encodeInteger(buf, pos, state, segment, 4);
          }
        }
        return out + td.decode(buf.subarray(0, pos));
      }
      function encodeInteger(buf, pos, state, segment, j) {
        const next = segment[j];
        let num = next - state[j];
        state[j] = next;
        num = num < 0 ? (-num << 1) | 1 : num << 1;
        do {
          let clamped = num & 31;
          num >>>= 5;
          if (num > 0) clamped |= 32;
          buf[pos++] = intToChar[clamped];
        } while (num > 0);
        return pos;
      }
      exports.decode = decode;
      exports.encode = encode;
      Object.defineProperty(exports, "__esModule", { value: true });
    });
  })(sourcemapCodec_umd$1, sourcemapCodec_umd$1.exports);
  return sourcemapCodec_umd$1.exports;
}
var resolveUri_umd$1 = { exports: {} };
var hasRequiredResolveUri_umd$1;
function requireResolveUri_umd$1() {
  if (hasRequiredResolveUri_umd$1) return resolveUri_umd$1.exports;
  hasRequiredResolveUri_umd$1 = 1;
  (function (module, exports) {
    (function (global, factory) {
      module.exports = factory();
    })(commonjsGlobal, function () {
      const schemeRegex = /^[\w+.-]+:\/\//;
      const urlRegex =
        /^([\w+.-]+:)\/\/([^@/#?]*@)?([^:/#?]*)(:\d+)?(\/[^#?]*)?(\?[^#]*)?(#.*)?/;
      const fileRegex =
        /^file:(?:\/\/((?![a-z]:)[^/#?]*)?)?(\/?[^#?]*)(\?[^#]*)?(#.*)?/i;
      function isAbsoluteUrl(input) {
        return schemeRegex.test(input);
      }
      function isSchemeRelativeUrl(input) {
        return input.startsWith("//");
      }
      function isAbsolutePath(input) {
        return input.startsWith("/");
      }
      function isFileUrl(input) {
        return input.startsWith("file:");
      }
      function isRelative(input) {
        return /^[.?#]/.test(input);
      }
      function parseAbsoluteUrl(input) {
        const match = urlRegex.exec(input);
        return makeUrl(
          match[1],
          match[2] || "",
          match[3],
          match[4] || "",
          match[5] || "/",
          match[6] || "",
          match[7] || "",
        );
      }
      function parseFileUrl(input) {
        const match = fileRegex.exec(input);
        const path = match[2];
        return makeUrl(
          "file:",
          "",
          match[1] || "",
          "",
          isAbsolutePath(path) ? path : "/" + path,
          match[3] || "",
          match[4] || "",
        );
      }
      function makeUrl(scheme, user, host, port, path, query, hash) {
        return {
          scheme: scheme,
          user: user,
          host: host,
          port: port,
          path: path,
          query: query,
          hash: hash,
          type: 7,
        };
      }
      function parseUrl(input) {
        if (isSchemeRelativeUrl(input)) {
          const url = parseAbsoluteUrl("http:" + input);
          url.scheme = "";
          url.type = 6;
          return url;
        }
        if (isAbsolutePath(input)) {
          const url = parseAbsoluteUrl("http://foo.com" + input);
          url.scheme = "";
          url.host = "";
          url.type = 5;
          return url;
        }
        if (isFileUrl(input)) return parseFileUrl(input);
        if (isAbsoluteUrl(input)) return parseAbsoluteUrl(input);
        const url = parseAbsoluteUrl("http://foo.com/" + input);
        url.scheme = "";
        url.host = "";
        url.type = input
          ? input.startsWith("?")
            ? 3
            : input.startsWith("#")
              ? 2
              : 4
          : 1;
        return url;
      }
      function stripPathFilename(path) {
        if (path.endsWith("/..")) return path;
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      function mergePaths(url, base) {
        normalizePath(base, base.type);
        if (url.path === "/") {
          url.path = base.path;
        } else {
          url.path = stripPathFilename(base.path) + url.path;
        }
      }
      function normalizePath(url, type) {
        const rel = type <= 4;
        const pieces = url.path.split("/");
        let pointer = 1;
        let positive = 0;
        let addTrailingSlash = false;
        for (let i = 1; i < pieces.length; i++) {
          const piece = pieces[i];
          if (!piece) {
            addTrailingSlash = true;
            continue;
          }
          addTrailingSlash = false;
          if (piece === ".") continue;
          if (piece === "..") {
            if (positive) {
              addTrailingSlash = true;
              positive--;
              pointer--;
            } else if (rel) {
              pieces[pointer++] = piece;
            }
            continue;
          }
          pieces[pointer++] = piece;
          positive++;
        }
        let path = "";
        for (let i = 1; i < pointer; i++) {
          path += "/" + pieces[i];
        }
        if (!path || (addTrailingSlash && !path.endsWith("/.."))) {
          path += "/";
        }
        url.path = path;
      }
      function resolve(input, base) {
        if (!input && !base) return "";
        const url = parseUrl(input);
        let inputType = url.type;
        if (base && inputType !== 7) {
          const baseUrl = parseUrl(base);
          const baseType = baseUrl.type;
          switch (inputType) {
            case 1:
              url.hash = baseUrl.hash;
            case 2:
              url.query = baseUrl.query;
            case 3:
            case 4:
              mergePaths(url, baseUrl);
            case 5:
              url.user = baseUrl.user;
              url.host = baseUrl.host;
              url.port = baseUrl.port;
            case 6:
              url.scheme = baseUrl.scheme;
          }
          if (baseType > inputType) inputType = baseType;
        }
        normalizePath(url, inputType);
        const queryHash = url.query + url.hash;
        switch (inputType) {
          case 2:
          case 3:
            return queryHash;
          case 4: {
            const path = url.path.slice(1);
            if (!path) return queryHash || ".";
            if (isRelative(base || input) && !isRelative(path)) {
              return "./" + path + queryHash;
            }
            return path + queryHash;
          }
          case 5:
            return url.path + queryHash;
          default:
            return (
              url.scheme +
              "//" +
              url.user +
              url.host +
              url.port +
              url.path +
              queryHash
            );
        }
      }
      return resolve;
    });
  })(resolveUri_umd$1);
  return resolveUri_umd$1.exports;
}
var hasRequiredTraceMapping_umd$1;
function requireTraceMapping_umd$1() {
  if (hasRequiredTraceMapping_umd$1) return traceMapping_umd$1.exports;
  hasRequiredTraceMapping_umd$1 = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(
        exports,
        requireSourcemapCodec_umd$1(),
        requireResolveUri_umd$1(),
      );
    })(commonjsGlobal, function (exports, sourcemapCodec, resolveUri) {
      function resolve(input, base) {
        if (base && !base.endsWith("/")) base += "/";
        return resolveUri(input, base);
      }
      function stripFilename(path) {
        if (!path) return "";
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      const COLUMN = 0;
      const SOURCES_INDEX = 1;
      const SOURCE_LINE = 2;
      const SOURCE_COLUMN = 3;
      const NAMES_INDEX = 4;
      const REV_GENERATED_LINE = 1;
      const REV_GENERATED_COLUMN = 2;
      function maybeSort(mappings, owned) {
        const unsortedIndex = nextUnsortedSegmentLine(mappings, 0);
        if (unsortedIndex === mappings.length) return mappings;
        if (!owned) mappings = mappings.slice();
        for (
          let i = unsortedIndex;
          i < mappings.length;
          i = nextUnsortedSegmentLine(mappings, i + 1)
        ) {
          mappings[i] = sortSegments(mappings[i], owned);
        }
        return mappings;
      }
      function nextUnsortedSegmentLine(mappings, start) {
        for (let i = start; i < mappings.length; i++) {
          if (!isSorted(mappings[i])) return i;
        }
        return mappings.length;
      }
      function isSorted(line) {
        for (let j = 1; j < line.length; j++) {
          if (line[j][COLUMN] < line[j - 1][COLUMN]) {
            return false;
          }
        }
        return true;
      }
      function sortSegments(line, owned) {
        if (!owned) line = line.slice();
        return line.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[COLUMN] - b[COLUMN];
      }
      let found = false;
      function binarySearch(haystack, needle, low, high) {
        while (low <= high) {
          const mid = low + ((high - low) >> 1);
          const cmp = haystack[mid][COLUMN] - needle;
          if (cmp === 0) {
            found = true;
            return mid;
          }
          if (cmp < 0) {
            low = mid + 1;
          } else {
            high = mid - 1;
          }
        }
        found = false;
        return low - 1;
      }
      function upperBound(haystack, needle, index) {
        for (let i = index + 1; i < haystack.length; index = i++) {
          if (haystack[i][COLUMN] !== needle) break;
        }
        return index;
      }
      function lowerBound(haystack, needle, index) {
        for (let i = index - 1; i >= 0; index = i--) {
          if (haystack[i][COLUMN] !== needle) break;
        }
        return index;
      }
      function memoizedState() {
        return { lastKey: -1, lastNeedle: -1, lastIndex: -1 };
      }
      function memoizedBinarySearch(haystack, needle, state, key) {
        const {
          lastKey: lastKey,
          lastNeedle: lastNeedle,
          lastIndex: lastIndex,
        } = state;
        let low = 0;
        let high = haystack.length - 1;
        if (key === lastKey) {
          if (needle === lastNeedle) {
            found = lastIndex !== -1 && haystack[lastIndex][COLUMN] === needle;
            return lastIndex;
          }
          if (needle >= lastNeedle) {
            low = lastIndex === -1 ? 0 : lastIndex;
          } else {
            high = lastIndex;
          }
        }
        state.lastKey = key;
        state.lastNeedle = needle;
        return (state.lastIndex = binarySearch(haystack, needle, low, high));
      }
      function buildBySources(decoded, memos) {
        const sources = memos.map(buildNullArray);
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            if (seg.length === 1) continue;
            const sourceIndex = seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            const originalSource = sources[sourceIndex];
            const originalLine =
              originalSource[sourceLine] || (originalSource[sourceLine] = []);
            const memo = memos[sourceIndex];
            let index = upperBound(
              originalLine,
              sourceColumn,
              memoizedBinarySearch(
                originalLine,
                sourceColumn,
                memo,
                sourceLine,
              ),
            );
            memo.lastIndex = ++index;
            insert(originalLine, index, [sourceColumn, i, seg[COLUMN]]);
          }
        }
        return sources;
      }
      function insert(array, index, value) {
        for (let i = array.length; i > index; i--) {
          array[i] = array[i - 1];
        }
        array[index] = value;
      }
      function buildNullArray() {
        return { __proto__: null };
      }
      const AnyMap = function (map, mapUrl) {
        const parsed = parse(map);
        if (!("sections" in parsed)) {
          return new TraceMap(parsed, mapUrl);
        }
        const mappings = [];
        const sources = [];
        const sourcesContent = [];
        const names = [];
        const ignoreList = [];
        recurse(
          parsed,
          mapUrl,
          mappings,
          sources,
          sourcesContent,
          names,
          ignoreList,
          0,
          0,
          Infinity,
          Infinity,
        );
        const joined = {
          version: 3,
          file: parsed.file,
          names: names,
          sources: sources,
          sourcesContent: sourcesContent,
          mappings: mappings,
          ignoreList: ignoreList,
        };
        return presortedDecodedMap(joined);
      };
      function parse(map) {
        return typeof map === "string" ? JSON.parse(map) : map;
      }
      function recurse(
        input,
        mapUrl,
        mappings,
        sources,
        sourcesContent,
        names,
        ignoreList,
        lineOffset,
        columnOffset,
        stopLine,
        stopColumn,
      ) {
        const { sections: sections } = input;
        for (let i = 0; i < sections.length; i++) {
          const { map: map, offset: offset } = sections[i];
          let sl = stopLine;
          let sc = stopColumn;
          if (i + 1 < sections.length) {
            const nextOffset = sections[i + 1].offset;
            sl = Math.min(stopLine, lineOffset + nextOffset.line);
            if (sl === stopLine) {
              sc = Math.min(stopColumn, columnOffset + nextOffset.column);
            } else if (sl < stopLine) {
              sc = columnOffset + nextOffset.column;
            }
          }
          addSection(
            map,
            mapUrl,
            mappings,
            sources,
            sourcesContent,
            names,
            ignoreList,
            lineOffset + offset.line,
            columnOffset + offset.column,
            sl,
            sc,
          );
        }
      }
      function addSection(
        input,
        mapUrl,
        mappings,
        sources,
        sourcesContent,
        names,
        ignoreList,
        lineOffset,
        columnOffset,
        stopLine,
        stopColumn,
      ) {
        const parsed = parse(input);
        if ("sections" in parsed) return recurse(...arguments);
        const map = new TraceMap(parsed, mapUrl);
        const sourcesOffset = sources.length;
        const namesOffset = names.length;
        const decoded = decodedMappings(map);
        const {
          resolvedSources: resolvedSources,
          sourcesContent: contents,
          ignoreList: ignores,
        } = map;
        append(sources, resolvedSources);
        append(names, map.names);
        if (contents) append(sourcesContent, contents);
        else
          for (let i = 0; i < resolvedSources.length; i++)
            sourcesContent.push(null);
        if (ignores)
          for (let i = 0; i < ignores.length; i++)
            ignoreList.push(ignores[i] + sourcesOffset);
        for (let i = 0; i < decoded.length; i++) {
          const lineI = lineOffset + i;
          if (lineI > stopLine) return;
          const out = getLine(mappings, lineI);
          const cOffset = i === 0 ? columnOffset : 0;
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            const column = cOffset + seg[COLUMN];
            if (lineI === stopLine && column >= stopColumn) return;
            if (seg.length === 1) {
              out.push([column]);
              continue;
            }
            const sourcesIndex = sourcesOffset + seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            out.push(
              seg.length === 4
                ? [column, sourcesIndex, sourceLine, sourceColumn]
                : [
                    column,
                    sourcesIndex,
                    sourceLine,
                    sourceColumn,
                    namesOffset + seg[NAMES_INDEX],
                  ],
            );
          }
        }
      }
      function append(arr, other) {
        for (let i = 0; i < other.length; i++) arr.push(other[i]);
      }
      function getLine(arr, index) {
        for (let i = arr.length; i <= index; i++) arr[i] = [];
        return arr[index];
      }
      const LINE_GTR_ZERO =
        "`line` must be greater than 0 (lines start at line 1)";
      const COL_GTR_EQ_ZERO =
        "`column` must be greater than or equal to 0 (columns start at column 0)";
      const LEAST_UPPER_BOUND = -1;
      const GREATEST_LOWER_BOUND = 1;
      class TraceMap {
        constructor(map, mapUrl) {
          const isString = typeof map === "string";
          if (!isString && map._decodedMemo) return map;
          const parsed = isString ? JSON.parse(map) : map;
          const {
            version: version,
            file: file,
            names: names,
            sourceRoot: sourceRoot,
            sources: sources,
            sourcesContent: sourcesContent,
          } = parsed;
          this.version = version;
          this.file = file;
          this.names = names || [];
          this.sourceRoot = sourceRoot;
          this.sources = sources;
          this.sourcesContent = sourcesContent;
          this.ignoreList =
            parsed.ignoreList || parsed.x_google_ignoreList || undefined;
          const from = resolve(sourceRoot || "", stripFilename(mapUrl));
          this.resolvedSources = sources.map((s) => resolve(s || "", from));
          const { mappings: mappings } = parsed;
          if (typeof mappings === "string") {
            this._encoded = mappings;
            this._decoded = undefined;
          } else {
            this._encoded = undefined;
            this._decoded = maybeSort(mappings, isString);
          }
          this._decodedMemo = memoizedState();
          this._bySources = undefined;
          this._bySourceMemos = undefined;
        }
      }
      function cast(map) {
        return map;
      }
      function encodedMappings(map) {
        var _a;
        var _b;
        return (_a = (_b = cast(map))._encoded) !== null && _a !== void 0
          ? _a
          : (_b._encoded = sourcemapCodec.encode(cast(map)._decoded));
      }
      function decodedMappings(map) {
        var _a;
        return (
          (_a = cast(map))._decoded ||
          (_a._decoded = sourcemapCodec.decode(cast(map)._encoded))
        );
      }
      function traceSegment(map, line, column) {
        const decoded = decodedMappings(map);
        if (line >= decoded.length) return null;
        const segments = decoded[line];
        const index = traceSegmentInternal(
          segments,
          cast(map)._decodedMemo,
          line,
          column,
          GREATEST_LOWER_BOUND,
        );
        return index === -1 ? null : segments[index];
      }
      function originalPositionFor(map, needle) {
        let { line: line, column: column, bias: bias } = needle;
        line--;
        if (line < 0) throw new Error(LINE_GTR_ZERO);
        if (column < 0) throw new Error(COL_GTR_EQ_ZERO);
        const decoded = decodedMappings(map);
        if (line >= decoded.length) return OMapping(null, null, null, null);
        const segments = decoded[line];
        const index = traceSegmentInternal(
          segments,
          cast(map)._decodedMemo,
          line,
          column,
          bias || GREATEST_LOWER_BOUND,
        );
        if (index === -1) return OMapping(null, null, null, null);
        const segment = segments[index];
        if (segment.length === 1) return OMapping(null, null, null, null);
        const { names: names, resolvedSources: resolvedSources } = map;
        return OMapping(
          resolvedSources[segment[SOURCES_INDEX]],
          segment[SOURCE_LINE] + 1,
          segment[SOURCE_COLUMN],
          segment.length === 5 ? names[segment[NAMES_INDEX]] : null,
        );
      }
      function generatedPositionFor(map, needle) {
        const {
          source: source,
          line: line,
          column: column,
          bias: bias,
        } = needle;
        return generatedPosition(
          map,
          source,
          line,
          column,
          bias || GREATEST_LOWER_BOUND,
          false,
        );
      }
      function allGeneratedPositionsFor(map, needle) {
        const {
          source: source,
          line: line,
          column: column,
          bias: bias,
        } = needle;
        return generatedPosition(
          map,
          source,
          line,
          column,
          bias || LEAST_UPPER_BOUND,
          true,
        );
      }
      function eachMapping(map, cb) {
        const decoded = decodedMappings(map);
        const { names: names, resolvedSources: resolvedSources } = map;
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            const generatedLine = i + 1;
            const generatedColumn = seg[0];
            let source = null;
            let originalLine = null;
            let originalColumn = null;
            let name = null;
            if (seg.length !== 1) {
              source = resolvedSources[seg[1]];
              originalLine = seg[2] + 1;
              originalColumn = seg[3];
            }
            if (seg.length === 5) name = names[seg[4]];
            cb({
              generatedLine: generatedLine,
              generatedColumn: generatedColumn,
              source: source,
              originalLine: originalLine,
              originalColumn: originalColumn,
              name: name,
            });
          }
        }
      }
      function sourceIndex(map, source) {
        const { sources: sources, resolvedSources: resolvedSources } = map;
        let index = sources.indexOf(source);
        if (index === -1) index = resolvedSources.indexOf(source);
        return index;
      }
      function sourceContentFor(map, source) {
        const { sourcesContent: sourcesContent } = map;
        if (sourcesContent == null) return null;
        const index = sourceIndex(map, source);
        return index === -1 ? null : sourcesContent[index];
      }
      function isIgnored(map, source) {
        const { ignoreList: ignoreList } = map;
        if (ignoreList == null) return false;
        const index = sourceIndex(map, source);
        return index === -1 ? false : ignoreList.includes(index);
      }
      function presortedDecodedMap(map, mapUrl) {
        const tracer = new TraceMap(clone(map, []), mapUrl);
        cast(tracer)._decoded = map.mappings;
        return tracer;
      }
      function decodedMap(map) {
        return clone(map, decodedMappings(map));
      }
      function encodedMap(map) {
        return clone(map, encodedMappings(map));
      }
      function clone(map, mappings) {
        return {
          version: map.version,
          file: map.file,
          names: map.names,
          sourceRoot: map.sourceRoot,
          sources: map.sources,
          sourcesContent: map.sourcesContent,
          mappings: mappings,
          ignoreList: map.ignoreList || map.x_google_ignoreList,
        };
      }
      function OMapping(source, line, column, name) {
        return { source: source, line: line, column: column, name: name };
      }
      function GMapping(line, column) {
        return { line: line, column: column };
      }
      function traceSegmentInternal(segments, memo, line, column, bias) {
        let index = memoizedBinarySearch(segments, column, memo, line);
        if (found) {
          index = (bias === LEAST_UPPER_BOUND ? upperBound : lowerBound)(
            segments,
            column,
            index,
          );
        } else if (bias === LEAST_UPPER_BOUND) index++;
        if (index === -1 || index === segments.length) return -1;
        return index;
      }
      function sliceGeneratedPositions(segments, memo, line, column, bias) {
        let min = traceSegmentInternal(
          segments,
          memo,
          line,
          column,
          GREATEST_LOWER_BOUND,
        );
        if (!found && bias === LEAST_UPPER_BOUND) min++;
        if (min === -1 || min === segments.length) return [];
        const matchedColumn = found ? column : segments[min][COLUMN];
        if (!found) min = lowerBound(segments, matchedColumn, min);
        const max = upperBound(segments, matchedColumn, min);
        const result = [];
        for (; min <= max; min++) {
          const segment = segments[min];
          result.push(
            GMapping(
              segment[REV_GENERATED_LINE] + 1,
              segment[REV_GENERATED_COLUMN],
            ),
          );
        }
        return result;
      }
      function generatedPosition(map, source, line, column, bias, all) {
        var _a;
        line--;
        if (line < 0) throw new Error(LINE_GTR_ZERO);
        if (column < 0) throw new Error(COL_GTR_EQ_ZERO);
        const { sources: sources, resolvedSources: resolvedSources } = map;
        let sourceIndex = sources.indexOf(source);
        if (sourceIndex === -1) sourceIndex = resolvedSources.indexOf(source);
        if (sourceIndex === -1) return all ? [] : GMapping(null, null);
        const generated =
          (_a = cast(map))._bySources ||
          (_a._bySources = buildBySources(
            decodedMappings(map),
            (cast(map)._bySourceMemos = sources.map(memoizedState)),
          ));
        const segments = generated[sourceIndex][line];
        if (segments == null) return all ? [] : GMapping(null, null);
        const memo = cast(map)._bySourceMemos[sourceIndex];
        if (all)
          return sliceGeneratedPositions(segments, memo, line, column, bias);
        const index = traceSegmentInternal(segments, memo, line, column, bias);
        if (index === -1) return GMapping(null, null);
        const segment = segments[index];
        return GMapping(
          segment[REV_GENERATED_LINE] + 1,
          segment[REV_GENERATED_COLUMN],
        );
      }
      exports.AnyMap = AnyMap;
      exports.GREATEST_LOWER_BOUND = GREATEST_LOWER_BOUND;
      exports.LEAST_UPPER_BOUND = LEAST_UPPER_BOUND;
      exports.TraceMap = TraceMap;
      exports.allGeneratedPositionsFor = allGeneratedPositionsFor;
      exports.decodedMap = decodedMap;
      exports.decodedMappings = decodedMappings;
      exports.eachMapping = eachMapping;
      exports.encodedMap = encodedMap;
      exports.encodedMappings = encodedMappings;
      exports.generatedPositionFor = generatedPositionFor;
      exports.isIgnored = isIgnored;
      exports.originalPositionFor = originalPositionFor;
      exports.presortedDecodedMap = presortedDecodedMap;
      exports.sourceContentFor = sourceContentFor;
      exports.traceSegment = traceSegment;
    });
  })(traceMapping_umd$1, traceMapping_umd$1.exports);
  return traceMapping_umd$1.exports;
}
var hasRequiredGenMapping_umd;
function requireGenMapping_umd() {
  if (hasRequiredGenMapping_umd) return genMapping_umd.exports;
  hasRequiredGenMapping_umd = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(
        exports,
        requireSetArray_umd(),
        requireSourcemapCodec_umd$2(),
        requireTraceMapping_umd$1(),
      );
    })(
      commonjsGlobal,
      function (exports, setArray, sourcemapCodec, traceMapping) {
        const COLUMN = 0;
        const SOURCES_INDEX = 1;
        const SOURCE_LINE = 2;
        const SOURCE_COLUMN = 3;
        const NAMES_INDEX = 4;
        const NO_NAME = -1;
        class GenMapping {
          constructor({ file: file, sourceRoot: sourceRoot } = {}) {
            this._names = new setArray.SetArray();
            this._sources = new setArray.SetArray();
            this._sourcesContent = [];
            this._mappings = [];
            this.file = file;
            this.sourceRoot = sourceRoot;
            this._ignoreList = new setArray.SetArray();
          }
        }
        function cast(map) {
          return map;
        }
        function addSegment(
          map,
          genLine,
          genColumn,
          source,
          sourceLine,
          sourceColumn,
          name,
          content,
        ) {
          return addSegmentInternal(
            false,
            map,
            genLine,
            genColumn,
            source,
            sourceLine,
            sourceColumn,
            name,
            content,
          );
        }
        function addMapping(map, mapping) {
          return addMappingInternal(false, map, mapping);
        }
        const maybeAddSegment = (
          map,
          genLine,
          genColumn,
          source,
          sourceLine,
          sourceColumn,
          name,
          content,
        ) =>
          addSegmentInternal(
            true,
            map,
            genLine,
            genColumn,
            source,
            sourceLine,
            sourceColumn,
            name,
            content,
          );
        const maybeAddMapping = (map, mapping) =>
          addMappingInternal(true, map, mapping);
        function setSourceContent(map, source, content) {
          const { _sources: sources, _sourcesContent: sourcesContent } =
            cast(map);
          const index = setArray.put(sources, source);
          sourcesContent[index] = content;
        }
        function setIgnore(map, source, ignore = true) {
          const {
            _sources: sources,
            _sourcesContent: sourcesContent,
            _ignoreList: ignoreList,
          } = cast(map);
          const index = setArray.put(sources, source);
          if (index === sourcesContent.length) sourcesContent[index] = null;
          if (ignore) setArray.put(ignoreList, index);
          else setArray.remove(ignoreList, index);
        }
        function toDecodedMap(map) {
          const {
            _mappings: mappings,
            _sources: sources,
            _sourcesContent: sourcesContent,
            _names: names,
            _ignoreList: ignoreList,
          } = cast(map);
          removeEmptyFinalLines(mappings);
          return {
            version: 3,
            file: map.file || undefined,
            names: names.array,
            sourceRoot: map.sourceRoot || undefined,
            sources: sources.array,
            sourcesContent: sourcesContent,
            mappings: mappings,
            ignoreList: ignoreList.array,
          };
        }
        function toEncodedMap(map) {
          const decoded = toDecodedMap(map);
          return Object.assign(Object.assign({}, decoded), {
            mappings: sourcemapCodec.encode(decoded.mappings),
          });
        }
        function fromMap(input) {
          const map = new traceMapping.TraceMap(input);
          const gen = new GenMapping({
            file: map.file,
            sourceRoot: map.sourceRoot,
          });
          putAll(cast(gen)._names, map.names);
          putAll(cast(gen)._sources, map.sources);
          cast(gen)._sourcesContent =
            map.sourcesContent || map.sources.map(() => null);
          cast(gen)._mappings = traceMapping.decodedMappings(map);
          if (map.ignoreList) putAll(cast(gen)._ignoreList, map.ignoreList);
          return gen;
        }
        function allMappings(map) {
          const out = [];
          const {
            _mappings: mappings,
            _sources: sources,
            _names: names,
          } = cast(map);
          for (let i = 0; i < mappings.length; i++) {
            const line = mappings[i];
            for (let j = 0; j < line.length; j++) {
              const seg = line[j];
              const generated = { line: i + 1, column: seg[COLUMN] };
              let source = undefined;
              let original = undefined;
              let name = undefined;
              if (seg.length !== 1) {
                source = sources.array[seg[SOURCES_INDEX]];
                original = {
                  line: seg[SOURCE_LINE] + 1,
                  column: seg[SOURCE_COLUMN],
                };
                if (seg.length === 5) name = names.array[seg[NAMES_INDEX]];
              }
              out.push({
                generated: generated,
                source: source,
                original: original,
                name: name,
              });
            }
          }
          return out;
        }
        function addSegmentInternal(
          skipable,
          map,
          genLine,
          genColumn,
          source,
          sourceLine,
          sourceColumn,
          name,
          content,
        ) {
          const {
            _mappings: mappings,
            _sources: sources,
            _sourcesContent: sourcesContent,
            _names: names,
          } = cast(map);
          const line = getLine(mappings, genLine);
          const index = getColumnIndex(line, genColumn);
          if (!source) {
            if (skipable && skipSourceless(line, index)) return;
            return insert(line, index, [genColumn]);
          }
          const sourcesIndex = setArray.put(sources, source);
          const namesIndex = name ? setArray.put(names, name) : NO_NAME;
          if (sourcesIndex === sourcesContent.length)
            sourcesContent[sourcesIndex] =
              content !== null && content !== void 0 ? content : null;
          if (
            skipable &&
            skipSource(
              line,
              index,
              sourcesIndex,
              sourceLine,
              sourceColumn,
              namesIndex,
            )
          ) {
            return;
          }
          return insert(
            line,
            index,
            name
              ? [genColumn, sourcesIndex, sourceLine, sourceColumn, namesIndex]
              : [genColumn, sourcesIndex, sourceLine, sourceColumn],
          );
        }
        function getLine(mappings, index) {
          for (let i = mappings.length; i <= index; i++) {
            mappings[i] = [];
          }
          return mappings[index];
        }
        function getColumnIndex(line, genColumn) {
          let index = line.length;
          for (let i = index - 1; i >= 0; index = i--) {
            const current = line[i];
            if (genColumn >= current[COLUMN]) break;
          }
          return index;
        }
        function insert(array, index, value) {
          for (let i = array.length; i > index; i--) {
            array[i] = array[i - 1];
          }
          array[index] = value;
        }
        function removeEmptyFinalLines(mappings) {
          const { length: length } = mappings;
          let len = length;
          for (let i = len - 1; i >= 0; len = i, i--) {
            if (mappings[i].length > 0) break;
          }
          if (len < length) mappings.length = len;
        }
        function putAll(setarr, array) {
          for (let i = 0; i < array.length; i++) setArray.put(setarr, array[i]);
        }
        function skipSourceless(line, index) {
          if (index === 0) return true;
          const prev = line[index - 1];
          return prev.length === 1;
        }
        function skipSource(
          line,
          index,
          sourcesIndex,
          sourceLine,
          sourceColumn,
          namesIndex,
        ) {
          if (index === 0) return false;
          const prev = line[index - 1];
          if (prev.length === 1) return false;
          return (
            sourcesIndex === prev[SOURCES_INDEX] &&
            sourceLine === prev[SOURCE_LINE] &&
            sourceColumn === prev[SOURCE_COLUMN] &&
            namesIndex === (prev.length === 5 ? prev[NAMES_INDEX] : NO_NAME)
          );
        }
        function addMappingInternal(skipable, map, mapping) {
          const {
            generated: generated,
            source: source,
            original: original,
            name: name,
            content: content,
          } = mapping;
          if (!source) {
            return addSegmentInternal(
              skipable,
              map,
              generated.line - 1,
              generated.column,
              null,
              null,
              null,
              null,
              null,
            );
          }
          return addSegmentInternal(
            skipable,
            map,
            generated.line - 1,
            generated.column,
            source,
            original.line - 1,
            original.column,
            name,
            content,
          );
        }
        exports.GenMapping = GenMapping;
        exports.addMapping = addMapping;
        exports.addSegment = addSegment;
        exports.allMappings = allMappings;
        exports.fromMap = fromMap;
        exports.maybeAddMapping = maybeAddMapping;
        exports.maybeAddSegment = maybeAddSegment;
        exports.setIgnore = setIgnore;
        exports.setSourceContent = setSourceContent;
        exports.toDecodedMap = toDecodedMap;
        exports.toEncodedMap = toEncodedMap;
        Object.defineProperty(exports, "__esModule", { value: true });
      },
    );
  })(genMapping_umd, genMapping_umd.exports);
  return genMapping_umd.exports;
}
var traceMapping_umd = { exports: {} };
var sourcemapCodec_umd = { exports: {} };
var hasRequiredSourcemapCodec_umd;
function requireSourcemapCodec_umd() {
  if (hasRequiredSourcemapCodec_umd) return sourcemapCodec_umd.exports;
  hasRequiredSourcemapCodec_umd = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(exports);
    })(commonjsGlobal, function (exports) {
      const comma = ",".charCodeAt(0);
      const semicolon = ";".charCodeAt(0);
      const chars =
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
      const intToChar = new Uint8Array(64);
      const charToInt = new Uint8Array(128);
      for (let i = 0; i < chars.length; i++) {
        const c = chars.charCodeAt(i);
        intToChar[i] = c;
        charToInt[c] = i;
      }
      const td =
        typeof TextDecoder !== "undefined"
          ? new TextDecoder()
          : typeof Buffer !== "undefined"
            ? {
                decode(buf) {
                  const out = Buffer.from(
                    buf.buffer,
                    buf.byteOffset,
                    buf.byteLength,
                  );
                  return out.toString();
                },
              }
            : {
                decode(buf) {
                  let out = "";
                  for (let i = 0; i < buf.length; i++) {
                    out += String.fromCharCode(buf[i]);
                  }
                  return out;
                },
              };
      function decode(mappings) {
        const state = new Int32Array(5);
        const decoded = [];
        let index = 0;
        do {
          const semi = indexOf(mappings, index);
          const line = [];
          let sorted = true;
          let lastCol = 0;
          state[0] = 0;
          for (let i = index; i < semi; i++) {
            let seg;
            i = decodeInteger(mappings, i, state, 0);
            const col = state[0];
            if (col < lastCol) sorted = false;
            lastCol = col;
            if (hasMoreVlq(mappings, i, semi)) {
              i = decodeInteger(mappings, i, state, 1);
              i = decodeInteger(mappings, i, state, 2);
              i = decodeInteger(mappings, i, state, 3);
              if (hasMoreVlq(mappings, i, semi)) {
                i = decodeInteger(mappings, i, state, 4);
                seg = [col, state[1], state[2], state[3], state[4]];
              } else {
                seg = [col, state[1], state[2], state[3]];
              }
            } else {
              seg = [col];
            }
            line.push(seg);
          }
          if (!sorted) sort(line);
          decoded.push(line);
          index = semi + 1;
        } while (index <= mappings.length);
        return decoded;
      }
      function indexOf(mappings, index) {
        const idx = mappings.indexOf(";", index);
        return idx === -1 ? mappings.length : idx;
      }
      function decodeInteger(mappings, pos, state, j) {
        let value = 0;
        let shift = 0;
        let integer = 0;
        do {
          const c = mappings.charCodeAt(pos++);
          integer = charToInt[c];
          value |= (integer & 31) << shift;
          shift += 5;
        } while (integer & 32);
        const shouldNegate = value & 1;
        value >>>= 1;
        if (shouldNegate) {
          value = -2147483648 | -value;
        }
        state[j] += value;
        return pos;
      }
      function hasMoreVlq(mappings, i, length) {
        if (i >= length) return false;
        return mappings.charCodeAt(i) !== comma;
      }
      function sort(line) {
        line.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[0] - b[0];
      }
      function encode(decoded) {
        const state = new Int32Array(5);
        const bufLength = 1024 * 16;
        const subLength = bufLength - 36;
        const buf = new Uint8Array(bufLength);
        const sub = buf.subarray(0, subLength);
        let pos = 0;
        let out = "";
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          if (i > 0) {
            if (pos === bufLength) {
              out += td.decode(buf);
              pos = 0;
            }
            buf[pos++] = semicolon;
          }
          if (line.length === 0) continue;
          state[0] = 0;
          for (let j = 0; j < line.length; j++) {
            const segment = line[j];
            if (pos > subLength) {
              out += td.decode(sub);
              buf.copyWithin(0, subLength, pos);
              pos -= subLength;
            }
            if (j > 0) buf[pos++] = comma;
            pos = encodeInteger(buf, pos, state, segment, 0);
            if (segment.length === 1) continue;
            pos = encodeInteger(buf, pos, state, segment, 1);
            pos = encodeInteger(buf, pos, state, segment, 2);
            pos = encodeInteger(buf, pos, state, segment, 3);
            if (segment.length === 4) continue;
            pos = encodeInteger(buf, pos, state, segment, 4);
          }
        }
        return out + td.decode(buf.subarray(0, pos));
      }
      function encodeInteger(buf, pos, state, segment, j) {
        const next = segment[j];
        let num = next - state[j];
        state[j] = next;
        num = num < 0 ? (-num << 1) | 1 : num << 1;
        do {
          let clamped = num & 31;
          num >>>= 5;
          if (num > 0) clamped |= 32;
          buf[pos++] = intToChar[clamped];
        } while (num > 0);
        return pos;
      }
      exports.decode = decode;
      exports.encode = encode;
      Object.defineProperty(exports, "__esModule", { value: true });
    });
  })(sourcemapCodec_umd, sourcemapCodec_umd.exports);
  return sourcemapCodec_umd.exports;
}
var resolveUri_umd = { exports: {} };
var hasRequiredResolveUri_umd;
function requireResolveUri_umd() {
  if (hasRequiredResolveUri_umd) return resolveUri_umd.exports;
  hasRequiredResolveUri_umd = 1;
  (function (module, exports) {
    (function (global, factory) {
      module.exports = factory();
    })(commonjsGlobal, function () {
      const schemeRegex = /^[\w+.-]+:\/\//;
      const urlRegex =
        /^([\w+.-]+:)\/\/([^@/#?]*@)?([^:/#?]*)(:\d+)?(\/[^#?]*)?(\?[^#]*)?(#.*)?/;
      const fileRegex =
        /^file:(?:\/\/((?![a-z]:)[^/#?]*)?)?(\/?[^#?]*)(\?[^#]*)?(#.*)?/i;
      function isAbsoluteUrl(input) {
        return schemeRegex.test(input);
      }
      function isSchemeRelativeUrl(input) {
        return input.startsWith("//");
      }
      function isAbsolutePath(input) {
        return input.startsWith("/");
      }
      function isFileUrl(input) {
        return input.startsWith("file:");
      }
      function isRelative(input) {
        return /^[.?#]/.test(input);
      }
      function parseAbsoluteUrl(input) {
        const match = urlRegex.exec(input);
        return makeUrl(
          match[1],
          match[2] || "",
          match[3],
          match[4] || "",
          match[5] || "/",
          match[6] || "",
          match[7] || "",
        );
      }
      function parseFileUrl(input) {
        const match = fileRegex.exec(input);
        const path = match[2];
        return makeUrl(
          "file:",
          "",
          match[1] || "",
          "",
          isAbsolutePath(path) ? path : "/" + path,
          match[3] || "",
          match[4] || "",
        );
      }
      function makeUrl(scheme, user, host, port, path, query, hash) {
        return {
          scheme: scheme,
          user: user,
          host: host,
          port: port,
          path: path,
          query: query,
          hash: hash,
          type: 7,
        };
      }
      function parseUrl(input) {
        if (isSchemeRelativeUrl(input)) {
          const url = parseAbsoluteUrl("http:" + input);
          url.scheme = "";
          url.type = 6;
          return url;
        }
        if (isAbsolutePath(input)) {
          const url = parseAbsoluteUrl("http://foo.com" + input);
          url.scheme = "";
          url.host = "";
          url.type = 5;
          return url;
        }
        if (isFileUrl(input)) return parseFileUrl(input);
        if (isAbsoluteUrl(input)) return parseAbsoluteUrl(input);
        const url = parseAbsoluteUrl("http://foo.com/" + input);
        url.scheme = "";
        url.host = "";
        url.type = input
          ? input.startsWith("?")
            ? 3
            : input.startsWith("#")
              ? 2
              : 4
          : 1;
        return url;
      }
      function stripPathFilename(path) {
        if (path.endsWith("/..")) return path;
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      function mergePaths(url, base) {
        normalizePath(base, base.type);
        if (url.path === "/") {
          url.path = base.path;
        } else {
          url.path = stripPathFilename(base.path) + url.path;
        }
      }
      function normalizePath(url, type) {
        const rel = type <= 4;
        const pieces = url.path.split("/");
        let pointer = 1;
        let positive = 0;
        let addTrailingSlash = false;
        for (let i = 1; i < pieces.length; i++) {
          const piece = pieces[i];
          if (!piece) {
            addTrailingSlash = true;
            continue;
          }
          addTrailingSlash = false;
          if (piece === ".") continue;
          if (piece === "..") {
            if (positive) {
              addTrailingSlash = true;
              positive--;
              pointer--;
            } else if (rel) {
              pieces[pointer++] = piece;
            }
            continue;
          }
          pieces[pointer++] = piece;
          positive++;
        }
        let path = "";
        for (let i = 1; i < pointer; i++) {
          path += "/" + pieces[i];
        }
        if (!path || (addTrailingSlash && !path.endsWith("/.."))) {
          path += "/";
        }
        url.path = path;
      }
      function resolve(input, base) {
        if (!input && !base) return "";
        const url = parseUrl(input);
        let inputType = url.type;
        if (base && inputType !== 7) {
          const baseUrl = parseUrl(base);
          const baseType = baseUrl.type;
          switch (inputType) {
            case 1:
              url.hash = baseUrl.hash;
            case 2:
              url.query = baseUrl.query;
            case 3:
            case 4:
              mergePaths(url, baseUrl);
            case 5:
              url.user = baseUrl.user;
              url.host = baseUrl.host;
              url.port = baseUrl.port;
            case 6:
              url.scheme = baseUrl.scheme;
          }
          if (baseType > inputType) inputType = baseType;
        }
        normalizePath(url, inputType);
        const queryHash = url.query + url.hash;
        switch (inputType) {
          case 2:
          case 3:
            return queryHash;
          case 4: {
            const path = url.path.slice(1);
            if (!path) return queryHash || ".";
            if (isRelative(base || input) && !isRelative(path)) {
              return "./" + path + queryHash;
            }
            return path + queryHash;
          }
          case 5:
            return url.path + queryHash;
          default:
            return (
              url.scheme +
              "//" +
              url.user +
              url.host +
              url.port +
              url.path +
              queryHash
            );
        }
      }
      return resolve;
    });
  })(resolveUri_umd);
  return resolveUri_umd.exports;
}
var hasRequiredTraceMapping_umd;
function requireTraceMapping_umd() {
  if (hasRequiredTraceMapping_umd) return traceMapping_umd.exports;
  hasRequiredTraceMapping_umd = 1;
  (function (module, exports) {
    (function (global, factory) {
      factory(exports, requireSourcemapCodec_umd(), requireResolveUri_umd());
    })(commonjsGlobal, function (exports, sourcemapCodec, resolveUri) {
      function resolve(input, base) {
        if (base && !base.endsWith("/")) base += "/";
        return resolveUri(input, base);
      }
      function stripFilename(path) {
        if (!path) return "";
        const index = path.lastIndexOf("/");
        return path.slice(0, index + 1);
      }
      const COLUMN = 0;
      const SOURCES_INDEX = 1;
      const SOURCE_LINE = 2;
      const SOURCE_COLUMN = 3;
      const NAMES_INDEX = 4;
      const REV_GENERATED_LINE = 1;
      const REV_GENERATED_COLUMN = 2;
      function maybeSort(mappings, owned) {
        const unsortedIndex = nextUnsortedSegmentLine(mappings, 0);
        if (unsortedIndex === mappings.length) return mappings;
        if (!owned) mappings = mappings.slice();
        for (
          let i = unsortedIndex;
          i < mappings.length;
          i = nextUnsortedSegmentLine(mappings, i + 1)
        ) {
          mappings[i] = sortSegments(mappings[i], owned);
        }
        return mappings;
      }
      function nextUnsortedSegmentLine(mappings, start) {
        for (let i = start; i < mappings.length; i++) {
          if (!isSorted(mappings[i])) return i;
        }
        return mappings.length;
      }
      function isSorted(line) {
        for (let j = 1; j < line.length; j++) {
          if (line[j][COLUMN] < line[j - 1][COLUMN]) {
            return false;
          }
        }
        return true;
      }
      function sortSegments(line, owned) {
        if (!owned) line = line.slice();
        return line.sort(sortComparator);
      }
      function sortComparator(a, b) {
        return a[COLUMN] - b[COLUMN];
      }
      let found = false;
      function binarySearch(haystack, needle, low, high) {
        while (low <= high) {
          const mid = low + ((high - low) >> 1);
          const cmp = haystack[mid][COLUMN] - needle;
          if (cmp === 0) {
            found = true;
            return mid;
          }
          if (cmp < 0) {
            low = mid + 1;
          } else {
            high = mid - 1;
          }
        }
        found = false;
        return low - 1;
      }
      function upperBound(haystack, needle, index) {
        for (let i = index + 1; i < haystack.length; index = i++) {
          if (haystack[i][COLUMN] !== needle) break;
        }
        return index;
      }
      function lowerBound(haystack, needle, index) {
        for (let i = index - 1; i >= 0; index = i--) {
          if (haystack[i][COLUMN] !== needle) break;
        }
        return index;
      }
      function memoizedState() {
        return { lastKey: -1, lastNeedle: -1, lastIndex: -1 };
      }
      function memoizedBinarySearch(haystack, needle, state, key) {
        const {
          lastKey: lastKey,
          lastNeedle: lastNeedle,
          lastIndex: lastIndex,
        } = state;
        let low = 0;
        let high = haystack.length - 1;
        if (key === lastKey) {
          if (needle === lastNeedle) {
            found = lastIndex !== -1 && haystack[lastIndex][COLUMN] === needle;
            return lastIndex;
          }
          if (needle >= lastNeedle) {
            low = lastIndex === -1 ? 0 : lastIndex;
          } else {
            high = lastIndex;
          }
        }
        state.lastKey = key;
        state.lastNeedle = needle;
        return (state.lastIndex = binarySearch(haystack, needle, low, high));
      }
      function buildBySources(decoded, memos) {
        const sources = memos.map(buildNullArray);
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            if (seg.length === 1) continue;
            const sourceIndex = seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            const originalSource = sources[sourceIndex];
            const originalLine =
              originalSource[sourceLine] || (originalSource[sourceLine] = []);
            const memo = memos[sourceIndex];
            let index = upperBound(
              originalLine,
              sourceColumn,
              memoizedBinarySearch(
                originalLine,
                sourceColumn,
                memo,
                sourceLine,
              ),
            );
            memo.lastIndex = ++index;
            insert(originalLine, index, [sourceColumn, i, seg[COLUMN]]);
          }
        }
        return sources;
      }
      function insert(array, index, value) {
        for (let i = array.length; i > index; i--) {
          array[i] = array[i - 1];
        }
        array[index] = value;
      }
      function buildNullArray() {
        return { __proto__: null };
      }
      const AnyMap = function (map, mapUrl) {
        const parsed = parse(map);
        if (!("sections" in parsed)) {
          return new TraceMap(parsed, mapUrl);
        }
        const mappings = [];
        const sources = [];
        const sourcesContent = [];
        const names = [];
        const ignoreList = [];
        recurse(
          parsed,
          mapUrl,
          mappings,
          sources,
          sourcesContent,
          names,
          ignoreList,
          0,
          0,
          Infinity,
          Infinity,
        );
        const joined = {
          version: 3,
          file: parsed.file,
          names: names,
          sources: sources,
          sourcesContent: sourcesContent,
          mappings: mappings,
          ignoreList: ignoreList,
        };
        return presortedDecodedMap(joined);
      };
      function parse(map) {
        return typeof map === "string" ? JSON.parse(map) : map;
      }
      function recurse(
        input,
        mapUrl,
        mappings,
        sources,
        sourcesContent,
        names,
        ignoreList,
        lineOffset,
        columnOffset,
        stopLine,
        stopColumn,
      ) {
        const { sections: sections } = input;
        for (let i = 0; i < sections.length; i++) {
          const { map: map, offset: offset } = sections[i];
          let sl = stopLine;
          let sc = stopColumn;
          if (i + 1 < sections.length) {
            const nextOffset = sections[i + 1].offset;
            sl = Math.min(stopLine, lineOffset + nextOffset.line);
            if (sl === stopLine) {
              sc = Math.min(stopColumn, columnOffset + nextOffset.column);
            } else if (sl < stopLine) {
              sc = columnOffset + nextOffset.column;
            }
          }
          addSection(
            map,
            mapUrl,
            mappings,
            sources,
            sourcesContent,
            names,
            ignoreList,
            lineOffset + offset.line,
            columnOffset + offset.column,
            sl,
            sc,
          );
        }
      }
      function addSection(
        input,
        mapUrl,
        mappings,
        sources,
        sourcesContent,
        names,
        ignoreList,
        lineOffset,
        columnOffset,
        stopLine,
        stopColumn,
      ) {
        const parsed = parse(input);
        if ("sections" in parsed) return recurse(...arguments);
        const map = new TraceMap(parsed, mapUrl);
        const sourcesOffset = sources.length;
        const namesOffset = names.length;
        const decoded = decodedMappings(map);
        const {
          resolvedSources: resolvedSources,
          sourcesContent: contents,
          ignoreList: ignores,
        } = map;
        append(sources, resolvedSources);
        append(names, map.names);
        if (contents) append(sourcesContent, contents);
        else
          for (let i = 0; i < resolvedSources.length; i++)
            sourcesContent.push(null);
        if (ignores)
          for (let i = 0; i < ignores.length; i++)
            ignoreList.push(ignores[i] + sourcesOffset);
        for (let i = 0; i < decoded.length; i++) {
          const lineI = lineOffset + i;
          if (lineI > stopLine) return;
          const out = getLine(mappings, lineI);
          const cOffset = i === 0 ? columnOffset : 0;
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            const column = cOffset + seg[COLUMN];
            if (lineI === stopLine && column >= stopColumn) return;
            if (seg.length === 1) {
              out.push([column]);
              continue;
            }
            const sourcesIndex = sourcesOffset + seg[SOURCES_INDEX];
            const sourceLine = seg[SOURCE_LINE];
            const sourceColumn = seg[SOURCE_COLUMN];
            out.push(
              seg.length === 4
                ? [column, sourcesIndex, sourceLine, sourceColumn]
                : [
                    column,
                    sourcesIndex,
                    sourceLine,
                    sourceColumn,
                    namesOffset + seg[NAMES_INDEX],
                  ],
            );
          }
        }
      }
      function append(arr, other) {
        for (let i = 0; i < other.length; i++) arr.push(other[i]);
      }
      function getLine(arr, index) {
        for (let i = arr.length; i <= index; i++) arr[i] = [];
        return arr[index];
      }
      const LINE_GTR_ZERO =
        "`line` must be greater than 0 (lines start at line 1)";
      const COL_GTR_EQ_ZERO =
        "`column` must be greater than or equal to 0 (columns start at column 0)";
      const LEAST_UPPER_BOUND = -1;
      const GREATEST_LOWER_BOUND = 1;
      class TraceMap {
        constructor(map, mapUrl) {
          const isString = typeof map === "string";
          if (!isString && map._decodedMemo) return map;
          const parsed = isString ? JSON.parse(map) : map;
          const {
            version: version,
            file: file,
            names: names,
            sourceRoot: sourceRoot,
            sources: sources,
            sourcesContent: sourcesContent,
          } = parsed;
          this.version = version;
          this.file = file;
          this.names = names || [];
          this.sourceRoot = sourceRoot;
          this.sources = sources;
          this.sourcesContent = sourcesContent;
          this.ignoreList =
            parsed.ignoreList || parsed.x_google_ignoreList || undefined;
          const from = resolve(sourceRoot || "", stripFilename(mapUrl));
          this.resolvedSources = sources.map((s) => resolve(s || "", from));
          const { mappings: mappings } = parsed;
          if (typeof mappings === "string") {
            this._encoded = mappings;
            this._decoded = undefined;
          } else {
            this._encoded = undefined;
            this._decoded = maybeSort(mappings, isString);
          }
          this._decodedMemo = memoizedState();
          this._bySources = undefined;
          this._bySourceMemos = undefined;
        }
      }
      function cast(map) {
        return map;
      }
      function encodedMappings(map) {
        var _a;
        var _b;
        return (_a = (_b = cast(map))._encoded) !== null && _a !== void 0
          ? _a
          : (_b._encoded = sourcemapCodec.encode(cast(map)._decoded));
      }
      function decodedMappings(map) {
        var _a;
        return (
          (_a = cast(map))._decoded ||
          (_a._decoded = sourcemapCodec.decode(cast(map)._encoded))
        );
      }
      function traceSegment(map, line, column) {
        const decoded = decodedMappings(map);
        if (line >= decoded.length) return null;
        const segments = decoded[line];
        const index = traceSegmentInternal(
          segments,
          cast(map)._decodedMemo,
          line,
          column,
          GREATEST_LOWER_BOUND,
        );
        return index === -1 ? null : segments[index];
      }
      function originalPositionFor(map, needle) {
        let { line: line, column: column, bias: bias } = needle;
        line--;
        if (line < 0) throw new Error(LINE_GTR_ZERO);
        if (column < 0) throw new Error(COL_GTR_EQ_ZERO);
        const decoded = decodedMappings(map);
        if (line >= decoded.length) return OMapping(null, null, null, null);
        const segments = decoded[line];
        const index = traceSegmentInternal(
          segments,
          cast(map)._decodedMemo,
          line,
          column,
          bias || GREATEST_LOWER_BOUND,
        );
        if (index === -1) return OMapping(null, null, null, null);
        const segment = segments[index];
        if (segment.length === 1) return OMapping(null, null, null, null);
        const { names: names, resolvedSources: resolvedSources } = map;
        return OMapping(
          resolvedSources[segment[SOURCES_INDEX]],
          segment[SOURCE_LINE] + 1,
          segment[SOURCE_COLUMN],
          segment.length === 5 ? names[segment[NAMES_INDEX]] : null,
        );
      }
      function generatedPositionFor(map, needle) {
        const {
          source: source,
          line: line,
          column: column,
          bias: bias,
        } = needle;
        return generatedPosition(
          map,
          source,
          line,
          column,
          bias || GREATEST_LOWER_BOUND,
          false,
        );
      }
      function allGeneratedPositionsFor(map, needle) {
        const {
          source: source,
          line: line,
          column: column,
          bias: bias,
        } = needle;
        return generatedPosition(
          map,
          source,
          line,
          column,
          bias || LEAST_UPPER_BOUND,
          true,
        );
      }
      function eachMapping(map, cb) {
        const decoded = decodedMappings(map);
        const { names: names, resolvedSources: resolvedSources } = map;
        for (let i = 0; i < decoded.length; i++) {
          const line = decoded[i];
          for (let j = 0; j < line.length; j++) {
            const seg = line[j];
            const generatedLine = i + 1;
            const generatedColumn = seg[0];
            let source = null;
            let originalLine = null;
            let originalColumn = null;
            let name = null;
            if (seg.length !== 1) {
              source = resolvedSources[seg[1]];
              originalLine = seg[2] + 1;
              originalColumn = seg[3];
            }
            if (seg.length === 5) name = names[seg[4]];
            cb({
              generatedLine: generatedLine,
              generatedColumn: generatedColumn,
              source: source,
              originalLine: originalLine,
              originalColumn: originalColumn,
              name: name,
            });
          }
        }
      }
      function sourceIndex(map, source) {
        const { sources: sources, resolvedSources: resolvedSources } = map;
        let index = sources.indexOf(source);
        if (index === -1) index = resolvedSources.indexOf(source);
        return index;
      }
      function sourceContentFor(map, source) {
        const { sourcesContent: sourcesContent } = map;
        if (sourcesContent == null) return null;
        const index = sourceIndex(map, source);
        return index === -1 ? null : sourcesContent[index];
      }
      function isIgnored(map, source) {
        const { ignoreList: ignoreList } = map;
        if (ignoreList == null) return false;
        const index = sourceIndex(map, source);
        return index === -1 ? false : ignoreList.includes(index);
      }
      function presortedDecodedMap(map, mapUrl) {
        const tracer = new TraceMap(clone(map, []), mapUrl);
        cast(tracer)._decoded = map.mappings;
        return tracer;
      }
      function decodedMap(map) {
        return clone(map, decodedMappings(map));
      }
      function encodedMap(map) {
        return clone(map, encodedMappings(map));
      }
      function clone(map, mappings) {
        return {
          version: map.version,
          file: map.file,
          names: map.names,
          sourceRoot: map.sourceRoot,
          sources: map.sources,
          sourcesContent: map.sourcesContent,
          mappings: mappings,
          ignoreList: map.ignoreList || map.x_google_ignoreList,
        };
      }
      function OMapping(source, line, column, name) {
        return { source: source, line: line, column: column, name: name };
      }
      function GMapping(line, column) {
        return { line: line, column: column };
      }
      function traceSegmentInternal(segments, memo, line, column, bias) {
        let index = memoizedBinarySearch(segments, column, memo, line);
        if (found) {
          index = (bias === LEAST_UPPER_BOUND ? upperBound : lowerBound)(
            segments,
            column,
            index,
          );
        } else if (bias === LEAST_UPPER_BOUND) index++;
        if (index === -1 || index === segments.length) return -1;
        return index;
      }
      function sliceGeneratedPositions(segments, memo, line, column, bias) {
        let min = traceSegmentInternal(
          segments,
          memo,
          line,
          column,
          GREATEST_LOWER_BOUND,
        );
        if (!found && bias === LEAST_UPPER_BOUND) min++;
        if (min === -1 || min === segments.length) return [];
        const matchedColumn = found ? column : segments[min][COLUMN];
        if (!found) min = lowerBound(segments, matchedColumn, min);
        const max = upperBound(segments, matchedColumn, min);
        const result = [];
        for (; min <= max; min++) {
          const segment = segments[min];
          result.push(
            GMapping(
              segment[REV_GENERATED_LINE] + 1,
              segment[REV_GENERATED_COLUMN],
            ),
          );
        }
        return result;
      }
      function generatedPosition(map, source, line, column, bias, all) {
        var _a;
        line--;
        if (line < 0) throw new Error(LINE_GTR_ZERO);
        if (column < 0) throw new Error(COL_GTR_EQ_ZERO);
        const { sources: sources, resolvedSources: resolvedSources } = map;
        let sourceIndex = sources.indexOf(source);
        if (sourceIndex === -1) sourceIndex = resolvedSources.indexOf(source);
        if (sourceIndex === -1) return all ? [] : GMapping(null, null);
        const generated =
          (_a = cast(map))._bySources ||
          (_a._bySources = buildBySources(
            decodedMappings(map),
            (cast(map)._bySourceMemos = sources.map(memoizedState)),
          ));
        const segments = generated[sourceIndex][line];
        if (segments == null) return all ? [] : GMapping(null, null);
        const memo = cast(map)._bySourceMemos[sourceIndex];
        if (all)
          return sliceGeneratedPositions(segments, memo, line, column, bias);
        const index = traceSegmentInternal(segments, memo, line, column, bias);
        if (index === -1) return GMapping(null, null);
        const segment = segments[index];
        return GMapping(
          segment[REV_GENERATED_LINE] + 1,
          segment[REV_GENERATED_COLUMN],
        );
      }
      exports.AnyMap = AnyMap;
      exports.GREATEST_LOWER_BOUND = GREATEST_LOWER_BOUND;
      exports.LEAST_UPPER_BOUND = LEAST_UPPER_BOUND;
      exports.TraceMap = TraceMap;
      exports.allGeneratedPositionsFor = allGeneratedPositionsFor;
      exports.decodedMap = decodedMap;
      exports.decodedMappings = decodedMappings;
      exports.eachMapping = eachMapping;
      exports.encodedMap = encodedMap;
      exports.encodedMappings = encodedMappings;
      exports.generatedPositionFor = generatedPositionFor;
      exports.isIgnored = isIgnored;
      exports.originalPositionFor = originalPositionFor;
      exports.presortedDecodedMap = presortedDecodedMap;
      exports.sourceContentFor = sourceContentFor;
      exports.traceSegment = traceSegment;
    });
  })(traceMapping_umd, traceMapping_umd.exports);
  return traceMapping_umd.exports;
}
var hasRequiredSourceMap$2;
function requireSourceMap$2() {
  if (hasRequiredSourceMap$2) return sourceMap$3;
  hasRequiredSourceMap$2 = 1;
  Object.defineProperty(sourceMap$3, "__esModule", { value: true });
  sourceMap$3.default = void 0;
  var _genMapping = requireGenMapping_umd();
  var _traceMapping = requireTraceMapping_umd();
  class SourceMap {
    constructor(opts, code) {
      var _opts$sourceFileName;
      this._map = void 0;
      this._rawMappings = void 0;
      this._sourceFileName = void 0;
      this._lastGenLine = 0;
      this._lastSourceLine = 0;
      this._lastSourceColumn = 0;
      this._inputMap = void 0;
      const map = (this._map = new _genMapping.GenMapping({
        sourceRoot: opts.sourceRoot,
      }));
      this._sourceFileName =
        (_opts$sourceFileName = opts.sourceFileName) == null
          ? void 0
          : _opts$sourceFileName.replace(/\\/g, "/");
      this._rawMappings = undefined;
      if (opts.inputSourceMap) {
        this._inputMap = new _traceMapping.TraceMap(opts.inputSourceMap);
        const resolvedSources = this._inputMap.resolvedSources;
        if (resolvedSources.length) {
          for (let i = 0; i < resolvedSources.length; i++) {
            var _this$_inputMap$sourc;
            (0, _genMapping.setSourceContent)(
              map,
              resolvedSources[i],
              (_this$_inputMap$sourc = this._inputMap.sourcesContent) == null
                ? void 0
                : _this$_inputMap$sourc[i],
            );
          }
        }
      }
      if (typeof code === "string" && !opts.inputSourceMap) {
        (0, _genMapping.setSourceContent)(map, this._sourceFileName, code);
      } else if (typeof code === "object") {
        for (const sourceFileName of Object.keys(code)) {
          (0, _genMapping.setSourceContent)(
            map,
            sourceFileName.replace(/\\/g, "/"),
            code[sourceFileName],
          );
        }
      }
    }
    get() {
      return (0, _genMapping.toEncodedMap)(this._map);
    }
    getDecoded() {
      return (0, _genMapping.toDecodedMap)(this._map);
    }
    getRawMappings() {
      return (
        this._rawMappings ||
        (this._rawMappings = (0, _genMapping.allMappings)(this._map))
      );
    }
    mark(generated, line, column, identifierName, identifierNamePos, filename) {
      var _originalMapping;
      this._rawMappings = undefined;
      let originalMapping;
      if (line != null) {
        if (this._inputMap) {
          originalMapping = (0, _traceMapping.originalPositionFor)(
            this._inputMap,
            { line: line, column: column },
          );
          if (!originalMapping.name && identifierNamePos) {
            const originalIdentifierMapping = (0,
            _traceMapping.originalPositionFor)(
              this._inputMap,
              identifierNamePos,
            );
            if (originalIdentifierMapping.name) {
              identifierName = originalIdentifierMapping.name;
            }
          }
        } else {
          originalMapping = {
            source:
              (filename == null ? void 0 : filename.replace(/\\/g, "/")) ||
              this._sourceFileName,
            line: line,
            column: column,
          };
        }
      }
      (0, _genMapping.maybeAddMapping)(this._map, {
        name: identifierName,
        generated: generated,
        source:
          (_originalMapping = originalMapping) == null
            ? void 0
            : _originalMapping.source,
        original: originalMapping,
      });
    }
  }
  sourceMap$3.default = SourceMap;
  return sourceMap$3;
}
var printer$2 = {};
var buffer$4 = {};
var hasRequiredBuffer;
function requireBuffer() {
  if (hasRequiredBuffer) return buffer$4;
  hasRequiredBuffer = 1;
  Object.defineProperty(buffer$4, "__esModule", { value: true });
  buffer$4.default = void 0;
  class Buffer {
    constructor(map, indentChar) {
      this._map = null;
      this._buf = "";
      this._str = "";
      this._appendCount = 0;
      this._last = 0;
      this._queue = [];
      this._queueCursor = 0;
      this._canMarkIdName = true;
      this._indentChar = "";
      this._fastIndentations = [];
      this._position = { line: 1, column: 0 };
      this._sourcePosition = {
        identifierName: undefined,
        identifierNamePos: undefined,
        line: undefined,
        column: undefined,
        filename: undefined,
      };
      this._map = map;
      this._indentChar = indentChar;
      for (let i = 0; i < 64; i++) {
        this._fastIndentations.push(indentChar.repeat(i));
      }
      this._allocQueue();
    }
    _allocQueue() {
      const queue = this._queue;
      for (let i = 0; i < 16; i++) {
        queue.push({
          char: 0,
          repeat: 1,
          line: undefined,
          column: undefined,
          identifierName: undefined,
          identifierNamePos: undefined,
          filename: "",
        });
      }
    }
    _pushQueue(char, repeat, line, column, filename) {
      const cursor = this._queueCursor;
      if (cursor === this._queue.length) {
        this._allocQueue();
      }
      const item = this._queue[cursor];
      item.char = char;
      item.repeat = repeat;
      item.line = line;
      item.column = column;
      item.filename = filename;
      this._queueCursor++;
    }
    _popQueue() {
      if (this._queueCursor === 0) {
        throw new Error("Cannot pop from empty queue");
      }
      return this._queue[--this._queueCursor];
    }
    get() {
      this._flush();
      const map = this._map;
      const result = {
        code: (this._buf + this._str).trimRight(),
        decodedMap: map == null ? void 0 : map.getDecoded(),
        get __mergedMap() {
          return this.map;
        },
        get map() {
          const resultMap = map ? map.get() : null;
          result.map = resultMap;
          return resultMap;
        },
        set map(value) {
          Object.defineProperty(result, "map", {
            value: value,
            writable: true,
          });
        },
        get rawMappings() {
          const mappings = map == null ? void 0 : map.getRawMappings();
          result.rawMappings = mappings;
          return mappings;
        },
        set rawMappings(value) {
          Object.defineProperty(result, "rawMappings", {
            value: value,
            writable: true,
          });
        },
      };
      return result;
    }
    append(str, maybeNewline) {
      this._flush();
      this._append(str, this._sourcePosition, maybeNewline);
    }
    appendChar(char) {
      this._flush();
      this._appendChar(char, 1, this._sourcePosition);
    }
    queue(char) {
      if (char === 10) {
        while (this._queueCursor !== 0) {
          const char = this._queue[this._queueCursor - 1].char;
          if (char !== 32 && char !== 9) {
            break;
          }
          this._queueCursor--;
        }
      }
      const sourcePosition = this._sourcePosition;
      this._pushQueue(
        char,
        1,
        sourcePosition.line,
        sourcePosition.column,
        sourcePosition.filename,
      );
    }
    queueIndentation(repeat) {
      if (repeat === 0) return;
      this._pushQueue(-1, repeat, undefined, undefined, undefined);
    }
    _flush() {
      const queueCursor = this._queueCursor;
      const queue = this._queue;
      for (let i = 0; i < queueCursor; i++) {
        const item = queue[i];
        this._appendChar(item.char, item.repeat, item);
      }
      this._queueCursor = 0;
    }
    _appendChar(char, repeat, sourcePos) {
      this._last = char;
      if (char === -1) {
        const fastIndentation = this._fastIndentations[repeat];
        if (fastIndentation !== undefined) {
          this._str += fastIndentation;
        } else {
          this._str +=
            repeat > 1 ? this._indentChar.repeat(repeat) : this._indentChar;
        }
      } else {
        this._str +=
          repeat > 1
            ? String.fromCharCode(char).repeat(repeat)
            : String.fromCharCode(char);
      }
      if (char !== 10) {
        this._mark(
          sourcePos.line,
          sourcePos.column,
          sourcePos.identifierName,
          sourcePos.identifierNamePos,
          sourcePos.filename,
        );
        this._position.column += repeat;
      } else {
        this._position.line++;
        this._position.column = 0;
      }
      if (this._canMarkIdName) {
        sourcePos.identifierName = undefined;
        sourcePos.identifierNamePos = undefined;
      }
    }
    _append(str, sourcePos, maybeNewline) {
      const len = str.length;
      const position = this._position;
      this._last = str.charCodeAt(len - 1);
      if (++this._appendCount > 4096) {
        +this._str;
        this._buf += this._str;
        this._str = str;
        this._appendCount = 0;
      } else {
        this._str += str;
      }
      if (!maybeNewline && !this._map) {
        position.column += len;
        return;
      }
      const {
        column: column,
        identifierName: identifierName,
        identifierNamePos: identifierNamePos,
        filename: filename,
      } = sourcePos;
      let line = sourcePos.line;
      if (
        (identifierName != null || identifierNamePos != null) &&
        this._canMarkIdName
      ) {
        sourcePos.identifierName = undefined;
        sourcePos.identifierNamePos = undefined;
      }
      let i = str.indexOf("\n");
      let last = 0;
      if (i !== 0) {
        this._mark(line, column, identifierName, identifierNamePos, filename);
      }
      while (i !== -1) {
        position.line++;
        position.column = 0;
        last = i + 1;
        if (last < len && line !== undefined) {
          this._mark(++line, 0, null, null, filename);
        }
        i = str.indexOf("\n", last);
      }
      position.column += len - last;
    }
    _mark(line, column, identifierName, identifierNamePos, filename) {
      var _this$_map;
      (_this$_map = this._map) == null ||
        _this$_map.mark(
          this._position,
          line,
          column,
          identifierName,
          identifierNamePos,
          filename,
        );
    }
    removeTrailingNewline() {
      const queueCursor = this._queueCursor;
      if (queueCursor !== 0 && this._queue[queueCursor - 1].char === 10) {
        this._queueCursor--;
      }
    }
    removeLastSemicolon() {
      const queueCursor = this._queueCursor;
      if (queueCursor !== 0 && this._queue[queueCursor - 1].char === 59) {
        this._queueCursor--;
      }
    }
    getLastChar() {
      const queueCursor = this._queueCursor;
      return queueCursor !== 0 ? this._queue[queueCursor - 1].char : this._last;
    }
    getNewlineCount() {
      const queueCursor = this._queueCursor;
      let count = 0;
      if (queueCursor === 0) return this._last === 10 ? 1 : 0;
      for (let i = queueCursor - 1; i >= 0; i--) {
        if (this._queue[i].char !== 10) {
          break;
        }
        count++;
      }
      return count === queueCursor && this._last === 10 ? count + 1 : count;
    }
    endsWithCharAndNewline() {
      const queue = this._queue;
      const queueCursor = this._queueCursor;
      if (queueCursor !== 0) {
        const lastCp = queue[queueCursor - 1].char;
        if (lastCp !== 10) return;
        if (queueCursor > 1) {
          return queue[queueCursor - 2].char;
        } else {
          return this._last;
        }
      }
    }
    hasContent() {
      return this._queueCursor !== 0 || !!this._last;
    }
    exactSource(loc, cb) {
      if (!this._map) {
        cb();
        return;
      }
      this.source("start", loc);
      const identifierName = loc.identifierName;
      const sourcePos = this._sourcePosition;
      if (identifierName) {
        this._canMarkIdName = false;
        sourcePos.identifierName = identifierName;
      }
      cb();
      if (identifierName) {
        this._canMarkIdName = true;
        sourcePos.identifierName = undefined;
        sourcePos.identifierNamePos = undefined;
      }
      this.source("end", loc);
    }
    source(prop, loc) {
      if (!this._map) return;
      this._normalizePosition(prop, loc, 0);
    }
    sourceWithOffset(prop, loc, columnOffset) {
      if (!this._map) return;
      this._normalizePosition(prop, loc, columnOffset);
    }
    withSource(prop, loc, cb) {
      if (this._map) {
        this.source(prop, loc);
      }
      cb();
    }
    _normalizePosition(prop, loc, columnOffset) {
      const pos = loc[prop];
      const target = this._sourcePosition;
      if (pos) {
        target.line = pos.line;
        target.column = Math.max(pos.column + columnOffset, 0);
        target.filename = loc.filename;
      }
    }
    getCurrentColumn() {
      const queue = this._queue;
      const queueCursor = this._queueCursor;
      let lastIndex = -1;
      let len = 0;
      for (let i = 0; i < queueCursor; i++) {
        const item = queue[i];
        if (item.char === 10) {
          lastIndex = len;
        }
        len += item.repeat;
      }
      return lastIndex === -1
        ? this._position.column + len
        : len - 1 - lastIndex;
    }
    getCurrentLine() {
      let count = 0;
      const queue = this._queue;
      for (let i = 0; i < this._queueCursor; i++) {
        if (queue[i].char === 10) {
          count++;
        }
      }
      return this._position.line + count;
    }
  }
  buffer$4.default = Buffer;
  return buffer$4;
}
var node$2 = {};
var whitespace$2 = {};
var hasRequiredWhitespace;
function requireWhitespace() {
  if (hasRequiredWhitespace) return whitespace$2;
  hasRequiredWhitespace = 1;
  Object.defineProperty(whitespace$2, "__esModule", { value: true });
  whitespace$2.nodes = void 0;
  var _t = t$d;
  const {
    FLIPPED_ALIAS_KEYS: FLIPPED_ALIAS_KEYS,
    isArrayExpression: isArrayExpression,
    isAssignmentExpression: isAssignmentExpression,
    isBinary: isBinary,
    isBlockStatement: isBlockStatement,
    isCallExpression: isCallExpression,
    isFunction: isFunction,
    isIdentifier: isIdentifier,
    isLiteral: isLiteral,
    isMemberExpression: isMemberExpression,
    isObjectExpression: isObjectExpression,
    isOptionalCallExpression: isOptionalCallExpression,
    isOptionalMemberExpression: isOptionalMemberExpression,
    isStringLiteral: isStringLiteral,
  } = _t;
  function crawlInternal(node, state) {
    if (!node) return state;
    if (isMemberExpression(node) || isOptionalMemberExpression(node)) {
      crawlInternal(node.object, state);
      if (node.computed) crawlInternal(node.property, state);
    } else if (isBinary(node) || isAssignmentExpression(node)) {
      crawlInternal(node.left, state);
      crawlInternal(node.right, state);
    } else if (isCallExpression(node) || isOptionalCallExpression(node)) {
      state.hasCall = true;
      crawlInternal(node.callee, state);
    } else if (isFunction(node)) {
      state.hasFunction = true;
    } else if (isIdentifier(node)) {
      state.hasHelper =
        state.hasHelper || (node.callee && isHelper(node.callee));
    }
    return state;
  }
  function crawl(node) {
    return crawlInternal(node, {
      hasCall: false,
      hasFunction: false,
      hasHelper: false,
    });
  }
  function isHelper(node) {
    if (!node) return false;
    if (isMemberExpression(node)) {
      return isHelper(node.object) || isHelper(node.property);
    } else if (isIdentifier(node)) {
      return node.name === "require" || node.name.charCodeAt(0) === 95;
    } else if (isCallExpression(node)) {
      return isHelper(node.callee);
    } else if (isBinary(node) || isAssignmentExpression(node)) {
      return (
        (isIdentifier(node.left) && isHelper(node.left)) || isHelper(node.right)
      );
    } else {
      return false;
    }
  }
  function isType(node) {
    return (
      isLiteral(node) ||
      isObjectExpression(node) ||
      isArrayExpression(node) ||
      isIdentifier(node) ||
      isMemberExpression(node)
    );
  }
  const nodes = (whitespace$2.nodes = {
    AssignmentExpression(node) {
      const state = crawl(node.right);
      if ((state.hasCall && state.hasHelper) || state.hasFunction) {
        return state.hasFunction ? 1 | 2 : 2;
      }
    },
    SwitchCase(node, parent) {
      return (
        (!!node.consequent.length || parent.cases[0] === node ? 1 : 0) |
        (!node.consequent.length &&
        parent.cases[parent.cases.length - 1] === node
          ? 2
          : 0)
      );
    },
    LogicalExpression(node) {
      if (isFunction(node.left) || isFunction(node.right)) {
        return 2;
      }
    },
    Literal(node) {
      if (isStringLiteral(node) && node.value === "use strict") {
        return 2;
      }
    },
    CallExpression(node) {
      if (isFunction(node.callee) || isHelper(node)) {
        return 1 | 2;
      }
    },
    OptionalCallExpression(node) {
      if (isFunction(node.callee)) {
        return 1 | 2;
      }
    },
    VariableDeclaration(node) {
      for (let i = 0; i < node.declarations.length; i++) {
        const declar = node.declarations[i];
        let enabled = isHelper(declar.id) && !isType(declar.init);
        if (!enabled && declar.init) {
          const state = crawl(declar.init);
          enabled =
            (isHelper(declar.init) && state.hasCall) || state.hasFunction;
        }
        if (enabled) {
          return 1 | 2;
        }
      }
    },
    IfStatement(node) {
      if (isBlockStatement(node.consequent)) {
        return 1 | 2;
      }
    },
  });
  nodes.ObjectProperty =
    nodes.ObjectTypeProperty =
    nodes.ObjectMethod =
      function (node, parent) {
        if (parent.properties[0] === node) {
          return 1;
        }
      };
  nodes.ObjectTypeCallProperty = function (node, parent) {
    var _parent$properties;
    if (
      parent.callProperties[0] === node &&
      !(
        (_parent$properties = parent.properties) != null &&
        _parent$properties.length
      )
    ) {
      return 1;
    }
  };
  nodes.ObjectTypeIndexer = function (node, parent) {
    var _parent$properties2, _parent$callPropertie;
    if (
      parent.indexers[0] === node &&
      !(
        (_parent$properties2 = parent.properties) != null &&
        _parent$properties2.length
      ) &&
      !(
        (_parent$callPropertie = parent.callProperties) != null &&
        _parent$callPropertie.length
      )
    ) {
      return 1;
    }
  };
  nodes.ObjectTypeInternalSlot = function (node, parent) {
    var _parent$properties3, _parent$callPropertie2, _parent$indexers;
    if (
      parent.internalSlots[0] === node &&
      !(
        (_parent$properties3 = parent.properties) != null &&
        _parent$properties3.length
      ) &&
      !(
        (_parent$callPropertie2 = parent.callProperties) != null &&
        _parent$callPropertie2.length
      ) &&
      !((_parent$indexers = parent.indexers) != null && _parent$indexers.length)
    ) {
      return 1;
    }
  };
  [
    ["Function", true],
    ["Class", true],
    ["Loop", true],
    ["LabeledStatement", true],
    ["SwitchStatement", true],
    ["TryStatement", true],
  ].forEach(function ([type, amounts]) {
    [type].concat(FLIPPED_ALIAS_KEYS[type] || []).forEach(function (type) {
      const ret = amounts ? 1 | 2 : 0;
      nodes[type] = () => ret;
    });
  });
  return whitespace$2;
}
var parentheses$1 = {};
var hasRequiredParentheses;
function requireParentheses() {
  if (hasRequiredParentheses) return parentheses$1;
  hasRequiredParentheses = 1;
  Object.defineProperty(parentheses$1, "__esModule", { value: true });
  parentheses$1.ArrowFunctionExpression = ArrowFunctionExpression;
  parentheses$1.AssignmentExpression = AssignmentExpression;
  parentheses$1.Binary = Binary;
  parentheses$1.BinaryExpression = BinaryExpression;
  parentheses$1.ClassExpression = ClassExpression;
  parentheses$1.ConditionalExpression = ConditionalExpression;
  parentheses$1.DoExpression = DoExpression;
  parentheses$1.FunctionExpression = FunctionExpression;
  parentheses$1.FunctionTypeAnnotation = FunctionTypeAnnotation;
  parentheses$1.Identifier = Identifier;
  parentheses$1.LogicalExpression = LogicalExpression;
  parentheses$1.NullableTypeAnnotation = NullableTypeAnnotation;
  parentheses$1.ObjectExpression = ObjectExpression;
  parentheses$1.OptionalIndexedAccessType = OptionalIndexedAccessType;
  parentheses$1.OptionalCallExpression =
    parentheses$1.OptionalMemberExpression = OptionalMemberExpression;
  parentheses$1.SequenceExpression = SequenceExpression;
  parentheses$1.TSTypeAssertion =
    parentheses$1.TSSatisfiesExpression =
    parentheses$1.TSAsExpression =
      TSAsExpression;
  parentheses$1.TSInferType = TSInferType;
  parentheses$1.TSInstantiationExpression = TSInstantiationExpression;
  parentheses$1.TSIntersectionType = parentheses$1.TSUnionType = TSUnionType;
  parentheses$1.UnaryLike = UnaryLike;
  parentheses$1.IntersectionTypeAnnotation = parentheses$1.UnionTypeAnnotation =
    UnionTypeAnnotation;
  parentheses$1.UpdateExpression = UpdateExpression;
  parentheses$1.AwaitExpression = parentheses$1.YieldExpression =
    YieldExpression;
  var _t = t$d;
  const {
    isArrayTypeAnnotation: isArrayTypeAnnotation,
    isArrowFunctionExpression: isArrowFunctionExpression,
    isBinaryExpression: isBinaryExpression,
    isCallExpression: isCallExpression,
    isExportDeclaration: isExportDeclaration,
    isForOfStatement: isForOfStatement,
    isIndexedAccessType: isIndexedAccessType,
    isMemberExpression: isMemberExpression,
    isObjectPattern: isObjectPattern,
    isOptionalMemberExpression: isOptionalMemberExpression,
    isYieldExpression: isYieldExpression,
  } = _t;
  const PRECEDENCE = new Map([
    ["||", 0],
    ["??", 0],
    ["|>", 0],
    ["&&", 1],
    ["|", 2],
    ["^", 3],
    ["&", 4],
    ["==", 5],
    ["===", 5],
    ["!=", 5],
    ["!==", 5],
    ["<", 6],
    [">", 6],
    ["<=", 6],
    [">=", 6],
    ["in", 6],
    ["instanceof", 6],
    [">>", 7],
    ["<<", 7],
    [">>>", 7],
    ["+", 8],
    ["-", 8],
    ["*", 9],
    ["/", 9],
    ["%", 9],
    ["**", 10],
  ]);
  function isTSTypeExpression(nodeType) {
    return (
      nodeType === "TSAsExpression" ||
      nodeType === "TSSatisfiesExpression" ||
      nodeType === "TSTypeAssertion"
    );
  }
  const isClassExtendsClause = (node, parent) => {
    const parentType = parent.type;
    return (
      (parentType === "ClassDeclaration" || parentType === "ClassExpression") &&
      parent.superClass === node
    );
  };
  const hasPostfixPart = (node, parent) => {
    const parentType = parent.type;
    return (
      ((parentType === "MemberExpression" ||
        parentType === "OptionalMemberExpression") &&
        parent.object === node) ||
      ((parentType === "CallExpression" ||
        parentType === "OptionalCallExpression" ||
        parentType === "NewExpression") &&
        parent.callee === node) ||
      (parentType === "TaggedTemplateExpression" && parent.tag === node) ||
      parentType === "TSNonNullExpression"
    );
  };
  function NullableTypeAnnotation(node, parent) {
    return isArrayTypeAnnotation(parent);
  }
  function FunctionTypeAnnotation(node, parent, printStack) {
    if (printStack.length < 3) return;
    const parentType = parent.type;
    return (
      parentType === "UnionTypeAnnotation" ||
      parentType === "IntersectionTypeAnnotation" ||
      parentType === "ArrayTypeAnnotation" ||
      (parentType === "TypeAnnotation" &&
        isArrowFunctionExpression(printStack[printStack.length - 3]))
    );
  }
  function UpdateExpression(node, parent) {
    return hasPostfixPart(node, parent) || isClassExtendsClause(node, parent);
  }
  function ObjectExpression(node, parent, printStack) {
    return isFirstInContext(printStack, 1 | 2);
  }
  function DoExpression(node, parent, printStack) {
    return !node.async && isFirstInContext(printStack, 1);
  }
  function Binary(node, parent) {
    const parentType = parent.type;
    if (
      node.operator === "**" &&
      parentType === "BinaryExpression" &&
      parent.operator === "**"
    ) {
      return parent.left === node;
    }
    if (isClassExtendsClause(node, parent)) {
      return true;
    }
    if (
      hasPostfixPart(node, parent) ||
      parentType === "UnaryExpression" ||
      parentType === "SpreadElement" ||
      parentType === "AwaitExpression"
    ) {
      return true;
    }
    if (
      parentType === "BinaryExpression" ||
      parentType === "LogicalExpression"
    ) {
      const parentPos = PRECEDENCE.get(parent.operator);
      const nodePos = PRECEDENCE.get(node.operator);
      if (
        (parentPos === nodePos &&
          parent.right === node &&
          parentType !== "LogicalExpression") ||
        parentPos > nodePos
      ) {
        return true;
      }
    }
    return undefined;
  }
  function UnionTypeAnnotation(node, parent) {
    const parentType = parent.type;
    return (
      parentType === "ArrayTypeAnnotation" ||
      parentType === "NullableTypeAnnotation" ||
      parentType === "IntersectionTypeAnnotation" ||
      parentType === "UnionTypeAnnotation"
    );
  }
  function OptionalIndexedAccessType(node, parent) {
    return isIndexedAccessType(parent) && parent.objectType === node;
  }
  function TSAsExpression() {
    return true;
  }
  function TSUnionType(node, parent) {
    const parentType = parent.type;
    return (
      parentType === "TSArrayType" ||
      parentType === "TSOptionalType" ||
      parentType === "TSIntersectionType" ||
      parentType === "TSUnionType" ||
      parentType === "TSRestType"
    );
  }
  function TSInferType(node, parent) {
    const parentType = parent.type;
    return parentType === "TSArrayType" || parentType === "TSOptionalType";
  }
  function TSInstantiationExpression(node, parent) {
    const parentType = parent.type;
    return (
      (parentType === "CallExpression" ||
        parentType === "OptionalCallExpression" ||
        parentType === "NewExpression" ||
        parentType === "TSInstantiationExpression") &&
      !!parent.typeParameters
    );
  }
  function BinaryExpression(node, parent) {
    if (node.operator === "in") {
      const parentType = parent.type;
      return (
        parentType === "VariableDeclarator" ||
        parentType === "ForStatement" ||
        parentType === "ForInStatement" ||
        parentType === "ForOfStatement"
      );
    }
    return false;
  }
  function SequenceExpression(node, parent) {
    const parentType = parent.type;
    if (
      parentType === "ForStatement" ||
      parentType === "ThrowStatement" ||
      parentType === "ReturnStatement" ||
      (parentType === "IfStatement" && parent.test === node) ||
      (parentType === "WhileStatement" && parent.test === node) ||
      (parentType === "ForInStatement" && parent.right === node) ||
      (parentType === "SwitchStatement" && parent.discriminant === node) ||
      (parentType === "ExpressionStatement" && parent.expression === node)
    ) {
      return false;
    }
    return true;
  }
  function YieldExpression(node, parent) {
    const parentType = parent.type;
    return (
      parentType === "BinaryExpression" ||
      parentType === "LogicalExpression" ||
      parentType === "UnaryExpression" ||
      parentType === "SpreadElement" ||
      hasPostfixPart(node, parent) ||
      (parentType === "AwaitExpression" && isYieldExpression(node)) ||
      (parentType === "ConditionalExpression" && node === parent.test) ||
      isClassExtendsClause(node, parent)
    );
  }
  function ClassExpression(node, parent, printStack) {
    return isFirstInContext(printStack, 1 | 4);
  }
  function UnaryLike(node, parent) {
    return (
      hasPostfixPart(node, parent) ||
      (isBinaryExpression(parent) &&
        parent.operator === "**" &&
        parent.left === node) ||
      isClassExtendsClause(node, parent)
    );
  }
  function FunctionExpression(node, parent, printStack) {
    return isFirstInContext(printStack, 1 | 4);
  }
  function ArrowFunctionExpression(node, parent) {
    return isExportDeclaration(parent) || ConditionalExpression(node, parent);
  }
  function ConditionalExpression(node, parent) {
    const parentType = parent.type;
    if (
      parentType === "UnaryExpression" ||
      parentType === "SpreadElement" ||
      parentType === "BinaryExpression" ||
      parentType === "LogicalExpression" ||
      (parentType === "ConditionalExpression" && parent.test === node) ||
      parentType === "AwaitExpression" ||
      isTSTypeExpression(parentType)
    ) {
      return true;
    }
    return UnaryLike(node, parent);
  }
  function OptionalMemberExpression(node, parent) {
    return (
      (isCallExpression(parent) && parent.callee === node) ||
      (isMemberExpression(parent) && parent.object === node)
    );
  }
  function AssignmentExpression(node, parent) {
    if (isObjectPattern(node.left)) {
      return true;
    } else {
      return ConditionalExpression(node, parent);
    }
  }
  function LogicalExpression(node, parent) {
    const parentType = parent.type;
    if (isTSTypeExpression(parentType)) return true;
    if (parentType !== "LogicalExpression") return false;
    switch (node.operator) {
      case "||":
        return parent.operator === "??" || parent.operator === "&&";
      case "&&":
        return parent.operator === "??";
      case "??":
        return parent.operator !== "??";
    }
  }
  function Identifier(node, parent, printStack) {
    var _node$extra;
    const parentType = parent.type;
    if (
      (_node$extra = node.extra) != null &&
      _node$extra.parenthesized &&
      parentType === "AssignmentExpression" &&
      parent.left === node
    ) {
      const rightType = parent.right.type;
      if (
        (rightType === "FunctionExpression" ||
          rightType === "ClassExpression") &&
        parent.right.id == null
      ) {
        return true;
      }
    }
    if (node.name === "let") {
      const isFollowedByBracket =
        isMemberExpression(parent, { object: node, computed: true }) ||
        isOptionalMemberExpression(parent, {
          object: node,
          computed: true,
          optional: false,
        });
      return isFirstInContext(
        printStack,
        isFollowedByBracket ? 1 | 8 | 16 | 32 : 32,
      );
    }
    return (
      node.name === "async" && isForOfStatement(parent) && node === parent.left
    );
  }
  function isFirstInContext(printStack, checkParam) {
    const expressionStatement = checkParam & 1;
    const arrowBody = checkParam & 2;
    const exportDefault = checkParam & 4;
    const forHead = checkParam & 8;
    const forInHead = checkParam & 16;
    const forOfHead = checkParam & 32;
    let i = printStack.length - 1;
    if (i <= 0) return;
    let node = printStack[i];
    i--;
    let parent = printStack[i];
    while (i >= 0) {
      const parentType = parent.type;
      if (
        (expressionStatement &&
          parentType === "ExpressionStatement" &&
          parent.expression === node) ||
        (exportDefault &&
          parentType === "ExportDefaultDeclaration" &&
          node === parent.declaration) ||
        (arrowBody &&
          parentType === "ArrowFunctionExpression" &&
          parent.body === node) ||
        (forHead && parentType === "ForStatement" && parent.init === node) ||
        (forInHead &&
          parentType === "ForInStatement" &&
          parent.left === node) ||
        (forOfHead && parentType === "ForOfStatement" && parent.left === node)
      ) {
        return true;
      }
      if (
        i > 0 &&
        ((hasPostfixPart(node, parent) && parentType !== "NewExpression") ||
          (parentType === "SequenceExpression" &&
            parent.expressions[0] === node) ||
          (parentType === "UpdateExpression" && !parent.prefix) ||
          (parentType === "ConditionalExpression" && parent.test === node) ||
          ((parentType === "BinaryExpression" ||
            parentType === "LogicalExpression") &&
            parent.left === node) ||
          (parentType === "AssignmentExpression" && parent.left === node))
      ) {
        node = parent;
        i--;
        parent = printStack[i];
      } else {
        return false;
      }
    }
    return false;
  }
  return parentheses$1;
}
var hasRequiredNode;
function requireNode() {
  if (hasRequiredNode) return node$2;
  hasRequiredNode = 1;
  Object.defineProperty(node$2, "__esModule", { value: true });
  node$2.needsParens = needsParens;
  node$2.needsWhitespace = needsWhitespace;
  node$2.needsWhitespaceAfter = needsWhitespaceAfter;
  node$2.needsWhitespaceBefore = needsWhitespaceBefore;
  var whitespace = requireWhitespace();
  var parens = requireParentheses();
  var _t = t$d;
  const {
    FLIPPED_ALIAS_KEYS: FLIPPED_ALIAS_KEYS,
    isCallExpression: isCallExpression,
    isExpressionStatement: isExpressionStatement,
    isMemberExpression: isMemberExpression,
    isNewExpression: isNewExpression,
  } = _t;
  function expandAliases(obj) {
    const map = new Map();
    function add(type, func) {
      const fn = map.get(type);
      map.set(
        type,
        fn
          ? function (node, parent, stack) {
              var _fn;
              return (_fn = fn(node, parent, stack)) != null
                ? _fn
                : func(node, parent, stack);
            }
          : func,
      );
    }
    for (const type of Object.keys(obj)) {
      const aliases = FLIPPED_ALIAS_KEYS[type];
      if (aliases) {
        for (const alias of aliases) {
          add(alias, obj[type]);
        }
      } else {
        add(type, obj[type]);
      }
    }
    return map;
  }
  const expandedParens = expandAliases(parens);
  const expandedWhitespaceNodes = expandAliases(whitespace.nodes);
  function isOrHasCallExpression(node) {
    if (isCallExpression(node)) {
      return true;
    }
    return isMemberExpression(node) && isOrHasCallExpression(node.object);
  }
  function needsWhitespace(node, parent, type) {
    var _expandedWhitespaceNo;
    if (!node) return false;
    if (isExpressionStatement(node)) {
      node = node.expression;
    }
    const flag =
      (_expandedWhitespaceNo = expandedWhitespaceNodes.get(node.type)) == null
        ? void 0
        : _expandedWhitespaceNo(node, parent);
    if (typeof flag === "number") {
      return (flag & type) !== 0;
    }
    return false;
  }
  function needsWhitespaceBefore(node, parent) {
    return needsWhitespace(node, parent, 1);
  }
  function needsWhitespaceAfter(node, parent) {
    return needsWhitespace(node, parent, 2);
  }
  function needsParens(node, parent, printStack) {
    var _expandedParens$get;
    if (!parent) return false;
    if (isNewExpression(parent) && parent.callee === node) {
      if (isOrHasCallExpression(node)) return true;
    }
    return (_expandedParens$get = expandedParens.get(node.type)) == null
      ? void 0
      : _expandedParens$get(node, parent, printStack);
  }
  return node$2;
}
var generators$1 = {};
var templateLiterals$1 = {};
var hasRequiredTemplateLiterals;
function requireTemplateLiterals() {
  if (hasRequiredTemplateLiterals) return templateLiterals$1;
  hasRequiredTemplateLiterals = 1;
  Object.defineProperty(templateLiterals$1, "__esModule", { value: true });
  templateLiterals$1.TaggedTemplateExpression = TaggedTemplateExpression;
  templateLiterals$1.TemplateElement = TemplateElement;
  templateLiterals$1.TemplateLiteral = TemplateLiteral;
  function TaggedTemplateExpression(node) {
    this.print(node.tag, node);
    this.print(node.typeParameters, node);
    this.print(node.quasi, node);
  }
  function TemplateElement(node, parent) {
    const isFirst = parent.quasis[0] === node;
    const isLast = parent.quasis[parent.quasis.length - 1] === node;
    const value =
      (isFirst ? "`" : "}") + node.value.raw + (isLast ? "`" : "${");
    this.token(value, true);
  }
  function TemplateLiteral(node) {
    const quasis = node.quasis;
    for (let i = 0; i < quasis.length; i++) {
      this.print(quasis[i], node);
      if (i + 1 < quasis.length) {
        this.print(node.expressions[i], node);
      }
    }
  }
  return templateLiterals$1;
}
var expressions$1 = {};
var hasRequiredExpressions;
function requireExpressions() {
  if (hasRequiredExpressions) return expressions$1;
  hasRequiredExpressions = 1;
  Object.defineProperty(expressions$1, "__esModule", { value: true });
  expressions$1.LogicalExpression =
    expressions$1.BinaryExpression =
    expressions$1.AssignmentExpression =
      AssignmentExpression;
  expressions$1.AssignmentPattern = AssignmentPattern;
  expressions$1.AwaitExpression = AwaitExpression;
  expressions$1.BindExpression = BindExpression;
  expressions$1.CallExpression = CallExpression;
  expressions$1.ConditionalExpression = ConditionalExpression;
  expressions$1.Decorator = Decorator;
  expressions$1.DoExpression = DoExpression;
  expressions$1.EmptyStatement = EmptyStatement;
  expressions$1.ExpressionStatement = ExpressionStatement;
  expressions$1.Import = Import;
  expressions$1.MemberExpression = MemberExpression;
  expressions$1.MetaProperty = MetaProperty;
  expressions$1.ModuleExpression = ModuleExpression;
  expressions$1.NewExpression = NewExpression;
  expressions$1.OptionalCallExpression = OptionalCallExpression;
  expressions$1.OptionalMemberExpression = OptionalMemberExpression;
  expressions$1.ParenthesizedExpression = ParenthesizedExpression;
  expressions$1.PrivateName = PrivateName;
  expressions$1.SequenceExpression = SequenceExpression;
  expressions$1.Super = Super;
  expressions$1.ThisExpression = ThisExpression;
  expressions$1.UnaryExpression = UnaryExpression;
  expressions$1.UpdateExpression = UpdateExpression;
  expressions$1.V8IntrinsicIdentifier = V8IntrinsicIdentifier;
  expressions$1.YieldExpression = YieldExpression;
  expressions$1._shouldPrintDecoratorsBeforeExport =
    _shouldPrintDecoratorsBeforeExport;
  var _t = t$d;
  var n = requireNode();
  const {
    isCallExpression: isCallExpression,
    isLiteral: isLiteral,
    isMemberExpression: isMemberExpression,
    isNewExpression: isNewExpression,
  } = _t;
  function UnaryExpression(node) {
    const { operator: operator } = node;
    if (
      operator === "void" ||
      operator === "delete" ||
      operator === "typeof" ||
      operator === "throw"
    ) {
      this.word(operator);
      this.space();
    } else {
      this.token(operator);
    }
    this.print(node.argument, node);
  }
  function DoExpression(node) {
    if (node.async) {
      this.word("async", true);
      this.space();
    }
    this.word("do");
    this.space();
    this.print(node.body, node);
  }
  function ParenthesizedExpression(node) {
    this.tokenChar(40);
    this.print(node.expression, node);
    this.rightParens(node);
  }
  function UpdateExpression(node) {
    if (node.prefix) {
      this.token(node.operator);
      this.print(node.argument, node);
    } else {
      this.printTerminatorless(node.argument, node, true);
      this.token(node.operator);
    }
  }
  function ConditionalExpression(node) {
    this.print(node.test, node);
    this.space();
    this.tokenChar(63);
    this.space();
    this.print(node.consequent, node);
    this.space();
    this.tokenChar(58);
    this.space();
    this.print(node.alternate, node);
  }
  function NewExpression(node, parent) {
    this.word("new");
    this.space();
    this.print(node.callee, node);
    if (
      this.format.minified &&
      node.arguments.length === 0 &&
      !node.optional &&
      !isCallExpression(parent, { callee: node }) &&
      !isMemberExpression(parent) &&
      !isNewExpression(parent)
    ) {
      return;
    }
    this.print(node.typeArguments, node);
    this.print(node.typeParameters, node);
    if (node.optional) {
      this.token("?.");
    }
    this.tokenChar(40);
    this.printList(node.arguments, node);
    this.rightParens(node);
  }
  function SequenceExpression(node) {
    this.printList(node.expressions, node);
  }
  function ThisExpression() {
    this.word("this");
  }
  function Super() {
    this.word("super");
  }
  function isDecoratorMemberExpression(node) {
    switch (node.type) {
      case "Identifier":
        return true;
      case "MemberExpression":
        return (
          !node.computed &&
          node.property.type === "Identifier" &&
          isDecoratorMemberExpression(node.object)
        );
      default:
        return false;
    }
  }
  function shouldParenthesizeDecoratorExpression(node) {
    if (node.type === "ParenthesizedExpression") {
      return false;
    }
    return !isDecoratorMemberExpression(
      node.type === "CallExpression" ? node.callee : node,
    );
  }
  function _shouldPrintDecoratorsBeforeExport(node) {
    if (typeof this.format.decoratorsBeforeExport === "boolean") {
      return this.format.decoratorsBeforeExport;
    }
    return (
      typeof node.start === "number" && node.start === node.declaration.start
    );
  }
  function Decorator(node) {
    this.tokenChar(64);
    const { expression: expression } = node;
    if (shouldParenthesizeDecoratorExpression(expression)) {
      this.tokenChar(40);
      this.print(expression, node);
      this.tokenChar(41);
    } else {
      this.print(expression, node);
    }
    this.newline();
  }
  function OptionalMemberExpression(node) {
    let { computed: computed } = node;
    const { optional: optional, property: property } = node;
    this.print(node.object, node);
    if (!computed && isMemberExpression(property)) {
      throw new TypeError(
        "Got a MemberExpression for MemberExpression property",
      );
    }
    if (isLiteral(property) && typeof property.value === "number") {
      computed = true;
    }
    if (optional) {
      this.token("?.");
    }
    if (computed) {
      this.tokenChar(91);
      this.print(property, node);
      this.tokenChar(93);
    } else {
      if (!optional) {
        this.tokenChar(46);
      }
      this.print(property, node);
    }
  }
  function OptionalCallExpression(node) {
    this.print(node.callee, node);
    this.print(node.typeParameters, node);
    if (node.optional) {
      this.token("?.");
    }
    this.print(node.typeArguments, node);
    this.tokenChar(40);
    this.printList(node.arguments, node);
    this.rightParens(node);
  }
  function CallExpression(node) {
    this.print(node.callee, node);
    this.print(node.typeArguments, node);
    this.print(node.typeParameters, node);
    this.tokenChar(40);
    this.printList(node.arguments, node);
    this.rightParens(node);
  }
  function Import() {
    this.word("import");
  }
  function AwaitExpression(node) {
    this.word("await");
    if (node.argument) {
      this.space();
      this.printTerminatorless(node.argument, node, false);
    }
  }
  function YieldExpression(node) {
    this.word("yield", true);
    if (node.delegate) {
      this.tokenChar(42);
      if (node.argument) {
        this.space();
        this.print(node.argument, node);
      }
    } else {
      if (node.argument) {
        this.space();
        this.printTerminatorless(node.argument, node, false);
      }
    }
  }
  function EmptyStatement() {
    this.semicolon(true);
  }
  function ExpressionStatement(node) {
    this.print(node.expression, node);
    this.semicolon();
  }
  function AssignmentPattern(node) {
    this.print(node.left, node);
    if (node.left.optional) this.tokenChar(63);
    this.print(node.left.typeAnnotation, node);
    this.space();
    this.tokenChar(61);
    this.space();
    this.print(node.right, node);
  }
  function AssignmentExpression(node, parent) {
    const parens =
      this.inForStatementInitCounter &&
      node.operator === "in" &&
      !n.needsParens(node, parent);
    if (parens) {
      this.tokenChar(40);
    }
    this.print(node.left, node);
    this.space();
    if (node.operator === "in" || node.operator === "instanceof") {
      this.word(node.operator);
    } else {
      this.token(node.operator);
    }
    this.space();
    this.print(node.right, node);
    if (parens) {
      this.tokenChar(41);
    }
  }
  function BindExpression(node) {
    this.print(node.object, node);
    this.token("::");
    this.print(node.callee, node);
  }
  function MemberExpression(node) {
    this.print(node.object, node);
    if (!node.computed && isMemberExpression(node.property)) {
      throw new TypeError(
        "Got a MemberExpression for MemberExpression property",
      );
    }
    let computed = node.computed;
    if (isLiteral(node.property) && typeof node.property.value === "number") {
      computed = true;
    }
    if (computed) {
      this.tokenChar(91);
      this.print(node.property, node);
      this.tokenChar(93);
    } else {
      this.tokenChar(46);
      this.print(node.property, node);
    }
  }
  function MetaProperty(node) {
    this.print(node.meta, node);
    this.tokenChar(46);
    this.print(node.property, node);
  }
  function PrivateName(node) {
    this.tokenChar(35);
    this.print(node.id, node);
  }
  function V8IntrinsicIdentifier(node) {
    this.tokenChar(37);
    this.word(node.name);
  }
  function ModuleExpression(node) {
    this.word("module", true);
    this.space();
    this.tokenChar(123);
    this.indent();
    const { body: body } = node;
    if (body.body.length || body.directives.length) {
      this.newline();
    }
    this.print(body, node);
    this.dedent();
    this.rightBrace(node);
  }
  return expressions$1;
}
var statements$1 = {};
var hasRequiredStatements;
function requireStatements() {
  if (hasRequiredStatements) return statements$1;
  hasRequiredStatements = 1;
  Object.defineProperty(statements$1, "__esModule", { value: true });
  statements$1.BreakStatement = BreakStatement;
  statements$1.CatchClause = CatchClause;
  statements$1.ContinueStatement = ContinueStatement;
  statements$1.DebuggerStatement = DebuggerStatement;
  statements$1.DoWhileStatement = DoWhileStatement;
  statements$1.ForOfStatement = statements$1.ForInStatement = void 0;
  statements$1.ForStatement = ForStatement;
  statements$1.IfStatement = IfStatement;
  statements$1.LabeledStatement = LabeledStatement;
  statements$1.ReturnStatement = ReturnStatement;
  statements$1.SwitchCase = SwitchCase;
  statements$1.SwitchStatement = SwitchStatement;
  statements$1.ThrowStatement = ThrowStatement;
  statements$1.TryStatement = TryStatement;
  statements$1.VariableDeclaration = VariableDeclaration;
  statements$1.VariableDeclarator = VariableDeclarator;
  statements$1.WhileStatement = WhileStatement;
  statements$1.WithStatement = WithStatement;
  var _t = t$d;
  const {
    isFor: isFor,
    isForStatement: isForStatement,
    isIfStatement: isIfStatement,
    isStatement: isStatement,
  } = _t;
  function WithStatement(node) {
    this.word("with");
    this.space();
    this.tokenChar(40);
    this.print(node.object, node);
    this.tokenChar(41);
    this.printBlock(node);
  }
  function IfStatement(node) {
    this.word("if");
    this.space();
    this.tokenChar(40);
    this.print(node.test, node);
    this.tokenChar(41);
    this.space();
    const needsBlock =
      node.alternate && isIfStatement(getLastStatement(node.consequent));
    if (needsBlock) {
      this.tokenChar(123);
      this.newline();
      this.indent();
    }
    this.printAndIndentOnComments(node.consequent, node);
    if (needsBlock) {
      this.dedent();
      this.newline();
      this.tokenChar(125);
    }
    if (node.alternate) {
      if (this.endsWith(125)) this.space();
      this.word("else");
      this.space();
      this.printAndIndentOnComments(node.alternate, node);
    }
  }
  function getLastStatement(statement) {
    const { body: body } = statement;
    if (isStatement(body) === false) {
      return statement;
    }
    return getLastStatement(body);
  }
  function ForStatement(node) {
    this.word("for");
    this.space();
    this.tokenChar(40);
    this.inForStatementInitCounter++;
    this.print(node.init, node);
    this.inForStatementInitCounter--;
    this.tokenChar(59);
    if (node.test) {
      this.space();
      this.print(node.test, node);
    }
    this.tokenChar(59);
    if (node.update) {
      this.space();
      this.print(node.update, node);
    }
    this.tokenChar(41);
    this.printBlock(node);
  }
  function WhileStatement(node) {
    this.word("while");
    this.space();
    this.tokenChar(40);
    this.print(node.test, node);
    this.tokenChar(41);
    this.printBlock(node);
  }
  function ForXStatement(node) {
    this.word("for");
    this.space();
    const isForOf = node.type === "ForOfStatement";
    if (isForOf && node.await) {
      this.word("await");
      this.space();
    }
    this.noIndentInnerCommentsHere();
    this.tokenChar(40);
    this.print(node.left, node);
    this.space();
    this.word(isForOf ? "of" : "in");
    this.space();
    this.print(node.right, node);
    this.tokenChar(41);
    this.printBlock(node);
  }
  statements$1.ForInStatement = ForXStatement;
  statements$1.ForOfStatement = ForXStatement;
  function DoWhileStatement(node) {
    this.word("do");
    this.space();
    this.print(node.body, node);
    this.space();
    this.word("while");
    this.space();
    this.tokenChar(40);
    this.print(node.test, node);
    this.tokenChar(41);
    this.semicolon();
  }
  function printStatementAfterKeyword(printer, node, parent, isLabel) {
    if (node) {
      printer.space();
      printer.printTerminatorless(node, parent, isLabel);
    }
    printer.semicolon();
  }
  function BreakStatement(node) {
    this.word("break");
    printStatementAfterKeyword(this, node.label, node, true);
  }
  function ContinueStatement(node) {
    this.word("continue");
    printStatementAfterKeyword(this, node.label, node, true);
  }
  function ReturnStatement(node) {
    this.word("return");
    printStatementAfterKeyword(this, node.argument, node, false);
  }
  function ThrowStatement(node) {
    this.word("throw");
    printStatementAfterKeyword(this, node.argument, node, false);
  }
  function LabeledStatement(node) {
    this.print(node.label, node);
    this.tokenChar(58);
    this.space();
    this.print(node.body, node);
  }
  function TryStatement(node) {
    this.word("try");
    this.space();
    this.print(node.block, node);
    this.space();
    if (node.handlers) {
      this.print(node.handlers[0], node);
    } else {
      this.print(node.handler, node);
    }
    if (node.finalizer) {
      this.space();
      this.word("finally");
      this.space();
      this.print(node.finalizer, node);
    }
  }
  function CatchClause(node) {
    this.word("catch");
    this.space();
    if (node.param) {
      this.tokenChar(40);
      this.print(node.param, node);
      this.print(node.param.typeAnnotation, node);
      this.tokenChar(41);
      this.space();
    }
    this.print(node.body, node);
  }
  function SwitchStatement(node) {
    this.word("switch");
    this.space();
    this.tokenChar(40);
    this.print(node.discriminant, node);
    this.tokenChar(41);
    this.space();
    this.tokenChar(123);
    this.printSequence(node.cases, node, {
      indent: true,
      addNewlines(leading, cas) {
        if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
      },
    });
    this.rightBrace(node);
  }
  function SwitchCase(node) {
    if (node.test) {
      this.word("case");
      this.space();
      this.print(node.test, node);
      this.tokenChar(58);
    } else {
      this.word("default");
      this.tokenChar(58);
    }
    if (node.consequent.length) {
      this.newline();
      this.printSequence(node.consequent, node, { indent: true });
    }
  }
  function DebuggerStatement() {
    this.word("debugger");
    this.semicolon();
  }
  function VariableDeclaration(node, parent) {
    if (node.declare) {
      this.word("declare");
      this.space();
    }
    const { kind: kind } = node;
    this.word(kind, kind === "using" || kind === "await using");
    this.space();
    let hasInits = false;
    if (!isFor(parent)) {
      for (const declar of node.declarations) {
        if (declar.init) {
          hasInits = true;
        }
      }
    }
    this.printList(node.declarations, node, {
      separator: hasInits
        ? function () {
            this.tokenChar(44);
            this.newline();
          }
        : undefined,
      indent: node.declarations.length > 1 ? true : false,
    });
    if (isFor(parent)) {
      if (isForStatement(parent)) {
        if (parent.init === node) return;
      } else {
        if (parent.left === node) return;
      }
    }
    this.semicolon();
  }
  function VariableDeclarator(node) {
    this.print(node.id, node);
    if (node.definite) this.tokenChar(33);
    this.print(node.id.typeAnnotation, node);
    if (node.init) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.init, node);
    }
  }
  return statements$1;
}
var classes$1 = {};
var hasRequiredClasses;
function requireClasses() {
  if (hasRequiredClasses) return classes$1;
  hasRequiredClasses = 1;
  Object.defineProperty(classes$1, "__esModule", { value: true });
  classes$1.ClassAccessorProperty = ClassAccessorProperty;
  classes$1.ClassBody = ClassBody;
  classes$1.ClassExpression = classes$1.ClassDeclaration = ClassDeclaration;
  classes$1.ClassMethod = ClassMethod;
  classes$1.ClassPrivateMethod = ClassPrivateMethod;
  classes$1.ClassPrivateProperty = ClassPrivateProperty;
  classes$1.ClassProperty = ClassProperty;
  classes$1.StaticBlock = StaticBlock;
  classes$1._classMethodHead = _classMethodHead;
  var _t = t$d;
  const {
    isExportDefaultDeclaration: isExportDefaultDeclaration,
    isExportNamedDeclaration: isExportNamedDeclaration,
  } = _t;
  function ClassDeclaration(node, parent) {
    const inExport =
      isExportDefaultDeclaration(parent) || isExportNamedDeclaration(parent);
    if (!inExport || !this._shouldPrintDecoratorsBeforeExport(parent)) {
      this.printJoin(node.decorators, node);
    }
    if (node.declare) {
      this.word("declare");
      this.space();
    }
    if (node.abstract) {
      this.word("abstract");
      this.space();
    }
    this.word("class");
    if (node.id) {
      this.space();
      this.print(node.id, node);
    }
    this.print(node.typeParameters, node);
    if (node.superClass) {
      this.space();
      this.word("extends");
      this.space();
      this.print(node.superClass, node);
      this.print(node.superTypeParameters, node);
    }
    if (node.implements) {
      this.space();
      this.word("implements");
      this.space();
      this.printList(node.implements, node);
    }
    this.space();
    this.print(node.body, node);
  }
  function ClassBody(node) {
    this.tokenChar(123);
    if (node.body.length === 0) {
      this.tokenChar(125);
    } else {
      this.newline();
      this.printSequence(node.body, node, { indent: true });
      if (!this.endsWith(10)) this.newline();
      this.rightBrace(node);
    }
  }
  function ClassProperty(node) {
    var _node$key$loc;
    this.printJoin(node.decorators, node);
    const endLine =
      (_node$key$loc = node.key.loc) == null ||
      (_node$key$loc = _node$key$loc.end) == null
        ? void 0
        : _node$key$loc.line;
    if (endLine) this.catchUp(endLine);
    this.tsPrintClassMemberModifiers(node);
    if (node.computed) {
      this.tokenChar(91);
      this.print(node.key, node);
      this.tokenChar(93);
    } else {
      this._variance(node);
      this.print(node.key, node);
    }
    if (node.optional) {
      this.tokenChar(63);
    }
    if (node.definite) {
      this.tokenChar(33);
    }
    this.print(node.typeAnnotation, node);
    if (node.value) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.value, node);
    }
    this.semicolon();
  }
  function ClassAccessorProperty(node) {
    var _node$key$loc2;
    this.printJoin(node.decorators, node);
    const endLine =
      (_node$key$loc2 = node.key.loc) == null ||
      (_node$key$loc2 = _node$key$loc2.end) == null
        ? void 0
        : _node$key$loc2.line;
    if (endLine) this.catchUp(endLine);
    this.tsPrintClassMemberModifiers(node);
    this.word("accessor", true);
    this.space();
    if (node.computed) {
      this.tokenChar(91);
      this.print(node.key, node);
      this.tokenChar(93);
    } else {
      this._variance(node);
      this.print(node.key, node);
    }
    if (node.optional) {
      this.tokenChar(63);
    }
    if (node.definite) {
      this.tokenChar(33);
    }
    this.print(node.typeAnnotation, node);
    if (node.value) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.value, node);
    }
    this.semicolon();
  }
  function ClassPrivateProperty(node) {
    this.printJoin(node.decorators, node);
    if (node.static) {
      this.word("static");
      this.space();
    }
    this.print(node.key, node);
    this.print(node.typeAnnotation, node);
    if (node.value) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.value, node);
    }
    this.semicolon();
  }
  function ClassMethod(node) {
    this._classMethodHead(node);
    this.space();
    this.print(node.body, node);
  }
  function ClassPrivateMethod(node) {
    this._classMethodHead(node);
    this.space();
    this.print(node.body, node);
  }
  function _classMethodHead(node) {
    var _node$key$loc3;
    this.printJoin(node.decorators, node);
    const endLine =
      (_node$key$loc3 = node.key.loc) == null ||
      (_node$key$loc3 = _node$key$loc3.end) == null
        ? void 0
        : _node$key$loc3.line;
    if (endLine) this.catchUp(endLine);
    this.tsPrintClassMemberModifiers(node);
    this._methodHead(node);
  }
  function StaticBlock(node) {
    this.word("static");
    this.space();
    this.tokenChar(123);
    if (node.body.length === 0) {
      this.tokenChar(125);
    } else {
      this.newline();
      this.printSequence(node.body, node, { indent: true });
      this.rightBrace(node);
    }
  }
  return classes$1;
}
var methods$1 = {};
var hasRequiredMethods;
function requireMethods() {
  if (hasRequiredMethods) return methods$1;
  hasRequiredMethods = 1;
  Object.defineProperty(methods$1, "__esModule", { value: true });
  methods$1.ArrowFunctionExpression = ArrowFunctionExpression;
  methods$1.FunctionDeclaration = methods$1.FunctionExpression =
    FunctionExpression;
  methods$1._functionHead = _functionHead;
  methods$1._methodHead = _methodHead;
  methods$1._param = _param;
  methods$1._parameters = _parameters;
  methods$1._params = _params;
  methods$1._predicate = _predicate;
  var _t = t$d;
  const { isIdentifier: isIdentifier } = _t;
  function _params(node, idNode, parentNode) {
    this.print(node.typeParameters, node);
    const nameInfo = _getFuncIdName.call(this, idNode, parentNode);
    if (nameInfo) {
      this.sourceIdentifierName(nameInfo.name, nameInfo.pos);
    }
    this.tokenChar(40);
    this._parameters(node.params, node);
    this.tokenChar(41);
    const noLineTerminator = node.type === "ArrowFunctionExpression";
    this.print(node.returnType, node, noLineTerminator);
    this._noLineTerminator = noLineTerminator;
  }
  function _parameters(parameters, parent) {
    const paramLength = parameters.length;
    for (let i = 0; i < paramLength; i++) {
      this._param(parameters[i], parent);
      if (i < parameters.length - 1) {
        this.tokenChar(44);
        this.space();
      }
    }
  }
  function _param(parameter, parent) {
    this.printJoin(parameter.decorators, parameter);
    this.print(parameter, parent);
    if (parameter.optional) {
      this.tokenChar(63);
    }
    this.print(parameter.typeAnnotation, parameter);
  }
  function _methodHead(node) {
    const kind = node.kind;
    const key = node.key;
    if (kind === "get" || kind === "set") {
      this.word(kind);
      this.space();
    }
    if (node.async) {
      this.word("async", true);
      this.space();
    }
    if (kind === "method" || kind === "init") {
      if (node.generator) {
        this.tokenChar(42);
      }
    }
    if (node.computed) {
      this.tokenChar(91);
      this.print(key, node);
      this.tokenChar(93);
    } else {
      this.print(key, node);
    }
    if (node.optional) {
      this.tokenChar(63);
    }
    this._params(
      node,
      node.computed && node.key.type !== "StringLiteral" ? undefined : node.key,
      undefined,
    );
  }
  function _predicate(node, noLineTerminatorAfter) {
    if (node.predicate) {
      if (!node.returnType) {
        this.tokenChar(58);
      }
      this.space();
      this.print(node.predicate, node, noLineTerminatorAfter);
    }
  }
  function _functionHead(node, parent) {
    if (node.async) {
      this.word("async");
      this._endsWithInnerRaw = false;
      this.space();
    }
    this.word("function");
    if (node.generator) {
      this._endsWithInnerRaw = false;
      this.tokenChar(42);
    }
    this.space();
    if (node.id) {
      this.print(node.id, node);
    }
    this._params(node, node.id, parent);
    if (node.type !== "TSDeclareFunction") {
      this._predicate(node);
    }
  }
  function FunctionExpression(node, parent) {
    this._functionHead(node, parent);
    this.space();
    this.print(node.body, node);
  }
  function ArrowFunctionExpression(node, parent) {
    if (node.async) {
      this.word("async", true);
      this.space();
    }
    let firstParam;
    if (
      !this.format.retainLines &&
      node.params.length === 1 &&
      isIdentifier((firstParam = node.params[0])) &&
      !hasTypesOrComments(node, firstParam)
    ) {
      this.print(firstParam, node, true);
    } else {
      this._params(node, undefined, parent);
    }
    this._predicate(node, true);
    this.space();
    this.printInnerComments();
    this.token("=>");
    this.space();
    this.print(node.body, node);
  }
  function hasTypesOrComments(node, param) {
    var _param$leadingComment, _param$trailingCommen;
    return !!(
      node.typeParameters ||
      node.returnType ||
      node.predicate ||
      param.typeAnnotation ||
      param.optional ||
      ((_param$leadingComment = param.leadingComments) != null &&
        _param$leadingComment.length) ||
      ((_param$trailingCommen = param.trailingComments) != null &&
        _param$trailingCommen.length)
    );
  }
  function _getFuncIdName(idNode, parent) {
    let id = idNode;
    if (!id && parent) {
      const parentType = parent.type;
      if (parentType === "VariableDeclarator") {
        id = parent.id;
      } else if (
        parentType === "AssignmentExpression" ||
        parentType === "AssignmentPattern"
      ) {
        id = parent.left;
      } else if (
        parentType === "ObjectProperty" ||
        parentType === "ClassProperty"
      ) {
        if (!parent.computed || parent.key.type === "StringLiteral") {
          id = parent.key;
        }
      } else if (
        parentType === "ClassPrivateProperty" ||
        parentType === "ClassAccessorProperty"
      ) {
        id = parent.key;
      }
    }
    if (!id) return;
    let nameInfo;
    if (id.type === "Identifier") {
      var _id$loc, _id$loc2;
      nameInfo = {
        pos: (_id$loc = id.loc) == null ? void 0 : _id$loc.start,
        name:
          ((_id$loc2 = id.loc) == null ? void 0 : _id$loc2.identifierName) ||
          id.name,
      };
    } else if (id.type === "PrivateName") {
      var _id$loc3;
      nameInfo = {
        pos: (_id$loc3 = id.loc) == null ? void 0 : _id$loc3.start,
        name: "#" + id.id.name,
      };
    } else if (id.type === "StringLiteral") {
      var _id$loc4;
      nameInfo = {
        pos: (_id$loc4 = id.loc) == null ? void 0 : _id$loc4.start,
        name: id.value,
      };
    }
    return nameInfo;
  }
  return methods$1;
}
var modules$1 = {};
var hasRequiredModules;
function requireModules() {
  if (hasRequiredModules) return modules$1;
  hasRequiredModules = 1;
  Object.defineProperty(modules$1, "__esModule", { value: true });
  modules$1.ExportAllDeclaration = ExportAllDeclaration;
  modules$1.ExportDefaultDeclaration = ExportDefaultDeclaration;
  modules$1.ExportDefaultSpecifier = ExportDefaultSpecifier;
  modules$1.ExportNamedDeclaration = ExportNamedDeclaration;
  modules$1.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
  modules$1.ExportSpecifier = ExportSpecifier;
  modules$1.ImportAttribute = ImportAttribute;
  modules$1.ImportDeclaration = ImportDeclaration;
  modules$1.ImportDefaultSpecifier = ImportDefaultSpecifier;
  modules$1.ImportExpression = ImportExpression;
  modules$1.ImportNamespaceSpecifier = ImportNamespaceSpecifier;
  modules$1.ImportSpecifier = ImportSpecifier;
  modules$1._printAttributes = _printAttributes;
  var _t = t$d;
  const {
    isClassDeclaration: isClassDeclaration,
    isExportDefaultSpecifier: isExportDefaultSpecifier,
    isExportNamespaceSpecifier: isExportNamespaceSpecifier,
    isImportDefaultSpecifier: isImportDefaultSpecifier,
    isImportNamespaceSpecifier: isImportNamespaceSpecifier,
    isStatement: isStatement,
  } = _t;
  function ImportSpecifier(node) {
    if (node.importKind === "type" || node.importKind === "typeof") {
      this.word(node.importKind);
      this.space();
    }
    this.print(node.imported, node);
    if (node.local && node.local.name !== node.imported.name) {
      this.space();
      this.word("as");
      this.space();
      this.print(node.local, node);
    }
  }
  function ImportDefaultSpecifier(node) {
    this.print(node.local, node);
  }
  function ExportDefaultSpecifier(node) {
    this.print(node.exported, node);
  }
  function ExportSpecifier(node) {
    if (node.exportKind === "type") {
      this.word("type");
      this.space();
    }
    this.print(node.local, node);
    if (node.exported && node.local.name !== node.exported.name) {
      this.space();
      this.word("as");
      this.space();
      this.print(node.exported, node);
    }
  }
  function ExportNamespaceSpecifier(node) {
    this.tokenChar(42);
    this.space();
    this.word("as");
    this.space();
    this.print(node.exported, node);
  }
  let warningShown = false;
  function _printAttributes(node) {
    const { importAttributesKeyword: importAttributesKeyword } = this.format;
    const { attributes: attributes, assertions: assertions } = node;
    if (attributes && !importAttributesKeyword && !warningShown) {
      warningShown = true;
      console.warn(
        `You are using import attributes, without specifying the desired output syntax.\nPlease specify the "importAttributesKeyword" generator option, whose value can be one of:\n - "with"        : \`import { a } from "b" with { type: "json" };\`\n - "assert"      : \`import { a } from "b" assert { type: "json" };\`\n - "with-legacy" : \`import { a } from "b" with type: "json";\`\n`,
      );
    }
    const useAssertKeyword =
      importAttributesKeyword === "assert" ||
      (!importAttributesKeyword && assertions);
    this.word(useAssertKeyword ? "assert" : "with");
    this.space();
    if (!useAssertKeyword && importAttributesKeyword !== "with") {
      this.printList(attributes || assertions, node);
      return;
    }
    this.tokenChar(123);
    this.space();
    this.printList(attributes || assertions, node);
    this.space();
    this.tokenChar(125);
  }
  function ExportAllDeclaration(node) {
    var _node$attributes, _node$assertions;
    this.word("export");
    this.space();
    if (node.exportKind === "type") {
      this.word("type");
      this.space();
    }
    this.tokenChar(42);
    this.space();
    this.word("from");
    this.space();
    if (
      ((_node$attributes = node.attributes) != null &&
        _node$attributes.length) ||
      ((_node$assertions = node.assertions) != null && _node$assertions.length)
    ) {
      this.print(node.source, node, true);
      this.space();
      this._printAttributes(node);
    } else {
      this.print(node.source, node);
    }
    this.semicolon();
  }
  function maybePrintDecoratorsBeforeExport(printer, node) {
    if (
      isClassDeclaration(node.declaration) &&
      printer._shouldPrintDecoratorsBeforeExport(node)
    ) {
      printer.printJoin(node.declaration.decorators, node);
    }
  }
  function ExportNamedDeclaration(node) {
    maybePrintDecoratorsBeforeExport(this, node);
    this.word("export");
    this.space();
    if (node.declaration) {
      const declar = node.declaration;
      this.print(declar, node);
      if (!isStatement(declar)) this.semicolon();
    } else {
      if (node.exportKind === "type") {
        this.word("type");
        this.space();
      }
      const specifiers = node.specifiers.slice(0);
      let hasSpecial = false;
      for (;;) {
        const first = specifiers[0];
        if (
          isExportDefaultSpecifier(first) ||
          isExportNamespaceSpecifier(first)
        ) {
          hasSpecial = true;
          this.print(specifiers.shift(), node);
          if (specifiers.length) {
            this.tokenChar(44);
            this.space();
          }
        } else {
          break;
        }
      }
      if (specifiers.length || (!specifiers.length && !hasSpecial)) {
        this.tokenChar(123);
        if (specifiers.length) {
          this.space();
          this.printList(specifiers, node);
          this.space();
        }
        this.tokenChar(125);
      }
      if (node.source) {
        var _node$attributes2, _node$assertions2;
        this.space();
        this.word("from");
        this.space();
        if (
          ((_node$attributes2 = node.attributes) != null &&
            _node$attributes2.length) ||
          ((_node$assertions2 = node.assertions) != null &&
            _node$assertions2.length)
        ) {
          this.print(node.source, node, true);
          this.space();
          this._printAttributes(node);
        } else {
          this.print(node.source, node);
        }
      }
      this.semicolon();
    }
  }
  function ExportDefaultDeclaration(node) {
    maybePrintDecoratorsBeforeExport(this, node);
    this.word("export");
    this.noIndentInnerCommentsHere();
    this.space();
    this.word("default");
    this.space();
    const declar = node.declaration;
    this.print(declar, node);
    if (!isStatement(declar)) this.semicolon();
  }
  function ImportDeclaration(node) {
    var _node$attributes3, _node$assertions3;
    this.word("import");
    this.space();
    const isTypeKind =
      node.importKind === "type" || node.importKind === "typeof";
    if (isTypeKind) {
      this.noIndentInnerCommentsHere();
      this.word(node.importKind);
      this.space();
    } else if (node.module) {
      this.noIndentInnerCommentsHere();
      this.word("module");
      this.space();
    } else if (node.phase) {
      this.noIndentInnerCommentsHere();
      this.word(node.phase);
      this.space();
    }
    const specifiers = node.specifiers.slice(0);
    const hasSpecifiers = !!specifiers.length;
    while (hasSpecifiers) {
      const first = specifiers[0];
      if (
        isImportDefaultSpecifier(first) ||
        isImportNamespaceSpecifier(first)
      ) {
        this.print(specifiers.shift(), node);
        if (specifiers.length) {
          this.tokenChar(44);
          this.space();
        }
      } else {
        break;
      }
    }
    if (specifiers.length) {
      this.tokenChar(123);
      this.space();
      this.printList(specifiers, node);
      this.space();
      this.tokenChar(125);
    } else if (isTypeKind && !hasSpecifiers) {
      this.tokenChar(123);
      this.tokenChar(125);
    }
    if (hasSpecifiers || isTypeKind) {
      this.space();
      this.word("from");
      this.space();
    }
    if (
      ((_node$attributes3 = node.attributes) != null &&
        _node$attributes3.length) ||
      ((_node$assertions3 = node.assertions) != null &&
        _node$assertions3.length)
    ) {
      this.print(node.source, node, true);
      this.space();
      this._printAttributes(node);
    } else {
      this.print(node.source, node);
    }
    this.semicolon();
  }
  function ImportAttribute(node) {
    this.print(node.key);
    this.tokenChar(58);
    this.space();
    this.print(node.value);
  }
  function ImportNamespaceSpecifier(node) {
    this.tokenChar(42);
    this.space();
    this.word("as");
    this.space();
    this.print(node.local, node);
  }
  function ImportExpression(node) {
    this.word("import");
    if (node.phase) {
      this.tokenChar(46);
      this.word(node.phase);
    }
    this.tokenChar(40);
    this.print(node.source, node);
    if (node.options != null) {
      this.tokenChar(44);
      this.space();
      this.print(node.options, node);
    }
    this.tokenChar(41);
  }
  return modules$1;
}
var types$2 = {};
var jsesc_1;
var hasRequiredJsesc;
function requireJsesc() {
  if (hasRequiredJsesc) return jsesc_1;
  hasRequiredJsesc = 1;
  const object = {};
  const hasOwnProperty = object.hasOwnProperty;
  const forOwn = (object, callback) => {
    for (const key in object) {
      if (hasOwnProperty.call(object, key)) {
        callback(key, object[key]);
      }
    }
  };
  const extend = (destination, source) => {
    if (!source) {
      return destination;
    }
    forOwn(source, (key, value) => {
      destination[key] = value;
    });
    return destination;
  };
  const forEach = (array, callback) => {
    const length = array.length;
    let index = -1;
    while (++index < length) {
      callback(array[index]);
    }
  };
  const toString = object.toString;
  const isArray = Array.isArray;
  const isBuffer = Buffer.isBuffer;
  const isObject = (value) => toString.call(value) == "[object Object]";
  const isString = (value) =>
    typeof value == "string" || toString.call(value) == "[object String]";
  const isNumber = (value) =>
    typeof value == "number" || toString.call(value) == "[object Number]";
  const isFunction = (value) => typeof value == "function";
  const isMap = (value) => toString.call(value) == "[object Map]";
  const isSet = (value) => toString.call(value) == "[object Set]";
  const singleEscapes = {
    '"': '\\"',
    "'": "\\'",
    "\\": "\\\\",
    "\b": "\\b",
    "\f": "\\f",
    "\n": "\\n",
    "\r": "\\r",
    "\t": "\\t",
  };
  const regexSingleEscape = /["'\\\b\f\n\r\t]/;
  const regexDigit = /[0-9]/;
  const regexWhitelist = /[ !#-&\(-\[\]-_a-~]/;
  const jsesc = (argument, options) => {
    const increaseIndentation = () => {
      oldIndent = indent;
      ++options.indentLevel;
      indent = options.indent.repeat(options.indentLevel);
    };
    const defaults = {
      escapeEverything: false,
      minimal: false,
      isScriptContext: false,
      quotes: "single",
      wrap: false,
      es6: false,
      json: false,
      compact: true,
      lowercaseHex: false,
      numbers: "decimal",
      indent: "\t",
      indentLevel: 0,
      __inline1__: false,
      __inline2__: false,
    };
    const json = options && options.json;
    if (json) {
      defaults.quotes = "double";
      defaults.wrap = true;
    }
    options = extend(defaults, options);
    if (
      options.quotes != "single" &&
      options.quotes != "double" &&
      options.quotes != "backtick"
    ) {
      options.quotes = "single";
    }
    const quote =
      options.quotes == "double"
        ? '"'
        : options.quotes == "backtick"
          ? "`"
          : "'";
    const compact = options.compact;
    const lowercaseHex = options.lowercaseHex;
    let indent = options.indent.repeat(options.indentLevel);
    let oldIndent = "";
    const inline1 = options.__inline1__;
    const inline2 = options.__inline2__;
    const newLine = compact ? "" : "\n";
    let result;
    let isEmpty = true;
    const useBinNumbers = options.numbers == "binary";
    const useOctNumbers = options.numbers == "octal";
    const useDecNumbers = options.numbers == "decimal";
    const useHexNumbers = options.numbers == "hexadecimal";
    if (json && argument && isFunction(argument.toJSON)) {
      argument = argument.toJSON();
    }
    if (!isString(argument)) {
      if (isMap(argument)) {
        if (argument.size == 0) {
          return "new Map()";
        }
        if (!compact) {
          options.__inline1__ = true;
          options.__inline2__ = false;
        }
        return "new Map(" + jsesc(Array.from(argument), options) + ")";
      }
      if (isSet(argument)) {
        if (argument.size == 0) {
          return "new Set()";
        }
        return "new Set(" + jsesc(Array.from(argument), options) + ")";
      }
      if (isBuffer(argument)) {
        if (argument.length == 0) {
          return "Buffer.from([])";
        }
        return "Buffer.from(" + jsesc(Array.from(argument), options) + ")";
      }
      if (isArray(argument)) {
        result = [];
        options.wrap = true;
        if (inline1) {
          options.__inline1__ = false;
          options.__inline2__ = true;
        }
        if (!inline2) {
          increaseIndentation();
        }
        forEach(argument, (value) => {
          isEmpty = false;
          if (inline2) {
            options.__inline2__ = false;
          }
          result.push(
            (compact || inline2 ? "" : indent) + jsesc(value, options),
          );
        });
        if (isEmpty) {
          return "[]";
        }
        if (inline2) {
          return "[" + result.join(", ") + "]";
        }
        return (
          "[" +
          newLine +
          result.join("," + newLine) +
          newLine +
          (compact ? "" : oldIndent) +
          "]"
        );
      } else if (isNumber(argument)) {
        if (json) {
          return JSON.stringify(argument);
        }
        if (useDecNumbers) {
          return String(argument);
        }
        if (useHexNumbers) {
          let hexadecimal = argument.toString(16);
          if (!lowercaseHex) {
            hexadecimal = hexadecimal.toUpperCase();
          }
          return "0x" + hexadecimal;
        }
        if (useBinNumbers) {
          return "0b" + argument.toString(2);
        }
        if (useOctNumbers) {
          return "0o" + argument.toString(8);
        }
      } else if (!isObject(argument)) {
        if (json) {
          return JSON.stringify(argument) || "null";
        }
        return String(argument);
      } else {
        result = [];
        options.wrap = true;
        increaseIndentation();
        forOwn(argument, (key, value) => {
          isEmpty = false;
          result.push(
            (compact ? "" : indent) +
              jsesc(key, options) +
              ":" +
              (compact ? "" : " ") +
              jsesc(value, options),
          );
        });
        if (isEmpty) {
          return "{}";
        }
        return (
          "{" +
          newLine +
          result.join("," + newLine) +
          newLine +
          (compact ? "" : oldIndent) +
          "}"
        );
      }
    }
    const string = argument;
    let index = -1;
    const length = string.length;
    result = "";
    while (++index < length) {
      const character = string.charAt(index);
      if (options.es6) {
        const first = string.charCodeAt(index);
        if (first >= 55296 && first <= 56319 && length > index + 1) {
          const second = string.charCodeAt(index + 1);
          if (second >= 56320 && second <= 57343) {
            const codePoint = (first - 55296) * 1024 + second - 56320 + 65536;
            let hexadecimal = codePoint.toString(16);
            if (!lowercaseHex) {
              hexadecimal = hexadecimal.toUpperCase();
            }
            result += "\\u{" + hexadecimal + "}";
            ++index;
            continue;
          }
        }
      }
      if (!options.escapeEverything) {
        if (regexWhitelist.test(character)) {
          result += character;
          continue;
        }
        if (character == '"') {
          result += quote == character ? '\\"' : character;
          continue;
        }
        if (character == "`") {
          result += quote == character ? "\\`" : character;
          continue;
        }
        if (character == "'") {
          result += quote == character ? "\\'" : character;
          continue;
        }
      }
      if (
        character == "\0" &&
        !json &&
        !regexDigit.test(string.charAt(index + 1))
      ) {
        result += "\\0";
        continue;
      }
      if (regexSingleEscape.test(character)) {
        result += singleEscapes[character];
        continue;
      }
      const charCode = character.charCodeAt(0);
      if (options.minimal && charCode != 8232 && charCode != 8233) {
        result += character;
        continue;
      }
      let hexadecimal = charCode.toString(16);
      if (!lowercaseHex) {
        hexadecimal = hexadecimal.toUpperCase();
      }
      const longhand = hexadecimal.length > 2 || json;
      const escaped =
        "\\" +
        (longhand ? "u" : "x") +
        ("0000" + hexadecimal).slice(longhand ? -4 : -2);
      result += escaped;
      continue;
    }
    if (options.wrap) {
      result = quote + result + quote;
    }
    if (quote == "`") {
      result = result.replace(/\$\{/g, "\\${");
    }
    if (options.isScriptContext) {
      return result
        .replace(/<\/(script|style)/gi, "<\\/$1")
        .replace(/<!--/g, json ? "\\u003C!--" : "\\x3C!--");
    }
    return result;
  };
  jsesc.version = "2.5.2";
  jsesc_1 = jsesc;
  return jsesc_1;
}
var hasRequiredTypes;
function requireTypes() {
  if (hasRequiredTypes) return types$2;
  hasRequiredTypes = 1;
  Object.defineProperty(types$2, "__esModule", { value: true });
  types$2.ArgumentPlaceholder = ArgumentPlaceholder;
  types$2.ArrayPattern = types$2.ArrayExpression = ArrayExpression;
  types$2.BigIntLiteral = BigIntLiteral;
  types$2.BooleanLiteral = BooleanLiteral;
  types$2.DecimalLiteral = DecimalLiteral;
  types$2.Identifier = Identifier;
  types$2.NullLiteral = NullLiteral;
  types$2.NumericLiteral = NumericLiteral;
  types$2.ObjectPattern = types$2.ObjectExpression = ObjectExpression;
  types$2.ObjectMethod = ObjectMethod;
  types$2.ObjectProperty = ObjectProperty;
  types$2.PipelineBareFunction = PipelineBareFunction;
  types$2.PipelinePrimaryTopicReference = PipelinePrimaryTopicReference;
  types$2.PipelineTopicExpression = PipelineTopicExpression;
  types$2.RecordExpression = RecordExpression;
  types$2.RegExpLiteral = RegExpLiteral;
  types$2.SpreadElement = types$2.RestElement = RestElement;
  types$2.StringLiteral = StringLiteral;
  types$2.TopicReference = TopicReference;
  types$2.TupleExpression = TupleExpression;
  var _t = t$d;
  var _jsesc = requireJsesc();
  const {
    isAssignmentPattern: isAssignmentPattern,
    isIdentifier: isIdentifier,
  } = _t;
  function Identifier(node) {
    var _node$loc;
    this.sourceIdentifierName(
      ((_node$loc = node.loc) == null ? void 0 : _node$loc.identifierName) ||
        node.name,
    );
    this.word(node.name);
  }
  function ArgumentPlaceholder() {
    this.tokenChar(63);
  }
  function RestElement(node) {
    this.token("...");
    this.print(node.argument, node);
  }
  function ObjectExpression(node) {
    const props = node.properties;
    this.tokenChar(123);
    if (props.length) {
      this.space();
      this.printList(props, node, { indent: true, statement: true });
      this.space();
    }
    this.sourceWithOffset("end", node.loc, -1);
    this.tokenChar(125);
  }
  function ObjectMethod(node) {
    this.printJoin(node.decorators, node);
    this._methodHead(node);
    this.space();
    this.print(node.body, node);
  }
  function ObjectProperty(node) {
    this.printJoin(node.decorators, node);
    if (node.computed) {
      this.tokenChar(91);
      this.print(node.key, node);
      this.tokenChar(93);
    } else {
      if (
        isAssignmentPattern(node.value) &&
        isIdentifier(node.key) &&
        node.key.name === node.value.left.name
      ) {
        this.print(node.value, node);
        return;
      }
      this.print(node.key, node);
      if (
        node.shorthand &&
        isIdentifier(node.key) &&
        isIdentifier(node.value) &&
        node.key.name === node.value.name
      ) {
        return;
      }
    }
    this.tokenChar(58);
    this.space();
    this.print(node.value, node);
  }
  function ArrayExpression(node) {
    const elems = node.elements;
    const len = elems.length;
    this.tokenChar(91);
    for (let i = 0; i < elems.length; i++) {
      const elem = elems[i];
      if (elem) {
        if (i > 0) this.space();
        this.print(elem, node);
        if (i < len - 1) this.tokenChar(44);
      } else {
        this.tokenChar(44);
      }
    }
    this.tokenChar(93);
  }
  function RecordExpression(node) {
    const props = node.properties;
    let startToken;
    let endToken;
    if (this.format.recordAndTupleSyntaxType === "bar") {
      startToken = "{|";
      endToken = "|}";
    } else if (
      this.format.recordAndTupleSyntaxType !== "hash" &&
      this.format.recordAndTupleSyntaxType != null
    ) {
      throw new Error(
        `The "recordAndTupleSyntaxType" generator option must be "bar" or "hash" (${JSON.stringify(this.format.recordAndTupleSyntaxType)} received).`,
      );
    } else {
      startToken = "#{";
      endToken = "}";
    }
    this.token(startToken);
    if (props.length) {
      this.space();
      this.printList(props, node, { indent: true, statement: true });
      this.space();
    }
    this.token(endToken);
  }
  function TupleExpression(node) {
    const elems = node.elements;
    const len = elems.length;
    let startToken;
    let endToken;
    if (this.format.recordAndTupleSyntaxType === "bar") {
      startToken = "[|";
      endToken = "|]";
    } else if (this.format.recordAndTupleSyntaxType === "hash") {
      startToken = "#[";
      endToken = "]";
    } else {
      throw new Error(
        `${this.format.recordAndTupleSyntaxType} is not a valid recordAndTuple syntax type`,
      );
    }
    this.token(startToken);
    for (let i = 0; i < elems.length; i++) {
      const elem = elems[i];
      if (elem) {
        if (i > 0) this.space();
        this.print(elem, node);
        if (i < len - 1) this.tokenChar(44);
      }
    }
    this.token(endToken);
  }
  function RegExpLiteral(node) {
    this.word(`/${node.pattern}/${node.flags}`);
  }
  function BooleanLiteral(node) {
    this.word(node.value ? "true" : "false");
  }
  function NullLiteral() {
    this.word("null");
  }
  function NumericLiteral(node) {
    const raw = this.getPossibleRaw(node);
    const opts = this.format.jsescOption;
    const value = node.value;
    const str = value + "";
    if (opts.numbers) {
      this.number(_jsesc(value, opts), value);
    } else if (raw == null) {
      this.number(str, value);
    } else if (this.format.minified) {
      this.number(raw.length < str.length ? raw : str, value);
    } else {
      this.number(raw, value);
    }
  }
  function StringLiteral(node) {
    const raw = this.getPossibleRaw(node);
    if (!this.format.minified && raw !== undefined) {
      this.token(raw);
      return;
    }
    const val = _jsesc(node.value, this.format.jsescOption);
    this.token(val);
  }
  function BigIntLiteral(node) {
    const raw = this.getPossibleRaw(node);
    if (!this.format.minified && raw !== undefined) {
      this.word(raw);
      return;
    }
    this.word(node.value + "n");
  }
  function DecimalLiteral(node) {
    const raw = this.getPossibleRaw(node);
    if (!this.format.minified && raw !== undefined) {
      this.word(raw);
      return;
    }
    this.word(node.value + "m");
  }
  const validTopicTokenSet = new Set(["^^", "@@", "^", "%", "#"]);
  function TopicReference() {
    const { topicToken: topicToken } = this.format;
    if (validTopicTokenSet.has(topicToken)) {
      this.token(topicToken);
    } else {
      const givenTopicTokenJSON = JSON.stringify(topicToken);
      const validTopics = Array.from(validTopicTokenSet, (v) =>
        JSON.stringify(v),
      );
      throw new Error(
        `The "topicToken" generator option must be one of ` +
          `${validTopics.join(", ")} (${givenTopicTokenJSON} received instead).`,
      );
    }
  }
  function PipelineTopicExpression(node) {
    this.print(node.expression, node);
  }
  function PipelineBareFunction(node) {
    this.print(node.callee, node);
  }
  function PipelinePrimaryTopicReference() {
    this.tokenChar(35);
  }
  return types$2;
}
var flow$2 = {};
var hasRequiredFlow;
function requireFlow() {
  if (hasRequiredFlow) return flow$2;
  hasRequiredFlow = 1;
  (function (exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.AnyTypeAnnotation = AnyTypeAnnotation;
    exports.ArrayTypeAnnotation = ArrayTypeAnnotation;
    exports.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
    exports.BooleanTypeAnnotation = BooleanTypeAnnotation;
    exports.DeclareClass = DeclareClass;
    exports.DeclareExportAllDeclaration = DeclareExportAllDeclaration;
    exports.DeclareExportDeclaration = DeclareExportDeclaration;
    exports.DeclareFunction = DeclareFunction;
    exports.DeclareInterface = DeclareInterface;
    exports.DeclareModule = DeclareModule;
    exports.DeclareModuleExports = DeclareModuleExports;
    exports.DeclareOpaqueType = DeclareOpaqueType;
    exports.DeclareTypeAlias = DeclareTypeAlias;
    exports.DeclareVariable = DeclareVariable;
    exports.DeclaredPredicate = DeclaredPredicate;
    exports.EmptyTypeAnnotation = EmptyTypeAnnotation;
    exports.EnumBooleanBody = EnumBooleanBody;
    exports.EnumBooleanMember = EnumBooleanMember;
    exports.EnumDeclaration = EnumDeclaration;
    exports.EnumDefaultedMember = EnumDefaultedMember;
    exports.EnumNumberBody = EnumNumberBody;
    exports.EnumNumberMember = EnumNumberMember;
    exports.EnumStringBody = EnumStringBody;
    exports.EnumStringMember = EnumStringMember;
    exports.EnumSymbolBody = EnumSymbolBody;
    exports.ExistsTypeAnnotation = ExistsTypeAnnotation;
    exports.FunctionTypeAnnotation = FunctionTypeAnnotation;
    exports.FunctionTypeParam = FunctionTypeParam;
    exports.IndexedAccessType = IndexedAccessType;
    exports.InferredPredicate = InferredPredicate;
    exports.InterfaceDeclaration = InterfaceDeclaration;
    exports.GenericTypeAnnotation =
      exports.ClassImplements =
      exports.InterfaceExtends =
        InterfaceExtends;
    exports.InterfaceTypeAnnotation = InterfaceTypeAnnotation;
    exports.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
    exports.MixedTypeAnnotation = MixedTypeAnnotation;
    exports.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
    exports.NullableTypeAnnotation = NullableTypeAnnotation;
    Object.defineProperty(exports, "NumberLiteralTypeAnnotation", {
      enumerable: true,
      get: function () {
        return _types2.NumericLiteral;
      },
    });
    exports.NumberTypeAnnotation = NumberTypeAnnotation;
    exports.ObjectTypeAnnotation = ObjectTypeAnnotation;
    exports.ObjectTypeCallProperty = ObjectTypeCallProperty;
    exports.ObjectTypeIndexer = ObjectTypeIndexer;
    exports.ObjectTypeInternalSlot = ObjectTypeInternalSlot;
    exports.ObjectTypeProperty = ObjectTypeProperty;
    exports.ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
    exports.OpaqueType = OpaqueType;
    exports.OptionalIndexedAccessType = OptionalIndexedAccessType;
    exports.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
    Object.defineProperty(exports, "StringLiteralTypeAnnotation", {
      enumerable: true,
      get: function () {
        return _types2.StringLiteral;
      },
    });
    exports.StringTypeAnnotation = StringTypeAnnotation;
    exports.SymbolTypeAnnotation = SymbolTypeAnnotation;
    exports.ThisTypeAnnotation = ThisTypeAnnotation;
    exports.TupleTypeAnnotation = TupleTypeAnnotation;
    exports.TypeAlias = TypeAlias;
    exports.TypeAnnotation = TypeAnnotation;
    exports.TypeCastExpression = TypeCastExpression;
    exports.TypeParameter = TypeParameter;
    exports.TypeParameterDeclaration = exports.TypeParameterInstantiation =
      TypeParameterInstantiation;
    exports.TypeofTypeAnnotation = TypeofTypeAnnotation;
    exports.UnionTypeAnnotation = UnionTypeAnnotation;
    exports.Variance = Variance;
    exports.VoidTypeAnnotation = VoidTypeAnnotation;
    exports._interfaceish = _interfaceish;
    exports._variance = _variance;
    var _t = t$d;
    var _modules = requireModules();
    var _types2 = requireTypes();
    const {
      isDeclareExportDeclaration: isDeclareExportDeclaration,
      isStatement: isStatement,
    } = _t;
    function AnyTypeAnnotation() {
      this.word("any");
    }
    function ArrayTypeAnnotation(node) {
      this.print(node.elementType, node, true);
      this.tokenChar(91);
      this.tokenChar(93);
    }
    function BooleanTypeAnnotation() {
      this.word("boolean");
    }
    function BooleanLiteralTypeAnnotation(node) {
      this.word(node.value ? "true" : "false");
    }
    function NullLiteralTypeAnnotation() {
      this.word("null");
    }
    function DeclareClass(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("class");
      this.space();
      this._interfaceish(node);
    }
    function DeclareFunction(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("function");
      this.space();
      this.print(node.id, node);
      this.print(node.id.typeAnnotation.typeAnnotation, node);
      if (node.predicate) {
        this.space();
        this.print(node.predicate, node);
      }
      this.semicolon();
    }
    function InferredPredicate() {
      this.tokenChar(37);
      this.word("checks");
    }
    function DeclaredPredicate(node) {
      this.tokenChar(37);
      this.word("checks");
      this.tokenChar(40);
      this.print(node.value, node);
      this.tokenChar(41);
    }
    function DeclareInterface(node) {
      this.word("declare");
      this.space();
      this.InterfaceDeclaration(node);
    }
    function DeclareModule(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.space();
      this.print(node.id, node);
      this.space();
      this.print(node.body, node);
    }
    function DeclareModuleExports(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.tokenChar(46);
      this.word("exports");
      this.print(node.typeAnnotation, node);
    }
    function DeclareTypeAlias(node) {
      this.word("declare");
      this.space();
      this.TypeAlias(node);
    }
    function DeclareOpaqueType(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.OpaqueType(node);
    }
    function DeclareVariable(node, parent) {
      if (!isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("var");
      this.space();
      this.print(node.id, node);
      this.print(node.id.typeAnnotation, node);
      this.semicolon();
    }
    function DeclareExportDeclaration(node) {
      this.word("declare");
      this.space();
      this.word("export");
      this.space();
      if (node.default) {
        this.word("default");
        this.space();
      }
      FlowExportDeclaration.call(this, node);
    }
    function DeclareExportAllDeclaration(node) {
      this.word("declare");
      this.space();
      _modules.ExportAllDeclaration.call(this, node);
    }
    function EnumDeclaration(node) {
      const { id: id, body: body } = node;
      this.word("enum");
      this.space();
      this.print(id, node);
      this.print(body, node);
    }
    function enumExplicitType(context, name, hasExplicitType) {
      if (hasExplicitType) {
        context.space();
        context.word("of");
        context.space();
        context.word(name);
      }
      context.space();
    }
    function enumBody(context, node) {
      const { members: members } = node;
      context.token("{");
      context.indent();
      context.newline();
      for (const member of members) {
        context.print(member, node);
        context.newline();
      }
      if (node.hasUnknownMembers) {
        context.token("...");
        context.newline();
      }
      context.dedent();
      context.token("}");
    }
    function EnumBooleanBody(node) {
      const { explicitType: explicitType } = node;
      enumExplicitType(this, "boolean", explicitType);
      enumBody(this, node);
    }
    function EnumNumberBody(node) {
      const { explicitType: explicitType } = node;
      enumExplicitType(this, "number", explicitType);
      enumBody(this, node);
    }
    function EnumStringBody(node) {
      const { explicitType: explicitType } = node;
      enumExplicitType(this, "string", explicitType);
      enumBody(this, node);
    }
    function EnumSymbolBody(node) {
      enumExplicitType(this, "symbol", true);
      enumBody(this, node);
    }
    function EnumDefaultedMember(node) {
      const { id: id } = node;
      this.print(id, node);
      this.tokenChar(44);
    }
    function enumInitializedMember(context, node) {
      const { id: id, init: init } = node;
      context.print(id, node);
      context.space();
      context.token("=");
      context.space();
      context.print(init, node);
      context.token(",");
    }
    function EnumBooleanMember(node) {
      enumInitializedMember(this, node);
    }
    function EnumNumberMember(node) {
      enumInitializedMember(this, node);
    }
    function EnumStringMember(node) {
      enumInitializedMember(this, node);
    }
    function FlowExportDeclaration(node) {
      if (node.declaration) {
        const declar = node.declaration;
        this.print(declar, node);
        if (!isStatement(declar)) this.semicolon();
      } else {
        this.tokenChar(123);
        if (node.specifiers.length) {
          this.space();
          this.printList(node.specifiers, node);
          this.space();
        }
        this.tokenChar(125);
        if (node.source) {
          this.space();
          this.word("from");
          this.space();
          this.print(node.source, node);
        }
        this.semicolon();
      }
    }
    function ExistsTypeAnnotation() {
      this.tokenChar(42);
    }
    function FunctionTypeAnnotation(node, parent) {
      this.print(node.typeParameters, node);
      this.tokenChar(40);
      if (node.this) {
        this.word("this");
        this.tokenChar(58);
        this.space();
        this.print(node.this.typeAnnotation, node);
        if (node.params.length || node.rest) {
          this.tokenChar(44);
          this.space();
        }
      }
      this.printList(node.params, node);
      if (node.rest) {
        if (node.params.length) {
          this.tokenChar(44);
          this.space();
        }
        this.token("...");
        this.print(node.rest, node);
      }
      this.tokenChar(41);
      const type = parent == null ? void 0 : parent.type;
      if (
        type != null &&
        (type === "ObjectTypeCallProperty" ||
          type === "ObjectTypeInternalSlot" ||
          type === "DeclareFunction" ||
          (type === "ObjectTypeProperty" && parent.method))
      ) {
        this.tokenChar(58);
      } else {
        this.space();
        this.token("=>");
      }
      this.space();
      this.print(node.returnType, node);
    }
    function FunctionTypeParam(node) {
      this.print(node.name, node);
      if (node.optional) this.tokenChar(63);
      if (node.name) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.typeAnnotation, node);
    }
    function InterfaceExtends(node) {
      this.print(node.id, node);
      this.print(node.typeParameters, node, true);
    }
    function _interfaceish(node) {
      var _node$extends;
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      if ((_node$extends = node.extends) != null && _node$extends.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends, node);
      }
      if (node.type === "DeclareClass") {
        var _node$mixins, _node$implements;
        if ((_node$mixins = node.mixins) != null && _node$mixins.length) {
          this.space();
          this.word("mixins");
          this.space();
          this.printList(node.mixins, node);
        }
        if (
          (_node$implements = node.implements) != null &&
          _node$implements.length
        ) {
          this.space();
          this.word("implements");
          this.space();
          this.printList(node.implements, node);
        }
      }
      this.space();
      this.print(node.body, node);
    }
    function _variance(node) {
      var _node$variance;
      const kind =
        (_node$variance = node.variance) == null ? void 0 : _node$variance.kind;
      if (kind != null) {
        if (kind === "plus") {
          this.tokenChar(43);
        } else if (kind === "minus") {
          this.tokenChar(45);
        }
      }
    }
    function InterfaceDeclaration(node) {
      this.word("interface");
      this.space();
      this._interfaceish(node);
    }
    function andSeparator() {
      this.space();
      this.tokenChar(38);
      this.space();
    }
    function InterfaceTypeAnnotation(node) {
      var _node$extends2;
      this.word("interface");
      if ((_node$extends2 = node.extends) != null && _node$extends2.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends, node);
      }
      this.space();
      this.print(node.body, node);
    }
    function IntersectionTypeAnnotation(node) {
      this.printJoin(node.types, node, { separator: andSeparator });
    }
    function MixedTypeAnnotation() {
      this.word("mixed");
    }
    function EmptyTypeAnnotation() {
      this.word("empty");
    }
    function NullableTypeAnnotation(node) {
      this.tokenChar(63);
      this.print(node.typeAnnotation, node);
    }
    function NumberTypeAnnotation() {
      this.word("number");
    }
    function StringTypeAnnotation() {
      this.word("string");
    }
    function ThisTypeAnnotation() {
      this.word("this");
    }
    function TupleTypeAnnotation(node) {
      this.tokenChar(91);
      this.printList(node.types, node);
      this.tokenChar(93);
    }
    function TypeofTypeAnnotation(node) {
      this.word("typeof");
      this.space();
      this.print(node.argument, node);
    }
    function TypeAlias(node) {
      this.word("type");
      this.space();
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.right, node);
      this.semicolon();
    }
    function TypeAnnotation(node) {
      this.tokenChar(58);
      this.space();
      if (node.optional) this.tokenChar(63);
      this.print(node.typeAnnotation, node);
    }
    function TypeParameterInstantiation(node) {
      this.tokenChar(60);
      this.printList(node.params, node, {});
      this.tokenChar(62);
    }
    function TypeParameter(node) {
      this._variance(node);
      this.word(node.name);
      if (node.bound) {
        this.print(node.bound, node);
      }
      if (node.default) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.default, node);
      }
    }
    function OpaqueType(node) {
      this.word("opaque");
      this.space();
      this.word("type");
      this.space();
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      if (node.supertype) {
        this.tokenChar(58);
        this.space();
        this.print(node.supertype, node);
      }
      if (node.impltype) {
        this.space();
        this.tokenChar(61);
        this.space();
        this.print(node.impltype, node);
      }
      this.semicolon();
    }
    function ObjectTypeAnnotation(node) {
      if (node.exact) {
        this.token("{|");
      } else {
        this.tokenChar(123);
      }
      const props = [
        ...node.properties,
        ...(node.callProperties || []),
        ...(node.indexers || []),
        ...(node.internalSlots || []),
      ];
      if (props.length) {
        this.newline();
        this.space();
        this.printJoin(props, node, {
          addNewlines(leading) {
            if (leading && !props[0]) return 1;
          },
          indent: true,
          statement: true,
          iterator: () => {
            if (props.length !== 1 || node.inexact) {
              this.tokenChar(44);
              this.space();
            }
          },
        });
        this.space();
      }
      if (node.inexact) {
        this.indent();
        this.token("...");
        if (props.length) {
          this.newline();
        }
        this.dedent();
      }
      if (node.exact) {
        this.token("|}");
      } else {
        this.tokenChar(125);
      }
    }
    function ObjectTypeInternalSlot(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.tokenChar(91);
      this.tokenChar(91);
      this.print(node.id, node);
      this.tokenChar(93);
      this.tokenChar(93);
      if (node.optional) this.tokenChar(63);
      if (!node.method) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeCallProperty(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeIndexer(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this._variance(node);
      this.tokenChar(91);
      if (node.id) {
        this.print(node.id, node);
        this.tokenChar(58);
        this.space();
      }
      this.print(node.key, node);
      this.tokenChar(93);
      this.tokenChar(58);
      this.space();
      this.print(node.value, node);
    }
    function ObjectTypeProperty(node) {
      if (node.proto) {
        this.word("proto");
        this.space();
      }
      if (node.static) {
        this.word("static");
        this.space();
      }
      if (node.kind === "get" || node.kind === "set") {
        this.word(node.kind);
        this.space();
      }
      this._variance(node);
      this.print(node.key, node);
      if (node.optional) this.tokenChar(63);
      if (!node.method) {
        this.tokenChar(58);
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeSpreadProperty(node) {
      this.token("...");
      this.print(node.argument, node);
    }
    function QualifiedTypeIdentifier(node) {
      this.print(node.qualification, node);
      this.tokenChar(46);
      this.print(node.id, node);
    }
    function SymbolTypeAnnotation() {
      this.word("symbol");
    }
    function orSeparator() {
      this.space();
      this.tokenChar(124);
      this.space();
    }
    function UnionTypeAnnotation(node) {
      this.printJoin(node.types, node, { separator: orSeparator });
    }
    function TypeCastExpression(node) {
      this.tokenChar(40);
      this.print(node.expression, node);
      this.print(node.typeAnnotation, node);
      this.tokenChar(41);
    }
    function Variance(node) {
      if (node.kind === "plus") {
        this.tokenChar(43);
      } else {
        this.tokenChar(45);
      }
    }
    function VoidTypeAnnotation() {
      this.word("void");
    }
    function IndexedAccessType(node) {
      this.print(node.objectType, node, true);
      this.tokenChar(91);
      this.print(node.indexType, node);
      this.tokenChar(93);
    }
    function OptionalIndexedAccessType(node) {
      this.print(node.objectType, node);
      if (node.optional) {
        this.token("?.");
      }
      this.tokenChar(91);
      this.print(node.indexType, node);
      this.tokenChar(93);
    }
  })(flow$2);
  return flow$2;
}
var base$1 = {};
var hasRequiredBase;
function requireBase() {
  if (hasRequiredBase) return base$1;
  hasRequiredBase = 1;
  Object.defineProperty(base$1, "__esModule", { value: true });
  base$1.BlockStatement = BlockStatement;
  base$1.Directive = Directive;
  base$1.DirectiveLiteral = DirectiveLiteral;
  base$1.File = File;
  base$1.InterpreterDirective = InterpreterDirective;
  base$1.Placeholder = Placeholder;
  base$1.Program = Program;
  function File(node) {
    if (node.program) {
      this.print(node.program.interpreter, node);
    }
    this.print(node.program, node);
  }
  function Program(node) {
    var _node$directives;
    this.noIndentInnerCommentsHere();
    this.printInnerComments();
    const directivesLen =
      (_node$directives = node.directives) == null
        ? void 0
        : _node$directives.length;
    if (directivesLen) {
      var _node$directives$trai;
      const newline = node.body.length ? 2 : 1;
      this.printSequence(node.directives, node, {
        trailingCommentsLineOffset: newline,
      });
      if (
        !(
          (_node$directives$trai =
            node.directives[directivesLen - 1].trailingComments) != null &&
          _node$directives$trai.length
        )
      ) {
        this.newline(newline);
      }
    }
    this.printSequence(node.body, node);
  }
  function BlockStatement(node) {
    var _node$directives2;
    this.tokenChar(123);
    const directivesLen =
      (_node$directives2 = node.directives) == null
        ? void 0
        : _node$directives2.length;
    if (directivesLen) {
      var _node$directives$trai2;
      const newline = node.body.length ? 2 : 1;
      this.printSequence(node.directives, node, {
        indent: true,
        trailingCommentsLineOffset: newline,
      });
      if (
        !(
          (_node$directives$trai2 =
            node.directives[directivesLen - 1].trailingComments) != null &&
          _node$directives$trai2.length
        )
      ) {
        this.newline(newline);
      }
    }
    this.printSequence(node.body, node, { indent: true });
    this.rightBrace(node);
  }
  function Directive(node) {
    this.print(node.value, node);
    this.semicolon();
  }
  const unescapedSingleQuoteRE = /(?:^|[^\\])(?:\\\\)*'/;
  const unescapedDoubleQuoteRE = /(?:^|[^\\])(?:\\\\)*"/;
  function DirectiveLiteral(node) {
    const raw = this.getPossibleRaw(node);
    if (!this.format.minified && raw !== undefined) {
      this.token(raw);
      return;
    }
    const { value: value } = node;
    if (!unescapedDoubleQuoteRE.test(value)) {
      this.token(`"${value}"`);
    } else if (!unescapedSingleQuoteRE.test(value)) {
      this.token(`'${value}'`);
    } else {
      throw new Error(
        "Malformed AST: it is not possible to print a directive containing" +
          " both unescaped single and double quotes.",
      );
    }
  }
  function InterpreterDirective(node) {
    this.token(`#!${node.value}`);
    this.newline(1, true);
  }
  function Placeholder(node) {
    this.token("%%");
    this.print(node.name);
    this.token("%%");
    if (node.expectedNode === "Statement") {
      this.semicolon();
    }
  }
  return base$1;
}
var jsx$2 = {};
var hasRequiredJsx;
function requireJsx() {
  if (hasRequiredJsx) return jsx$2;
  hasRequiredJsx = 1;
  Object.defineProperty(jsx$2, "__esModule", { value: true });
  jsx$2.JSXAttribute = JSXAttribute;
  jsx$2.JSXClosingElement = JSXClosingElement;
  jsx$2.JSXClosingFragment = JSXClosingFragment;
  jsx$2.JSXElement = JSXElement;
  jsx$2.JSXEmptyExpression = JSXEmptyExpression;
  jsx$2.JSXExpressionContainer = JSXExpressionContainer;
  jsx$2.JSXFragment = JSXFragment;
  jsx$2.JSXIdentifier = JSXIdentifier;
  jsx$2.JSXMemberExpression = JSXMemberExpression;
  jsx$2.JSXNamespacedName = JSXNamespacedName;
  jsx$2.JSXOpeningElement = JSXOpeningElement;
  jsx$2.JSXOpeningFragment = JSXOpeningFragment;
  jsx$2.JSXSpreadAttribute = JSXSpreadAttribute;
  jsx$2.JSXSpreadChild = JSXSpreadChild;
  jsx$2.JSXText = JSXText;
  function JSXAttribute(node) {
    this.print(node.name, node);
    if (node.value) {
      this.tokenChar(61);
      this.print(node.value, node);
    }
  }
  function JSXIdentifier(node) {
    this.word(node.name);
  }
  function JSXNamespacedName(node) {
    this.print(node.namespace, node);
    this.tokenChar(58);
    this.print(node.name, node);
  }
  function JSXMemberExpression(node) {
    this.print(node.object, node);
    this.tokenChar(46);
    this.print(node.property, node);
  }
  function JSXSpreadAttribute(node) {
    this.tokenChar(123);
    this.token("...");
    this.print(node.argument, node);
    this.tokenChar(125);
  }
  function JSXExpressionContainer(node) {
    this.tokenChar(123);
    this.print(node.expression, node);
    this.tokenChar(125);
  }
  function JSXSpreadChild(node) {
    this.tokenChar(123);
    this.token("...");
    this.print(node.expression, node);
    this.tokenChar(125);
  }
  function JSXText(node) {
    const raw = this.getPossibleRaw(node);
    if (raw !== undefined) {
      this.token(raw, true);
    } else {
      this.token(node.value, true);
    }
  }
  function JSXElement(node) {
    const open = node.openingElement;
    this.print(open, node);
    if (open.selfClosing) return;
    this.indent();
    for (const child of node.children) {
      this.print(child, node);
    }
    this.dedent();
    this.print(node.closingElement, node);
  }
  function spaceSeparator() {
    this.space();
  }
  function JSXOpeningElement(node) {
    this.tokenChar(60);
    this.print(node.name, node);
    this.print(node.typeParameters, node);
    if (node.attributes.length > 0) {
      this.space();
      this.printJoin(node.attributes, node, { separator: spaceSeparator });
    }
    if (node.selfClosing) {
      this.space();
      this.token("/>");
    } else {
      this.tokenChar(62);
    }
  }
  function JSXClosingElement(node) {
    this.token("</");
    this.print(node.name, node);
    this.tokenChar(62);
  }
  function JSXEmptyExpression() {
    this.printInnerComments();
  }
  function JSXFragment(node) {
    this.print(node.openingFragment, node);
    this.indent();
    for (const child of node.children) {
      this.print(child, node);
    }
    this.dedent();
    this.print(node.closingFragment, node);
  }
  function JSXOpeningFragment() {
    this.tokenChar(60);
    this.tokenChar(62);
  }
  function JSXClosingFragment() {
    this.token("</");
    this.tokenChar(62);
  }
  return jsx$2;
}
var typescript$2 = {};
var hasRequiredTypescript;
function requireTypescript() {
  if (hasRequiredTypescript) return typescript$2;
  hasRequiredTypescript = 1;
  Object.defineProperty(typescript$2, "__esModule", { value: true });
  typescript$2.TSAnyKeyword = TSAnyKeyword;
  typescript$2.TSArrayType = TSArrayType;
  typescript$2.TSSatisfiesExpression = typescript$2.TSAsExpression =
    TSTypeExpression;
  typescript$2.TSBigIntKeyword = TSBigIntKeyword;
  typescript$2.TSBooleanKeyword = TSBooleanKeyword;
  typescript$2.TSCallSignatureDeclaration = TSCallSignatureDeclaration;
  typescript$2.TSConditionalType = TSConditionalType;
  typescript$2.TSConstructSignatureDeclaration =
    TSConstructSignatureDeclaration;
  typescript$2.TSConstructorType = TSConstructorType;
  typescript$2.TSDeclareFunction = TSDeclareFunction;
  typescript$2.TSDeclareMethod = TSDeclareMethod;
  typescript$2.TSEnumDeclaration = TSEnumDeclaration;
  typescript$2.TSEnumMember = TSEnumMember;
  typescript$2.TSExportAssignment = TSExportAssignment;
  typescript$2.TSExpressionWithTypeArguments = TSExpressionWithTypeArguments;
  typescript$2.TSExternalModuleReference = TSExternalModuleReference;
  typescript$2.TSFunctionType = TSFunctionType;
  typescript$2.TSImportEqualsDeclaration = TSImportEqualsDeclaration;
  typescript$2.TSImportType = TSImportType;
  typescript$2.TSIndexSignature = TSIndexSignature;
  typescript$2.TSIndexedAccessType = TSIndexedAccessType;
  typescript$2.TSInferType = TSInferType;
  typescript$2.TSInstantiationExpression = TSInstantiationExpression;
  typescript$2.TSInterfaceBody = TSInterfaceBody;
  typescript$2.TSInterfaceDeclaration = TSInterfaceDeclaration;
  typescript$2.TSIntersectionType = TSIntersectionType;
  typescript$2.TSIntrinsicKeyword = TSIntrinsicKeyword;
  typescript$2.TSLiteralType = TSLiteralType;
  typescript$2.TSMappedType = TSMappedType;
  typescript$2.TSMethodSignature = TSMethodSignature;
  typescript$2.TSModuleBlock = TSModuleBlock;
  typescript$2.TSModuleDeclaration = TSModuleDeclaration;
  typescript$2.TSNamedTupleMember = TSNamedTupleMember;
  typescript$2.TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
  typescript$2.TSNeverKeyword = TSNeverKeyword;
  typescript$2.TSNonNullExpression = TSNonNullExpression;
  typescript$2.TSNullKeyword = TSNullKeyword;
  typescript$2.TSNumberKeyword = TSNumberKeyword;
  typescript$2.TSObjectKeyword = TSObjectKeyword;
  typescript$2.TSOptionalType = TSOptionalType;
  typescript$2.TSParameterProperty = TSParameterProperty;
  typescript$2.TSParenthesizedType = TSParenthesizedType;
  typescript$2.TSPropertySignature = TSPropertySignature;
  typescript$2.TSQualifiedName = TSQualifiedName;
  typescript$2.TSRestType = TSRestType;
  typescript$2.TSStringKeyword = TSStringKeyword;
  typescript$2.TSSymbolKeyword = TSSymbolKeyword;
  typescript$2.TSThisType = TSThisType;
  typescript$2.TSTupleType = TSTupleType;
  typescript$2.TSTypeAliasDeclaration = TSTypeAliasDeclaration;
  typescript$2.TSTypeAnnotation = TSTypeAnnotation;
  typescript$2.TSTypeAssertion = TSTypeAssertion;
  typescript$2.TSTypeLiteral = TSTypeLiteral;
  typescript$2.TSTypeOperator = TSTypeOperator;
  typescript$2.TSTypeParameter = TSTypeParameter;
  typescript$2.TSTypeParameterDeclaration =
    typescript$2.TSTypeParameterInstantiation = TSTypeParameterInstantiation;
  typescript$2.TSTypePredicate = TSTypePredicate;
  typescript$2.TSTypeQuery = TSTypeQuery;
  typescript$2.TSTypeReference = TSTypeReference;
  typescript$2.TSUndefinedKeyword = TSUndefinedKeyword;
  typescript$2.TSUnionType = TSUnionType;
  typescript$2.TSUnknownKeyword = TSUnknownKeyword;
  typescript$2.TSVoidKeyword = TSVoidKeyword;
  typescript$2.tsPrintClassMemberModifiers = tsPrintClassMemberModifiers;
  typescript$2.tsPrintFunctionOrConstructorType =
    tsPrintFunctionOrConstructorType;
  typescript$2.tsPrintPropertyOrMethodName = tsPrintPropertyOrMethodName;
  typescript$2.tsPrintSignatureDeclarationBase =
    tsPrintSignatureDeclarationBase;
  typescript$2.tsPrintTypeLiteralOrInterfaceBody =
    tsPrintTypeLiteralOrInterfaceBody;
  function TSTypeAnnotation(node) {
    this.tokenChar(58);
    this.space();
    if (node.optional) this.tokenChar(63);
    this.print(node.typeAnnotation, node);
  }
  function TSTypeParameterInstantiation(node, parent) {
    this.tokenChar(60);
    this.printList(node.params, node, {});
    if (parent.type === "ArrowFunctionExpression" && node.params.length === 1) {
      this.tokenChar(44);
    }
    this.tokenChar(62);
  }
  function TSTypeParameter(node) {
    if (node.in) {
      this.word("in");
      this.space();
    }
    if (node.out) {
      this.word("out");
      this.space();
    }
    this.word(node.name);
    if (node.constraint) {
      this.space();
      this.word("extends");
      this.space();
      this.print(node.constraint, node);
    }
    if (node.default) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(node.default, node);
    }
  }
  function TSParameterProperty(node) {
    if (node.accessibility) {
      this.word(node.accessibility);
      this.space();
    }
    if (node.readonly) {
      this.word("readonly");
      this.space();
    }
    this._param(node.parameter);
  }
  function TSDeclareFunction(node, parent) {
    if (node.declare) {
      this.word("declare");
      this.space();
    }
    this._functionHead(node, parent);
    this.tokenChar(59);
  }
  function TSDeclareMethod(node) {
    this._classMethodHead(node);
    this.tokenChar(59);
  }
  function TSQualifiedName(node) {
    this.print(node.left, node);
    this.tokenChar(46);
    this.print(node.right, node);
  }
  function TSCallSignatureDeclaration(node) {
    this.tsPrintSignatureDeclarationBase(node);
    this.tokenChar(59);
  }
  function TSConstructSignatureDeclaration(node) {
    this.word("new");
    this.space();
    this.tsPrintSignatureDeclarationBase(node);
    this.tokenChar(59);
  }
  function TSPropertySignature(node) {
    const { readonly: readonly } = node;
    if (readonly) {
      this.word("readonly");
      this.space();
    }
    this.tsPrintPropertyOrMethodName(node);
    this.print(node.typeAnnotation, node);
    this.tokenChar(59);
  }
  function tsPrintPropertyOrMethodName(node) {
    if (node.computed) {
      this.tokenChar(91);
    }
    this.print(node.key, node);
    if (node.computed) {
      this.tokenChar(93);
    }
    if (node.optional) {
      this.tokenChar(63);
    }
  }
  function TSMethodSignature(node) {
    const { kind: kind } = node;
    if (kind === "set" || kind === "get") {
      this.word(kind);
      this.space();
    }
    this.tsPrintPropertyOrMethodName(node);
    this.tsPrintSignatureDeclarationBase(node);
    this.tokenChar(59);
  }
  function TSIndexSignature(node) {
    const { readonly: readonly, static: isStatic } = node;
    if (isStatic) {
      this.word("static");
      this.space();
    }
    if (readonly) {
      this.word("readonly");
      this.space();
    }
    this.tokenChar(91);
    this._parameters(node.parameters, node);
    this.tokenChar(93);
    this.print(node.typeAnnotation, node);
    this.tokenChar(59);
  }
  function TSAnyKeyword() {
    this.word("any");
  }
  function TSBigIntKeyword() {
    this.word("bigint");
  }
  function TSUnknownKeyword() {
    this.word("unknown");
  }
  function TSNumberKeyword() {
    this.word("number");
  }
  function TSObjectKeyword() {
    this.word("object");
  }
  function TSBooleanKeyword() {
    this.word("boolean");
  }
  function TSStringKeyword() {
    this.word("string");
  }
  function TSSymbolKeyword() {
    this.word("symbol");
  }
  function TSVoidKeyword() {
    this.word("void");
  }
  function TSUndefinedKeyword() {
    this.word("undefined");
  }
  function TSNullKeyword() {
    this.word("null");
  }
  function TSNeverKeyword() {
    this.word("never");
  }
  function TSIntrinsicKeyword() {
    this.word("intrinsic");
  }
  function TSThisType() {
    this.word("this");
  }
  function TSFunctionType(node) {
    this.tsPrintFunctionOrConstructorType(node);
  }
  function TSConstructorType(node) {
    if (node.abstract) {
      this.word("abstract");
      this.space();
    }
    this.word("new");
    this.space();
    this.tsPrintFunctionOrConstructorType(node);
  }
  function tsPrintFunctionOrConstructorType(node) {
    const { typeParameters: typeParameters } = node;
    const parameters = node.parameters;
    this.print(typeParameters, node);
    this.tokenChar(40);
    this._parameters(parameters, node);
    this.tokenChar(41);
    this.space();
    this.token("=>");
    this.space();
    const returnType = node.typeAnnotation;
    this.print(returnType.typeAnnotation, node);
  }
  function TSTypeReference(node) {
    this.print(node.typeName, node, true);
    this.print(node.typeParameters, node, true);
  }
  function TSTypePredicate(node) {
    if (node.asserts) {
      this.word("asserts");
      this.space();
    }
    this.print(node.parameterName);
    if (node.typeAnnotation) {
      this.space();
      this.word("is");
      this.space();
      this.print(node.typeAnnotation.typeAnnotation);
    }
  }
  function TSTypeQuery(node) {
    this.word("typeof");
    this.space();
    this.print(node.exprName);
    if (node.typeParameters) {
      this.print(node.typeParameters, node);
    }
  }
  function TSTypeLiteral(node) {
    this.tsPrintTypeLiteralOrInterfaceBody(node.members, node);
  }
  function tsPrintTypeLiteralOrInterfaceBody(members, node) {
    tsPrintBraced(this, members, node);
  }
  function tsPrintBraced(printer, members, node) {
    printer.token("{");
    if (members.length) {
      printer.indent();
      printer.newline();
      for (const member of members) {
        printer.print(member, node);
        printer.newline();
      }
      printer.dedent();
    }
    printer.rightBrace(node);
  }
  function TSArrayType(node) {
    this.print(node.elementType, node, true);
    this.token("[]");
  }
  function TSTupleType(node) {
    this.tokenChar(91);
    this.printList(node.elementTypes, node);
    this.tokenChar(93);
  }
  function TSOptionalType(node) {
    this.print(node.typeAnnotation, node);
    this.tokenChar(63);
  }
  function TSRestType(node) {
    this.token("...");
    this.print(node.typeAnnotation, node);
  }
  function TSNamedTupleMember(node) {
    this.print(node.label, node);
    if (node.optional) this.tokenChar(63);
    this.tokenChar(58);
    this.space();
    this.print(node.elementType, node);
  }
  function TSUnionType(node) {
    tsPrintUnionOrIntersectionType(this, node, "|");
  }
  function TSIntersectionType(node) {
    tsPrintUnionOrIntersectionType(this, node, "&");
  }
  function tsPrintUnionOrIntersectionType(printer, node, sep) {
    printer.printJoin(node.types, node, {
      separator() {
        this.space();
        this.token(sep);
        this.space();
      },
    });
  }
  function TSConditionalType(node) {
    this.print(node.checkType);
    this.space();
    this.word("extends");
    this.space();
    this.print(node.extendsType);
    this.space();
    this.tokenChar(63);
    this.space();
    this.print(node.trueType);
    this.space();
    this.tokenChar(58);
    this.space();
    this.print(node.falseType);
  }
  function TSInferType(node) {
    this.token("infer");
    this.space();
    this.print(node.typeParameter);
  }
  function TSParenthesizedType(node) {
    this.tokenChar(40);
    this.print(node.typeAnnotation, node);
    this.tokenChar(41);
  }
  function TSTypeOperator(node) {
    this.word(node.operator);
    this.space();
    this.print(node.typeAnnotation, node);
  }
  function TSIndexedAccessType(node) {
    this.print(node.objectType, node, true);
    this.tokenChar(91);
    this.print(node.indexType, node);
    this.tokenChar(93);
  }
  function TSMappedType(node) {
    const {
      nameType: nameType,
      optional: optional,
      readonly: readonly,
      typeParameter: typeParameter,
      typeAnnotation: typeAnnotation,
    } = node;
    this.tokenChar(123);
    this.space();
    if (readonly) {
      tokenIfPlusMinus(this, readonly);
      this.word("readonly");
      this.space();
    }
    this.tokenChar(91);
    this.word(typeParameter.name);
    this.space();
    this.word("in");
    this.space();
    this.print(typeParameter.constraint, typeParameter);
    if (nameType) {
      this.space();
      this.word("as");
      this.space();
      this.print(nameType, node);
    }
    this.tokenChar(93);
    if (optional) {
      tokenIfPlusMinus(this, optional);
      this.tokenChar(63);
    }
    if (typeAnnotation) {
      this.tokenChar(58);
      this.space();
      this.print(typeAnnotation, node);
    }
    this.space();
    this.tokenChar(125);
  }
  function tokenIfPlusMinus(self, tok) {
    if (tok !== true) {
      self.token(tok);
    }
  }
  function TSLiteralType(node) {
    this.print(node.literal, node);
  }
  function TSExpressionWithTypeArguments(node) {
    this.print(node.expression, node);
    this.print(node.typeParameters, node);
  }
  function TSInterfaceDeclaration(node) {
    const {
      declare: declare,
      id: id,
      typeParameters: typeParameters,
      extends: extendz,
      body: body,
    } = node;
    if (declare) {
      this.word("declare");
      this.space();
    }
    this.word("interface");
    this.space();
    this.print(id, node);
    this.print(typeParameters, node);
    if (extendz != null && extendz.length) {
      this.space();
      this.word("extends");
      this.space();
      this.printList(extendz, node);
    }
    this.space();
    this.print(body, node);
  }
  function TSInterfaceBody(node) {
    this.tsPrintTypeLiteralOrInterfaceBody(node.body, node);
  }
  function TSTypeAliasDeclaration(node) {
    const {
      declare: declare,
      id: id,
      typeParameters: typeParameters,
      typeAnnotation: typeAnnotation,
    } = node;
    if (declare) {
      this.word("declare");
      this.space();
    }
    this.word("type");
    this.space();
    this.print(id, node);
    this.print(typeParameters, node);
    this.space();
    this.tokenChar(61);
    this.space();
    this.print(typeAnnotation, node);
    this.tokenChar(59);
  }
  function TSTypeExpression(node) {
    var _expression$trailingC;
    const {
      type: type,
      expression: expression,
      typeAnnotation: typeAnnotation,
    } = node;
    const forceParens = !!(
      (_expression$trailingC = expression.trailingComments) != null &&
      _expression$trailingC.length
    );
    this.print(expression, node, true, undefined, forceParens);
    this.space();
    this.word(type === "TSAsExpression" ? "as" : "satisfies");
    this.space();
    this.print(typeAnnotation, node);
  }
  function TSTypeAssertion(node) {
    const { typeAnnotation: typeAnnotation, expression: expression } = node;
    this.tokenChar(60);
    this.print(typeAnnotation, node);
    this.tokenChar(62);
    this.space();
    this.print(expression, node);
  }
  function TSInstantiationExpression(node) {
    this.print(node.expression, node);
    this.print(node.typeParameters, node);
  }
  function TSEnumDeclaration(node) {
    const { declare: declare, const: isConst, id: id, members: members } = node;
    if (declare) {
      this.word("declare");
      this.space();
    }
    if (isConst) {
      this.word("const");
      this.space();
    }
    this.word("enum");
    this.space();
    this.print(id, node);
    this.space();
    tsPrintBraced(this, members, node);
  }
  function TSEnumMember(node) {
    const { id: id, initializer: initializer } = node;
    this.print(id, node);
    if (initializer) {
      this.space();
      this.tokenChar(61);
      this.space();
      this.print(initializer, node);
    }
    this.tokenChar(44);
  }
  function TSModuleDeclaration(node) {
    const { declare: declare, id: id } = node;
    if (declare) {
      this.word("declare");
      this.space();
    }
    if (!node.global) {
      this.word(id.type === "Identifier" ? "namespace" : "module");
      this.space();
    }
    this.print(id, node);
    if (!node.body) {
      this.tokenChar(59);
      return;
    }
    let body = node.body;
    while (body.type === "TSModuleDeclaration") {
      this.tokenChar(46);
      this.print(body.id, body);
      body = body.body;
    }
    this.space();
    this.print(body, node);
  }
  function TSModuleBlock(node) {
    tsPrintBraced(this, node.body, node);
  }
  function TSImportType(node) {
    const {
      argument: argument,
      qualifier: qualifier,
      typeParameters: typeParameters,
    } = node;
    this.word("import");
    this.tokenChar(40);
    this.print(argument, node);
    this.tokenChar(41);
    if (qualifier) {
      this.tokenChar(46);
      this.print(qualifier, node);
    }
    if (typeParameters) {
      this.print(typeParameters, node);
    }
  }
  function TSImportEqualsDeclaration(node) {
    const {
      isExport: isExport,
      id: id,
      moduleReference: moduleReference,
    } = node;
    if (isExport) {
      this.word("export");
      this.space();
    }
    this.word("import");
    this.space();
    this.print(id, node);
    this.space();
    this.tokenChar(61);
    this.space();
    this.print(moduleReference, node);
    this.tokenChar(59);
  }
  function TSExternalModuleReference(node) {
    this.token("require(");
    this.print(node.expression, node);
    this.tokenChar(41);
  }
  function TSNonNullExpression(node) {
    this.print(node.expression, node);
    this.tokenChar(33);
  }
  function TSExportAssignment(node) {
    this.word("export");
    this.space();
    this.tokenChar(61);
    this.space();
    this.print(node.expression, node);
    this.tokenChar(59);
  }
  function TSNamespaceExportDeclaration(node) {
    this.word("export");
    this.space();
    this.word("as");
    this.space();
    this.word("namespace");
    this.space();
    this.print(node.id, node);
  }
  function tsPrintSignatureDeclarationBase(node) {
    const { typeParameters: typeParameters } = node;
    const parameters = node.parameters;
    this.print(typeParameters, node);
    this.tokenChar(40);
    this._parameters(parameters, node);
    this.tokenChar(41);
    const returnType = node.typeAnnotation;
    this.print(returnType, node);
  }
  function tsPrintClassMemberModifiers(node) {
    const isField =
      node.type === "ClassAccessorProperty" || node.type === "ClassProperty";
    if (isField && node.declare) {
      this.word("declare");
      this.space();
    }
    if (node.accessibility) {
      this.word(node.accessibility);
      this.space();
    }
    if (node.static) {
      this.word("static");
      this.space();
    }
    if (node.override) {
      this.word("override");
      this.space();
    }
    if (node.abstract) {
      this.word("abstract");
      this.space();
    }
    if (isField && node.readonly) {
      this.word("readonly");
      this.space();
    }
  }
  return typescript$2;
}
var hasRequiredGenerators;
function requireGenerators() {
  if (hasRequiredGenerators) return generators$1;
  hasRequiredGenerators = 1;
  (function (exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var _templateLiterals = requireTemplateLiterals();
    Object.keys(_templateLiterals).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _templateLiterals[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _templateLiterals[key];
        },
      });
    });
    var _expressions = requireExpressions();
    Object.keys(_expressions).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _expressions[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _expressions[key];
        },
      });
    });
    var _statements = requireStatements();
    Object.keys(_statements).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _statements[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _statements[key];
        },
      });
    });
    var _classes = requireClasses();
    Object.keys(_classes).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _classes[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _classes[key];
        },
      });
    });
    var _methods = requireMethods();
    Object.keys(_methods).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _methods[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _methods[key];
        },
      });
    });
    var _modules = requireModules();
    Object.keys(_modules).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _modules[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _modules[key];
        },
      });
    });
    var _types = requireTypes();
    Object.keys(_types).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _types[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _types[key];
        },
      });
    });
    var _flow = requireFlow();
    Object.keys(_flow).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _flow[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _flow[key];
        },
      });
    });
    var _base = requireBase();
    Object.keys(_base).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _base[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _base[key];
        },
      });
    });
    var _jsx = requireJsx();
    Object.keys(_jsx).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _jsx[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _jsx[key];
        },
      });
    });
    var _typescript = requireTypescript();
    Object.keys(_typescript).forEach(function (key) {
      if (key === "default" || key === "__esModule") return;
      if (key in exports && exports[key] === _typescript[key]) return;
      Object.defineProperty(exports, key, {
        enumerable: true,
        get: function () {
          return _typescript[key];
        },
      });
    });
  })(generators$1);
  return generators$1;
}
var hasRequiredPrinter;
function requirePrinter() {
  if (hasRequiredPrinter) return printer$2;
  hasRequiredPrinter = 1;
  Object.defineProperty(printer$2, "__esModule", { value: true });
  printer$2.default = void 0;
  var _buffer = requireBuffer();
  var n = requireNode();
  var _t = t$d;
  var generatorFunctions = requireGenerators();
  const {
    isFunction: isFunction,
    isStatement: isStatement,
    isClassBody: isClassBody,
    isTSInterfaceBody: isTSInterfaceBody,
    isTSEnumDeclaration: isTSEnumDeclaration,
  } = _t;
  const SCIENTIFIC_NOTATION = /e/i;
  const ZERO_DECIMAL_INTEGER = /\.0+$/;
  const HAS_NEWLINE = /[\n\r\u2028\u2029]/;
  const HAS_NEWLINE_OR_BlOCK_COMMENT_END = /[\n\r\u2028\u2029]|\*\//;
  const { needsParens: needsParens } = n;
  class Printer {
    constructor(format, map) {
      this.inForStatementInitCounter = 0;
      this._printStack = [];
      this._indent = 0;
      this._indentRepeat = 0;
      this._insideAux = false;
      this._parenPushNewlineState = null;
      this._noLineTerminator = false;
      this._printAuxAfterOnNextUserNode = false;
      this._printedComments = new Set();
      this._endsWithInteger = false;
      this._endsWithWord = false;
      this._lastCommentLine = 0;
      this._endsWithInnerRaw = false;
      this._indentInnerComments = true;
      this.format = format;
      this._indentRepeat = format.indent.style.length;
      this._inputMap = map == null ? void 0 : map._inputMap;
      this._buf = new _buffer.default(map, format.indent.style[0]);
    }
    generate(ast) {
      this.print(ast);
      this._maybeAddAuxComment();
      return this._buf.get();
    }
    indent() {
      if (this.format.compact || this.format.concise) return;
      this._indent++;
    }
    dedent() {
      if (this.format.compact || this.format.concise) return;
      this._indent--;
    }
    semicolon(force = false) {
      this._maybeAddAuxComment();
      if (force) {
        this._appendChar(59);
      } else {
        this._queue(59);
      }
      this._noLineTerminator = false;
    }
    rightBrace(node) {
      if (this.format.minified) {
        this._buf.removeLastSemicolon();
      }
      this.sourceWithOffset("end", node.loc, -1);
      this.tokenChar(125);
    }
    rightParens(node) {
      this.sourceWithOffset("end", node.loc, -1);
      this.tokenChar(41);
    }
    space(force = false) {
      if (this.format.compact) return;
      if (force) {
        this._space();
      } else if (this._buf.hasContent()) {
        const lastCp = this.getLastChar();
        if (lastCp !== 32 && lastCp !== 10) {
          this._space();
        }
      }
    }
    word(str, noLineTerminatorAfter = false) {
      this._maybePrintInnerComments();
      if (
        this._endsWithWord ||
        (str.charCodeAt(0) === 47 && this.endsWith(47))
      ) {
        this._space();
      }
      this._maybeAddAuxComment();
      this._append(str, false);
      this._endsWithWord = true;
      this._noLineTerminator = noLineTerminatorAfter;
    }
    number(str, number) {
      function isNonDecimalLiteral(str) {
        if (str.length > 2 && str.charCodeAt(0) === 48) {
          const secondChar = str.charCodeAt(1);
          return secondChar === 98 || secondChar === 111 || secondChar === 120;
        }
        return false;
      }
      this.word(str);
      this._endsWithInteger =
        Number.isInteger(number) &&
        !isNonDecimalLiteral(str) &&
        !SCIENTIFIC_NOTATION.test(str) &&
        !ZERO_DECIMAL_INTEGER.test(str) &&
        str.charCodeAt(str.length - 1) !== 46;
    }
    token(str, maybeNewline = false) {
      this._maybePrintInnerComments();
      const lastChar = this.getLastChar();
      const strFirst = str.charCodeAt(0);
      if (
        (lastChar === 33 && (str === "--" || strFirst === 61)) ||
        (strFirst === 43 && lastChar === 43) ||
        (strFirst === 45 && lastChar === 45) ||
        (strFirst === 46 && this._endsWithInteger)
      ) {
        this._space();
      }
      this._maybeAddAuxComment();
      this._append(str, maybeNewline);
      this._noLineTerminator = false;
    }
    tokenChar(char) {
      this._maybePrintInnerComments();
      const lastChar = this.getLastChar();
      if (
        (char === 43 && lastChar === 43) ||
        (char === 45 && lastChar === 45) ||
        (char === 46 && this._endsWithInteger)
      ) {
        this._space();
      }
      this._maybeAddAuxComment();
      this._appendChar(char);
      this._noLineTerminator = false;
    }
    newline(i = 1, force) {
      if (i <= 0) return;
      if (!force) {
        if (this.format.retainLines || this.format.compact) return;
        if (this.format.concise) {
          this.space();
          return;
        }
      }
      if (i > 2) i = 2;
      i -= this._buf.getNewlineCount();
      for (let j = 0; j < i; j++) {
        this._newline();
      }
      return;
    }
    endsWith(char) {
      return this.getLastChar() === char;
    }
    getLastChar() {
      return this._buf.getLastChar();
    }
    endsWithCharAndNewline() {
      return this._buf.endsWithCharAndNewline();
    }
    removeTrailingNewline() {
      this._buf.removeTrailingNewline();
    }
    exactSource(loc, cb) {
      if (!loc) {
        cb();
        return;
      }
      this._catchUp("start", loc);
      this._buf.exactSource(loc, cb);
    }
    source(prop, loc) {
      if (!loc) return;
      this._catchUp(prop, loc);
      this._buf.source(prop, loc);
    }
    sourceWithOffset(prop, loc, columnOffset) {
      if (!loc) return;
      this._catchUp(prop, loc);
      this._buf.sourceWithOffset(prop, loc, columnOffset);
    }
    withSource(prop, loc, cb) {
      if (!loc) {
        cb();
        return;
      }
      this._catchUp(prop, loc);
      this._buf.withSource(prop, loc, cb);
    }
    sourceIdentifierName(identifierName, pos) {
      if (!this._buf._canMarkIdName) return;
      const sourcePosition = this._buf._sourcePosition;
      sourcePosition.identifierNamePos = pos;
      sourcePosition.identifierName = identifierName;
    }
    _space() {
      this._queue(32);
    }
    _newline() {
      this._queue(10);
    }
    _append(str, maybeNewline) {
      this._maybeAddParen(str);
      this._maybeIndent(str.charCodeAt(0));
      this._buf.append(str, maybeNewline);
      this._endsWithWord = false;
      this._endsWithInteger = false;
    }
    _appendChar(char) {
      this._maybeAddParenChar(char);
      this._maybeIndent(char);
      this._buf.appendChar(char);
      this._endsWithWord = false;
      this._endsWithInteger = false;
    }
    _queue(char) {
      this._maybeAddParenChar(char);
      this._maybeIndent(char);
      this._buf.queue(char);
      this._endsWithWord = false;
      this._endsWithInteger = false;
    }
    _maybeIndent(firstChar) {
      if (this._indent && firstChar !== 10 && this.endsWith(10)) {
        this._buf.queueIndentation(this._getIndent());
      }
    }
    _shouldIndent(firstChar) {
      if (this._indent && firstChar !== 10 && this.endsWith(10)) {
        return true;
      }
    }
    _maybeAddParenChar(char) {
      const parenPushNewlineState = this._parenPushNewlineState;
      if (!parenPushNewlineState) return;
      if (char === 32) {
        return;
      }
      if (char !== 10) {
        this._parenPushNewlineState = null;
        return;
      }
      this.tokenChar(40);
      this.indent();
      parenPushNewlineState.printed = true;
    }
    _maybeAddParen(str) {
      const parenPushNewlineState = this._parenPushNewlineState;
      if (!parenPushNewlineState) return;
      const len = str.length;
      let i;
      for (i = 0; i < len && str.charCodeAt(i) === 32; i++) continue;
      if (i === len) {
        return;
      }
      const cha = str.charCodeAt(i);
      if (cha !== 10) {
        if (cha !== 47 || i + 1 === len) {
          this._parenPushNewlineState = null;
          return;
        }
        const chaPost = str.charCodeAt(i + 1);
        if (chaPost === 42) {
          return;
        } else if (chaPost !== 47) {
          this._parenPushNewlineState = null;
          return;
        }
      }
      this.tokenChar(40);
      this.indent();
      parenPushNewlineState.printed = true;
    }
    catchUp(line) {
      if (!this.format.retainLines) return;
      const count = line - this._buf.getCurrentLine();
      for (let i = 0; i < count; i++) {
        this._newline();
      }
    }
    _catchUp(prop, loc) {
      var _loc$prop;
      if (!this.format.retainLines) return;
      const line =
        loc == null || (_loc$prop = loc[prop]) == null
          ? void 0
          : _loc$prop.line;
      if (line != null) {
        const count = line - this._buf.getCurrentLine();
        for (let i = 0; i < count; i++) {
          this._newline();
        }
      }
    }
    _getIndent() {
      return this._indentRepeat * this._indent;
    }
    printTerminatorless(node, parent, isLabel) {
      if (isLabel) {
        this._noLineTerminator = true;
        this.print(node, parent);
      } else {
        const terminatorState = { printed: false };
        this._parenPushNewlineState = terminatorState;
        this.print(node, parent);
        if (terminatorState.printed) {
          this.dedent();
          this.newline();
          this.tokenChar(41);
        }
      }
    }
    print(
      node,
      parent,
      noLineTerminatorAfter,
      trailingCommentsLineOffset,
      forceParens,
    ) {
      var _node$extra, _node$leadingComments;
      if (!node) return;
      this._endsWithInnerRaw = false;
      const nodeType = node.type;
      const format = this.format;
      const oldConcise = format.concise;
      if (node._compact) {
        format.concise = true;
      }
      const printMethod = this[nodeType];
      if (printMethod === undefined) {
        throw new ReferenceError(
          `unknown node of type ${JSON.stringify(nodeType)} with constructor ${JSON.stringify(node.constructor.name)}`,
        );
      }
      this._printStack.push(node);
      const oldInAux = this._insideAux;
      this._insideAux = node.loc == undefined;
      this._maybeAddAuxComment(this._insideAux && !oldInAux);
      const parenthesized =
        (_node$extra = node.extra) == null ? void 0 : _node$extra.parenthesized;
      let shouldPrintParens =
        forceParens ||
        (parenthesized &&
          format.retainFunctionParens &&
          nodeType === "FunctionExpression") ||
        needsParens(node, parent, this._printStack);
      if (
        !shouldPrintParens &&
        parenthesized &&
        (_node$leadingComments = node.leadingComments) != null &&
        _node$leadingComments.length &&
        node.leadingComments[0].type === "CommentBlock"
      ) {
        const parentType = parent == null ? void 0 : parent.type;
        switch (parentType) {
          case "ExpressionStatement":
          case "VariableDeclarator":
          case "AssignmentExpression":
          case "ReturnStatement":
            break;
          case "CallExpression":
          case "OptionalCallExpression":
          case "NewExpression":
            if (parent.callee !== node) break;
          default:
            shouldPrintParens = true;
        }
      }
      if (shouldPrintParens) {
        this.tokenChar(40);
        this._endsWithInnerRaw = false;
      }
      this._lastCommentLine = 0;
      this._printLeadingComments(node, parent);
      const loc =
        nodeType === "Program" || nodeType === "File" ? null : node.loc;
      this.exactSource(loc, printMethod.bind(this, node, parent));
      if (shouldPrintParens) {
        this._printTrailingComments(node, parent);
        this.tokenChar(41);
        this._noLineTerminator = noLineTerminatorAfter;
      } else if (noLineTerminatorAfter && !this._noLineTerminator) {
        this._noLineTerminator = true;
        this._printTrailingComments(node, parent);
      } else {
        this._printTrailingComments(node, parent, trailingCommentsLineOffset);
      }
      this._printStack.pop();
      format.concise = oldConcise;
      this._insideAux = oldInAux;
      this._endsWithInnerRaw = false;
    }
    _maybeAddAuxComment(enteredPositionlessNode) {
      if (enteredPositionlessNode) this._printAuxBeforeComment();
      if (!this._insideAux) this._printAuxAfterComment();
    }
    _printAuxBeforeComment() {
      if (this._printAuxAfterOnNextUserNode) return;
      this._printAuxAfterOnNextUserNode = true;
      const comment = this.format.auxiliaryCommentBefore;
      if (comment) {
        this._printComment({ type: "CommentBlock", value: comment }, 0);
      }
    }
    _printAuxAfterComment() {
      if (!this._printAuxAfterOnNextUserNode) return;
      this._printAuxAfterOnNextUserNode = false;
      const comment = this.format.auxiliaryCommentAfter;
      if (comment) {
        this._printComment({ type: "CommentBlock", value: comment }, 0);
      }
    }
    getPossibleRaw(node) {
      const extra = node.extra;
      if (
        (extra == null ? void 0 : extra.raw) != null &&
        extra.rawValue != null &&
        node.value === extra.rawValue
      ) {
        return extra.raw;
      }
    }
    printJoin(nodes, parent, opts = {}) {
      if (!(nodes != null && nodes.length)) return;
      let { indent: indent } = opts;
      if (indent == null && this.format.retainLines) {
        var _nodes$0$loc;
        const startLine =
          (_nodes$0$loc = nodes[0].loc) == null
            ? void 0
            : _nodes$0$loc.start.line;
        if (startLine != null && startLine !== this._buf.getCurrentLine()) {
          indent = true;
        }
      }
      if (indent) this.indent();
      const newlineOpts = {
        addNewlines: opts.addNewlines,
        nextNodeStartLine: 0,
      };
      const separator = opts.separator ? opts.separator.bind(this) : null;
      const len = nodes.length;
      for (let i = 0; i < len; i++) {
        const node = nodes[i];
        if (!node) continue;
        if (opts.statement) this._printNewline(i === 0, newlineOpts);
        this.print(
          node,
          parent,
          undefined,
          opts.trailingCommentsLineOffset || 0,
        );
        opts.iterator == null || opts.iterator(node, i);
        if (i < len - 1) separator == null || separator();
        if (opts.statement) {
          var _node$trailingComment;
          if (
            !(
              (_node$trailingComment = node.trailingComments) != null &&
              _node$trailingComment.length
            )
          ) {
            this._lastCommentLine = 0;
          }
          if (i + 1 === len) {
            this.newline(1);
          } else {
            var _nextNode$loc;
            const nextNode = nodes[i + 1];
            newlineOpts.nextNodeStartLine =
              ((_nextNode$loc = nextNode.loc) == null
                ? void 0
                : _nextNode$loc.start.line) || 0;
            this._printNewline(true, newlineOpts);
          }
        }
      }
      if (indent) this.dedent();
    }
    printAndIndentOnComments(node, parent) {
      const indent = node.leadingComments && node.leadingComments.length > 0;
      if (indent) this.indent();
      this.print(node, parent);
      if (indent) this.dedent();
    }
    printBlock(parent) {
      const node = parent.body;
      if (node.type !== "EmptyStatement") {
        this.space();
      }
      this.print(node, parent);
    }
    _printTrailingComments(node, parent, lineOffset) {
      const {
        innerComments: innerComments,
        trailingComments: trailingComments,
      } = node;
      if (innerComments != null && innerComments.length) {
        this._printComments(2, innerComments, node, parent, lineOffset);
      }
      if (trailingComments != null && trailingComments.length) {
        this._printComments(2, trailingComments, node, parent, lineOffset);
      }
    }
    _printLeadingComments(node, parent) {
      const comments = node.leadingComments;
      if (!(comments != null && comments.length)) return;
      this._printComments(0, comments, node, parent);
    }
    _maybePrintInnerComments() {
      if (this._endsWithInnerRaw) this.printInnerComments();
      this._endsWithInnerRaw = true;
      this._indentInnerComments = true;
    }
    printInnerComments() {
      const node = this._printStack[this._printStack.length - 1];
      const comments = node.innerComments;
      if (!(comments != null && comments.length)) return;
      const hasSpace = this.endsWith(32);
      const indent = this._indentInnerComments;
      const printedCommentsCount = this._printedComments.size;
      if (indent) this.indent();
      this._printComments(1, comments, node);
      if (hasSpace && printedCommentsCount !== this._printedComments.size) {
        this.space();
      }
      if (indent) this.dedent();
    }
    noIndentInnerCommentsHere() {
      this._indentInnerComments = false;
    }
    printSequence(nodes, parent, opts = {}) {
      var _opts$indent;
      opts.statement = true;
      (_opts$indent = opts.indent) != null
        ? _opts$indent
        : (opts.indent = false);
      this.printJoin(nodes, parent, opts);
    }
    printList(items, parent, opts = {}) {
      if (opts.separator == null) {
        opts.separator = commaSeparator;
      }
      this.printJoin(items, parent, opts);
    }
    _printNewline(newLine, opts) {
      const format = this.format;
      if (format.retainLines || format.compact) return;
      if (format.concise) {
        this.space();
        return;
      }
      if (!newLine) {
        return;
      }
      const startLine = opts.nextNodeStartLine;
      const lastCommentLine = this._lastCommentLine;
      if (startLine > 0 && lastCommentLine > 0) {
        const offset = startLine - lastCommentLine;
        if (offset >= 0) {
          this.newline(offset || 1);
          return;
        }
      }
      if (this._buf.hasContent()) {
        this.newline(1);
      }
    }
    _shouldPrintComment(comment) {
      if (comment.ignore) return 0;
      if (this._printedComments.has(comment)) return 0;
      if (
        this._noLineTerminator &&
        HAS_NEWLINE_OR_BlOCK_COMMENT_END.test(comment.value)
      ) {
        return 2;
      }
      this._printedComments.add(comment);
      if (!this.format.shouldPrintComment(comment.value)) {
        return 0;
      }
      return 1;
    }
    _printComment(comment, skipNewLines) {
      const noLineTerminator = this._noLineTerminator;
      const isBlockComment = comment.type === "CommentBlock";
      const printNewLines =
        isBlockComment && skipNewLines !== 1 && !this._noLineTerminator;
      if (printNewLines && this._buf.hasContent() && skipNewLines !== 2) {
        this.newline(1);
      }
      const lastCharCode = this.getLastChar();
      if (lastCharCode !== 91 && lastCharCode !== 123) {
        this.space();
      }
      let val;
      if (isBlockComment) {
        const { _parenPushNewlineState: _parenPushNewlineState } = this;
        if (
          (_parenPushNewlineState == null
            ? void 0
            : _parenPushNewlineState.printed) === false &&
          HAS_NEWLINE.test(comment.value)
        ) {
          this.tokenChar(40);
          this.indent();
          _parenPushNewlineState.printed = true;
        }
        val = `/*${comment.value}*/`;
        if (this.format.indent.adjustMultilineComment) {
          var _comment$loc;
          const offset =
            (_comment$loc = comment.loc) == null
              ? void 0
              : _comment$loc.start.column;
          if (offset) {
            const newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
            val = val.replace(newlineRegex, "\n");
          }
          if (this.format.concise) {
            val = val.replace(/\n(?!$)/g, `\n`);
          } else {
            let indentSize = this.format.retainLines
              ? 0
              : this._buf.getCurrentColumn();
            if (this._shouldIndent(47) || this.format.retainLines) {
              indentSize += this._getIndent();
            }
            val = val.replace(/\n(?!$)/g, `\n${" ".repeat(indentSize)}`);
          }
        }
      } else if (!noLineTerminator) {
        val = `//${comment.value}`;
      } else {
        val = `/*${comment.value}*/`;
      }
      if (this.endsWith(47)) this._space();
      this.source("start", comment.loc);
      this._append(val, isBlockComment);
      if (!isBlockComment && !noLineTerminator) {
        this.newline(1, true);
      }
      if (printNewLines && skipNewLines !== 3) {
        this.newline(1);
      }
    }
    _printComments(type, comments, node, parent, lineOffset = 0) {
      const nodeLoc = node.loc;
      const len = comments.length;
      let hasLoc = !!nodeLoc;
      const nodeStartLine = hasLoc ? nodeLoc.start.line : 0;
      const nodeEndLine = hasLoc ? nodeLoc.end.line : 0;
      let lastLine = 0;
      let leadingCommentNewline = 0;
      const maybeNewline = this._noLineTerminator
        ? function () {}
        : this.newline.bind(this);
      for (let i = 0; i < len; i++) {
        const comment = comments[i];
        const shouldPrint = this._shouldPrintComment(comment);
        if (shouldPrint === 2) {
          hasLoc = false;
          break;
        }
        if (hasLoc && comment.loc && shouldPrint === 1) {
          const commentStartLine = comment.loc.start.line;
          const commentEndLine = comment.loc.end.line;
          if (type === 0) {
            let offset = 0;
            if (i === 0) {
              if (
                this._buf.hasContent() &&
                (comment.type === "CommentLine" ||
                  commentStartLine != commentEndLine)
              ) {
                offset = leadingCommentNewline = 1;
              }
            } else {
              offset = commentStartLine - lastLine;
            }
            lastLine = commentEndLine;
            maybeNewline(offset);
            this._printComment(comment, 1);
            if (i + 1 === len) {
              maybeNewline(
                Math.max(nodeStartLine - lastLine, leadingCommentNewline),
              );
              lastLine = nodeStartLine;
            }
          } else if (type === 1) {
            const offset =
              commentStartLine - (i === 0 ? nodeStartLine : lastLine);
            lastLine = commentEndLine;
            maybeNewline(offset);
            this._printComment(comment, 1);
            if (i + 1 === len) {
              maybeNewline(Math.min(1, nodeEndLine - lastLine));
              lastLine = nodeEndLine;
            }
          } else {
            const offset =
              commentStartLine -
              (i === 0 ? nodeEndLine - lineOffset : lastLine);
            lastLine = commentEndLine;
            maybeNewline(offset);
            this._printComment(comment, 1);
          }
        } else {
          hasLoc = false;
          if (shouldPrint !== 1) {
            continue;
          }
          if (len === 1) {
            const singleLine = comment.loc
              ? comment.loc.start.line === comment.loc.end.line
              : !HAS_NEWLINE.test(comment.value);
            const shouldSkipNewline =
              singleLine &&
              !isStatement(node) &&
              !isClassBody(parent) &&
              !isTSInterfaceBody(parent) &&
              !isTSEnumDeclaration(parent);
            if (type === 0) {
              this._printComment(
                comment,
                (shouldSkipNewline && node.type !== "ObjectExpression") ||
                  (singleLine && isFunction(parent, { body: node }))
                  ? 1
                  : 0,
              );
            } else if (shouldSkipNewline && type === 2) {
              this._printComment(comment, 1);
            } else {
              this._printComment(comment, 0);
            }
          } else if (
            type === 1 &&
            !(node.type === "ObjectExpression" && node.properties.length > 1) &&
            node.type !== "ClassBody" &&
            node.type !== "TSInterfaceBody"
          ) {
            this._printComment(comment, i === 0 ? 2 : i === len - 1 ? 3 : 0);
          } else {
            this._printComment(comment, 0);
          }
        }
      }
      if (type === 2 && hasLoc && lastLine) {
        this._lastCommentLine = lastLine;
      }
    }
  }
  Object.assign(Printer.prototype, generatorFunctions);
  {
    Printer.prototype.Noop = function Noop() {};
  }
  printer$2.default = Printer;
  function commaSeparator() {
    this.tokenChar(44);
    this.space();
  }
  return printer$2;
}
var hasRequiredLib$o;
function requireLib$o() {
  if (hasRequiredLib$o) return lib$o;
  hasRequiredLib$o = 1;
  Object.defineProperty(lib$o, "__esModule", { value: true });
  lib$o.default = generate;
  var _sourceMap = requireSourceMap$2();
  var _printer = requirePrinter();
  function normalizeOptions(code, opts) {
    var _opts$recordAndTupleS;
    const format = {
      auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
      auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
      shouldPrintComment: opts.shouldPrintComment,
      retainLines: opts.retainLines,
      retainFunctionParens: opts.retainFunctionParens,
      comments: opts.comments == null || opts.comments,
      compact: opts.compact,
      minified: opts.minified,
      concise: opts.concise,
      indent: { adjustMultilineComment: true, style: "  " },
      jsescOption: Object.assign(
        { quotes: "double", wrap: true, minimal: false },
        opts.jsescOption,
      ),
      recordAndTupleSyntaxType:
        (_opts$recordAndTupleS = opts.recordAndTupleSyntaxType) != null
          ? _opts$recordAndTupleS
          : "hash",
      topicToken: opts.topicToken,
      importAttributesKeyword: opts.importAttributesKeyword,
    };
    {
      format.decoratorsBeforeExport = opts.decoratorsBeforeExport;
      format.jsescOption.json = opts.jsonCompatibleStrings;
    }
    if (format.minified) {
      format.compact = true;
      format.shouldPrintComment =
        format.shouldPrintComment || (() => format.comments);
    } else {
      format.shouldPrintComment =
        format.shouldPrintComment ||
        ((value) =>
          format.comments ||
          value.includes("@license") ||
          value.includes("@preserve"));
    }
    if (format.compact === "auto") {
      format.compact = typeof code === "string" && code.length > 5e5;
      if (format.compact) {
        console.error(
          "[BABEL] Note: The code generator has deoptimised the styling of " +
            `${opts.filename} as it exceeds the max of ${"500KB"}.`,
        );
      }
    }
    if (format.compact) {
      format.indent.adjustMultilineComment = false;
    }
    const {
      auxiliaryCommentBefore: auxiliaryCommentBefore,
      auxiliaryCommentAfter: auxiliaryCommentAfter,
      shouldPrintComment: shouldPrintComment,
    } = format;
    if (auxiliaryCommentBefore && !shouldPrintComment(auxiliaryCommentBefore)) {
      format.auxiliaryCommentBefore = undefined;
    }
    if (auxiliaryCommentAfter && !shouldPrintComment(auxiliaryCommentAfter)) {
      format.auxiliaryCommentAfter = undefined;
    }
    return format;
  }
  {
    lib$o.CodeGenerator = class CodeGenerator {
      constructor(ast, opts = {}, code) {
        this._ast = void 0;
        this._format = void 0;
        this._map = void 0;
        this._ast = ast;
        this._format = normalizeOptions(code, opts);
        this._map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
      }
      generate() {
        const printer = new _printer.default(this._format, this._map);
        return printer.generate(this._ast);
      }
    };
  }
  function generate(ast, opts = {}, code) {
    const format = normalizeOptions(code, opts);
    const map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
    const printer = new _printer.default(format, map);
    return printer.generate(ast);
  }
  return lib$o;
}
var ancestry$1 = {};
var hasRequiredAncestry$1;
function requireAncestry$1() {
  if (hasRequiredAncestry$1) return ancestry$1;
  hasRequiredAncestry$1 = 1;
  Object.defineProperty(ancestry$1, "__esModule", { value: true });
  ancestry$1.find = find;
  ancestry$1.findParent = findParent;
  ancestry$1.getAncestry = getAncestry;
  ancestry$1.getDeepestCommonAncestorFrom = getDeepestCommonAncestorFrom;
  ancestry$1.getEarliestCommonAncestorFrom = getEarliestCommonAncestorFrom;
  ancestry$1.getFunctionParent = getFunctionParent;
  ancestry$1.getStatementParent = getStatementParent;
  ancestry$1.inType = inType;
  ancestry$1.isAncestor = isAncestor;
  ancestry$1.isDescendant = isDescendant;
  var _t = t$d;
  const { VISITOR_KEYS: VISITOR_KEYS } = _t;
  function findParent(callback) {
    let path = this;
    while ((path = path.parentPath)) {
      if (callback(path)) return path;
    }
    return null;
  }
  function find(callback) {
    let path = this;
    do {
      if (callback(path)) return path;
    } while ((path = path.parentPath));
    return null;
  }
  function getFunctionParent() {
    return this.findParent((p) => p.isFunction());
  }
  function getStatementParent() {
    let path = this;
    do {
      if (
        !path.parentPath ||
        (Array.isArray(path.container) && path.isStatement())
      ) {
        break;
      } else {
        path = path.parentPath;
      }
    } while (path);
    if (path && (path.isProgram() || path.isFile())) {
      throw new Error(
        "File/Program node, we can't possibly find a statement parent to this",
      );
    }
    return path;
  }
  function getEarliestCommonAncestorFrom(paths) {
    return this.getDeepestCommonAncestorFrom(
      paths,
      function (deepest, i, ancestries) {
        let earliest;
        const keys = VISITOR_KEYS[deepest.type];
        for (const ancestry of ancestries) {
          const path = ancestry[i + 1];
          if (!earliest) {
            earliest = path;
            continue;
          }
          if (path.listKey && earliest.listKey === path.listKey) {
            if (path.key < earliest.key) {
              earliest = path;
              continue;
            }
          }
          const earliestKeyIndex = keys.indexOf(earliest.parentKey);
          const currentKeyIndex = keys.indexOf(path.parentKey);
          if (earliestKeyIndex > currentKeyIndex) {
            earliest = path;
          }
        }
        return earliest;
      },
    );
  }
  function getDeepestCommonAncestorFrom(paths, filter) {
    if (!paths.length) {
      return this;
    }
    if (paths.length === 1) {
      return paths[0];
    }
    let minDepth = Infinity;
    let lastCommonIndex, lastCommon;
    const ancestries = paths.map((path) => {
      const ancestry = [];
      do {
        ancestry.unshift(path);
      } while ((path = path.parentPath) && path !== this);
      if (ancestry.length < minDepth) {
        minDepth = ancestry.length;
      }
      return ancestry;
    });
    const first = ancestries[0];
    depthLoop: for (let i = 0; i < minDepth; i++) {
      const shouldMatch = first[i];
      for (const ancestry of ancestries) {
        if (ancestry[i] !== shouldMatch) {
          break depthLoop;
        }
      }
      lastCommonIndex = i;
      lastCommon = shouldMatch;
    }
    if (lastCommon) {
      if (filter) {
        return filter(lastCommon, lastCommonIndex, ancestries);
      } else {
        return lastCommon;
      }
    } else {
      throw new Error("Couldn't find intersection");
    }
  }
  function getAncestry() {
    let path = this;
    const paths = [];
    do {
      paths.push(path);
    } while ((path = path.parentPath));
    return paths;
  }
  function isAncestor(maybeDescendant) {
    return maybeDescendant.isDescendant(this);
  }
  function isDescendant(maybeAncestor) {
    return !!this.findParent((parent) => parent === maybeAncestor);
  }
  function inType(...candidateTypes) {
    let path = this;
    while (path) {
      for (const type of candidateTypes) {
        if (path.node.type === type) return true;
      }
      path = path.parentPath;
    }
    return false;
  }
  return ancestry$1;
}
var inference$1 = {};
var inferers$1 = {};
var infererReference$1 = {};
var util$8 = {};
var hasRequiredUtil$2;
function requireUtil$2() {
  if (hasRequiredUtil$2) return util$8;
  hasRequiredUtil$2 = 1;
  Object.defineProperty(util$8, "__esModule", { value: true });
  util$8.createUnionType = createUnionType;
  var _t = t$d;
  const {
    createFlowUnionType: createFlowUnionType,
    createTSUnionType: createTSUnionType,
    createUnionTypeAnnotation: createUnionTypeAnnotation,
    isFlowType: isFlowType,
    isTSType: isTSType,
  } = _t;
  function createUnionType(types) {
    {
      if (types.every((v) => isFlowType(v))) {
        if (createFlowUnionType) {
          return createFlowUnionType(types);
        }
        return createUnionTypeAnnotation(types);
      } else if (types.every((v) => isTSType(v))) {
        if (createTSUnionType) {
          return createTSUnionType(types);
        }
      }
    }
  }
  return util$8;
}
var hasRequiredInfererReference$1;
function requireInfererReference$1() {
  if (hasRequiredInfererReference$1) return infererReference$1;
  hasRequiredInfererReference$1 = 1;
  Object.defineProperty(infererReference$1, "__esModule", { value: true });
  infererReference$1.default = _default;
  var _t = t$d;
  var _util = requireUtil$2();
  const {
    BOOLEAN_NUMBER_BINARY_OPERATORS: BOOLEAN_NUMBER_BINARY_OPERATORS,
    createTypeAnnotationBasedOnTypeof: createTypeAnnotationBasedOnTypeof,
    numberTypeAnnotation: numberTypeAnnotation,
    voidTypeAnnotation: voidTypeAnnotation,
  } = _t;
  function _default(node) {
    if (!this.isReferenced()) return;
    const binding = this.scope.getBinding(node.name);
    if (binding) {
      if (binding.identifier.typeAnnotation) {
        return binding.identifier.typeAnnotation;
      } else {
        return getTypeAnnotationBindingConstantViolations(
          binding,
          this,
          node.name,
        );
      }
    }
    if (node.name === "undefined") {
      return voidTypeAnnotation();
    } else if (node.name === "NaN" || node.name === "Infinity") {
      return numberTypeAnnotation();
    } else if (node.name === "arguments");
  }
  function getTypeAnnotationBindingConstantViolations(binding, path, name) {
    const types = [];
    const functionConstantViolations = [];
    let constantViolations = getConstantViolationsBefore(
      binding,
      path,
      functionConstantViolations,
    );
    const testType = getConditionalAnnotation(binding, path, name);
    if (testType) {
      const testConstantViolations = getConstantViolationsBefore(
        binding,
        testType.ifStatement,
      );
      constantViolations = constantViolations.filter(
        (path) => testConstantViolations.indexOf(path) < 0,
      );
      types.push(testType.typeAnnotation);
    }
    if (constantViolations.length) {
      constantViolations.push(...functionConstantViolations);
      for (const violation of constantViolations) {
        types.push(violation.getTypeAnnotation());
      }
    }
    if (!types.length) {
      return;
    }
    return (0, _util.createUnionType)(types);
  }
  function getConstantViolationsBefore(binding, path, functions) {
    const violations = binding.constantViolations.slice();
    violations.unshift(binding.path);
    return violations.filter((violation) => {
      violation = violation.resolve();
      const status = violation._guessExecutionStatusRelativeTo(path);
      if (functions && status === "unknown") functions.push(violation);
      return status === "before";
    });
  }
  function inferAnnotationFromBinaryExpression(name, path) {
    const operator = path.node.operator;
    const right = path.get("right").resolve();
    const left = path.get("left").resolve();
    let target;
    if (left.isIdentifier({ name: name })) {
      target = right;
    } else if (right.isIdentifier({ name: name })) {
      target = left;
    }
    if (target) {
      if (operator === "===") {
        return target.getTypeAnnotation();
      }
      if (BOOLEAN_NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
        return numberTypeAnnotation();
      }
      return;
    }
    if (operator !== "===" && operator !== "==") return;
    let typeofPath;
    let typePath;
    if (left.isUnaryExpression({ operator: "typeof" })) {
      typeofPath = left;
      typePath = right;
    } else if (right.isUnaryExpression({ operator: "typeof" })) {
      typeofPath = right;
      typePath = left;
    }
    if (!typeofPath) return;
    if (!typeofPath.get("argument").isIdentifier({ name: name })) return;
    typePath = typePath.resolve();
    if (!typePath.isLiteral()) return;
    const typeValue = typePath.node.value;
    if (typeof typeValue !== "string") return;
    return createTypeAnnotationBasedOnTypeof(typeValue);
  }
  function getParentConditionalPath(binding, path, name) {
    let parentPath;
    while ((parentPath = path.parentPath)) {
      if (parentPath.isIfStatement() || parentPath.isConditionalExpression()) {
        if (path.key === "test") {
          return;
        }
        return parentPath;
      }
      if (parentPath.isFunction()) {
        if (parentPath.parentPath.scope.getBinding(name) !== binding) return;
      }
      path = parentPath;
    }
  }
  function getConditionalAnnotation(binding, path, name) {
    const ifStatement = getParentConditionalPath(binding, path, name);
    if (!ifStatement) return;
    const test = ifStatement.get("test");
    const paths = [test];
    const types = [];
    for (let i = 0; i < paths.length; i++) {
      const path = paths[i];
      if (path.isLogicalExpression()) {
        if (path.node.operator === "&&") {
          paths.push(path.get("left"));
          paths.push(path.get("right"));
        }
      } else if (path.isBinaryExpression()) {
        const type = inferAnnotationFromBinaryExpression(name, path);
        if (type) types.push(type);
      }
    }
    if (types.length) {
      return {
        typeAnnotation: (0, _util.createUnionType)(types),
        ifStatement: ifStatement,
      };
    }
    return getConditionalAnnotation(binding, ifStatement, name);
  }
  return infererReference$1;
}
var hasRequiredInferers$1;
function requireInferers$1() {
  if (hasRequiredInferers$1) return inferers$1;
  hasRequiredInferers$1 = 1;
  (function (exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ArrayExpression = ArrayExpression;
    exports.AssignmentExpression = AssignmentExpression;
    exports.BinaryExpression = BinaryExpression;
    exports.BooleanLiteral = BooleanLiteral;
    exports.CallExpression = CallExpression;
    exports.ConditionalExpression = ConditionalExpression;
    exports.ClassDeclaration =
      exports.ClassExpression =
      exports.FunctionDeclaration =
      exports.ArrowFunctionExpression =
      exports.FunctionExpression =
        Func;
    Object.defineProperty(exports, "Identifier", {
      enumerable: true,
      get: function () {
        return _infererReference.default;
      },
    });
    exports.LogicalExpression = LogicalExpression;
    exports.NewExpression = NewExpression;
    exports.NullLiteral = NullLiteral;
    exports.NumericLiteral = NumericLiteral;
    exports.ObjectExpression = ObjectExpression;
    exports.ParenthesizedExpression = ParenthesizedExpression;
    exports.RegExpLiteral = RegExpLiteral;
    exports.RestElement = RestElement;
    exports.SequenceExpression = SequenceExpression;
    exports.StringLiteral = StringLiteral;
    exports.TSAsExpression = TSAsExpression;
    exports.TSNonNullExpression = TSNonNullExpression;
    exports.TaggedTemplateExpression = TaggedTemplateExpression;
    exports.TemplateLiteral = TemplateLiteral;
    exports.TypeCastExpression = TypeCastExpression;
    exports.UnaryExpression = UnaryExpression;
    exports.UpdateExpression = UpdateExpression;
    exports.VariableDeclarator = VariableDeclarator;
    var _t = t$d;
    var _infererReference = requireInfererReference$1();
    var _util = requireUtil$2();
    const {
      BOOLEAN_BINARY_OPERATORS: BOOLEAN_BINARY_OPERATORS,
      BOOLEAN_UNARY_OPERATORS: BOOLEAN_UNARY_OPERATORS,
      NUMBER_BINARY_OPERATORS: NUMBER_BINARY_OPERATORS,
      NUMBER_UNARY_OPERATORS: NUMBER_UNARY_OPERATORS,
      STRING_UNARY_OPERATORS: STRING_UNARY_OPERATORS,
      anyTypeAnnotation: anyTypeAnnotation,
      arrayTypeAnnotation: arrayTypeAnnotation,
      booleanTypeAnnotation: booleanTypeAnnotation,
      buildMatchMemberExpression: buildMatchMemberExpression,
      genericTypeAnnotation: genericTypeAnnotation,
      identifier: identifier,
      nullLiteralTypeAnnotation: nullLiteralTypeAnnotation,
      numberTypeAnnotation: numberTypeAnnotation,
      stringTypeAnnotation: stringTypeAnnotation,
      tupleTypeAnnotation: tupleTypeAnnotation,
      unionTypeAnnotation: unionTypeAnnotation,
      voidTypeAnnotation: voidTypeAnnotation,
      isIdentifier: isIdentifier,
    } = _t;
    function VariableDeclarator() {
      if (!this.get("id").isIdentifier()) return;
      return this.get("init").getTypeAnnotation();
    }
    function TypeCastExpression(node) {
      return node.typeAnnotation;
    }
    TypeCastExpression.validParent = true;
    function TSAsExpression(node) {
      return node.typeAnnotation;
    }
    TSAsExpression.validParent = true;
    function TSNonNullExpression() {
      return this.get("expression").getTypeAnnotation();
    }
    function NewExpression(node) {
      if (node.callee.type === "Identifier") {
        return genericTypeAnnotation(node.callee);
      }
    }
    function TemplateLiteral() {
      return stringTypeAnnotation();
    }
    function UnaryExpression(node) {
      const operator = node.operator;
      if (operator === "void") {
        return voidTypeAnnotation();
      } else if (NUMBER_UNARY_OPERATORS.indexOf(operator) >= 0) {
        return numberTypeAnnotation();
      } else if (STRING_UNARY_OPERATORS.indexOf(operator) >= 0) {
        return stringTypeAnnotation();
      } else if (BOOLEAN_UNARY_OPERATORS.indexOf(operator) >= 0) {
        return booleanTypeAnnotation();
      }
    }
    function BinaryExpression(node) {
      const operator = node.operator;
      if (NUMBER_BINARY_OPERATORS.indexOf(operator) >= 0) {
        return numberTypeAnnotation();
      } else if (BOOLEAN_BINARY_OPERATORS.indexOf(operator) >= 0) {
        return booleanTypeAnnotation();
      } else if (operator === "+") {
        const right = this.get("right");
        const left = this.get("left");
        if (left.isBaseType("number") && right.isBaseType("number")) {
          return numberTypeAnnotation();
        } else if (left.isBaseType("string") || right.isBaseType("string")) {
          return stringTypeAnnotation();
        }
        return unionTypeAnnotation([
          stringTypeAnnotation(),
          numberTypeAnnotation(),
        ]);
      }
    }
    function LogicalExpression() {
      const argumentTypes = [
        this.get("left").getTypeAnnotation(),
        this.get("right").getTypeAnnotation(),
      ];
      return (0, _util.createUnionType)(argumentTypes);
    }
    function ConditionalExpression() {
      const argumentTypes = [
        this.get("consequent").getTypeAnnotation(),
        this.get("alternate").getTypeAnnotation(),
      ];
      return (0, _util.createUnionType)(argumentTypes);
    }
    function SequenceExpression() {
      return this.get("expressions").pop().getTypeAnnotation();
    }
    function ParenthesizedExpression() {
      return this.get("expression").getTypeAnnotation();
    }
    function AssignmentExpression() {
      return this.get("right").getTypeAnnotation();
    }
    function UpdateExpression(node) {
      const operator = node.operator;
      if (operator === "++" || operator === "--") {
        return numberTypeAnnotation();
      }
    }
    function StringLiteral() {
      return stringTypeAnnotation();
    }
    function NumericLiteral() {
      return numberTypeAnnotation();
    }
    function BooleanLiteral() {
      return booleanTypeAnnotation();
    }
    function NullLiteral() {
      return nullLiteralTypeAnnotation();
    }
    function RegExpLiteral() {
      return genericTypeAnnotation(identifier("RegExp"));
    }
    function ObjectExpression() {
      return genericTypeAnnotation(identifier("Object"));
    }
    function ArrayExpression() {
      return genericTypeAnnotation(identifier("Array"));
    }
    function RestElement() {
      return ArrayExpression();
    }
    RestElement.validParent = true;
    function Func() {
      return genericTypeAnnotation(identifier("Function"));
    }
    const isArrayFrom = buildMatchMemberExpression("Array.from");
    const isObjectKeys = buildMatchMemberExpression("Object.keys");
    const isObjectValues = buildMatchMemberExpression("Object.values");
    const isObjectEntries = buildMatchMemberExpression("Object.entries");
    function CallExpression() {
      const { callee: callee } = this.node;
      if (isObjectKeys(callee)) {
        return arrayTypeAnnotation(stringTypeAnnotation());
      } else if (
        isArrayFrom(callee) ||
        isObjectValues(callee) ||
        isIdentifier(callee, { name: "Array" })
      ) {
        return arrayTypeAnnotation(anyTypeAnnotation());
      } else if (isObjectEntries(callee)) {
        return arrayTypeAnnotation(
          tupleTypeAnnotation([stringTypeAnnotation(), anyTypeAnnotation()]),
        );
      }
      return resolveCall(this.get("callee"));
    }
    function TaggedTemplateExpression() {
      return resolveCall(this.get("tag"));
    }
    function resolveCall(callee) {
      callee = callee.resolve();
      if (callee.isFunction()) {
        const { node: node } = callee;
        if (node.async) {
          if (node.generator) {
            return genericTypeAnnotation(identifier("AsyncIterator"));
          } else {
            return genericTypeAnnotation(identifier("Promise"));
          }
        } else {
          if (node.generator) {
            return genericTypeAnnotation(identifier("Iterator"));
          } else if (callee.node.returnType) {
            return callee.node.returnType;
          } else;
        }
      }
    }
  })(inferers$1);
  return inferers$1;
}
var hasRequiredInference$1;
function requireInference$1() {
  if (hasRequiredInference$1) return inference$1;
  hasRequiredInference$1 = 1;
  Object.defineProperty(inference$1, "__esModule", { value: true });
  inference$1._getTypeAnnotation = _getTypeAnnotation;
  inference$1.baseTypeStrictlyMatches = baseTypeStrictlyMatches;
  inference$1.couldBeBaseType = couldBeBaseType;
  inference$1.getTypeAnnotation = getTypeAnnotation;
  inference$1.isBaseType = isBaseType;
  inference$1.isGenericType = isGenericType;
  var inferers = requireInferers$1();
  var _t = t$d;
  const {
    anyTypeAnnotation: anyTypeAnnotation,
    isAnyTypeAnnotation: isAnyTypeAnnotation,
    isArrayTypeAnnotation: isArrayTypeAnnotation,
    isBooleanTypeAnnotation: isBooleanTypeAnnotation,
    isEmptyTypeAnnotation: isEmptyTypeAnnotation,
    isFlowBaseAnnotation: isFlowBaseAnnotation,
    isGenericTypeAnnotation: isGenericTypeAnnotation,
    isIdentifier: isIdentifier,
    isMixedTypeAnnotation: isMixedTypeAnnotation,
    isNumberTypeAnnotation: isNumberTypeAnnotation,
    isStringTypeAnnotation: isStringTypeAnnotation,
    isTSArrayType: isTSArrayType,
    isTSTypeAnnotation: isTSTypeAnnotation,
    isTSTypeReference: isTSTypeReference,
    isTupleTypeAnnotation: isTupleTypeAnnotation,
    isTypeAnnotation: isTypeAnnotation,
    isUnionTypeAnnotation: isUnionTypeAnnotation,
    isVoidTypeAnnotation: isVoidTypeAnnotation,
    stringTypeAnnotation: stringTypeAnnotation,
    voidTypeAnnotation: voidTypeAnnotation,
  } = _t;
  function getTypeAnnotation() {
    let type = this.getData("typeAnnotation");
    if (type != null) {
      return type;
    }
    type = this._getTypeAnnotation() || anyTypeAnnotation();
    if (isTypeAnnotation(type) || isTSTypeAnnotation(type)) {
      type = type.typeAnnotation;
    }
    this.setData("typeAnnotation", type);
    return type;
  }
  const typeAnnotationInferringNodes = new WeakSet();
  function _getTypeAnnotation() {
    const node = this.node;
    if (!node) {
      if (this.key === "init" && this.parentPath.isVariableDeclarator()) {
        const declar = this.parentPath.parentPath;
        const declarParent = declar.parentPath;
        if (declar.key === "left" && declarParent.isForInStatement()) {
          return stringTypeAnnotation();
        }
        if (declar.key === "left" && declarParent.isForOfStatement()) {
          return anyTypeAnnotation();
        }
        return voidTypeAnnotation();
      } else {
        return;
      }
    }
    if (node.typeAnnotation) {
      return node.typeAnnotation;
    }
    if (typeAnnotationInferringNodes.has(node)) {
      return;
    }
    typeAnnotationInferringNodes.add(node);
    try {
      var _inferer;
      let inferer = inferers[node.type];
      if (inferer) {
        return inferer.call(this, node);
      }
      inferer = inferers[this.parentPath.type];
      if ((_inferer = inferer) != null && _inferer.validParent) {
        return this.parentPath.getTypeAnnotation();
      }
    } finally {
      typeAnnotationInferringNodes.delete(node);
    }
  }
  function isBaseType(baseName, soft) {
    return _isBaseType(baseName, this.getTypeAnnotation(), soft);
  }
  function _isBaseType(baseName, type, soft) {
    if (baseName === "string") {
      return isStringTypeAnnotation(type);
    } else if (baseName === "number") {
      return isNumberTypeAnnotation(type);
    } else if (baseName === "boolean") {
      return isBooleanTypeAnnotation(type);
    } else if (baseName === "any") {
      return isAnyTypeAnnotation(type);
    } else if (baseName === "mixed") {
      return isMixedTypeAnnotation(type);
    } else if (baseName === "empty") {
      return isEmptyTypeAnnotation(type);
    } else if (baseName === "void") {
      return isVoidTypeAnnotation(type);
    } else {
      if (soft) {
        return false;
      } else {
        throw new Error(`Unknown base type ${baseName}`);
      }
    }
  }
  function couldBeBaseType(name) {
    const type = this.getTypeAnnotation();
    if (isAnyTypeAnnotation(type)) return true;
    if (isUnionTypeAnnotation(type)) {
      for (const type2 of type.types) {
        if (isAnyTypeAnnotation(type2) || _isBaseType(name, type2, true)) {
          return true;
        }
      }
      return false;
    } else {
      return _isBaseType(name, type, true);
    }
  }
  function baseTypeStrictlyMatches(rightArg) {
    const left = this.getTypeAnnotation();
    const right = rightArg.getTypeAnnotation();
    if (!isAnyTypeAnnotation(left) && isFlowBaseAnnotation(left)) {
      return right.type === left.type;
    }
    return false;
  }
  function isGenericType(genericName) {
    const type = this.getTypeAnnotation();
    if (genericName === "Array") {
      if (
        isTSArrayType(type) ||
        isArrayTypeAnnotation(type) ||
        isTupleTypeAnnotation(type)
      ) {
        return true;
      }
    }
    return (
      (isGenericTypeAnnotation(type) &&
        isIdentifier(type.id, { name: genericName })) ||
      (isTSTypeReference(type) &&
        isIdentifier(type.typeName, { name: genericName }))
    );
  }
  return inference$1;
}
var replacement$1 = {};
var lib$n = {};
var lib$m = {};
var jsTokens = {};
var hasRequiredJsTokens;
function requireJsTokens() {
  if (hasRequiredJsTokens) return jsTokens;
  hasRequiredJsTokens = 1;
  Object.defineProperty(jsTokens, "__esModule", { value: true });
  jsTokens.default =
    /((['"])(?:(?!\2|\\).|\\(?:\r\n|[\s\S]))*(\2)?|`(?:[^`\\$]|\\[\s\S]|\$(?!\{)|\$\{(?:[^{}]|\{[^}]*\}?)*\}?)*(`)?)|(\/\/.*)|(\/\*(?:[^*]|\*(?!\/))*(\*\/)?)|(\/(?!\*)(?:\[(?:(?![\]\\]).|\\.)*\]|(?![\/\]\\]).|\\.)+\/(?:(?!\s*(?:\b|[\u0080-\uFFFF$\\'"~({]|[+\-!](?!=)|\.?\d))|[gmiyus]{1,6}\b(?![\u0080-\uFFFF$\\]|\s*(?:[+\-*%&|^<>!=?({]|\/(?![\/*])))))|(0[xX][\da-fA-F]+|0[oO][0-7]+|0[bB][01]+|(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?)|((?!\d)(?:(?!\s)[$\w\u0080-\uFFFF]|\\u[\da-fA-F]{4}|\\u\{[\da-fA-F]+\})+)|(--|\+\+|&&|\|\||=>|\.{3}|(?:[+\-\/%&|^]|\*{1,2}|<{1,2}|>{1,3}|!=?|={1,2})=?|[?~.,:;[\](){}])|(\s+)|(^$|[\s\S])/g;
  jsTokens.matchToToken = function (match) {
    var token = { type: "invalid", value: match[0], closed: undefined };
    if (match[1])
      (token.type = "string"), (token.closed = !!(match[3] || match[4]));
    else if (match[5]) token.type = "comment";
    else if (match[6]) (token.type = "comment"), (token.closed = !!match[7]);
    else if (match[8]) token.type = "regex";
    else if (match[9]) token.type = "number";
    else if (match[10]) token.type = "name";
    else if (match[11]) token.type = "punctuator";
    else if (match[12]) token.type = "whitespace";
    return token;
  };
  return jsTokens;
}
var lib$l = {};
var identifier$2 = {};
var hasRequiredIdentifier$2;
function requireIdentifier$2() {
  if (hasRequiredIdentifier$2) return identifier$2;
  hasRequiredIdentifier$2 = 1;
  Object.defineProperty(identifier$2, "__esModule", { value: true });
  identifier$2.isIdentifierChar = isIdentifierChar;
  identifier$2.isIdentifierName = isIdentifierName;
  identifier$2.isIdentifierStart = isIdentifierStart;
  let nonASCIIidentifierStartChars =
    "ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲈᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟊꟐꟑꟓꟕ-ꟙꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ";
  let nonASCIIidentifierChars =
    "‌‍·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛࢘-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･";
  const nonASCIIidentifierStart = new RegExp(
    "[" + nonASCIIidentifierStartChars + "]",
  );
  const nonASCIIidentifier = new RegExp(
    "[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]",
  );
  nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
  const astralIdentifierStartCodes = [
    0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48,
    48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5,
    39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10,
    21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11,
    22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2,
    2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72,
    56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20,
    28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4,
    0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2,
    14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4,
    159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0,
    60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2,
    23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12,
    45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0,
    26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921,
    103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30,
    18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67,
    12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16,
    0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2,
    70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2,
    27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2,
    24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11,
    6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60,
    67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5,
    0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0,
    3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719,
    33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6,
    4191,
  ];
  const astralIdentifierCodes = [
    509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1,
    574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1,
    11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13,
    9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3,
    2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3,
    8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5,
    2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0,
    10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2,
    6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4,
    14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54,
    8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31,
    3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2,
    16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983,
    6, 110, 6, 6, 9, 4759, 9, 787719, 239,
  ];
  function isInAstralSet(code, set) {
    let pos = 65536;
    for (let i = 0, length = set.length; i < length; i += 2) {
      pos += set[i];
      if (pos > code) return false;
      pos += set[i + 1];
      if (pos >= code) return true;
    }
    return false;
  }
  function isIdentifierStart(code) {
    if (code < 65) return code === 36;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;
    if (code <= 65535) {
      return (
        code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code))
      );
    }
    return isInAstralSet(code, astralIdentifierStartCodes);
  }
  function isIdentifierChar(code) {
    if (code < 48) return code === 36;
    if (code < 58) return true;
    if (code < 65) return false;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;
    if (code <= 65535) {
      return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
    }
    return (
      isInAstralSet(code, astralIdentifierStartCodes) ||
      isInAstralSet(code, astralIdentifierCodes)
    );
  }
  function isIdentifierName(name) {
    let isFirst = true;
    for (let i = 0; i < name.length; i++) {
      let cp = name.charCodeAt(i);
      if ((cp & 64512) === 55296 && i + 1 < name.length) {
        const trail = name.charCodeAt(++i);
        if ((trail & 64512) === 56320) {
          cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
        }
      }
      if (isFirst) {
        isFirst = false;
        if (!isIdentifierStart(cp)) {
          return false;
        }
      } else if (!isIdentifierChar(cp)) {
        return false;
      }
    }
    return !isFirst;
  }
  return identifier$2;
}
var keyword$2 = {};
var hasRequiredKeyword$2;
function requireKeyword$2() {
  if (hasRequiredKeyword$2) return keyword$2;
  hasRequiredKeyword$2 = 1;
  Object.defineProperty(keyword$2, "__esModule", { value: true });
  keyword$2.isKeyword = isKeyword;
  keyword$2.isReservedWord = isReservedWord;
  keyword$2.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
  keyword$2.isStrictBindReservedWord = isStrictBindReservedWord;
  keyword$2.isStrictReservedWord = isStrictReservedWord;
  const reservedWords = {
    keyword: [
      "break",
      "case",
      "catch",
      "continue",
      "debugger",
      "default",
      "do",
      "else",
      "finally",
      "for",
      "function",
      "if",
      "return",
      "switch",
      "throw",
      "try",
      "var",
      "const",
      "while",
      "with",
      "new",
      "this",
      "super",
      "class",
      "extends",
      "export",
      "import",
      "null",
      "true",
      "false",
      "in",
      "instanceof",
      "typeof",
      "void",
      "delete",
    ],
    strict: [
      "implements",
      "interface",
      "let",
      "package",
      "private",
      "protected",
      "public",
      "static",
      "yield",
    ],
    strictBind: ["eval", "arguments"],
  };
  const keywords = new Set(reservedWords.keyword);
  const reservedWordsStrictSet = new Set(reservedWords.strict);
  const reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
  function isReservedWord(word, inModule) {
    return (inModule && word === "await") || word === "enum";
  }
  function isStrictReservedWord(word, inModule) {
    return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
  }
  function isStrictBindOnlyReservedWord(word) {
    return reservedWordsStrictBindSet.has(word);
  }
  function isStrictBindReservedWord(word, inModule) {
    return (
      isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word)
    );
  }
  function isKeyword(word) {
    return keywords.has(word);
  }
  return keyword$2;
}
var hasRequiredLib$n;
function requireLib$n() {
  if (hasRequiredLib$n) return lib$l;
  hasRequiredLib$n = 1;
  (function (exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    Object.defineProperty(exports, "isIdentifierChar", {
      enumerable: true,
      get: function () {
        return _identifier.isIdentifierChar;
      },
    });
    Object.defineProperty(exports, "isIdentifierName", {
      enumerable: true,
      get: function () {
        return _identifier.isIdentifierName;
      },
    });
    Object.defineProperty(exports, "isIdentifierStart", {
      enumerable: true,
      get: function () {
        return _identifier.isIdentifierStart;
      },
    });
    Object.defineProperty(exports, "isKeyword", {
      enumerable: true,
      get: function () {
        return _keyword.isKeyword;
      },
    });
    Object.defineProperty(exports, "isReservedWord", {
      enumerable: true,
      get: function () {
        return _keyword.isReservedWord;
      },
    });
    Object.defineProperty(exports, "isStrictBindOnlyReservedWord", {
      enumerable: true,
      get: function () {
        return _keyword.isStrictBindOnlyReservedWord;
      },
    });
    Object.defineProperty(exports, "isStrictBindReservedWord", {
      enumerable: true,
      get: function () {
        return _keyword.isStrictBindReservedWord;
      },
    });
    Object.defineProperty(exports, "isStrictReservedWord", {
      enumerable: true,
      get: function () {
        return _keyword.isStrictReservedWord;
      },
    });
    var _identifier = requireIdentifier$2();
    var _keyword = requireKeyword$2();
  })(lib$l);
  return lib$l;
}
var picocolors = { exports: {} };
var hasRequiredPicocolors;
function requirePicocolors() {
  if (hasRequiredPicocolors) return picocolors.exports;
  hasRequiredPicocolors = 1;
  let tty = require$$0$3;
  let isColorSupported =
    !("NO_COLOR" in process.env || process.argv.includes("--no-color")) &&
    ("FORCE_COLOR" in process.env ||
      process.argv.includes("--color") ||
      process.platform === "win32" ||
      (tty.isatty(1) && process.env.TERM !== "dumb") ||
      "CI" in process.env);
  let formatter =
    (open, close, replace = open) =>
    (input) => {
      let string = "" + input;
      let index = string.indexOf(close, open.length);
      return ~index
        ? open + replaceClose(string, close, replace, index) + close
        : open + string + close;
    };
  let replaceClose = (string, close, replace, index) => {
    let start = string.substring(0, index) + replace;
    let end = string.substring(index + close.length);
    let nextIndex = end.indexOf(close);
    return ~nextIndex
      ? start + replaceClose(end, close, replace, nextIndex)
      : start + end;
  };
  let createColors = (enabled = isColorSupported) => ({
    isColorSupported: enabled,
    reset: enabled ? (s) => `[0m${s}[0m` : String,
    bold: enabled ? formatter("[1m", "[22m", "[22m[1m") : String,
    dim: enabled ? formatter("[2m", "[22m", "[22m[2m") : String,
    italic: enabled ? formatter("[3m", "[23m") : String,
    underline: enabled ? formatter("[4m", "[24m") : String,
    inverse: enabled ? formatter("[7m", "[27m") : String,
    hidden: enabled ? formatter("[8m", "[28m") : String,
    strikethrough: enabled ? formatter("[9m", "[29m") : String,
    black: enabled ? formatter("[30m", "[39m") : String,
    red: enabled ? formatter("[31m", "[39m") : String,
    green: enabled ? formatter("[32m", "[39m") : String,
    yellow: enabled ? formatter("[33m", "[39m") : String,
    blue: enabled ? formatter("[34m", "[39m") : String,
    magenta: enabled ? formatter("[35m", "[39m") : String,
    cyan: enabled ? formatter("[36m", "[39m") : String,
    white: enabled ? formatter("[37m", "[39m") : String,
    gray: enabled ? formatter("[90m", "[39m") : String,
    bgBlack: enabled ? formatter("[40m", "[49m") : String,
    bgRed: enabled ? formatter("[41m", "[49m") : String,
    bgGreen: enabled ? formatter("[42m", "[49m") : String,
    bgYellow: enabled ? formatter("[43m", "[49m") : String,
    bgBlue: enabled ? formatter("[44m", "[49m") : String,
    bgMagenta: enabled ? formatter("[45m", "[49m") : String,
    bgCyan: enabled ? formatter("[46m", "[49m") : String,
    bgWhite: enabled ? formatter("[47m", "[49m") : String,
  });
  picocolors.exports = createColors();
  picocolors.exports.createColors = createColors;
  return picocolors.exports;
}
var chalk$3 = { exports: {} };
var escapeStringRegexp$2;
var hasRequiredEscapeStringRegexp$2;
function requireEscapeStringRegexp$2() {
  if (hasRequiredEscapeStringRegexp$2) return escapeStringRegexp$2;
  hasRequiredEscapeStringRegexp$2 = 1;
  var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
  escapeStringRegexp$2 = function (str) {
    if (typeof str !== "string") {
      throw new TypeError("Expected a string");
    }
    return str.replace(matchOperatorsRe, "\\$&");
  };
  return escapeStringRegexp$2;
}
var ansiStyles$4 = { exports: {} };
var conversions$5 = { exports: {} };
var colorName$3;
var hasRequiredColorName$2;
function requireColorName$2() {
  if (hasRequiredColorName$2) return colorName$3;
  hasRequiredColorName$2 = 1;
  colorName$3 = {
    aliceblue: [240, 248, 255],
    antiquewhite: [250, 235, 215],
    aqua: [0, 255, 255],
    aquamarine: [127, 255, 212],
    azure: [240, 255, 255],
    beige: [245, 245, 220],
    bisque: [255, 228, 196],
    black: [0, 0, 0],
    blanchedalmond: [255, 235, 205],
    blue: [0, 0, 255],
    blueviolet: [138, 43, 226],
    brown: [165, 42, 42],
    burlywood: [222, 184, 135],
    cadetblue: [95, 158, 160],
    chartreuse: [127, 255, 0],
    chocolate: [210, 105, 30],
    coral: [255, 127, 80],
    cornflowerblue: [100, 149, 237],
    cornsilk: [255, 248, 220],
    crimson: [220, 20, 60],
    cyan: [0, 255, 255],
    darkblue: [0, 0, 139],
    darkcyan: [0, 139, 139],
    darkgoldenrod: [184, 134, 11],
    darkgray: [169, 169, 169],
    darkgreen: [0, 100, 0],
    darkgrey: [169, 169, 169],
    darkkhaki: [189, 183, 107],
    darkmagenta: [139, 0, 139],
    darkolivegreen: [85, 107, 47],
    darkorange: [255, 140, 0],
    darkorchid: [153, 50, 204],
    darkred: [139, 0, 0],
    darksalmon: [233, 150, 122],
    darkseagreen: [143, 188, 143],
    darkslateblue: [72, 61, 139],
    darkslategray: [47, 79, 79],
    darkslategrey: [47, 79, 79],
    darkturquoise: [0, 206, 209],
    darkviolet: [148, 0, 211],
    deeppink: [255, 20, 147],
    deepskyblue: [0, 191, 255],
    dimgray: [105, 105, 105],
    dimgrey: [105, 105, 105],
    dodgerblue: [30, 144, 255],
    firebrick: [178, 34, 34],
    floralwhite: [255, 250, 240],
    forestgreen: [34, 139, 34],
    fuchsia: [255, 0, 255],
    gainsboro: [220, 220, 220],
    ghostwhite: [248, 248, 255],
    gold: [255, 215, 0],
    goldenrod: [218, 165, 32],
    gray: [128, 128, 128],
    green: [0, 128, 0],
    greenyellow: [173, 255, 47],
    grey: [128, 128, 128],
    honeydew: [240, 255, 240],
    hotpink: [255, 105, 180],
    indianred: [205, 92, 92],
    indigo: [75, 0, 130],
    ivory: [255, 255, 240],
    khaki: [240, 230, 140],
    lavender: [230, 230, 250],
    lavenderblush: [255, 240, 245],
    lawngreen: [124, 252, 0],
    lemonchiffon: [255, 250, 205],
    lightblue: [173, 216, 230],
    lightcoral: [240, 128, 128],
    lightcyan: [224, 255, 255],
    lightgoldenrodyellow: [250, 250, 210],
    lightgray: [211, 211, 211],
    lightgreen: [144, 238, 144],
    lightgrey: [211, 211, 211],
    lightpink: [255, 182, 193],
    lightsalmon: [255, 160, 122],
    lightseagreen: [32, 178, 170],
    lightskyblue: [135, 206, 250],
    lightslategray: [119, 136, 153],
    lightslategrey: [119, 136, 153],
    lightsteelblue: [176, 196, 222],
    lightyellow: [255, 255, 224],
    lime: [0, 255, 0],
    limegreen: [50, 205, 50],
    linen: [250, 240, 230],
    magenta: [255, 0, 255],
    maroon: [128, 0, 0],
    mediumaquamarine: [102, 205, 170],
    mediumblue: [0, 0, 205],
    mediumorchid: [186, 85, 211],
    mediumpurple: [147, 112, 219],
    mediumseagreen: [60, 179, 113],
    mediumslateblue: [123, 104, 238],
    mediumspringgreen: [0, 250, 154],
    mediumturquoise: [72, 209, 204],
    mediumvioletred: [199, 21, 133],
    midnightblue: [25, 25, 112],
    mintcream: [245, 255, 250],
    mistyrose: [255, 228, 225],
    moccasin: [255, 228, 181],
    navajowhite: [255, 222, 173],
    navy: [0, 0, 128],
    oldlace: [253, 245, 230],
    olive: [128, 128, 0],
    olivedrab: [107, 142, 35],
    orange: [255, 165, 0],
    orangered: [255, 69, 0],
    orchid: [218, 112, 214],
    palegoldenrod: [238, 232, 170],
    palegreen: [152, 251, 152],
    paleturquoise: [175, 238, 238],
    palevioletred: [219, 112, 147],
    papayawhip: [255, 239, 213],
    peachpuff: [255, 218, 185],
    peru: [205, 133, 63],
    pink: [255, 192, 203],
    plum: [221, 160, 221],
    powderblue: [176, 224, 230],
    purple: [128, 0, 128],
    rebeccapurple: [102, 51, 153],
    red: [255, 0, 0],
    rosybrown: [188, 143, 143],
    royalblue: [65, 105, 225],
    saddlebrown: [139, 69, 19],
    salmon: [250, 128, 114],
    sandybrown: [244, 164, 96],
    seagreen: [46, 139, 87],
    seashell: [255, 245, 238],
    sienna: [160, 82, 45],
    silver: [192, 192, 192],
    skyblue: [135, 206, 235],
    slateblue: [106, 90, 205],
    slategray: [112, 128, 144],
    slategrey: [112, 128, 144],
    snow: [255, 250, 250],
    springgreen: [0, 255, 127],
    steelblue: [70, 130, 180],
    tan: [210, 180, 140],
    teal: [0, 128, 128],
    thistle: [216, 191, 216],
    tomato: [255, 99, 71],
    turquoise: [64, 224, 208],
    violet: [238, 130, 238],
    wheat: [245, 222, 179],
    white: [255, 255, 255],
    whitesmoke: [245, 245, 245],
    yellow: [255, 255, 0],
    yellowgreen: [154, 205, 50],
  };
  return colorName$3;
}
var hasRequiredConversions$2;
function requireConversions$2() {
  if (hasRequiredConversions$2) return conversions$5.exports;
  hasRequiredConversions$2 = 1;
  var cssKeywords = requireColorName$2();
  var reverseKeywords = {};
  for (var key in cssKeywords) {
    if (cssKeywords.hasOwnProperty(key)) {
      reverseKeywords[cssKeywords[key]] = key;
    }
  }
  var convert = (conversions$5.exports = {
    rgb: { channels: 3, labels: "rgb" },
    hsl: { channels: 3, labels: "hsl" },
    hsv: { channels: 3, labels: "hsv" },
    hwb: { channels: 3, labels: "hwb" },
    cmyk: { channels: 4, labels: "cmyk" },
    xyz: { channels: 3, labels: "xyz" },
    lab: { channels: 3, labels: "lab" },
    lch: { channels: 3, labels: "lch" },
    hex: { channels: 1, labels: ["hex"] },
    keyword: { channels: 1, labels: ["keyword"] },
    ansi16: { channels: 1, labels: ["ansi16"] },
    ansi256: { channels: 1, labels: ["ansi256"] },
    hcg: { channels: 3, labels: ["h", "c", "g"] },
    apple: { channels: 3, labels: ["r16", "g16", "b16"] },
    gray: { channels: 1, labels: ["gray"] },
  });
  for (var model in convert) {
    if (convert.hasOwnProperty(model)) {
      if (!("channels" in convert[model])) {
        throw new Error("missing channels property: " + model);
      }
      if (!("labels" in convert[model])) {
        throw new Error("missing channel labels property: " + model);
      }
      if (convert[model].labels.length !== convert[model].channels) {
        throw new Error("channel and label counts mismatch: " + model);
      }
      var channels = convert[model].channels;
      var labels = convert[model].labels;
      delete convert[model].channels;
      delete convert[model].labels;
      Object.defineProperty(convert[model], "channels", { value: channels });
      Object.defineProperty(convert[model], "labels", { value: labels });
    }
  }
  convert.rgb.hsl = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var min = Math.min(r, g, b);
    var max = Math.max(r, g, b);
    var delta = max - min;
    var h;
    var s;
    var l;
    if (max === min) {
      h = 0;
    } else if (r === max) {
      h = (g - b) / delta;
    } else if (g === max) {
      h = 2 + (b - r) / delta;
    } else if (b === max) {
      h = 4 + (r - g) / delta;
    }
    h = Math.min(h * 60, 360);
    if (h < 0) {
      h += 360;
    }
    l = (min + max) / 2;
    if (max === min) {
      s = 0;
    } else if (l <= 0.5) {
      s = delta / (max + min);
    } else {
      s = delta / (2 - max - min);
    }
    return [h, s * 100, l * 100];
  };
  convert.rgb.hsv = function (rgb) {
    var rdif;
    var gdif;
    var bdif;
    var h;
    var s;
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var v = Math.max(r, g, b);
    var diff = v - Math.min(r, g, b);
    var diffc = function (c) {
      return (v - c) / 6 / diff + 1 / 2;
    };
    if (diff === 0) {
      h = s = 0;
    } else {
      s = diff / v;
      rdif = diffc(r);
      gdif = diffc(g);
      bdif = diffc(b);
      if (r === v) {
        h = bdif - gdif;
      } else if (g === v) {
        h = 1 / 3 + rdif - bdif;
      } else if (b === v) {
        h = 2 / 3 + gdif - rdif;
      }
      if (h < 0) {
        h += 1;
      } else if (h > 1) {
        h -= 1;
      }
    }
    return [h * 360, s * 100, v * 100];
  };
  convert.rgb.hwb = function (rgb) {
    var r = rgb[0];
    var g = rgb[1];
    var b = rgb[2];
    var h = convert.rgb.hsl(rgb)[0];
    var w = (1 / 255) * Math.min(r, Math.min(g, b));
    b = 1 - (1 / 255) * Math.max(r, Math.max(g, b));
    return [h, w * 100, b * 100];
  };
  convert.rgb.cmyk = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var c;
    var m;
    var y;
    var k;
    k = Math.min(1 - r, 1 - g, 1 - b);
    c = (1 - r - k) / (1 - k) || 0;
    m = (1 - g - k) / (1 - k) || 0;
    y = (1 - b - k) / (1 - k) || 0;
    return [c * 100, m * 100, y * 100, k * 100];
  };
  function comparativeDistance(x, y) {
    return (
      Math.pow(x[0] - y[0], 2) +
      Math.pow(x[1] - y[1], 2) +
      Math.pow(x[2] - y[2], 2)
    );
  }
  convert.rgb.keyword = function (rgb) {
    var reversed = reverseKeywords[rgb];
    if (reversed) {
      return reversed;
    }
    var currentClosestDistance = Infinity;
    var currentClosestKeyword;
    for (var keyword in cssKeywords) {
      if (cssKeywords.hasOwnProperty(keyword)) {
        var value = cssKeywords[keyword];
        var distance = comparativeDistance(rgb, value);
        if (distance < currentClosestDistance) {
          currentClosestDistance = distance;
          currentClosestKeyword = keyword;
        }
      }
    }
    return currentClosestKeyword;
  };
  convert.keyword.rgb = function (keyword) {
    return cssKeywords[keyword];
  };
  convert.rgb.xyz = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
    g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
    b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
    var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
    var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
    var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
    return [x * 100, y * 100, z * 100];
  };
  convert.rgb.lab = function (rgb) {
    var xyz = convert.rgb.xyz(rgb);
    var x = xyz[0];
    var y = xyz[1];
    var z = xyz[2];
    var l;
    var a;
    var b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  };
  convert.hsl.rgb = function (hsl) {
    var h = hsl[0] / 360;
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var t1;
    var t2;
    var t3;
    var rgb;
    var val;
    if (s === 0) {
      val = l * 255;
      return [val, val, val];
    }
    if (l < 0.5) {
      t2 = l * (1 + s);
    } else {
      t2 = l + s - l * s;
    }
    t1 = 2 * l - t2;
    rgb = [0, 0, 0];
    for (var i = 0; i < 3; i++) {
      t3 = h + (1 / 3) * -(i - 1);
      if (t3 < 0) {
        t3++;
      }
      if (t3 > 1) {
        t3--;
      }
      if (6 * t3 < 1) {
        val = t1 + (t2 - t1) * 6 * t3;
      } else if (2 * t3 < 1) {
        val = t2;
      } else if (3 * t3 < 2) {
        val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
      } else {
        val = t1;
      }
      rgb[i] = val * 255;
    }
    return rgb;
  };
  convert.hsl.hsv = function (hsl) {
    var h = hsl[0];
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var smin = s;
    var lmin = Math.max(l, 0.01);
    var sv;
    var v;
    l *= 2;
    s *= l <= 1 ? l : 2 - l;
    smin *= lmin <= 1 ? lmin : 2 - lmin;
    v = (l + s) / 2;
    sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);
    return [h, sv * 100, v * 100];
  };
  convert.hsv.rgb = function (hsv) {
    var h = hsv[0] / 60;
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var hi = Math.floor(h) % 6;
    var f = h - Math.floor(h);
    var p = 255 * v * (1 - s);
    var q = 255 * v * (1 - s * f);
    var t = 255 * v * (1 - s * (1 - f));
    v *= 255;
    switch (hi) {
      case 0:
        return [v, t, p];
      case 1:
        return [q, v, p];
      case 2:
        return [p, v, t];
      case 3:
        return [p, q, v];
      case 4:
        return [t, p, v];
      case 5:
        return [v, p, q];
    }
  };
  convert.hsv.hsl = function (hsv) {
    var h = hsv[0];
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var vmin = Math.max(v, 0.01);
    var lmin;
    var sl;
    var l;
    l = (2 - s) * v;
    lmin = (2 - s) * vmin;
    sl = s * vmin;
    sl /= lmin <= 1 ? lmin : 2 - lmin;
    sl = sl || 0;
    l /= 2;
    return [h, sl * 100, l * 100];
  };
  convert.hwb.rgb = function (hwb) {
    var h = hwb[0] / 360;
    var wh = hwb[1] / 100;
    var bl = hwb[2] / 100;
    var ratio = wh + bl;
    var i;
    var v;
    var f;
    var n;
    if (ratio > 1) {
      wh /= ratio;
      bl /= ratio;
    }
    i = Math.floor(6 * h);
    v = 1 - bl;
    f = 6 * h - i;
    if ((i & 1) !== 0) {
      f = 1 - f;
    }
    n = wh + f * (v - wh);
    var r;
    var g;
    var b;
    switch (i) {
      default:
      case 6:
      case 0:
        r = v;
        g = n;
        b = wh;
        break;
      case 1:
        r = n;
        g = v;
        b = wh;
        break;
      case 2:
        r = wh;
        g = v;
        b = n;
        break;
      case 3:
        r = wh;
        g = n;
        b = v;
        break;
      case 4:
        r = n;
        g = wh;
        b = v;
        break;
      case 5:
        r = v;
        g = wh;
        b = n;
        break;
    }
    return [r * 255, g * 255, b * 255];
  };
  convert.cmyk.rgb = function (cmyk) {
    var c = cmyk[0] / 100;
    var m = cmyk[1] / 100;
    var y = cmyk[2] / 100;
    var k = cmyk[3] / 100;
    var r;
    var g;
    var b;
    r = 1 - Math.min(1, c * (1 - k) + k);
    g = 1 - Math.min(1, m * (1 - k) + k);
    b = 1 - Math.min(1, y * (1 - k) + k);
    return [r * 255, g * 255, b * 255];
  };
  convert.xyz.rgb = function (xyz) {
    var x = xyz[0] / 100;
    var y = xyz[1] / 100;
    var z = xyz[2] / 100;
    var r;
    var g;
    var b;
    r = x * 3.2406 + y * -1.5372 + z * -0.4986;
    g = x * -0.9689 + y * 1.8758 + z * 0.0415;
    b = x * 0.0557 + y * -0.204 + z * 1.057;
    r = r > 0.0031308 ? 1.055 * Math.pow(r, 1 / 2.4) - 0.055 : r * 12.92;
    g = g > 0.0031308 ? 1.055 * Math.pow(g, 1 / 2.4) - 0.055 : g * 12.92;
    b = b > 0.0031308 ? 1.055 * Math.pow(b, 1 / 2.4) - 0.055 : b * 12.92;
    r = Math.min(Math.max(0, r), 1);
    g = Math.min(Math.max(0, g), 1);
    b = Math.min(Math.max(0, b), 1);
    return [r * 255, g * 255, b * 255];
  };
  convert.xyz.lab = function (xyz) {
    var x = xyz[0];
    var y = xyz[1];
    var z = xyz[2];
    var l;
    var a;
    var b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  };
  convert.lab.xyz = function (lab) {
    var l = lab[0];
    var a = lab[1];
    var b = lab[2];
    var x;
    var y;
    var z;
    y = (l + 16) / 116;
    x = a / 500 + y;
    z = y - b / 200;
    var y2 = Math.pow(y, 3);
    var x2 = Math.pow(x, 3);
    var z2 = Math.pow(z, 3);
    y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
    x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
    z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;
    x *= 95.047;
    y *= 100;
    z *= 108.883;
    return [x, y, z];
  };
  convert.lab.lch = function (lab) {
    var l = lab[0];
    var a = lab[1];
    var b = lab[2];
    var hr;
    var h;
    var c;
    hr = Math.atan2(b, a);
    h = (hr * 360) / 2 / Math.PI;
    if (h < 0) {
      h += 360;
    }
    c = Math.sqrt(a * a + b * b);
    return [l, c, h];
  };
  convert.lch.lab = function (lch) {
    var l = lch[0];
    var c = lch[1];
    var h = lch[2];
    var a;
    var b;
    var hr;
    hr = (h / 360) * 2 * Math.PI;
    a = c * Math.cos(hr);
    b = c * Math.sin(hr);
    return [l, a, b];
  };
  convert.rgb.ansi16 = function (args) {
    var r = args[0];
    var g = args[1];
    var b = args[2];
    var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2];
    value = Math.round(value / 50);
    if (value === 0) {
      return 30;
    }
    var ansi =
      30 +
      ((Math.round(b / 255) << 2) |
        (Math.round(g / 255) << 1) |
        Math.round(r / 255));
    if (value === 2) {
      ansi += 60;
    }
    return ansi;
  };
  convert.hsv.ansi16 = function (args) {
    return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
  };
  convert.rgb.ansi256 = function (args) {
    var r = args[0];
    var g = args[1];
    var b = args[2];
    if (r === g && g === b) {
      if (r < 8) {
        return 16;
      }
      if (r > 248) {
        return 231;
      }
      return Math.round(((r - 8) / 247) * 24) + 232;
    }
    var ansi =
      16 +
      36 * Math.round((r / 255) * 5) +
      6 * Math.round((g / 255) * 5) +
      Math.round((b / 255) * 5);
    return ansi;
  };
  convert.ansi16.rgb = function (args) {
    var color = args % 10;
    if (color === 0 || color === 7) {
      if (args > 50) {
        color += 3.5;
      }
      color = (color / 10.5) * 255;
      return [color, color, color];
    }
    var mult = (~~(args > 50) + 1) * 0.5;
    var r = (color & 1) * mult * 255;
    var g = ((color >> 1) & 1) * mult * 255;
    var b = ((color >> 2) & 1) * mult * 255;
    return [r, g, b];
  };
  convert.ansi256.rgb = function (args) {
    if (args >= 232) {
      var c = (args - 232) * 10 + 8;
      return [c, c, c];
    }
    args -= 16;
    var rem;
    var r = (Math.floor(args / 36) / 5) * 255;
    var g = (Math.floor((rem = args % 36) / 6) / 5) * 255;
    var b = ((rem % 6) / 5) * 255;
    return [r, g, b];
  };
  convert.rgb.hex = function (args) {
    var integer =
      ((Math.round(args[0]) & 255) << 16) +
      ((Math.round(args[1]) & 255) << 8) +
      (Math.round(args[2]) & 255);
    var string = integer.toString(16).toUpperCase();
    return "000000".substring(string.length) + string;
  };
  convert.hex.rgb = function (args) {
    var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
    if (!match) {
      return [0, 0, 0];
    }
    var colorString = match[0];
    if (match[0].length === 3) {
      colorString = colorString
        .split("")
        .map(function (char) {
          return char + char;
        })
        .join("");
    }
    var integer = parseInt(colorString, 16);
    var r = (integer >> 16) & 255;
    var g = (integer >> 8) & 255;
    var b = integer & 255;
    return [r, g, b];
  };
  convert.rgb.hcg = function (rgb) {
    var r = rgb[0] / 255;
    var g = rgb[1] / 255;
    var b = rgb[2] / 255;
    var max = Math.max(Math.max(r, g), b);
    var min = Math.min(Math.min(r, g), b);
    var chroma = max - min;
    var grayscale;
    var hue;
    if (chroma < 1) {
      grayscale = min / (1 - chroma);
    } else {
      grayscale = 0;
    }
    if (chroma <= 0) {
      hue = 0;
    } else if (max === r) {
      hue = ((g - b) / chroma) % 6;
    } else if (max === g) {
      hue = 2 + (b - r) / chroma;
    } else {
      hue = 4 + (r - g) / chroma + 4;
    }
    hue /= 6;
    hue %= 1;
    return [hue * 360, chroma * 100, grayscale * 100];
  };
  convert.hsl.hcg = function (hsl) {
    var s = hsl[1] / 100;
    var l = hsl[2] / 100;
    var c = 1;
    var f = 0;
    if (l < 0.5) {
      c = 2 * s * l;
    } else {
      c = 2 * s * (1 - l);
    }
    if (c < 1) {
      f = (l - 0.5 * c) / (1 - c);
    }
    return [hsl[0], c * 100, f * 100];
  };
  convert.hsv.hcg = function (hsv) {
    var s = hsv[1] / 100;
    var v = hsv[2] / 100;
    var c = s * v;
    var f = 0;
    if (c < 1) {
      f = (v - c) / (1 - c);
    }
    return [hsv[0], c * 100, f * 100];
  };
  convert.hcg.rgb = function (hcg) {
    var h = hcg[0] / 360;
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    if (c === 0) {
      return [g * 255, g * 255, g * 255];
    }
    var pure = [0, 0, 0];
    var hi = (h % 1) * 6;
    var v = hi % 1;
    var w = 1 - v;
    var mg = 0;
    switch (Math.floor(hi)) {
      case 0:
        pure[0] = 1;
        pure[1] = v;
        pure[2] = 0;
        break;
      case 1:
        pure[0] = w;
        pure[1] = 1;
        pure[2] = 0;
        break;
      case 2:
        pure[0] = 0;
        pure[1] = 1;
        pure[2] = v;
        break;
      case 3:
        pure[0] = 0;
        pure[1] = w;
        pure[2] = 1;
        break;
      case 4:
        pure[0] = v;
        pure[1] = 0;
        pure[2] = 1;
        break;
      default:
        pure[0] = 1;
        pure[1] = 0;
        pure[2] = w;
    }
    mg = (1 - c) * g;
    return [
      (c * pure[0] + mg) * 255,
      (c * pure[1] + mg) * 255,
      (c * pure[2] + mg) * 255,
    ];
  };
  convert.hcg.hsv = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var v = c + g * (1 - c);
    var f = 0;
    if (v > 0) {
      f = c / v;
    }
    return [hcg[0], f * 100, v * 100];
  };
  convert.hcg.hsl = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var l = g * (1 - c) + 0.5 * c;
    var s = 0;
    if (l > 0 && l < 0.5) {
      s = c / (2 * l);
    } else if (l >= 0.5 && l < 1) {
      s = c / (2 * (1 - l));
    }
    return [hcg[0], s * 100, l * 100];
  };
  convert.hcg.hwb = function (hcg) {
    var c = hcg[1] / 100;
    var g = hcg[2] / 100;
    var v = c + g * (1 - c);
    return [hcg[0], (v - c) * 100, (1 - v) * 100];
  };
  convert.hwb.hcg = function (hwb) {
    var w = hwb[1] / 100;
    var b = hwb[2] / 100;
    var v = 1 - b;
    var c = v - w;
    var g = 0;
    if (c < 1) {
      g = (v - c) / (1 - c);
    }
    return [hwb[0], c * 100, g * 100];
  };
  convert.apple.rgb = function (apple) {
    return [
      (apple[0] / 65535) * 255,
      (apple[1] / 65535) * 255,
      (apple[2] / 65535) * 255,
    ];
  };
  convert.rgb.apple = function (rgb) {
    return [
      (rgb[0] / 255) * 65535,
      (rgb[1] / 255) * 65535,
      (rgb[2] / 255) * 65535,
    ];
  };
  convert.gray.rgb = function (args) {
    return [
      (args[0] / 100) * 255,
      (args[0] / 100) * 255,
      (args[0] / 100) * 255,
    ];
  };
  convert.gray.hsl = convert.gray.hsv = function (args) {
    return [0, 0, args[0]];
  };
  convert.gray.hwb = function (gray) {
    return [0, 100, gray[0]];
  };
  convert.gray.cmyk = function (gray) {
    return [0, 0, 0, gray[0]];
  };
  convert.gray.lab = function (gray) {
    return [gray[0], 0, 0];
  };
  convert.gray.hex = function (gray) {
    var val = Math.round((gray[0] / 100) * 255) & 255;
    var integer = (val << 16) + (val << 8) + val;
    var string = integer.toString(16).toUpperCase();
    return "000000".substring(string.length) + string;
  };
  convert.rgb.gray = function (rgb) {
    var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
    return [(val / 255) * 100];
  };
  return conversions$5.exports;
}
var route$4;
var hasRequiredRoute$2;
function requireRoute$2() {
  if (hasRequiredRoute$2) return route$4;
  hasRequiredRoute$2 = 1;
  var conversions = requireConversions$2();
  function buildGraph() {
    var graph = {};
    var models = Object.keys(conversions);
    for (var len = models.length, i = 0; i < len; i++) {
      graph[models[i]] = { distance: -1, parent: null };
    }
    return graph;
  }
  function deriveBFS(fromModel) {
    var graph = buildGraph();
    var queue = [fromModel];
    graph[fromModel].distance = 0;
    while (queue.length) {
      var current = queue.pop();
      var adjacents = Object.keys(conversions[current]);
      for (var len = adjacents.length, i = 0; i < len; i++) {
        var adjacent = adjacents[i];
        var node = graph[adjacent];
        if (node.distance === -1) {
          node.distance = graph[current].distance + 1;
          node.parent = current;
          queue.unshift(adjacent);
        }
      }
    }
    return graph;
  }
  function link(from, to) {
    return function (args) {
      return to(from(args));
    };
  }
  function wrapConversion(toModel, graph) {
    var path = [graph[toModel].parent, toModel];
    var fn = conversions[graph[toModel].parent][toModel];
    var cur = graph[toModel].parent;
    while (graph[cur].parent) {
      path.unshift(graph[cur].parent);
      fn = link(conversions[graph[cur].parent][cur], fn);
      cur = graph[cur].parent;
    }
    fn.conversion = path;
    return fn;
  }
  route$4 = function (fromModel) {
    var graph = deriveBFS(fromModel);
    var conversion = {};
    var models = Object.keys(graph);
    for (var len = models.length, i = 0; i < len; i++) {
      var toModel = models[i];
      var node = graph[toModel];
      if (node.parent === null) {
        continue;
      }
      conversion[toModel] = wrapConversion(toModel, graph);
    }
    return conversion;
  };
  return route$4;
}
var colorConvert$3;
var hasRequiredColorConvert$2;
function requireColorConvert$2() {
  if (hasRequiredColorConvert$2) return colorConvert$3;
  hasRequiredColorConvert$2 = 1;
  var conversions = requireConversions$2();
  var route = requireRoute$2();
  var convert = {};
  var models = Object.keys(conversions);
  function wrapRaw(fn) {
    var wrappedFn = function (args) {
      if (args === undefined || args === null) {
        return args;
      }
      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }
      return fn(args);
    };
    if ("conversion" in fn) {
      wrappedFn.conversion = fn.conversion;
    }
    return wrappedFn;
  }
  function wrapRounded(fn) {
    var wrappedFn = function (args) {
      if (args === undefined || args === null) {
        return args;
      }
      if (arguments.length > 1) {
        args = Array.prototype.slice.call(arguments);
      }
      var result = fn(args);
      if (typeof result === "object") {
        for (var len = result.length, i = 0; i < len; i++) {
          result[i] = Math.round(result[i]);
        }
      }
      return result;
    };
    if ("conversion" in fn) {
      wrappedFn.conversion = fn.conversion;
    }
    return wrappedFn;
  }
  models.forEach(function (fromModel) {
    convert[fromModel] = {};
    Object.defineProperty(convert[fromModel], "channels", {
      value: conversions[fromModel].channels,
    });
    Object.defineProperty(convert[fromModel], "labels", {
      value: conversions[fromModel].labels,
    });
    var routes = route(fromModel);
    var routeModels = Object.keys(routes);
    routeModels.forEach(function (toModel) {
      var fn = routes[toModel];
      convert[fromModel][toModel] = wrapRounded(fn);
      convert[fromModel][toModel].raw = wrapRaw(fn);
    });
  });
  colorConvert$3 = convert;
  return colorConvert$3;
}
ansiStyles$4.exports;
var hasRequiredAnsiStyles$1;
function requireAnsiStyles$1() {
  if (hasRequiredAnsiStyles$1) return ansiStyles$4.exports;
  hasRequiredAnsiStyles$1 = 1;
  (function (module) {
    const colorConvert = requireColorConvert$2();
    const wrapAnsi16 = (fn, offset) =>
      function () {
        const code = fn.apply(colorConvert, arguments);
        return `[${code + offset}m`;
      };
    const wrapAnsi256 = (fn, offset) =>
      function () {
        const code = fn.apply(colorConvert, arguments);
        return `[${38 + offset};5;${code}m`;
      };
    const wrapAnsi16m = (fn, offset) =>
      function () {
        const rgb = fn.apply(colorConvert, arguments);
        return `[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
      };
    function assembleStyles() {
      const codes = new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29],
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39],
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49],
        },
      };
      styles.color.grey = styles.color.gray;
      for (const groupName of Object.keys(styles)) {
        const group = styles[groupName];
        for (const styleName of Object.keys(group)) {
          const style = group[styleName];
          styles[styleName] = { open: `[${style[0]}m`, close: `[${style[1]}m` };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false,
        });
        Object.defineProperty(styles, "codes", {
          value: codes,
          enumerable: false,
        });
      }
      const ansi2ansi = (n) => n;
      const rgb2rgb = (r, g, b) => [r, g, b];
      styles.color.close = "[39m";
      styles.bgColor.close = "[49m";
      styles.color.ansi = { ansi: wrapAnsi16(ansi2ansi, 0) };
      styles.color.ansi256 = { ansi256: wrapAnsi256(ansi2ansi, 0) };
      styles.color.ansi16m = { rgb: wrapAnsi16m(rgb2rgb, 0) };
      styles.bgColor.ansi = { ansi: wrapAnsi16(ansi2ansi, 10) };
      styles.bgColor.ansi256 = { ansi256: wrapAnsi256(ansi2ansi, 10) };
      styles.bgColor.ansi16m = { rgb: wrapAnsi16m(rgb2rgb, 10) };
      for (let key of Object.keys(colorConvert)) {
        if (typeof colorConvert[key] !== "object") {
          continue;
        }
        const suite = colorConvert[key];
        if (key === "ansi16") {
          key = "ansi";
        }
        if ("ansi16" in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }
        if ("ansi256" in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }
        if ("rgb" in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }
      return styles;
    }
    Object.defineProperty(module, "exports", {
      enumerable: true,
      get: assembleStyles,
    });
  })(ansiStyles$4);
  return ansiStyles$4.exports;
}
var hasFlag$4;
var hasRequiredHasFlag$2;
function requireHasFlag$2() {
  if (hasRequiredHasFlag$2) return hasFlag$4;
  hasRequiredHasFlag$2 = 1;
  hasFlag$4 = (flag, argv) => {
    argv = argv || process.argv;
    const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
    const pos = argv.indexOf(prefix + flag);
    const terminatorPos = argv.indexOf("--");
    return pos !== -1 && (terminatorPos === -1 ? true : pos < terminatorPos);
  };
  return hasFlag$4;
}
var supportsColor_1$3;
var hasRequiredSupportsColor$2;
function requireSupportsColor$2() {
  if (hasRequiredSupportsColor$2) return supportsColor_1$3;
  hasRequiredSupportsColor$2 = 1;
  const os = require$$0$4;
  const hasFlag = requireHasFlag$2();
  const env = process.env;
  let forceColor;
  if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false")) {
    forceColor = false;
  } else if (
    hasFlag("color") ||
    hasFlag("colors") ||
    hasFlag("color=true") ||
    hasFlag("color=always")
  ) {
    forceColor = true;
  }
  if ("FORCE_COLOR" in env) {
    forceColor =
      env.FORCE_COLOR.length === 0 || parseInt(env.FORCE_COLOR, 10) !== 0;
  }
  function translateLevel(level) {
    if (level === 0) {
      return false;
    }
    return {
      level: level,
      hasBasic: true,
      has256: level >= 2,
      has16m: level >= 3,
    };
  }
  function supportsColor(stream) {
    if (forceColor === false) {
      return 0;
    }
    if (
      hasFlag("color=16m") ||
      hasFlag("color=full") ||
      hasFlag("color=truecolor")
    ) {
      return 3;
    }
    if (hasFlag("color=256")) {
      return 2;
    }
    if (stream && !stream.isTTY && forceColor !== true) {
      return 0;
    }
    const min = forceColor ? 1 : 0;
    if (process.platform === "win32") {
      const osRelease = os.release().split(".");
      if (
        Number(process.versions.node.split(".")[0]) >= 8 &&
        Number(osRelease[0]) >= 10 &&
        Number(osRelease[2]) >= 10586
      ) {
        return Number(osRelease[2]) >= 14931 ? 3 : 2;
      }
      return 1;
    }
    if ("CI" in env) {
      if (
        ["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI"].some(
          (sign) => sign in env,
        ) ||
        env.CI_NAME === "codeship"
      ) {
        return 1;
      }
      return min;
    }
    if ("TEAMCITY_VERSION" in env) {
      return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
    }
    if (env.COLORTERM === "truecolor") {
      return 3;
    }
    if ("TERM_PROGRAM" in env) {
      const version = parseInt(
        (env.TERM_PROGRAM_VERSION || "").split(".")[0],
        10,
      );
      switch (env.TERM_PROGRAM) {
        case "iTerm.app":
          return version >= 3 ? 3 : 2;
        case "Apple_Terminal":
          return 2;
      }
    }
    if (/-256(color)?$/i.test(env.TERM)) {
      return 2;
    }
    if (
      /^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(
        env.TERM,
      )
    ) {
      return 1;
    }
    if ("COLORTERM" in env) {
      return 1;
    }
    if (env.TERM === "dumb") {
      return min;
    }
    return min;
  }
  function getSupportLevel(stream) {
    const level = supportsColor(stream);
    return translateLevel(level);
  }
  supportsColor_1$3 = {
    supportsColor: getSupportLevel,
    stdout: getSupportLevel(process.stdout),
    stderr: getSupportLevel(process.stderr),
  };
  return supportsColor_1$3;
}
var templates$3;
var hasRequiredTemplates$3;
function requireTemplates$3() {
  if (hasRequiredTemplates$3) return templates$3;
  hasRequiredTemplates$3 = 1;
  const TEMPLATE_REGEX =
    /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
  const STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
  const STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
  const ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;
  const ESCAPES = new Map([
    ["n", "\n"],
    ["r", "\r"],
    ["t", "\t"],
    ["b", "\b"],
    ["f", "\f"],
    ["v", "\v"],
    ["0", "\0"],
    ["\\", "\\"],
    ["e", ""],
    ["a", ""],
  ]);
  function unescape(c) {
    if ((c[0] === "u" && c.length === 5) || (c[0] === "x" && c.length === 3)) {
      return String.fromCharCode(parseInt(c.slice(1), 16));
    }
    return ESCAPES.get(c) || c;
  }
  function parseArguments(name, args) {
    const results = [];
    const chunks = args.trim().split(/\s*,\s*/g);
    let matches;
    for (const chunk of chunks) {
      if (!isNaN(chunk)) {
        results.push(Number(chunk));
      } else if ((matches = chunk.match(STRING_REGEX))) {
        results.push(
          matches[2].replace(ESCAPE_REGEX, (m, escape, chr) =>
            escape ? unescape(escape) : chr,
          ),
        );
      } else {
        throw new Error(
          `Invalid Chalk template style argument: ${chunk} (in style '${name}')`,
        );
      }
    }
    return results;
  }
  function parseStyle(style) {
    STYLE_REGEX.lastIndex = 0;
    const results = [];
    let matches;
    while ((matches = STYLE_REGEX.exec(style)) !== null) {
      const name = matches[1];
      if (matches[2]) {
        const args = parseArguments(name, matches[2]);
        results.push([name].concat(args));
      } else {
        results.push([name]);
      }
    }
    return results;
  }
  function buildStyle(chalk, styles) {
    const enabled = {};
    for (const layer of styles) {
      for (const style of layer.styles) {
        enabled[style[0]] = layer.inverse ? null : style.slice(1);
      }
    }
    let current = chalk;
    for (const styleName of Object.keys(enabled)) {
      if (Array.isArray(enabled[styleName])) {
        if (!(styleName in current)) {
          throw new Error(`Unknown Chalk style: ${styleName}`);
        }
        if (enabled[styleName].length > 0) {
          current = current[styleName].apply(current, enabled[styleName]);
        } else {
          current = current[styleName];
        }
      }
    }
    return current;
  }
  templates$3 = (chalk, tmp) => {
    const styles = [];
    const chunks = [];
    let chunk = [];
    tmp.replace(TEMPLATE_REGEX, (m, escapeChar, inverse, style, close, chr) => {
      if (escapeChar) {
        chunk.push(unescape(escapeChar));
      } else if (style) {
        const str = chunk.join("");
        chunk = [];
        chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
        styles.push({ inverse: inverse, styles: parseStyle(style) });
      } else if (close) {
        if (styles.length === 0) {
          throw new Error("Found extraneous } in Chalk template literal");
        }
        chunks.push(buildStyle(chalk, styles)(chunk.join("")));
        chunk = [];
        styles.pop();
      } else {
        chunk.push(chr);
      }
    });
    chunks.push(chunk.join(""));
    if (styles.length > 0) {
      const errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? "" : "s"} (\`}\`)`;
      throw new Error(errMsg);
    }
    return chunks.join("");
  };
  return templates$3;
}
var hasRequiredChalk$2;
function requireChalk$2() {
  if (hasRequiredChalk$2) return chalk$3.exports;
  hasRequiredChalk$2 = 1;
  (function (module) {
    const escapeStringRegexp = requireEscapeStringRegexp$2();
    const ansiStyles = requireAnsiStyles$1();
    const stdoutColor = requireSupportsColor$2().stdout;
    const template = requireTemplates$3();
    const isSimpleWindowsTerm =
      process.platform === "win32" &&
      !(process.env.TERM || "").toLowerCase().startsWith("xterm");
    const levelMapping = ["ansi", "ansi", "ansi256", "ansi16m"];
    const skipModels = new Set(["gray"]);
    const styles = Object.create(null);
    function applyOptions(obj, options) {
      options = options || {};
      const scLevel = stdoutColor ? stdoutColor.level : 0;
      obj.level = options.level === undefined ? scLevel : options.level;
      obj.enabled = "enabled" in options ? options.enabled : obj.level > 0;
    }
    function Chalk(options) {
      if (!this || !(this instanceof Chalk) || this.template) {
        const chalk = {};
        applyOptions(chalk, options);
        chalk.template = function () {
          const args = [].slice.call(arguments);
          return chalkTag.apply(null, [chalk.template].concat(args));
        };
        Object.setPrototypeOf(chalk, Chalk.prototype);
        Object.setPrototypeOf(chalk.template, chalk);
        chalk.template.constructor = Chalk;
        return chalk.template;
      }
      applyOptions(this, options);
    }
    if (isSimpleWindowsTerm) {
      ansiStyles.blue.open = "[94m";
    }
    for (const key of Object.keys(ansiStyles)) {
      ansiStyles[key].closeRe = new RegExp(
        escapeStringRegexp(ansiStyles[key].close),
        "g",
      );
      styles[key] = {
        get() {
          const codes = ansiStyles[key];
          return build.call(
            this,
            this._styles ? this._styles.concat(codes) : [codes],
            this._empty,
            key,
          );
        },
      };
    }
    styles.visible = {
      get() {
        return build.call(this, this._styles || [], true, "visible");
      },
    };
    ansiStyles.color.closeRe = new RegExp(
      escapeStringRegexp(ansiStyles.color.close),
      "g",
    );
    for (const model of Object.keys(ansiStyles.color.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      styles[model] = {
        get() {
          const level = this.level;
          return function () {
            const open = ansiStyles.color[levelMapping[level]][model].apply(
              null,
              arguments,
            );
            const codes = {
              open: open,
              close: ansiStyles.color.close,
              closeRe: ansiStyles.color.closeRe,
            };
            return build.call(
              this,
              this._styles ? this._styles.concat(codes) : [codes],
              this._empty,
              model,
            );
          };
        },
      };
    }
    ansiStyles.bgColor.closeRe = new RegExp(
      escapeStringRegexp(ansiStyles.bgColor.close),
      "g",
    );
    for (const model of Object.keys(ansiStyles.bgColor.ansi)) {
      if (skipModels.has(model)) {
        continue;
      }
      const bgModel = "bg" + model[0].toUpperCase() + model.slice(1);
      styles[bgModel] = {
        get() {
          const level = this.level;
          return function () {
            const open = ansiStyles.bgColor[levelMapping[level]][model].apply(
              null,
              arguments,
            );
            const codes = {
              open: open,
              close: ansiStyles.bgColor.close,
              closeRe: ansiStyles.bgColor.closeRe,
            };
            return build.call(
              this,
              this._styles ? this._styles.concat(codes) : [codes],
              this._empty,
              model,
            );
          };
        },
      };
    }
    const proto = Object.defineProperties(() => {}, styles);
    function build(_styles, _empty, key) {
      const builder = function () {
        return applyStyle.apply(builder, arguments);
      };
      builder._styles = _styles;
      builder._empty = _empty;
      const self = this;
      Object.defineProperty(builder, "level", {
        enumerable: true,
        get() {
          return self.level;
        },
        set(level) {
          self.level = level;
        },
      });
      Object.defineProperty(builder, "enabled", {
        enumerable: true,
        get() {
          return self.enabled;
        },
        set(enabled) {
          self.enabled = enabled;
        },
      });
      builder.hasGrey = this.hasGrey || key === "gray" || key === "grey";
      builder.__proto__ = proto;
      return builder;
    }
    function applyStyle() {
      const args = arguments;
      const argsLen = args.length;
      let str = String(arguments[0]);
      if (argsLen === 0) {
        return "";
      }
      if (argsLen > 1) {
        for (let a = 1; a < argsLen; a++) {
          str += " " + args[a];
        }
      }
      if (!this.enabled || this.level <= 0 || !str) {
        return this._empty ? "" : str;
      }
      const originalDim = ansiStyles.dim.open;
      if (isSimpleWindowsTerm && this.hasGrey) {
        ansiStyles.dim.open = "";
      }
      for (const code of this._styles.slice().reverse()) {
        str = code.open + str.replace(code.closeRe, code.open) + code.close;
        str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
      }
      ansiStyles.dim.open = originalDim;
      return str;
    }
    function chalkTag(chalk, strings) {
      if (!Array.isArray(strings)) {
        return [].slice.call(arguments, 1).join(" ");
      }
      const args = [].slice.call(arguments, 2);
      const parts = [strings.raw[0]];
      for (let i = 1; i < strings.length; i++) {
        parts.push(String(args[i - 1]).replace(/[{}\\]/g, "\\$&"));
        parts.push(String(strings.raw[i]));
      }
      return template(chalk, parts.join(""));
    }
    Object.defineProperties(Chalk.prototype, styles);
    module.exports = Chalk();
    module.exports.supportsColor = stdoutColor;
    module.exports.default = module.exports;
  })(chalk$3);
  return chalk$3.exports;
}
var hasRequiredLib$m;
function requireLib$m() {
  if (hasRequiredLib$m) return lib$m;
  hasRequiredLib$m = 1;
  Object.defineProperty(lib$m, "__esModule", { value: true });
  lib$m.default = highlight;
  lib$m.shouldHighlight = shouldHighlight;
  var _jsTokens = requireJsTokens();
  var _helperValidatorIdentifier = requireLib$n();
  var _picocolors = _interopRequireWildcard(requirePicocolors(), true);
  function _getRequireWildcardCache(e) {
    if ("function" != typeof WeakMap) return null;
    var r = new WeakMap(),
      t = new WeakMap();
    return (_getRequireWildcardCache = function (e) {
      return e ? t : r;
    })(e);
  }
  function _interopRequireWildcard(e, r) {
    if (!r && e && e.__esModule) return e;
    if (null === e || ("object" != typeof e && "function" != typeof e))
      return { default: e };
    var t = _getRequireWildcardCache(r);
    if (t && t.has(e)) return t.get(e);
    var n = { __proto__: null },
      a = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for (var u in e)
      if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
        var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
        i && (i.get || i.set) ? Object.defineProperty(n, u, i) : (n[u] = e[u]);
      }
    return (n.default = e), t && t.set(e, n), n;
  }
  const colors =
    typeof process === "object" &&
    (process.env.FORCE_COLOR === "0" || process.env.FORCE_COLOR === "false")
      ? (0, _picocolors.createColors)(false)
      : _picocolors.default;
  const compose = (f, g) => (v) => f(g(v));
  const sometimesKeywords = new Set([
    "as",
    "async",
    "from",
    "get",
    "of",
    "set",
  ]);
  function getDefs(colors) {
    return {
      keyword: colors.cyan,
      capitalized: colors.yellow,
      jsxIdentifier: colors.yellow,
      punctuator: colors.yellow,
      number: colors.magenta,
      string: colors.green,
      regex: colors.magenta,
      comment: colors.gray,
      invalid: compose(compose(colors.white, colors.bgRed), colors.bold),
    };
  }
  const NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
  const BRACKET = /^[()[\]{}]$/;
  let tokenize;
  {
    const JSX_TAG = /^[a-z][\w-]*$/i;
    const getTokenType = function (token, offset, text) {
      if (token.type === "name") {
        if (
          (0, _helperValidatorIdentifier.isKeyword)(token.value) ||
          (0, _helperValidatorIdentifier.isStrictReservedWord)(
            token.value,
            true,
          ) ||
          sometimesKeywords.has(token.value)
        ) {
          return "keyword";
        }
        if (
          JSX_TAG.test(token.value) &&
          (text[offset - 1] === "<" || text.slice(offset - 2, offset) == "</")
        ) {
          return "jsxIdentifier";
        }
        if (token.value[0] !== token.value[0].toLowerCase()) {
          return "capitalized";
        }
      }
      if (token.type === "punctuator" && BRACKET.test(token.value)) {
        return "bracket";
      }
      if (
        token.type === "invalid" &&
        (token.value === "@" || token.value === "#")
      ) {
        return "punctuator";
      }
      return token.type;
    };
    tokenize = function* (text) {
      let match;
      while ((match = _jsTokens.default.exec(text))) {
        const token = _jsTokens.matchToToken(match);
        yield {
          type: getTokenType(token, match.index, text),
          value: token.value,
        };
      }
    };
  }
  function highlightTokens(defs, text) {
    let highlighted = "";
    for (const { type: type, value: value } of tokenize(text)) {
      const colorize = defs[type];
      if (colorize) {
        highlighted += value
          .split(NEWLINE)
          .map((str) => colorize(str))
          .join("\n");
      } else {
        highlighted += value;
      }
    }
    return highlighted;
  }
  function shouldHighlight(options) {
    return colors.isColorSupported || options.forceColor;
  }
  let pcWithForcedColor = undefined;
  function getColors(forceColor) {
    if (forceColor) {
      var _pcWithForcedColor;
      (_pcWithForcedColor = pcWithForcedColor) != null
        ? _pcWithForcedColor
        : (pcWithForcedColor = (0, _picocolors.createColors)(true));
      return pcWithForcedColor;
    }
    return colors;
  }
  function highlight(code, options = {}) {
    if (code !== "" && shouldHighlight(options)) {
      const defs = getDefs(getColors(options.forceColor));
      return highlightTokens(defs, code);
    } else {
      return code;
    }
  }
  {
    let chalk, chalkWithForcedColor;
    lib$m.getChalk = ({ forceColor: forceColor }) => {
      var _chalk;
      (_chalk = chalk) != null ? _chalk : (chalk = requireChalk$2());
      if (forceColor) {
        var _chalkWithForcedColor;
        (_chalkWithForcedColor = chalkWithForcedColor) != null
          ? _chalkWithForcedColor
          : (chalkWithForcedColor = new chalk.constructor({
              enabled: true,
              level: 1,
            }));
        return chalkWithForcedColor;
      }
      return chalk;
    };
  }
  return lib$m;
}
var hasRequiredLib$l;
function requireLib$l() {
  if (hasRequiredLib$l) return lib$n;
  hasRequiredLib$l = 1;
  Object.defineProperty(lib$n, "__esModule", { value: true });
  lib$n.codeFrameColumns = codeFrameColumns;
  lib$n.default = _default;
  var _highlight = requireLib$m();
  var _picocolors = _interopRequireWildcard(requirePicocolors(), true);
  function _getRequireWildcardCache(e) {
    if ("function" != typeof WeakMap) return null;
    var r = new WeakMap(),
      t = new WeakMap();
    return (_getRequireWildcardCache = function (e) {
      return e ? t : r;
    })(e);
  }
  function _interopRequireWildcard(e, r) {
    if (!r && e && e.__esModule) return e;
    if (null === e || ("object" != typeof e && "function" != typeof e))
      return { default: e };
    var t = _getRequireWildcardCache(r);
    if (t && t.has(e)) return t.get(e);
    var n = { __proto__: null },
      a = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for (var u in e)
      if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
        var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
        i && (i.get || i.set) ? Object.defineProperty(n, u, i) : (n[u] = e[u]);
      }
    return (n.default = e), t && t.set(e, n), n;
  }
  const colors =
    typeof process === "object" &&
    (process.env.FORCE_COLOR === "0" || process.env.FORCE_COLOR === "false")
      ? (0, _picocolors.createColors)(false)
      : _picocolors.default;
  const compose = (f, g) => (v) => f(g(v));
  let pcWithForcedColor = undefined;
  function getColors(forceColor) {
    if (forceColor) {
      var _pcWithForcedColor;
      (_pcWithForcedColor = pcWithForcedColor) != null
        ? _pcWithForcedColor
        : (pcWithForcedColor = (0, _picocolors.createColors)(true));
      return pcWithForcedColor;
    }
    return colors;
  }
  let deprecationWarningShown = false;
  function getDefs(colors) {
    return {
      gutter: colors.gray,
      marker: compose(colors.red, colors.bold),
      message: compose(colors.red, colors.bold),
    };
  }
  const NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
  function getMarkerLines(loc, source, opts) {
    const startLoc = Object.assign({ column: 0, line: -1 }, loc.start);
    const endLoc = Object.assign({}, startLoc, loc.end);
    const { linesAbove: linesAbove = 2, linesBelow: linesBelow = 3 } =
      opts || {};
    const startLine = startLoc.line;
    const startColumn = startLoc.column;
    const endLine = endLoc.line;
    const endColumn = endLoc.column;
    let start = Math.max(startLine - (linesAbove + 1), 0);
    let end = Math.min(source.length, endLine + linesBelow);
    if (startLine === -1) {
      start = 0;
    }
    if (endLine === -1) {
      end = source.length;
    }
    const lineDiff = endLine - startLine;
    const markerLines = {};
    if (lineDiff) {
      for (let i = 0; i <= lineDiff; i++) {
        const lineNumber = i + startLine;
        if (!startColumn) {
          markerLines[lineNumber] = true;
        } else if (i === 0) {
          const sourceLength = source[lineNumber - 1].length;
          markerLines[lineNumber] = [
            startColumn,
            sourceLength - startColumn + 1,
          ];
        } else if (i === lineDiff) {
          markerLines[lineNumber] = [0, endColumn];
        } else {
          const sourceLength = source[lineNumber - i].length;
          markerLines[lineNumber] = [0, sourceLength];
        }
      }
    } else {
      if (startColumn === endColumn) {
        if (startColumn) {
          markerLines[startLine] = [startColumn, 0];
        } else {
          markerLines[startLine] = true;
        }
      } else {
        markerLines[startLine] = [startColumn, endColumn - startColumn];
      }
    }
    return { start: start, end: end, markerLines: markerLines };
  }
  function codeFrameColumns(rawLines, loc, opts = {}) {
    const highlighted =
      (opts.highlightCode || opts.forceColor) &&
      (0, _highlight.shouldHighlight)(opts);
    const colors = getColors(opts.forceColor);
    const defs = getDefs(colors);
    const maybeHighlight = (fmt, string) =>
      highlighted ? fmt(string) : string;
    const lines = rawLines.split(NEWLINE);
    const {
      start: start,
      end: end,
      markerLines: markerLines,
    } = getMarkerLines(loc, lines, opts);
    const hasColumns = loc.start && typeof loc.start.column === "number";
    const numberMaxWidth = String(end).length;
    const highlightedLines = highlighted
      ? (0, _highlight.default)(rawLines, opts)
      : rawLines;
    let frame = highlightedLines
      .split(NEWLINE, end)
      .slice(start, end)
      .map((line, index) => {
        const number = start + 1 + index;
        const paddedNumber = ` ${number}`.slice(-numberMaxWidth);
        const gutter = ` ${paddedNumber} |`;
        const hasMarker = markerLines[number];
        const lastMarkerLine = !markerLines[number + 1];
        if (hasMarker) {
          let markerLine = "";
          if (Array.isArray(hasMarker)) {
            const markerSpacing = line
              .slice(0, Math.max(hasMarker[0] - 1, 0))
              .replace(/[^\t]/g, " ");
            const numberOfMarkers = hasMarker[1] || 1;
            markerLine = [
              "\n ",
              maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")),
              " ",
              markerSpacing,
              maybeHighlight(defs.marker, "^").repeat(numberOfMarkers),
            ].join("");
            if (lastMarkerLine && opts.message) {
              markerLine += " " + maybeHighlight(defs.message, opts.message);
            }
          }
          return [
            maybeHighlight(defs.marker, ">"),
            maybeHighlight(defs.gutter, gutter),
            line.length > 0 ? ` ${line}` : "",
            markerLine,
          ].join("");
        } else {
          return ` ${maybeHighlight(defs.gutter, gutter)}${line.length > 0 ? ` ${line}` : ""}`;
        }
      })
      .join("\n");
    if (opts.message && !hasColumns) {
      frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}\n${frame}`;
    }
    if (highlighted) {
      return colors.reset(frame);
    } else {
      return frame;
    }
  }
  function _default(rawLines, lineNumber, colNumber, opts = {}) {
    if (!deprecationWarningShown) {
      deprecationWarningShown = true;
      const message =
        "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";
      if (process.emitWarning) {
        process.emitWarning(message, "DeprecationWarning");
      } else {
        const deprecationError = new Error(message);
        deprecationError.name = "DeprecationWarning";
        console.warn(new Error(message));
      }
    }
    colNumber = Math.max(colNumber, 0);
    const location = { start: { column: colNumber, line: lineNumber } };
    return codeFrameColumns(rawLines, location, opts);
  }
  return lib$n;
}
var lib$k = {};
var hasRequiredLib$k;
function requireLib$k() {
  if (hasRequiredLib$k) return lib$k;
  hasRequiredLib$k = 1;
  Object.defineProperty(lib$k, "__esModule", { value: true });
  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }
    return target;
  }
  class Position {
    constructor(line, col, index) {
      this.line = void 0;
      this.column = void 0;
      this.index = void 0;
      this.line = line;
      this.column = col;
      this.index = index;
    }
  }
  class SourceLocation {
    constructor(start, end) {
      this.start = void 0;
      this.end = void 0;
      this.filename = void 0;
      this.identifierName = void 0;
      this.start = start;
      this.end = end;
    }
  }
  function createPositionWithColumnOffset(position, columnOffset) {
    const { line: line, column: column, index: index } = position;
    return new Position(line, column + columnOffset, index + columnOffset);
  }
  const code = "BABEL_PARSER_SOURCETYPE_MODULE_REQUIRED";
  var ModuleErrors = {
    ImportMetaOutsideModule: {
      message: `import.meta may appear only with 'sourceType: "module"'`,
      code: code,
    },
    ImportOutsideModule: {
      message: `'import' and 'export' may appear only with 'sourceType: "module"'`,
      code: code,
    },
  };
  const NodeDescriptions = {
    ArrayPattern: "array destructuring pattern",
    AssignmentExpression: "assignment expression",
    AssignmentPattern: "assignment expression",
    ArrowFunctionExpression: "arrow function expression",
    ConditionalExpression: "conditional expression",
    CatchClause: "catch clause",
    ForOfStatement: "for-of statement",
    ForInStatement: "for-in statement",
    ForStatement: "for-loop",
    FormalParameters: "function parameter list",
    Identifier: "identifier",
    ImportSpecifier: "import specifier",
    ImportDefaultSpecifier: "import default specifier",
    ImportNamespaceSpecifier: "import namespace specifier",
    ObjectPattern: "object destructuring pattern",
    ParenthesizedExpression: "parenthesized expression",
    RestElement: "rest element",
    UpdateExpression: { true: "prefix operation", false: "postfix operation" },
    VariableDeclarator: "variable declaration",
    YieldExpression: "yield expression",
  };
  const toNodeDescription = ({ type: type, prefix: prefix }) =>
    type === "UpdateExpression"
      ? NodeDescriptions.UpdateExpression[String(prefix)]
      : NodeDescriptions[type];
  var StandardErrors = {
    AccessorIsGenerator: ({ kind: kind }) =>
      `A ${kind}ter cannot be a generator.`,
    ArgumentsInClass:
      "'arguments' is only allowed in functions and class methods.",
    AsyncFunctionInSingleStatementContext:
      "Async functions can only be declared at the top level or inside a block.",
    AwaitBindingIdentifier:
      "Can not use 'await' as identifier inside an async function.",
    AwaitBindingIdentifierInStaticBlock:
      "Can not use 'await' as identifier inside a static block.",
    AwaitExpressionFormalParameter:
      "'await' is not allowed in async function parameters.",
    AwaitUsingNotInAsyncContext:
      "'await using' is only allowed within async functions and at the top levels of modules.",
    AwaitNotInAsyncContext:
      "'await' is only allowed within async functions and at the top levels of modules.",
    AwaitNotInAsyncFunction: "'await' is only allowed within async functions.",
    BadGetterArity: "A 'get' accessor must not have any formal parameters.",
    BadSetterArity: "A 'set' accessor must have exactly one formal parameter.",
    BadSetterRestParameter:
      "A 'set' accessor function argument must not be a rest parameter.",
    ConstructorClassField: "Classes may not have a field named 'constructor'.",
    ConstructorClassPrivateField:
      "Classes may not have a private field named '#constructor'.",
    ConstructorIsAccessor: "Class constructor may not be an accessor.",
    ConstructorIsAsync: "Constructor can't be an async function.",
    ConstructorIsGenerator: "Constructor can't be a generator.",
    DeclarationMissingInitializer: ({ kind: kind }) =>
      `Missing initializer in ${kind} declaration.`,
    DecoratorArgumentsOutsideParentheses:
      "Decorator arguments must be moved inside parentheses: use '@(decorator(args))' instead of '@(decorator)(args)'.",
    DecoratorBeforeExport:
      "Decorators must be placed *before* the 'export' keyword. Remove the 'decoratorsBeforeExport: true' option to use the 'export @decorator class {}' syntax.",
    DecoratorsBeforeAfterExport:
      "Decorators can be placed *either* before or after the 'export' keyword, but not in both locations at the same time.",
    DecoratorConstructor:
      "Decorators can't be used with a constructor. Did you mean '@dec class { ... }'?",
    DecoratorExportClass:
      "Decorators must be placed *after* the 'export' keyword. Remove the 'decoratorsBeforeExport: false' option to use the '@decorator export class {}' syntax.",
    DecoratorSemicolon: "Decorators must not be followed by a semicolon.",
    DecoratorStaticBlock: "Decorators can't be used with a static block.",
    DeferImportRequiresNamespace:
      'Only `import defer * as x from "./module"` is valid.',
    DeletePrivateField: "Deleting a private field is not allowed.",
    DestructureNamedImport:
      "ES2015 named imports do not destructure. Use another statement for destructuring after the import.",
    DuplicateConstructor: "Duplicate constructor in the same class.",
    DuplicateDefaultExport: "Only one default export allowed per module.",
    DuplicateExport: ({ exportName: exportName }) =>
      `\`${exportName}\` has already been exported. Exported identifiers must be unique.`,
    DuplicateProto: "Redefinition of __proto__ property.",
    DuplicateRegExpFlags: "Duplicate regular expression flag.",
    DynamicImportPhaseRequiresImportExpressions: ({ phase: phase }) =>
      `'import.${phase}(...)' can only be parsed when using the 'createImportExpressions' option.`,
    ElementAfterRest: "Rest element must be last element.",
    EscapedCharNotAnIdentifier: "Invalid Unicode escape.",
    ExportBindingIsString: ({ localName: localName, exportName: exportName }) =>
      `A string literal cannot be used as an exported binding without \`from\`.\n- Did you mean \`export { '${localName}' as '${exportName}' } from 'some-module'\`?`,
    ExportDefaultFromAsIdentifier:
      "'from' is not allowed as an identifier after 'export default'.",
    ForInOfLoopInitializer: ({ type: type }) =>
      `'${type === "ForInStatement" ? "for-in" : "for-of"}' loop variable declaration may not have an initializer.`,
    ForInUsing: "For-in loop may not start with 'using' declaration.",
    ForOfAsync: "The left-hand side of a for-of loop may not be 'async'.",
    ForOfLet: "The left-hand side of a for-of loop may not start with 'let'.",
    GeneratorInSingleStatementContext:
      "Generators can only be declared at the top level or inside a block.",
    IllegalBreakContinue: ({ type: type }) =>
      `Unsyntactic ${type === "BreakStatement" ? "break" : "continue"}.`,
    IllegalLanguageModeDirective:
      "Illegal 'use strict' directive in function with non-simple parameter list.",
    IllegalReturn: "'return' outside of function.",
    ImportAttributesUseAssert:
      "The `assert` keyword in import attributes is deprecated and it has been replaced by the `with` keyword. You can enable the `deprecatedAssertSyntax: true` option in the import attributes plugin to suppress this error.",
    ImportBindingIsString: ({ importName: importName }) =>
      `A string literal cannot be used as an imported binding.\n- Did you mean \`import { "${importName}" as foo }\`?`,
    ImportCallArgumentTrailingComma:
      "Trailing comma is disallowed inside import(...) arguments.",
    ImportCallArity: ({ maxArgumentCount: maxArgumentCount }) =>
      `\`import()\` requires exactly ${maxArgumentCount === 1 ? "one argument" : "one or two arguments"}.`,
    ImportCallNotNewExpression: "Cannot use new with import(...).",
    ImportCallSpreadArgument: "`...` is not allowed in `import()`.",
    ImportJSONBindingNotDefault:
      "A JSON module can only be imported with `default`.",
    ImportReflectionHasAssertion: "`import module x` cannot have assertions.",
    ImportReflectionNotBinding:
      'Only `import module x from "./module"` is valid.',
    IncompatibleRegExpUVFlags:
      "The 'u' and 'v' regular expression flags cannot be enabled at the same time.",
    InvalidBigIntLiteral: "Invalid BigIntLiteral.",
    InvalidCodePoint: "Code point out of bounds.",
    InvalidCoverInitializedName: "Invalid shorthand property initializer.",
    InvalidDecimal: "Invalid decimal.",
    InvalidDigit: ({ radix: radix }) => `Expected number in radix ${radix}.`,
    InvalidEscapeSequence: "Bad character escape sequence.",
    InvalidEscapeSequenceTemplate: "Invalid escape sequence in template.",
    InvalidEscapedReservedWord: ({ reservedWord: reservedWord }) =>
      `Escape sequence in keyword ${reservedWord}.`,
    InvalidIdentifier: ({ identifierName: identifierName }) =>
      `Invalid identifier ${identifierName}.`,
    InvalidLhs: ({ ancestor: ancestor }) =>
      `Invalid left-hand side in ${toNodeDescription(ancestor)}.`,
    InvalidLhsBinding: ({ ancestor: ancestor }) =>
      `Binding invalid left-hand side in ${toNodeDescription(ancestor)}.`,
    InvalidLhsOptionalChaining: ({ ancestor: ancestor }) =>
      `Invalid optional chaining in the left-hand side of ${toNodeDescription(ancestor)}.`,
    InvalidNumber: "Invalid number.",
    InvalidOrMissingExponent:
      "Floating-point numbers require a valid exponent after the 'e'.",
    InvalidOrUnexpectedToken: ({ unexpected: unexpected }) =>
      `Unexpected character '${unexpected}'.`,
    InvalidParenthesizedAssignment: "Invalid parenthesized assignment pattern.",
    InvalidPrivateFieldResolution: ({ identifierName: identifierName }) =>
      `Private name #${identifierName} is not defined.`,
    InvalidPropertyBindingPattern: "Binding member expression.",
    InvalidRecordProperty:
      "Only properties and spread elements are allowed in record definitions.",
    InvalidRestAssignmentPattern: "Invalid rest operator's argument.",
    LabelRedeclaration: ({ labelName: labelName }) =>
      `Label '${labelName}' is already declared.`,
    LetInLexicalBinding: "'let' is disallowed as a lexically bound name.",
    LineTerminatorBeforeArrow: "No line break is allowed before '=>'.",
    MalformedRegExpFlags: "Invalid regular expression flag.",
    MissingClassName: "A class name is required.",
    MissingEqInAssignment:
      "Only '=' operator can be used for specifying default value.",
    MissingSemicolon: "Missing semicolon.",
    MissingPlugin: ({ missingPlugin: missingPlugin }) =>
      `This experimental syntax requires enabling the parser plugin: ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
    MissingOneOfPlugins: ({ missingPlugin: missingPlugin }) =>
      `This experimental syntax requires enabling one of the following parser plugin(s): ${missingPlugin.map((name) => JSON.stringify(name)).join(", ")}.`,
    MissingUnicodeEscape: "Expecting Unicode escape sequence \\uXXXX.",
    MixingCoalesceWithLogical:
      "Nullish coalescing operator(??) requires parens when mixing with logical operators.",
    ModuleAttributeDifferentFromType:
      "The only accepted module attribute is `type`.",
    ModuleAttributeInvalidValue:
      "Only string literals are allowed as module attribute values.",
    ModuleAttributesWithDuplicateKeys: ({ key: key }) =>
      `Duplicate key "${key}" is not allowed in module attributes.`,
    ModuleExportNameHasLoneSurrogate: ({
      surrogateCharCode: surrogateCharCode,
    }) =>
      `An export name cannot include a lone surrogate, found '\\u${surrogateCharCode.toString(16)}'.`,
    ModuleExportUndefined: ({ localName: localName }) =>
      `Export '${localName}' is not defined.`,
    MultipleDefaultsInSwitch: "Multiple default clauses.",
    NewlineAfterThrow: "Illegal newline after throw.",
    NoCatchOrFinally: "Missing catch or finally clause.",
    NumberIdentifier: "Identifier directly after number.",
    NumericSeparatorInEscapeSequence:
      "Numeric separators are not allowed inside unicode escape sequences or hex escape sequences.",
    ObsoleteAwaitStar:
      "'await*' has been removed from the async functions proposal. Use Promise.all() instead.",
    OptionalChainingNoNew:
      "Constructors in/after an Optional Chain are not allowed.",
    OptionalChainingNoTemplate:
      "Tagged Template Literals are not allowed in optionalChain.",
    OverrideOnConstructor:
      "'override' modifier cannot appear on a constructor declaration.",
    ParamDupe: "Argument name clash.",
    PatternHasAccessor: "Object pattern can't contain getter or setter.",
    PatternHasMethod: "Object pattern can't contain methods.",
    PrivateInExpectedIn: ({ identifierName: identifierName }) =>
      `Private names are only allowed in property accesses (\`obj.#${identifierName}\`) or in \`in\` expressions (\`#${identifierName} in obj\`).`,
    PrivateNameRedeclaration: ({ identifierName: identifierName }) =>
      `Duplicate private name #${identifierName}.`,
    RecordExpressionBarIncorrectEndSyntaxType:
      "Record expressions ending with '|}' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    RecordExpressionBarIncorrectStartSyntaxType:
      "Record expressions starting with '{|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    RecordExpressionHashIncorrectStartSyntaxType:
      "Record expressions starting with '#{' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
    RecordNoProto: "'__proto__' is not allowed in Record expressions.",
    RestTrailingComma: "Unexpected trailing comma after rest element.",
    SloppyFunction:
      "In non-strict mode code, functions can only be declared at top level or inside a block.",
    SloppyFunctionAnnexB:
      "In non-strict mode code, functions can only be declared at top level, inside a block, or as the body of an if statement.",
    SourcePhaseImportRequiresDefault:
      'Only `import source x from "./module"` is valid.',
    StaticPrototype: "Classes may not have static property named prototype.",
    SuperNotAllowed:
      "`super()` is only valid inside a class constructor of a subclass. Maybe a typo in the method name ('constructor') or not extending another class?",
    SuperPrivateField: "Private fields can't be accessed on super.",
    TrailingDecorator: "Decorators must be attached to a class element.",
    TupleExpressionBarIncorrectEndSyntaxType:
      "Tuple expressions ending with '|]' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    TupleExpressionBarIncorrectStartSyntaxType:
      "Tuple expressions starting with '[|' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'bar'.",
    TupleExpressionHashIncorrectStartSyntaxType:
      "Tuple expressions starting with '#[' are only allowed when the 'syntaxType' option of the 'recordAndTuple' plugin is set to 'hash'.",
    UnexpectedArgumentPlaceholder: "Unexpected argument placeholder.",
    UnexpectedAwaitAfterPipelineBody:
      'Unexpected "await" after pipeline body; await must have parentheses in minimal proposal.',
    UnexpectedDigitAfterHash: "Unexpected digit after hash token.",
    UnexpectedImportExport:
      "'import' and 'export' may only appear at the top level.",
    UnexpectedKeyword: ({ keyword: keyword }) =>
      `Unexpected keyword '${keyword}'.`,
    UnexpectedLeadingDecorator:
      "Leading decorators must be attached to a class declaration.",
    UnexpectedLexicalDeclaration:
      "Lexical declaration cannot appear in a single-statement context.",
    UnexpectedNewTarget:
      "`new.target` can only be used in functions or class properties.",
    UnexpectedNumericSeparator:
      "A numeric separator is only allowed between two digits.",
    UnexpectedPrivateField: "Unexpected private name.",
    UnexpectedReservedWord: ({ reservedWord: reservedWord }) =>
      `Unexpected reserved word '${reservedWord}'.`,
    UnexpectedSuper: "'super' is only allowed in object methods and classes.",
    UnexpectedToken: ({ expected: expected, unexpected: unexpected }) =>
      `Unexpected token${unexpected ? ` '${unexpected}'.` : ""}${expected ? `, expected "${expected}"` : ""}`,
    UnexpectedTokenUnaryExponentiation:
      "Illegal expression. Wrap left hand side or entire exponentiation in parentheses.",
    UnexpectedUsingDeclaration:
      "Using declaration cannot appear in the top level when source type is `script`.",
    UnsupportedBind: "Binding should be performed on object property.",
    UnsupportedDecoratorExport:
      "A decorated export must export a class declaration.",
    UnsupportedDefaultExport:
      "Only expressions, functions or classes are allowed as the `default` export.",
    UnsupportedImport:
      "`import` can only be used in `import()` or `import.meta`.",
    UnsupportedMetaProperty: ({
      target: target,
      onlyValidPropertyName: onlyValidPropertyName,
    }) =>
      `The only valid meta property for ${target} is ${target}.${onlyValidPropertyName}.`,
    UnsupportedParameterDecorator:
      "Decorators cannot be used to decorate parameters.",
    UnsupportedPropertyDecorator:
      "Decorators cannot be used to decorate object literal properties.",
    UnsupportedSuper:
      "'super' can only be used with function calls (i.e. super()) or in property accesses (i.e. super.prop or super[prop]).",
    UnterminatedComment: "Unterminated comment.",
    UnterminatedRegExp: "Unterminated regular expression.",
    UnterminatedString: "Unterminated string constant.",
    UnterminatedTemplate: "Unterminated template.",
    UsingDeclarationHasBindingPattern:
      "Using declaration cannot have destructuring patterns.",
    VarRedeclaration: ({ identifierName: identifierName }) =>
      `Identifier '${identifierName}' has already been declared.`,
    YieldBindingIdentifier:
      "Can not use 'yield' as identifier inside a generator.",
    YieldInParameter: "Yield expression is not allowed in formal parameters.",
    ZeroDigitNumericSeparator:
      "Numeric separator can not be used after leading 0.",
  };
  var StrictModeErrors = {
    StrictDelete: "Deleting local variable in strict mode.",
    StrictEvalArguments: ({ referenceName: referenceName }) =>
      `Assigning to '${referenceName}' in strict mode.`,
    StrictEvalArgumentsBinding: ({ bindingName: bindingName }) =>
      `Binding '${bindingName}' in strict mode.`,
    StrictFunction:
      "In strict mode code, functions can only be declared at top level or inside a block.",
    StrictNumericEscape:
      "The only valid numeric escape in strict mode is '\\0'.",
    StrictOctalLiteral: "Legacy octal literals are not allowed in strict mode.",
    StrictWith: "'with' in strict mode.",
  };
  const UnparenthesizedPipeBodyDescriptions = new Set([
    "ArrowFunctionExpression",
    "AssignmentExpression",
    "ConditionalExpression",
    "YieldExpression",
  ]);
  var PipelineOperatorErrors = {
    PipeBodyIsTighter:
      "Unexpected yield after pipeline body; any yield expression acting as Hack-style pipe body must be parenthesized due to its loose operator precedence.",
    PipeTopicRequiresHackPipes:
      'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.',
    PipeTopicUnbound:
      "Topic reference is unbound; it must be inside a pipe body.",
    PipeTopicUnconfiguredToken: ({ token: token }) =>
      `Invalid topic token ${token}. In order to use ${token} as a topic reference, the pipelineOperator plugin must be configured with { "proposal": "hack", "topicToken": "${token}" }.`,
    PipeTopicUnused:
      "Hack-style pipe body does not contain a topic reference; Hack-style pipes must use topic at least once.",
    PipeUnparenthesizedBody: ({ type: type }) =>
      `Hack-style pipe body cannot be an unparenthesized ${toNodeDescription({ type: type })}; please wrap it in parentheses.`,
    PipelineBodyNoArrow:
      'Unexpected arrow "=>" after pipeline body; arrow function in pipeline body must be parenthesized.',
    PipelineBodySequenceExpression:
      "Pipeline body may not be a comma-separated sequence expression.",
    PipelineHeadSequenceExpression:
      "Pipeline head should not be a comma-separated sequence expression.",
    PipelineTopicUnused:
      "Pipeline is in topic style but does not use topic reference.",
    PrimaryTopicNotAllowed:
      "Topic reference was used in a lexical context without topic binding.",
    PrimaryTopicRequiresSmartPipeline:
      'Topic reference is used, but the pipelineOperator plugin was not passed a "proposal": "hack" or "smart" option.',
  };
  const _excluded = ["toMessage"],
    _excluded2 = ["message"];
  function defineHidden(obj, key, value) {
    Object.defineProperty(obj, key, {
      enumerable: false,
      configurable: true,
      value: value,
    });
  }
  function toParseErrorConstructor(_ref) {
    let { toMessage: toMessage } = _ref,
      properties = _objectWithoutPropertiesLoose(_ref, _excluded);
    return function constructor(loc, details) {
      const error = new SyntaxError();
      Object.assign(error, properties, { loc: loc, pos: loc.index });
      if ("missingPlugin" in details) {
        Object.assign(error, { missingPlugin: details.missingPlugin });
      }
      defineHidden(error, "clone", function clone(overrides = {}) {
        var _overrides$loc;
        const {
          line: line,
          column: column,
          index: index,
        } = (_overrides$loc = overrides.loc) != null ? _overrides$loc : loc;
        return constructor(
          new Position(line, column, index),
          Object.assign({}, details, overrides.details),
        );
      });
      defineHidden(error, "details", details);
      Object.defineProperty(error, "message", {
        configurable: true,
        get() {
          const message = `${toMessage(details)} (${loc.line}:${loc.column})`;
          this.message = message;
          return message;
        },
        set(value) {
          Object.defineProperty(this, "message", {
            value: value,
            writable: true,
          });
        },
      });
      return error;
    };
  }
  function ParseErrorEnum(argument, syntaxPlugin) {
    if (Array.isArray(argument)) {
      return (parseErrorTemplates) =>
        ParseErrorEnum(parseErrorTemplates, argument[0]);
    }
    const ParseErrorConstructors = {};
    for (const reasonCode of Object.keys(argument)) {
      const template = argument[reasonCode];
      const _ref2 =
          typeof template === "string"
            ? { message: () => template }
            : typeof template === "function"
              ? { message: template }
              : template,
        { message: message } = _ref2,
        rest = _objectWithoutPropertiesLoose(_ref2, _excluded2);
      const toMessage = typeof message === "string" ? () => message : message;
      ParseErrorConstructors[reasonCode] = toParseErrorConstructor(
        Object.assign(
          {
            code: "BABEL_PARSER_SYNTAX_ERROR",
            reasonCode: reasonCode,
            toMessage: toMessage,
          },
          syntaxPlugin ? { syntaxPlugin: syntaxPlugin } : {},
          rest,
        ),
      );
    }
    return ParseErrorConstructors;
  }
  const Errors = Object.assign(
    {},
    ParseErrorEnum(ModuleErrors),
    ParseErrorEnum(StandardErrors),
    ParseErrorEnum(StrictModeErrors),
    ParseErrorEnum`pipelineOperator`(PipelineOperatorErrors),
  );
  const { defineProperty: defineProperty } = Object;
  const toUnenumerable = (object, key) =>
    defineProperty(object, key, { enumerable: false, value: object[key] });
  function toESTreeLocation(node) {
    node.loc.start && toUnenumerable(node.loc.start, "index");
    node.loc.end && toUnenumerable(node.loc.end, "index");
    return node;
  }
  var estree = (superClass) =>
    class ESTreeParserMixin extends superClass {
      parse() {
        const file = toESTreeLocation(super.parse());
        if (this.options.tokens) {
          file.tokens = file.tokens.map(toESTreeLocation);
        }
        return file;
      }
      parseRegExpLiteral({ pattern: pattern, flags: flags }) {
        let regex = null;
        try {
          regex = new RegExp(pattern, flags);
        } catch (e) {}
        const node = this.estreeParseLiteral(regex);
        node.regex = { pattern: pattern, flags: flags };
        return node;
      }
      parseBigIntLiteral(value) {
        let bigInt;
        try {
          bigInt = BigInt(value);
        } catch (_unused) {
          bigInt = null;
        }
        const node = this.estreeParseLiteral(bigInt);
        node.bigint = String(node.value || value);
        return node;
      }
      parseDecimalLiteral(value) {
        const decimal = null;
        const node = this.estreeParseLiteral(decimal);
        node.decimal = String(node.value || value);
        return node;
      }
      estreeParseLiteral(value) {
        return this.parseLiteral(value, "Literal");
      }
      parseStringLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      parseNumericLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      parseNullLiteral() {
        return this.estreeParseLiteral(null);
      }
      parseBooleanLiteral(value) {
        return this.estreeParseLiteral(value);
      }
      directiveToStmt(directive) {
        const expression = directive.value;
        delete directive.value;
        expression.type = "Literal";
        expression.raw = expression.extra.raw;
        expression.value = expression.extra.expressionValue;
        const stmt = directive;
        stmt.type = "ExpressionStatement";
        stmt.expression = expression;
        stmt.directive = expression.extra.rawValue;
        delete expression.extra;
        return stmt;
      }
      initFunction(node, isAsync) {
        super.initFunction(node, isAsync);
        node.expression = false;
      }
      checkDeclaration(node) {
        if (node != null && this.isObjectProperty(node)) {
          this.checkDeclaration(node.value);
        } else {
          super.checkDeclaration(node);
        }
      }
      getObjectOrClassMethodParams(method) {
        return method.value.params;
      }
      isValidDirective(stmt) {
        var _stmt$expression$extr;
        return (
          stmt.type === "ExpressionStatement" &&
          stmt.expression.type === "Literal" &&
          typeof stmt.expression.value === "string" &&
          !(
            (_stmt$expression$extr = stmt.expression.extra) != null &&
            _stmt$expression$extr.parenthesized
          )
        );
      }
      parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
        super.parseBlockBody(
          node,
          allowDirectives,
          topLevel,
          end,
          afterBlockParse,
        );
        const directiveStatements = node.directives.map((d) =>
          this.directiveToStmt(d),
        );
        node.body = directiveStatements.concat(node.body);
        delete node.directives;
      }
      pushClassMethod(
        classBody,
        method,
        isGenerator,
        isAsync,
        isConstructor,
        allowsDirectSuper,
      ) {
        this.parseMethod(
          method,
          isGenerator,
          isAsync,
          isConstructor,
          allowsDirectSuper,
          "ClassMethod",
          true,
        );
        if (method.typeParameters) {
          method.value.typeParameters = method.typeParameters;
          delete method.typeParameters;
        }
        classBody.body.push(method);
      }
      parsePrivateName() {
        const node = super.parsePrivateName();
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return node;
          }
        }
        return this.convertPrivateNameToPrivateIdentifier(node);
      }
      convertPrivateNameToPrivateIdentifier(node) {
        const name = super.getPrivateNameSV(node);
        node = node;
        delete node.id;
        node.name = name;
        node.type = "PrivateIdentifier";
        return node;
      }
      isPrivateName(node) {
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return super.isPrivateName(node);
          }
        }
        return node.type === "PrivateIdentifier";
      }
      getPrivateNameSV(node) {
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return super.getPrivateNameSV(node);
          }
        }
        return node.name;
      }
      parseLiteral(value, type) {
        const node = super.parseLiteral(value, type);
        node.raw = node.extra.raw;
        delete node.extra;
        return node;
      }
      parseFunctionBody(node, allowExpression, isMethod = false) {
        super.parseFunctionBody(node, allowExpression, isMethod);
        node.expression = node.body.type !== "BlockStatement";
      }
      parseMethod(
        node,
        isGenerator,
        isAsync,
        isConstructor,
        allowDirectSuper,
        type,
        inClassScope = false,
      ) {
        let funcNode = this.startNode();
        funcNode.kind = node.kind;
        funcNode = super.parseMethod(
          funcNode,
          isGenerator,
          isAsync,
          isConstructor,
          allowDirectSuper,
          type,
          inClassScope,
        );
        funcNode.type = "FunctionExpression";
        delete funcNode.kind;
        node.value = funcNode;
        if (type === "ClassPrivateMethod") {
          node.computed = false;
        }
        return this.finishNode(node, "MethodDefinition");
      }
      parseClassProperty(...args) {
        const propertyNode = super.parseClassProperty(...args);
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return propertyNode;
          }
        }
        propertyNode.type = "PropertyDefinition";
        return propertyNode;
      }
      parseClassPrivateProperty(...args) {
        const propertyNode = super.parseClassPrivateProperty(...args);
        {
          if (!this.getPluginOption("estree", "classFeatures")) {
            return propertyNode;
          }
        }
        propertyNode.type = "PropertyDefinition";
        propertyNode.computed = false;
        return propertyNode;
      }
      parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
        const node = super.parseObjectMethod(
          prop,
          isGenerator,
          isAsync,
          isPattern,
          isAccessor,
        );
        if (node) {
          node.type = "Property";
          if (node.kind === "method") {
            node.kind = "init";
          }
          node.shorthand = false;
        }
        return node;
      }
      parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
        const node = super.parseObjectProperty(
          prop,
          startLoc,
          isPattern,
          refExpressionErrors,
        );
        if (node) {
          node.kind = "init";
          node.type = "Property";
        }
        return node;
      }
      isValidLVal(type, isUnparenthesizedInAssign, binding) {
        return type === "Property"
          ? "value"
          : super.isValidLVal(type, isUnparenthesizedInAssign, binding);
      }
      isAssignable(node, isBinding) {
        if (node != null && this.isObjectProperty(node)) {
          return this.isAssignable(node.value, isBinding);
        }
        return super.isAssignable(node, isBinding);
      }
      toAssignable(node, isLHS = false) {
        if (node != null && this.isObjectProperty(node)) {
          const { key: key, value: value } = node;
          if (this.isPrivateName(key)) {
            this.classScope.usePrivateName(
              this.getPrivateNameSV(key),
              key.loc.start,
            );
          }
          this.toAssignable(value, isLHS);
        } else {
          super.toAssignable(node, isLHS);
        }
      }
      toAssignableObjectExpressionProp(prop, isLast, isLHS) {
        if (prop.kind === "get" || prop.kind === "set") {
          this.raise(Errors.PatternHasAccessor, prop.key);
        } else if (prop.method) {
          this.raise(Errors.PatternHasMethod, prop.key);
        } else {
          super.toAssignableObjectExpressionProp(prop, isLast, isLHS);
        }
      }
      finishCallExpression(unfinished, optional) {
        const node = super.finishCallExpression(unfinished, optional);
        if (node.callee.type === "Import") {
          node.type = "ImportExpression";
          node.source = node.arguments[0];
          if (
            this.hasPlugin("importAttributes") ||
            this.hasPlugin("importAssertions")
          ) {
            var _node$arguments$, _node$arguments$2;
            node.options =
              (_node$arguments$ = node.arguments[1]) != null
                ? _node$arguments$
                : null;
            node.attributes =
              (_node$arguments$2 = node.arguments[1]) != null
                ? _node$arguments$2
                : null;
          }
          delete node.arguments;
          delete node.callee;
        }
        return node;
      }
      toReferencedArguments(node) {
        if (node.type === "ImportExpression") {
          return;
        }
        super.toReferencedArguments(node);
      }
      parseExport(unfinished, decorators) {
        const exportStartLoc = this.state.lastTokStartLoc;
        const node = super.parseExport(unfinished, decorators);
        switch (node.type) {
          case "ExportAllDeclaration":
            node.exported = null;
            break;
          case "ExportNamedDeclaration":
            if (
              node.specifiers.length === 1 &&
              node.specifiers[0].type === "ExportNamespaceSpecifier"
            ) {
              node.type = "ExportAllDeclaration";
              node.exported = node.specifiers[0].exported;
              delete node.specifiers;
            }
          case "ExportDefaultDeclaration":
            {
              var _declaration$decorato;
              const { declaration: declaration } = node;
              if (
                (declaration == null ? void 0 : declaration.type) ===
                  "ClassDeclaration" &&
                ((_declaration$decorato = declaration.decorators) == null
                  ? void 0
                  : _declaration$decorato.length) > 0 &&
                declaration.start === node.start
              ) {
                this.resetStartLocation(node, exportStartLoc);
              }
            }
            break;
        }
        return node;
      }
      parseSubscript(base, startLoc, noCalls, state) {
        const node = super.parseSubscript(base, startLoc, noCalls, state);
        if (state.optionalChainMember) {
          if (
            node.type === "OptionalMemberExpression" ||
            node.type === "OptionalCallExpression"
          ) {
            node.type = node.type.substring(8);
          }
          if (state.stop) {
            const chain = this.startNodeAtNode(node);
            chain.expression = node;
            return this.finishNode(chain, "ChainExpression");
          }
        } else if (
          node.type === "MemberExpression" ||
          node.type === "CallExpression"
        ) {
          node.optional = false;
        }
        return node;
      }
      isOptionalMemberExpression(node) {
        if (node.type === "ChainExpression") {
          return node.expression.type === "MemberExpression";
        }
        return super.isOptionalMemberExpression(node);
      }
      hasPropertyAsPrivateName(node) {
        if (node.type === "ChainExpression") {
          node = node.expression;
        }
        return super.hasPropertyAsPrivateName(node);
      }
      isObjectProperty(node) {
        return node.type === "Property" && node.kind === "init" && !node.method;
      }
      isObjectMethod(node) {
        return node.method || node.kind === "get" || node.kind === "set";
      }
      finishNodeAt(node, type, endLoc) {
        return toESTreeLocation(super.finishNodeAt(node, type, endLoc));
      }
      resetStartLocation(node, startLoc) {
        super.resetStartLocation(node, startLoc);
        toESTreeLocation(node);
      }
      resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
        super.resetEndLocation(node, endLoc);
        toESTreeLocation(node);
      }
    };
  class TokContext {
    constructor(token, preserveSpace) {
      this.token = void 0;
      this.preserveSpace = void 0;
      this.token = token;
      this.preserveSpace = !!preserveSpace;
    }
  }
  const types = {
    brace: new TokContext("{"),
    j_oTag: new TokContext("<tag"),
    j_cTag: new TokContext("</tag"),
    j_expr: new TokContext("<tag>...</tag>", true),
  };
  {
    types.template = new TokContext("`", true);
  }
  const beforeExpr = true;
  const startsExpr = true;
  const isLoop = true;
  const isAssign = true;
  const prefix = true;
  const postfix = true;
  class ExportedTokenType {
    constructor(label, conf = {}) {
      this.label = void 0;
      this.keyword = void 0;
      this.beforeExpr = void 0;
      this.startsExpr = void 0;
      this.rightAssociative = void 0;
      this.isLoop = void 0;
      this.isAssign = void 0;
      this.prefix = void 0;
      this.postfix = void 0;
      this.binop = void 0;
      this.label = label;
      this.keyword = conf.keyword;
      this.beforeExpr = !!conf.beforeExpr;
      this.startsExpr = !!conf.startsExpr;
      this.rightAssociative = !!conf.rightAssociative;
      this.isLoop = !!conf.isLoop;
      this.isAssign = !!conf.isAssign;
      this.prefix = !!conf.prefix;
      this.postfix = !!conf.postfix;
      this.binop = conf.binop != null ? conf.binop : null;
      {
        this.updateContext = null;
      }
    }
  }
  const keywords$1 = new Map();
  function createKeyword(name, options = {}) {
    options.keyword = name;
    const token = createToken(name, options);
    keywords$1.set(name, token);
    return token;
  }
  function createBinop(name, binop) {
    return createToken(name, { beforeExpr: beforeExpr, binop: binop });
  }
  let tokenTypeCounter = -1;
  const tokenTypes = [];
  const tokenLabels = [];
  const tokenBinops = [];
  const tokenBeforeExprs = [];
  const tokenStartsExprs = [];
  const tokenPrefixes = [];
  function createToken(name, options = {}) {
    var _options$binop,
      _options$beforeExpr,
      _options$startsExpr,
      _options$prefix;
    ++tokenTypeCounter;
    tokenLabels.push(name);
    tokenBinops.push(
      (_options$binop = options.binop) != null ? _options$binop : -1,
    );
    tokenBeforeExprs.push(
      (_options$beforeExpr = options.beforeExpr) != null
        ? _options$beforeExpr
        : false,
    );
    tokenStartsExprs.push(
      (_options$startsExpr = options.startsExpr) != null
        ? _options$startsExpr
        : false,
    );
    tokenPrefixes.push(
      (_options$prefix = options.prefix) != null ? _options$prefix : false,
    );
    tokenTypes.push(new ExportedTokenType(name, options));
    return tokenTypeCounter;
  }
  function createKeywordLike(name, options = {}) {
    var _options$binop2,
      _options$beforeExpr2,
      _options$startsExpr2,
      _options$prefix2;
    ++tokenTypeCounter;
    keywords$1.set(name, tokenTypeCounter);
    tokenLabels.push(name);
    tokenBinops.push(
      (_options$binop2 = options.binop) != null ? _options$binop2 : -1,
    );
    tokenBeforeExprs.push(
      (_options$beforeExpr2 = options.beforeExpr) != null
        ? _options$beforeExpr2
        : false,
    );
    tokenStartsExprs.push(
      (_options$startsExpr2 = options.startsExpr) != null
        ? _options$startsExpr2
        : false,
    );
    tokenPrefixes.push(
      (_options$prefix2 = options.prefix) != null ? _options$prefix2 : false,
    );
    tokenTypes.push(new ExportedTokenType("name", options));
    return tokenTypeCounter;
  }
  const tt = {
    bracketL: createToken("[", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    bracketHashL: createToken("#[", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    bracketBarL: createToken("[|", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    bracketR: createToken("]"),
    bracketBarR: createToken("|]"),
    braceL: createToken("{", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    braceBarL: createToken("{|", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    braceHashL: createToken("#{", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    braceR: createToken("}"),
    braceBarR: createToken("|}"),
    parenL: createToken("(", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    parenR: createToken(")"),
    comma: createToken(",", { beforeExpr: beforeExpr }),
    semi: createToken(";", { beforeExpr: beforeExpr }),
    colon: createToken(":", { beforeExpr: beforeExpr }),
    doubleColon: createToken("::", { beforeExpr: beforeExpr }),
    dot: createToken("."),
    question: createToken("?", { beforeExpr: beforeExpr }),
    questionDot: createToken("?."),
    arrow: createToken("=>", { beforeExpr: beforeExpr }),
    template: createToken("template"),
    ellipsis: createToken("...", { beforeExpr: beforeExpr }),
    backQuote: createToken("`", { startsExpr: startsExpr }),
    dollarBraceL: createToken("${", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    templateTail: createToken("...`", { startsExpr: startsExpr }),
    templateNonTail: createToken("...${", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    at: createToken("@"),
    hash: createToken("#", { startsExpr: startsExpr }),
    interpreterDirective: createToken("#!..."),
    eq: createToken("=", { beforeExpr: beforeExpr, isAssign: isAssign }),
    assign: createToken("_=", { beforeExpr: beforeExpr, isAssign: isAssign }),
    slashAssign: createToken("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign,
    }),
    xorAssign: createToken("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign,
    }),
    moduloAssign: createToken("_=", {
      beforeExpr: beforeExpr,
      isAssign: isAssign,
    }),
    incDec: createToken("++/--", {
      prefix: prefix,
      postfix: postfix,
      startsExpr: startsExpr,
    }),
    bang: createToken("!", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    tilde: createToken("~", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    doubleCaret: createToken("^^", { startsExpr: startsExpr }),
    doubleAt: createToken("@@", { startsExpr: startsExpr }),
    pipeline: createBinop("|>", 0),
    nullishCoalescing: createBinop("??", 1),
    logicalOR: createBinop("||", 1),
    logicalAND: createBinop("&&", 2),
    bitwiseOR: createBinop("|", 3),
    bitwiseXOR: createBinop("^", 4),
    bitwiseAND: createBinop("&", 5),
    equality: createBinop("==/!=/===/!==", 6),
    lt: createBinop("</>/<=/>=", 7),
    gt: createBinop("</>/<=/>=", 7),
    relational: createBinop("</>/<=/>=", 7),
    bitShift: createBinop("<</>>/>>>", 8),
    bitShiftL: createBinop("<</>>/>>>", 8),
    bitShiftR: createBinop("<</>>/>>>", 8),
    plusMin: createToken("+/-", {
      beforeExpr: beforeExpr,
      binop: 9,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    modulo: createToken("%", { binop: 10, startsExpr: startsExpr }),
    star: createToken("*", { binop: 10 }),
    slash: createBinop("/", 10),
    exponent: createToken("**", {
      beforeExpr: beforeExpr,
      binop: 11,
      rightAssociative: true,
    }),
    _in: createKeyword("in", { beforeExpr: beforeExpr, binop: 7 }),
    _instanceof: createKeyword("instanceof", {
      beforeExpr: beforeExpr,
      binop: 7,
    }),
    _break: createKeyword("break"),
    _case: createKeyword("case", { beforeExpr: beforeExpr }),
    _catch: createKeyword("catch"),
    _continue: createKeyword("continue"),
    _debugger: createKeyword("debugger"),
    _default: createKeyword("default", { beforeExpr: beforeExpr }),
    _else: createKeyword("else", { beforeExpr: beforeExpr }),
    _finally: createKeyword("finally"),
    _function: createKeyword("function", { startsExpr: startsExpr }),
    _if: createKeyword("if"),
    _return: createKeyword("return", { beforeExpr: beforeExpr }),
    _switch: createKeyword("switch"),
    _throw: createKeyword("throw", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    _try: createKeyword("try"),
    _var: createKeyword("var"),
    _const: createKeyword("const"),
    _with: createKeyword("with"),
    _new: createKeyword("new", {
      beforeExpr: beforeExpr,
      startsExpr: startsExpr,
    }),
    _this: createKeyword("this", { startsExpr: startsExpr }),
    _super: createKeyword("super", { startsExpr: startsExpr }),
    _class: createKeyword("class", { startsExpr: startsExpr }),
    _extends: createKeyword("extends", { beforeExpr: beforeExpr }),
    _export: createKeyword("export"),
    _import: createKeyword("import", { startsExpr: startsExpr }),
    _null: createKeyword("null", { startsExpr: startsExpr }),
    _true: createKeyword("true", { startsExpr: startsExpr }),
    _false: createKeyword("false", { startsExpr: startsExpr }),
    _typeof: createKeyword("typeof", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    _void: createKeyword("void", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    _delete: createKeyword("delete", {
      beforeExpr: beforeExpr,
      prefix: prefix,
      startsExpr: startsExpr,
    }),
    _do: createKeyword("do", { isLoop: isLoop, beforeExpr: beforeExpr }),
    _for: createKeyword("for", { isLoop: isLoop }),
    _while: createKeyword("while", { isLoop: isLoop }),
    _as: createKeywordLike("as", { startsExpr: startsExpr }),
    _assert: createKeywordLike("assert", { startsExpr: startsExpr }),
    _async: createKeywordLike("async", { startsExpr: startsExpr }),
    _await: createKeywordLike("await", { startsExpr: startsExpr }),
    _defer: createKeywordLike("defer", { startsExpr: startsExpr }),
    _from: createKeywordLike("from", { startsExpr: startsExpr }),
    _get: createKeywordLike("get", { startsExpr: startsExpr }),
    _let: createKeywordLike("let", { startsExpr: startsExpr }),
    _meta: createKeywordLike("meta", { startsExpr: startsExpr }),
    _of: createKeywordLike("of", { startsExpr: startsExpr }),
    _sent: createKeywordLike("sent", { startsExpr: startsExpr }),
    _set: createKeywordLike("set", { startsExpr: startsExpr }),
    _source: createKeywordLike("source", { startsExpr: startsExpr }),
    _static: createKeywordLike("static", { startsExpr: startsExpr }),
    _using: createKeywordLike("using", { startsExpr: startsExpr }),
    _yield: createKeywordLike("yield", { startsExpr: startsExpr }),
    _asserts: createKeywordLike("asserts", { startsExpr: startsExpr }),
    _checks: createKeywordLike("checks", { startsExpr: startsExpr }),
    _exports: createKeywordLike("exports", { startsExpr: startsExpr }),
    _global: createKeywordLike("global", { startsExpr: startsExpr }),
    _implements: createKeywordLike("implements", { startsExpr: startsExpr }),
    _intrinsic: createKeywordLike("intrinsic", { startsExpr: startsExpr }),
    _infer: createKeywordLike("infer", { startsExpr: startsExpr }),
    _is: createKeywordLike("is", { startsExpr: startsExpr }),
    _mixins: createKeywordLike("mixins", { startsExpr: startsExpr }),
    _proto: createKeywordLike("proto", { startsExpr: startsExpr }),
    _require: createKeywordLike("require", { startsExpr: startsExpr }),
    _satisfies: createKeywordLike("satisfies", { startsExpr: startsExpr }),
    _keyof: createKeywordLike("keyof", { startsExpr: startsExpr }),
    _readonly: createKeywordLike("readonly", { startsExpr: startsExpr }),
    _unique: createKeywordLike("unique", { startsExpr: startsExpr }),
    _abstract: createKeywordLike("abstract", { startsExpr: startsExpr }),
    _declare: createKeywordLike("declare", { startsExpr: startsExpr }),
    _enum: createKeywordLike("enum", { startsExpr: startsExpr }),
    _module: createKeywordLike("module", { startsExpr: startsExpr }),
    _namespace: createKeywordLike("namespace", { startsExpr: startsExpr }),
    _interface: createKeywordLike("interface", { startsExpr: startsExpr }),
    _type: createKeywordLike("type", { startsExpr: startsExpr }),
    _opaque: createKeywordLike("opaque", { startsExpr: startsExpr }),
    name: createToken("name", { startsExpr: startsExpr }),
    string: createToken("string", { startsExpr: startsExpr }),
    num: createToken("num", { startsExpr: startsExpr }),
    bigint: createToken("bigint", { startsExpr: startsExpr }),
    decimal: createToken("decimal", { startsExpr: startsExpr }),
    regexp: createToken("regexp", { startsExpr: startsExpr }),
    privateName: createToken("#name", { startsExpr: startsExpr }),
    eof: createToken("eof"),
    jsxName: createToken("jsxName"),
    jsxText: createToken("jsxText", { beforeExpr: true }),
    jsxTagStart: createToken("jsxTagStart", { startsExpr: true }),
    jsxTagEnd: createToken("jsxTagEnd"),
    placeholder: createToken("%%", { startsExpr: true }),
  };
  function tokenIsIdentifier(token) {
    return token >= 93 && token <= 132;
  }
  function tokenKeywordOrIdentifierIsKeyword(token) {
    return token <= 92;
  }
  function tokenIsKeywordOrIdentifier(token) {
    return token >= 58 && token <= 132;
  }
  function tokenIsLiteralPropertyName(token) {
    return token >= 58 && token <= 136;
  }
  function tokenComesBeforeExpression(token) {
    return tokenBeforeExprs[token];
  }
  function tokenCanStartExpression(token) {
    return tokenStartsExprs[token];
  }
  function tokenIsAssignment(token) {
    return token >= 29 && token <= 33;
  }
  function tokenIsFlowInterfaceOrTypeOrOpaque(token) {
    return token >= 129 && token <= 131;
  }
  function tokenIsLoop(token) {
    return token >= 90 && token <= 92;
  }
  function tokenIsKeyword(token) {
    return token >= 58 && token <= 92;
  }
  function tokenIsOperator(token) {
    return token >= 39 && token <= 59;
  }
  function tokenIsPostfix(token) {
    return token === 34;
  }
  function tokenIsPrefix(token) {
    return tokenPrefixes[token];
  }
  function tokenIsTSTypeOperator(token) {
    return token >= 121 && token <= 123;
  }
  function tokenIsTSDeclarationStart(token) {
    return token >= 124 && token <= 130;
  }
  function tokenLabelName(token) {
    return tokenLabels[token];
  }
  function tokenOperatorPrecedence(token) {
    return tokenBinops[token];
  }
  function tokenIsRightAssociative(token) {
    return token === 57;
  }
  function tokenIsTemplate(token) {
    return token >= 24 && token <= 25;
  }
  function getExportedToken(token) {
    return tokenTypes[token];
  }
  {
    tokenTypes[8].updateContext = (context) => {
      context.pop();
    };
    tokenTypes[5].updateContext =
      tokenTypes[7].updateContext =
      tokenTypes[23].updateContext =
        (context) => {
          context.push(types.brace);
        };
    tokenTypes[22].updateContext = (context) => {
      if (context[context.length - 1] === types.template) {
        context.pop();
      } else {
        context.push(types.template);
      }
    };
    tokenTypes[142].updateContext = (context) => {
      context.push(types.j_expr, types.j_oTag);
    };
  }
  let nonASCIIidentifierStartChars =
    "ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲈᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟊꟐꟑꟓꟕ-ꟙꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ";
  let nonASCIIidentifierChars =
    "‌‍·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛࢘-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･";
  const nonASCIIidentifierStart = new RegExp(
    "[" + nonASCIIidentifierStartChars + "]",
  );
  const nonASCIIidentifier = new RegExp(
    "[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]",
  );
  nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
  const astralIdentifierStartCodes = [
    0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48,
    48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5,
    39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10,
    21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11,
    22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2,
    2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72,
    56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20,
    28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4,
    0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2,
    14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4,
    159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0,
    60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2,
    23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12,
    45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0,
    26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921,
    103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30,
    18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67,
    12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16,
    0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2,
    70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2,
    27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2,
    24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11,
    6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60,
    67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5,
    0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0,
    3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719,
    33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6,
    4191,
  ];
  const astralIdentifierCodes = [
    509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1,
    574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1,
    11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13,
    9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3,
    2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3,
    8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5,
    2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0,
    10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2,
    6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4,
    14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54,
    8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31,
    3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2,
    16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983,
    6, 110, 6, 6, 9, 4759, 9, 787719, 239,
  ];
  function isInAstralSet(code, set) {
    let pos = 65536;
    for (let i = 0, length = set.length; i < length; i += 2) {
      pos += set[i];
      if (pos > code) return false;
      pos += set[i + 1];
      if (pos >= code) return true;
    }
    return false;
  }
  function isIdentifierStart(code) {
    if (code < 65) return code === 36;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;
    if (code <= 65535) {
      return (
        code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code))
      );
    }
    return isInAstralSet(code, astralIdentifierStartCodes);
  }
  function isIdentifierChar(code) {
    if (code < 48) return code === 36;
    if (code < 58) return true;
    if (code < 65) return false;
    if (code <= 90) return true;
    if (code < 97) return code === 95;
    if (code <= 122) return true;
    if (code <= 65535) {
      return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
    }
    return (
      isInAstralSet(code, astralIdentifierStartCodes) ||
      isInAstralSet(code, astralIdentifierCodes)
    );
  }
  const reservedWords = {
    keyword: [
      "break",
      "case",
      "catch",
      "continue",
      "debugger",
      "default",
      "do",
      "else",
      "finally",
      "for",
      "function",
      "if",
      "return",
      "switch",
      "throw",
      "try",
      "var",
      "const",
      "while",
      "with",
      "new",
      "this",
      "super",
      "class",
      "extends",
      "export",
      "import",
      "null",
      "true",
      "false",
      "in",
      "instanceof",
      "typeof",
      "void",
      "delete",
    ],
    strict: [
      "implements",
      "interface",
      "let",
      "package",
      "private",
      "protected",
      "public",
      "static",
      "yield",
    ],
    strictBind: ["eval", "arguments"],
  };
  const keywords = new Set(reservedWords.keyword);
  const reservedWordsStrictSet = new Set(reservedWords.strict);
  const reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
  function isReservedWord(word, inModule) {
    return (inModule && word === "await") || word === "enum";
  }
  function isStrictReservedWord(word, inModule) {
    return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
  }
  function isStrictBindOnlyReservedWord(word) {
    return reservedWordsStrictBindSet.has(word);
  }
  function isStrictBindReservedWord(word, inModule) {
    return (
      isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word)
    );
  }
  function isKeyword(word) {
    return keywords.has(word);
  }
  function isIteratorStart(current, next, next2) {
    return current === 64 && next === 64 && isIdentifierStart(next2);
  }
  const reservedWordLikeSet = new Set([
    "break",
    "case",
    "catch",
    "continue",
    "debugger",
    "default",
    "do",
    "else",
    "finally",
    "for",
    "function",
    "if",
    "return",
    "switch",
    "throw",
    "try",
    "var",
    "const",
    "while",
    "with",
    "new",
    "this",
    "super",
    "class",
    "extends",
    "export",
    "import",
    "null",
    "true",
    "false",
    "in",
    "instanceof",
    "typeof",
    "void",
    "delete",
    "implements",
    "interface",
    "let",
    "package",
    "private",
    "protected",
    "public",
    "static",
    "yield",
    "eval",
    "arguments",
    "enum",
    "await",
  ]);
  function canBeReservedWord(word) {
    return reservedWordLikeSet.has(word);
  }
  class Scope {
    constructor(flags) {
      this.flags = 0;
      this.names = new Map();
      this.firstLexicalName = "";
      this.flags = flags;
    }
  }
  class ScopeHandler {
    constructor(parser, inModule) {
      this.parser = void 0;
      this.scopeStack = [];
      this.inModule = void 0;
      this.undefinedExports = new Map();
      this.parser = parser;
      this.inModule = inModule;
    }
    get inTopLevel() {
      return (this.currentScope().flags & 1) > 0;
    }
    get inFunction() {
      return (this.currentVarScopeFlags() & 2) > 0;
    }
    get allowSuper() {
      return (this.currentThisScopeFlags() & 16) > 0;
    }
    get allowDirectSuper() {
      return (this.currentThisScopeFlags() & 32) > 0;
    }
    get inClass() {
      return (this.currentThisScopeFlags() & 64) > 0;
    }
    get inClassAndNotInNonArrowFunction() {
      const flags = this.currentThisScopeFlags();
      return (flags & 64) > 0 && (flags & 2) === 0;
    }
    get inStaticBlock() {
      for (let i = this.scopeStack.length - 1; ; i--) {
        const { flags: flags } = this.scopeStack[i];
        if (flags & 128) {
          return true;
        }
        if (flags & (387 | 64)) {
          return false;
        }
      }
    }
    get inNonArrowFunction() {
      return (this.currentThisScopeFlags() & 2) > 0;
    }
    get treatFunctionsAsVar() {
      return this.treatFunctionsAsVarInScope(this.currentScope());
    }
    createScope(flags) {
      return new Scope(flags);
    }
    enter(flags) {
      this.scopeStack.push(this.createScope(flags));
    }
    exit() {
      const scope = this.scopeStack.pop();
      return scope.flags;
    }
    treatFunctionsAsVarInScope(scope) {
      return !!(
        scope.flags & (2 | 128) ||
        (!this.parser.inModule && scope.flags & 1)
      );
    }
    declareName(name, bindingType, loc) {
      let scope = this.currentScope();
      if (bindingType & 8 || bindingType & 16) {
        this.checkRedeclarationInScope(scope, name, bindingType, loc);
        let type = scope.names.get(name) || 0;
        if (bindingType & 16) {
          type = type | 4;
        } else {
          if (!scope.firstLexicalName) {
            scope.firstLexicalName = name;
          }
          type = type | 2;
        }
        scope.names.set(name, type);
        if (bindingType & 8) {
          this.maybeExportDefined(scope, name);
        }
      } else if (bindingType & 4) {
        for (let i = this.scopeStack.length - 1; i >= 0; --i) {
          scope = this.scopeStack[i];
          this.checkRedeclarationInScope(scope, name, bindingType, loc);
          scope.names.set(name, (scope.names.get(name) || 0) | 1);
          this.maybeExportDefined(scope, name);
          if (scope.flags & 387) break;
        }
      }
      if (this.parser.inModule && scope.flags & 1) {
        this.undefinedExports.delete(name);
      }
    }
    maybeExportDefined(scope, name) {
      if (this.parser.inModule && scope.flags & 1) {
        this.undefinedExports.delete(name);
      }
    }
    checkRedeclarationInScope(scope, name, bindingType, loc) {
      if (this.isRedeclaredInScope(scope, name, bindingType)) {
        this.parser.raise(Errors.VarRedeclaration, loc, {
          identifierName: name,
        });
      }
    }
    isRedeclaredInScope(scope, name, bindingType) {
      if (!(bindingType & 1)) return false;
      if (bindingType & 8) {
        return scope.names.has(name);
      }
      const type = scope.names.get(name);
      if (bindingType & 16) {
        return (
          (type & 2) > 0 ||
          (!this.treatFunctionsAsVarInScope(scope) && (type & 1) > 0)
        );
      }
      return (
        ((type & 2) > 0 &&
          !(scope.flags & 8 && scope.firstLexicalName === name)) ||
        (!this.treatFunctionsAsVarInScope(scope) && (type & 4) > 0)
      );
    }
    checkLocalExport(id) {
      const { name: name } = id;
      const topLevelScope = this.scopeStack[0];
      if (!topLevelScope.names.has(name)) {
        this.undefinedExports.set(name, id.loc.start);
      }
    }
    currentScope() {
      return this.scopeStack[this.scopeStack.length - 1];
    }
    currentVarScopeFlags() {
      for (let i = this.scopeStack.length - 1; ; i--) {
        const { flags: flags } = this.scopeStack[i];
        if (flags & 387) {
          return flags;
        }
      }
    }
    currentThisScopeFlags() {
      for (let i = this.scopeStack.length - 1; ; i--) {
        const { flags: flags } = this.scopeStack[i];
        if (flags & (387 | 64) && !(flags & 4)) {
          return flags;
        }
      }
    }
  }
  class FlowScope extends Scope {
    constructor(...args) {
      super(...args);
      this.declareFunctions = new Set();
    }
  }
  class FlowScopeHandler extends ScopeHandler {
    createScope(flags) {
      return new FlowScope(flags);
    }
    declareName(name, bindingType, loc) {
      const scope = this.currentScope();
      if (bindingType & 2048) {
        this.checkRedeclarationInScope(scope, name, bindingType, loc);
        this.maybeExportDefined(scope, name);
        scope.declareFunctions.add(name);
        return;
      }
      super.declareName(name, bindingType, loc);
    }
    isRedeclaredInScope(scope, name, bindingType) {
      if (super.isRedeclaredInScope(scope, name, bindingType)) return true;
      if (bindingType & 2048 && !scope.declareFunctions.has(name)) {
        const type = scope.names.get(name);
        return (type & 4) > 0 || (type & 2) > 0;
      }
      return false;
    }
    checkLocalExport(id) {
      if (!this.scopeStack[0].declareFunctions.has(id.name)) {
        super.checkLocalExport(id);
      }
    }
  }
  class BaseParser {
    constructor() {
      this.sawUnambiguousESM = false;
      this.ambiguousScriptDifferentAst = false;
    }
    hasPlugin(pluginConfig) {
      if (typeof pluginConfig === "string") {
        return this.plugins.has(pluginConfig);
      } else {
        const [pluginName, pluginOptions] = pluginConfig;
        if (!this.hasPlugin(pluginName)) {
          return false;
        }
        const actualOptions = this.plugins.get(pluginName);
        for (const key of Object.keys(pluginOptions)) {
          if (
            (actualOptions == null ? void 0 : actualOptions[key]) !==
            pluginOptions[key]
          ) {
            return false;
          }
        }
        return true;
      }
    }
    getPluginOption(plugin, name) {
      var _this$plugins$get;
      return (_this$plugins$get = this.plugins.get(plugin)) == null
        ? void 0
        : _this$plugins$get[name];
    }
  }
  function setTrailingComments(node, comments) {
    if (node.trailingComments === undefined) {
      node.trailingComments = comments;
    } else {
      node.trailingComments.unshift(...comments);
    }
  }
  function setLeadingComments(node, comments) {
    if (node.leadingComments === undefined) {
      node.leadingComments = comments;
    } else {
      node.leadingComments.unshift(...comments);
    }
  }
  function setInnerComments(node, comments) {
    if (node.innerComments === undefined) {
      node.innerComments = comments;
    } else {
      node.innerComments.unshift(...comments);
    }
  }
  function adjustInnerComments(node, elements, commentWS) {
    let lastElement = null;
    let i = elements.length;
    while (lastElement === null && i > 0) {
      lastElement = elements[--i];
    }
    if (lastElement === null || lastElement.start > commentWS.start) {
      setInnerComments(node, commentWS.comments);
    } else {
      setTrailingComments(lastElement, commentWS.comments);
    }
  }
  class CommentsParser extends BaseParser {
    addComment(comment) {
      if (this.filename) comment.loc.filename = this.filename;
      const { commentsLen: commentsLen } = this.state;
      if (this.comments.length != commentsLen)
        this.comments.length = commentsLen;
      this.comments.push(comment);
      this.state.commentsLen++;
    }
    processComment(node) {
      const { commentStack: commentStack } = this.state;
      const commentStackLength = commentStack.length;
      if (commentStackLength === 0) return;
      let i = commentStackLength - 1;
      const lastCommentWS = commentStack[i];
      if (lastCommentWS.start === node.end) {
        lastCommentWS.leadingNode = node;
        i--;
      }
      const { start: nodeStart } = node;
      for (; i >= 0; i--) {
        const commentWS = commentStack[i];
        const commentEnd = commentWS.end;
        if (commentEnd > nodeStart) {
          commentWS.containingNode = node;
          this.finalizeComment(commentWS);
          commentStack.splice(i, 1);
        } else {
          if (commentEnd === nodeStart) {
            commentWS.trailingNode = node;
          }
          break;
        }
      }
    }
    finalizeComment(commentWS) {
      const { comments: comments } = commentWS;
      if (commentWS.leadingNode !== null || commentWS.trailingNode !== null) {
        if (commentWS.leadingNode !== null) {
          setTrailingComments(commentWS.leadingNode, comments);
        }
        if (commentWS.trailingNode !== null) {
          setLeadingComments(commentWS.trailingNode, comments);
        }
      } else {
        const { containingNode: node, start: commentStart } = commentWS;
        if (this.input.charCodeAt(commentStart - 1) === 44) {
          switch (node.type) {
            case "ObjectExpression":
            case "ObjectPattern":
            case "RecordExpression":
              adjustInnerComments(node, node.properties, commentWS);
              break;
            case "CallExpression":
            case "OptionalCallExpression":
              adjustInnerComments(node, node.arguments, commentWS);
              break;
            case "FunctionDeclaration":
            case "FunctionExpression":
            case "ArrowFunctionExpression":
            case "ObjectMethod":
            case "ClassMethod":
            case "ClassPrivateMethod":
              adjustInnerComments(node, node.params, commentWS);
              break;
            case "ArrayExpression":
            case "ArrayPattern":
            case "TupleExpression":
              adjustInnerComments(node, node.elements, commentWS);
              break;
            case "ExportNamedDeclaration":
            case "ImportDeclaration":
              adjustInnerComments(node, node.specifiers, commentWS);
              break;
            default: {
              setInnerComments(node, comments);
            }
          }
        } else {
          setInnerComments(node, comments);
        }
      }
    }
    finalizeRemainingComments() {
      const { commentStack: commentStack } = this.state;
      for (let i = commentStack.length - 1; i >= 0; i--) {
        this.finalizeComment(commentStack[i]);
      }
      this.state.commentStack = [];
    }
    resetPreviousNodeTrailingComments(node) {
      const { commentStack: commentStack } = this.state;
      const { length: length } = commentStack;
      if (length === 0) return;
      const commentWS = commentStack[length - 1];
      if (commentWS.leadingNode === node) {
        commentWS.leadingNode = null;
      }
    }
    resetPreviousIdentifierLeadingComments(node) {
      const { commentStack: commentStack } = this.state;
      const { length: length } = commentStack;
      if (length === 0) return;
      if (commentStack[length - 1].trailingNode === node) {
        commentStack[length - 1].trailingNode = null;
      } else if (
        length >= 2 &&
        commentStack[length - 2].trailingNode === node
      ) {
        commentStack[length - 2].trailingNode = null;
      }
    }
    takeSurroundingComments(node, start, end) {
      const { commentStack: commentStack } = this.state;
      const commentStackLength = commentStack.length;
      if (commentStackLength === 0) return;
      let i = commentStackLength - 1;
      for (; i >= 0; i--) {
        const commentWS = commentStack[i];
        const commentEnd = commentWS.end;
        const commentStart = commentWS.start;
        if (commentStart === end) {
          commentWS.leadingNode = node;
        } else if (commentEnd === start) {
          commentWS.trailingNode = node;
        } else if (commentEnd < start) {
          break;
        }
      }
    }
  }
  const lineBreak = /\r\n?|[\n\u2028\u2029]/;
  const lineBreakG = new RegExp(lineBreak.source, "g");
  function isNewLine(code) {
    switch (code) {
      case 10:
      case 13:
      case 8232:
      case 8233:
        return true;
      default:
        return false;
    }
  }
  const skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
  const skipWhiteSpaceInLine = /(?:[^\S\n\r\u2028\u2029]|\/\/.*|\/\*.*?\*\/)*/g;
  const skipWhiteSpaceToLineBreak = new RegExp(
    "(?=(" +
      skipWhiteSpaceInLine.source +
      "))\\1" +
      /(?=[\n\r\u2028\u2029]|\/\*(?!.*?\*\/)|$)/.source,
    "y",
  );
  function isWhitespace(code) {
    switch (code) {
      case 9:
      case 11:
      case 12:
      case 32:
      case 160:
      case 5760:
      case 8192:
      case 8193:
      case 8194:
      case 8195:
      case 8196:
      case 8197:
      case 8198:
      case 8199:
      case 8200:
      case 8201:
      case 8202:
      case 8239:
      case 8287:
      case 12288:
      case 65279:
        return true;
      default:
        return false;
    }
  }
  class State {
    constructor() {
      this.flags = 1024;
      this.curLine = void 0;
      this.lineStart = void 0;
      this.startLoc = void 0;
      this.endLoc = void 0;
      this.errors = [];
      this.potentialArrowAt = -1;
      this.noArrowAt = [];
      this.noArrowParamsConversionAt = [];
      this.topicContext = { maxNumOfResolvableTopics: 0, maxTopicIndex: null };
      this.labels = [];
      this.commentsLen = 0;
      this.commentStack = [];
      this.pos = 0;
      this.type = 139;
      this.value = null;
      this.start = 0;
      this.end = 0;
      this.lastTokEndLoc = null;
      this.lastTokStartLoc = null;
      this.context = [types.brace];
      this.firstInvalidTemplateEscapePos = null;
      this.strictErrors = new Map();
      this.tokensLength = 0;
    }
    get strict() {
      return (this.flags & 1) > 0;
    }
    set strict(value) {
      if (value) {
        this.flags |= 1;
      } else {
        this.flags &= ~1;
      }
    }
    init({
      strictMode: strictMode,
      sourceType: sourceType,
      startLine: startLine,
      startColumn: startColumn,
    }) {
      this.strict =
        strictMode === false
          ? false
          : strictMode === true
            ? true
            : sourceType === "module";
      this.curLine = startLine;
      this.lineStart = -startColumn;
      this.startLoc = this.endLoc = new Position(startLine, startColumn, 0);
    }
    get maybeInArrowParameters() {
      return (this.flags & 2) > 0;
    }
    set maybeInArrowParameters(value) {
      if (value) {
        this.flags |= 2;
      } else {
        this.flags &= ~2;
      }
    }
    get inType() {
      return (this.flags & 4) > 0;
    }
    set inType(value) {
      if (value) {
        this.flags |= 4;
      } else {
        this.flags &= ~4;
      }
    }
    get noAnonFunctionType() {
      return (this.flags & 8) > 0;
    }
    set noAnonFunctionType(value) {
      if (value) {
        this.flags |= 8;
      } else {
        this.flags &= ~8;
      }
    }
    get hasFlowComment() {
      return (this.flags & 16) > 0;
    }
    set hasFlowComment(value) {
      if (value) {
        this.flags |= 16;
      } else {
        this.flags &= ~16;
      }
    }
    get isAmbientContext() {
      return (this.flags & 32) > 0;
    }
    set isAmbientContext(value) {
      if (value) {
        this.flags |= 32;
      } else {
        this.flags &= ~32;
      }
    }
    get inAbstractClass() {
      return (this.flags & 64) > 0;
    }
    set inAbstractClass(value) {
      if (value) {
        this.flags |= 64;
      } else {
        this.flags &= ~64;
      }
    }
    get inDisallowConditionalTypesContext() {
      return (this.flags & 128) > 0;
    }
    set inDisallowConditionalTypesContext(value) {
      if (value) {
        this.flags |= 128;
      } else {
        this.flags &= ~128;
      }
    }
    get soloAwait() {
      return (this.flags & 256) > 0;
    }
    set soloAwait(value) {
      if (value) {
        this.flags |= 256;
      } else {
        this.flags &= ~256;
      }
    }
    get inFSharpPipelineDirectBody() {
      return (this.flags & 512) > 0;
    }
    set inFSharpPipelineDirectBody(value) {
      if (value) {
        this.flags |= 512;
      } else {
        this.flags &= ~512;
      }
    }
    get canStartJSXElement() {
      return (this.flags & 1024) > 0;
    }
    set canStartJSXElement(value) {
      if (value) {
        this.flags |= 1024;
      } else {
        this.flags &= ~1024;
      }
    }
    get containsEsc() {
      return (this.flags & 2048) > 0;
    }
    set containsEsc(value) {
      if (value) {
        this.flags |= 2048;
      } else {
        this.flags &= ~2048;
      }
    }
    curPosition() {
      return new Position(this.curLine, this.pos - this.lineStart, this.pos);
    }
    clone() {
      const state = new State();
      state.flags = this.flags;
      state.curLine = this.curLine;
      state.lineStart = this.lineStart;
      state.startLoc = this.startLoc;
      state.endLoc = this.endLoc;
      state.errors = this.errors.slice();
      state.potentialArrowAt = this.potentialArrowAt;
      state.noArrowAt = this.noArrowAt.slice();
      state.noArrowParamsConversionAt = this.noArrowParamsConversionAt.slice();
      state.topicContext = this.topicContext;
      state.labels = this.labels.slice();
      state.commentsLen = this.commentsLen;
      state.commentStack = this.commentStack.slice();
      state.pos = this.pos;
      state.type = this.type;
      state.value = this.value;
      state.start = this.start;
      state.end = this.end;
      state.lastTokEndLoc = this.lastTokEndLoc;
      state.lastTokStartLoc = this.lastTokStartLoc;
      state.context = this.context.slice();
      state.firstInvalidTemplateEscapePos = this.firstInvalidTemplateEscapePos;
      state.strictErrors = this.strictErrors;
      state.tokensLength = this.tokensLength;
      return state;
    }
  }
  var _isDigit = function isDigit(code) {
    return code >= 48 && code <= 57;
  };
  const forbiddenNumericSeparatorSiblings = {
    decBinOct: new Set([46, 66, 69, 79, 95, 98, 101, 111]),
    hex: new Set([46, 88, 95, 120]),
  };
  const isAllowedNumericSeparatorSibling = {
    bin: (ch) => ch === 48 || ch === 49,
    oct: (ch) => ch >= 48 && ch <= 55,
    dec: (ch) => ch >= 48 && ch <= 57,
    hex: (ch) =>
      (ch >= 48 && ch <= 57) ||
      (ch >= 65 && ch <= 70) ||
      (ch >= 97 && ch <= 102),
  };
  function readStringContents(type, input, pos, lineStart, curLine, errors) {
    const initialPos = pos;
    const initialLineStart = lineStart;
    const initialCurLine = curLine;
    let out = "";
    let firstInvalidLoc = null;
    let chunkStart = pos;
    const { length: length } = input;
    for (;;) {
      if (pos >= length) {
        errors.unterminated(initialPos, initialLineStart, initialCurLine);
        out += input.slice(chunkStart, pos);
        break;
      }
      const ch = input.charCodeAt(pos);
      if (isStringEnd(type, ch, input, pos)) {
        out += input.slice(chunkStart, pos);
        break;
      }
      if (ch === 92) {
        out += input.slice(chunkStart, pos);
        const res = readEscapedChar(
          input,
          pos,
          lineStart,
          curLine,
          type === "template",
          errors,
        );
        if (res.ch === null && !firstInvalidLoc) {
          firstInvalidLoc = {
            pos: pos,
            lineStart: lineStart,
            curLine: curLine,
          };
        } else {
          out += res.ch;
        }
        ({ pos: pos, lineStart: lineStart, curLine: curLine } = res);
        chunkStart = pos;
      } else if (ch === 8232 || ch === 8233) {
        ++pos;
        ++curLine;
        lineStart = pos;
      } else if (ch === 10 || ch === 13) {
        if (type === "template") {
          out += input.slice(chunkStart, pos) + "\n";
          ++pos;
          if (ch === 13 && input.charCodeAt(pos) === 10) {
            ++pos;
          }
          ++curLine;
          chunkStart = lineStart = pos;
        } else {
          errors.unterminated(initialPos, initialLineStart, initialCurLine);
        }
      } else {
        ++pos;
      }
    }
    return {
      pos: pos,
      str: out,
      firstInvalidLoc: firstInvalidLoc,
      lineStart: lineStart,
      curLine: curLine,
      containsInvalid: !!firstInvalidLoc,
    };
  }
  function isStringEnd(type, ch, input, pos) {
    if (type === "template") {
      return ch === 96 || (ch === 36 && input.charCodeAt(pos + 1) === 123);
    }
    return ch === (type === "double" ? 34 : 39);
  }
  function readEscapedChar(input, pos, lineStart, curLine, inTemplate, errors) {
    const throwOnInvalid = !inTemplate;
    pos++;
    const res = (ch) => ({
      pos: pos,
      ch: ch,
      lineStart: lineStart,
      curLine: curLine,
    });
    const ch = input.charCodeAt(pos++);
    switch (ch) {
      case 110:
        return res("\n");
      case 114:
        return res("\r");
      case 120: {
        let code;
        ({ code: code, pos: pos } = readHexChar(
          input,
          pos,
          lineStart,
          curLine,
          2,
          false,
          throwOnInvalid,
          errors,
        ));
        return res(code === null ? null : String.fromCharCode(code));
      }
      case 117: {
        let code;
        ({ code: code, pos: pos } = readCodePoint(
          input,
          pos,
          lineStart,
          curLine,
          throwOnInvalid,
          errors,
        ));
        return res(code === null ? null : String.fromCodePoint(code));
      }
      case 116:
        return res("\t");
      case 98:
        return res("\b");
      case 118:
        return res("\v");
      case 102:
        return res("\f");
      case 13:
        if (input.charCodeAt(pos) === 10) {
          ++pos;
        }
      case 10:
        lineStart = pos;
        ++curLine;
      case 8232:
      case 8233:
        return res("");
      case 56:
      case 57:
        if (inTemplate) {
          return res(null);
        } else {
          errors.strictNumericEscape(pos - 1, lineStart, curLine);
        }
      default:
        if (ch >= 48 && ch <= 55) {
          const startPos = pos - 1;
          const match = input.slice(startPos, pos + 2).match(/^[0-7]+/);
          let octalStr = match[0];
          let octal = parseInt(octalStr, 8);
          if (octal > 255) {
            octalStr = octalStr.slice(0, -1);
            octal = parseInt(octalStr, 8);
          }
          pos += octalStr.length - 1;
          const next = input.charCodeAt(pos);
          if (octalStr !== "0" || next === 56 || next === 57) {
            if (inTemplate) {
              return res(null);
            } else {
              errors.strictNumericEscape(startPos, lineStart, curLine);
            }
          }
          return res(String.fromCharCode(octal));
        }
        return res(String.fromCharCode(ch));
    }
  }
  function readHexChar(
    input,
    pos,
    lineStart,
    curLine,
    len,
    forceLen,
    throwOnInvalid,
    errors,
  ) {
    const initialPos = pos;
    let n;
    ({ n: n, pos: pos } = readInt(
      input,
      pos,
      lineStart,
      curLine,
      16,
      len,
      forceLen,
      false,
      errors,
      !throwOnInvalid,
    ));
    if (n === null) {
      if (throwOnInvalid) {
        errors.invalidEscapeSequence(initialPos, lineStart, curLine);
      } else {
        pos = initialPos - 1;
      }
    }
    return { code: n, pos: pos };
  }
  function readInt(
    input,
    pos,
    lineStart,
    curLine,
    radix,
    len,
    forceLen,
    allowNumSeparator,
    errors,
    bailOnError,
  ) {
    const start = pos;
    const forbiddenSiblings =
      radix === 16
        ? forbiddenNumericSeparatorSiblings.hex
        : forbiddenNumericSeparatorSiblings.decBinOct;
    const isAllowedSibling =
      radix === 16
        ? isAllowedNumericSeparatorSibling.hex
        : radix === 10
          ? isAllowedNumericSeparatorSibling.dec
          : radix === 8
            ? isAllowedNumericSeparatorSibling.oct
            : isAllowedNumericSeparatorSibling.bin;
    let invalid = false;
    let total = 0;
    for (let i = 0, e = len == null ? Infinity : len; i < e; ++i) {
      const code = input.charCodeAt(pos);
      let val;
      if (code === 95 && allowNumSeparator !== "bail") {
        const prev = input.charCodeAt(pos - 1);
        const next = input.charCodeAt(pos + 1);
        if (!allowNumSeparator) {
          if (bailOnError) return { n: null, pos: pos };
          errors.numericSeparatorInEscapeSequence(pos, lineStart, curLine);
        } else if (
          Number.isNaN(next) ||
          !isAllowedSibling(next) ||
          forbiddenSiblings.has(prev) ||
          forbiddenSiblings.has(next)
        ) {
          if (bailOnError) return { n: null, pos: pos };
          errors.unexpectedNumericSeparator(pos, lineStart, curLine);
        }
        ++pos;
        continue;
      }
      if (code >= 97) {
        val = code - 97 + 10;
      } else if (code >= 65) {
        val = code - 65 + 10;
      } else if (_isDigit(code)) {
        val = code - 48;
      } else {
        val = Infinity;
      }
      if (val >= radix) {
        if (val <= 9 && bailOnError) {
          return { n: null, pos: pos };
        } else if (
          val <= 9 &&
          errors.invalidDigit(pos, lineStart, curLine, radix)
        ) {
          val = 0;
        } else if (forceLen) {
          val = 0;
          invalid = true;
        } else {
          break;
        }
      }
      ++pos;
      total = total * radix + val;
    }
    if (pos === start || (len != null && pos - start !== len) || invalid) {
      return { n: null, pos: pos };
    }
    return { n: total, pos: pos };
  }
  function readCodePoint(
    input,
    pos,
    lineStart,
    curLine,
    throwOnInvalid,
    errors,
  ) {
    const ch = input.charCodeAt(pos);
    let code;
    if (ch === 123) {
      ++pos;
      ({ code: code, pos: pos } = readHexChar(
        input,
        pos,
        lineStart,
        curLine,
        input.indexOf("}", pos) - pos,
        true,
        throwOnInvalid,
        errors,
      ));
      ++pos;
      if (code !== null && code > 1114111) {
        if (throwOnInvalid) {
          errors.invalidCodePoint(pos, lineStart, curLine);
        } else {
          return { code: null, pos: pos };
        }
      }
    } else {
      ({ code: code, pos: pos } = readHexChar(
        input,
        pos,
        lineStart,
        curLine,
        4,
        false,
        throwOnInvalid,
        errors,
      ));
    }
    return { code: code, pos: pos };
  }
  function buildPosition(pos, lineStart, curLine) {
    return new Position(curLine, pos - lineStart, pos);
  }
  const VALID_REGEX_FLAGS = new Set([103, 109, 115, 105, 121, 117, 100, 118]);
  class Token {
    constructor(state) {
      this.type = state.type;
      this.value = state.value;
      this.start = state.start;
      this.end = state.end;
      this.loc = new SourceLocation(state.startLoc, state.endLoc);
    }
  }
  class Tokenizer extends CommentsParser {
    constructor(options, input) {
      super();
      this.isLookahead = void 0;
      this.tokens = [];
      this.errorHandlers_readInt = {
        invalidDigit: (pos, lineStart, curLine, radix) => {
          if (!this.options.errorRecovery) return false;
          this.raise(
            Errors.InvalidDigit,
            buildPosition(pos, lineStart, curLine),
            { radix: radix },
          );
          return true;
        },
        numericSeparatorInEscapeSequence: this.errorBuilder(
          Errors.NumericSeparatorInEscapeSequence,
        ),
        unexpectedNumericSeparator: this.errorBuilder(
          Errors.UnexpectedNumericSeparator,
        ),
      };
      this.errorHandlers_readCodePoint = Object.assign(
        {},
        this.errorHandlers_readInt,
        {
          invalidEscapeSequence: this.errorBuilder(
            Errors.InvalidEscapeSequence,
          ),
          invalidCodePoint: this.errorBuilder(Errors.InvalidCodePoint),
        },
      );
      this.errorHandlers_readStringContents_string = Object.assign(
        {},
        this.errorHandlers_readCodePoint,
        {
          strictNumericEscape: (pos, lineStart, curLine) => {
            this.recordStrictModeErrors(
              Errors.StrictNumericEscape,
              buildPosition(pos, lineStart, curLine),
            );
          },
          unterminated: (pos, lineStart, curLine) => {
            throw this.raise(
              Errors.UnterminatedString,
              buildPosition(pos - 1, lineStart, curLine),
            );
          },
        },
      );
      this.errorHandlers_readStringContents_template = Object.assign(
        {},
        this.errorHandlers_readCodePoint,
        {
          strictNumericEscape: this.errorBuilder(Errors.StrictNumericEscape),
          unterminated: (pos, lineStart, curLine) => {
            throw this.raise(
              Errors.UnterminatedTemplate,
              buildPosition(pos, lineStart, curLine),
            );
          },
        },
      );
      this.state = new State();
      this.state.init(options);
      this.input = input;
      this.length = input.length;
      this.comments = [];
      this.isLookahead = false;
    }
    pushToken(token) {
      this.tokens.length = this.state.tokensLength;
      this.tokens.push(token);
      ++this.state.tokensLength;
    }
    next() {
      this.checkKeywordEscapes();
      if (this.options.tokens) {
        this.pushToken(new Token(this.state));
      }
      this.state.lastTokEndLoc = this.state.endLoc;
      this.state.lastTokStartLoc = this.state.startLoc;
      this.nextToken();
    }
    eat(type) {
      if (this.match(type)) {
        this.next();
        return true;
      } else {
        return false;
      }
    }
    match(type) {
      return this.state.type === type;
    }
    createLookaheadState(state) {
      return {
        pos: state.pos,
        value: null,
        type: state.type,
        start: state.start,
        end: state.end,
        context: [this.curContext()],
        inType: state.inType,
        startLoc: state.startLoc,
        lastTokEndLoc: state.lastTokEndLoc,
        curLine: state.curLine,
        lineStart: state.lineStart,
        curPosition: state.curPosition,
      };
    }
    lookahead() {
      const old = this.state;
      this.state = this.createLookaheadState(old);
      this.isLookahead = true;
      this.nextToken();
      this.isLookahead = false;
      const curr = this.state;
      this.state = old;
      return curr;
    }
    nextTokenStart() {
      return this.nextTokenStartSince(this.state.pos);
    }
    nextTokenStartSince(pos) {
      skipWhiteSpace.lastIndex = pos;
      return skipWhiteSpace.test(this.input) ? skipWhiteSpace.lastIndex : pos;
    }
    lookaheadCharCode() {
      return this.input.charCodeAt(this.nextTokenStart());
    }
    nextTokenInLineStart() {
      return this.nextTokenInLineStartSince(this.state.pos);
    }
    nextTokenInLineStartSince(pos) {
      skipWhiteSpaceInLine.lastIndex = pos;
      return skipWhiteSpaceInLine.test(this.input)
        ? skipWhiteSpaceInLine.lastIndex
        : pos;
    }
    lookaheadInLineCharCode() {
      return this.input.charCodeAt(this.nextTokenInLineStart());
    }
    codePointAtPos(pos) {
      let cp = this.input.charCodeAt(pos);
      if ((cp & 64512) === 55296 && ++pos < this.input.length) {
        const trail = this.input.charCodeAt(pos);
        if ((trail & 64512) === 56320) {
          cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
        }
      }
      return cp;
    }
    setStrict(strict) {
      this.state.strict = strict;
      if (strict) {
        this.state.strictErrors.forEach(([toParseError, at]) =>
          this.raise(toParseError, at),
        );
        this.state.strictErrors.clear();
      }
    }
    curContext() {
      return this.state.context[this.state.context.length - 1];
    }
    nextToken() {
      this.skipSpace();
      this.state.start = this.state.pos;
      if (!this.isLookahead) this.state.startLoc = this.state.curPosition();
      if (this.state.pos >= this.length) {
        this.finishToken(139);
        return;
      }
      this.getTokenFromCode(this.codePointAtPos(this.state.pos));
    }
    skipBlockComment(commentEnd) {
      let startLoc;
      if (!this.isLookahead) startLoc = this.state.curPosition();
      const start = this.state.pos;
      const end = this.input.indexOf(commentEnd, start + 2);
      if (end === -1) {
        throw this.raise(Errors.UnterminatedComment, this.state.curPosition());
      }
      this.state.pos = end + commentEnd.length;
      lineBreakG.lastIndex = start + 2;
      while (lineBreakG.test(this.input) && lineBreakG.lastIndex <= end) {
        ++this.state.curLine;
        this.state.lineStart = lineBreakG.lastIndex;
      }
      if (this.isLookahead) return;
      const comment = {
        type: "CommentBlock",
        value: this.input.slice(start + 2, end),
        start: start,
        end: end + commentEnd.length,
        loc: new SourceLocation(startLoc, this.state.curPosition()),
      };
      if (this.options.tokens) this.pushToken(comment);
      return comment;
    }
    skipLineComment(startSkip) {
      const start = this.state.pos;
      let startLoc;
      if (!this.isLookahead) startLoc = this.state.curPosition();
      let ch = this.input.charCodeAt((this.state.pos += startSkip));
      if (this.state.pos < this.length) {
        while (!isNewLine(ch) && ++this.state.pos < this.length) {
          ch = this.input.charCodeAt(this.state.pos);
        }
      }
      if (this.isLookahead) return;
      const end = this.state.pos;
      const value = this.input.slice(start + startSkip, end);
      const comment = {
        type: "CommentLine",
        value: value,
        start: start,
        end: end,
        loc: new SourceLocation(startLoc, this.state.curPosition()),
      };
      if (this.options.tokens) this.pushToken(comment);
      return comment;
    }
    skipSpace() {
      const spaceStart = this.state.pos;
      const comments = [];
      loop: while (this.state.pos < this.length) {
        const ch = this.input.charCodeAt(this.state.pos);
        switch (ch) {
          case 32:
          case 160:
          case 9:
            ++this.state.pos;
            break;
          case 13:
            if (this.input.charCodeAt(this.state.pos + 1) === 10) {
              ++this.state.pos;
            }
          case 10:
          case 8232:
          case 8233:
            ++this.state.pos;
            ++this.state.curLine;
            this.state.lineStart = this.state.pos;
            break;
          case 47:
            switch (this.input.charCodeAt(this.state.pos + 1)) {
              case 42: {
                const comment = this.skipBlockComment("*/");
                if (comment !== undefined) {
                  this.addComment(comment);
                  if (this.options.attachComment) comments.push(comment);
                }
                break;
              }
              case 47: {
                const comment = this.skipLineComment(2);
                if (comment !== undefined) {
                  this.addComment(comment);
                  if (this.options.attachComment) comments.push(comment);
                }
                break;
              }
              default:
                break loop;
            }
            break;
          default:
            if (isWhitespace(ch)) {
              ++this.state.pos;
            } else if (ch === 45 && !this.inModule && this.options.annexB) {
              const pos = this.state.pos;
              if (
                this.input.charCodeAt(pos + 1) === 45 &&
                this.input.charCodeAt(pos + 2) === 62 &&
                (spaceStart === 0 || this.state.lineStart > spaceStart)
              ) {
                const comment = this.skipLineComment(3);
                if (comment !== undefined) {
                  this.addComment(comment);
                  if (this.options.attachComment) comments.push(comment);
                }
              } else {
                break loop;
              }
            } else if (ch === 60 && !this.inModule && this.options.annexB) {
              const pos = this.state.pos;
              if (
                this.input.charCodeAt(pos + 1) === 33 &&
                this.input.charCodeAt(pos + 2) === 45 &&
                this.input.charCodeAt(pos + 3) === 45
              ) {
                const comment = this.skipLineComment(4);
                if (comment !== undefined) {
                  this.addComment(comment);
                  if (this.options.attachComment) comments.push(comment);
                }
              } else {
                break loop;
              }
            } else {
              break loop;
            }
        }
      }
      if (comments.length > 0) {
        const end = this.state.pos;
        const commentWhitespace = {
          start: spaceStart,
          end: end,
          comments: comments,
          leadingNode: null,
          trailingNode: null,
          containingNode: null,
        };
        this.state.commentStack.push(commentWhitespace);
      }
    }
    finishToken(type, val) {
      this.state.end = this.state.pos;
      this.state.endLoc = this.state.curPosition();
      const prevType = this.state.type;
      this.state.type = type;
      this.state.value = val;
      if (!this.isLookahead) {
        this.updateContext(prevType);
      }
    }
    replaceToken(type) {
      this.state.type = type;
      this.updateContext();
    }
    readToken_numberSign() {
      if (this.state.pos === 0 && this.readToken_interpreter()) {
        return;
      }
      const nextPos = this.state.pos + 1;
      const next = this.codePointAtPos(nextPos);
      if (next >= 48 && next <= 57) {
        throw this.raise(
          Errors.UnexpectedDigitAfterHash,
          this.state.curPosition(),
        );
      }
      if (next === 123 || (next === 91 && this.hasPlugin("recordAndTuple"))) {
        this.expectPlugin("recordAndTuple");
        if (this.getPluginOption("recordAndTuple", "syntaxType") === "bar") {
          throw this.raise(
            next === 123
              ? Errors.RecordExpressionHashIncorrectStartSyntaxType
              : Errors.TupleExpressionHashIncorrectStartSyntaxType,
            this.state.curPosition(),
          );
        }
        this.state.pos += 2;
        if (next === 123) {
          this.finishToken(7);
        } else {
          this.finishToken(1);
        }
      } else if (isIdentifierStart(next)) {
        ++this.state.pos;
        this.finishToken(138, this.readWord1(next));
      } else if (next === 92) {
        ++this.state.pos;
        this.finishToken(138, this.readWord1());
      } else {
        this.finishOp(27, 1);
      }
    }
    readToken_dot() {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next >= 48 && next <= 57) {
        this.readNumber(true);
        return;
      }
      if (next === 46 && this.input.charCodeAt(this.state.pos + 2) === 46) {
        this.state.pos += 3;
        this.finishToken(21);
      } else {
        ++this.state.pos;
        this.finishToken(16);
      }
    }
    readToken_slash() {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next === 61) {
        this.finishOp(31, 2);
      } else {
        this.finishOp(56, 1);
      }
    }
    readToken_interpreter() {
      if (this.state.pos !== 0 || this.length < 2) return false;
      let ch = this.input.charCodeAt(this.state.pos + 1);
      if (ch !== 33) return false;
      const start = this.state.pos;
      this.state.pos += 1;
      while (!isNewLine(ch) && ++this.state.pos < this.length) {
        ch = this.input.charCodeAt(this.state.pos);
      }
      const value = this.input.slice(start + 2, this.state.pos);
      this.finishToken(28, value);
      return true;
    }
    readToken_mult_modulo(code) {
      let type = code === 42 ? 55 : 54;
      let width = 1;
      let next = this.input.charCodeAt(this.state.pos + 1);
      if (code === 42 && next === 42) {
        width++;
        next = this.input.charCodeAt(this.state.pos + 2);
        type = 57;
      }
      if (next === 61 && !this.state.inType) {
        width++;
        type = code === 37 ? 33 : 30;
      }
      this.finishOp(type, width);
    }
    readToken_pipe_amp(code) {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next === code) {
        if (this.input.charCodeAt(this.state.pos + 2) === 61) {
          this.finishOp(30, 3);
        } else {
          this.finishOp(code === 124 ? 41 : 42, 2);
        }
        return;
      }
      if (code === 124) {
        if (next === 62) {
          this.finishOp(39, 2);
          return;
        }
        if (this.hasPlugin("recordAndTuple") && next === 125) {
          if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
            throw this.raise(
              Errors.RecordExpressionBarIncorrectEndSyntaxType,
              this.state.curPosition(),
            );
          }
          this.state.pos += 2;
          this.finishToken(9);
          return;
        }
        if (this.hasPlugin("recordAndTuple") && next === 93) {
          if (this.getPluginOption("recordAndTuple", "syntaxType") !== "bar") {
            throw this.raise(
              Errors.TupleExpressionBarIncorrectEndSyntaxType,
              this.state.curPosition(),
            );
          }
          this.state.pos += 2;
          this.finishToken(4);
          return;
        }
      }
      if (next === 61) {
        this.finishOp(30, 2);
        return;
      }
      this.finishOp(code === 124 ? 43 : 45, 1);
    }
    readToken_caret() {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next === 61 && !this.state.inType) {
        this.finishOp(32, 2);
      } else if (
        next === 94 &&
        this.hasPlugin([
          "pipelineOperator",
          { proposal: "hack", topicToken: "^^" },
        ])
      ) {
        this.finishOp(37, 2);
        const lookaheadCh = this.input.codePointAt(this.state.pos);
        if (lookaheadCh === 94) {
          this.unexpected();
        }
      } else {
        this.finishOp(44, 1);
      }
    }
    readToken_atSign() {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (
        next === 64 &&
        this.hasPlugin([
          "pipelineOperator",
          { proposal: "hack", topicToken: "@@" },
        ])
      ) {
        this.finishOp(38, 2);
      } else {
        this.finishOp(26, 1);
      }
    }
    readToken_plus_min(code) {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next === code) {
        this.finishOp(34, 2);
        return;
      }
      if (next === 61) {
        this.finishOp(30, 2);
      } else {
        this.finishOp(53, 1);
      }
    }
    readToken_lt() {
      const { pos: pos } = this.state;
      const next = this.input.charCodeAt(pos + 1);
      if (next === 60) {
        if (this.input.charCodeAt(pos + 2) === 61) {
          this.finishOp(30, 3);
          return;
        }
        this.finishOp(51, 2);
        return;
      }
      if (next === 61) {
        this.finishOp(49, 2);
        return;
      }
      this.finishOp(47, 1);
    }
    readToken_gt() {
      const { pos: pos } = this.state;
      const next = this.input.charCodeAt(pos + 1);
      if (next === 62) {
        const size = this.input.charCodeAt(pos + 2) === 62 ? 3 : 2;
        if (this.input.charCodeAt(pos + size) === 61) {
          this.finishOp(30, size + 1);
          return;
        }
        this.finishOp(52, size);
        return;
      }
      if (next === 61) {
        this.finishOp(49, 2);
        return;
      }
      this.finishOp(48, 1);
    }
    readToken_eq_excl(code) {
      const next = this.input.charCodeAt(this.state.pos + 1);
      if (next === 61) {
        this.finishOp(
          46,
          this.input.charCodeAt(this.state.pos + 2) === 61 ? 3 : 2,
        );
        return;
      }
      if (code === 61 && next === 62) {
        this.state.pos += 2;
        this.finishToken(19);
        return;
      }
      this.finishOp(code === 61 ? 29 : 35, 1);
    }
    readToken_question() {
      const next = this.input.charCodeAt(this.state.pos + 1);
      const next2 = this.input.charCodeAt(this.state.pos + 2);
      if (next === 63) {
        if (next2 === 61) {
          this.finishOp(30, 3);
        } else {
          this.finishOp(40, 2);
        }
      } else if (next === 46 && !(next2 >= 48 && next2 <= 57)) {
        this.state.pos += 2;
        this.finishToken(18);
      } else {
        ++this.state.pos;
        this.finishToken(17);
      }
    }
    getTokenFromCode(code) {
      switch (code) {
        case 46:
          this.readToken_dot();
          return;
        case 40:
          ++this.state.pos;
          this.finishToken(10);
          return;
        case 41:
          ++this.state.pos;
          this.finishToken(11);
          return;
        case 59:
          ++this.state.pos;
          this.finishToken(13);
          return;
        case 44:
          ++this.state.pos;
          this.finishToken(12);
          return;
        case 91:
          if (
            this.hasPlugin("recordAndTuple") &&
            this.input.charCodeAt(this.state.pos + 1) === 124
          ) {
            if (
              this.getPluginOption("recordAndTuple", "syntaxType") !== "bar"
            ) {
              throw this.raise(
                Errors.TupleExpressionBarIncorrectStartSyntaxType,
                this.state.curPosition(),
              );
            }
            this.state.pos += 2;
            this.finishToken(2);
          } else {
            ++this.state.pos;
            this.finishToken(0);
          }
          return;
        case 93:
          ++this.state.pos;
          this.finishToken(3);
          return;
        case 123:
          if (
            this.hasPlugin("recordAndTuple") &&
            this.input.charCodeAt(this.state.pos + 1) === 124
          ) {
            if (
              this.getPluginOption("recordAndTuple", "syntaxType") !== "bar"
            ) {
              throw this.raise(
                Errors.RecordExpressionBarIncorrectStartSyntaxType,
                this.state.curPosition(),
              );
            }
            this.state.pos += 2;
            this.finishToken(6);
          } else {
            ++this.state.pos;
            this.finishToken(5);
          }
          return;
        case 125:
          ++this.state.pos;
          this.finishToken(8);
          return;
        case 58:
          if (
            this.hasPlugin("functionBind") &&
            this.input.charCodeAt(this.state.pos + 1) === 58
          ) {
            this.finishOp(15, 2);
          } else {
            ++this.state.pos;
            this.finishToken(14);
          }
          return;
        case 63:
          this.readToken_question();
          return;
        case 96:
          this.readTemplateToken();
          return;
        case 48: {
          const next = this.input.charCodeAt(this.state.pos + 1);
          if (next === 120 || next === 88) {
            this.readRadixNumber(16);
            return;
          }
          if (next === 111 || next === 79) {
            this.readRadixNumber(8);
            return;
          }
          if (next === 98 || next === 66) {
            this.readRadixNumber(2);
            return;
          }
        }
        case 49:
        case 50:
        case 51:
        case 52:
        case 53:
        case 54:
        case 55:
        case 56:
        case 57:
          this.readNumber(false);
          return;
        case 34:
        case 39:
          this.readString(code);
          return;
        case 47:
          this.readToken_slash();
          return;
        case 37:
        case 42:
          this.readToken_mult_modulo(code);
          return;
        case 124:
        case 38:
          this.readToken_pipe_amp(code);
          return;
        case 94:
          this.readToken_caret();
          return;
        case 43:
        case 45:
          this.readToken_plus_min(code);
          return;
        case 60:
          this.readToken_lt();
          return;
        case 62:
          this.readToken_gt();
          return;
        case 61:
        case 33:
          this.readToken_eq_excl(code);
          return;
        case 126:
          this.finishOp(36, 1);
          return;
        case 64:
          this.readToken_atSign();
          return;
        case 35:
          this.readToken_numberSign();
          return;
        case 92:
          this.readWord();
          return;
        default:
          if (isIdentifierStart(code)) {
            this.readWord(code);
            return;
          }
      }
      throw this.raise(
        Errors.InvalidOrUnexpectedToken,
        this.state.curPosition(),
        { unexpected: String.fromCodePoint(code) },
      );
    }
    finishOp(type, size) {
      const str = this.input.slice(this.state.pos, this.state.pos + size);
      this.state.pos += size;
      this.finishToken(type, str);
    }
    readRegexp() {
      const startLoc = this.state.startLoc;
      const start = this.state.start + 1;
      let escaped, inClass;
      let { pos: pos } = this.state;
      for (; ; ++pos) {
        if (pos >= this.length) {
          throw this.raise(
            Errors.UnterminatedRegExp,
            createPositionWithColumnOffset(startLoc, 1),
          );
        }
        const ch = this.input.charCodeAt(pos);
        if (isNewLine(ch)) {
          throw this.raise(
            Errors.UnterminatedRegExp,
            createPositionWithColumnOffset(startLoc, 1),
          );
        }
        if (escaped) {
          escaped = false;
        } else {
          if (ch === 91) {
            inClass = true;
          } else if (ch === 93 && inClass) {
            inClass = false;
          } else if (ch === 47 && !inClass) {
            break;
          }
          escaped = ch === 92;
        }
      }
      const content = this.input.slice(start, pos);
      ++pos;
      let mods = "";
      const nextPos = () =>
        createPositionWithColumnOffset(startLoc, pos + 2 - start);
      while (pos < this.length) {
        const cp = this.codePointAtPos(pos);
        const char = String.fromCharCode(cp);
        if (VALID_REGEX_FLAGS.has(cp)) {
          if (cp === 118) {
            if (mods.includes("u")) {
              this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
            }
          } else if (cp === 117) {
            if (mods.includes("v")) {
              this.raise(Errors.IncompatibleRegExpUVFlags, nextPos());
            }
          }
          if (mods.includes(char)) {
            this.raise(Errors.DuplicateRegExpFlags, nextPos());
          }
        } else if (isIdentifierChar(cp) || cp === 92) {
          this.raise(Errors.MalformedRegExpFlags, nextPos());
        } else {
          break;
        }
        ++pos;
        mods += char;
      }
      this.state.pos = pos;
      this.finishToken(137, { pattern: content, flags: mods });
    }
    readInt(radix, len, forceLen = false, allowNumSeparator = true) {
      const { n: n, pos: pos } = readInt(
        this.input,
        this.state.pos,
        this.state.lineStart,
        this.state.curLine,
        radix,
        len,
        forceLen,
        allowNumSeparator,
        this.errorHandlers_readInt,
        false,
      );
      this.state.pos = pos;
      return n;
    }
    readRadixNumber(radix) {
      const startLoc = this.state.curPosition();
      let isBigInt = false;
      this.state.pos += 2;
      const val = this.readInt(radix);
      if (val == null) {
        this.raise(
          Errors.InvalidDigit,
          createPositionWithColumnOffset(startLoc, 2),
          { radix: radix },
        );
      }
      const next = this.input.charCodeAt(this.state.pos);
      if (next === 110) {
        ++this.state.pos;
        isBigInt = true;
      } else if (next === 109) {
        throw this.raise(Errors.InvalidDecimal, startLoc);
      }
      if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
        throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
      }
      if (isBigInt) {
        const str = this.input
          .slice(startLoc.index, this.state.pos)
          .replace(/[_n]/g, "");
        this.finishToken(135, str);
        return;
      }
      this.finishToken(134, val);
    }
    readNumber(startsWithDot) {
      const start = this.state.pos;
      const startLoc = this.state.curPosition();
      let isFloat = false;
      let isBigInt = false;
      let isDecimal = false;
      let hasExponent = false;
      let isOctal = false;
      if (!startsWithDot && this.readInt(10) === null) {
        this.raise(Errors.InvalidNumber, this.state.curPosition());
      }
      const hasLeadingZero =
        this.state.pos - start >= 2 && this.input.charCodeAt(start) === 48;
      if (hasLeadingZero) {
        const integer = this.input.slice(start, this.state.pos);
        this.recordStrictModeErrors(Errors.StrictOctalLiteral, startLoc);
        if (!this.state.strict) {
          const underscorePos = integer.indexOf("_");
          if (underscorePos > 0) {
            this.raise(
              Errors.ZeroDigitNumericSeparator,
              createPositionWithColumnOffset(startLoc, underscorePos),
            );
          }
        }
        isOctal = hasLeadingZero && !/[89]/.test(integer);
      }
      let next = this.input.charCodeAt(this.state.pos);
      if (next === 46 && !isOctal) {
        ++this.state.pos;
        this.readInt(10);
        isFloat = true;
        next = this.input.charCodeAt(this.state.pos);
      }
      if ((next === 69 || next === 101) && !isOctal) {
        next = this.input.charCodeAt(++this.state.pos);
        if (next === 43 || next === 45) {
          ++this.state.pos;
        }
        if (this.readInt(10) === null) {
          this.raise(Errors.InvalidOrMissingExponent, startLoc);
        }
        isFloat = true;
        hasExponent = true;
        next = this.input.charCodeAt(this.state.pos);
      }
      if (next === 110) {
        if (isFloat || hasLeadingZero) {
          this.raise(Errors.InvalidBigIntLiteral, startLoc);
        }
        ++this.state.pos;
        isBigInt = true;
      }
      if (next === 109) {
        this.expectPlugin("decimal", this.state.curPosition());
        if (hasExponent || hasLeadingZero) {
          this.raise(Errors.InvalidDecimal, startLoc);
        }
        ++this.state.pos;
        isDecimal = true;
      }
      if (isIdentifierStart(this.codePointAtPos(this.state.pos))) {
        throw this.raise(Errors.NumberIdentifier, this.state.curPosition());
      }
      const str = this.input.slice(start, this.state.pos).replace(/[_mn]/g, "");
      if (isBigInt) {
        this.finishToken(135, str);
        return;
      }
      if (isDecimal) {
        this.finishToken(136, str);
        return;
      }
      const val = isOctal ? parseInt(str, 8) : parseFloat(str);
      this.finishToken(134, val);
    }
    readCodePoint(throwOnInvalid) {
      const { code: code, pos: pos } = readCodePoint(
        this.input,
        this.state.pos,
        this.state.lineStart,
        this.state.curLine,
        throwOnInvalid,
        this.errorHandlers_readCodePoint,
      );
      this.state.pos = pos;
      return code;
    }
    readString(quote) {
      const {
        str: str,
        pos: pos,
        curLine: curLine,
        lineStart: lineStart,
      } = readStringContents(
        quote === 34 ? "double" : "single",
        this.input,
        this.state.pos + 1,
        this.state.lineStart,
        this.state.curLine,
        this.errorHandlers_readStringContents_string,
      );
      this.state.pos = pos + 1;
      this.state.lineStart = lineStart;
      this.state.curLine = curLine;
      this.finishToken(133, str);
    }
    readTemplateContinuation() {
      if (!this.match(8)) {
        this.unexpected(null, 8);
      }
      this.state.pos--;
      this.readTemplateToken();
    }
    readTemplateToken() {
      const opening = this.input[this.state.pos];
      const {
        str: str,
        firstInvalidLoc: firstInvalidLoc,
        pos: pos,
        curLine: curLine,
        lineStart: lineStart,
      } = readStringContents(
        "template",
        this.input,
        this.state.pos + 1,
        this.state.lineStart,
        this.state.curLine,
        this.errorHandlers_readStringContents_template,
      );
      this.state.pos = pos + 1;
      this.state.lineStart = lineStart;
      this.state.curLine = curLine;
      if (firstInvalidLoc) {
        this.state.firstInvalidTemplateEscapePos = new Position(
          firstInvalidLoc.curLine,
          firstInvalidLoc.pos - firstInvalidLoc.lineStart,
          firstInvalidLoc.pos,
        );
      }
      if (this.input.codePointAt(pos) === 96) {
        this.finishToken(24, firstInvalidLoc ? null : opening + str + "`");
      } else {
        this.state.pos++;
        this.finishToken(25, firstInvalidLoc ? null : opening + str + "${");
      }
    }
    recordStrictModeErrors(toParseError, at) {
      const index = at.index;
      if (this.state.strict && !this.state.strictErrors.has(index)) {
        this.raise(toParseError, at);
      } else {
        this.state.strictErrors.set(index, [toParseError, at]);
      }
    }
    readWord1(firstCode) {
      this.state.containsEsc = false;
      let word = "";
      const start = this.state.pos;
      let chunkStart = this.state.pos;
      if (firstCode !== undefined) {
        this.state.pos += firstCode <= 65535 ? 1 : 2;
      }
      while (this.state.pos < this.length) {
        const ch = this.codePointAtPos(this.state.pos);
        if (isIdentifierChar(ch)) {
          this.state.pos += ch <= 65535 ? 1 : 2;
        } else if (ch === 92) {
          this.state.containsEsc = true;
          word += this.input.slice(chunkStart, this.state.pos);
          const escStart = this.state.curPosition();
          const identifierCheck =
            this.state.pos === start ? isIdentifierStart : isIdentifierChar;
          if (this.input.charCodeAt(++this.state.pos) !== 117) {
            this.raise(Errors.MissingUnicodeEscape, this.state.curPosition());
            chunkStart = this.state.pos - 1;
            continue;
          }
          ++this.state.pos;
          const esc = this.readCodePoint(true);
          if (esc !== null) {
            if (!identifierCheck(esc)) {
              this.raise(Errors.EscapedCharNotAnIdentifier, escStart);
            }
            word += String.fromCodePoint(esc);
          }
          chunkStart = this.state.pos;
        } else {
          break;
        }
      }
      return word + this.input.slice(chunkStart, this.state.pos);
    }
    readWord(firstCode) {
      const word = this.readWord1(firstCode);
      const type = keywords$1.get(word);
      if (type !== undefined) {
        this.finishToken(type, tokenLabelName(type));
      } else {
        this.finishToken(132, word);
      }
    }
    checkKeywordEscapes() {
      const { type: type } = this.state;
      if (tokenIsKeyword(type) && this.state.containsEsc) {
        this.raise(Errors.InvalidEscapedReservedWord, this.state.startLoc, {
          reservedWord: tokenLabelName(type),
        });
      }
    }
    raise(toParseError, at, details = {}) {
      const loc = at instanceof Position ? at : at.loc.start;
      const error = toParseError(loc, details);
      if (!this.options.errorRecovery) throw error;
      if (!this.isLookahead) this.state.errors.push(error);
      return error;
    }
    raiseOverwrite(toParseError, at, details = {}) {
      const loc = at instanceof Position ? at : at.loc.start;
      const pos = loc.index;
      const errors = this.state.errors;
      for (let i = errors.length - 1; i >= 0; i--) {
        const error = errors[i];
        if (error.loc.index === pos) {
          return (errors[i] = toParseError(loc, details));
        }
        if (error.loc.index < pos) break;
      }
      return this.raise(toParseError, at, details);
    }
    updateContext(prevType) {}
    unexpected(loc, type) {
      throw this.raise(
        Errors.UnexpectedToken,
        loc != null ? loc : this.state.startLoc,
        { expected: type ? tokenLabelName(type) : null },
      );
    }
    expectPlugin(pluginName, loc) {
      if (this.hasPlugin(pluginName)) {
        return true;
      }
      throw this.raise(
        Errors.MissingPlugin,
        loc != null ? loc : this.state.startLoc,
        { missingPlugin: [pluginName] },
      );
    }
    expectOnePlugin(pluginNames) {
      if (!pluginNames.some((name) => this.hasPlugin(name))) {
        throw this.raise(Errors.MissingOneOfPlugins, this.state.startLoc, {
          missingPlugin: pluginNames,
        });
      }
    }
    errorBuilder(error) {
      return (pos, lineStart, curLine) => {
        this.raise(error, buildPosition(pos, lineStart, curLine));
      };
    }
  }
  class ClassScope {
    constructor() {
      this.privateNames = new Set();
      this.loneAccessors = new Map();
      this.undefinedPrivateNames = new Map();
    }
  }
  class ClassScopeHandler {
    constructor(parser) {
      this.parser = void 0;
      this.stack = [];
      this.undefinedPrivateNames = new Map();
      this.parser = parser;
    }
    current() {
      return this.stack[this.stack.length - 1];
    }
    enter() {
      this.stack.push(new ClassScope());
    }
    exit() {
      const oldClassScope = this.stack.pop();
      const current = this.current();
      for (const [name, loc] of Array.from(
        oldClassScope.undefinedPrivateNames,
      )) {
        if (current) {
          if (!current.undefinedPrivateNames.has(name)) {
            current.undefinedPrivateNames.set(name, loc);
          }
        } else {
          this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, {
            identifierName: name,
          });
        }
      }
    }
    declarePrivateName(name, elementType, loc) {
      const {
        privateNames: privateNames,
        loneAccessors: loneAccessors,
        undefinedPrivateNames: undefinedPrivateNames,
      } = this.current();
      let redefined = privateNames.has(name);
      if (elementType & 3) {
        const accessor = redefined && loneAccessors.get(name);
        if (accessor) {
          const oldStatic = accessor & 4;
          const newStatic = elementType & 4;
          const oldKind = accessor & 3;
          const newKind = elementType & 3;
          redefined = oldKind === newKind || oldStatic !== newStatic;
          if (!redefined) loneAccessors.delete(name);
        } else if (!redefined) {
          loneAccessors.set(name, elementType);
        }
      }
      if (redefined) {
        this.parser.raise(Errors.PrivateNameRedeclaration, loc, {
          identifierName: name,
        });
      }
      privateNames.add(name);
      undefinedPrivateNames.delete(name);
    }
    usePrivateName(name, loc) {
      let classScope;
      for (classScope of this.stack) {
        if (classScope.privateNames.has(name)) return;
      }
      if (classScope) {
        classScope.undefinedPrivateNames.set(name, loc);
      } else {
        this.parser.raise(Errors.InvalidPrivateFieldResolution, loc, {
          identifierName: name,
        });
      }
    }
  }
  class ExpressionScope {
    constructor(type = 0) {
      this.type = type;
    }
    canBeArrowParameterDeclaration() {
      return this.type === 2 || this.type === 1;
    }
    isCertainlyParameterDeclaration() {
      return this.type === 3;
    }
  }
  class ArrowHeadParsingScope extends ExpressionScope {
    constructor(type) {
      super(type);
      this.declarationErrors = new Map();
    }
    recordDeclarationError(ParsingErrorClass, at) {
      const index = at.index;
      this.declarationErrors.set(index, [ParsingErrorClass, at]);
    }
    clearDeclarationError(index) {
      this.declarationErrors.delete(index);
    }
    iterateErrors(iterator) {
      this.declarationErrors.forEach(iterator);
    }
  }
  class ExpressionScopeHandler {
    constructor(parser) {
      this.parser = void 0;
      this.stack = [new ExpressionScope()];
      this.parser = parser;
    }
    enter(scope) {
      this.stack.push(scope);
    }
    exit() {
      this.stack.pop();
    }
    recordParameterInitializerError(toParseError, node) {
      const origin = node.loc.start;
      const { stack: stack } = this;
      let i = stack.length - 1;
      let scope = stack[i];
      while (!scope.isCertainlyParameterDeclaration()) {
        if (scope.canBeArrowParameterDeclaration()) {
          scope.recordDeclarationError(toParseError, origin);
        } else {
          return;
        }
        scope = stack[--i];
      }
      this.parser.raise(toParseError, origin);
    }
    recordArrowParameterBindingError(error, node) {
      const { stack: stack } = this;
      const scope = stack[stack.length - 1];
      const origin = node.loc.start;
      if (scope.isCertainlyParameterDeclaration()) {
        this.parser.raise(error, origin);
      } else if (scope.canBeArrowParameterDeclaration()) {
        scope.recordDeclarationError(error, origin);
      } else {
        return;
      }
    }
    recordAsyncArrowParametersError(at) {
      const { stack: stack } = this;
      let i = stack.length - 1;
      let scope = stack[i];
      while (scope.canBeArrowParameterDeclaration()) {
        if (scope.type === 2) {
          scope.recordDeclarationError(Errors.AwaitBindingIdentifier, at);
        }
        scope = stack[--i];
      }
    }
    validateAsPattern() {
      const { stack: stack } = this;
      const currentScope = stack[stack.length - 1];
      if (!currentScope.canBeArrowParameterDeclaration()) return;
      currentScope.iterateErrors(([toParseError, loc]) => {
        this.parser.raise(toParseError, loc);
        let i = stack.length - 2;
        let scope = stack[i];
        while (scope.canBeArrowParameterDeclaration()) {
          scope.clearDeclarationError(loc.index);
          scope = stack[--i];
        }
      });
    }
  }
  function newParameterDeclarationScope() {
    return new ExpressionScope(3);
  }
  function newArrowHeadScope() {
    return new ArrowHeadParsingScope(1);
  }
  function newAsyncArrowScope() {
    return new ArrowHeadParsingScope(2);
  }
  function newExpressionScope() {
    return new ExpressionScope();
  }
  class ProductionParameterHandler {
    constructor() {
      this.stacks = [];
    }
    enter(flags) {
      this.stacks.push(flags);
    }
    exit() {
      this.stacks.pop();
    }
    currentFlags() {
      return this.stacks[this.stacks.length - 1];
    }
    get hasAwait() {
      return (this.currentFlags() & 2) > 0;
    }
    get hasYield() {
      return (this.currentFlags() & 1) > 0;
    }
    get hasReturn() {
      return (this.currentFlags() & 4) > 0;
    }
    get hasIn() {
      return (this.currentFlags() & 8) > 0;
    }
  }
  function functionFlags(isAsync, isGenerator) {
    return (isAsync ? 2 : 0) | (isGenerator ? 1 : 0);
  }
  class UtilParser extends Tokenizer {
    addExtra(node, key, value, enumerable = true) {
      if (!node) return;
      const extra = (node.extra = node.extra || {});
      if (enumerable) {
        extra[key] = value;
      } else {
        Object.defineProperty(extra, key, {
          enumerable: enumerable,
          value: value,
        });
      }
    }
    isContextual(token) {
      return this.state.type === token && !this.state.containsEsc;
    }
    isUnparsedContextual(nameStart, name) {
      const nameEnd = nameStart + name.length;
      if (this.input.slice(nameStart, nameEnd) === name) {
        const nextCh = this.input.charCodeAt(nameEnd);
        return !(isIdentifierChar(nextCh) || (nextCh & 64512) === 55296);
      }
      return false;
    }
    isLookaheadContextual(name) {
      const next = this.nextTokenStart();
      return this.isUnparsedContextual(next, name);
    }
    eatContextual(token) {
      if (this.isContextual(token)) {
        this.next();
        return true;
      }
      return false;
    }
    expectContextual(token, toParseError) {
      if (!this.eatContextual(token)) {
        if (toParseError != null) {
          throw this.raise(toParseError, this.state.startLoc);
        }
        this.unexpected(null, token);
      }
    }
    canInsertSemicolon() {
      return this.match(139) || this.match(8) || this.hasPrecedingLineBreak();
    }
    hasPrecedingLineBreak() {
      return lineBreak.test(
        this.input.slice(this.state.lastTokEndLoc.index, this.state.start),
      );
    }
    hasFollowingLineBreak() {
      skipWhiteSpaceToLineBreak.lastIndex = this.state.end;
      return skipWhiteSpaceToLineBreak.test(this.input);
    }
    isLineTerminator() {
      return this.eat(13) || this.canInsertSemicolon();
    }
    semicolon(allowAsi = true) {
      if (allowAsi ? this.isLineTerminator() : this.eat(13)) return;
      this.raise(Errors.MissingSemicolon, this.state.lastTokEndLoc);
    }
    expect(type, loc) {
      this.eat(type) || this.unexpected(loc, type);
    }
    tryParse(fn, oldState = this.state.clone()) {
      const abortSignal = { node: null };
      try {
        const node = fn((node = null) => {
          abortSignal.node = node;
          throw abortSignal;
        });
        if (this.state.errors.length > oldState.errors.length) {
          const failState = this.state;
          this.state = oldState;
          this.state.tokensLength = failState.tokensLength;
          return {
            node: node,
            error: failState.errors[oldState.errors.length],
            thrown: false,
            aborted: false,
            failState: failState,
          };
        }
        return {
          node: node,
          error: null,
          thrown: false,
          aborted: false,
          failState: null,
        };
      } catch (error) {
        const failState = this.state;
        this.state = oldState;
        if (error instanceof SyntaxError) {
          return {
            node: null,
            error: error,
            thrown: true,
            aborted: false,
            failState: failState,
          };
        }
        if (error === abortSignal) {
          return {
            node: abortSignal.node,
            error: null,
            thrown: false,
            aborted: true,
            failState: failState,
          };
        }
        throw error;
      }
    }
    checkExpressionErrors(refExpressionErrors, andThrow) {
      if (!refExpressionErrors) return false;
      const {
        shorthandAssignLoc: shorthandAssignLoc,
        doubleProtoLoc: doubleProtoLoc,
        privateKeyLoc: privateKeyLoc,
        optionalParametersLoc: optionalParametersLoc,
      } = refExpressionErrors;
      const hasErrors =
        !!shorthandAssignLoc ||
        !!doubleProtoLoc ||
        !!optionalParametersLoc ||
        !!privateKeyLoc;
      if (!andThrow) {
        return hasErrors;
      }
      if (shorthandAssignLoc != null) {
        this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
      }
      if (doubleProtoLoc != null) {
        this.raise(Errors.DuplicateProto, doubleProtoLoc);
      }
      if (privateKeyLoc != null) {
        this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
      }
      if (optionalParametersLoc != null) {
        this.unexpected(optionalParametersLoc);
      }
    }
    isLiteralPropertyName() {
      return tokenIsLiteralPropertyName(this.state.type);
    }
    isPrivateName(node) {
      return node.type === "PrivateName";
    }
    getPrivateNameSV(node) {
      return node.id.name;
    }
    hasPropertyAsPrivateName(node) {
      return (
        (node.type === "MemberExpression" ||
          node.type === "OptionalMemberExpression") &&
        this.isPrivateName(node.property)
      );
    }
    isObjectProperty(node) {
      return node.type === "ObjectProperty";
    }
    isObjectMethod(node) {
      return node.type === "ObjectMethod";
    }
    initializeScopes(inModule = this.options.sourceType === "module") {
      const oldLabels = this.state.labels;
      this.state.labels = [];
      const oldExportedIdentifiers = this.exportedIdentifiers;
      this.exportedIdentifiers = new Set();
      const oldInModule = this.inModule;
      this.inModule = inModule;
      const oldScope = this.scope;
      const ScopeHandler = this.getScopeHandler();
      this.scope = new ScopeHandler(this, inModule);
      const oldProdParam = this.prodParam;
      this.prodParam = new ProductionParameterHandler();
      const oldClassScope = this.classScope;
      this.classScope = new ClassScopeHandler(this);
      const oldExpressionScope = this.expressionScope;
      this.expressionScope = new ExpressionScopeHandler(this);
      return () => {
        this.state.labels = oldLabels;
        this.exportedIdentifiers = oldExportedIdentifiers;
        this.inModule = oldInModule;
        this.scope = oldScope;
        this.prodParam = oldProdParam;
        this.classScope = oldClassScope;
        this.expressionScope = oldExpressionScope;
      };
    }
    enterInitialScopes() {
      let paramFlags = 0;
      if (this.inModule) {
        paramFlags |= 2;
      }
      this.scope.enter(1);
      this.prodParam.enter(paramFlags);
    }
    checkDestructuringPrivate(refExpressionErrors) {
      const { privateKeyLoc: privateKeyLoc } = refExpressionErrors;
      if (privateKeyLoc !== null) {
        this.expectPlugin("destructuringPrivate", privateKeyLoc);
      }
    }
  }
  class ExpressionErrors {
    constructor() {
      this.shorthandAssignLoc = null;
      this.doubleProtoLoc = null;
      this.privateKeyLoc = null;
      this.optionalParametersLoc = null;
    }
  }
  class Node {
    constructor(parser, pos, loc) {
      this.type = "";
      this.start = pos;
      this.end = 0;
      this.loc = new SourceLocation(loc);
      if (parser != null && parser.options.ranges) this.range = [pos, 0];
      if (parser != null && parser.filename)
        this.loc.filename = parser.filename;
    }
  }
  const NodePrototype = Node.prototype;
  {
    NodePrototype.__clone = function () {
      const newNode = new Node(undefined, this.start, this.loc.start);
      const keys = Object.keys(this);
      for (let i = 0, length = keys.length; i < length; i++) {
        const key = keys[i];
        if (
          key !== "leadingComments" &&
          key !== "trailingComments" &&
          key !== "innerComments"
        ) {
          newNode[key] = this[key];
        }
      }
      return newNode;
    };
  }
  function clonePlaceholder(node) {
    return cloneIdentifier(node);
  }
  function cloneIdentifier(node) {
    const {
      type: type,
      start: start,
      end: end,
      loc: loc,
      range: range,
      extra: extra,
      name: name,
    } = node;
    const cloned = Object.create(NodePrototype);
    cloned.type = type;
    cloned.start = start;
    cloned.end = end;
    cloned.loc = loc;
    cloned.range = range;
    cloned.extra = extra;
    cloned.name = name;
    if (type === "Placeholder") {
      cloned.expectedNode = node.expectedNode;
    }
    return cloned;
  }
  function cloneStringLiteral(node) {
    const {
      type: type,
      start: start,
      end: end,
      loc: loc,
      range: range,
      extra: extra,
    } = node;
    if (type === "Placeholder") {
      return clonePlaceholder(node);
    }
    const cloned = Object.create(NodePrototype);
    cloned.type = type;
    cloned.start = start;
    cloned.end = end;
    cloned.loc = loc;
    cloned.range = range;
    if (node.raw !== undefined) {
      cloned.raw = node.raw;
    } else {
      cloned.extra = extra;
    }
    cloned.value = node.value;
    return cloned;
  }
  class NodeUtils extends UtilParser {
    startNode() {
      const loc = this.state.startLoc;
      return new Node(this, loc.index, loc);
    }
    startNodeAt(loc) {
      return new Node(this, loc.index, loc);
    }
    startNodeAtNode(type) {
      return this.startNodeAt(type.loc.start);
    }
    finishNode(node, type) {
      return this.finishNodeAt(node, type, this.state.lastTokEndLoc);
    }
    finishNodeAt(node, type, endLoc) {
      node.type = type;
      node.end = endLoc.index;
      node.loc.end = endLoc;
      if (this.options.ranges) node.range[1] = endLoc.index;
      if (this.options.attachComment) this.processComment(node);
      return node;
    }
    resetStartLocation(node, startLoc) {
      node.start = startLoc.index;
      node.loc.start = startLoc;
      if (this.options.ranges) node.range[0] = startLoc.index;
    }
    resetEndLocation(node, endLoc = this.state.lastTokEndLoc) {
      node.end = endLoc.index;
      node.loc.end = endLoc;
      if (this.options.ranges) node.range[1] = endLoc.index;
    }
    resetStartLocationFromNode(node, locationNode) {
      this.resetStartLocation(node, locationNode.loc.start);
    }
  }
  const reservedTypes = new Set([
    "_",
    "any",
    "bool",
    "boolean",
    "empty",
    "extends",
    "false",
    "interface",
    "mixed",
    "null",
    "number",
    "static",
    "string",
    "true",
    "typeof",
    "void",
  ]);
  const FlowErrors = ParseErrorEnum`flow`({
    AmbiguousConditionalArrow:
      "Ambiguous expression: wrap the arrow functions in parentheses to disambiguate.",
    AmbiguousDeclareModuleKind:
      "Found both `declare module.exports` and `declare export` in the same module. Modules can only have 1 since they are either an ES module or they are a CommonJS module.",
    AssignReservedType: ({ reservedType: reservedType }) =>
      `Cannot overwrite reserved type ${reservedType}.`,
    DeclareClassElement:
      "The `declare` modifier can only appear on class fields.",
    DeclareClassFieldInitializer:
      "Initializers are not allowed in fields with the `declare` modifier.",
    DuplicateDeclareModuleExports:
      "Duplicate `declare module.exports` statement.",
    EnumBooleanMemberNotInitialized: ({
      memberName: memberName,
      enumName: enumName,
    }) =>
      `Boolean enum members need to be initialized. Use either \`${memberName} = true,\` or \`${memberName} = false,\` in enum \`${enumName}\`.`,
    EnumDuplicateMemberName: ({ memberName: memberName, enumName: enumName }) =>
      `Enum member names need to be unique, but the name \`${memberName}\` has already been used before in enum \`${enumName}\`.`,
    EnumInconsistentMemberValues: ({ enumName: enumName }) =>
      `Enum \`${enumName}\` has inconsistent member initializers. Either use no initializers, or consistently use literals (either booleans, numbers, or strings) for all member initializers.`,
    EnumInvalidExplicitType: ({
      invalidEnumType: invalidEnumType,
      enumName: enumName,
    }) =>
      `Enum type \`${invalidEnumType}\` is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
    EnumInvalidExplicitTypeUnknownSupplied: ({ enumName: enumName }) =>
      `Supplied enum type is not valid. Use one of \`boolean\`, \`number\`, \`string\`, or \`symbol\` in enum \`${enumName}\`.`,
    EnumInvalidMemberInitializerPrimaryType: ({
      enumName: enumName,
      memberName: memberName,
      explicitType: explicitType,
    }) =>
      `Enum \`${enumName}\` has type \`${explicitType}\`, so the initializer of \`${memberName}\` needs to be a ${explicitType} literal.`,
    EnumInvalidMemberInitializerSymbolType: ({
      enumName: enumName,
      memberName: memberName,
    }) =>
      `Symbol enum members cannot be initialized. Use \`${memberName},\` in enum \`${enumName}\`.`,
    EnumInvalidMemberInitializerUnknownType: ({
      enumName: enumName,
      memberName: memberName,
    }) =>
      `The enum member initializer for \`${memberName}\` needs to be a literal (either a boolean, number, or string) in enum \`${enumName}\`.`,
    EnumInvalidMemberName: ({
      enumName: enumName,
      memberName: memberName,
      suggestion: suggestion,
    }) =>
      `Enum member names cannot start with lowercase 'a' through 'z'. Instead of using \`${memberName}\`, consider using \`${suggestion}\`, in enum \`${enumName}\`.`,
    EnumNumberMemberNotInitialized: ({
      enumName: enumName,
      memberName: memberName,
    }) =>
      `Number enum members need to be initialized, e.g. \`${memberName} = 1\` in enum \`${enumName}\`.`,
    EnumStringMemberInconsistentlyInitialized: ({ enumName: enumName }) =>
      `String enum members need to consistently either all use initializers, or use no initializers, in enum \`${enumName}\`.`,
    GetterMayNotHaveThisParam: "A getter cannot have a `this` parameter.",
    ImportReflectionHasImportType:
      "An `import module` declaration can not use `type` or `typeof` keyword.",
    ImportTypeShorthandOnlyInPureImport:
      "The `type` and `typeof` keywords on named imports can only be used on regular `import` statements. It cannot be used with `import type` or `import typeof` statements.",
    InexactInsideExact:
      "Explicit inexact syntax cannot appear inside an explicit exact object type.",
    InexactInsideNonObject:
      "Explicit inexact syntax cannot appear in class or interface definitions.",
    InexactVariance: "Explicit inexact syntax cannot have variance.",
    InvalidNonTypeImportInDeclareModule:
      "Imports within a `declare module` body must always be `import type` or `import typeof`.",
    MissingTypeParamDefault:
      "Type parameter declaration needs a default, since a preceding type parameter declaration has a default.",
    NestedDeclareModule:
      "`declare module` cannot be used inside another `declare module`.",
    NestedFlowComment:
      "Cannot have a flow comment inside another flow comment.",
    PatternIsOptional: Object.assign(
      {
        message:
          "A binding pattern parameter cannot be optional in an implementation signature.",
      },
      { reasonCode: "OptionalBindingPattern" },
    ),
    SetterMayNotHaveThisParam: "A setter cannot have a `this` parameter.",
    SpreadVariance: "Spread properties cannot have variance.",
    ThisParamAnnotationRequired:
      "A type annotation is required for the `this` parameter.",
    ThisParamBannedInConstructor:
      "Constructors cannot have a `this` parameter; constructors don't bind `this` like other functions.",
    ThisParamMayNotBeOptional: "The `this` parameter cannot be optional.",
    ThisParamMustBeFirst:
      "The `this` parameter must be the first function parameter.",
    ThisParamNoDefault: "The `this` parameter may not have a default value.",
    TypeBeforeInitializer:
      "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
    TypeCastInPattern:
      "The type cast expression is expected to be wrapped with parenthesis.",
    UnexpectedExplicitInexactInObject:
      "Explicit inexact syntax must appear at the end of an inexact object.",
    UnexpectedReservedType: ({ reservedType: reservedType }) =>
      `Unexpected reserved type ${reservedType}.`,
    UnexpectedReservedUnderscore:
      "`_` is only allowed as a type argument to call or new.",
    UnexpectedSpaceBetweenModuloChecks:
      "Spaces between `%` and `checks` are not allowed here.",
    UnexpectedSpreadType:
      "Spread operator cannot appear in class or interface definitions.",
    UnexpectedSubtractionOperand:
      'Unexpected token, expected "number" or "bigint".',
    UnexpectedTokenAfterTypeParameter:
      "Expected an arrow function after this type parameter declaration.",
    UnexpectedTypeParameterBeforeAsyncArrowFunction:
      "Type parameters must come after the async keyword, e.g. instead of `<T> async () => {}`, use `async <T>() => {}`.",
    UnsupportedDeclareExportKind: ({
      unsupportedExportKind: unsupportedExportKind,
      suggestion: suggestion,
    }) =>
      `\`declare export ${unsupportedExportKind}\` is not supported. Use \`${suggestion}\` instead.`,
    UnsupportedStatementInDeclareModule:
      "Only declares and type imports are allowed inside declare module.",
    UnterminatedFlowComment: "Unterminated flow-comment.",
  });
  function isEsModuleType(bodyElement) {
    return (
      bodyElement.type === "DeclareExportAllDeclaration" ||
      (bodyElement.type === "DeclareExportDeclaration" &&
        (!bodyElement.declaration ||
          (bodyElement.declaration.type !== "TypeAlias" &&
            bodyElement.declaration.type !== "InterfaceDeclaration")))
    );
  }
  function hasTypeImportKind(node) {
    return node.importKind === "type" || node.importKind === "typeof";
  }
  const exportSuggestions = {
    const: "declare export var",
    let: "declare export var",
    type: "export type",
    interface: "export interface",
  };
  function partition(list, test) {
    const list1 = [];
    const list2 = [];
    for (let i = 0; i < list.length; i++) {
      (test(list[i], i, list) ? list1 : list2).push(list[i]);
    }
    return [list1, list2];
  }
  const FLOW_PRAGMA_REGEX = /\*?\s*@((?:no)?flow)\b/;
  var flow = (superClass) =>
    class FlowParserMixin extends superClass {
      constructor(...args) {
        super(...args);
        this.flowPragma = undefined;
      }
      getScopeHandler() {
        return FlowScopeHandler;
      }
      shouldParseTypes() {
        return (
          this.getPluginOption("flow", "all") || this.flowPragma === "flow"
        );
      }
      shouldParseEnums() {
        return !!this.getPluginOption("flow", "enums");
      }
      finishToken(type, val) {
        if (type !== 133 && type !== 13 && type !== 28) {
          if (this.flowPragma === undefined) {
            this.flowPragma = null;
          }
        }
        super.finishToken(type, val);
      }
      addComment(comment) {
        if (this.flowPragma === undefined) {
          const matches = FLOW_PRAGMA_REGEX.exec(comment.value);
          if (!matches);
          else if (matches[1] === "flow") {
            this.flowPragma = "flow";
          } else if (matches[1] === "noflow") {
            this.flowPragma = "noflow";
          } else {
            throw new Error("Unexpected flow pragma");
          }
        }
        super.addComment(comment);
      }
      flowParseTypeInitialiser(tok) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        this.expect(tok || 14);
        const type = this.flowParseType();
        this.state.inType = oldInType;
        return type;
      }
      flowParsePredicate() {
        const node = this.startNode();
        const moduloLoc = this.state.startLoc;
        this.next();
        this.expectContextual(110);
        if (this.state.lastTokStartLoc.index > moduloLoc.index + 1) {
          this.raise(FlowErrors.UnexpectedSpaceBetweenModuloChecks, moduloLoc);
        }
        if (this.eat(10)) {
          node.value = super.parseExpression();
          this.expect(11);
          return this.finishNode(node, "DeclaredPredicate");
        } else {
          return this.finishNode(node, "InferredPredicate");
        }
      }
      flowParseTypeAndPredicateInitialiser() {
        const oldInType = this.state.inType;
        this.state.inType = true;
        this.expect(14);
        let type = null;
        let predicate = null;
        if (this.match(54)) {
          this.state.inType = oldInType;
          predicate = this.flowParsePredicate();
        } else {
          type = this.flowParseType();
          this.state.inType = oldInType;
          if (this.match(54)) {
            predicate = this.flowParsePredicate();
          }
        }
        return [type, predicate];
      }
      flowParseDeclareClass(node) {
        this.next();
        this.flowParseInterfaceish(node, true);
        return this.finishNode(node, "DeclareClass");
      }
      flowParseDeclareFunction(node) {
        this.next();
        const id = (node.id = this.parseIdentifier());
        const typeNode = this.startNode();
        const typeContainer = this.startNode();
        if (this.match(47)) {
          typeNode.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          typeNode.typeParameters = null;
        }
        this.expect(10);
        const tmp = this.flowParseFunctionTypeParams();
        typeNode.params = tmp.params;
        typeNode.rest = tmp.rest;
        typeNode.this = tmp._this;
        this.expect(11);
        [typeNode.returnType, node.predicate] =
          this.flowParseTypeAndPredicateInitialiser();
        typeContainer.typeAnnotation = this.finishNode(
          typeNode,
          "FunctionTypeAnnotation",
        );
        id.typeAnnotation = this.finishNode(typeContainer, "TypeAnnotation");
        this.resetEndLocation(id);
        this.semicolon();
        this.scope.declareName(node.id.name, 2048, node.id.loc.start);
        return this.finishNode(node, "DeclareFunction");
      }
      flowParseDeclare(node, insideModule) {
        if (this.match(80)) {
          return this.flowParseDeclareClass(node);
        } else if (this.match(68)) {
          return this.flowParseDeclareFunction(node);
        } else if (this.match(74)) {
          return this.flowParseDeclareVariable(node);
        } else if (this.eatContextual(127)) {
          if (this.match(16)) {
            return this.flowParseDeclareModuleExports(node);
          } else {
            if (insideModule) {
              this.raise(
                FlowErrors.NestedDeclareModule,
                this.state.lastTokStartLoc,
              );
            }
            return this.flowParseDeclareModule(node);
          }
        } else if (this.isContextual(130)) {
          return this.flowParseDeclareTypeAlias(node);
        } else if (this.isContextual(131)) {
          return this.flowParseDeclareOpaqueType(node);
        } else if (this.isContextual(129)) {
          return this.flowParseDeclareInterface(node);
        } else if (this.match(82)) {
          return this.flowParseDeclareExportDeclaration(node, insideModule);
        } else {
          this.unexpected();
        }
      }
      flowParseDeclareVariable(node) {
        this.next();
        node.id = this.flowParseTypeAnnotatableIdentifier(true);
        this.scope.declareName(node.id.name, 5, node.id.loc.start);
        this.semicolon();
        return this.finishNode(node, "DeclareVariable");
      }
      flowParseDeclareModule(node) {
        this.scope.enter(0);
        if (this.match(133)) {
          node.id = super.parseExprAtom();
        } else {
          node.id = this.parseIdentifier();
        }
        const bodyNode = (node.body = this.startNode());
        const body = (bodyNode.body = []);
        this.expect(5);
        while (!this.match(8)) {
          let bodyNode = this.startNode();
          if (this.match(83)) {
            this.next();
            if (!this.isContextual(130) && !this.match(87)) {
              this.raise(
                FlowErrors.InvalidNonTypeImportInDeclareModule,
                this.state.lastTokStartLoc,
              );
            }
            super.parseImport(bodyNode);
          } else {
            this.expectContextual(
              125,
              FlowErrors.UnsupportedStatementInDeclareModule,
            );
            bodyNode = this.flowParseDeclare(bodyNode, true);
          }
          body.push(bodyNode);
        }
        this.scope.exit();
        this.expect(8);
        this.finishNode(bodyNode, "BlockStatement");
        let kind = null;
        let hasModuleExport = false;
        body.forEach((bodyElement) => {
          if (isEsModuleType(bodyElement)) {
            if (kind === "CommonJS") {
              this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
            }
            kind = "ES";
          } else if (bodyElement.type === "DeclareModuleExports") {
            if (hasModuleExport) {
              this.raise(FlowErrors.DuplicateDeclareModuleExports, bodyElement);
            }
            if (kind === "ES") {
              this.raise(FlowErrors.AmbiguousDeclareModuleKind, bodyElement);
            }
            kind = "CommonJS";
            hasModuleExport = true;
          }
        });
        node.kind = kind || "CommonJS";
        return this.finishNode(node, "DeclareModule");
      }
      flowParseDeclareExportDeclaration(node, insideModule) {
        this.expect(82);
        if (this.eat(65)) {
          if (this.match(68) || this.match(80)) {
            node.declaration = this.flowParseDeclare(this.startNode());
          } else {
            node.declaration = this.flowParseType();
            this.semicolon();
          }
          node.default = true;
          return this.finishNode(node, "DeclareExportDeclaration");
        } else {
          if (
            this.match(75) ||
            this.isLet() ||
            ((this.isContextual(130) || this.isContextual(129)) &&
              !insideModule)
          ) {
            const label = this.state.value;
            throw this.raise(
              FlowErrors.UnsupportedDeclareExportKind,
              this.state.startLoc,
              {
                unsupportedExportKind: label,
                suggestion: exportSuggestions[label],
              },
            );
          }
          if (
            this.match(74) ||
            this.match(68) ||
            this.match(80) ||
            this.isContextual(131)
          ) {
            node.declaration = this.flowParseDeclare(this.startNode());
            node.default = false;
            return this.finishNode(node, "DeclareExportDeclaration");
          } else if (
            this.match(55) ||
            this.match(5) ||
            this.isContextual(129) ||
            this.isContextual(130) ||
            this.isContextual(131)
          ) {
            node = this.parseExport(node, null);
            if (node.type === "ExportNamedDeclaration") {
              node.type = "ExportDeclaration";
              node.default = false;
              delete node.exportKind;
            }
            node.type = "Declare" + node.type;
            return node;
          }
        }
        this.unexpected();
      }
      flowParseDeclareModuleExports(node) {
        this.next();
        this.expectContextual(111);
        node.typeAnnotation = this.flowParseTypeAnnotation();
        this.semicolon();
        return this.finishNode(node, "DeclareModuleExports");
      }
      flowParseDeclareTypeAlias(node) {
        this.next();
        const finished = this.flowParseTypeAlias(node);
        finished.type = "DeclareTypeAlias";
        return finished;
      }
      flowParseDeclareOpaqueType(node) {
        this.next();
        const finished = this.flowParseOpaqueType(node, true);
        finished.type = "DeclareOpaqueType";
        return finished;
      }
      flowParseDeclareInterface(node) {
        this.next();
        this.flowParseInterfaceish(node, false);
        return this.finishNode(node, "DeclareInterface");
      }
      flowParseInterfaceish(node, isClass) {
        node.id = this.flowParseRestrictedIdentifier(!isClass, true);
        this.scope.declareName(
          node.id.name,
          isClass ? 17 : 8201,
          node.id.loc.start,
        );
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.extends = [];
        if (this.eat(81)) {
          do {
            node.extends.push(this.flowParseInterfaceExtends());
          } while (!isClass && this.eat(12));
        }
        if (isClass) {
          node.implements = [];
          node.mixins = [];
          if (this.eatContextual(117)) {
            do {
              node.mixins.push(this.flowParseInterfaceExtends());
            } while (this.eat(12));
          }
          if (this.eatContextual(113)) {
            do {
              node.implements.push(this.flowParseInterfaceExtends());
            } while (this.eat(12));
          }
        }
        node.body = this.flowParseObjectType({
          allowStatic: isClass,
          allowExact: false,
          allowSpread: false,
          allowProto: isClass,
          allowInexact: false,
        });
      }
      flowParseInterfaceExtends() {
        const node = this.startNode();
        node.id = this.flowParseQualifiedTypeIdentifier();
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterInstantiation();
        } else {
          node.typeParameters = null;
        }
        return this.finishNode(node, "InterfaceExtends");
      }
      flowParseInterface(node) {
        this.flowParseInterfaceish(node, false);
        return this.finishNode(node, "InterfaceDeclaration");
      }
      checkNotUnderscore(word) {
        if (word === "_") {
          this.raise(
            FlowErrors.UnexpectedReservedUnderscore,
            this.state.startLoc,
          );
        }
      }
      checkReservedType(word, startLoc, declaration) {
        if (!reservedTypes.has(word)) return;
        this.raise(
          declaration
            ? FlowErrors.AssignReservedType
            : FlowErrors.UnexpectedReservedType,
          startLoc,
          { reservedType: word },
        );
      }
      flowParseRestrictedIdentifier(liberal, declaration) {
        this.checkReservedType(
          this.state.value,
          this.state.startLoc,
          declaration,
        );
        return this.parseIdentifier(liberal);
      }
      flowParseTypeAlias(node) {
        node.id = this.flowParseRestrictedIdentifier(false, true);
        this.scope.declareName(node.id.name, 8201, node.id.loc.start);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.right = this.flowParseTypeInitialiser(29);
        this.semicolon();
        return this.finishNode(node, "TypeAlias");
      }
      flowParseOpaqueType(node, declare) {
        this.expectContextual(130);
        node.id = this.flowParseRestrictedIdentifier(true, true);
        this.scope.declareName(node.id.name, 8201, node.id.loc.start);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        } else {
          node.typeParameters = null;
        }
        node.supertype = null;
        if (this.match(14)) {
          node.supertype = this.flowParseTypeInitialiser(14);
        }
        node.impltype = null;
        if (!declare) {
          node.impltype = this.flowParseTypeInitialiser(29);
        }
        this.semicolon();
        return this.finishNode(node, "OpaqueType");
      }
      flowParseTypeParameter(requireDefault = false) {
        const nodeStartLoc = this.state.startLoc;
        const node = this.startNode();
        const variance = this.flowParseVariance();
        const ident = this.flowParseTypeAnnotatableIdentifier();
        node.name = ident.name;
        node.variance = variance;
        node.bound = ident.typeAnnotation;
        if (this.match(29)) {
          this.eat(29);
          node.default = this.flowParseType();
        } else {
          if (requireDefault) {
            this.raise(FlowErrors.MissingTypeParamDefault, nodeStartLoc);
          }
        }
        return this.finishNode(node, "TypeParameter");
      }
      flowParseTypeParameterDeclaration() {
        const oldInType = this.state.inType;
        const node = this.startNode();
        node.params = [];
        this.state.inType = true;
        if (this.match(47) || this.match(142)) {
          this.next();
        } else {
          this.unexpected();
        }
        let defaultRequired = false;
        do {
          const typeParameter = this.flowParseTypeParameter(defaultRequired);
          node.params.push(typeParameter);
          if (typeParameter.default) {
            defaultRequired = true;
          }
          if (!this.match(48)) {
            this.expect(12);
          }
        } while (!this.match(48));
        this.expect(48);
        this.state.inType = oldInType;
        return this.finishNode(node, "TypeParameterDeclaration");
      }
      flowParseTypeParameterInstantiation() {
        const node = this.startNode();
        const oldInType = this.state.inType;
        node.params = [];
        this.state.inType = true;
        this.expect(47);
        const oldNoAnonFunctionType = this.state.noAnonFunctionType;
        this.state.noAnonFunctionType = false;
        while (!this.match(48)) {
          node.params.push(this.flowParseType());
          if (!this.match(48)) {
            this.expect(12);
          }
        }
        this.state.noAnonFunctionType = oldNoAnonFunctionType;
        this.expect(48);
        this.state.inType = oldInType;
        return this.finishNode(node, "TypeParameterInstantiation");
      }
      flowParseTypeParameterInstantiationCallOrNew() {
        const node = this.startNode();
        const oldInType = this.state.inType;
        node.params = [];
        this.state.inType = true;
        this.expect(47);
        while (!this.match(48)) {
          node.params.push(this.flowParseTypeOrImplicitInstantiation());
          if (!this.match(48)) {
            this.expect(12);
          }
        }
        this.expect(48);
        this.state.inType = oldInType;
        return this.finishNode(node, "TypeParameterInstantiation");
      }
      flowParseInterfaceType() {
        const node = this.startNode();
        this.expectContextual(129);
        node.extends = [];
        if (this.eat(81)) {
          do {
            node.extends.push(this.flowParseInterfaceExtends());
          } while (this.eat(12));
        }
        node.body = this.flowParseObjectType({
          allowStatic: false,
          allowExact: false,
          allowSpread: false,
          allowProto: false,
          allowInexact: false,
        });
        return this.finishNode(node, "InterfaceTypeAnnotation");
      }
      flowParseObjectPropertyKey() {
        return this.match(134) || this.match(133)
          ? super.parseExprAtom()
          : this.parseIdentifier(true);
      }
      flowParseObjectTypeIndexer(node, isStatic, variance) {
        node.static = isStatic;
        if (this.lookahead().type === 14) {
          node.id = this.flowParseObjectPropertyKey();
          node.key = this.flowParseTypeInitialiser();
        } else {
          node.id = null;
          node.key = this.flowParseType();
        }
        this.expect(3);
        node.value = this.flowParseTypeInitialiser();
        node.variance = variance;
        return this.finishNode(node, "ObjectTypeIndexer");
      }
      flowParseObjectTypeInternalSlot(node, isStatic) {
        node.static = isStatic;
        node.id = this.flowParseObjectPropertyKey();
        this.expect(3);
        this.expect(3);
        if (this.match(47) || this.match(10)) {
          node.method = true;
          node.optional = false;
          node.value = this.flowParseObjectTypeMethodish(
            this.startNodeAt(node.loc.start),
          );
        } else {
          node.method = false;
          if (this.eat(17)) {
            node.optional = true;
          }
          node.value = this.flowParseTypeInitialiser();
        }
        return this.finishNode(node, "ObjectTypeInternalSlot");
      }
      flowParseObjectTypeMethodish(node) {
        node.params = [];
        node.rest = null;
        node.typeParameters = null;
        node.this = null;
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        this.expect(10);
        if (this.match(78)) {
          node.this = this.flowParseFunctionTypeParam(true);
          node.this.name = null;
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        while (!this.match(11) && !this.match(21)) {
          node.params.push(this.flowParseFunctionTypeParam(false));
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        if (this.eat(21)) {
          node.rest = this.flowParseFunctionTypeParam(false);
        }
        this.expect(11);
        node.returnType = this.flowParseTypeInitialiser();
        return this.finishNode(node, "FunctionTypeAnnotation");
      }
      flowParseObjectTypeCallProperty(node, isStatic) {
        const valueNode = this.startNode();
        node.static = isStatic;
        node.value = this.flowParseObjectTypeMethodish(valueNode);
        return this.finishNode(node, "ObjectTypeCallProperty");
      }
      flowParseObjectType({
        allowStatic: allowStatic,
        allowExact: allowExact,
        allowSpread: allowSpread,
        allowProto: allowProto,
        allowInexact: allowInexact,
      }) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        const nodeStart = this.startNode();
        nodeStart.callProperties = [];
        nodeStart.properties = [];
        nodeStart.indexers = [];
        nodeStart.internalSlots = [];
        let endDelim;
        let exact;
        let inexact = false;
        if (allowExact && this.match(6)) {
          this.expect(6);
          endDelim = 9;
          exact = true;
        } else {
          this.expect(5);
          endDelim = 8;
          exact = false;
        }
        nodeStart.exact = exact;
        while (!this.match(endDelim)) {
          let isStatic = false;
          let protoStartLoc = null;
          let inexactStartLoc = null;
          const node = this.startNode();
          if (allowProto && this.isContextual(118)) {
            const lookahead = this.lookahead();
            if (lookahead.type !== 14 && lookahead.type !== 17) {
              this.next();
              protoStartLoc = this.state.startLoc;
              allowStatic = false;
            }
          }
          if (allowStatic && this.isContextual(106)) {
            const lookahead = this.lookahead();
            if (lookahead.type !== 14 && lookahead.type !== 17) {
              this.next();
              isStatic = true;
            }
          }
          const variance = this.flowParseVariance();
          if (this.eat(0)) {
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (this.eat(0)) {
              if (variance) {
                this.unexpected(variance.loc.start);
              }
              nodeStart.internalSlots.push(
                this.flowParseObjectTypeInternalSlot(node, isStatic),
              );
            } else {
              nodeStart.indexers.push(
                this.flowParseObjectTypeIndexer(node, isStatic, variance),
              );
            }
          } else if (this.match(10) || this.match(47)) {
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (variance) {
              this.unexpected(variance.loc.start);
            }
            nodeStart.callProperties.push(
              this.flowParseObjectTypeCallProperty(node, isStatic),
            );
          } else {
            let kind = "init";
            if (this.isContextual(99) || this.isContextual(104)) {
              const lookahead = this.lookahead();
              if (tokenIsLiteralPropertyName(lookahead.type)) {
                kind = this.state.value;
                this.next();
              }
            }
            const propOrInexact = this.flowParseObjectTypeProperty(
              node,
              isStatic,
              protoStartLoc,
              variance,
              kind,
              allowSpread,
              allowInexact != null ? allowInexact : !exact,
            );
            if (propOrInexact === null) {
              inexact = true;
              inexactStartLoc = this.state.lastTokStartLoc;
            } else {
              nodeStart.properties.push(propOrInexact);
            }
          }
          this.flowObjectTypeSemicolon();
          if (inexactStartLoc && !this.match(8) && !this.match(9)) {
            this.raise(
              FlowErrors.UnexpectedExplicitInexactInObject,
              inexactStartLoc,
            );
          }
        }
        this.expect(endDelim);
        if (allowSpread) {
          nodeStart.inexact = inexact;
        }
        const out = this.finishNode(nodeStart, "ObjectTypeAnnotation");
        this.state.inType = oldInType;
        return out;
      }
      flowParseObjectTypeProperty(
        node,
        isStatic,
        protoStartLoc,
        variance,
        kind,
        allowSpread,
        allowInexact,
      ) {
        if (this.eat(21)) {
          const isInexactToken =
            this.match(12) || this.match(13) || this.match(8) || this.match(9);
          if (isInexactToken) {
            if (!allowSpread) {
              this.raise(
                FlowErrors.InexactInsideNonObject,
                this.state.lastTokStartLoc,
              );
            } else if (!allowInexact) {
              this.raise(
                FlowErrors.InexactInsideExact,
                this.state.lastTokStartLoc,
              );
            }
            if (variance) {
              this.raise(FlowErrors.InexactVariance, variance);
            }
            return null;
          }
          if (!allowSpread) {
            this.raise(
              FlowErrors.UnexpectedSpreadType,
              this.state.lastTokStartLoc,
            );
          }
          if (protoStartLoc != null) {
            this.unexpected(protoStartLoc);
          }
          if (variance) {
            this.raise(FlowErrors.SpreadVariance, variance);
          }
          node.argument = this.flowParseType();
          return this.finishNode(node, "ObjectTypeSpreadProperty");
        } else {
          node.key = this.flowParseObjectPropertyKey();
          node.static = isStatic;
          node.proto = protoStartLoc != null;
          node.kind = kind;
          let optional = false;
          if (this.match(47) || this.match(10)) {
            node.method = true;
            if (protoStartLoc != null) {
              this.unexpected(protoStartLoc);
            }
            if (variance) {
              this.unexpected(variance.loc.start);
            }
            node.value = this.flowParseObjectTypeMethodish(
              this.startNodeAt(node.loc.start),
            );
            if (kind === "get" || kind === "set") {
              this.flowCheckGetterSetterParams(node);
            }
            if (
              !allowSpread &&
              node.key.name === "constructor" &&
              node.value.this
            ) {
              this.raise(
                FlowErrors.ThisParamBannedInConstructor,
                node.value.this,
              );
            }
          } else {
            if (kind !== "init") this.unexpected();
            node.method = false;
            if (this.eat(17)) {
              optional = true;
            }
            node.value = this.flowParseTypeInitialiser();
            node.variance = variance;
          }
          node.optional = optional;
          return this.finishNode(node, "ObjectTypeProperty");
        }
      }
      flowCheckGetterSetterParams(property) {
        const paramCount = property.kind === "get" ? 0 : 1;
        const length =
          property.value.params.length + (property.value.rest ? 1 : 0);
        if (property.value.this) {
          this.raise(
            property.kind === "get"
              ? FlowErrors.GetterMayNotHaveThisParam
              : FlowErrors.SetterMayNotHaveThisParam,
            property.value.this,
          );
        }
        if (length !== paramCount) {
          this.raise(
            property.kind === "get"
              ? Errors.BadGetterArity
              : Errors.BadSetterArity,
            property,
          );
        }
        if (property.kind === "set" && property.value.rest) {
          this.raise(Errors.BadSetterRestParameter, property);
        }
      }
      flowObjectTypeSemicolon() {
        if (
          !this.eat(13) &&
          !this.eat(12) &&
          !this.match(8) &&
          !this.match(9)
        ) {
          this.unexpected();
        }
      }
      flowParseQualifiedTypeIdentifier(startLoc, id) {
        var _startLoc;
        (_startLoc = startLoc) != null
          ? _startLoc
          : (startLoc = this.state.startLoc);
        let node = id || this.flowParseRestrictedIdentifier(true);
        while (this.eat(16)) {
          const node2 = this.startNodeAt(startLoc);
          node2.qualification = node;
          node2.id = this.flowParseRestrictedIdentifier(true);
          node = this.finishNode(node2, "QualifiedTypeIdentifier");
        }
        return node;
      }
      flowParseGenericType(startLoc, id) {
        const node = this.startNodeAt(startLoc);
        node.typeParameters = null;
        node.id = this.flowParseQualifiedTypeIdentifier(startLoc, id);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterInstantiation();
        }
        return this.finishNode(node, "GenericTypeAnnotation");
      }
      flowParseTypeofType() {
        const node = this.startNode();
        this.expect(87);
        node.argument = this.flowParsePrimaryType();
        return this.finishNode(node, "TypeofTypeAnnotation");
      }
      flowParseTupleType() {
        const node = this.startNode();
        node.types = [];
        this.expect(0);
        while (this.state.pos < this.length && !this.match(3)) {
          node.types.push(this.flowParseType());
          if (this.match(3)) break;
          this.expect(12);
        }
        this.expect(3);
        return this.finishNode(node, "TupleTypeAnnotation");
      }
      flowParseFunctionTypeParam(first) {
        let name = null;
        let optional = false;
        let typeAnnotation = null;
        const node = this.startNode();
        const lh = this.lookahead();
        const isThis = this.state.type === 78;
        if (lh.type === 14 || lh.type === 17) {
          if (isThis && !first) {
            this.raise(FlowErrors.ThisParamMustBeFirst, node);
          }
          name = this.parseIdentifier(isThis);
          if (this.eat(17)) {
            optional = true;
            if (isThis) {
              this.raise(FlowErrors.ThisParamMayNotBeOptional, node);
            }
          }
          typeAnnotation = this.flowParseTypeInitialiser();
        } else {
          typeAnnotation = this.flowParseType();
        }
        node.name = name;
        node.optional = optional;
        node.typeAnnotation = typeAnnotation;
        return this.finishNode(node, "FunctionTypeParam");
      }
      reinterpretTypeAsFunctionTypeParam(type) {
        const node = this.startNodeAt(type.loc.start);
        node.name = null;
        node.optional = false;
        node.typeAnnotation = type;
        return this.finishNode(node, "FunctionTypeParam");
      }
      flowParseFunctionTypeParams(params = []) {
        let rest = null;
        let _this = null;
        if (this.match(78)) {
          _this = this.flowParseFunctionTypeParam(true);
          _this.name = null;
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        while (!this.match(11) && !this.match(21)) {
          params.push(this.flowParseFunctionTypeParam(false));
          if (!this.match(11)) {
            this.expect(12);
          }
        }
        if (this.eat(21)) {
          rest = this.flowParseFunctionTypeParam(false);
        }
        return { params: params, rest: rest, _this: _this };
      }
      flowIdentToTypeAnnotation(startLoc, node, id) {
        switch (id.name) {
          case "any":
            return this.finishNode(node, "AnyTypeAnnotation");
          case "bool":
          case "boolean":
            return this.finishNode(node, "BooleanTypeAnnotation");
          case "mixed":
            return this.finishNode(node, "MixedTypeAnnotation");
          case "empty":
            return this.finishNode(node, "EmptyTypeAnnotation");
          case "number":
            return this.finishNode(node, "NumberTypeAnnotation");
          case "string":
            return this.finishNode(node, "StringTypeAnnotation");
          case "symbol":
            return this.finishNode(node, "SymbolTypeAnnotation");
          default:
            this.checkNotUnderscore(id.name);
            return this.flowParseGenericType(startLoc, id);
        }
      }
      flowParsePrimaryType() {
        const startLoc = this.state.startLoc;
        const node = this.startNode();
        let tmp;
        let type;
        let isGroupedType = false;
        const oldNoAnonFunctionType = this.state.noAnonFunctionType;
        switch (this.state.type) {
          case 5:
            return this.flowParseObjectType({
              allowStatic: false,
              allowExact: false,
              allowSpread: true,
              allowProto: false,
              allowInexact: true,
            });
          case 6:
            return this.flowParseObjectType({
              allowStatic: false,
              allowExact: true,
              allowSpread: true,
              allowProto: false,
              allowInexact: false,
            });
          case 0:
            this.state.noAnonFunctionType = false;
            type = this.flowParseTupleType();
            this.state.noAnonFunctionType = oldNoAnonFunctionType;
            return type;
          case 47:
            node.typeParameters = this.flowParseTypeParameterDeclaration();
            this.expect(10);
            tmp = this.flowParseFunctionTypeParams();
            node.params = tmp.params;
            node.rest = tmp.rest;
            node.this = tmp._this;
            this.expect(11);
            this.expect(19);
            node.returnType = this.flowParseType();
            return this.finishNode(node, "FunctionTypeAnnotation");
          case 10:
            this.next();
            if (!this.match(11) && !this.match(21)) {
              if (tokenIsIdentifier(this.state.type) || this.match(78)) {
                const token = this.lookahead().type;
                isGroupedType = token !== 17 && token !== 14;
              } else {
                isGroupedType = true;
              }
            }
            if (isGroupedType) {
              this.state.noAnonFunctionType = false;
              type = this.flowParseType();
              this.state.noAnonFunctionType = oldNoAnonFunctionType;
              if (
                this.state.noAnonFunctionType ||
                !(
                  this.match(12) ||
                  (this.match(11) && this.lookahead().type === 19)
                )
              ) {
                this.expect(11);
                return type;
              } else {
                this.eat(12);
              }
            }
            if (type) {
              tmp = this.flowParseFunctionTypeParams([
                this.reinterpretTypeAsFunctionTypeParam(type),
              ]);
            } else {
              tmp = this.flowParseFunctionTypeParams();
            }
            node.params = tmp.params;
            node.rest = tmp.rest;
            node.this = tmp._this;
            this.expect(11);
            this.expect(19);
            node.returnType = this.flowParseType();
            node.typeParameters = null;
            return this.finishNode(node, "FunctionTypeAnnotation");
          case 133:
            return this.parseLiteral(
              this.state.value,
              "StringLiteralTypeAnnotation",
            );
          case 85:
          case 86:
            node.value = this.match(85);
            this.next();
            return this.finishNode(node, "BooleanLiteralTypeAnnotation");
          case 53:
            if (this.state.value === "-") {
              this.next();
              if (this.match(134)) {
                return this.parseLiteralAtNode(
                  -this.state.value,
                  "NumberLiteralTypeAnnotation",
                  node,
                );
              }
              if (this.match(135)) {
                return this.parseLiteralAtNode(
                  -this.state.value,
                  "BigIntLiteralTypeAnnotation",
                  node,
                );
              }
              throw this.raise(
                FlowErrors.UnexpectedSubtractionOperand,
                this.state.startLoc,
              );
            }
            this.unexpected();
            return;
          case 134:
            return this.parseLiteral(
              this.state.value,
              "NumberLiteralTypeAnnotation",
            );
          case 135:
            return this.parseLiteral(
              this.state.value,
              "BigIntLiteralTypeAnnotation",
            );
          case 88:
            this.next();
            return this.finishNode(node, "VoidTypeAnnotation");
          case 84:
            this.next();
            return this.finishNode(node, "NullLiteralTypeAnnotation");
          case 78:
            this.next();
            return this.finishNode(node, "ThisTypeAnnotation");
          case 55:
            this.next();
            return this.finishNode(node, "ExistsTypeAnnotation");
          case 87:
            return this.flowParseTypeofType();
          default:
            if (tokenIsKeyword(this.state.type)) {
              const label = tokenLabelName(this.state.type);
              this.next();
              return super.createIdentifier(node, label);
            } else if (tokenIsIdentifier(this.state.type)) {
              if (this.isContextual(129)) {
                return this.flowParseInterfaceType();
              }
              return this.flowIdentToTypeAnnotation(
                startLoc,
                node,
                this.parseIdentifier(),
              );
            }
        }
        this.unexpected();
      }
      flowParsePostfixType() {
        const startLoc = this.state.startLoc;
        let type = this.flowParsePrimaryType();
        let seenOptionalIndexedAccess = false;
        while (
          (this.match(0) || this.match(18)) &&
          !this.canInsertSemicolon()
        ) {
          const node = this.startNodeAt(startLoc);
          const optional = this.eat(18);
          seenOptionalIndexedAccess = seenOptionalIndexedAccess || optional;
          this.expect(0);
          if (!optional && this.match(3)) {
            node.elementType = type;
            this.next();
            type = this.finishNode(node, "ArrayTypeAnnotation");
          } else {
            node.objectType = type;
            node.indexType = this.flowParseType();
            this.expect(3);
            if (seenOptionalIndexedAccess) {
              node.optional = optional;
              type = this.finishNode(node, "OptionalIndexedAccessType");
            } else {
              type = this.finishNode(node, "IndexedAccessType");
            }
          }
        }
        return type;
      }
      flowParsePrefixType() {
        const node = this.startNode();
        if (this.eat(17)) {
          node.typeAnnotation = this.flowParsePrefixType();
          return this.finishNode(node, "NullableTypeAnnotation");
        } else {
          return this.flowParsePostfixType();
        }
      }
      flowParseAnonFunctionWithoutParens() {
        const param = this.flowParsePrefixType();
        if (!this.state.noAnonFunctionType && this.eat(19)) {
          const node = this.startNodeAt(param.loc.start);
          node.params = [this.reinterpretTypeAsFunctionTypeParam(param)];
          node.rest = null;
          node.this = null;
          node.returnType = this.flowParseType();
          node.typeParameters = null;
          return this.finishNode(node, "FunctionTypeAnnotation");
        }
        return param;
      }
      flowParseIntersectionType() {
        const node = this.startNode();
        this.eat(45);
        const type = this.flowParseAnonFunctionWithoutParens();
        node.types = [type];
        while (this.eat(45)) {
          node.types.push(this.flowParseAnonFunctionWithoutParens());
        }
        return node.types.length === 1
          ? type
          : this.finishNode(node, "IntersectionTypeAnnotation");
      }
      flowParseUnionType() {
        const node = this.startNode();
        this.eat(43);
        const type = this.flowParseIntersectionType();
        node.types = [type];
        while (this.eat(43)) {
          node.types.push(this.flowParseIntersectionType());
        }
        return node.types.length === 1
          ? type
          : this.finishNode(node, "UnionTypeAnnotation");
      }
      flowParseType() {
        const oldInType = this.state.inType;
        this.state.inType = true;
        const type = this.flowParseUnionType();
        this.state.inType = oldInType;
        return type;
      }
      flowParseTypeOrImplicitInstantiation() {
        if (this.state.type === 132 && this.state.value === "_") {
          const startLoc = this.state.startLoc;
          const node = this.parseIdentifier();
          return this.flowParseGenericType(startLoc, node);
        } else {
          return this.flowParseType();
        }
      }
      flowParseTypeAnnotation() {
        const node = this.startNode();
        node.typeAnnotation = this.flowParseTypeInitialiser();
        return this.finishNode(node, "TypeAnnotation");
      }
      flowParseTypeAnnotatableIdentifier(allowPrimitiveOverride) {
        const ident = allowPrimitiveOverride
          ? this.parseIdentifier()
          : this.flowParseRestrictedIdentifier();
        if (this.match(14)) {
          ident.typeAnnotation = this.flowParseTypeAnnotation();
          this.resetEndLocation(ident);
        }
        return ident;
      }
      typeCastToParameter(node) {
        node.expression.typeAnnotation = node.typeAnnotation;
        this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
        return node.expression;
      }
      flowParseVariance() {
        let variance = null;
        if (this.match(53)) {
          variance = this.startNode();
          if (this.state.value === "+") {
            variance.kind = "plus";
          } else {
            variance.kind = "minus";
          }
          this.next();
          return this.finishNode(variance, "Variance");
        }
        return variance;
      }
      parseFunctionBody(node, allowExpressionBody, isMethod = false) {
        if (allowExpressionBody) {
          this.forwardNoArrowParamsConversionAt(node, () =>
            super.parseFunctionBody(node, true, isMethod),
          );
          return;
        }
        super.parseFunctionBody(node, false, isMethod);
      }
      parseFunctionBodyAndFinish(node, type, isMethod = false) {
        if (this.match(14)) {
          const typeNode = this.startNode();
          [typeNode.typeAnnotation, node.predicate] =
            this.flowParseTypeAndPredicateInitialiser();
          node.returnType = typeNode.typeAnnotation
            ? this.finishNode(typeNode, "TypeAnnotation")
            : null;
        }
        return super.parseFunctionBodyAndFinish(node, type, isMethod);
      }
      parseStatementLike(flags) {
        if (this.state.strict && this.isContextual(129)) {
          const lookahead = this.lookahead();
          if (tokenIsKeywordOrIdentifier(lookahead.type)) {
            const node = this.startNode();
            this.next();
            return this.flowParseInterface(node);
          }
        } else if (this.shouldParseEnums() && this.isContextual(126)) {
          const node = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(node);
        }
        const stmt = super.parseStatementLike(flags);
        if (this.flowPragma === undefined && !this.isValidDirective(stmt)) {
          this.flowPragma = null;
        }
        return stmt;
      }
      parseExpressionStatement(node, expr, decorators) {
        if (expr.type === "Identifier") {
          if (expr.name === "declare") {
            if (
              this.match(80) ||
              tokenIsIdentifier(this.state.type) ||
              this.match(68) ||
              this.match(74) ||
              this.match(82)
            ) {
              return this.flowParseDeclare(node);
            }
          } else if (tokenIsIdentifier(this.state.type)) {
            if (expr.name === "interface") {
              return this.flowParseInterface(node);
            } else if (expr.name === "type") {
              return this.flowParseTypeAlias(node);
            } else if (expr.name === "opaque") {
              return this.flowParseOpaqueType(node, false);
            }
          }
        }
        return super.parseExpressionStatement(node, expr, decorators);
      }
      shouldParseExportDeclaration() {
        const { type: type } = this.state;
        if (
          tokenIsFlowInterfaceOrTypeOrOpaque(type) ||
          (this.shouldParseEnums() && type === 126)
        ) {
          return !this.state.containsEsc;
        }
        return super.shouldParseExportDeclaration();
      }
      isExportDefaultSpecifier() {
        const { type: type } = this.state;
        if (
          tokenIsFlowInterfaceOrTypeOrOpaque(type) ||
          (this.shouldParseEnums() && type === 126)
        ) {
          return this.state.containsEsc;
        }
        return super.isExportDefaultSpecifier();
      }
      parseExportDefaultExpression() {
        if (this.shouldParseEnums() && this.isContextual(126)) {
          const node = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(node);
        }
        return super.parseExportDefaultExpression();
      }
      parseConditional(expr, startLoc, refExpressionErrors) {
        if (!this.match(17)) return expr;
        if (this.state.maybeInArrowParameters) {
          const nextCh = this.lookaheadCharCode();
          if (
            nextCh === 44 ||
            nextCh === 61 ||
            nextCh === 58 ||
            nextCh === 41
          ) {
            this.setOptionalParametersError(refExpressionErrors);
            return expr;
          }
        }
        this.expect(17);
        const state = this.state.clone();
        const originalNoArrowAt = this.state.noArrowAt;
        const node = this.startNodeAt(startLoc);
        let { consequent: consequent, failed: failed } =
          this.tryParseConditionalConsequent();
        let [valid, invalid] = this.getArrowLikeExpressions(consequent);
        if (failed || invalid.length > 0) {
          const noArrowAt = [...originalNoArrowAt];
          if (invalid.length > 0) {
            this.state = state;
            this.state.noArrowAt = noArrowAt;
            for (let i = 0; i < invalid.length; i++) {
              noArrowAt.push(invalid[i].start);
            }
            ({ consequent: consequent, failed: failed } =
              this.tryParseConditionalConsequent());
            [valid, invalid] = this.getArrowLikeExpressions(consequent);
          }
          if (failed && valid.length > 1) {
            this.raise(FlowErrors.AmbiguousConditionalArrow, state.startLoc);
          }
          if (failed && valid.length === 1) {
            this.state = state;
            noArrowAt.push(valid[0].start);
            this.state.noArrowAt = noArrowAt;
            ({ consequent: consequent, failed: failed } =
              this.tryParseConditionalConsequent());
          }
        }
        this.getArrowLikeExpressions(consequent, true);
        this.state.noArrowAt = originalNoArrowAt;
        this.expect(14);
        node.test = expr;
        node.consequent = consequent;
        node.alternate = this.forwardNoArrowParamsConversionAt(node, () =>
          this.parseMaybeAssign(undefined, undefined),
        );
        return this.finishNode(node, "ConditionalExpression");
      }
      tryParseConditionalConsequent() {
        this.state.noArrowParamsConversionAt.push(this.state.start);
        const consequent = this.parseMaybeAssignAllowIn();
        const failed = !this.match(14);
        this.state.noArrowParamsConversionAt.pop();
        return { consequent: consequent, failed: failed };
      }
      getArrowLikeExpressions(node, disallowInvalid) {
        const stack = [node];
        const arrows = [];
        while (stack.length !== 0) {
          const node = stack.pop();
          if (node.type === "ArrowFunctionExpression") {
            if (node.typeParameters || !node.returnType) {
              this.finishArrowValidation(node);
            } else {
              arrows.push(node);
            }
            stack.push(node.body);
          } else if (node.type === "ConditionalExpression") {
            stack.push(node.consequent);
            stack.push(node.alternate);
          }
        }
        if (disallowInvalid) {
          arrows.forEach((node) => this.finishArrowValidation(node));
          return [arrows, []];
        }
        return partition(arrows, (node) =>
          node.params.every((param) => this.isAssignable(param, true)),
        );
      }
      finishArrowValidation(node) {
        var _node$extra;
        this.toAssignableList(
          node.params,
          (_node$extra = node.extra) == null
            ? void 0
            : _node$extra.trailingCommaLoc,
          false,
        );
        this.scope.enter(2 | 4);
        super.checkParams(node, false, true);
        this.scope.exit();
      }
      forwardNoArrowParamsConversionAt(node, parse) {
        let result;
        if (this.state.noArrowParamsConversionAt.indexOf(node.start) !== -1) {
          this.state.noArrowParamsConversionAt.push(this.state.start);
          result = parse();
          this.state.noArrowParamsConversionAt.pop();
        } else {
          result = parse();
        }
        return result;
      }
      parseParenItem(node, startLoc) {
        node = super.parseParenItem(node, startLoc);
        if (this.eat(17)) {
          node.optional = true;
          this.resetEndLocation(node);
        }
        if (this.match(14)) {
          const typeCastNode = this.startNodeAt(startLoc);
          typeCastNode.expression = node;
          typeCastNode.typeAnnotation = this.flowParseTypeAnnotation();
          return this.finishNode(typeCastNode, "TypeCastExpression");
        }
        return node;
      }
      assertModuleNodeAllowed(node) {
        if (
          (node.type === "ImportDeclaration" &&
            (node.importKind === "type" || node.importKind === "typeof")) ||
          (node.type === "ExportNamedDeclaration" &&
            node.exportKind === "type") ||
          (node.type === "ExportAllDeclaration" && node.exportKind === "type")
        ) {
          return;
        }
        super.assertModuleNodeAllowed(node);
      }
      parseExportDeclaration(node) {
        if (this.isContextual(130)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          if (this.match(5)) {
            node.specifiers = this.parseExportSpecifiers(true);
            super.parseExportFrom(node);
            return null;
          } else {
            return this.flowParseTypeAlias(declarationNode);
          }
        } else if (this.isContextual(131)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseOpaqueType(declarationNode, false);
        } else if (this.isContextual(129)) {
          node.exportKind = "type";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseInterface(declarationNode);
        } else if (this.shouldParseEnums() && this.isContextual(126)) {
          node.exportKind = "value";
          const declarationNode = this.startNode();
          this.next();
          return this.flowParseEnumDeclaration(declarationNode);
        } else {
          return super.parseExportDeclaration(node);
        }
      }
      eatExportStar(node) {
        if (super.eatExportStar(node)) return true;
        if (this.isContextual(130) && this.lookahead().type === 55) {
          node.exportKind = "type";
          this.next();
          this.next();
          return true;
        }
        return false;
      }
      maybeParseExportNamespaceSpecifier(node) {
        const { startLoc: startLoc } = this.state;
        const hasNamespace = super.maybeParseExportNamespaceSpecifier(node);
        if (hasNamespace && node.exportKind === "type") {
          this.unexpected(startLoc);
        }
        return hasNamespace;
      }
      parseClassId(node, isStatement, optionalId) {
        super.parseClassId(node, isStatement, optionalId);
        if (this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
      }
      parseClassMember(classBody, member, state) {
        const { startLoc: startLoc } = this.state;
        if (this.isContextual(125)) {
          if (super.parseClassMemberFromModifier(classBody, member)) {
            return;
          }
          member.declare = true;
        }
        super.parseClassMember(classBody, member, state);
        if (member.declare) {
          if (
            member.type !== "ClassProperty" &&
            member.type !== "ClassPrivateProperty" &&
            member.type !== "PropertyDefinition"
          ) {
            this.raise(FlowErrors.DeclareClassElement, startLoc);
          } else if (member.value) {
            this.raise(FlowErrors.DeclareClassFieldInitializer, member.value);
          }
        }
      }
      isIterator(word) {
        return word === "iterator" || word === "asyncIterator";
      }
      readIterator() {
        const word = super.readWord1();
        const fullWord = "@@" + word;
        if (!this.isIterator(word) || !this.state.inType) {
          this.raise(Errors.InvalidIdentifier, this.state.curPosition(), {
            identifierName: fullWord,
          });
        }
        this.finishToken(132, fullWord);
      }
      getTokenFromCode(code) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code === 123 && next === 124) {
          this.finishOp(6, 2);
        } else if (this.state.inType && (code === 62 || code === 60)) {
          this.finishOp(code === 62 ? 48 : 47, 1);
        } else if (this.state.inType && code === 63) {
          if (next === 46) {
            this.finishOp(18, 2);
          } else {
            this.finishOp(17, 1);
          }
        } else if (
          isIteratorStart(code, next, this.input.charCodeAt(this.state.pos + 2))
        ) {
          this.state.pos += 2;
          this.readIterator();
        } else {
          super.getTokenFromCode(code);
        }
      }
      isAssignable(node, isBinding) {
        if (node.type === "TypeCastExpression") {
          return this.isAssignable(node.expression, isBinding);
        } else {
          return super.isAssignable(node, isBinding);
        }
      }
      toAssignable(node, isLHS = false) {
        if (
          !isLHS &&
          node.type === "AssignmentExpression" &&
          node.left.type === "TypeCastExpression"
        ) {
          node.left = this.typeCastToParameter(node.left);
        }
        super.toAssignable(node, isLHS);
      }
      toAssignableList(exprList, trailingCommaLoc, isLHS) {
        for (let i = 0; i < exprList.length; i++) {
          const expr = exprList[i];
          if ((expr == null ? void 0 : expr.type) === "TypeCastExpression") {
            exprList[i] = this.typeCastToParameter(expr);
          }
        }
        super.toAssignableList(exprList, trailingCommaLoc, isLHS);
      }
      toReferencedList(exprList, isParenthesizedExpr) {
        for (let i = 0; i < exprList.length; i++) {
          var _expr$extra;
          const expr = exprList[i];
          if (
            expr &&
            expr.type === "TypeCastExpression" &&
            !(
              (_expr$extra = expr.extra) != null && _expr$extra.parenthesized
            ) &&
            (exprList.length > 1 || !isParenthesizedExpr)
          ) {
            this.raise(FlowErrors.TypeCastInPattern, expr.typeAnnotation);
          }
        }
        return exprList;
      }
      parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
        const node = super.parseArrayLike(
          close,
          canBePattern,
          isTuple,
          refExpressionErrors,
        );
        if (canBePattern && !this.state.maybeInArrowParameters) {
          this.toReferencedList(node.elements);
        }
        return node;
      }
      isValidLVal(type, isParenthesized, binding) {
        return (
          type === "TypeCastExpression" ||
          super.isValidLVal(type, isParenthesized, binding)
        );
      }
      parseClassProperty(node) {
        if (this.match(14)) {
          node.typeAnnotation = this.flowParseTypeAnnotation();
        }
        return super.parseClassProperty(node);
      }
      parseClassPrivateProperty(node) {
        if (this.match(14)) {
          node.typeAnnotation = this.flowParseTypeAnnotation();
        }
        return super.parseClassPrivateProperty(node);
      }
      isClassMethod() {
        return this.match(47) || super.isClassMethod();
      }
      isClassProperty() {
        return this.match(14) || super.isClassProperty();
      }
      isNonstaticConstructor(method) {
        return !this.match(14) && super.isNonstaticConstructor(method);
      }
      pushClassMethod(
        classBody,
        method,
        isGenerator,
        isAsync,
        isConstructor,
        allowsDirectSuper,
      ) {
        if (method.variance) {
          this.unexpected(method.variance.loc.start);
        }
        delete method.variance;
        if (this.match(47)) {
          method.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.pushClassMethod(
          classBody,
          method,
          isGenerator,
          isAsync,
          isConstructor,
          allowsDirectSuper,
        );
        if (method.params && isConstructor) {
          const params = method.params;
          if (params.length > 0 && this.isThisParam(params[0])) {
            this.raise(FlowErrors.ThisParamBannedInConstructor, method);
          }
        } else if (
          method.type === "MethodDefinition" &&
          isConstructor &&
          method.value.params
        ) {
          const params = method.value.params;
          if (params.length > 0 && this.isThisParam(params[0])) {
            this.raise(FlowErrors.ThisParamBannedInConstructor, method);
          }
        }
      }
      pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
        if (method.variance) {
          this.unexpected(method.variance.loc.start);
        }
        delete method.variance;
        if (this.match(47)) {
          method.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
      }
      parseClassSuper(node) {
        super.parseClassSuper(node);
        if (node.superClass && this.match(47)) {
          node.superTypeParameters = this.flowParseTypeParameterInstantiation();
        }
        if (this.isContextual(113)) {
          this.next();
          const implemented = (node.implements = []);
          do {
            const node = this.startNode();
            node.id = this.flowParseRestrictedIdentifier(true);
            if (this.match(47)) {
              node.typeParameters = this.flowParseTypeParameterInstantiation();
            } else {
              node.typeParameters = null;
            }
            implemented.push(this.finishNode(node, "ClassImplements"));
          } while (this.eat(12));
        }
      }
      checkGetterSetterParams(method) {
        super.checkGetterSetterParams(method);
        const params = this.getObjectOrClassMethodParams(method);
        if (params.length > 0) {
          const param = params[0];
          if (this.isThisParam(param) && method.kind === "get") {
            this.raise(FlowErrors.GetterMayNotHaveThisParam, param);
          } else if (this.isThisParam(param)) {
            this.raise(FlowErrors.SetterMayNotHaveThisParam, param);
          }
        }
      }
      parsePropertyNamePrefixOperator(node) {
        node.variance = this.flowParseVariance();
      }
      parseObjPropValue(
        prop,
        startLoc,
        isGenerator,
        isAsync,
        isPattern,
        isAccessor,
        refExpressionErrors,
      ) {
        if (prop.variance) {
          this.unexpected(prop.variance.loc.start);
        }
        delete prop.variance;
        let typeParameters;
        if (this.match(47) && !isAccessor) {
          typeParameters = this.flowParseTypeParameterDeclaration();
          if (!this.match(10)) this.unexpected();
        }
        const result = super.parseObjPropValue(
          prop,
          startLoc,
          isGenerator,
          isAsync,
          isPattern,
          isAccessor,
          refExpressionErrors,
        );
        if (typeParameters) {
          (result.value || result).typeParameters = typeParameters;
        }
        return result;
      }
      parseAssignableListItemTypes(param) {
        if (this.eat(17)) {
          if (param.type !== "Identifier") {
            this.raise(FlowErrors.PatternIsOptional, param);
          }
          if (this.isThisParam(param)) {
            this.raise(FlowErrors.ThisParamMayNotBeOptional, param);
          }
          param.optional = true;
        }
        if (this.match(14)) {
          param.typeAnnotation = this.flowParseTypeAnnotation();
        } else if (this.isThisParam(param)) {
          this.raise(FlowErrors.ThisParamAnnotationRequired, param);
        }
        if (this.match(29) && this.isThisParam(param)) {
          this.raise(FlowErrors.ThisParamNoDefault, param);
        }
        this.resetEndLocation(param);
        return param;
      }
      parseMaybeDefault(startLoc, left) {
        const node = super.parseMaybeDefault(startLoc, left);
        if (
          node.type === "AssignmentPattern" &&
          node.typeAnnotation &&
          node.right.start < node.typeAnnotation.start
        ) {
          this.raise(FlowErrors.TypeBeforeInitializer, node.typeAnnotation);
        }
        return node;
      }
      checkImportReflection(node) {
        super.checkImportReflection(node);
        if (node.module && node.importKind !== "value") {
          this.raise(
            FlowErrors.ImportReflectionHasImportType,
            node.specifiers[0].loc.start,
          );
        }
      }
      parseImportSpecifierLocal(node, specifier, type) {
        specifier.local = hasTypeImportKind(node)
          ? this.flowParseRestrictedIdentifier(true, true)
          : this.parseIdentifier();
        node.specifiers.push(this.finishImportSpecifier(specifier, type));
      }
      isPotentialImportPhase(isExport) {
        if (super.isPotentialImportPhase(isExport)) return true;
        if (this.isContextual(130)) {
          if (!isExport) return true;
          const ch = this.lookaheadCharCode();
          return ch === 123 || ch === 42;
        }
        return !isExport && this.isContextual(87);
      }
      applyImportPhase(node, isExport, phase, loc) {
        super.applyImportPhase(node, isExport, phase, loc);
        if (isExport) {
          if (!phase && this.match(65)) {
            return;
          }
          node.exportKind = phase === "type" ? phase : "value";
        } else {
          if (phase === "type" && this.match(55)) this.unexpected();
          node.importKind =
            phase === "type" || phase === "typeof" ? phase : "value";
        }
      }
      parseImportSpecifier(
        specifier,
        importedIsString,
        isInTypeOnlyImport,
        isMaybeTypeOnly,
        bindingType,
      ) {
        const firstIdent = specifier.imported;
        let specifierTypeKind = null;
        if (firstIdent.type === "Identifier") {
          if (firstIdent.name === "type") {
            specifierTypeKind = "type";
          } else if (firstIdent.name === "typeof") {
            specifierTypeKind = "typeof";
          }
        }
        let isBinding = false;
        if (this.isContextual(93) && !this.isLookaheadContextual("as")) {
          const as_ident = this.parseIdentifier(true);
          if (
            specifierTypeKind !== null &&
            !tokenIsKeywordOrIdentifier(this.state.type)
          ) {
            specifier.imported = as_ident;
            specifier.importKind = specifierTypeKind;
            specifier.local = cloneIdentifier(as_ident);
          } else {
            specifier.imported = firstIdent;
            specifier.importKind = null;
            specifier.local = this.parseIdentifier();
          }
        } else {
          if (
            specifierTypeKind !== null &&
            tokenIsKeywordOrIdentifier(this.state.type)
          ) {
            specifier.imported = this.parseIdentifier(true);
            specifier.importKind = specifierTypeKind;
          } else {
            if (importedIsString) {
              throw this.raise(Errors.ImportBindingIsString, specifier, {
                importName: firstIdent.value,
              });
            }
            specifier.imported = firstIdent;
            specifier.importKind = null;
          }
          if (this.eatContextual(93)) {
            specifier.local = this.parseIdentifier();
          } else {
            isBinding = true;
            specifier.local = cloneIdentifier(specifier.imported);
          }
        }
        const specifierIsTypeImport = hasTypeImportKind(specifier);
        if (isInTypeOnlyImport && specifierIsTypeImport) {
          this.raise(FlowErrors.ImportTypeShorthandOnlyInPureImport, specifier);
        }
        if (isInTypeOnlyImport || specifierIsTypeImport) {
          this.checkReservedType(
            specifier.local.name,
            specifier.local.loc.start,
            true,
          );
        }
        if (isBinding && !isInTypeOnlyImport && !specifierIsTypeImport) {
          this.checkReservedWord(
            specifier.local.name,
            specifier.loc.start,
            true,
            true,
          );
        }
        return this.finishImportSpecifier(specifier, "ImportSpecifier");
      }
      parseBindingAtom() {
        switch (this.state.type) {
          case 78:
            return this.parseIdentifier(true);
          default:
            return super.parseBindingAtom();
        }
      }
      parseFunctionParams(node, isConstructor) {
        const kind = node.kind;
        if (kind !== "get" && kind !== "set" && this.match(47)) {
          node.typeParameters = this.flowParseTypeParameterDeclaration();
        }
        super.parseFunctionParams(node, isConstructor);
      }
      parseVarId(decl, kind) {
        super.parseVarId(decl, kind);
        if (this.match(14)) {
          decl.id.typeAnnotation = this.flowParseTypeAnnotation();
          this.resetEndLocation(decl.id);
        }
      }
      parseAsyncArrowFromCallExpression(node, call) {
        if (this.match(14)) {
          const oldNoAnonFunctionType = this.state.noAnonFunctionType;
          this.state.noAnonFunctionType = true;
          node.returnType = this.flowParseTypeAnnotation();
          this.state.noAnonFunctionType = oldNoAnonFunctionType;
        }
        return super.parseAsyncArrowFromCallExpression(node, call);
      }
      shouldParseAsyncArrow() {
        return this.match(14) || super.shouldParseAsyncArrow();
      }
      parseMaybeAssign(refExpressionErrors, afterLeftParse) {
        var _jsx;
        let state = null;
        let jsx;
        if (this.hasPlugin("jsx") && (this.match(142) || this.match(47))) {
          state = this.state.clone();
          jsx = this.tryParse(
            () => super.parseMaybeAssign(refExpressionErrors, afterLeftParse),
            state,
          );
          if (!jsx.error) return jsx.node;
          const { context: context } = this.state;
          const currentContext = context[context.length - 1];
          if (
            currentContext === types.j_oTag ||
            currentContext === types.j_expr
          ) {
            context.pop();
          }
        }
        if (((_jsx = jsx) != null && _jsx.error) || this.match(47)) {
          var _jsx2, _jsx3;
          state = state || this.state.clone();
          let typeParameters;
          const arrow = this.tryParse((abort) => {
            var _arrowExpression$extr;
            typeParameters = this.flowParseTypeParameterDeclaration();
            const arrowExpression = this.forwardNoArrowParamsConversionAt(
              typeParameters,
              () => {
                const result = super.parseMaybeAssign(
                  refExpressionErrors,
                  afterLeftParse,
                );
                this.resetStartLocationFromNode(result, typeParameters);
                return result;
              },
            );
            if (
              (_arrowExpression$extr = arrowExpression.extra) != null &&
              _arrowExpression$extr.parenthesized
            )
              abort();
            const expr = this.maybeUnwrapTypeCastExpression(arrowExpression);
            if (expr.type !== "ArrowFunctionExpression") abort();
            expr.typeParameters = typeParameters;
            this.resetStartLocationFromNode(expr, typeParameters);
            return arrowExpression;
          }, state);
          let arrowExpression = null;
          if (
            arrow.node &&
            this.maybeUnwrapTypeCastExpression(arrow.node).type ===
              "ArrowFunctionExpression"
          ) {
            if (!arrow.error && !arrow.aborted) {
              if (arrow.node.async) {
                this.raise(
                  FlowErrors.UnexpectedTypeParameterBeforeAsyncArrowFunction,
                  typeParameters,
                );
              }
              return arrow.node;
            }
            arrowExpression = arrow.node;
          }
          if ((_jsx2 = jsx) != null && _jsx2.node) {
            this.state = jsx.failState;
            return jsx.node;
          }
          if (arrowExpression) {
            this.state = arrow.failState;
            return arrowExpression;
          }
          if ((_jsx3 = jsx) != null && _jsx3.thrown) throw jsx.error;
          if (arrow.thrown) throw arrow.error;
          throw this.raise(
            FlowErrors.UnexpectedTokenAfterTypeParameter,
            typeParameters,
          );
        }
        return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
      }
      parseArrow(node) {
        if (this.match(14)) {
          const result = this.tryParse(() => {
            const oldNoAnonFunctionType = this.state.noAnonFunctionType;
            this.state.noAnonFunctionType = true;
            const typeNode = this.startNode();
            [typeNode.typeAnnotation, node.predicate] =
              this.flowParseTypeAndPredicateInitialiser();
            this.state.noAnonFunctionType = oldNoAnonFunctionType;
            if (this.canInsertSemicolon()) this.unexpected();
            if (!this.match(19)) this.unexpected();
            return typeNode;
          });
          if (result.thrown) return null;
          if (result.error) this.state = result.failState;
          node.returnType = result.node.typeAnnotation
            ? this.finishNode(result.node, "TypeAnnotation")
            : null;
        }
        return super.parseArrow(node);
      }
      shouldParseArrow(params) {
        return this.match(14) || super.shouldParseArrow(params);
      }
      setArrowFunctionParameters(node, params) {
        if (this.state.noArrowParamsConversionAt.indexOf(node.start) !== -1) {
          node.params = params;
        } else {
          super.setArrowFunctionParameters(node, params);
        }
      }
      checkParams(
        node,
        allowDuplicates,
        isArrowFunction,
        strictModeChanged = true,
      ) {
        if (
          isArrowFunction &&
          this.state.noArrowParamsConversionAt.indexOf(node.start) !== -1
        ) {
          return;
        }
        for (let i = 0; i < node.params.length; i++) {
          if (this.isThisParam(node.params[i]) && i > 0) {
            this.raise(FlowErrors.ThisParamMustBeFirst, node.params[i]);
          }
        }
        super.checkParams(
          node,
          allowDuplicates,
          isArrowFunction,
          strictModeChanged,
        );
      }
      parseParenAndDistinguishExpression(canBeArrow) {
        return super.parseParenAndDistinguishExpression(
          canBeArrow && this.state.noArrowAt.indexOf(this.state.start) === -1,
        );
      }
      parseSubscripts(base, startLoc, noCalls) {
        if (
          base.type === "Identifier" &&
          base.name === "async" &&
          this.state.noArrowAt.indexOf(startLoc.index) !== -1
        ) {
          this.next();
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          node.arguments = super.parseCallExpressionArguments(11, false);
          base = this.finishNode(node, "CallExpression");
        } else if (
          base.type === "Identifier" &&
          base.name === "async" &&
          this.match(47)
        ) {
          const state = this.state.clone();
          const arrow = this.tryParse(
            (abort) =>
              this.parseAsyncArrowWithTypeParameters(startLoc) || abort(),
            state,
          );
          if (!arrow.error && !arrow.aborted) return arrow.node;
          const result = this.tryParse(
            () => super.parseSubscripts(base, startLoc, noCalls),
            state,
          );
          if (result.node && !result.error) return result.node;
          if (arrow.node) {
            this.state = arrow.failState;
            return arrow.node;
          }
          if (result.node) {
            this.state = result.failState;
            return result.node;
          }
          throw arrow.error || result.error;
        }
        return super.parseSubscripts(base, startLoc, noCalls);
      }
      parseSubscript(base, startLoc, noCalls, subscriptState) {
        if (this.match(18) && this.isLookaheadToken_lt()) {
          subscriptState.optionalChainMember = true;
          if (noCalls) {
            subscriptState.stop = true;
            return base;
          }
          this.next();
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          node.typeArguments = this.flowParseTypeParameterInstantiation();
          this.expect(10);
          node.arguments = this.parseCallExpressionArguments(11, false);
          node.optional = true;
          return this.finishCallExpression(node, true);
        } else if (!noCalls && this.shouldParseTypes() && this.match(47)) {
          const node = this.startNodeAt(startLoc);
          node.callee = base;
          const result = this.tryParse(() => {
            node.typeArguments =
              this.flowParseTypeParameterInstantiationCallOrNew();
            this.expect(10);
            node.arguments = super.parseCallExpressionArguments(11, false);
            if (subscriptState.optionalChainMember) {
              node.optional = false;
            }
            return this.finishCallExpression(
              node,
              subscriptState.optionalChainMember,
            );
          });
          if (result.node) {
            if (result.error) this.state = result.failState;
            return result.node;
          }
        }
        return super.parseSubscript(base, startLoc, noCalls, subscriptState);
      }
      parseNewCallee(node) {
        super.parseNewCallee(node);
        let targs = null;
        if (this.shouldParseTypes() && this.match(47)) {
          targs = this.tryParse(() =>
            this.flowParseTypeParameterInstantiationCallOrNew(),
          ).node;
        }
        node.typeArguments = targs;
      }
      parseAsyncArrowWithTypeParameters(startLoc) {
        const node = this.startNodeAt(startLoc);
        this.parseFunctionParams(node, false);
        if (!this.parseArrow(node)) return;
        return super.parseArrowExpression(node, undefined, true);
      }
      readToken_mult_modulo(code) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code === 42 && next === 47 && this.state.hasFlowComment) {
          this.state.hasFlowComment = false;
          this.state.pos += 2;
          this.nextToken();
          return;
        }
        super.readToken_mult_modulo(code);
      }
      readToken_pipe_amp(code) {
        const next = this.input.charCodeAt(this.state.pos + 1);
        if (code === 124 && next === 125) {
          this.finishOp(9, 2);
          return;
        }
        super.readToken_pipe_amp(code);
      }
      parseTopLevel(file, program) {
        const fileNode = super.parseTopLevel(file, program);
        if (this.state.hasFlowComment) {
          this.raise(
            FlowErrors.UnterminatedFlowComment,
            this.state.curPosition(),
          );
        }
        return fileNode;
      }
      skipBlockComment() {
        if (this.hasPlugin("flowComments") && this.skipFlowComment()) {
          if (this.state.hasFlowComment) {
            throw this.raise(FlowErrors.NestedFlowComment, this.state.startLoc);
          }
          this.hasFlowCommentCompletion();
          const commentSkip = this.skipFlowComment();
          if (commentSkip) {
            this.state.pos += commentSkip;
            this.state.hasFlowComment = true;
          }
          return;
        }
        return super.skipBlockComment(this.state.hasFlowComment ? "*-/" : "*/");
      }
      skipFlowComment() {
        const { pos: pos } = this.state;
        let shiftToFirstNonWhiteSpace = 2;
        while (
          [32, 9].includes(
            this.input.charCodeAt(pos + shiftToFirstNonWhiteSpace),
          )
        ) {
          shiftToFirstNonWhiteSpace++;
        }
        const ch2 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos);
        const ch3 = this.input.charCodeAt(shiftToFirstNonWhiteSpace + pos + 1);
        if (ch2 === 58 && ch3 === 58) {
          return shiftToFirstNonWhiteSpace + 2;
        }
        if (
          this.input.slice(
            shiftToFirstNonWhiteSpace + pos,
            shiftToFirstNonWhiteSpace + pos + 12,
          ) === "flow-include"
        ) {
          return shiftToFirstNonWhiteSpace + 12;
        }
        if (ch2 === 58 && ch3 !== 58) {
          return shiftToFirstNonWhiteSpace;
        }
        return false;
      }
      hasFlowCommentCompletion() {
        const end = this.input.indexOf("*/", this.state.pos);
        if (end === -1) {
          throw this.raise(
            Errors.UnterminatedComment,
            this.state.curPosition(),
          );
        }
      }
      flowEnumErrorBooleanMemberNotInitialized(
        loc,
        { enumName: enumName, memberName: memberName },
      ) {
        this.raise(FlowErrors.EnumBooleanMemberNotInitialized, loc, {
          memberName: memberName,
          enumName: enumName,
        });
      }
      flowEnumErrorInvalidMemberInitializer(loc, enumContext) {
        return this.raise(
          !enumContext.explicitType
            ? FlowErrors.EnumInvalidMemberInitializerUnknownType
            : enumContext.explicitType === "symbol"
              ? FlowErrors.EnumInvalidMemberInitializerSymbolType
              : FlowErrors.EnumInvalidMemberInitializerPrimaryType,
          loc,
          enumContext,
        );
      }
      flowEnumErrorNumberMemberNotInitialized(loc, details) {
        this.raise(FlowErrors.EnumNumberMemberNotInitialized, loc, details);
      }
      flowEnumErrorStringMemberInconsistentlyInitialized(node, details) {
        this.raise(
          FlowErrors.EnumStringMemberInconsistentlyInitialized,
          node,
          details,
        );
      }
      flowEnumMemberInit() {
        const startLoc = this.state.startLoc;
        const endOfInit = () => this.match(12) || this.match(8);
        switch (this.state.type) {
          case 134: {
            const literal = this.parseNumericLiteral(this.state.value);
            if (endOfInit()) {
              return { type: "number", loc: literal.loc.start, value: literal };
            }
            return { type: "invalid", loc: startLoc };
          }
          case 133: {
            const literal = this.parseStringLiteral(this.state.value);
            if (endOfInit()) {
              return { type: "string", loc: literal.loc.start, value: literal };
            }
            return { type: "invalid", loc: startLoc };
          }
          case 85:
          case 86: {
            const literal = this.parseBooleanLiteral(this.match(85));
            if (endOfInit()) {
              return {
                type: "boolean",
                loc: literal.loc.start,
                value: literal,
              };
            }
            return { type: "invalid", loc: startLoc };
          }
          default:
            return { type: "invalid", loc: startLoc };
        }
      }
      flowEnumMemberRaw() {
        const loc = this.state.startLoc;
        const id = this.parseIdentifier(true);
        const init = this.eat(29)
          ? this.flowEnumMemberInit()
          : { type: "none", loc: loc };
        return { id: id, init: init };
      }
      flowEnumCheckExplicitTypeMismatch(loc, context, expectedType) {
        const { explicitType: explicitType } = context;
        if (explicitType === null) {
          return;
        }
        if (explicitType !== expectedType) {
          this.flowEnumErrorInvalidMemberInitializer(loc, context);
        }
      }
      flowEnumMembers({ enumName: enumName, explicitType: explicitType }) {
        const seenNames = new Set();
        const members = {
          booleanMembers: [],
          numberMembers: [],
          stringMembers: [],
          defaultedMembers: [],
        };
        let hasUnknownMembers = false;
        while (!this.match(8)) {
          if (this.eat(21)) {
            hasUnknownMembers = true;
            break;
          }
          const memberNode = this.startNode();
          const { id: id, init: init } = this.flowEnumMemberRaw();
          const memberName = id.name;
          if (memberName === "") {
            continue;
          }
          if (/^[a-z]/.test(memberName)) {
            this.raise(FlowErrors.EnumInvalidMemberName, id, {
              memberName: memberName,
              suggestion: memberName[0].toUpperCase() + memberName.slice(1),
              enumName: enumName,
            });
          }
          if (seenNames.has(memberName)) {
            this.raise(FlowErrors.EnumDuplicateMemberName, id, {
              memberName: memberName,
              enumName: enumName,
            });
          }
          seenNames.add(memberName);
          const context = {
            enumName: enumName,
            explicitType: explicitType,
            memberName: memberName,
          };
          memberNode.id = id;
          switch (init.type) {
            case "boolean": {
              this.flowEnumCheckExplicitTypeMismatch(
                init.loc,
                context,
                "boolean",
              );
              memberNode.init = init.value;
              members.booleanMembers.push(
                this.finishNode(memberNode, "EnumBooleanMember"),
              );
              break;
            }
            case "number": {
              this.flowEnumCheckExplicitTypeMismatch(
                init.loc,
                context,
                "number",
              );
              memberNode.init = init.value;
              members.numberMembers.push(
                this.finishNode(memberNode, "EnumNumberMember"),
              );
              break;
            }
            case "string": {
              this.flowEnumCheckExplicitTypeMismatch(
                init.loc,
                context,
                "string",
              );
              memberNode.init = init.value;
              members.stringMembers.push(
                this.finishNode(memberNode, "EnumStringMember"),
              );
              break;
            }
            case "invalid": {
              throw this.flowEnumErrorInvalidMemberInitializer(
                init.loc,
                context,
              );
            }
            case "none": {
              switch (explicitType) {
                case "boolean":
                  this.flowEnumErrorBooleanMemberNotInitialized(
                    init.loc,
                    context,
                  );
                  break;
                case "number":
                  this.flowEnumErrorNumberMemberNotInitialized(
                    init.loc,
                    context,
                  );
                  break;
                default:
                  members.defaultedMembers.push(
                    this.finishNode(memberNode, "EnumDefaultedMember"),
                  );
              }
            }
          }
          if (!this.match(8)) {
            this.expect(12);
          }
        }
        return { members: members, hasUnknownMembers: hasUnknownMembers };
      }
      flowEnumStringMembers(
        initializedMembers,
        defaultedMembers,
        { enumName: enumName },
      ) {
        if (initializedMembers.length === 0) {
          return defaultedMembers;
        } else if (defaultedMembers.length === 0) {
          return initializedMembers;
        } else if (defaultedMembers.length > initializedMembers.length) {
          for (const member of initializedMembers) {
            this.flowEnumErrorStringMemberInconsistentlyInitialized(member, {
              enumName: enumName,
            });
          }
          return defaultedMembers;
        } else {
          for (const member of defaultedMembers) {
            this.flowEnumErrorStringMemberInconsistentlyInitialized(member, {
              enumName: enumName,
            });
          }
          return initializedMembers;
        }
      }
      flowEnumParseExplicitType({ enumName: enumName }) {
        if (!this.eatContextual(102)) return null;
        if (!tokenIsIdentifier(this.state.type)) {
          throw this.raise(
            FlowErrors.EnumInvalidExplicitTypeUnknownSupplied,
            this.state.startLoc,
            { enumName: enumName },
          );
        }
        const { value: value } = this.state;
        this.next();
        if (
          value !== "boolean" &&
          value !== "number" &&
          value !== "string" &&
          value !== "symbol"
        ) {
          this.raise(FlowErrors.EnumInvalidExplicitType, this.state.startLoc, {
            enumName: enumName,
            invalidEnumType: value,
          });
        }
        return value;
      }
      flowEnumBody(node, id) {
        const enumName = id.name;
        const nameLoc = id.loc.start;
        const explicitType = this.flowEnumParseExplicitType({
          enumName: enumName,
        });
        this.expect(5);
        const { members: members, hasUnknownMembers: hasUnknownMembers } =
          this.flowEnumMembers({
            enumName: enumName,
            explicitType: explicitType,
          });
        node.hasUnknownMembers = hasUnknownMembers;
        switch (explicitType) {
          case "boolean":
            node.explicitType = true;
            node.members = members.booleanMembers;
            this.expect(8);
            return this.finishNode(node, "EnumBooleanBody");
          case "number":
            node.explicitType = true;
            node.members = members.numberMembers;
            this.expect(8);
            return this.finishNode(node, "EnumNumberBody");
          case "string":
            node.explicitType = true;
            node.members = this.flowEnumStringMembers(
              members.stringMembers,
              members.defaultedMembers,
              { enumName: enumName },
            );
            this.expect(8);
            return this.finishNode(node, "EnumStringBody");
          case "symbol":
            node.members = members.defaultedMembers;
            this.expect(8);
            return this.finishNode(node, "EnumSymbolBody");
          default: {
            const empty = () => {
              node.members = [];
              this.expect(8);
              return this.finishNode(node, "EnumStringBody");
            };
            node.explicitType = false;
            const boolsLen = members.booleanMembers.length;
            const numsLen = members.numberMembers.length;
            const strsLen = members.stringMembers.length;
            const defaultedLen = members.defaultedMembers.length;
            if (!boolsLen && !numsLen && !strsLen && !defaultedLen) {
              return empty();
            } else if (!boolsLen && !numsLen) {
              node.members = this.flowEnumStringMembers(
                members.stringMembers,
                members.defaultedMembers,
                { enumName: enumName },
              );
              this.expect(8);
              return this.finishNode(node, "EnumStringBody");
            } else if (!numsLen && !strsLen && boolsLen >= defaultedLen) {
              for (const member of members.defaultedMembers) {
                this.flowEnumErrorBooleanMemberNotInitialized(
                  member.loc.start,
                  { enumName: enumName, memberName: member.id.name },
                );
              }
              node.members = members.booleanMembers;
              this.expect(8);
              return this.finishNode(node, "EnumBooleanBody");
            } else if (!boolsLen && !strsLen && numsLen >= defaultedLen) {
              for (const member of members.defaultedMembers) {
                this.flowEnumErrorNumberMemberNotInitialized(member.loc.start, {
                  enumName: enumName,
                  memberName: member.id.name,
                });
              }
              node.members = members.numberMembers;
              this.expect(8);
              return this.finishNode(node, "EnumNumberBody");
            } else {
              this.raise(FlowErrors.EnumInconsistentMemberValues, nameLoc, {
                enumName: enumName,
              });
              return empty();
            }
          }
        }
      }
      flowParseEnumDeclaration(node) {
        const id = this.parseIdentifier();
        node.id = id;
        node.body = this.flowEnumBody(this.startNode(), id);
        return this.finishNode(node, "EnumDeclaration");
      }
      isLookaheadToken_lt() {
        const next = this.nextTokenStart();
        if (this.input.charCodeAt(next) === 60) {
          const afterNext = this.input.charCodeAt(next + 1);
          return afterNext !== 60 && afterNext !== 61;
        }
        return false;
      }
      maybeUnwrapTypeCastExpression(node) {
        return node.type === "TypeCastExpression" ? node.expression : node;
      }
    };
  const entities = {
    __proto__: null,
    quot: '"',
    amp: "&",
    apos: "'",
    lt: "<",
    gt: ">",
    nbsp: " ",
    iexcl: "¡",
    cent: "¢",
    pound: "£",
    curren: "¤",
    yen: "¥",
    brvbar: "¦",
    sect: "§",
    uml: "¨",
    copy: "©",
    ordf: "ª",
    laquo: "«",
    not: "¬",
    shy: "­",
    reg: "®",
    macr: "¯",
    deg: "°",
    plusmn: "±",
    sup2: "²",
    sup3: "³",
    acute: "´",
    micro: "µ",
    para: "¶",
    middot: "·",
    cedil: "¸",
    sup1: "¹",
    ordm: "º",
    raquo: "»",
    frac14: "¼",
    frac12: "½",
    frac34: "¾",
    iquest: "¿",
    Agrave: "À",
    Aacute: "Á",
    Acirc: "Â",
    Atilde: "Ã",
    Auml: "Ä",
    Aring: "Å",
    AElig: "Æ",
    Ccedil: "Ç",
    Egrave: "È",
    Eacute: "É",
    Ecirc: "Ê",
    Euml: "Ë",
    Igrave: "Ì",
    Iacute: "Í",
    Icirc: "Î",
    Iuml: "Ï",
    ETH: "Ð",
    Ntilde: "Ñ",
    Ograve: "Ò",
    Oacute: "Ó",
    Ocirc: "Ô",
    Otilde: "Õ",
    Ouml: "Ö",
    times: "×",
    Oslash: "Ø",
    Ugrave: "Ù",
    Uacute: "Ú",
    Ucirc: "Û",
    Uuml: "Ü",
    Yacute: "Ý",
    THORN: "Þ",
    szlig: "ß",
    agrave: "à",
    aacute: "á",
    acirc: "â",
    atilde: "ã",
    auml: "ä",
    aring: "å",
    aelig: "æ",
    ccedil: "ç",
    egrave: "è",
    eacute: "é",
    ecirc: "ê",
    euml: "ë",
    igrave: "ì",
    iacute: "í",
    icirc: "î",
    iuml: "ï",
    eth: "ð",
    ntilde: "ñ",
    ograve: "ò",
    oacute: "ó",
    ocirc: "ô",
    otilde: "õ",
    ouml: "ö",
    divide: "÷",
    oslash: "ø",
    ugrave: "ù",
    uacute: "ú",
    ucirc: "û",
    uuml: "ü",
    yacute: "ý",
    thorn: "þ",
    yuml: "ÿ",
    OElig: "Œ",
    oelig: "œ",
    Scaron: "Š",
    scaron: "š",
    Yuml: "Ÿ",
    fnof: "ƒ",
    circ: "ˆ",
    tilde: "˜",
    Alpha: "Α",
    Beta: "Β",
    Gamma: "Γ",
    Delta: "Δ",
    Epsilon: "Ε",
    Zeta: "Ζ",
    Eta: "Η",
    Theta: "Θ",
    Iota: "Ι",
    Kappa: "Κ",
    Lambda: "Λ",
    Mu: "Μ",
    Nu: "Ν",
    Xi: "Ξ",
    Omicron: "Ο",
    Pi: "Π",
    Rho: "Ρ",
    Sigma: "Σ",
    Tau: "Τ",
    Upsilon: "Υ",
    Phi: "Φ",
    Chi: "Χ",
    Psi: "Ψ",
    Omega: "Ω",
    alpha: "α",
    beta: "β",
    gamma: "γ",
    delta: "δ",
    epsilon: "ε",
    zeta: "ζ",
    eta: "η",
    theta: "θ",
    iota: "ι",
    kappa: "κ",
    lambda: "λ",
    mu: "μ",
    nu: "ν",
    xi: "ξ",
    omicron: "ο",
    pi: "π",
    rho: "ρ",
    sigmaf: "ς",
    sigma: "σ",
    tau: "τ",
    upsilon: "υ",
    phi: "φ",
    chi: "χ",
    psi: "ψ",
    omega: "ω",
    thetasym: "ϑ",
    upsih: "ϒ",
    piv: "ϖ",
    ensp: " ",
    emsp: " ",
    thinsp: " ",
    zwnj: "‌",
    zwj: "‍",
    lrm: "‎",
    rlm: "‏",
    ndash: "–",
    mdash: "—",
    lsquo: "‘",
    rsquo: "’",
    sbquo: "‚",
    ldquo: "“",
    rdquo: "”",
    bdquo: "„",
    dagger: "†",
    Dagger: "‡",
    bull: "•",
    hellip: "…",
    permil: "‰",
    prime: "′",
    Prime: "″",
    lsaquo: "‹",
    rsaquo: "›",
    oline: "‾",
    frasl: "⁄",
    euro: "€",
    image: "ℑ",
    weierp: "℘",
    real: "ℜ",
    trade: "™",
    alefsym: "ℵ",
    larr: "←",
    uarr: "↑",
    rarr: "→",
    darr: "↓",
    harr: "↔",
    crarr: "↵",
    lArr: "⇐",
    uArr: "⇑",
    rArr: "⇒",
    dArr: "⇓",
    hArr: "⇔",
    forall: "∀",
    part: "∂",
    exist: "∃",
    empty: "∅",
    nabla: "∇",
    isin: "∈",
    notin: "∉",
    ni: "∋",
    prod: "∏",
    sum: "∑",
    minus: "−",
    lowast: "∗",
    radic: "√",
    prop: "∝",
    infin: "∞",
    ang: "∠",
    and: "∧",
    or: "∨",
    cap: "∩",
    cup: "∪",
    int: "∫",
    there4: "∴",
    sim: "∼",
    cong: "≅",
    asymp: "≈",
    ne: "≠",
    equiv: "≡",
    le: "≤",
    ge: "≥",
    sub: "⊂",
    sup: "⊃",
    nsub: "⊄",
    sube: "⊆",
    supe: "⊇",
    oplus: "⊕",
    otimes: "⊗",
    perp: "⊥",
    sdot: "⋅",
    lceil: "⌈",
    rceil: "⌉",
    lfloor: "⌊",
    rfloor: "⌋",
    lang: "〈",
    rang: "〉",
    loz: "◊",
    spades: "♠",
    clubs: "♣",
    hearts: "♥",
    diams: "♦",
  };
  const JsxErrors = ParseErrorEnum`jsx`({
    AttributeIsEmpty:
      "JSX attributes must only be assigned a non-empty expression.",
    MissingClosingTagElement: ({ openingTagName: openingTagName }) =>
      `Expected corresponding JSX closing tag for <${openingTagName}>.`,
    MissingClosingTagFragment: "Expected corresponding JSX closing tag for <>.",
    UnexpectedSequenceExpression:
      "Sequence expressions cannot be directly nested inside JSX. Did you mean to wrap it in parentheses (...)?",
    UnexpectedToken: ({ unexpected: unexpected, HTMLEntity: HTMLEntity }) =>
      `Unexpected token \`${unexpected}\`. Did you mean \`${HTMLEntity}\` or \`{'${unexpected}'}\`?`,
    UnsupportedJsxValue:
      "JSX value should be either an expression or a quoted JSX text.",
    UnterminatedJsxContent: "Unterminated JSX contents.",
    UnwrappedAdjacentJSXElements:
      "Adjacent JSX elements must be wrapped in an enclosing tag. Did you want a JSX fragment <>...</>?",
  });
  function isFragment(object) {
    return object
      ? object.type === "JSXOpeningFragment" ||
          object.type === "JSXClosingFragment"
      : false;
  }
  function getQualifiedJSXName(object) {
    if (object.type === "JSXIdentifier") {
      return object.name;
    }
    if (object.type === "JSXNamespacedName") {
      return object.namespace.name + ":" + object.name.name;
    }
    if (object.type === "JSXMemberExpression") {
      return (
        getQualifiedJSXName(object.object) +
        "." +
        getQualifiedJSXName(object.property)
      );
    }
    throw new Error("Node had unexpected type: " + object.type);
  }
  var jsx = (superClass) =>
    class JSXParserMixin extends superClass {
      jsxReadToken() {
        let out = "";
        let chunkStart = this.state.pos;
        for (;;) {
          if (this.state.pos >= this.length) {
            throw this.raise(
              JsxErrors.UnterminatedJsxContent,
              this.state.startLoc,
            );
          }
          const ch = this.input.charCodeAt(this.state.pos);
          switch (ch) {
            case 60:
            case 123:
              if (this.state.pos === this.state.start) {
                if (ch === 60 && this.state.canStartJSXElement) {
                  ++this.state.pos;
                  this.finishToken(142);
                } else {
                  super.getTokenFromCode(ch);
                }
                return;
              }
              out += this.input.slice(chunkStart, this.state.pos);
              this.finishToken(141, out);
              return;
            case 38:
              out += this.input.slice(chunkStart, this.state.pos);
              out += this.jsxReadEntity();
              chunkStart = this.state.pos;
              break;
            case 62:
            case 125:
            default:
              if (isNewLine(ch)) {
                out += this.input.slice(chunkStart, this.state.pos);
                out += this.jsxReadNewLine(true);
                chunkStart = this.state.pos;
              } else {
                ++this.state.pos;
              }
          }
        }
      }
      jsxReadNewLine(normalizeCRLF) {
        const ch = this.input.charCodeAt(this.state.pos);
        let out;
        ++this.state.pos;
        if (ch === 13 && this.input.charCodeAt(this.state.pos) === 10) {
          ++this.state.pos;
          out = normalizeCRLF ? "\n" : "\r\n";
        } else {
          out = String.fromCharCode(ch);
        }
        ++this.state.curLine;
        this.state.lineStart = this.state.pos;
        return out;
      }
      jsxReadString(quote) {
        let out = "";
        let chunkStart = ++this.state.pos;
        for (;;) {
          if (this.state.pos >= this.length) {
            throw this.raise(Errors.UnterminatedString, this.state.startLoc);
          }
          const ch = this.input.charCodeAt(this.state.pos);
          if (ch === quote) break;
          if (ch === 38) {
            out += this.input.slice(chunkStart, this.state.pos);
            out += this.jsxReadEntity();
            chunkStart = this.state.pos;
          } else if (isNewLine(ch)) {
            out += this.input.slice(chunkStart, this.state.pos);
            out += this.jsxReadNewLine(false);
            chunkStart = this.state.pos;
          } else {
            ++this.state.pos;
          }
        }
        out += this.input.slice(chunkStart, this.state.pos++);
        this.finishToken(133, out);
      }
      jsxReadEntity() {
        const startPos = ++this.state.pos;
        if (this.codePointAtPos(this.state.pos) === 35) {
          ++this.state.pos;
          let radix = 10;
          if (this.codePointAtPos(this.state.pos) === 120) {
            radix = 16;
            ++this.state.pos;
          }
          const codePoint = this.readInt(radix, undefined, false, "bail");
          if (
            codePoint !== null &&
            this.codePointAtPos(this.state.pos) === 59
          ) {
            ++this.state.pos;
            return String.fromCodePoint(codePoint);
          }
        } else {
          let count = 0;
          let semi = false;
          while (
            count++ < 10 &&
            this.state.pos < this.length &&
            !(semi = this.codePointAtPos(this.state.pos) == 59)
          ) {
            ++this.state.pos;
          }
          if (semi) {
            const desc = this.input.slice(startPos, this.state.pos);
            const entity = entities[desc];
            ++this.state.pos;
            if (entity) {
              return entity;
            }
          }
        }
        this.state.pos = startPos;
        return "&";
      }
      jsxReadWord() {
        let ch;
        const start = this.state.pos;
        do {
          ch = this.input.charCodeAt(++this.state.pos);
        } while (isIdentifierChar(ch) || ch === 45);
        this.finishToken(140, this.input.slice(start, this.state.pos));
      }
      jsxParseIdentifier() {
        const node = this.startNode();
        if (this.match(140)) {
          node.name = this.state.value;
        } else if (tokenIsKeyword(this.state.type)) {
          node.name = tokenLabelName(this.state.type);
        } else {
          this.unexpected();
        }
        this.next();
        return this.finishNode(node, "JSXIdentifier");
      }
      jsxParseNamespacedName() {
        const startLoc = this.state.startLoc;
        const name = this.jsxParseIdentifier();
        if (!this.eat(14)) return name;
        const node = this.startNodeAt(startLoc);
        node.namespace = name;
        node.name = this.jsxParseIdentifier();
        return this.finishNode(node, "JSXNamespacedName");
      }
      jsxParseElementName() {
        const startLoc = this.state.startLoc;
        let node = this.jsxParseNamespacedName();
        if (node.type === "JSXNamespacedName") {
          return node;
        }
        while (this.eat(16)) {
          const newNode = this.startNodeAt(startLoc);
          newNode.object = node;
          newNode.property = this.jsxParseIdentifier();
          node = this.finishNode(newNode, "JSXMemberExpression");
        }
        return node;
      }
      jsxParseAttributeValue() {
        let node;
        switch (this.state.type) {
          case 5:
            node = this.startNode();
            this.setContext(types.brace);
            this.next();
            node = this.jsxParseExpressionContainer(node, types.j_oTag);
            if (node.expression.type === "JSXEmptyExpression") {
              this.raise(JsxErrors.AttributeIsEmpty, node);
            }
            return node;
          case 142:
          case 133:
            return this.parseExprAtom();
          default:
            throw this.raise(
              JsxErrors.UnsupportedJsxValue,
              this.state.startLoc,
            );
        }
      }
      jsxParseEmptyExpression() {
        const node = this.startNodeAt(this.state.lastTokEndLoc);
        return this.finishNodeAt(
          node,
          "JSXEmptyExpression",
          this.state.startLoc,
        );
      }
      jsxParseSpreadChild(node) {
        this.next();
        node.expression = this.parseExpression();
        this.setContext(types.j_expr);
        this.state.canStartJSXElement = true;
        this.expect(8);
        return this.finishNode(node, "JSXSpreadChild");
      }
      jsxParseExpressionContainer(node, previousContext) {
        if (this.match(8)) {
          node.expression = this.jsxParseEmptyExpression();
        } else {
          const expression = this.parseExpression();
          node.expression = expression;
        }
        this.setContext(previousContext);
        this.state.canStartJSXElement = true;
        this.expect(8);
        return this.finishNode(node, "JSXExpressionContainer");
      }
      jsxParseAttribute() {
        const node = this.startNode();
        if (this.match(5)) {
          this.setContext(types.brace);
          this.next();
          this.expect(21);
          node.argument = this.parseMaybeAssignAllowIn();
          this.setContext(types.j_oTag);
          this.state.canStartJSXElement = true;
          this.expect(8);
          return this.finishNode(node, "JSXSpreadAttribute");
        }
        node.name = this.jsxParseNamespacedName();
        node.value = this.eat(29) ? this.jsxParseAttributeValue() : null;
        return this.finishNode(node, "JSXAttribute");
      }
      jsxParseOpeningElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        if (this.eat(143)) {
          return this.finishNode(node, "JSXOpeningFragment");
        }
        node.name = this.jsxParseElementName();
        return this.jsxParseOpeningElementAfterName(node);
      }
      jsxParseOpeningElementAfterName(node) {
        const attributes = [];
        while (!this.match(56) && !this.match(143)) {
          attributes.push(this.jsxParseAttribute());
        }
        node.attributes = attributes;
        node.selfClosing = this.eat(56);
        this.expect(143);
        return this.finishNode(node, "JSXOpeningElement");
      }
      jsxParseClosingElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        if (this.eat(143)) {
          return this.finishNode(node, "JSXClosingFragment");
        }
        node.name = this.jsxParseElementName();
        this.expect(143);
        return this.finishNode(node, "JSXClosingElement");
      }
      jsxParseElementAt(startLoc) {
        const node = this.startNodeAt(startLoc);
        const children = [];
        const openingElement = this.jsxParseOpeningElementAt(startLoc);
        let closingElement = null;
        if (!openingElement.selfClosing) {
          contents: for (;;) {
            switch (this.state.type) {
              case 142:
                startLoc = this.state.startLoc;
                this.next();
                if (this.eat(56)) {
                  closingElement = this.jsxParseClosingElementAt(startLoc);
                  break contents;
                }
                children.push(this.jsxParseElementAt(startLoc));
                break;
              case 141:
                children.push(this.parseExprAtom());
                break;
              case 5: {
                const node = this.startNode();
                this.setContext(types.brace);
                this.next();
                if (this.match(21)) {
                  children.push(this.jsxParseSpreadChild(node));
                } else {
                  children.push(
                    this.jsxParseExpressionContainer(node, types.j_expr),
                  );
                }
                break;
              }
              default:
                this.unexpected();
            }
          }
          if (
            isFragment(openingElement) &&
            !isFragment(closingElement) &&
            closingElement !== null
          ) {
            this.raise(JsxErrors.MissingClosingTagFragment, closingElement);
          } else if (
            !isFragment(openingElement) &&
            isFragment(closingElement)
          ) {
            this.raise(JsxErrors.MissingClosingTagElement, closingElement, {
              openingTagName: getQualifiedJSXName(openingElement.name),
            });
          } else if (
            !isFragment(openingElement) &&
            !isFragment(closingElement)
          ) {
            if (
              getQualifiedJSXName(closingElement.name) !==
              getQualifiedJSXName(openingElement.name)
            ) {
              this.raise(JsxErrors.MissingClosingTagElement, closingElement, {
                openingTagName: getQualifiedJSXName(openingElement.name),
              });
            }
          }
        }
        if (isFragment(openingElement)) {
          node.openingFragment = openingElement;
          node.closingFragment = closingElement;
        } else {
          node.openingElement = openingElement;
          node.closingElement = closingElement;
        }
        node.children = children;
        if (this.match(47)) {
          throw this.raise(
            JsxErrors.UnwrappedAdjacentJSXElements,
            this.state.startLoc,
          );
        }
        return isFragment(openingElement)
          ? this.finishNode(node, "JSXFragment")
          : this.finishNode(node, "JSXElement");
      }
      jsxParseElement() {
        const startLoc = this.state.startLoc;
        this.next();
        return this.jsxParseElementAt(startLoc);
      }
      setContext(newContext) {
        const { context: context } = this.state;
        context[context.length - 1] = newContext;
      }
      parseExprAtom(refExpressionErrors) {
        if (this.match(141)) {
          return this.parseLiteral(this.state.value, "JSXText");
        } else if (this.match(142)) {
          return this.jsxParseElement();
        } else if (
          this.match(47) &&
          this.input.charCodeAt(this.state.pos) !== 33
        ) {
          this.replaceToken(142);
          return this.jsxParseElement();
        } else {
          return super.parseExprAtom(refExpressionErrors);
        }
      }
      skipSpace() {
        const curContext = this.curContext();
        if (!curContext.preserveSpace) super.skipSpace();
      }
      getTokenFromCode(code) {
        const context = this.curContext();
        if (context === types.j_expr) {
          this.jsxReadToken();
          return;
        }
        if (context === types.j_oTag || context === types.j_cTag) {
          if (isIdentifierStart(code)) {
            this.jsxReadWord();
            return;
          }
          if (code === 62) {
            ++this.state.pos;
            this.finishToken(143);
            return;
          }
          if ((code === 34 || code === 39) && context === types.j_oTag) {
            this.jsxReadString(code);
            return;
          }
        }
        if (
          code === 60 &&
          this.state.canStartJSXElement &&
          this.input.charCodeAt(this.state.pos + 1) !== 33
        ) {
          ++this.state.pos;
          this.finishToken(142);
          return;
        }
        super.getTokenFromCode(code);
      }
      updateContext(prevType) {
        const { context: context, type: type } = this.state;
        if (type === 56 && prevType === 142) {
          context.splice(-2, 2, types.j_cTag);
          this.state.canStartJSXElement = false;
        } else if (type === 142) {
          context.push(types.j_oTag);
        } else if (type === 143) {
          const out = context[context.length - 1];
          if (
            (out === types.j_oTag && prevType === 56) ||
            out === types.j_cTag
          ) {
            context.pop();
            this.state.canStartJSXElement =
              context[context.length - 1] === types.j_expr;
          } else {
            this.setContext(types.j_expr);
            this.state.canStartJSXElement = true;
          }
        } else {
          this.state.canStartJSXElement = tokenComesBeforeExpression(type);
        }
      }
    };
  class TypeScriptScope extends Scope {
    constructor(...args) {
      super(...args);
      this.tsNames = new Map();
    }
  }
  class TypeScriptScopeHandler extends ScopeHandler {
    constructor(...args) {
      super(...args);
      this.importsStack = [];
    }
    createScope(flags) {
      this.importsStack.push(new Set());
      return new TypeScriptScope(flags);
    }
    enter(flags) {
      if (flags == 256) {
        this.importsStack.push(new Set());
      }
      super.enter(flags);
    }
    exit() {
      const flags = super.exit();
      if (flags == 256) {
        this.importsStack.pop();
      }
      return flags;
    }
    hasImport(name, allowShadow) {
      const len = this.importsStack.length;
      if (this.importsStack[len - 1].has(name)) {
        return true;
      }
      if (!allowShadow && len > 1) {
        for (let i = 0; i < len - 1; i++) {
          if (this.importsStack[i].has(name)) return true;
        }
      }
      return false;
    }
    declareName(name, bindingType, loc) {
      if (bindingType & 4096) {
        if (this.hasImport(name, true)) {
          this.parser.raise(Errors.VarRedeclaration, loc, {
            identifierName: name,
          });
        }
        this.importsStack[this.importsStack.length - 1].add(name);
        return;
      }
      const scope = this.currentScope();
      let type = scope.tsNames.get(name) || 0;
      if (bindingType & 1024) {
        this.maybeExportDefined(scope, name);
        scope.tsNames.set(name, type | 16);
        return;
      }
      super.declareName(name, bindingType, loc);
      if (bindingType & 2) {
        if (!(bindingType & 1)) {
          this.checkRedeclarationInScope(scope, name, bindingType, loc);
          this.maybeExportDefined(scope, name);
        }
        type = type | 1;
      }
      if (bindingType & 256) {
        type = type | 2;
      }
      if (bindingType & 512) {
        type = type | 4;
      }
      if (bindingType & 128) {
        type = type | 8;
      }
      if (type) scope.tsNames.set(name, type);
    }
    isRedeclaredInScope(scope, name, bindingType) {
      const type = scope.tsNames.get(name);
      if ((type & 2) > 0) {
        if (bindingType & 256) {
          const isConst = !!(bindingType & 512);
          const wasConst = (type & 4) > 0;
          return isConst !== wasConst;
        }
        return true;
      }
      if (bindingType & 128 && (type & 8) > 0) {
        if (scope.names.get(name) & 2) {
          return !!(bindingType & 1);
        } else {
          return false;
        }
      }
      if (bindingType & 2 && (type & 1) > 0) {
        return true;
      }
      return super.isRedeclaredInScope(scope, name, bindingType);
    }
    checkLocalExport(id) {
      const { name: name } = id;
      if (this.hasImport(name)) return;
      const len = this.scopeStack.length;
      for (let i = len - 1; i >= 0; i--) {
        const scope = this.scopeStack[i];
        const type = scope.tsNames.get(name);
        if ((type & 1) > 0 || (type & 16) > 0) {
          return;
        }
      }
      super.checkLocalExport(id);
    }
  }
  const getOwn$1 = (object, key) =>
    hasOwnProperty.call(object, key) && object[key];
  const unwrapParenthesizedExpression = (node) =>
    node.type === "ParenthesizedExpression"
      ? unwrapParenthesizedExpression(node.expression)
      : node;
  class LValParser extends NodeUtils {
    toAssignable(node, isLHS = false) {
      var _node$extra, _node$extra3;
      let parenthesized = undefined;
      if (
        node.type === "ParenthesizedExpression" ||
        ((_node$extra = node.extra) != null && _node$extra.parenthesized)
      ) {
        parenthesized = unwrapParenthesizedExpression(node);
        if (isLHS) {
          if (parenthesized.type === "Identifier") {
            this.expressionScope.recordArrowParameterBindingError(
              Errors.InvalidParenthesizedAssignment,
              node,
            );
          } else if (
            parenthesized.type !== "MemberExpression" &&
            !this.isOptionalMemberExpression(parenthesized)
          ) {
            this.raise(Errors.InvalidParenthesizedAssignment, node);
          }
        } else {
          this.raise(Errors.InvalidParenthesizedAssignment, node);
        }
      }
      switch (node.type) {
        case "Identifier":
        case "ObjectPattern":
        case "ArrayPattern":
        case "AssignmentPattern":
        case "RestElement":
          break;
        case "ObjectExpression":
          node.type = "ObjectPattern";
          for (
            let i = 0, length = node.properties.length, last = length - 1;
            i < length;
            i++
          ) {
            var _node$extra2;
            const prop = node.properties[i];
            const isLast = i === last;
            this.toAssignableObjectExpressionProp(prop, isLast, isLHS);
            if (
              isLast &&
              prop.type === "RestElement" &&
              (_node$extra2 = node.extra) != null &&
              _node$extra2.trailingCommaLoc
            ) {
              this.raise(Errors.RestTrailingComma, node.extra.trailingCommaLoc);
            }
          }
          break;
        case "ObjectProperty": {
          const { key: key, value: value } = node;
          if (this.isPrivateName(key)) {
            this.classScope.usePrivateName(
              this.getPrivateNameSV(key),
              key.loc.start,
            );
          }
          this.toAssignable(value, isLHS);
          break;
        }
        case "SpreadElement": {
          throw new Error(
            "Internal @babel/parser error (this is a bug, please report it)." +
              " SpreadElement should be converted by .toAssignable's caller.",
          );
        }
        case "ArrayExpression":
          node.type = "ArrayPattern";
          this.toAssignableList(
            node.elements,
            (_node$extra3 = node.extra) == null
              ? void 0
              : _node$extra3.trailingCommaLoc,
            isLHS,
          );
          break;
        case "AssignmentExpression":
          if (node.operator !== "=") {
            this.raise(Errors.MissingEqInAssignment, node.left.loc.end);
          }
          node.type = "AssignmentPattern";
          delete node.operator;
          this.toAssignable(node.left, isLHS);
          break;
        case "ParenthesizedExpression":
          this.toAssignable(parenthesized, isLHS);
          break;
      }
    }
    toAssignableObjectExpressionProp(prop, isLast, isLHS) {
      if (prop.type === "ObjectMethod") {
        this.raise(
          prop.kind === "get" || prop.kind === "set"
            ? Errors.PatternHasAccessor
            : Errors.PatternHasMethod,
          prop.key,
        );
      } else if (prop.type === "SpreadElement") {
        prop.type = "RestElement";
        const arg = prop.argument;
        this.checkToRestConversion(arg, false);
        this.toAssignable(arg, isLHS);
        if (!isLast) {
          this.raise(Errors.RestTrailingComma, prop);
        }
      } else {
        this.toAssignable(prop, isLHS);
      }
    }
    toAssignableList(exprList, trailingCommaLoc, isLHS) {
      const end = exprList.length - 1;
      for (let i = 0; i <= end; i++) {
        const elt = exprList[i];
        if (!elt) continue;
        if (elt.type === "SpreadElement") {
          elt.type = "RestElement";
          const arg = elt.argument;
          this.checkToRestConversion(arg, true);
          this.toAssignable(arg, isLHS);
        } else {
          this.toAssignable(elt, isLHS);
        }
        if (elt.type === "RestElement") {
          if (i < end) {
            this.raise(Errors.RestTrailingComma, elt);
          } else if (trailingCommaLoc) {
            this.raise(Errors.RestTrailingComma, trailingCommaLoc);
          }
        }
      }
    }
    isAssignable(node, isBinding) {
      switch (node.type) {
        case "Identifier":
        case "ObjectPattern":
        case "ArrayPattern":
        case "AssignmentPattern":
        case "RestElement":
          return true;
        case "ObjectExpression": {
          const last = node.properties.length - 1;
          return node.properties.every(
            (prop, i) =>
              prop.type !== "ObjectMethod" &&
              (i === last || prop.type !== "SpreadElement") &&
              this.isAssignable(prop),
          );
        }
        case "ObjectProperty":
          return this.isAssignable(node.value);
        case "SpreadElement":
          return this.isAssignable(node.argument);
        case "ArrayExpression":
          return node.elements.every(
            (element) => element === null || this.isAssignable(element),
          );
        case "AssignmentExpression":
          return node.operator === "=";
        case "ParenthesizedExpression":
          return this.isAssignable(node.expression);
        case "MemberExpression":
        case "OptionalMemberExpression":
          return !isBinding;
        default:
          return false;
      }
    }
    toReferencedList(exprList, isParenthesizedExpr) {
      return exprList;
    }
    toReferencedListDeep(exprList, isParenthesizedExpr) {
      this.toReferencedList(exprList, isParenthesizedExpr);
      for (const expr of exprList) {
        if ((expr == null ? void 0 : expr.type) === "ArrayExpression") {
          this.toReferencedListDeep(expr.elements);
        }
      }
    }
    parseSpread(refExpressionErrors) {
      const node = this.startNode();
      this.next();
      node.argument = this.parseMaybeAssignAllowIn(
        refExpressionErrors,
        undefined,
      );
      return this.finishNode(node, "SpreadElement");
    }
    parseRestBinding() {
      const node = this.startNode();
      this.next();
      node.argument = this.parseBindingAtom();
      return this.finishNode(node, "RestElement");
    }
    parseBindingAtom() {
      switch (this.state.type) {
        case 0: {
          const node = this.startNode();
          this.next();
          node.elements = this.parseBindingList(3, 93, 1);
          return this.finishNode(node, "ArrayPattern");
        }
        case 5:
          return this.parseObjectLike(8, true);
      }
      return this.parseIdentifier();
    }
    parseBindingList(close, closeCharCode, flags) {
      const allowEmpty = flags & 1;
      const elts = [];
      let first = true;
      while (!this.eat(close)) {
        if (first) {
          first = false;
        } else {
          this.expect(12);
        }
        if (allowEmpty && this.match(12)) {
          elts.push(null);
        } else if (this.eat(close)) {
          break;
        } else if (this.match(21)) {
          elts.push(
            this.parseAssignableListItemTypes(this.parseRestBinding(), flags),
          );
          if (!this.checkCommaAfterRest(closeCharCode)) {
            this.expect(close);
            break;
          }
        } else {
          const decorators = [];
          if (this.match(26) && this.hasPlugin("decorators")) {
            this.raise(
              Errors.UnsupportedParameterDecorator,
              this.state.startLoc,
            );
          }
          while (this.match(26)) {
            decorators.push(this.parseDecorator());
          }
          elts.push(this.parseAssignableListItem(flags, decorators));
        }
      }
      return elts;
    }
    parseBindingRestProperty(prop) {
      this.next();
      prop.argument = this.parseIdentifier();
      this.checkCommaAfterRest(125);
      return this.finishNode(prop, "RestElement");
    }
    parseBindingProperty() {
      const prop = this.startNode();
      const { type: type, startLoc: startLoc } = this.state;
      if (type === 21) {
        return this.parseBindingRestProperty(prop);
      } else if (type === 138) {
        this.expectPlugin("destructuringPrivate", startLoc);
        this.classScope.usePrivateName(this.state.value, startLoc);
        prop.key = this.parsePrivateName();
      } else {
        this.parsePropertyName(prop);
      }
      prop.method = false;
      return this.parseObjPropValue(prop, startLoc, false, false, true, false);
    }
    parseAssignableListItem(flags, decorators) {
      const left = this.parseMaybeDefault();
      this.parseAssignableListItemTypes(left, flags);
      const elt = this.parseMaybeDefault(left.loc.start, left);
      if (decorators.length) {
        left.decorators = decorators;
      }
      return elt;
    }
    parseAssignableListItemTypes(param, flags) {
      return param;
    }
    parseMaybeDefault(startLoc, left) {
      var _startLoc, _left;
      (_startLoc = startLoc) != null
        ? _startLoc
        : (startLoc = this.state.startLoc);
      left = (_left = left) != null ? _left : this.parseBindingAtom();
      if (!this.eat(29)) return left;
      const node = this.startNodeAt(startLoc);
      node.left = left;
      node.right = this.parseMaybeAssignAllowIn();
      return this.finishNode(node, "AssignmentPattern");
    }
    isValidLVal(type, isUnparenthesizedInAssign, binding) {
      return getOwn$1(
        {
          AssignmentPattern: "left",
          RestElement: "argument",
          ObjectProperty: "value",
          ParenthesizedExpression: "expression",
          ArrayPattern: "elements",
          ObjectPattern: "properties",
        },
        type,
      );
    }
    isOptionalMemberExpression(expression) {
      return expression.type === "OptionalMemberExpression";
    }
    checkLVal(
      expression,
      {
        in: ancestor,
        binding: binding = 64,
        checkClashes: checkClashes = false,
        strictModeChanged: strictModeChanged = false,
        hasParenthesizedAncestor: hasParenthesizedAncestor = false,
      },
    ) {
      var _expression$extra;
      const type = expression.type;
      if (this.isObjectMethod(expression)) return;
      const isOptionalMemberExpression =
        this.isOptionalMemberExpression(expression);
      if (isOptionalMemberExpression || type === "MemberExpression") {
        if (isOptionalMemberExpression) {
          this.expectPlugin("optionalChainingAssign", expression.loc.start);
          if (ancestor.type !== "AssignmentExpression") {
            this.raise(Errors.InvalidLhsOptionalChaining, expression, {
              ancestor: ancestor,
            });
          }
        }
        if (binding !== 64) {
          this.raise(Errors.InvalidPropertyBindingPattern, expression);
        }
        return;
      }
      if (type === "Identifier") {
        this.checkIdentifier(expression, binding, strictModeChanged);
        const { name: name } = expression;
        if (checkClashes) {
          if (checkClashes.has(name)) {
            this.raise(Errors.ParamDupe, expression);
          } else {
            checkClashes.add(name);
          }
        }
        return;
      }
      const validity = this.isValidLVal(
        type,
        !(
          hasParenthesizedAncestor ||
          ((_expression$extra = expression.extra) != null &&
            _expression$extra.parenthesized)
        ) && ancestor.type === "AssignmentExpression",
        binding,
      );
      if (validity === true) return;
      if (validity === false) {
        const ParseErrorClass =
          binding === 64 ? Errors.InvalidLhs : Errors.InvalidLhsBinding;
        this.raise(ParseErrorClass, expression, { ancestor: ancestor });
        return;
      }
      const [key, isParenthesizedExpression] = Array.isArray(validity)
        ? validity
        : [validity, type === "ParenthesizedExpression"];
      const nextAncestor =
        type === "ArrayPattern" || type === "ObjectPattern"
          ? { type: type }
          : ancestor;
      for (const child of [].concat(expression[key])) {
        if (child) {
          this.checkLVal(child, {
            in: nextAncestor,
            binding: binding,
            checkClashes: checkClashes,
            strictModeChanged: strictModeChanged,
            hasParenthesizedAncestor: isParenthesizedExpression,
          });
        }
      }
    }
    checkIdentifier(at, bindingType, strictModeChanged = false) {
      if (
        this.state.strict &&
        (strictModeChanged
          ? isStrictBindReservedWord(at.name, this.inModule)
          : isStrictBindOnlyReservedWord(at.name))
      ) {
        if (bindingType === 64) {
          this.raise(Errors.StrictEvalArguments, at, {
            referenceName: at.name,
          });
        } else {
          this.raise(Errors.StrictEvalArgumentsBinding, at, {
            bindingName: at.name,
          });
        }
      }
      if (bindingType & 8192 && at.name === "let") {
        this.raise(Errors.LetInLexicalBinding, at);
      }
      if (!(bindingType & 64)) {
        this.declareNameFromIdentifier(at, bindingType);
      }
    }
    declareNameFromIdentifier(identifier, binding) {
      this.scope.declareName(identifier.name, binding, identifier.loc.start);
    }
    checkToRestConversion(node, allowPattern) {
      switch (node.type) {
        case "ParenthesizedExpression":
          this.checkToRestConversion(node.expression, allowPattern);
          break;
        case "Identifier":
        case "MemberExpression":
          break;
        case "ArrayExpression":
        case "ObjectExpression":
          if (allowPattern) break;
        default:
          this.raise(Errors.InvalidRestAssignmentPattern, node);
      }
    }
    checkCommaAfterRest(close) {
      if (!this.match(12)) {
        return false;
      }
      this.raise(
        this.lookaheadCharCode() === close
          ? Errors.RestTrailingComma
          : Errors.ElementAfterRest,
        this.state.startLoc,
      );
      return true;
    }
  }
  const getOwn = (object, key) =>
    hasOwnProperty.call(object, key) && object[key];
  function nonNull(x) {
    if (x == null) {
      throw new Error(`Unexpected ${x} value.`);
    }
    return x;
  }
  function assert(x) {
    if (!x) {
      throw new Error("Assert fail");
    }
  }
  const TSErrors = ParseErrorEnum`typescript`({
    AbstractMethodHasImplementation: ({ methodName: methodName }) =>
      `Method '${methodName}' cannot have an implementation because it is marked abstract.`,
    AbstractPropertyHasInitializer: ({ propertyName: propertyName }) =>
      `Property '${propertyName}' cannot have an initializer because it is marked abstract.`,
    AccesorCannotDeclareThisParameter:
      "'get' and 'set' accessors cannot declare 'this' parameters.",
    AccesorCannotHaveTypeParameters: "An accessor cannot have type parameters.",
    AccessorCannotBeOptional:
      "An 'accessor' property cannot be declared optional.",
    ClassMethodHasDeclare: "Class methods cannot have the 'declare' modifier.",
    ClassMethodHasReadonly:
      "Class methods cannot have the 'readonly' modifier.",
    ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference:
      "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference.",
    ConstructorHasTypeParameters:
      "Type parameters cannot appear on a constructor declaration.",
    DeclareAccessor: ({ kind: kind }) =>
      `'declare' is not allowed in ${kind}ters.`,
    DeclareClassFieldHasInitializer:
      "Initializers are not allowed in ambient contexts.",
    DeclareFunctionHasImplementation:
      "An implementation cannot be declared in ambient contexts.",
    DuplicateAccessibilityModifier: ({ modifier: modifier }) =>
      `Accessibility modifier already seen.`,
    DuplicateModifier: ({ modifier: modifier }) =>
      `Duplicate modifier: '${modifier}'.`,
    EmptyHeritageClauseType: ({ token: token }) =>
      `'${token}' list cannot be empty.`,
    EmptyTypeArguments: "Type argument list cannot be empty.",
    EmptyTypeParameters: "Type parameter list cannot be empty.",
    ExpectedAmbientAfterExportDeclare:
      "'export declare' must be followed by an ambient declaration.",
    ImportAliasHasImportType: "An import alias can not use 'import type'.",
    ImportReflectionHasImportType:
      "An `import module` declaration can not use `type` modifier",
    IncompatibleModifiers: ({ modifiers: modifiers }) =>
      `'${modifiers[0]}' modifier cannot be used with '${modifiers[1]}' modifier.`,
    IndexSignatureHasAbstract:
      "Index signatures cannot have the 'abstract' modifier.",
    IndexSignatureHasAccessibility: ({ modifier: modifier }) =>
      `Index signatures cannot have an accessibility modifier ('${modifier}').`,
    IndexSignatureHasDeclare:
      "Index signatures cannot have the 'declare' modifier.",
    IndexSignatureHasOverride:
      "'override' modifier cannot appear on an index signature.",
    IndexSignatureHasStatic:
      "Index signatures cannot have the 'static' modifier.",
    InitializerNotAllowedInAmbientContext:
      "Initializers are not allowed in ambient contexts.",
    InvalidModifierOnTypeMember: ({ modifier: modifier }) =>
      `'${modifier}' modifier cannot appear on a type member.`,
    InvalidModifierOnTypeParameter: ({ modifier: modifier }) =>
      `'${modifier}' modifier cannot appear on a type parameter.`,
    InvalidModifierOnTypeParameterPositions: ({ modifier: modifier }) =>
      `'${modifier}' modifier can only appear on a type parameter of a class, interface or type alias.`,
    InvalidModifiersOrder: ({ orderedModifiers: orderedModifiers }) =>
      `'${orderedModifiers[0]}' modifier must precede '${orderedModifiers[1]}' modifier.`,
    InvalidPropertyAccessAfterInstantiationExpression:
      "Invalid property access after an instantiation expression. " +
      "You can either wrap the instantiation expression in parentheses, or delete the type arguments.",
    InvalidTupleMemberLabel:
      "Tuple members must be labeled with a simple identifier.",
    MissingInterfaceName:
      "'interface' declarations must be followed by an identifier.",
    NonAbstractClassHasAbstractMethod:
      "Abstract methods can only appear within an abstract class.",
    NonClassMethodPropertyHasAbstractModifer:
      "'abstract' modifier can only appear on a class, method, or property declaration.",
    OptionalTypeBeforeRequired:
      "A required element cannot follow an optional element.",
    OverrideNotInSubClass:
      "This member cannot have an 'override' modifier because its containing class does not extend another class.",
    PatternIsOptional:
      "A binding pattern parameter cannot be optional in an implementation signature.",
    PrivateElementHasAbstract:
      "Private elements cannot have the 'abstract' modifier.",
    PrivateElementHasAccessibility: ({ modifier: modifier }) =>
      `Private elements cannot have an accessibility modifier ('${modifier}').`,
    ReadonlyForMethodSignature:
      "'readonly' modifier can only appear on a property declaration or index signature.",
    ReservedArrowTypeParam:
      "This syntax is reserved in files with the .mts or .cts extension. Add a trailing comma, as in `<T,>() => ...`.",
    ReservedTypeAssertion:
      "This syntax is reserved in files with the .mts or .cts extension. Use an `as` expression instead.",
    SetAccesorCannotHaveOptionalParameter:
      "A 'set' accessor cannot have an optional parameter.",
    SetAccesorCannotHaveRestParameter:
      "A 'set' accessor cannot have rest parameter.",
    SetAccesorCannotHaveReturnType:
      "A 'set' accessor cannot have a return type annotation.",
    SingleTypeParameterWithoutTrailingComma: ({
      typeParameterName: typeParameterName,
    }) =>
      `Single type parameter ${typeParameterName} should have a trailing comma. Example usage: <${typeParameterName},>.`,
    StaticBlockCannotHaveModifier:
      "Static class blocks cannot have any modifier.",
    TupleOptionalAfterType:
      "A labeled tuple optional element must be declared using a question mark after the name and before the colon (`name?: type`), rather than after the type (`name: type?`).",
    TypeAnnotationAfterAssign:
      "Type annotations must come before default assignments, e.g. instead of `age = 25: number` use `age: number = 25`.",
    TypeImportCannotSpecifyDefaultAndNamed:
      "A type-only import can specify a default import or named bindings, but not both.",
    TypeModifierIsUsedInTypeExports:
      "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement.",
    TypeModifierIsUsedInTypeImports:
      "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement.",
    UnexpectedParameterModifier:
      "A parameter property is only allowed in a constructor implementation.",
    UnexpectedReadonly:
      "'readonly' type modifier is only permitted on array and tuple literal types.",
    UnexpectedTypeAnnotation: "Did not expect a type annotation here.",
    UnexpectedTypeCastInParameter:
      "Unexpected type cast in parameter position.",
    UnsupportedImportTypeArgument:
      "Argument in a type import must be a string literal.",
    UnsupportedParameterPropertyKind:
      "A parameter property may not be declared using a binding pattern.",
    UnsupportedSignatureParameterKind: ({ type: type }) =>
      `Name in a signature must be an Identifier, ObjectPattern or ArrayPattern, instead got ${type}.`,
  });
  function keywordTypeFromName(value) {
    switch (value) {
      case "any":
        return "TSAnyKeyword";
      case "boolean":
        return "TSBooleanKeyword";
      case "bigint":
        return "TSBigIntKeyword";
      case "never":
        return "TSNeverKeyword";
      case "number":
        return "TSNumberKeyword";
      case "object":
        return "TSObjectKeyword";
      case "string":
        return "TSStringKeyword";
      case "symbol":
        return "TSSymbolKeyword";
      case "undefined":
        return "TSUndefinedKeyword";
      case "unknown":
        return "TSUnknownKeyword";
      default:
        return undefined;
    }
  }
  function tsIsAccessModifier(modifier) {
    return (
      modifier === "private" ||
      modifier === "public" ||
      modifier === "protected"
    );
  }
  function tsIsVarianceAnnotations(modifier) {
    return modifier === "in" || modifier === "out";
  }
  var typescript = (superClass) =>
    class TypeScriptParserMixin extends superClass {
      constructor(...args) {
        super(...args);
        this.tsParseInOutModifiers = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["in", "out"],
          disallowedModifiers: [
            "const",
            "public",
            "private",
            "protected",
            "readonly",
            "declare",
            "abstract",
            "override",
          ],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameter,
        });
        this.tsParseConstModifier = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["const"],
          disallowedModifiers: ["in", "out"],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions,
        });
        this.tsParseInOutConstModifiers = this.tsParseModifiers.bind(this, {
          allowedModifiers: ["in", "out", "const"],
          disallowedModifiers: [
            "public",
            "private",
            "protected",
            "readonly",
            "declare",
            "abstract",
            "override",
          ],
          errorTemplate: TSErrors.InvalidModifierOnTypeParameter,
        });
      }
      getScopeHandler() {
        return TypeScriptScopeHandler;
      }
      tsIsIdentifier() {
        return tokenIsIdentifier(this.state.type);
      }
      tsTokenCanFollowModifier() {
        return (
          (this.match(0) ||
            this.match(5) ||
            this.match(55) ||
            this.match(21) ||
            this.match(138) ||
            this.isLiteralPropertyName()) &&
          !this.hasPrecedingLineBreak()
        );
      }
      tsNextTokenCanFollowModifier() {
        this.next();
        return this.tsTokenCanFollowModifier();
      }
      tsParseModifier(allowedModifiers, stopOnStartOfClassStaticBlock) {
        if (
          !tokenIsIdentifier(this.state.type) &&
          this.state.type !== 58 &&
          this.state.type !== 75
        ) {
          return undefined;
        }
        const modifier = this.state.value;
        if (allowedModifiers.indexOf(modifier) !== -1) {
          if (stopOnStartOfClassStaticBlock && this.tsIsStartOfStaticBlocks()) {
            return undefined;
          }
          if (this.tsTryParse(this.tsNextTokenCanFollowModifier.bind(this))) {
            return modifier;
          }
        }
        return undefined;
      }
      tsParseModifiers(
        {
          allowedModifiers: allowedModifiers,
          disallowedModifiers: disallowedModifiers,
          stopOnStartOfClassStaticBlock: stopOnStartOfClassStaticBlock,
          errorTemplate: errorTemplate = TSErrors.InvalidModifierOnTypeMember,
        },
        modified,
      ) {
        const enforceOrder = (loc, modifier, before, after) => {
          if (modifier === before && modified[after]) {
            this.raise(TSErrors.InvalidModifiersOrder, loc, {
              orderedModifiers: [before, after],
            });
          }
        };
        const incompatible = (loc, modifier, mod1, mod2) => {
          if (
            (modified[mod1] && modifier === mod2) ||
            (modified[mod2] && modifier === mod1)
          ) {
            this.raise(TSErrors.IncompatibleModifiers, loc, {
              modifiers: [mod1, mod2],
            });
          }
        };
        for (;;) {
          const { startLoc: startLoc } = this.state;
          const modifier = this.tsParseModifier(
            allowedModifiers.concat(
              disallowedModifiers != null ? disallowedModifiers : [],
            ),
            stopOnStartOfClassStaticBlock,
          );
          if (!modifier) break;
          if (tsIsAccessModifier(modifier)) {
            if (modified.accessibility) {
              this.raise(TSErrors.DuplicateAccessibilityModifier, startLoc, {
                modifier: modifier,
              });
            } else {
              enforceOrder(startLoc, modifier, modifier, "override");
              enforceOrder(startLoc, modifier, modifier, "static");
              enforceOrder(startLoc, modifier, modifier, "readonly");
              modified.accessibility = modifier;
            }
          } else if (tsIsVarianceAnnotations(modifier)) {
            if (modified[modifier]) {
              this.raise(TSErrors.DuplicateModifier, startLoc, {
                modifier: modifier,
              });
            }
            modified[modifier] = true;
            enforceOrder(startLoc, modifier, "in", "out");
          } else {
            if (hasOwnProperty.call(modified, modifier)) {
              this.raise(TSErrors.DuplicateModifier, startLoc, {
                modifier: modifier,
              });
            } else {
              enforceOrder(startLoc, modifier, "static", "readonly");
              enforceOrder(startLoc, modifier, "static", "override");
              enforceOrder(startLoc, modifier, "override", "readonly");
              enforceOrder(startLoc, modifier, "abstract", "override");
              incompatible(startLoc, modifier, "declare", "override");
              incompatible(startLoc, modifier, "static", "abstract");
            }
            modified[modifier] = true;
          }
          if (
            disallowedModifiers != null &&
            disallowedModifiers.includes(modifier)
          ) {
            this.raise(errorTemplate, startLoc, { modifier: modifier });
          }
        }
      }
      tsIsListTerminator(kind) {
        switch (kind) {
          case "EnumMembers":
          case "TypeMembers":
            return this.match(8);
          case "HeritageClauseElement":
            return this.match(5);
          case "TupleElementTypes":
            return this.match(3);
          case "TypeParametersOrArguments":
            return this.match(48);
        }
      }
      tsParseList(kind, parseElement) {
        const result = [];
        while (!this.tsIsListTerminator(kind)) {
          result.push(parseElement());
        }
        return result;
      }
      tsParseDelimitedList(kind, parseElement, refTrailingCommaPos) {
        return nonNull(
          this.tsParseDelimitedListWorker(
            kind,
            parseElement,
            true,
            refTrailingCommaPos,
          ),
        );
      }
      tsParseDelimitedListWorker(
        kind,
        parseElement,
        expectSuccess,
        refTrailingCommaPos,
      ) {
        const result = [];
        let trailingCommaPos = -1;
        for (;;) {
          if (this.tsIsListTerminator(kind)) {
            break;
          }
          trailingCommaPos = -1;
          const element = parseElement();
          if (element == null) {
            return undefined;
          }
          result.push(element);
          if (this.eat(12)) {
            trailingCommaPos = this.state.lastTokStartLoc.index;
            continue;
          }
          if (this.tsIsListTerminator(kind)) {
            break;
          }
          if (expectSuccess) {
            this.expect(12);
          }
          return undefined;
        }
        if (refTrailingCommaPos) {
          refTrailingCommaPos.value = trailingCommaPos;
        }
        return result;
      }
      tsParseBracketedList(
        kind,
        parseElement,
        bracket,
        skipFirstToken,
        refTrailingCommaPos,
      ) {
        if (!skipFirstToken) {
          if (bracket) {
            this.expect(0);
          } else {
            this.expect(47);
          }
        }
        const result = this.tsParseDelimitedList(
          kind,
          parseElement,
          refTrailingCommaPos,
        );
        if (bracket) {
          this.expect(3);
        } else {
          this.expect(48);
        }
        return result;
      }
      tsParseImportType() {
        const node = this.startNode();
        this.expect(83);
        this.expect(10);
        if (!this.match(133)) {
          this.raise(
            TSErrors.UnsupportedImportTypeArgument,
            this.state.startLoc,
          );
        }
        node.argument = super.parseExprAtom();
        if (
          this.hasPlugin("importAttributes") ||
          this.hasPlugin("importAssertions")
        ) {
          node.options = null;
        }
        if (this.eat(12)) {
          this.expectImportAttributesPlugin();
          if (!this.match(11)) {
            node.options = super.parseMaybeAssignAllowIn();
            this.eat(12);
          }
        }
        this.expect(11);
        if (this.eat(16)) {
          node.qualifier = this.tsParseEntityName();
        }
        if (this.match(47)) {
          node.typeParameters = this.tsParseTypeArguments();
        }
        return this.finishNode(node, "TSImportType");
      }
      tsParseEntityName(allowReservedWords = true) {
        let entity = this.parseIdentifier(allowReservedWords);
        while (this.eat(16)) {
          const node = this.startNodeAtNode(entity);
          node.left = entity;
          node.right = this.parseIdentifier(allowReservedWords);
          entity = this.finishNode(node, "TSQualifiedName");
        }
        return entity;
      }
      tsParseTypeReference() {
        const node = this.startNode();
        node.typeName = this.tsParseEntityName();
        if (!this.hasPrecedingLineBreak() && this.match(47)) {
          node.typeParameters = this.tsParseTypeArguments();
        }
        return this.finishNode(node, "TSTypeReference");
      }
      tsParseThisTypePredicate(lhs) {
        this.next();
        const node = this.startNodeAtNode(lhs);
        node.parameterName = lhs;
        node.typeAnnotation = this.tsParseTypeAnnotation(false);
        node.asserts = false;
        return this.finishNode(node, "TSTypePredicate");
      }
      tsParseThisTypeNode() {
        const node = this.startNode();
        this.next();
        return this.finishNode(node, "TSThisType");
      }
      tsParseTypeQuery() {
        const node = this.startNode();
        this.expect(87);
        if (this.match(83)) {
          node.exprName = this.tsParseImportType();
        } else {
          node.exprName = this.tsParseEntityName();
        }
        if (!this.hasPrecedingLineBreak() && this.match(47)) {
          node.typeParameters = this.tsParseTypeArguments();
        }
        return this.finishNode(node, "TSTypeQuery");
      }
      tsParseTypeParameter(parseModifiers) {
        const node = this.startNode();
        parseModifiers(node);
        node.name = this.tsParseTypeParameterName();
        node.constraint = this.tsEatThenParseType(81);
        node.default = this.tsEatThenParseType(29);
        return this.finishNode(node, "TSTypeParameter");
      }
      tsTryParseTypeParameters(parseModifiers) {
        if (this.match(47)) {
          return this.tsParseTypeParameters(parseModifiers);
        }
      }
      tsParseTypeParameters(parseModifiers) {
        const node = this.startNode();
        if (this.match(47) || this.match(142)) {
          this.next();
        } else {
          this.unexpected();
        }
        const refTrailingCommaPos = { value: -1 };
        node.params = this.tsParseBracketedList(
          "TypeParametersOrArguments",
          this.tsParseTypeParameter.bind(this, parseModifiers),
          false,
          true,
          refTrailingCommaPos,
        );
        if (node.params.length === 0) {
          this.raise(TSErrors.EmptyTypeParameters, node);
        }
        if (refTrailingCommaPos.value !== -1) {
          this.addExtra(node, "trailingComma", refTrailingCommaPos.value);
        }
        return this.finishNode(node, "TSTypeParameterDeclaration");
      }
      tsFillSignature(returnToken, signature) {
        const returnTokenRequired = returnToken === 19;
        const paramsKey = "parameters";
        const returnTypeKey = "typeAnnotation";
        signature.typeParameters = this.tsTryParseTypeParameters(
          this.tsParseConstModifier,
        );
        this.expect(10);
        signature[paramsKey] = this.tsParseBindingListForSignature();
        if (returnTokenRequired) {
          signature[returnTypeKey] =
            this.tsParseTypeOrTypePredicateAnnotation(returnToken);
        } else if (this.match(returnToken)) {
          signature[returnTypeKey] =
            this.tsParseTypeOrTypePredicateAnnotation(returnToken);
        }
      }
      tsParseBindingListForSignature() {
        const list = super.parseBindingList(11, 41, 2);
        for (const pattern of list) {
          const { type: type } = pattern;
          if (type === "AssignmentPattern" || type === "TSParameterProperty") {
            this.raise(TSErrors.UnsupportedSignatureParameterKind, pattern, {
              type: type,
            });
          }
        }
        return list;
      }
      tsParseTypeMemberSemicolon() {
        if (!this.eat(12) && !this.isLineTerminator()) {
          this.expect(13);
        }
      }
      tsParseSignatureMember(kind, node) {
        this.tsFillSignature(14, node);
        this.tsParseTypeMemberSemicolon();
        return this.finishNode(node, kind);
      }
      tsIsUnambiguouslyIndexSignature() {
        this.next();
        if (tokenIsIdentifier(this.state.type)) {
          this.next();
          return this.match(14);
        }
        return false;
      }
      tsTryParseIndexSignature(node) {
        if (
          !(
            this.match(0) &&
            this.tsLookAhead(this.tsIsUnambiguouslyIndexSignature.bind(this))
          )
        ) {
          return;
        }
        this.expect(0);
        const id = this.parseIdentifier();
        id.typeAnnotation = this.tsParseTypeAnnotation();
        this.resetEndLocation(id);
        this.expect(3);
        node.parameters = [id];
        const type = this.tsTryParseTypeAnnotation();
        if (type) node.typeAnnotation = type;
        this.tsParseTypeMemberSemicolon();
        return this.finishNode(node, "TSIndexSignature");
      }
      tsParsePropertyOrMethodSignature(node, readonly) {
        if (this.eat(17)) node.optional = true;
        const nodeAny = node;
        if (this.match(10) || this.match(47)) {
          if (readonly) {
            this.raise(TSErrors.ReadonlyForMethodSignature, node);
          }
          const method = nodeAny;
          if (method.kind && this.match(47)) {
            this.raise(
              TSErrors.AccesorCannotHaveTypeParameters,
              this.state.curPosition(),
            );
          }
          this.tsFillSignature(14, method);
          this.tsParseTypeMemberSemicolon();
          const paramsKey = "parameters";
          const returnTypeKey = "typeAnnotation";
          if (method.kind === "get") {
            if (method[paramsKey].length > 0) {
              this.raise(Errors.BadGetterArity, this.state.curPosition());
              if (this.isThisParam(method[paramsKey][0])) {
                this.raise(
                  TSErrors.AccesorCannotDeclareThisParameter,
                  this.state.curPosition(),
                );
              }
            }
          } else if (method.kind === "set") {
            if (method[paramsKey].length !== 1) {
              this.raise(Errors.BadSetterArity, this.state.curPosition());
            } else {
              const firstParameter = method[paramsKey][0];
              if (this.isThisParam(firstParameter)) {
                this.raise(
                  TSErrors.AccesorCannotDeclareThisParameter,
                  this.state.curPosition(),
                );
              }
              if (
                firstParameter.type === "Identifier" &&
                firstParameter.optional
              ) {
                this.raise(
                  TSErrors.SetAccesorCannotHaveOptionalParameter,
                  this.state.curPosition(),
                );
              }
              if (firstParameter.type === "RestElement") {
                this.raise(
                  TSErrors.SetAccesorCannotHaveRestParameter,
                  this.state.curPosition(),
                );
              }
            }
            if (method[returnTypeKey]) {
              this.raise(
                TSErrors.SetAccesorCannotHaveReturnType,
                method[returnTypeKey],
              );
            }
          } else {
            method.kind = "method";
          }
          return this.finishNode(method, "TSMethodSignature");
        } else {
          const property = nodeAny;
          if (readonly) property.readonly = true;
          const type = this.tsTryParseTypeAnnotation();
          if (type) property.typeAnnotation = type;
          this.tsParseTypeMemberSemicolon();
          return this.finishNode(property, "TSPropertySignature");
        }
      }
      tsParseTypeMember() {
        const node = this.startNode();
        if (this.match(10) || this.match(47)) {
          return this.tsParseSignatureMember(
            "TSCallSignatureDeclaration",
            node,
          );
        }
        if (this.match(77)) {
          const id = this.startNode();
          this.next();
          if (this.match(10) || this.match(47)) {
            return this.tsParseSignatureMember(
              "TSConstructSignatureDeclaration",
              node,
            );
          } else {
            node.key = this.createIdentifier(id, "new");
            return this.tsParsePropertyOrMethodSignature(node, false);
          }
        }
        this.tsParseModifiers(
          {
            allowedModifiers: ["readonly"],
            disallowedModifiers: [
              "declare",
              "abstract",
              "private",
              "protected",
              "public",
              "static",
              "override",
            ],
          },
          node,
        );
        const idx = this.tsTryParseIndexSignature(node);
        if (idx) {
          return idx;
        }
        super.parsePropertyName(node);
        if (
          !node.computed &&
          node.key.type === "Identifier" &&
          (node.key.name === "get" || node.key.name === "set") &&
          this.tsTokenCanFollowModifier()
        ) {
          node.kind = node.key.name;
          super.parsePropertyName(node);
        }
        return this.tsParsePropertyOrMethodSignature(node, !!node.readonly);
      }
      tsParseTypeLiteral() {
        const node = this.startNode();
        node.members = this.tsParseObjectTypeMembers();
        return this.finishNode(node, "TSTypeLiteral");
      }
      tsParseObjectTypeMembers() {
        this.expect(5);
        const members = this.tsParseList(
          "TypeMembers",
          this.tsParseTypeMember.bind(this),
        );
        this.expect(8);
        return members;
      }
      tsIsStartOfMappedType() {
        this.next();
        if (this.eat(53)) {
          return this.isContextual(122);
        }
        if (this.isContextual(122)) {
          this.next();
        }
        if (!this.match(0)) {
          return false;
        }
        this.next();
        if (!this.tsIsIdentifier()) {
          return false;
        }
        this.next();
        return this.match(58);
      }
      tsParseMappedTypeParameter() {
        const node = this.startNode();
        node.name = this.tsParseTypeParameterName();
        node.constraint = this.tsExpectThenParseType(58);
        return this.finishNode(node, "TSTypeParameter");
      }
      tsParseMappedType() {
        const node = this.startNode();
        this.expect(5);
        if (this.match(53)) {
          node.readonly = this.state.value;
          this.next();
          this.expectContextual(122);
        } else if (this.eatContextual(122)) {
          node.readonly = true;
        }
        this.expect(0);
        node.typeParameter = this.tsParseMappedTypeParameter();
        node.nameType = this.eatContextual(93) ? this.tsParseType() : null;
        this.expect(3);
        if (this.match(53)) {
          node.optional = this.state.value;
          this.next();
          this.expect(17);
        } else if (this.eat(17)) {
          node.optional = true;
        }
        node.typeAnnotation = this.tsTryParseType();
        this.semicolon();
        this.expect(8);
        return this.finishNode(node, "TSMappedType");
      }
      tsParseTupleType() {
        const node = this.startNode();
        node.elementTypes = this.tsParseBracketedList(
          "TupleElementTypes",
          this.tsParseTupleElementType.bind(this),
          true,
          false,
        );
        let seenOptionalElement = false;
        node.elementTypes.forEach((elementNode) => {
          const { type: type } = elementNode;
          if (
            seenOptionalElement &&
            type !== "TSRestType" &&
            type !== "TSOptionalType" &&
            !(type === "TSNamedTupleMember" && elementNode.optional)
          ) {
            this.raise(TSErrors.OptionalTypeBeforeRequired, elementNode);
          }
          seenOptionalElement ||
            (seenOptionalElement =
              (type === "TSNamedTupleMember" && elementNode.optional) ||
              type === "TSOptionalType");
        });
        return this.finishNode(node, "TSTupleType");
      }
      tsParseTupleElementType() {
        const { startLoc: startLoc } = this.state;
        const rest = this.eat(21);
        let labeled;
        let label;
        let optional;
        let type;
        const isWord = tokenIsKeywordOrIdentifier(this.state.type);
        const chAfterWord = isWord ? this.lookaheadCharCode() : null;
        if (chAfterWord === 58) {
          labeled = true;
          optional = false;
          label = this.parseIdentifier(true);
          this.expect(14);
          type = this.tsParseType();
        } else if (chAfterWord === 63) {
          optional = true;
          const startLoc = this.state.startLoc;
          const wordName = this.state.value;
          const typeOrLabel = this.tsParseNonArrayType();
          if (this.lookaheadCharCode() === 58) {
            labeled = true;
            label = this.createIdentifier(this.startNodeAt(startLoc), wordName);
            this.expect(17);
            this.expect(14);
            type = this.tsParseType();
          } else {
            labeled = false;
            type = typeOrLabel;
            this.expect(17);
          }
        } else {
          type = this.tsParseType();
          optional = this.eat(17);
          labeled = this.eat(14);
        }
        if (labeled) {
          let labeledNode;
          if (label) {
            labeledNode = this.startNodeAtNode(label);
            labeledNode.optional = optional;
            labeledNode.label = label;
            labeledNode.elementType = type;
            if (this.eat(17)) {
              labeledNode.optional = true;
              this.raise(
                TSErrors.TupleOptionalAfterType,
                this.state.lastTokStartLoc,
              );
            }
          } else {
            labeledNode = this.startNodeAtNode(type);
            labeledNode.optional = optional;
            this.raise(TSErrors.InvalidTupleMemberLabel, type);
            labeledNode.label = type;
            labeledNode.elementType = this.tsParseType();
          }
          type = this.finishNode(labeledNode, "TSNamedTupleMember");
        } else if (optional) {
          const optionalTypeNode = this.startNodeAtNode(type);
          optionalTypeNode.typeAnnotation = type;
          type = this.finishNode(optionalTypeNode, "TSOptionalType");
        }
        if (rest) {
          const restNode = this.startNodeAt(startLoc);
          restNode.typeAnnotation = type;
          type = this.finishNode(restNode, "TSRestType");
        }
        return type;
      }
      tsParseParenthesizedType() {
        const node = this.startNode();
        this.expect(10);
        node.typeAnnotation = this.tsParseType();
        this.expect(11);
        return this.finishNode(node, "TSParenthesizedType");
      }
      tsParseFunctionOrConstructorType(type, abstract) {
        const node = this.startNode();
        if (type === "TSConstructorType") {
          node.abstract = !!abstract;
          if (abstract) this.next();
          this.next();
        }
        this.tsInAllowConditionalTypesContext(() =>
          this.tsFillSignature(19, node),
        );
        return this.finishNode(node, type);
      }
      tsParseLiteralTypeNode() {
        const node = this.startNode();
        switch (this.state.type) {
          case 134:
          case 135:
          case 133:
          case 85:
          case 86:
            node.literal = super.parseExprAtom();
            break;
          default:
            this.unexpected();
        }
        return this.finishNode(node, "TSLiteralType");
      }
      tsParseTemplateLiteralType() {
        const node = this.startNode();
        node.literal = super.parseTemplate(false);
        return this.finishNode(node, "TSLiteralType");
      }
      parseTemplateSubstitution() {
        if (this.state.inType) return this.tsParseType();
        return super.parseTemplateSubstitution();
      }
      tsParseThisTypeOrThisTypePredicate() {
        const thisKeyword = this.tsParseThisTypeNode();
        if (this.isContextual(116) && !this.hasPrecedingLineBreak()) {
          return this.tsParseThisTypePredicate(thisKeyword);
        } else {
          return thisKeyword;
        }
      }
      tsParseNonArrayType() {
        switch (this.state.type) {
          case 133:
          case 134:
          case 135:
          case 85:
          case 86:
            return this.tsParseLiteralTypeNode();
          case 53:
            if (this.state.value === "-") {
              const node = this.startNode();
              const nextToken = this.lookahead();
              if (nextToken.type !== 134 && nextToken.type !== 135) {
                this.unexpected();
              }
              node.literal = this.parseMaybeUnary();
              return this.finishNode(node, "TSLiteralType");
            }
            break;
          case 78:
            return this.tsParseThisTypeOrThisTypePredicate();
          case 87:
            return this.tsParseTypeQuery();
          case 83:
            return this.tsParseImportType();
          case 5:
            return this.tsLookAhead(this.tsIsStartOfMappedType.bind(this))
              ? this.tsParseMappedType()
              : this.tsParseTypeLiteral();
          case 0:
            return this.tsParseTupleType();
          case 10:
            return this.tsParseParenthesizedType();
          case 25:
          case 24:
            return this.tsParseTemplateLiteralType();
          default: {
            const { type: type } = this.state;
            if (tokenIsIdentifier(type) || type === 88 || type === 84) {
              const nodeType =
                type === 88
                  ? "TSVoidKeyword"
                  : type === 84
                    ? "TSNullKeyword"
                    : keywordTypeFromName(this.state.value);
              if (nodeType !== undefined && this.lookaheadCharCode() !== 46) {
                const node = this.startNode();
                this.next();
                return this.finishNode(node, nodeType);
              }
              return this.tsParseTypeReference();
            }
          }
        }
        this.unexpected();
      }
      tsParseArrayTypeOrHigher() {
        let type = this.tsParseNonArrayType();
        while (!this.hasPrecedingLineBreak() && this.eat(0)) {
          if (this.match(3)) {
            const node = this.startNodeAtNode(type);
            node.elementType = type;
            this.expect(3);
            type = this.finishNode(node, "TSArrayType");
          } else {
            const node = this.startNodeAtNode(type);
            node.objectType = type;
            node.indexType = this.tsParseType();
            this.expect(3);
            type = this.finishNode(node, "TSIndexedAccessType");
          }
        }
        return type;
      }
      tsParseTypeOperator() {
        const node = this.startNode();
        const operator = this.state.value;
        this.next();
        node.operator = operator;
        node.typeAnnotation = this.tsParseTypeOperatorOrHigher();
        if (operator === "readonly") {
          this.tsCheckTypeAnnotationForReadOnly(node);
        }
        return this.finishNode(node, "TSTypeOperator");
      }
      tsCheckTypeAnnotationForReadOnly(node) {
        switch (node.typeAnnotation.type) {
          case "TSTupleType":
          case "TSArrayType":
            return;
          default:
            this.raise(TSErrors.UnexpectedReadonly, node);
        }
      }
      tsParseInferType() {
        const node = this.startNode();
        this.expectContextual(115);
        const typeParameter = this.startNode();
        typeParameter.name = this.tsParseTypeParameterName();
        typeParameter.constraint = this.tsTryParse(() =>
          this.tsParseConstraintForInferType(),
        );
        node.typeParameter = this.finishNode(typeParameter, "TSTypeParameter");
        return this.finishNode(node, "TSInferType");
      }
      tsParseConstraintForInferType() {
        if (this.eat(81)) {
          const constraint = this.tsInDisallowConditionalTypesContext(() =>
            this.tsParseType(),
          );
          if (this.state.inDisallowConditionalTypesContext || !this.match(17)) {
            return constraint;
          }
        }
      }
      tsParseTypeOperatorOrHigher() {
        const isTypeOperator =
          tokenIsTSTypeOperator(this.state.type) && !this.state.containsEsc;
        return isTypeOperator
          ? this.tsParseTypeOperator()
          : this.isContextual(115)
            ? this.tsParseInferType()
            : this.tsInAllowConditionalTypesContext(() =>
                this.tsParseArrayTypeOrHigher(),
              );
      }
      tsParseUnionOrIntersectionType(kind, parseConstituentType, operator) {
        const node = this.startNode();
        const hasLeadingOperator = this.eat(operator);
        const types = [];
        do {
          types.push(parseConstituentType());
        } while (this.eat(operator));
        if (types.length === 1 && !hasLeadingOperator) {
          return types[0];
        }
        node.types = types;
        return this.finishNode(node, kind);
      }
      tsParseIntersectionTypeOrHigher() {
        return this.tsParseUnionOrIntersectionType(
          "TSIntersectionType",
          this.tsParseTypeOperatorOrHigher.bind(this),
          45,
        );
      }
      tsParseUnionTypeOrHigher() {
        return this.tsParseUnionOrIntersectionType(
          "TSUnionType",
          this.tsParseIntersectionTypeOrHigher.bind(this),
          43,
        );
      }
      tsIsStartOfFunctionType() {
        if (this.match(47)) {
          return true;
        }
        return (
          this.match(10) &&
          this.tsLookAhead(this.tsIsUnambiguouslyStartOfFunctionType.bind(this))
        );
      }
      tsSkipParameterStart() {
        if (tokenIsIdentifier(this.state.type) || this.match(78)) {
          this.next();
          return true;
        }
        if (this.match(5)) {
          const { errors: errors } = this.state;
          const previousErrorCount = errors.length;
          try {
            this.parseObjectLike(8, true);
            return errors.length === previousErrorCount;
          } catch (_unused) {
            return false;
          }
        }
        if (this.match(0)) {
          this.next();
          const { errors: errors } = this.state;
          const previousErrorCount = errors.length;
          try {
            super.parseBindingList(3, 93, 1);
            return errors.length === previousErrorCount;
          } catch (_unused2) {
            return false;
          }
        }
        return false;
      }
      tsIsUnambiguouslyStartOfFunctionType() {
        this.next();
        if (this.match(11) || this.match(21)) {
          return true;
        }
        if (this.tsSkipParameterStart()) {
          if (
            this.match(14) ||
            this.match(12) ||
            this.match(17) ||
            this.match(29)
          ) {
            return true;
          }
          if (this.match(11)) {
            this.next();
            if (this.match(19)) {
              return true;
            }
          }
        }
        return false;
      }
      tsParseTypeOrTypePredicateAnnotation(returnToken) {
        return this.tsInType(() => {
          const t = this.startNode();
          this.expect(returnToken);
          const node = this.startNode();
          const asserts = !!this.tsTryParse(
            this.tsParseTypePredicateAsserts.bind(this),
          );
          if (asserts && this.match(78)) {
            let thisTypePredicate = this.tsParseThisTypeOrThisTypePredicate();
            if (thisTypePredicate.type === "TSThisType") {
              node.parameterName = thisTypePredicate;
              node.asserts = true;
              node.typeAnnotation = null;
              thisTypePredicate = this.finishNode(node, "TSTypePredicate");
            } else {
              this.resetStartLocationFromNode(thisTypePredicate, node);
              thisTypePredicate.asserts = true;
            }
            t.typeAnnotation = thisTypePredicate;
            return this.finishNode(t, "TSTypeAnnotation");
          }
          const typePredicateVariable =
            this.tsIsIdentifier() &&
            this.tsTryParse(this.tsParseTypePredicatePrefix.bind(this));
          if (!typePredicateVariable) {
            if (!asserts) {
              return this.tsParseTypeAnnotation(false, t);
            }
            node.parameterName = this.parseIdentifier();
            node.asserts = asserts;
            node.typeAnnotation = null;
            t.typeAnnotation = this.finishNode(node, "TSTypePredicate");
            return this.finishNode(t, "TSTypeAnnotation");
          }
          const type = this.tsParseTypeAnnotation(false);
          node.parameterName = typePredicateVariable;
          node.typeAnnotation = type;
          node.asserts = asserts;
          t.typeAnnotation = this.finishNode(node, "TSTypePredicate");
          return this.finishNode(t, "TSTypeAnnotation");
        });
      }
      tsTryParseTypeOrTypePredicateAnnotation() {
        if (this.match(14)) {
          return this.tsParseTypeOrTypePredicateAnnotation(14);
        }
      }
      tsTryParseTypeAnnotation() {
        if (this.match(14)) {
          return this.tsParseTypeAnnotation();
        }
      }
      tsTryParseType() {
        return this.tsEatThenParseType(14);
      }
      tsParseTypePredicatePrefix() {
        const id = this.parseIdentifier();
        if (this.isContextual(116) && !this.hasPrecedingLineBreak()) {
          this.next();
          return id;
        }
      }
      tsParseTypePredicateAsserts() {
        if (this.state.type !== 109) {
          return false;
        }
        const containsEsc = this.state.containsEsc;
        this.next();
        if (!tokenIsIdentifier(this.state.type) && !this.match(78)) {
          return false;
        }
        if (containsEsc) {
          this.raise(
            Errors.InvalidEscapedReservedWord,
            this.state.lastTokStartLoc,
            { reservedWord: "asserts" },
          );
        }
        return true;
      }
      tsParseTypeAnnotation(eatColon = true, t = this.startNode()) {
        this.tsInType(() => {
          if (eatColon) this.expect(14);
          t.typeAnnotation = this.tsParseType();
        });
        return this.finishNode(t, "TSTypeAnnotation");
      }
      tsParseType() {
        assert(this.state.inType);
        const type = this.tsParseNonConditionalType();
        if (
          this.state.inDisallowConditionalTypesContext ||
          this.hasPrecedingLineBreak() ||
          !this.eat(81)
        ) {
          return type;
        }
        const node = this.startNodeAtNode(type);
        node.checkType = type;
        node.extendsType = this.tsInDisallowConditionalTypesContext(() =>
          this.tsParseNonConditionalType(),
        );
        this.expect(17);
        node.trueType = this.tsInAllowConditionalTypesContext(() =>
          this.tsParseType(),
        );
        this.expect(14);
        node.falseType = this.tsInAllowConditionalTypesContext(() =>
          this.tsParseType(),
        );
        return this.finishNode(node, "TSConditionalType");
      }
      isAbstractConstructorSignature() {
        return this.isContextual(124) && this.lookahead().type === 77;
      }
      tsParseNonConditionalType() {
        if (this.tsIsStartOfFunctionType()) {
          return this.tsParseFunctionOrConstructorType("TSFunctionType");
        }
        if (this.match(77)) {
          return this.tsParseFunctionOrConstructorType("TSConstructorType");
        } else if (this.isAbstractConstructorSignature()) {
          return this.tsParseFunctionOrConstructorType(
            "TSConstructorType",
            true,
          );
        }
        return this.tsParseUnionTypeOrHigher();
      }
      tsParseTypeAssertion() {
        if (this.getPluginOption("typescript", "disallowAmbiguousJSXLike")) {
          this.raise(TSErrors.ReservedTypeAssertion, this.state.startLoc);
        }
        const node = this.startNode();
        node.typeAnnotation = this.tsInType(() => {
          this.next();
          return this.match(75)
            ? this.tsParseTypeReference()
            : this.tsParseType();
        });
        this.expect(48);
        node.expression = this.parseMaybeUnary();
        return this.finishNode(node, "TSTypeAssertion");
      }
      tsParseHeritageClause(token) {
        const originalStartLoc = this.state.startLoc;
        const delimitedList = this.tsParseDelimitedList(
          "HeritageClauseElement",
          () => {
            const node = this.startNode();
            node.expression = this.tsParseEntityName();
            if (this.match(47)) {
              node.typeParameters = this.tsParseTypeArguments();
            }
            return this.finishNode(node, "TSExpressionWithTypeArguments");
          },
        );
        if (!delimitedList.length) {
          this.raise(TSErrors.EmptyHeritageClauseType, originalStartLoc, {
            token: token,
          });
        }
        return delimitedList;
      }
      tsParseInterfaceDeclaration(node, properties = {}) {
        if (this.hasFollowingLineBreak()) return null;
        this.expectContextual(129);
        if (properties.declare) node.declare = true;
        if (tokenIsIdentifier(this.state.type)) {
          node.id = this.parseIdentifier();
          this.checkIdentifier(node.id, 130);
        } else {
          node.id = null;
          this.raise(TSErrors.MissingInterfaceName, this.state.startLoc);
        }
        node.typeParameters = this.tsTryParseTypeParameters(
          this.tsParseInOutConstModifiers,
        );
        if (this.eat(81)) {
          node.extends = this.tsParseHeritageClause("extends");
        }
        const body = this.startNode();
        body.body = this.tsInType(this.tsParseObjectTypeMembers.bind(this));
        node.body = this.finishNode(body, "TSInterfaceBody");
        return this.finishNode(node, "TSInterfaceDeclaration");
      }
      tsParseTypeAliasDeclaration(node) {
        node.id = this.parseIdentifier();
        this.checkIdentifier(node.id, 2);
        node.typeAnnotation = this.tsInType(() => {
          node.typeParameters = this.tsTryParseTypeParameters(
            this.tsParseInOutModifiers,
          );
          this.expect(29);
          if (this.isContextual(114) && this.lookahead().type !== 16) {
            const node = this.startNode();
            this.next();
            return this.finishNode(node, "TSIntrinsicKeyword");
          }
          return this.tsParseType();
        });
        this.semicolon();
        return this.finishNode(node, "TSTypeAliasDeclaration");
      }
      tsInNoContext(cb) {
        const oldContext = this.state.context;
        this.state.context = [oldContext[0]];
        try {
          return cb();
        } finally {
          this.state.context = oldContext;
        }
      }
      tsInType(cb) {
        const oldInType = this.state.inType;
        this.state.inType = true;
        try {
          return cb();
        } finally {
          this.state.inType = oldInType;
        }
      }
      tsInDisallowConditionalTypesContext(cb) {
        const oldInDisallowConditionalTypesContext =
          this.state.inDisallowConditionalTypesContext;
        this.state.inDisallowConditionalTypesContext = true;
        try {
          return cb();
        } finally {
          this.state.inDisallowConditionalTypesContext =
            oldInDisallowConditionalTypesContext;
        }
      }
      tsInAllowConditionalTypesContext(cb) {
        const oldInDisallowConditionalTypesContext =
          this.state.inDisallowConditionalTypesContext;
        this.state.inDisallowConditionalTypesContext = false;
        try {
          return cb();
        } finally {
          this.state.inDisallowConditionalTypesContext =
            oldInDisallowConditionalTypesContext;
        }
      }
      tsEatThenParseType(token) {
        if (this.match(token)) {
          return this.tsNextThenParseType();
        }
      }
      tsExpectThenParseType(token) {
        return this.tsInType(() => {
          this.expect(token);
          return this.tsParseType();
        });
      }
      tsNextThenParseType() {
        return this.tsInType(() => {
          this.next();
          return this.tsParseType();
        });
      }
      tsParseEnumMember() {
        const node = this.startNode();
        node.id = this.match(133)
          ? super.parseStringLiteral(this.state.value)
          : this.parseIdentifier(true);
        if (this.eat(29)) {
          node.initializer = super.parseMaybeAssignAllowIn();
        }
        return this.finishNode(node, "TSEnumMember");
      }
      tsParseEnumDeclaration(node, properties = {}) {
        if (properties.const) node.const = true;
        if (properties.declare) node.declare = true;
        this.expectContextual(126);
        node.id = this.parseIdentifier();
        this.checkIdentifier(node.id, node.const ? 8971 : 8459);
        this.expect(5);
        node.members = this.tsParseDelimitedList(
          "EnumMembers",
          this.tsParseEnumMember.bind(this),
        );
        this.expect(8);
        return this.finishNode(node, "TSEnumDeclaration");
      }
      tsParseModuleBlock() {
        const node = this.startNode();
        this.scope.enter(0);
        this.expect(5);
        super.parseBlockOrModuleBlockBody((node.body = []), undefined, true, 8);
        this.scope.exit();
        return this.finishNode(node, "TSModuleBlock");
      }
      tsParseModuleOrNamespaceDeclaration(node, nested = false) {
        node.id = this.parseIdentifier();
        if (!nested) {
          this.checkIdentifier(node.id, 1024);
        }
        if (this.eat(16)) {
          const inner = this.startNode();
          this.tsParseModuleOrNamespaceDeclaration(inner, true);
          node.body = inner;
        } else {
          this.scope.enter(256);
          this.prodParam.enter(0);
          node.body = this.tsParseModuleBlock();
          this.prodParam.exit();
          this.scope.exit();
        }
        return this.finishNode(node, "TSModuleDeclaration");
      }
      tsParseAmbientExternalModuleDeclaration(node) {
        if (this.isContextual(112)) {
          node.global = true;
          node.id = this.parseIdentifier();
        } else if (this.match(133)) {
          node.id = super.parseStringLiteral(this.state.value);
        } else {
          this.unexpected();
        }
        if (this.match(5)) {
          this.scope.enter(256);
          this.prodParam.enter(0);
          node.body = this.tsParseModuleBlock();
          this.prodParam.exit();
          this.scope.exit();
        } else {
          this.semicolon();
        }
        return this.finishNode(node, "TSModuleDeclaration");
      }
      tsParseImportEqualsDeclaration(node, maybeDefaultIdentifier, isExport) {
        node.isExport = isExport || false;
        node.id = maybeDefaultIdentifier || this.parseIdentifier();
        this.checkIdentifier(node.id, 4096);
        this.expect(29);
        const moduleReference = this.tsParseModuleReference();
        if (
          node.importKind === "type" &&
          moduleReference.type !== "TSExternalModuleReference"
        ) {
          this.raise(TSErrors.ImportAliasHasImportType, moduleReference);
        }
        node.moduleReference = moduleReference;
        this.semicolon();
        return this.finishNode(node, "TSImportEqualsDeclaration");
      }
      tsIsExternalModuleReference() {
        return this.isContextual(119) && this.lookaheadCharCode() === 40;
      }
      tsParseModuleReference() {
        return this.tsIsExternalModuleReference()
          ? this.tsParseExternalModuleReference()
          : this.tsParseEntityName(false);
      }
      tsParseExternalModuleReference() {
        const node = this.startNode();
        this.expectContextual(119);
        this.expect(10);
        if (!this.match(133)) {
          this.unexpected();
        }
        node.expression = super.parseExprAtom();
        this.expect(11);
        this.sawUnambiguousESM = true;
        return this.finishNode(node, "TSExternalModuleReference");
      }
      tsLookAhead(f) {
        const state = this.state.clone();
        const res = f();
        this.state = state;
        return res;
      }
      tsTryParseAndCatch(f) {
        const result = this.tryParse((abort) => f() || abort());
        if (result.aborted || !result.node) return;
        if (result.error) this.state = result.failState;
        return result.node;
      }
      tsTryParse(f) {
        const state = this.state.clone();
        const result = f();
        if (result !== undefined && result !== false) {
          return result;
        }
        this.state = state;
      }
      tsTryParseDeclare(nany) {
        if (this.isLineTerminator()) {
          return;
        }
        let startType = this.state.type;
        let kind;
        if (this.isContextual(100)) {
          startType = 74;
          kind = "let";
        }
        return this.tsInAmbientContext(() => {
          switch (startType) {
            case 68:
              nany.declare = true;
              return super.parseFunctionStatement(nany, false, false);
            case 80:
              nany.declare = true;
              return this.parseClass(nany, true, false);
            case 126:
              return this.tsParseEnumDeclaration(nany, { declare: true });
            case 112:
              return this.tsParseAmbientExternalModuleDeclaration(nany);
            case 75:
            case 74:
              if (!this.match(75) || !this.isLookaheadContextual("enum")) {
                nany.declare = true;
                return this.parseVarStatement(
                  nany,
                  kind || this.state.value,
                  true,
                );
              }
              this.expect(75);
              return this.tsParseEnumDeclaration(nany, {
                const: true,
                declare: true,
              });
            case 129: {
              const result = this.tsParseInterfaceDeclaration(nany, {
                declare: true,
              });
              if (result) return result;
            }
            default:
              if (tokenIsIdentifier(startType)) {
                return this.tsParseDeclaration(
                  nany,
                  this.state.value,
                  true,
                  null,
                );
              }
          }
        });
      }
      tsTryParseExportDeclaration() {
        return this.tsParseDeclaration(
          this.startNode(),
          this.state.value,
          true,
          null,
        );
      }
      tsParseExpressionStatement(node, expr, decorators) {
        switch (expr.name) {
          case "declare": {
            const declaration = this.tsTryParseDeclare(node);
            if (declaration) {
              declaration.declare = true;
            }
            return declaration;
          }
          case "global":
            if (this.match(5)) {
              this.scope.enter(256);
              this.prodParam.enter(0);
              const mod = node;
              mod.global = true;
              mod.id = expr;
              mod.body = this.tsParseModuleBlock();
              this.scope.exit();
              this.prodParam.exit();
              return this.finishNode(mod, "TSModuleDeclaration");
            }
            break;
          default:
            return this.tsParseDeclaration(node, expr.name, false, decorators);
        }
      }
      tsParseDeclaration(node, value, next, decorators) {
        switch (value) {
          case "abstract":
            if (
              this.tsCheckLineTerminator(next) &&
              (this.match(80) || tokenIsIdentifier(this.state.type))
            ) {
              return this.tsParseAbstractDeclaration(node, decorators);
            }
            break;
          case "module":
            if (this.tsCheckLineTerminator(next)) {
              if (this.match(133)) {
                return this.tsParseAmbientExternalModuleDeclaration(node);
              } else if (tokenIsIdentifier(this.state.type)) {
                return this.tsParseModuleOrNamespaceDeclaration(node);
              }
            }
            break;
          case "namespace":
            if (
              this.tsCheckLineTerminator(next) &&
              tokenIsIdentifier(this.state.type)
            ) {
              return this.tsParseModuleOrNamespaceDeclaration(node);
            }
            break;
          case "type":
            if (
              this.tsCheckLineTerminator(next) &&
              tokenIsIdentifier(this.state.type)
            ) {
              return this.tsParseTypeAliasDeclaration(node);
            }
            break;
        }
      }
      tsCheckLineTerminator(next) {
        if (next) {
          if (this.hasFollowingLineBreak()) return false;
          this.next();
          return true;
        }
        return !this.isLineTerminator();
      }
      tsTryParseGenericAsyncArrowFunction(startLoc) {
        if (!this.match(47)) return;
        const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
        this.state.maybeInArrowParameters = true;
        const res = this.tsTryParseAndCatch(() => {
          const node = this.startNodeAt(startLoc);
          node.typeParameters = this.tsParseTypeParameters(
            this.tsParseConstModifier,
          );
          super.parseFunctionParams(node);
          node.returnType = this.tsTryParseTypeOrTypePredicateAnnotation();
          this.expect(19);
          return node;
        });
        this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
        if (!res) return;
        return super.parseArrowExpression(res, null, true);
      }
      tsParseTypeArgumentsInExpression() {
        if (this.reScan_lt() !== 47) return;
        return this.tsParseTypeArguments();
      }
      tsParseTypeArguments() {
        const node = this.startNode();
        node.params = this.tsInType(() =>
          this.tsInNoContext(() => {
            this.expect(47);
            return this.tsParseDelimitedList(
              "TypeParametersOrArguments",
              this.tsParseType.bind(this),
            );
          }),
        );
        if (node.params.length === 0) {
          this.raise(TSErrors.EmptyTypeArguments, node);
        } else if (!this.state.inType && this.curContext() === types.brace) {
          this.reScan_lt_gt();
        }
        this.expect(48);
        return this.finishNode(node, "TSTypeParameterInstantiation");
      }
      tsIsDeclarationStart() {
        return tokenIsTSDeclarationStart(this.state.type);
      }
      isExportDefaultSpecifier() {
        if (this.tsIsDeclarationStart()) return false;
        return super.isExportDefaultSpecifier();
      }
      parseAssignableListItem(flags, decorators) {
        const startLoc = this.state.startLoc;
        const modified = {};
        this.tsParseModifiers(
          {
            allowedModifiers: [
              "public",
              "private",
              "protected",
              "override",
              "readonly",
            ],
          },
          modified,
        );
        const accessibility = modified.accessibility;
        const override = modified.override;
        const readonly = modified.readonly;
        if (!(flags & 4) && (accessibility || readonly || override)) {
          this.raise(TSErrors.UnexpectedParameterModifier, startLoc);
        }
        const left = this.parseMaybeDefault();
        this.parseAssignableListItemTypes(left, flags);
        const elt = this.parseMaybeDefault(left.loc.start, left);
        if (accessibility || readonly || override) {
          const pp = this.startNodeAt(startLoc);
          if (decorators.length) {
            pp.decorators = decorators;
          }
          if (accessibility) pp.accessibility = accessibility;
          if (readonly) pp.readonly = readonly;
          if (override) pp.override = override;
          if (elt.type !== "Identifier" && elt.type !== "AssignmentPattern") {
            this.raise(TSErrors.UnsupportedParameterPropertyKind, pp);
          }
          pp.parameter = elt;
          return this.finishNode(pp, "TSParameterProperty");
        }
        if (decorators.length) {
          left.decorators = decorators;
        }
        return elt;
      }
      isSimpleParameter(node) {
        return (
          (node.type === "TSParameterProperty" &&
            super.isSimpleParameter(node.parameter)) ||
          super.isSimpleParameter(node)
        );
      }
      tsDisallowOptionalPattern(node) {
        for (const param of node.params) {
          if (
            param.type !== "Identifier" &&
            param.optional &&
            !this.state.isAmbientContext
          ) {
            this.raise(TSErrors.PatternIsOptional, param);
          }
        }
      }
      setArrowFunctionParameters(node, params, trailingCommaLoc) {
        super.setArrowFunctionParameters(node, params, trailingCommaLoc);
        this.tsDisallowOptionalPattern(node);
      }
      parseFunctionBodyAndFinish(node, type, isMethod = false) {
        if (this.match(14)) {
          node.returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
        }
        const bodilessType =
          type === "FunctionDeclaration"
            ? "TSDeclareFunction"
            : type === "ClassMethod" || type === "ClassPrivateMethod"
              ? "TSDeclareMethod"
              : undefined;
        if (bodilessType && !this.match(5) && this.isLineTerminator()) {
          return this.finishNode(node, bodilessType);
        }
        if (
          bodilessType === "TSDeclareFunction" &&
          this.state.isAmbientContext
        ) {
          this.raise(TSErrors.DeclareFunctionHasImplementation, node);
          if (node.declare) {
            return super.parseFunctionBodyAndFinish(
              node,
              bodilessType,
              isMethod,
            );
          }
        }
        this.tsDisallowOptionalPattern(node);
        return super.parseFunctionBodyAndFinish(node, type, isMethod);
      }
      registerFunctionStatementId(node) {
        if (!node.body && node.id) {
          this.checkIdentifier(node.id, 1024);
        } else {
          super.registerFunctionStatementId(node);
        }
      }
      tsCheckForInvalidTypeCasts(items) {
        items.forEach((node) => {
          if ((node == null ? void 0 : node.type) === "TSTypeCastExpression") {
            this.raise(TSErrors.UnexpectedTypeAnnotation, node.typeAnnotation);
          }
        });
      }
      toReferencedList(exprList, isInParens) {
        this.tsCheckForInvalidTypeCasts(exprList);
        return exprList;
      }
      parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
        const node = super.parseArrayLike(
          close,
          canBePattern,
          isTuple,
          refExpressionErrors,
        );
        if (node.type === "ArrayExpression") {
          this.tsCheckForInvalidTypeCasts(node.elements);
        }
        return node;
      }
      parseSubscript(base, startLoc, noCalls, state) {
        if (!this.hasPrecedingLineBreak() && this.match(35)) {
          this.state.canStartJSXElement = false;
          this.next();
          const nonNullExpression = this.startNodeAt(startLoc);
          nonNullExpression.expression = base;
          return this.finishNode(nonNullExpression, "TSNonNullExpression");
        }
        let isOptionalCall = false;
        if (this.match(18) && this.lookaheadCharCode() === 60) {
          if (noCalls) {
            state.stop = true;
            return base;
          }
          state.optionalChainMember = isOptionalCall = true;
          this.next();
        }
        if (this.match(47) || this.match(51)) {
          let missingParenErrorLoc;
          const result = this.tsTryParseAndCatch(() => {
            if (!noCalls && this.atPossibleAsyncArrow(base)) {
              const asyncArrowFn =
                this.tsTryParseGenericAsyncArrowFunction(startLoc);
              if (asyncArrowFn) {
                return asyncArrowFn;
              }
            }
            const typeArguments = this.tsParseTypeArgumentsInExpression();
            if (!typeArguments) return;
            if (isOptionalCall && !this.match(10)) {
              missingParenErrorLoc = this.state.curPosition();
              return;
            }
            if (tokenIsTemplate(this.state.type)) {
              const result = super.parseTaggedTemplateExpression(
                base,
                startLoc,
                state,
              );
              result.typeParameters = typeArguments;
              return result;
            }
            if (!noCalls && this.eat(10)) {
              const node = this.startNodeAt(startLoc);
              node.callee = base;
              node.arguments = this.parseCallExpressionArguments(11, false);
              this.tsCheckForInvalidTypeCasts(node.arguments);
              node.typeParameters = typeArguments;
              if (state.optionalChainMember) {
                node.optional = isOptionalCall;
              }
              return this.finishCallExpression(node, state.optionalChainMember);
            }
            const tokenType = this.state.type;
            if (
              tokenType === 48 ||
              tokenType === 52 ||
              (tokenType !== 10 &&
                tokenCanStartExpression(tokenType) &&
                !this.hasPrecedingLineBreak())
            ) {
              return;
            }
            const node = this.startNodeAt(startLoc);
            node.expression = base;
            node.typeParameters = typeArguments;
            return this.finishNode(node, "TSInstantiationExpression");
          });
          if (missingParenErrorLoc) {
            this.unexpected(missingParenErrorLoc, 10);
          }
          if (result) {
            if (
              result.type === "TSInstantiationExpression" &&
              (this.match(16) ||
                (this.match(18) && this.lookaheadCharCode() !== 40))
            ) {
              this.raise(
                TSErrors.InvalidPropertyAccessAfterInstantiationExpression,
                this.state.startLoc,
              );
            }
            return result;
          }
        }
        return super.parseSubscript(base, startLoc, noCalls, state);
      }
      parseNewCallee(node) {
        var _callee$extra;
        super.parseNewCallee(node);
        const { callee: callee } = node;
        if (
          callee.type === "TSInstantiationExpression" &&
          !(
            (_callee$extra = callee.extra) != null &&
            _callee$extra.parenthesized
          )
        ) {
          node.typeParameters = callee.typeParameters;
          node.callee = callee.expression;
        }
      }
      parseExprOp(left, leftStartLoc, minPrec) {
        let isSatisfies;
        if (
          tokenOperatorPrecedence(58) > minPrec &&
          !this.hasPrecedingLineBreak() &&
          (this.isContextual(93) || (isSatisfies = this.isContextual(120)))
        ) {
          const node = this.startNodeAt(leftStartLoc);
          node.expression = left;
          node.typeAnnotation = this.tsInType(() => {
            this.next();
            if (this.match(75)) {
              if (isSatisfies) {
                this.raise(Errors.UnexpectedKeyword, this.state.startLoc, {
                  keyword: "const",
                });
              }
              return this.tsParseTypeReference();
            }
            return this.tsParseType();
          });
          this.finishNode(
            node,
            isSatisfies ? "TSSatisfiesExpression" : "TSAsExpression",
          );
          this.reScan_lt_gt();
          return this.parseExprOp(node, leftStartLoc, minPrec);
        }
        return super.parseExprOp(left, leftStartLoc, minPrec);
      }
      checkReservedWord(word, startLoc, checkKeywords, isBinding) {
        if (!this.state.isAmbientContext) {
          super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
        }
      }
      checkImportReflection(node) {
        super.checkImportReflection(node);
        if (node.module && node.importKind !== "value") {
          this.raise(
            TSErrors.ImportReflectionHasImportType,
            node.specifiers[0].loc.start,
          );
        }
      }
      checkDuplicateExports() {}
      isPotentialImportPhase(isExport) {
        if (super.isPotentialImportPhase(isExport)) return true;
        if (this.isContextual(130)) {
          const ch = this.lookaheadCharCode();
          return isExport ? ch === 123 || ch === 42 : ch !== 61;
        }
        return !isExport && this.isContextual(87);
      }
      applyImportPhase(node, isExport, phase, loc) {
        super.applyImportPhase(node, isExport, phase, loc);
        if (isExport) {
          node.exportKind = phase === "type" ? "type" : "value";
        } else {
          node.importKind =
            phase === "type" || phase === "typeof" ? phase : "value";
        }
      }
      parseImport(node) {
        if (this.match(133)) {
          node.importKind = "value";
          return super.parseImport(node);
        }
        let importNode;
        if (
          tokenIsIdentifier(this.state.type) &&
          this.lookaheadCharCode() === 61
        ) {
          node.importKind = "value";
          return this.tsParseImportEqualsDeclaration(node);
        } else if (this.isContextual(130)) {
          const maybeDefaultIdentifier = this.parseMaybeImportPhase(
            node,
            false,
          );
          if (this.lookaheadCharCode() === 61) {
            return this.tsParseImportEqualsDeclaration(
              node,
              maybeDefaultIdentifier,
            );
          } else {
            importNode = super.parseImportSpecifiersAndAfter(
              node,
              maybeDefaultIdentifier,
            );
          }
        } else {
          importNode = super.parseImport(node);
        }
        if (
          importNode.importKind === "type" &&
          importNode.specifiers.length > 1 &&
          importNode.specifiers[0].type === "ImportDefaultSpecifier"
        ) {
          this.raise(
            TSErrors.TypeImportCannotSpecifyDefaultAndNamed,
            importNode,
          );
        }
        return importNode;
      }
      parseExport(node, decorators) {
        if (this.match(83)) {
          this.next();
          let maybeDefaultIdentifier = null;
          if (this.isContextual(130) && this.isPotentialImportPhase(false)) {
            maybeDefaultIdentifier = this.parseMaybeImportPhase(node, false);
          } else {
            node.importKind = "value";
          }
          return this.tsParseImportEqualsDeclaration(
            node,
            maybeDefaultIdentifier,
            true,
          );
        } else if (this.eat(29)) {
          const assign = node;
          assign.expression = super.parseExpression();
          this.semicolon();
          this.sawUnambiguousESM = true;
          return this.finishNode(assign, "TSExportAssignment");
        } else if (this.eatContextual(93)) {
          const decl = node;
          this.expectContextual(128);
          decl.id = this.parseIdentifier();
          this.semicolon();
          return this.finishNode(decl, "TSNamespaceExportDeclaration");
        } else {
          return super.parseExport(node, decorators);
        }
      }
      isAbstractClass() {
        return this.isContextual(124) && this.lookahead().type === 80;
      }
      parseExportDefaultExpression() {
        if (this.isAbstractClass()) {
          const cls = this.startNode();
          this.next();
          cls.abstract = true;
          return this.parseClass(cls, true, true);
        }
        if (this.match(129)) {
          const result = this.tsParseInterfaceDeclaration(this.startNode());
          if (result) return result;
        }
        return super.parseExportDefaultExpression();
      }
      parseVarStatement(node, kind, allowMissingInitializer = false) {
        const { isAmbientContext: isAmbientContext } = this.state;
        const declaration = super.parseVarStatement(
          node,
          kind,
          allowMissingInitializer || isAmbientContext,
        );
        if (!isAmbientContext) return declaration;
        for (const { id: id, init: init } of declaration.declarations) {
          if (!init) continue;
          if (kind !== "const" || !!id.typeAnnotation) {
            this.raise(TSErrors.InitializerNotAllowedInAmbientContext, init);
          } else if (
            !isValidAmbientConstInitializer(init, this.hasPlugin("estree"))
          ) {
            this.raise(
              TSErrors.ConstInitiailizerMustBeStringOrNumericLiteralOrLiteralEnumReference,
              init,
            );
          }
        }
        return declaration;
      }
      parseStatementContent(flags, decorators) {
        if (this.match(75) && this.isLookaheadContextual("enum")) {
          const node = this.startNode();
          this.expect(75);
          return this.tsParseEnumDeclaration(node, { const: true });
        }
        if (this.isContextual(126)) {
          return this.tsParseEnumDeclaration(this.startNode());
        }
        if (this.isContextual(129)) {
          const result = this.tsParseInterfaceDeclaration(this.startNode());
          if (result) return result;
        }
        return super.parseStatementContent(flags, decorators);
      }
      parseAccessModifier() {
        return this.tsParseModifier(["public", "protected", "private"]);
      }
      tsHasSomeModifiers(member, modifiers) {
        return modifiers.some((modifier) => {
          if (tsIsAccessModifier(modifier)) {
            return member.accessibility === modifier;
          }
          return !!member[modifier];
        });
      }
      tsIsStartOfStaticBlocks() {
        return this.isContextual(106) && this.lookaheadCharCode() === 123;
      }
      parseClassMember(classBody, member, state) {
        const modifiers = [
          "declare",
          "private",
          "public",
          "protected",
          "override",
          "abstract",
          "readonly",
          "static",
        ];
        this.tsParseModifiers(
          {
            allowedModifiers: modifiers,
            disallowedModifiers: ["in", "out"],
            stopOnStartOfClassStaticBlock: true,
            errorTemplate: TSErrors.InvalidModifierOnTypeParameterPositions,
          },
          member,
        );
        const callParseClassMemberWithIsStatic = () => {
          if (this.tsIsStartOfStaticBlocks()) {
            this.next();
            this.next();
            if (this.tsHasSomeModifiers(member, modifiers)) {
              this.raise(
                TSErrors.StaticBlockCannotHaveModifier,
                this.state.curPosition(),
              );
            }
            super.parseClassStaticBlock(classBody, member);
          } else {
            this.parseClassMemberWithIsStatic(
              classBody,
              member,
              state,
              !!member.static,
            );
          }
        };
        if (member.declare) {
          this.tsInAmbientContext(callParseClassMemberWithIsStatic);
        } else {
          callParseClassMemberWithIsStatic();
        }
      }
      parseClassMemberWithIsStatic(classBody, member, state, isStatic) {
        const idx = this.tsTryParseIndexSignature(member);
        if (idx) {
          classBody.body.push(idx);
          if (member.abstract) {
            this.raise(TSErrors.IndexSignatureHasAbstract, member);
          }
          if (member.accessibility) {
            this.raise(TSErrors.IndexSignatureHasAccessibility, member, {
              modifier: member.accessibility,
            });
          }
          if (member.declare) {
            this.raise(TSErrors.IndexSignatureHasDeclare, member);
          }
          if (member.override) {
            this.raise(TSErrors.IndexSignatureHasOverride, member);
          }
          return;
        }
        if (!this.state.inAbstractClass && member.abstract) {
          this.raise(TSErrors.NonAbstractClassHasAbstractMethod, member);
        }
        if (member.override) {
          if (!state.hadSuperClass) {
            this.raise(TSErrors.OverrideNotInSubClass, member);
          }
        }
        super.parseClassMemberWithIsStatic(classBody, member, state, isStatic);
      }
      parsePostMemberNameModifiers(methodOrProp) {
        const optional = this.eat(17);
        if (optional) methodOrProp.optional = true;
        if (methodOrProp.readonly && this.match(10)) {
          this.raise(TSErrors.ClassMethodHasReadonly, methodOrProp);
        }
        if (methodOrProp.declare && this.match(10)) {
          this.raise(TSErrors.ClassMethodHasDeclare, methodOrProp);
        }
      }
      parseExpressionStatement(node, expr, decorators) {
        const decl =
          expr.type === "Identifier"
            ? this.tsParseExpressionStatement(node, expr, decorators)
            : undefined;
        return decl || super.parseExpressionStatement(node, expr, decorators);
      }
      shouldParseExportDeclaration() {
        if (this.tsIsDeclarationStart()) return true;
        return super.shouldParseExportDeclaration();
      }
      parseConditional(expr, startLoc, refExpressionErrors) {
        if (!this.state.maybeInArrowParameters || !this.match(17)) {
          return super.parseConditional(expr, startLoc, refExpressionErrors);
        }
        const result = this.tryParse(() =>
          super.parseConditional(expr, startLoc),
        );
        if (!result.node) {
          if (result.error) {
            super.setOptionalParametersError(refExpressionErrors, result.error);
          }
          return expr;
        }
        if (result.error) this.state = result.failState;
        return result.node;
      }
      parseParenItem(node, startLoc) {
        node = super.parseParenItem(node, startLoc);
        if (this.eat(17)) {
          node.optional = true;
          this.resetEndLocation(node);
        }
        if (this.match(14)) {
          const typeCastNode = this.startNodeAt(startLoc);
          typeCastNode.expression = node;
          typeCastNode.typeAnnotation = this.tsParseTypeAnnotation();
          return this.finishNode(typeCastNode, "TSTypeCastExpression");
        }
        return node;
      }
      parseExportDeclaration(node) {
        if (!this.state.isAmbientContext && this.isContextual(125)) {
          return this.tsInAmbientContext(() =>
            this.parseExportDeclaration(node),
          );
        }
        const startLoc = this.state.startLoc;
        const isDeclare = this.eatContextual(125);
        if (
          isDeclare &&
          (this.isContextual(125) || !this.shouldParseExportDeclaration())
        ) {
          throw this.raise(
            TSErrors.ExpectedAmbientAfterExportDeclare,
            this.state.startLoc,
          );
        }
        const isIdentifier = tokenIsIdentifier(this.state.type);
        const declaration =
          (isIdentifier && this.tsTryParseExportDeclaration()) ||
          super.parseExportDeclaration(node);
        if (!declaration) return null;
        if (
          declaration.type === "TSInterfaceDeclaration" ||
          declaration.type === "TSTypeAliasDeclaration" ||
          isDeclare
        ) {
          node.exportKind = "type";
        }
        if (isDeclare) {
          this.resetStartLocation(declaration, startLoc);
          declaration.declare = true;
        }
        return declaration;
      }
      parseClassId(node, isStatement, optionalId, bindingType) {
        if ((!isStatement || optionalId) && this.isContextual(113)) {
          return;
        }
        super.parseClassId(
          node,
          isStatement,
          optionalId,
          node.declare ? 1024 : 8331,
        );
        const typeParameters = this.tsTryParseTypeParameters(
          this.tsParseInOutConstModifiers,
        );
        if (typeParameters) node.typeParameters = typeParameters;
      }
      parseClassPropertyAnnotation(node) {
        if (!node.optional) {
          if (this.eat(35)) {
            node.definite = true;
          } else if (this.eat(17)) {
            node.optional = true;
          }
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) node.typeAnnotation = type;
      }
      parseClassProperty(node) {
        this.parseClassPropertyAnnotation(node);
        if (
          this.state.isAmbientContext &&
          !(node.readonly && !node.typeAnnotation) &&
          this.match(29)
        ) {
          this.raise(
            TSErrors.DeclareClassFieldHasInitializer,
            this.state.startLoc,
          );
        }
        if (node.abstract && this.match(29)) {
          const { key: key } = node;
          this.raise(
            TSErrors.AbstractPropertyHasInitializer,
            this.state.startLoc,
            {
              propertyName:
                key.type === "Identifier" && !node.computed
                  ? key.name
                  : `[${this.input.slice(key.start, key.end)}]`,
            },
          );
        }
        return super.parseClassProperty(node);
      }
      parseClassPrivateProperty(node) {
        if (node.abstract) {
          this.raise(TSErrors.PrivateElementHasAbstract, node);
        }
        if (node.accessibility) {
          this.raise(TSErrors.PrivateElementHasAccessibility, node, {
            modifier: node.accessibility,
          });
        }
        this.parseClassPropertyAnnotation(node);
        return super.parseClassPrivateProperty(node);
      }
      parseClassAccessorProperty(node) {
        this.parseClassPropertyAnnotation(node);
        if (node.optional) {
          this.raise(TSErrors.AccessorCannotBeOptional, node);
        }
        return super.parseClassAccessorProperty(node);
      }
      pushClassMethod(
        classBody,
        method,
        isGenerator,
        isAsync,
        isConstructor,
        allowsDirectSuper,
      ) {
        const typeParameters = this.tsTryParseTypeParameters(
          this.tsParseConstModifier,
        );
        if (typeParameters && isConstructor) {
          this.raise(TSErrors.ConstructorHasTypeParameters, typeParameters);
        }
        const { declare: declare = false, kind: kind } = method;
        if (declare && (kind === "get" || kind === "set")) {
          this.raise(TSErrors.DeclareAccessor, method, { kind: kind });
        }
        if (typeParameters) method.typeParameters = typeParameters;
        super.pushClassMethod(
          classBody,
          method,
          isGenerator,
          isAsync,
          isConstructor,
          allowsDirectSuper,
        );
      }
      pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
        const typeParameters = this.tsTryParseTypeParameters(
          this.tsParseConstModifier,
        );
        if (typeParameters) method.typeParameters = typeParameters;
        super.pushClassPrivateMethod(classBody, method, isGenerator, isAsync);
      }
      declareClassPrivateMethodInScope(node, kind) {
        if (node.type === "TSDeclareMethod") return;
        if (node.type === "MethodDefinition" && !node.value.body) return;
        super.declareClassPrivateMethodInScope(node, kind);
      }
      parseClassSuper(node) {
        super.parseClassSuper(node);
        if (node.superClass && (this.match(47) || this.match(51))) {
          node.superTypeParameters = this.tsParseTypeArgumentsInExpression();
        }
        if (this.eatContextual(113)) {
          node.implements = this.tsParseHeritageClause("implements");
        }
      }
      parseObjPropValue(
        prop,
        startLoc,
        isGenerator,
        isAsync,
        isPattern,
        isAccessor,
        refExpressionErrors,
      ) {
        const typeParameters = this.tsTryParseTypeParameters(
          this.tsParseConstModifier,
        );
        if (typeParameters) prop.typeParameters = typeParameters;
        return super.parseObjPropValue(
          prop,
          startLoc,
          isGenerator,
          isAsync,
          isPattern,
          isAccessor,
          refExpressionErrors,
        );
      }
      parseFunctionParams(node, isConstructor) {
        const typeParameters = this.tsTryParseTypeParameters(
          this.tsParseConstModifier,
        );
        if (typeParameters) node.typeParameters = typeParameters;
        super.parseFunctionParams(node, isConstructor);
      }
      parseVarId(decl, kind) {
        super.parseVarId(decl, kind);
        if (
          decl.id.type === "Identifier" &&
          !this.hasPrecedingLineBreak() &&
          this.eat(35)
        ) {
          decl.definite = true;
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) {
          decl.id.typeAnnotation = type;
          this.resetEndLocation(decl.id);
        }
      }
      parseAsyncArrowFromCallExpression(node, call) {
        if (this.match(14)) {
          node.returnType = this.tsParseTypeAnnotation();
        }
        return super.parseAsyncArrowFromCallExpression(node, call);
      }
      parseMaybeAssign(refExpressionErrors, afterLeftParse) {
        var _jsx, _jsx2, _typeCast, _jsx3, _typeCast2;
        let state;
        let jsx;
        let typeCast;
        if (this.hasPlugin("jsx") && (this.match(142) || this.match(47))) {
          state = this.state.clone();
          jsx = this.tryParse(
            () => super.parseMaybeAssign(refExpressionErrors, afterLeftParse),
            state,
          );
          if (!jsx.error) return jsx.node;
          const { context: context } = this.state;
          const currentContext = context[context.length - 1];
          if (
            currentContext === types.j_oTag ||
            currentContext === types.j_expr
          ) {
            context.pop();
          }
        }
        if (!((_jsx = jsx) != null && _jsx.error) && !this.match(47)) {
          return super.parseMaybeAssign(refExpressionErrors, afterLeftParse);
        }
        if (!state || state === this.state) state = this.state.clone();
        let typeParameters;
        const arrow = this.tryParse((abort) => {
          var _expr$extra, _typeParameters;
          typeParameters = this.tsParseTypeParameters(
            this.tsParseConstModifier,
          );
          const expr = super.parseMaybeAssign(
            refExpressionErrors,
            afterLeftParse,
          );
          if (
            expr.type !== "ArrowFunctionExpression" ||
            ((_expr$extra = expr.extra) != null && _expr$extra.parenthesized)
          ) {
            abort();
          }
          if (
            ((_typeParameters = typeParameters) == null
              ? void 0
              : _typeParameters.params.length) !== 0
          ) {
            this.resetStartLocationFromNode(expr, typeParameters);
          }
          expr.typeParameters = typeParameters;
          return expr;
        }, state);
        if (!arrow.error && !arrow.aborted) {
          if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
          return arrow.node;
        }
        if (!jsx) {
          assert(!this.hasPlugin("jsx"));
          typeCast = this.tryParse(
            () => super.parseMaybeAssign(refExpressionErrors, afterLeftParse),
            state,
          );
          if (!typeCast.error) return typeCast.node;
        }
        if ((_jsx2 = jsx) != null && _jsx2.node) {
          this.state = jsx.failState;
          return jsx.node;
        }
        if (arrow.node) {
          this.state = arrow.failState;
          if (typeParameters) this.reportReservedArrowTypeParam(typeParameters);
          return arrow.node;
        }
        if ((_typeCast = typeCast) != null && _typeCast.node) {
          this.state = typeCast.failState;
          return typeCast.node;
        }
        throw (
          ((_jsx3 = jsx) == null ? void 0 : _jsx3.error) ||
          arrow.error ||
          ((_typeCast2 = typeCast) == null ? void 0 : _typeCast2.error)
        );
      }
      reportReservedArrowTypeParam(node) {
        var _node$extra;
        if (
          node.params.length === 1 &&
          !node.params[0].constraint &&
          !((_node$extra = node.extra) != null && _node$extra.trailingComma) &&
          this.getPluginOption("typescript", "disallowAmbiguousJSXLike")
        ) {
          this.raise(TSErrors.ReservedArrowTypeParam, node);
        }
      }
      parseMaybeUnary(refExpressionErrors, sawUnary) {
        if (!this.hasPlugin("jsx") && this.match(47)) {
          return this.tsParseTypeAssertion();
        }
        return super.parseMaybeUnary(refExpressionErrors, sawUnary);
      }
      parseArrow(node) {
        if (this.match(14)) {
          const result = this.tryParse((abort) => {
            const returnType = this.tsParseTypeOrTypePredicateAnnotation(14);
            if (this.canInsertSemicolon() || !this.match(19)) abort();
            return returnType;
          });
          if (result.aborted) return;
          if (!result.thrown) {
            if (result.error) this.state = result.failState;
            node.returnType = result.node;
          }
        }
        return super.parseArrow(node);
      }
      parseAssignableListItemTypes(param, flags) {
        if (!(flags & 2)) return param;
        if (this.eat(17)) {
          param.optional = true;
        }
        const type = this.tsTryParseTypeAnnotation();
        if (type) param.typeAnnotation = type;
        this.resetEndLocation(param);
        return param;
      }
      isAssignable(node, isBinding) {
        switch (node.type) {
          case "TSTypeCastExpression":
            return this.isAssignable(node.expression, isBinding);
          case "TSParameterProperty":
            return true;
          default:
            return super.isAssignable(node, isBinding);
        }
      }
      toAssignable(node, isLHS = false) {
        switch (node.type) {
          case "ParenthesizedExpression":
            this.toAssignableParenthesizedExpression(node, isLHS);
            break;
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSNonNullExpression":
          case "TSTypeAssertion":
            if (isLHS) {
              this.expressionScope.recordArrowParameterBindingError(
                TSErrors.UnexpectedTypeCastInParameter,
                node,
              );
            } else {
              this.raise(TSErrors.UnexpectedTypeCastInParameter, node);
            }
            this.toAssignable(node.expression, isLHS);
            break;
          case "AssignmentExpression":
            if (!isLHS && node.left.type === "TSTypeCastExpression") {
              node.left = this.typeCastToParameter(node.left);
            }
          default:
            super.toAssignable(node, isLHS);
        }
      }
      toAssignableParenthesizedExpression(node, isLHS) {
        switch (node.expression.type) {
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSNonNullExpression":
          case "TSTypeAssertion":
          case "ParenthesizedExpression":
            this.toAssignable(node.expression, isLHS);
            break;
          default:
            super.toAssignable(node, isLHS);
        }
      }
      checkToRestConversion(node, allowPattern) {
        switch (node.type) {
          case "TSAsExpression":
          case "TSSatisfiesExpression":
          case "TSTypeAssertion":
          case "TSNonNullExpression":
            this.checkToRestConversion(node.expression, false);
            break;
          default:
            super.checkToRestConversion(node, allowPattern);
        }
      }
      isValidLVal(type, isUnparenthesizedInAssign, binding) {
        return (
          getOwn(
            {
              TSTypeCastExpression: true,
              TSParameterProperty: "parameter",
              TSNonNullExpression: "expression",
              TSAsExpression: (binding !== 64 ||
                !isUnparenthesizedInAssign) && ["expression", true],
              TSSatisfiesExpression: (binding !== 64 ||
                !isUnparenthesizedInAssign) && ["expression", true],
              TSTypeAssertion: (binding !== 64 ||
                !isUnparenthesizedInAssign) && ["expression", true],
            },
            type,
          ) || super.isValidLVal(type, isUnparenthesizedInAssign, binding)
        );
      }
      parseBindingAtom() {
        if (this.state.type === 78) {
          return this.parseIdentifier(true);
        }
        return super.parseBindingAtom();
      }
      parseMaybeDecoratorArguments(expr) {
        if (this.match(47) || this.match(51)) {
          const typeArguments = this.tsParseTypeArgumentsInExpression();
          if (this.match(10)) {
            const call = super.parseMaybeDecoratorArguments(expr);
            call.typeParameters = typeArguments;
            return call;
          }
          this.unexpected(null, 10);
        }
        return super.parseMaybeDecoratorArguments(expr);
      }
      checkCommaAfterRest(close) {
        if (
          this.state.isAmbientContext &&
          this.match(12) &&
          this.lookaheadCharCode() === close
        ) {
          this.next();
          return false;
        }
        return super.checkCommaAfterRest(close);
      }
      isClassMethod() {
        return this.match(47) || super.isClassMethod();
      }
      isClassProperty() {
        return this.match(35) || this.match(14) || super.isClassProperty();
      }
      parseMaybeDefault(startLoc, left) {
        const node = super.parseMaybeDefault(startLoc, left);
        if (
          node.type === "AssignmentPattern" &&
          node.typeAnnotation &&
          node.right.start < node.typeAnnotation.start
        ) {
          this.raise(TSErrors.TypeAnnotationAfterAssign, node.typeAnnotation);
        }
        return node;
      }
      getTokenFromCode(code) {
        if (this.state.inType) {
          if (code === 62) {
            this.finishOp(48, 1);
            return;
          }
          if (code === 60) {
            this.finishOp(47, 1);
            return;
          }
        }
        super.getTokenFromCode(code);
      }
      reScan_lt_gt() {
        const { type: type } = this.state;
        if (type === 47) {
          this.state.pos -= 1;
          this.readToken_lt();
        } else if (type === 48) {
          this.state.pos -= 1;
          this.readToken_gt();
        }
      }
      reScan_lt() {
        const { type: type } = this.state;
        if (type === 51) {
          this.state.pos -= 2;
          this.finishOp(47, 1);
          return 47;
        }
        return type;
      }
      toAssignableList(exprList, trailingCommaLoc, isLHS) {
        for (let i = 0; i < exprList.length; i++) {
          const expr = exprList[i];
          if ((expr == null ? void 0 : expr.type) === "TSTypeCastExpression") {
            exprList[i] = this.typeCastToParameter(expr);
          }
        }
        super.toAssignableList(exprList, trailingCommaLoc, isLHS);
      }
      typeCastToParameter(node) {
        node.expression.typeAnnotation = node.typeAnnotation;
        this.resetEndLocation(node.expression, node.typeAnnotation.loc.end);
        return node.expression;
      }
      shouldParseArrow(params) {
        if (this.match(14)) {
          return params.every((expr) => this.isAssignable(expr, true));
        }
        return super.shouldParseArrow(params);
      }
      shouldParseAsyncArrow() {
        return this.match(14) || super.shouldParseAsyncArrow();
      }
      canHaveLeadingDecorator() {
        return super.canHaveLeadingDecorator() || this.isAbstractClass();
      }
      jsxParseOpeningElementAfterName(node) {
        if (this.match(47) || this.match(51)) {
          const typeArguments = this.tsTryParseAndCatch(() =>
            this.tsParseTypeArgumentsInExpression(),
          );
          if (typeArguments) node.typeParameters = typeArguments;
        }
        return super.jsxParseOpeningElementAfterName(node);
      }
      getGetterSetterExpectedParamCount(method) {
        const baseCount = super.getGetterSetterExpectedParamCount(method);
        const params = this.getObjectOrClassMethodParams(method);
        const firstParam = params[0];
        const hasContextParam = firstParam && this.isThisParam(firstParam);
        return hasContextParam ? baseCount + 1 : baseCount;
      }
      parseCatchClauseParam() {
        const param = super.parseCatchClauseParam();
        const type = this.tsTryParseTypeAnnotation();
        if (type) {
          param.typeAnnotation = type;
          this.resetEndLocation(param);
        }
        return param;
      }
      tsInAmbientContext(cb) {
        const oldIsAmbientContext = this.state.isAmbientContext;
        this.state.isAmbientContext = true;
        try {
          return cb();
        } finally {
          this.state.isAmbientContext = oldIsAmbientContext;
        }
      }
      parseClass(node, isStatement, optionalId) {
        const oldInAbstractClass = this.state.inAbstractClass;
        this.state.inAbstractClass = !!node.abstract;
        try {
          return super.parseClass(node, isStatement, optionalId);
        } finally {
          this.state.inAbstractClass = oldInAbstractClass;
        }
      }
      tsParseAbstractDeclaration(node, decorators) {
        if (this.match(80)) {
          node.abstract = true;
          return this.maybeTakeDecorators(
            decorators,
            this.parseClass(node, true, false),
          );
        } else if (this.isContextual(129)) {
          if (!this.hasFollowingLineBreak()) {
            node.abstract = true;
            this.raise(TSErrors.NonClassMethodPropertyHasAbstractModifer, node);
            return this.tsParseInterfaceDeclaration(node);
          }
        } else {
          this.unexpected(null, 80);
        }
      }
      parseMethod(
        node,
        isGenerator,
        isAsync,
        isConstructor,
        allowDirectSuper,
        type,
        inClassScope,
      ) {
        const method = super.parseMethod(
          node,
          isGenerator,
          isAsync,
          isConstructor,
          allowDirectSuper,
          type,
          inClassScope,
        );
        if (method.abstract) {
          const hasBody = this.hasPlugin("estree")
            ? !!method.value.body
            : !!method.body;
          if (hasBody) {
            const { key: key } = method;
            this.raise(TSErrors.AbstractMethodHasImplementation, method, {
              methodName:
                key.type === "Identifier" && !method.computed
                  ? key.name
                  : `[${this.input.slice(key.start, key.end)}]`,
            });
          }
        }
        return method;
      }
      tsParseTypeParameterName() {
        const typeName = this.parseIdentifier();
        return typeName.name;
      }
      shouldParseAsAmbientContext() {
        return !!this.getPluginOption("typescript", "dts");
      }
      parse() {
        if (this.shouldParseAsAmbientContext()) {
          this.state.isAmbientContext = true;
        }
        return super.parse();
      }
      getExpression() {
        if (this.shouldParseAsAmbientContext()) {
          this.state.isAmbientContext = true;
        }
        return super.getExpression();
      }
      parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly) {
        if (!isString && isMaybeTypeOnly) {
          this.parseTypeOnlyImportExportSpecifier(node, false, isInTypeExport);
          return this.finishNode(node, "ExportSpecifier");
        }
        node.exportKind = "value";
        return super.parseExportSpecifier(
          node,
          isString,
          isInTypeExport,
          isMaybeTypeOnly,
        );
      }
      parseImportSpecifier(
        specifier,
        importedIsString,
        isInTypeOnlyImport,
        isMaybeTypeOnly,
        bindingType,
      ) {
        if (!importedIsString && isMaybeTypeOnly) {
          this.parseTypeOnlyImportExportSpecifier(
            specifier,
            true,
            isInTypeOnlyImport,
          );
          return this.finishNode(specifier, "ImportSpecifier");
        }
        specifier.importKind = "value";
        return super.parseImportSpecifier(
          specifier,
          importedIsString,
          isInTypeOnlyImport,
          isMaybeTypeOnly,
          isInTypeOnlyImport ? 4098 : 4096,
        );
      }
      parseTypeOnlyImportExportSpecifier(
        node,
        isImport,
        isInTypeOnlyImportExport,
      ) {
        const leftOfAsKey = isImport ? "imported" : "local";
        const rightOfAsKey = isImport ? "local" : "exported";
        let leftOfAs = node[leftOfAsKey];
        let rightOfAs;
        let hasTypeSpecifier = false;
        let canParseAsKeyword = true;
        const loc = leftOfAs.loc.start;
        if (this.isContextual(93)) {
          const firstAs = this.parseIdentifier();
          if (this.isContextual(93)) {
            const secondAs = this.parseIdentifier();
            if (tokenIsKeywordOrIdentifier(this.state.type)) {
              hasTypeSpecifier = true;
              leftOfAs = firstAs;
              rightOfAs = isImport
                ? this.parseIdentifier()
                : this.parseModuleExportName();
              canParseAsKeyword = false;
            } else {
              rightOfAs = secondAs;
              canParseAsKeyword = false;
            }
          } else if (tokenIsKeywordOrIdentifier(this.state.type)) {
            canParseAsKeyword = false;
            rightOfAs = isImport
              ? this.parseIdentifier()
              : this.parseModuleExportName();
          } else {
            hasTypeSpecifier = true;
            leftOfAs = firstAs;
          }
        } else if (tokenIsKeywordOrIdentifier(this.state.type)) {
          hasTypeSpecifier = true;
          if (isImport) {
            leftOfAs = this.parseIdentifier(true);
            if (!this.isContextual(93)) {
              this.checkReservedWord(
                leftOfAs.name,
                leftOfAs.loc.start,
                true,
                true,
              );
            }
          } else {
            leftOfAs = this.parseModuleExportName();
          }
        }
        if (hasTypeSpecifier && isInTypeOnlyImportExport) {
          this.raise(
            isImport
              ? TSErrors.TypeModifierIsUsedInTypeImports
              : TSErrors.TypeModifierIsUsedInTypeExports,
            loc,
          );
        }
        node[leftOfAsKey] = leftOfAs;
        node[rightOfAsKey] = rightOfAs;
        const kindKey = isImport ? "importKind" : "exportKind";
        node[kindKey] = hasTypeSpecifier ? "type" : "value";
        if (canParseAsKeyword && this.eatContextual(93)) {
          node[rightOfAsKey] = isImport
            ? this.parseIdentifier()
            : this.parseModuleExportName();
        }
        if (!node[rightOfAsKey]) {
          node[rightOfAsKey] = cloneIdentifier(node[leftOfAsKey]);
        }
        if (isImport) {
          this.checkIdentifier(
            node[rightOfAsKey],
            hasTypeSpecifier ? 4098 : 4096,
          );
        }
      }
    };
  function isPossiblyLiteralEnum(expression) {
    if (expression.type !== "MemberExpression") return false;
    const { computed: computed, property: property } = expression;
    if (
      computed &&
      property.type !== "StringLiteral" &&
      (property.type !== "TemplateLiteral" || property.expressions.length > 0)
    ) {
      return false;
    }
    return isUncomputedMemberExpressionChain(expression.object);
  }
  function isValidAmbientConstInitializer(expression, estree) {
    var _expression$extra;
    const { type: type } = expression;
    if (
      (_expression$extra = expression.extra) != null &&
      _expression$extra.parenthesized
    ) {
      return false;
    }
    if (estree) {
      if (type === "Literal") {
        const { value: value } = expression;
        if (typeof value === "string" || typeof value === "boolean") {
          return true;
        }
      }
    } else {
      if (type === "StringLiteral" || type === "BooleanLiteral") {
        return true;
      }
    }
    if (isNumber(expression, estree) || isNegativeNumber(expression, estree)) {
      return true;
    }
    if (type === "TemplateLiteral" && expression.expressions.length === 0) {
      return true;
    }
    if (isPossiblyLiteralEnum(expression)) {
      return true;
    }
    return false;
  }
  function isNumber(expression, estree) {
    if (estree) {
      return (
        expression.type === "Literal" &&
        (typeof expression.value === "number" || "bigint" in expression)
      );
    }
    return (
      expression.type === "NumericLiteral" ||
      expression.type === "BigIntLiteral"
    );
  }
  function isNegativeNumber(expression, estree) {
    if (expression.type === "UnaryExpression") {
      const { operator: operator, argument: argument } = expression;
      if (operator === "-" && isNumber(argument, estree)) {
        return true;
      }
    }
    return false;
  }
  function isUncomputedMemberExpressionChain(expression) {
    if (expression.type === "Identifier") return true;
    if (expression.type !== "MemberExpression" || expression.computed) {
      return false;
    }
    return isUncomputedMemberExpressionChain(expression.object);
  }
  const PlaceholderErrors = ParseErrorEnum`placeholders`({
    ClassNameIsRequired: "A class name is required.",
    UnexpectedSpace: "Unexpected space in placeholder.",
  });
  var placeholders = (superClass) =>
    class PlaceholdersParserMixin extends superClass {
      parsePlaceholder(expectedNode) {
        if (this.match(144)) {
          const node = this.startNode();
          this.next();
          this.assertNoSpace();
          node.name = super.parseIdentifier(true);
          this.assertNoSpace();
          this.expect(144);
          return this.finishPlaceholder(node, expectedNode);
        }
      }
      finishPlaceholder(node, expectedNode) {
        const isFinished = !!(node.expectedNode && node.type === "Placeholder");
        node.expectedNode = expectedNode;
        return isFinished ? node : this.finishNode(node, "Placeholder");
      }
      getTokenFromCode(code) {
        if (code === 37 && this.input.charCodeAt(this.state.pos + 1) === 37) {
          this.finishOp(144, 2);
        } else {
          super.getTokenFromCode(code);
        }
      }
      parseExprAtom(refExpressionErrors) {
        return (
          this.parsePlaceholder("Expression") ||
          super.parseExprAtom(refExpressionErrors)
        );
      }
      parseIdentifier(liberal) {
        return (
          this.parsePlaceholder("Identifier") || super.parseIdentifier(liberal)
        );
      }
      checkReservedWord(word, startLoc, checkKeywords, isBinding) {
        if (word !== undefined) {
          super.checkReservedWord(word, startLoc, checkKeywords, isBinding);
        }
      }
      parseBindingAtom() {
        return this.parsePlaceholder("Pattern") || super.parseBindingAtom();
      }
      isValidLVal(type, isParenthesized, binding) {
        return (
          type === "Placeholder" ||
          super.isValidLVal(type, isParenthesized, binding)
        );
      }
      toAssignable(node, isLHS) {
        if (
          node &&
          node.type === "Placeholder" &&
          node.expectedNode === "Expression"
        ) {
          node.expectedNode = "Pattern";
        } else {
          super.toAssignable(node, isLHS);
        }
      }
      chStartsBindingIdentifier(ch, pos) {
        if (super.chStartsBindingIdentifier(ch, pos)) {
          return true;
        }
        const nextToken = this.lookahead();
        if (nextToken.type === 144) {
          return true;
        }
        return false;
      }
      verifyBreakContinue(node, isBreak) {
        if (node.label && node.label.type === "Placeholder") return;
        super.verifyBreakContinue(node, isBreak);
      }
      parseExpressionStatement(node, expr) {
        var _expr$extra;
        if (
          expr.type !== "Placeholder" ||
          ((_expr$extra = expr.extra) != null && _expr$extra.parenthesized)
        ) {
          return super.parseExpressionStatement(node, expr);
        }
        if (this.match(14)) {
          const stmt = node;
          stmt.label = this.finishPlaceholder(expr, "Identifier");
          this.next();
          stmt.body = super.parseStatementOrSloppyAnnexBFunctionDeclaration();
          return this.finishNode(stmt, "LabeledStatement");
        }
        this.semicolon();
        node.name = expr.name;
        return this.finishPlaceholder(node, "Statement");
      }
      parseBlock(allowDirectives, createNewLexicalScope, afterBlockParse) {
        return (
          this.parsePlaceholder("BlockStatement") ||
          super.parseBlock(
            allowDirectives,
            createNewLexicalScope,
            afterBlockParse,
          )
        );
      }
      parseFunctionId(requireId) {
        return (
          this.parsePlaceholder("Identifier") ||
          super.parseFunctionId(requireId)
        );
      }
      parseClass(node, isStatement, optionalId) {
        const type = isStatement ? "ClassDeclaration" : "ClassExpression";
        this.next();
        const oldStrict = this.state.strict;
        const placeholder = this.parsePlaceholder("Identifier");
        if (placeholder) {
          if (this.match(81) || this.match(144) || this.match(5)) {
            node.id = placeholder;
          } else if (optionalId || !isStatement) {
            node.id = null;
            node.body = this.finishPlaceholder(placeholder, "ClassBody");
            return this.finishNode(node, type);
          } else {
            throw this.raise(
              PlaceholderErrors.ClassNameIsRequired,
              this.state.startLoc,
            );
          }
        } else {
          this.parseClassId(node, isStatement, optionalId);
        }
        super.parseClassSuper(node);
        node.body =
          this.parsePlaceholder("ClassBody") ||
          super.parseClassBody(!!node.superClass, oldStrict);
        return this.finishNode(node, type);
      }
      parseExport(node, decorators) {
        const placeholder = this.parsePlaceholder("Identifier");
        if (!placeholder) return super.parseExport(node, decorators);
        if (!this.isContextual(98) && !this.match(12)) {
          node.specifiers = [];
          node.source = null;
          node.declaration = this.finishPlaceholder(placeholder, "Declaration");
          return this.finishNode(node, "ExportNamedDeclaration");
        }
        this.expectPlugin("exportDefaultFrom");
        const specifier = this.startNode();
        specifier.exported = placeholder;
        node.specifiers = [
          this.finishNode(specifier, "ExportDefaultSpecifier"),
        ];
        return super.parseExport(node, decorators);
      }
      isExportDefaultSpecifier() {
        if (this.match(65)) {
          const next = this.nextTokenStart();
          if (this.isUnparsedContextual(next, "from")) {
            if (
              this.input.startsWith(
                tokenLabelName(144),
                this.nextTokenStartSince(next + 4),
              )
            ) {
              return true;
            }
          }
        }
        return super.isExportDefaultSpecifier();
      }
      maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
        var _specifiers;
        if ((_specifiers = node.specifiers) != null && _specifiers.length) {
          return true;
        }
        return super.maybeParseExportDefaultSpecifier(
          node,
          maybeDefaultIdentifier,
        );
      }
      checkExport(node) {
        const { specifiers: specifiers } = node;
        if (specifiers != null && specifiers.length) {
          node.specifiers = specifiers.filter(
            (node) => node.exported.type === "Placeholder",
          );
        }
        super.checkExport(node);
        node.specifiers = specifiers;
      }
      parseImport(node) {
        const placeholder = this.parsePlaceholder("Identifier");
        if (!placeholder) return super.parseImport(node);
        node.specifiers = [];
        if (!this.isContextual(98) && !this.match(12)) {
          node.source = this.finishPlaceholder(placeholder, "StringLiteral");
          this.semicolon();
          return this.finishNode(node, "ImportDeclaration");
        }
        const specifier = this.startNodeAtNode(placeholder);
        specifier.local = placeholder;
        node.specifiers.push(
          this.finishNode(specifier, "ImportDefaultSpecifier"),
        );
        if (this.eat(12)) {
          const hasStarImport = this.maybeParseStarImportSpecifier(node);
          if (!hasStarImport) this.parseNamedImportSpecifiers(node);
        }
        this.expectContextual(98);
        node.source = this.parseImportSource();
        this.semicolon();
        return this.finishNode(node, "ImportDeclaration");
      }
      parseImportSource() {
        return (
          this.parsePlaceholder("StringLiteral") || super.parseImportSource()
        );
      }
      assertNoSpace() {
        if (this.state.start > this.state.lastTokEndLoc.index) {
          this.raise(
            PlaceholderErrors.UnexpectedSpace,
            this.state.lastTokEndLoc,
          );
        }
      }
    };
  var v8intrinsic = (superClass) =>
    class V8IntrinsicMixin extends superClass {
      parseV8Intrinsic() {
        if (this.match(54)) {
          const v8IntrinsicStartLoc = this.state.startLoc;
          const node = this.startNode();
          this.next();
          if (tokenIsIdentifier(this.state.type)) {
            const name = this.parseIdentifierName();
            const identifier = this.createIdentifier(node, name);
            identifier.type = "V8IntrinsicIdentifier";
            if (this.match(10)) {
              return identifier;
            }
          }
          this.unexpected(v8IntrinsicStartLoc);
        }
      }
      parseExprAtom(refExpressionErrors) {
        return (
          this.parseV8Intrinsic() || super.parseExprAtom(refExpressionErrors)
        );
      }
    };
  function hasPlugin(plugins, expectedConfig) {
    const [expectedName, expectedOptions] =
      typeof expectedConfig === "string"
        ? [expectedConfig, {}]
        : expectedConfig;
    const expectedKeys = Object.keys(expectedOptions);
    const expectedOptionsIsEmpty = expectedKeys.length === 0;
    return plugins.some((p) => {
      if (typeof p === "string") {
        return expectedOptionsIsEmpty && p === expectedName;
      } else {
        const [pluginName, pluginOptions] = p;
        if (pluginName !== expectedName) {
          return false;
        }
        for (const key of expectedKeys) {
          if (pluginOptions[key] !== expectedOptions[key]) {
            return false;
          }
        }
        return true;
      }
    });
  }
  function getPluginOption(plugins, name, option) {
    const plugin = plugins.find((plugin) => {
      if (Array.isArray(plugin)) {
        return plugin[0] === name;
      } else {
        return plugin === name;
      }
    });
    if (plugin && Array.isArray(plugin) && plugin.length > 1) {
      return plugin[1][option];
    }
    return null;
  }
  const PIPELINE_PROPOSALS = ["minimal", "fsharp", "hack", "smart"];
  const TOPIC_TOKENS = ["^^", "@@", "^", "%", "#"];
  const RECORD_AND_TUPLE_SYNTAX_TYPES = ["hash", "bar"];
  function validatePlugins(plugins) {
    if (hasPlugin(plugins, "decorators")) {
      if (hasPlugin(plugins, "decorators-legacy")) {
        throw new Error(
          "Cannot use the decorators and decorators-legacy plugin together",
        );
      }
      const decoratorsBeforeExport = getPluginOption(
        plugins,
        "decorators",
        "decoratorsBeforeExport",
      );
      if (
        decoratorsBeforeExport != null &&
        typeof decoratorsBeforeExport !== "boolean"
      ) {
        throw new Error(
          "'decoratorsBeforeExport' must be a boolean, if specified.",
        );
      }
      const allowCallParenthesized = getPluginOption(
        plugins,
        "decorators",
        "allowCallParenthesized",
      );
      if (
        allowCallParenthesized != null &&
        typeof allowCallParenthesized !== "boolean"
      ) {
        throw new Error("'allowCallParenthesized' must be a boolean.");
      }
    }
    if (hasPlugin(plugins, "flow") && hasPlugin(plugins, "typescript")) {
      throw new Error("Cannot combine flow and typescript plugins.");
    }
    if (
      hasPlugin(plugins, "placeholders") &&
      hasPlugin(plugins, "v8intrinsic")
    ) {
      throw new Error("Cannot combine placeholders and v8intrinsic plugins.");
    }
    if (hasPlugin(plugins, "pipelineOperator")) {
      const proposal = getPluginOption(plugins, "pipelineOperator", "proposal");
      if (!PIPELINE_PROPOSALS.includes(proposal)) {
        const proposalList = PIPELINE_PROPOSALS.map((p) => `"${p}"`).join(", ");
        throw new Error(
          `"pipelineOperator" requires "proposal" option whose value must be one of: ${proposalList}.`,
        );
      }
      const tupleSyntaxIsHash = hasPlugin(plugins, [
        "recordAndTuple",
        { syntaxType: "hash" },
      ]);
      if (proposal === "hack") {
        if (hasPlugin(plugins, "placeholders")) {
          throw new Error(
            "Cannot combine placeholders plugin and Hack-style pipes.",
          );
        }
        if (hasPlugin(plugins, "v8intrinsic")) {
          throw new Error(
            "Cannot combine v8intrinsic plugin and Hack-style pipes.",
          );
        }
        const topicToken = getPluginOption(
          plugins,
          "pipelineOperator",
          "topicToken",
        );
        if (!TOPIC_TOKENS.includes(topicToken)) {
          const tokenList = TOPIC_TOKENS.map((t) => `"${t}"`).join(", ");
          throw new Error(
            `"pipelineOperator" in "proposal": "hack" mode also requires a "topicToken" option whose value must be one of: ${tokenList}.`,
          );
        }
        if (topicToken === "#" && tupleSyntaxIsHash) {
          throw new Error(
            'Plugin conflict between `["pipelineOperator", { proposal: "hack", topicToken: "#" }]` and `["recordAndtuple", { syntaxType: "hash"}]`.',
          );
        }
      } else if (proposal === "smart" && tupleSyntaxIsHash) {
        throw new Error(
          'Plugin conflict between `["pipelineOperator", { proposal: "smart" }]` and `["recordAndtuple", { syntaxType: "hash"}]`.',
        );
      }
    }
    if (hasPlugin(plugins, "moduleAttributes")) {
      {
        if (
          hasPlugin(plugins, "importAssertions") ||
          hasPlugin(plugins, "importAttributes")
        ) {
          throw new Error(
            "Cannot combine importAssertions, importAttributes and moduleAttributes plugins.",
          );
        }
        const moduleAttributesVersionPluginOption = getPluginOption(
          plugins,
          "moduleAttributes",
          "version",
        );
        if (moduleAttributesVersionPluginOption !== "may-2020") {
          throw new Error(
            "The 'moduleAttributes' plugin requires a 'version' option," +
              " representing the last proposal update. Currently, the" +
              " only supported value is 'may-2020'.",
          );
        }
      }
    }
    if (
      hasPlugin(plugins, "importAssertions") &&
      hasPlugin(plugins, "importAttributes")
    ) {
      throw new Error(
        "Cannot combine importAssertions and importAttributes plugins.",
      );
    }
    if (
      hasPlugin(plugins, "recordAndTuple") &&
      getPluginOption(plugins, "recordAndTuple", "syntaxType") != null &&
      !RECORD_AND_TUPLE_SYNTAX_TYPES.includes(
        getPluginOption(plugins, "recordAndTuple", "syntaxType"),
      )
    ) {
      throw new Error(
        "The 'syntaxType' option of the 'recordAndTuple' plugin must be one of: " +
          RECORD_AND_TUPLE_SYNTAX_TYPES.map((p) => `'${p}'`).join(", "),
      );
    }
    if (
      hasPlugin(plugins, "asyncDoExpressions") &&
      !hasPlugin(plugins, "doExpressions")
    ) {
      const error = new Error(
        "'asyncDoExpressions' requires 'doExpressions', please add 'doExpressions' to parser plugins.",
      );
      error.missingPlugins = "doExpressions";
      throw error;
    }
    if (
      hasPlugin(plugins, "optionalChainingAssign") &&
      getPluginOption(plugins, "optionalChainingAssign", "version") !==
        "2023-07"
    ) {
      throw new Error(
        "The 'optionalChainingAssign' plugin requires a 'version' option," +
          " representing the last proposal update. Currently, the" +
          " only supported value is '2023-07'.",
      );
    }
  }
  const mixinPlugins = {
    estree: estree,
    jsx: jsx,
    flow: flow,
    typescript: typescript,
    v8intrinsic: v8intrinsic,
    placeholders: placeholders,
  };
  const mixinPluginNames = Object.keys(mixinPlugins);
  const defaultOptions = {
    sourceType: "script",
    sourceFilename: undefined,
    startColumn: 0,
    startLine: 1,
    allowAwaitOutsideFunction: false,
    allowReturnOutsideFunction: false,
    allowNewTargetOutsideFunction: false,
    allowImportExportEverywhere: false,
    allowSuperOutsideMethod: false,
    allowUndeclaredExports: false,
    plugins: [],
    strictMode: null,
    ranges: false,
    tokens: false,
    createImportExpressions: false,
    createParenthesizedExpressions: false,
    errorRecovery: false,
    attachComment: true,
    annexB: true,
  };
  function getOptions(opts) {
    if (opts == null) {
      return Object.assign({}, defaultOptions);
    }
    if (opts.annexB != null && opts.annexB !== false) {
      throw new Error("The `annexB` option can only be set to `false`.");
    }
    const options = {};
    for (const key of Object.keys(defaultOptions)) {
      var _opts$key;
      options[key] =
        (_opts$key = opts[key]) != null ? _opts$key : defaultOptions[key];
    }
    return options;
  }
  class ExpressionParser extends LValParser {
    checkProto(prop, isRecord, protoRef, refExpressionErrors) {
      if (
        prop.type === "SpreadElement" ||
        this.isObjectMethod(prop) ||
        prop.computed ||
        prop.shorthand
      ) {
        return;
      }
      const key = prop.key;
      const name = key.type === "Identifier" ? key.name : key.value;
      if (name === "__proto__") {
        if (isRecord) {
          this.raise(Errors.RecordNoProto, key);
          return;
        }
        if (protoRef.used) {
          if (refExpressionErrors) {
            if (refExpressionErrors.doubleProtoLoc === null) {
              refExpressionErrors.doubleProtoLoc = key.loc.start;
            }
          } else {
            this.raise(Errors.DuplicateProto, key);
          }
        }
        protoRef.used = true;
      }
    }
    shouldExitDescending(expr, potentialArrowAt) {
      return (
        expr.type === "ArrowFunctionExpression" &&
        expr.start === potentialArrowAt
      );
    }
    getExpression() {
      this.enterInitialScopes();
      this.nextToken();
      const expr = this.parseExpression();
      if (!this.match(139)) {
        this.unexpected();
      }
      this.finalizeRemainingComments();
      expr.comments = this.comments;
      expr.errors = this.state.errors;
      if (this.options.tokens) {
        expr.tokens = this.tokens;
      }
      return expr;
    }
    parseExpression(disallowIn, refExpressionErrors) {
      if (disallowIn) {
        return this.disallowInAnd(() =>
          this.parseExpressionBase(refExpressionErrors),
        );
      }
      return this.allowInAnd(() =>
        this.parseExpressionBase(refExpressionErrors),
      );
    }
    parseExpressionBase(refExpressionErrors) {
      const startLoc = this.state.startLoc;
      const expr = this.parseMaybeAssign(refExpressionErrors);
      if (this.match(12)) {
        const node = this.startNodeAt(startLoc);
        node.expressions = [expr];
        while (this.eat(12)) {
          node.expressions.push(this.parseMaybeAssign(refExpressionErrors));
        }
        this.toReferencedList(node.expressions);
        return this.finishNode(node, "SequenceExpression");
      }
      return expr;
    }
    parseMaybeAssignDisallowIn(refExpressionErrors, afterLeftParse) {
      return this.disallowInAnd(() =>
        this.parseMaybeAssign(refExpressionErrors, afterLeftParse),
      );
    }
    parseMaybeAssignAllowIn(refExpressionErrors, afterLeftParse) {
      return this.allowInAnd(() =>
        this.parseMaybeAssign(refExpressionErrors, afterLeftParse),
      );
    }
    setOptionalParametersError(refExpressionErrors, resultError) {
      var _resultError$loc;
      refExpressionErrors.optionalParametersLoc =
        (_resultError$loc = resultError == null ? void 0 : resultError.loc) !=
        null
          ? _resultError$loc
          : this.state.startLoc;
    }
    parseMaybeAssign(refExpressionErrors, afterLeftParse) {
      const startLoc = this.state.startLoc;
      if (this.isContextual(108)) {
        if (this.prodParam.hasYield) {
          let left = this.parseYield();
          if (afterLeftParse) {
            left = afterLeftParse.call(this, left, startLoc);
          }
          return left;
        }
      }
      let ownExpressionErrors;
      if (refExpressionErrors) {
        ownExpressionErrors = false;
      } else {
        refExpressionErrors = new ExpressionErrors();
        ownExpressionErrors = true;
      }
      const { type: type } = this.state;
      if (type === 10 || tokenIsIdentifier(type)) {
        this.state.potentialArrowAt = this.state.start;
      }
      let left = this.parseMaybeConditional(refExpressionErrors);
      if (afterLeftParse) {
        left = afterLeftParse.call(this, left, startLoc);
      }
      if (tokenIsAssignment(this.state.type)) {
        const node = this.startNodeAt(startLoc);
        const operator = this.state.value;
        node.operator = operator;
        if (this.match(29)) {
          this.toAssignable(left, true);
          node.left = left;
          const startIndex = startLoc.index;
          if (
            refExpressionErrors.doubleProtoLoc != null &&
            refExpressionErrors.doubleProtoLoc.index >= startIndex
          ) {
            refExpressionErrors.doubleProtoLoc = null;
          }
          if (
            refExpressionErrors.shorthandAssignLoc != null &&
            refExpressionErrors.shorthandAssignLoc.index >= startIndex
          ) {
            refExpressionErrors.shorthandAssignLoc = null;
          }
          if (
            refExpressionErrors.privateKeyLoc != null &&
            refExpressionErrors.privateKeyLoc.index >= startIndex
          ) {
            this.checkDestructuringPrivate(refExpressionErrors);
            refExpressionErrors.privateKeyLoc = null;
          }
        } else {
          node.left = left;
        }
        this.next();
        node.right = this.parseMaybeAssign();
        this.checkLVal(left, {
          in: this.finishNode(node, "AssignmentExpression"),
        });
        return node;
      } else if (ownExpressionErrors) {
        this.checkExpressionErrors(refExpressionErrors, true);
      }
      return left;
    }
    parseMaybeConditional(refExpressionErrors) {
      const startLoc = this.state.startLoc;
      const potentialArrowAt = this.state.potentialArrowAt;
      const expr = this.parseExprOps(refExpressionErrors);
      if (this.shouldExitDescending(expr, potentialArrowAt)) {
        return expr;
      }
      return this.parseConditional(expr, startLoc, refExpressionErrors);
    }
    parseConditional(expr, startLoc, refExpressionErrors) {
      if (this.eat(17)) {
        const node = this.startNodeAt(startLoc);
        node.test = expr;
        node.consequent = this.parseMaybeAssignAllowIn();
        this.expect(14);
        node.alternate = this.parseMaybeAssign();
        return this.finishNode(node, "ConditionalExpression");
      }
      return expr;
    }
    parseMaybeUnaryOrPrivate(refExpressionErrors) {
      return this.match(138)
        ? this.parsePrivateName()
        : this.parseMaybeUnary(refExpressionErrors);
    }
    parseExprOps(refExpressionErrors) {
      const startLoc = this.state.startLoc;
      const potentialArrowAt = this.state.potentialArrowAt;
      const expr = this.parseMaybeUnaryOrPrivate(refExpressionErrors);
      if (this.shouldExitDescending(expr, potentialArrowAt)) {
        return expr;
      }
      return this.parseExprOp(expr, startLoc, -1);
    }
    parseExprOp(left, leftStartLoc, minPrec) {
      if (this.isPrivateName(left)) {
        const value = this.getPrivateNameSV(left);
        if (
          minPrec >= tokenOperatorPrecedence(58) ||
          !this.prodParam.hasIn ||
          !this.match(58)
        ) {
          this.raise(Errors.PrivateInExpectedIn, left, {
            identifierName: value,
          });
        }
        this.classScope.usePrivateName(value, left.loc.start);
      }
      const op = this.state.type;
      if (tokenIsOperator(op) && (this.prodParam.hasIn || !this.match(58))) {
        let prec = tokenOperatorPrecedence(op);
        if (prec > minPrec) {
          if (op === 39) {
            this.expectPlugin("pipelineOperator");
            if (this.state.inFSharpPipelineDirectBody) {
              return left;
            }
            this.checkPipelineAtInfixOperator(left, leftStartLoc);
          }
          const node = this.startNodeAt(leftStartLoc);
          node.left = left;
          node.operator = this.state.value;
          const logical = op === 41 || op === 42;
          const coalesce = op === 40;
          if (coalesce) {
            prec = tokenOperatorPrecedence(42);
          }
          this.next();
          if (
            op === 39 &&
            this.hasPlugin(["pipelineOperator", { proposal: "minimal" }])
          ) {
            if (this.state.type === 96 && this.prodParam.hasAwait) {
              throw this.raise(
                Errors.UnexpectedAwaitAfterPipelineBody,
                this.state.startLoc,
              );
            }
          }
          node.right = this.parseExprOpRightExpr(op, prec);
          const finishedNode = this.finishNode(
            node,
            logical || coalesce ? "LogicalExpression" : "BinaryExpression",
          );
          const nextOp = this.state.type;
          if (
            (coalesce && (nextOp === 41 || nextOp === 42)) ||
            (logical && nextOp === 40)
          ) {
            throw this.raise(
              Errors.MixingCoalesceWithLogical,
              this.state.startLoc,
            );
          }
          return this.parseExprOp(finishedNode, leftStartLoc, minPrec);
        }
      }
      return left;
    }
    parseExprOpRightExpr(op, prec) {
      const startLoc = this.state.startLoc;
      switch (op) {
        case 39:
          switch (this.getPluginOption("pipelineOperator", "proposal")) {
            case "hack":
              return this.withTopicBindingContext(() =>
                this.parseHackPipeBody(),
              );
            case "smart":
              return this.withTopicBindingContext(() => {
                if (this.prodParam.hasYield && this.isContextual(108)) {
                  throw this.raise(
                    Errors.PipeBodyIsTighter,
                    this.state.startLoc,
                  );
                }
                return this.parseSmartPipelineBodyInStyle(
                  this.parseExprOpBaseRightExpr(op, prec),
                  startLoc,
                );
              });
            case "fsharp":
              return this.withSoloAwaitPermittingContext(() =>
                this.parseFSharpPipelineBody(prec),
              );
          }
        default:
          return this.parseExprOpBaseRightExpr(op, prec);
      }
    }
    parseExprOpBaseRightExpr(op, prec) {
      const startLoc = this.state.startLoc;
      return this.parseExprOp(
        this.parseMaybeUnaryOrPrivate(),
        startLoc,
        tokenIsRightAssociative(op) ? prec - 1 : prec,
      );
    }
    parseHackPipeBody() {
      var _body$extra;
      const { startLoc: startLoc } = this.state;
      const body = this.parseMaybeAssign();
      const requiredParentheses = UnparenthesizedPipeBodyDescriptions.has(
        body.type,
      );
      if (
        requiredParentheses &&
        !((_body$extra = body.extra) != null && _body$extra.parenthesized)
      ) {
        this.raise(Errors.PipeUnparenthesizedBody, startLoc, {
          type: body.type,
        });
      }
      if (!this.topicReferenceWasUsedInCurrentContext()) {
        this.raise(Errors.PipeTopicUnused, startLoc);
      }
      return body;
    }
    checkExponentialAfterUnary(node) {
      if (this.match(57)) {
        this.raise(Errors.UnexpectedTokenUnaryExponentiation, node.argument);
      }
    }
    parseMaybeUnary(refExpressionErrors, sawUnary) {
      const startLoc = this.state.startLoc;
      const isAwait = this.isContextual(96);
      if (isAwait && this.isAwaitAllowed()) {
        this.next();
        const expr = this.parseAwait(startLoc);
        if (!sawUnary) this.checkExponentialAfterUnary(expr);
        return expr;
      }
      const update = this.match(34);
      const node = this.startNode();
      if (tokenIsPrefix(this.state.type)) {
        node.operator = this.state.value;
        node.prefix = true;
        if (this.match(72)) {
          this.expectPlugin("throwExpressions");
        }
        const isDelete = this.match(89);
        this.next();
        node.argument = this.parseMaybeUnary(null, true);
        this.checkExpressionErrors(refExpressionErrors, true);
        if (this.state.strict && isDelete) {
          const arg = node.argument;
          if (arg.type === "Identifier") {
            this.raise(Errors.StrictDelete, node);
          } else if (this.hasPropertyAsPrivateName(arg)) {
            this.raise(Errors.DeletePrivateField, node);
          }
        }
        if (!update) {
          if (!sawUnary) {
            this.checkExponentialAfterUnary(node);
          }
          return this.finishNode(node, "UnaryExpression");
        }
      }
      const expr = this.parseUpdate(node, update, refExpressionErrors);
      if (isAwait) {
        const { type: type } = this.state;
        const startsExpr = this.hasPlugin("v8intrinsic")
          ? tokenCanStartExpression(type)
          : tokenCanStartExpression(type) && !this.match(54);
        if (startsExpr && !this.isAmbiguousAwait()) {
          this.raiseOverwrite(Errors.AwaitNotInAsyncContext, startLoc);
          return this.parseAwait(startLoc);
        }
      }
      return expr;
    }
    parseUpdate(node, update, refExpressionErrors) {
      if (update) {
        const updateExpressionNode = node;
        this.checkLVal(updateExpressionNode.argument, {
          in: this.finishNode(updateExpressionNode, "UpdateExpression"),
        });
        return node;
      }
      const startLoc = this.state.startLoc;
      let expr = this.parseExprSubscripts(refExpressionErrors);
      if (this.checkExpressionErrors(refExpressionErrors, false)) return expr;
      while (tokenIsPostfix(this.state.type) && !this.canInsertSemicolon()) {
        const node = this.startNodeAt(startLoc);
        node.operator = this.state.value;
        node.prefix = false;
        node.argument = expr;
        this.next();
        this.checkLVal(expr, {
          in: (expr = this.finishNode(node, "UpdateExpression")),
        });
      }
      return expr;
    }
    parseExprSubscripts(refExpressionErrors) {
      const startLoc = this.state.startLoc;
      const potentialArrowAt = this.state.potentialArrowAt;
      const expr = this.parseExprAtom(refExpressionErrors);
      if (this.shouldExitDescending(expr, potentialArrowAt)) {
        return expr;
      }
      return this.parseSubscripts(expr, startLoc);
    }
    parseSubscripts(base, startLoc, noCalls) {
      const state = {
        optionalChainMember: false,
        maybeAsyncArrow: this.atPossibleAsyncArrow(base),
        stop: false,
      };
      do {
        base = this.parseSubscript(base, startLoc, noCalls, state);
        state.maybeAsyncArrow = false;
      } while (!state.stop);
      return base;
    }
    parseSubscript(base, startLoc, noCalls, state) {
      const { type: type } = this.state;
      if (!noCalls && type === 15) {
        return this.parseBind(base, startLoc, noCalls, state);
      } else if (tokenIsTemplate(type)) {
        return this.parseTaggedTemplateExpression(base, startLoc, state);
      }
      let optional = false;
      if (type === 18) {
        if (noCalls) {
          this.raise(Errors.OptionalChainingNoNew, this.state.startLoc);
          if (this.lookaheadCharCode() === 40) {
            state.stop = true;
            return base;
          }
        }
        state.optionalChainMember = optional = true;
        this.next();
      }
      if (!noCalls && this.match(10)) {
        return this.parseCoverCallAndAsyncArrowHead(
          base,
          startLoc,
          state,
          optional,
        );
      } else {
        const computed = this.eat(0);
        if (computed || optional || this.eat(16)) {
          return this.parseMember(base, startLoc, state, computed, optional);
        } else {
          state.stop = true;
          return base;
        }
      }
    }
    parseMember(base, startLoc, state, computed, optional) {
      const node = this.startNodeAt(startLoc);
      node.object = base;
      node.computed = computed;
      if (computed) {
        node.property = this.parseExpression();
        this.expect(3);
      } else if (this.match(138)) {
        if (base.type === "Super") {
          this.raise(Errors.SuperPrivateField, startLoc);
        }
        this.classScope.usePrivateName(this.state.value, this.state.startLoc);
        node.property = this.parsePrivateName();
      } else {
        node.property = this.parseIdentifier(true);
      }
      if (state.optionalChainMember) {
        node.optional = optional;
        return this.finishNode(node, "OptionalMemberExpression");
      } else {
        return this.finishNode(node, "MemberExpression");
      }
    }
    parseBind(base, startLoc, noCalls, state) {
      const node = this.startNodeAt(startLoc);
      node.object = base;
      this.next();
      node.callee = this.parseNoCallExpr();
      state.stop = true;
      return this.parseSubscripts(
        this.finishNode(node, "BindExpression"),
        startLoc,
        noCalls,
      );
    }
    parseCoverCallAndAsyncArrowHead(base, startLoc, state, optional) {
      const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
      let refExpressionErrors = null;
      this.state.maybeInArrowParameters = true;
      this.next();
      const node = this.startNodeAt(startLoc);
      node.callee = base;
      const {
        maybeAsyncArrow: maybeAsyncArrow,
        optionalChainMember: optionalChainMember,
      } = state;
      if (maybeAsyncArrow) {
        this.expressionScope.enter(newAsyncArrowScope());
        refExpressionErrors = new ExpressionErrors();
      }
      if (optionalChainMember) {
        node.optional = optional;
      }
      if (optional) {
        node.arguments = this.parseCallExpressionArguments(11);
      } else {
        node.arguments = this.parseCallExpressionArguments(
          11,
          base.type === "Import",
          base.type !== "Super",
          node,
          refExpressionErrors,
        );
      }
      let finishedNode = this.finishCallExpression(node, optionalChainMember);
      if (maybeAsyncArrow && this.shouldParseAsyncArrow() && !optional) {
        state.stop = true;
        this.checkDestructuringPrivate(refExpressionErrors);
        this.expressionScope.validateAsPattern();
        this.expressionScope.exit();
        finishedNode = this.parseAsyncArrowFromCallExpression(
          this.startNodeAt(startLoc),
          finishedNode,
        );
      } else {
        if (maybeAsyncArrow) {
          this.checkExpressionErrors(refExpressionErrors, true);
          this.expressionScope.exit();
        }
        this.toReferencedArguments(finishedNode);
      }
      this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
      return finishedNode;
    }
    toReferencedArguments(node, isParenthesizedExpr) {
      this.toReferencedListDeep(node.arguments, isParenthesizedExpr);
    }
    parseTaggedTemplateExpression(base, startLoc, state) {
      const node = this.startNodeAt(startLoc);
      node.tag = base;
      node.quasi = this.parseTemplate(true);
      if (state.optionalChainMember) {
        this.raise(Errors.OptionalChainingNoTemplate, startLoc);
      }
      return this.finishNode(node, "TaggedTemplateExpression");
    }
    atPossibleAsyncArrow(base) {
      return (
        base.type === "Identifier" &&
        base.name === "async" &&
        this.state.lastTokEndLoc.index === base.end &&
        !this.canInsertSemicolon() &&
        base.end - base.start === 5 &&
        base.start === this.state.potentialArrowAt
      );
    }
    expectImportAttributesPlugin() {
      if (!this.hasPlugin("importAssertions")) {
        this.expectPlugin("importAttributes");
      }
    }
    finishCallExpression(node, optional) {
      if (node.callee.type === "Import") {
        if (node.arguments.length === 2) {
          {
            if (!this.hasPlugin("moduleAttributes")) {
              this.expectImportAttributesPlugin();
            }
          }
        }
        if (node.arguments.length === 0 || node.arguments.length > 2) {
          this.raise(Errors.ImportCallArity, node, {
            maxArgumentCount:
              this.hasPlugin("importAttributes") ||
              this.hasPlugin("importAssertions") ||
              this.hasPlugin("moduleAttributes")
                ? 2
                : 1,
          });
        } else {
          for (const arg of node.arguments) {
            if (arg.type === "SpreadElement") {
              this.raise(Errors.ImportCallSpreadArgument, arg);
            }
          }
        }
      }
      return this.finishNode(
        node,
        optional ? "OptionalCallExpression" : "CallExpression",
      );
    }
    parseCallExpressionArguments(
      close,
      dynamicImport,
      allowPlaceholder,
      nodeForExtra,
      refExpressionErrors,
    ) {
      const elts = [];
      let first = true;
      const oldInFSharpPipelineDirectBody =
        this.state.inFSharpPipelineDirectBody;
      this.state.inFSharpPipelineDirectBody = false;
      while (!this.eat(close)) {
        if (first) {
          first = false;
        } else {
          this.expect(12);
          if (this.match(close)) {
            if (
              dynamicImport &&
              !this.hasPlugin("importAttributes") &&
              !this.hasPlugin("importAssertions") &&
              !this.hasPlugin("moduleAttributes")
            ) {
              this.raise(
                Errors.ImportCallArgumentTrailingComma,
                this.state.lastTokStartLoc,
              );
            }
            if (nodeForExtra) {
              this.addTrailingCommaExtraToNode(nodeForExtra);
            }
            this.next();
            break;
          }
        }
        elts.push(
          this.parseExprListItem(false, refExpressionErrors, allowPlaceholder),
        );
      }
      this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
      return elts;
    }
    shouldParseAsyncArrow() {
      return this.match(19) && !this.canInsertSemicolon();
    }
    parseAsyncArrowFromCallExpression(node, call) {
      var _call$extra;
      this.resetPreviousNodeTrailingComments(call);
      this.expect(19);
      this.parseArrowExpression(
        node,
        call.arguments,
        true,
        (_call$extra = call.extra) == null
          ? void 0
          : _call$extra.trailingCommaLoc,
      );
      if (call.innerComments) {
        setInnerComments(node, call.innerComments);
      }
      if (call.callee.trailingComments) {
        setInnerComments(node, call.callee.trailingComments);
      }
      return node;
    }
    parseNoCallExpr() {
      const startLoc = this.state.startLoc;
      return this.parseSubscripts(this.parseExprAtom(), startLoc, true);
    }
    parseExprAtom(refExpressionErrors) {
      let node;
      let decorators = null;
      const { type: type } = this.state;
      switch (type) {
        case 79:
          return this.parseSuper();
        case 83:
          node = this.startNode();
          this.next();
          if (this.match(16)) {
            return this.parseImportMetaProperty(node);
          }
          if (this.match(10)) {
            if (this.options.createImportExpressions) {
              return this.parseImportCall(node);
            } else {
              return this.finishNode(node, "Import");
            }
          } else {
            this.raise(Errors.UnsupportedImport, this.state.lastTokStartLoc);
            return this.finishNode(node, "Import");
          }
        case 78:
          node = this.startNode();
          this.next();
          return this.finishNode(node, "ThisExpression");
        case 90: {
          return this.parseDo(this.startNode(), false);
        }
        case 56:
        case 31: {
          this.readRegexp();
          return this.parseRegExpLiteral(this.state.value);
        }
        case 134:
          return this.parseNumericLiteral(this.state.value);
        case 135:
          return this.parseBigIntLiteral(this.state.value);
        case 136:
          return this.parseDecimalLiteral(this.state.value);
        case 133:
          return this.parseStringLiteral(this.state.value);
        case 84:
          return this.parseNullLiteral();
        case 85:
          return this.parseBooleanLiteral(true);
        case 86:
          return this.parseBooleanLiteral(false);
        case 10: {
          const canBeArrow = this.state.potentialArrowAt === this.state.start;
          return this.parseParenAndDistinguishExpression(canBeArrow);
        }
        case 2:
        case 1: {
          return this.parseArrayLike(
            this.state.type === 2 ? 4 : 3,
            false,
            true,
          );
        }
        case 0: {
          return this.parseArrayLike(3, true, false, refExpressionErrors);
        }
        case 6:
        case 7: {
          return this.parseObjectLike(
            this.state.type === 6 ? 9 : 8,
            false,
            true,
          );
        }
        case 5: {
          return this.parseObjectLike(8, false, false, refExpressionErrors);
        }
        case 68:
          return this.parseFunctionOrFunctionSent();
        case 26:
          decorators = this.parseDecorators();
        case 80:
          return this.parseClass(
            this.maybeTakeDecorators(decorators, this.startNode()),
            false,
          );
        case 77:
          return this.parseNewOrNewTarget();
        case 25:
        case 24:
          return this.parseTemplate(false);
        case 15: {
          node = this.startNode();
          this.next();
          node.object = null;
          const callee = (node.callee = this.parseNoCallExpr());
          if (callee.type === "MemberExpression") {
            return this.finishNode(node, "BindExpression");
          } else {
            throw this.raise(Errors.UnsupportedBind, callee);
          }
        }
        case 138: {
          this.raise(Errors.PrivateInExpectedIn, this.state.startLoc, {
            identifierName: this.state.value,
          });
          return this.parsePrivateName();
        }
        case 33: {
          return this.parseTopicReferenceThenEqualsSign(54, "%");
        }
        case 32: {
          return this.parseTopicReferenceThenEqualsSign(44, "^");
        }
        case 37:
        case 38: {
          return this.parseTopicReference("hack");
        }
        case 44:
        case 54:
        case 27: {
          const pipeProposal = this.getPluginOption(
            "pipelineOperator",
            "proposal",
          );
          if (pipeProposal) {
            return this.parseTopicReference(pipeProposal);
          }
          this.unexpected();
          break;
        }
        case 47: {
          const lookaheadCh = this.input.codePointAt(this.nextTokenStart());
          if (isIdentifierStart(lookaheadCh) || lookaheadCh === 62) {
            this.expectOnePlugin(["jsx", "flow", "typescript"]);
          } else {
            this.unexpected();
          }
          break;
        }
        default:
          if (tokenIsIdentifier(type)) {
            if (
              this.isContextual(127) &&
              this.lookaheadInLineCharCode() === 123
            ) {
              return this.parseModuleExpression();
            }
            const canBeArrow = this.state.potentialArrowAt === this.state.start;
            const containsEsc = this.state.containsEsc;
            const id = this.parseIdentifier();
            if (
              !containsEsc &&
              id.name === "async" &&
              !this.canInsertSemicolon()
            ) {
              const { type: type } = this.state;
              if (type === 68) {
                this.resetPreviousNodeTrailingComments(id);
                this.next();
                return this.parseAsyncFunctionExpression(
                  this.startNodeAtNode(id),
                );
              } else if (tokenIsIdentifier(type)) {
                if (this.lookaheadCharCode() === 61) {
                  return this.parseAsyncArrowUnaryFunction(
                    this.startNodeAtNode(id),
                  );
                } else {
                  return id;
                }
              } else if (type === 90) {
                this.resetPreviousNodeTrailingComments(id);
                return this.parseDo(this.startNodeAtNode(id), true);
              }
            }
            if (canBeArrow && this.match(19) && !this.canInsertSemicolon()) {
              this.next();
              return this.parseArrowExpression(
                this.startNodeAtNode(id),
                [id],
                false,
              );
            }
            return id;
          } else {
            this.unexpected();
          }
      }
    }
    parseTopicReferenceThenEqualsSign(topicTokenType, topicTokenValue) {
      const pipeProposal = this.getPluginOption("pipelineOperator", "proposal");
      if (pipeProposal) {
        this.state.type = topicTokenType;
        this.state.value = topicTokenValue;
        this.state.pos--;
        this.state.end--;
        this.state.endLoc = createPositionWithColumnOffset(
          this.state.endLoc,
          -1,
        );
        return this.parseTopicReference(pipeProposal);
      } else {
        this.unexpected();
      }
    }
    parseTopicReference(pipeProposal) {
      const node = this.startNode();
      const startLoc = this.state.startLoc;
      const tokenType = this.state.type;
      this.next();
      return this.finishTopicReference(node, startLoc, pipeProposal, tokenType);
    }
    finishTopicReference(node, startLoc, pipeProposal, tokenType) {
      if (
        this.testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType)
      ) {
        const nodeType =
          pipeProposal === "smart"
            ? "PipelinePrimaryTopicReference"
            : "TopicReference";
        if (!this.topicReferenceIsAllowedInCurrentContext()) {
          this.raise(
            pipeProposal === "smart"
              ? Errors.PrimaryTopicNotAllowed
              : Errors.PipeTopicUnbound,
            startLoc,
          );
        }
        this.registerTopicReference();
        return this.finishNode(node, nodeType);
      } else {
        throw this.raise(Errors.PipeTopicUnconfiguredToken, startLoc, {
          token: tokenLabelName(tokenType),
        });
      }
    }
    testTopicReferenceConfiguration(pipeProposal, startLoc, tokenType) {
      switch (pipeProposal) {
        case "hack": {
          return this.hasPlugin([
            "pipelineOperator",
            { topicToken: tokenLabelName(tokenType) },
          ]);
        }
        case "smart":
          return tokenType === 27;
        default:
          throw this.raise(Errors.PipeTopicRequiresHackPipes, startLoc);
      }
    }
    parseAsyncArrowUnaryFunction(node) {
      this.prodParam.enter(functionFlags(true, this.prodParam.hasYield));
      const params = [this.parseIdentifier()];
      this.prodParam.exit();
      if (this.hasPrecedingLineBreak()) {
        this.raise(Errors.LineTerminatorBeforeArrow, this.state.curPosition());
      }
      this.expect(19);
      return this.parseArrowExpression(node, params, true);
    }
    parseDo(node, isAsync) {
      this.expectPlugin("doExpressions");
      if (isAsync) {
        this.expectPlugin("asyncDoExpressions");
      }
      node.async = isAsync;
      this.next();
      const oldLabels = this.state.labels;
      this.state.labels = [];
      if (isAsync) {
        this.prodParam.enter(2);
        node.body = this.parseBlock();
        this.prodParam.exit();
      } else {
        node.body = this.parseBlock();
      }
      this.state.labels = oldLabels;
      return this.finishNode(node, "DoExpression");
    }
    parseSuper() {
      const node = this.startNode();
      this.next();
      if (
        this.match(10) &&
        !this.scope.allowDirectSuper &&
        !this.options.allowSuperOutsideMethod
      ) {
        this.raise(Errors.SuperNotAllowed, node);
      } else if (
        !this.scope.allowSuper &&
        !this.options.allowSuperOutsideMethod
      ) {
        this.raise(Errors.UnexpectedSuper, node);
      }
      if (!this.match(10) && !this.match(0) && !this.match(16)) {
        this.raise(Errors.UnsupportedSuper, node);
      }
      return this.finishNode(node, "Super");
    }
    parsePrivateName() {
      const node = this.startNode();
      const id = this.startNodeAt(
        createPositionWithColumnOffset(this.state.startLoc, 1),
      );
      const name = this.state.value;
      this.next();
      node.id = this.createIdentifier(id, name);
      return this.finishNode(node, "PrivateName");
    }
    parseFunctionOrFunctionSent() {
      const node = this.startNode();
      this.next();
      if (this.prodParam.hasYield && this.match(16)) {
        const meta = this.createIdentifier(
          this.startNodeAtNode(node),
          "function",
        );
        this.next();
        if (this.match(103)) {
          this.expectPlugin("functionSent");
        } else if (!this.hasPlugin("functionSent")) {
          this.unexpected();
        }
        return this.parseMetaProperty(node, meta, "sent");
      }
      return this.parseFunction(node);
    }
    parseMetaProperty(node, meta, propertyName) {
      node.meta = meta;
      const containsEsc = this.state.containsEsc;
      node.property = this.parseIdentifier(true);
      if (node.property.name !== propertyName || containsEsc) {
        this.raise(Errors.UnsupportedMetaProperty, node.property, {
          target: meta.name,
          onlyValidPropertyName: propertyName,
        });
      }
      return this.finishNode(node, "MetaProperty");
    }
    parseImportMetaProperty(node) {
      const id = this.createIdentifier(this.startNodeAtNode(node), "import");
      this.next();
      if (this.isContextual(101)) {
        if (!this.inModule) {
          this.raise(Errors.ImportMetaOutsideModule, id);
        }
        this.sawUnambiguousESM = true;
      } else if (this.isContextual(105) || this.isContextual(97)) {
        const isSource = this.isContextual(105);
        if (!isSource) this.unexpected();
        this.expectPlugin(
          isSource ? "sourcePhaseImports" : "deferredImportEvaluation",
        );
        if (!this.options.createImportExpressions) {
          throw this.raise(
            Errors.DynamicImportPhaseRequiresImportExpressions,
            this.state.startLoc,
            { phase: this.state.value },
          );
        }
        this.next();
        node.phase = isSource ? "source" : "defer";
        return this.parseImportCall(node);
      }
      return this.parseMetaProperty(node, id, "meta");
    }
    parseLiteralAtNode(value, type, node) {
      this.addExtra(node, "rawValue", value);
      this.addExtra(node, "raw", this.input.slice(node.start, this.state.end));
      node.value = value;
      this.next();
      return this.finishNode(node, type);
    }
    parseLiteral(value, type) {
      const node = this.startNode();
      return this.parseLiteralAtNode(value, type, node);
    }
    parseStringLiteral(value) {
      return this.parseLiteral(value, "StringLiteral");
    }
    parseNumericLiteral(value) {
      return this.parseLiteral(value, "NumericLiteral");
    }
    parseBigIntLiteral(value) {
      return this.parseLiteral(value, "BigIntLiteral");
    }
    parseDecimalLiteral(value) {
      return this.parseLiteral(value, "DecimalLiteral");
    }
    parseRegExpLiteral(value) {
      const node = this.parseLiteral(value.value, "RegExpLiteral");
      node.pattern = value.pattern;
      node.flags = value.flags;
      return node;
    }
    parseBooleanLiteral(value) {
      const node = this.startNode();
      node.value = value;
      this.next();
      return this.finishNode(node, "BooleanLiteral");
    }
    parseNullLiteral() {
      const node = this.startNode();
      this.next();
      return this.finishNode(node, "NullLiteral");
    }
    parseParenAndDistinguishExpression(canBeArrow) {
      const startLoc = this.state.startLoc;
      let val;
      this.next();
      this.expressionScope.enter(newArrowHeadScope());
      const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
      const oldInFSharpPipelineDirectBody =
        this.state.inFSharpPipelineDirectBody;
      this.state.maybeInArrowParameters = true;
      this.state.inFSharpPipelineDirectBody = false;
      const innerStartLoc = this.state.startLoc;
      const exprList = [];
      const refExpressionErrors = new ExpressionErrors();
      let first = true;
      let spreadStartLoc;
      let optionalCommaStartLoc;
      while (!this.match(11)) {
        if (first) {
          first = false;
        } else {
          this.expect(
            12,
            refExpressionErrors.optionalParametersLoc === null
              ? null
              : refExpressionErrors.optionalParametersLoc,
          );
          if (this.match(11)) {
            optionalCommaStartLoc = this.state.startLoc;
            break;
          }
        }
        if (this.match(21)) {
          const spreadNodeStartLoc = this.state.startLoc;
          spreadStartLoc = this.state.startLoc;
          exprList.push(
            this.parseParenItem(this.parseRestBinding(), spreadNodeStartLoc),
          );
          if (!this.checkCommaAfterRest(41)) {
            break;
          }
        } else {
          exprList.push(
            this.parseMaybeAssignAllowIn(
              refExpressionErrors,
              this.parseParenItem,
            ),
          );
        }
      }
      const innerEndLoc = this.state.lastTokEndLoc;
      this.expect(11);
      this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
      this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
      let arrowNode = this.startNodeAt(startLoc);
      if (
        canBeArrow &&
        this.shouldParseArrow(exprList) &&
        (arrowNode = this.parseArrow(arrowNode))
      ) {
        this.checkDestructuringPrivate(refExpressionErrors);
        this.expressionScope.validateAsPattern();
        this.expressionScope.exit();
        this.parseArrowExpression(arrowNode, exprList, false);
        return arrowNode;
      }
      this.expressionScope.exit();
      if (!exprList.length) {
        this.unexpected(this.state.lastTokStartLoc);
      }
      if (optionalCommaStartLoc) this.unexpected(optionalCommaStartLoc);
      if (spreadStartLoc) this.unexpected(spreadStartLoc);
      this.checkExpressionErrors(refExpressionErrors, true);
      this.toReferencedListDeep(exprList, true);
      if (exprList.length > 1) {
        val = this.startNodeAt(innerStartLoc);
        val.expressions = exprList;
        this.finishNode(val, "SequenceExpression");
        this.resetEndLocation(val, innerEndLoc);
      } else {
        val = exprList[0];
      }
      return this.wrapParenthesis(startLoc, val);
    }
    wrapParenthesis(startLoc, expression) {
      if (!this.options.createParenthesizedExpressions) {
        this.addExtra(expression, "parenthesized", true);
        this.addExtra(expression, "parenStart", startLoc.index);
        this.takeSurroundingComments(
          expression,
          startLoc.index,
          this.state.lastTokEndLoc.index,
        );
        return expression;
      }
      const parenExpression = this.startNodeAt(startLoc);
      parenExpression.expression = expression;
      return this.finishNode(parenExpression, "ParenthesizedExpression");
    }
    shouldParseArrow(params) {
      return !this.canInsertSemicolon();
    }
    parseArrow(node) {
      if (this.eat(19)) {
        return node;
      }
    }
    parseParenItem(node, startLoc) {
      return node;
    }
    parseNewOrNewTarget() {
      const node = this.startNode();
      this.next();
      if (this.match(16)) {
        const meta = this.createIdentifier(this.startNodeAtNode(node), "new");
        this.next();
        const metaProp = this.parseMetaProperty(node, meta, "target");
        if (
          !this.scope.inNonArrowFunction &&
          !this.scope.inClass &&
          !this.options.allowNewTargetOutsideFunction
        ) {
          this.raise(Errors.UnexpectedNewTarget, metaProp);
        }
        return metaProp;
      }
      return this.parseNew(node);
    }
    parseNew(node) {
      this.parseNewCallee(node);
      if (this.eat(10)) {
        const args = this.parseExprList(11);
        this.toReferencedList(args);
        node.arguments = args;
      } else {
        node.arguments = [];
      }
      return this.finishNode(node, "NewExpression");
    }
    parseNewCallee(node) {
      const isImport = this.match(83);
      const callee = this.parseNoCallExpr();
      node.callee = callee;
      if (
        isImport &&
        (callee.type === "Import" || callee.type === "ImportExpression")
      ) {
        this.raise(Errors.ImportCallNotNewExpression, callee);
      }
    }
    parseTemplateElement(isTagged) {
      const {
        start: start,
        startLoc: startLoc,
        end: end,
        value: value,
      } = this.state;
      const elemStart = start + 1;
      const elem = this.startNodeAt(
        createPositionWithColumnOffset(startLoc, 1),
      );
      if (value === null) {
        if (!isTagged) {
          this.raise(
            Errors.InvalidEscapeSequenceTemplate,
            createPositionWithColumnOffset(
              this.state.firstInvalidTemplateEscapePos,
              1,
            ),
          );
        }
      }
      const isTail = this.match(24);
      const endOffset = isTail ? -1 : -2;
      const elemEnd = end + endOffset;
      elem.value = {
        raw: this.input.slice(elemStart, elemEnd).replace(/\r\n?/g, "\n"),
        cooked: value === null ? null : value.slice(1, endOffset),
      };
      elem.tail = isTail;
      this.next();
      const finishedNode = this.finishNode(elem, "TemplateElement");
      this.resetEndLocation(
        finishedNode,
        createPositionWithColumnOffset(this.state.lastTokEndLoc, endOffset),
      );
      return finishedNode;
    }
    parseTemplate(isTagged) {
      const node = this.startNode();
      node.expressions = [];
      let curElt = this.parseTemplateElement(isTagged);
      node.quasis = [curElt];
      while (!curElt.tail) {
        node.expressions.push(this.parseTemplateSubstitution());
        this.readTemplateContinuation();
        node.quasis.push((curElt = this.parseTemplateElement(isTagged)));
      }
      return this.finishNode(node, "TemplateLiteral");
    }
    parseTemplateSubstitution() {
      return this.parseExpression();
    }
    parseObjectLike(close, isPattern, isRecord, refExpressionErrors) {
      if (isRecord) {
        this.expectPlugin("recordAndTuple");
      }
      const oldInFSharpPipelineDirectBody =
        this.state.inFSharpPipelineDirectBody;
      this.state.inFSharpPipelineDirectBody = false;
      const propHash = Object.create(null);
      let first = true;
      const node = this.startNode();
      node.properties = [];
      this.next();
      while (!this.match(close)) {
        if (first) {
          first = false;
        } else {
          this.expect(12);
          if (this.match(close)) {
            this.addTrailingCommaExtraToNode(node);
            break;
          }
        }
        let prop;
        if (isPattern) {
          prop = this.parseBindingProperty();
        } else {
          prop = this.parsePropertyDefinition(refExpressionErrors);
          this.checkProto(prop, isRecord, propHash, refExpressionErrors);
        }
        if (
          isRecord &&
          !this.isObjectProperty(prop) &&
          prop.type !== "SpreadElement"
        ) {
          this.raise(Errors.InvalidRecordProperty, prop);
        }
        if (prop.shorthand) {
          this.addExtra(prop, "shorthand", true);
        }
        node.properties.push(prop);
      }
      this.next();
      this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
      let type = "ObjectExpression";
      if (isPattern) {
        type = "ObjectPattern";
      } else if (isRecord) {
        type = "RecordExpression";
      }
      return this.finishNode(node, type);
    }
    addTrailingCommaExtraToNode(node) {
      this.addExtra(node, "trailingComma", this.state.lastTokStartLoc.index);
      this.addExtra(
        node,
        "trailingCommaLoc",
        this.state.lastTokStartLoc,
        false,
      );
    }
    maybeAsyncOrAccessorProp(prop) {
      return (
        !prop.computed &&
        prop.key.type === "Identifier" &&
        (this.isLiteralPropertyName() || this.match(0) || this.match(55))
      );
    }
    parsePropertyDefinition(refExpressionErrors) {
      let decorators = [];
      if (this.match(26)) {
        if (this.hasPlugin("decorators")) {
          this.raise(Errors.UnsupportedPropertyDecorator, this.state.startLoc);
        }
        while (this.match(26)) {
          decorators.push(this.parseDecorator());
        }
      }
      const prop = this.startNode();
      let isAsync = false;
      let isAccessor = false;
      let startLoc;
      if (this.match(21)) {
        if (decorators.length) this.unexpected();
        return this.parseSpread();
      }
      if (decorators.length) {
        prop.decorators = decorators;
        decorators = [];
      }
      prop.method = false;
      if (refExpressionErrors) {
        startLoc = this.state.startLoc;
      }
      let isGenerator = this.eat(55);
      this.parsePropertyNamePrefixOperator(prop);
      const containsEsc = this.state.containsEsc;
      const key = this.parsePropertyName(prop, refExpressionErrors);
      if (!isGenerator && !containsEsc && this.maybeAsyncOrAccessorProp(prop)) {
        const keyName = key.name;
        if (keyName === "async" && !this.hasPrecedingLineBreak()) {
          isAsync = true;
          this.resetPreviousNodeTrailingComments(key);
          isGenerator = this.eat(55);
          this.parsePropertyName(prop);
        }
        if (keyName === "get" || keyName === "set") {
          isAccessor = true;
          this.resetPreviousNodeTrailingComments(key);
          prop.kind = keyName;
          if (this.match(55)) {
            isGenerator = true;
            this.raise(Errors.AccessorIsGenerator, this.state.curPosition(), {
              kind: keyName,
            });
            this.next();
          }
          this.parsePropertyName(prop);
        }
      }
      return this.parseObjPropValue(
        prop,
        startLoc,
        isGenerator,
        isAsync,
        false,
        isAccessor,
        refExpressionErrors,
      );
    }
    getGetterSetterExpectedParamCount(method) {
      return method.kind === "get" ? 0 : 1;
    }
    getObjectOrClassMethodParams(method) {
      return method.params;
    }
    checkGetterSetterParams(method) {
      var _params;
      const paramCount = this.getGetterSetterExpectedParamCount(method);
      const params = this.getObjectOrClassMethodParams(method);
      if (params.length !== paramCount) {
        this.raise(
          method.kind === "get" ? Errors.BadGetterArity : Errors.BadSetterArity,
          method,
        );
      }
      if (
        method.kind === "set" &&
        ((_params = params[params.length - 1]) == null
          ? void 0
          : _params.type) === "RestElement"
      ) {
        this.raise(Errors.BadSetterRestParameter, method);
      }
    }
    parseObjectMethod(prop, isGenerator, isAsync, isPattern, isAccessor) {
      if (isAccessor) {
        const finishedProp = this.parseMethod(
          prop,
          isGenerator,
          false,
          false,
          false,
          "ObjectMethod",
        );
        this.checkGetterSetterParams(finishedProp);
        return finishedProp;
      }
      if (isAsync || isGenerator || this.match(10)) {
        if (isPattern) this.unexpected();
        prop.kind = "method";
        prop.method = true;
        return this.parseMethod(
          prop,
          isGenerator,
          isAsync,
          false,
          false,
          "ObjectMethod",
        );
      }
    }
    parseObjectProperty(prop, startLoc, isPattern, refExpressionErrors) {
      prop.shorthand = false;
      if (this.eat(14)) {
        prop.value = isPattern
          ? this.parseMaybeDefault(this.state.startLoc)
          : this.parseMaybeAssignAllowIn(refExpressionErrors);
        return this.finishNode(prop, "ObjectProperty");
      }
      if (!prop.computed && prop.key.type === "Identifier") {
        this.checkReservedWord(prop.key.name, prop.key.loc.start, true, false);
        if (isPattern) {
          prop.value = this.parseMaybeDefault(
            startLoc,
            cloneIdentifier(prop.key),
          );
        } else if (this.match(29)) {
          const shorthandAssignLoc = this.state.startLoc;
          if (refExpressionErrors != null) {
            if (refExpressionErrors.shorthandAssignLoc === null) {
              refExpressionErrors.shorthandAssignLoc = shorthandAssignLoc;
            }
          } else {
            this.raise(Errors.InvalidCoverInitializedName, shorthandAssignLoc);
          }
          prop.value = this.parseMaybeDefault(
            startLoc,
            cloneIdentifier(prop.key),
          );
        } else {
          prop.value = cloneIdentifier(prop.key);
        }
        prop.shorthand = true;
        return this.finishNode(prop, "ObjectProperty");
      }
    }
    parseObjPropValue(
      prop,
      startLoc,
      isGenerator,
      isAsync,
      isPattern,
      isAccessor,
      refExpressionErrors,
    ) {
      const node =
        this.parseObjectMethod(
          prop,
          isGenerator,
          isAsync,
          isPattern,
          isAccessor,
        ) ||
        this.parseObjectProperty(
          prop,
          startLoc,
          isPattern,
          refExpressionErrors,
        );
      if (!node) this.unexpected();
      return node;
    }
    parsePropertyName(prop, refExpressionErrors) {
      if (this.eat(0)) {
        prop.computed = true;
        prop.key = this.parseMaybeAssignAllowIn();
        this.expect(3);
      } else {
        const { type: type, value: value } = this.state;
        let key;
        if (tokenIsKeywordOrIdentifier(type)) {
          key = this.parseIdentifier(true);
        } else {
          switch (type) {
            case 134:
              key = this.parseNumericLiteral(value);
              break;
            case 133:
              key = this.parseStringLiteral(value);
              break;
            case 135:
              key = this.parseBigIntLiteral(value);
              break;
            case 136:
              key = this.parseDecimalLiteral(value);
              break;
            case 138: {
              const privateKeyLoc = this.state.startLoc;
              if (refExpressionErrors != null) {
                if (refExpressionErrors.privateKeyLoc === null) {
                  refExpressionErrors.privateKeyLoc = privateKeyLoc;
                }
              } else {
                this.raise(Errors.UnexpectedPrivateField, privateKeyLoc);
              }
              key = this.parsePrivateName();
              break;
            }
            default:
              this.unexpected();
          }
        }
        prop.key = key;
        if (type !== 138) {
          prop.computed = false;
        }
      }
      return prop.key;
    }
    initFunction(node, isAsync) {
      node.id = null;
      node.generator = false;
      node.async = isAsync;
    }
    parseMethod(
      node,
      isGenerator,
      isAsync,
      isConstructor,
      allowDirectSuper,
      type,
      inClassScope = false,
    ) {
      this.initFunction(node, isAsync);
      node.generator = isGenerator;
      this.scope.enter(
        2 | 16 | (inClassScope ? 64 : 0) | (allowDirectSuper ? 32 : 0),
      );
      this.prodParam.enter(functionFlags(isAsync, node.generator));
      this.parseFunctionParams(node, isConstructor);
      const finishedNode = this.parseFunctionBodyAndFinish(node, type, true);
      this.prodParam.exit();
      this.scope.exit();
      return finishedNode;
    }
    parseArrayLike(close, canBePattern, isTuple, refExpressionErrors) {
      if (isTuple) {
        this.expectPlugin("recordAndTuple");
      }
      const oldInFSharpPipelineDirectBody =
        this.state.inFSharpPipelineDirectBody;
      this.state.inFSharpPipelineDirectBody = false;
      const node = this.startNode();
      this.next();
      node.elements = this.parseExprList(
        close,
        !isTuple,
        refExpressionErrors,
        node,
      );
      this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
      return this.finishNode(
        node,
        isTuple ? "TupleExpression" : "ArrayExpression",
      );
    }
    parseArrowExpression(node, params, isAsync, trailingCommaLoc) {
      this.scope.enter(2 | 4);
      let flags = functionFlags(isAsync, false);
      if (!this.match(5) && this.prodParam.hasIn) {
        flags |= 8;
      }
      this.prodParam.enter(flags);
      this.initFunction(node, isAsync);
      const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
      if (params) {
        this.state.maybeInArrowParameters = true;
        this.setArrowFunctionParameters(node, params, trailingCommaLoc);
      }
      this.state.maybeInArrowParameters = false;
      this.parseFunctionBody(node, true);
      this.prodParam.exit();
      this.scope.exit();
      this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
      return this.finishNode(node, "ArrowFunctionExpression");
    }
    setArrowFunctionParameters(node, params, trailingCommaLoc) {
      this.toAssignableList(params, trailingCommaLoc, false);
      node.params = params;
    }
    parseFunctionBodyAndFinish(node, type, isMethod = false) {
      this.parseFunctionBody(node, false, isMethod);
      return this.finishNode(node, type);
    }
    parseFunctionBody(node, allowExpression, isMethod = false) {
      const isExpression = allowExpression && !this.match(5);
      this.expressionScope.enter(newExpressionScope());
      if (isExpression) {
        node.body = this.parseMaybeAssign();
        this.checkParams(node, false, allowExpression, false);
      } else {
        const oldStrict = this.state.strict;
        const oldLabels = this.state.labels;
        this.state.labels = [];
        this.prodParam.enter(this.prodParam.currentFlags() | 4);
        node.body = this.parseBlock(true, false, (hasStrictModeDirective) => {
          const nonSimple = !this.isSimpleParamList(node.params);
          if (hasStrictModeDirective && nonSimple) {
            this.raise(
              Errors.IllegalLanguageModeDirective,
              (node.kind === "method" || node.kind === "constructor") &&
                !!node.key
                ? node.key.loc.end
                : node,
            );
          }
          const strictModeChanged = !oldStrict && this.state.strict;
          this.checkParams(
            node,
            !this.state.strict && !allowExpression && !isMethod && !nonSimple,
            allowExpression,
            strictModeChanged,
          );
          if (this.state.strict && node.id) {
            this.checkIdentifier(node.id, 65, strictModeChanged);
          }
        });
        this.prodParam.exit();
        this.state.labels = oldLabels;
      }
      this.expressionScope.exit();
    }
    isSimpleParameter(node) {
      return node.type === "Identifier";
    }
    isSimpleParamList(params) {
      for (let i = 0, len = params.length; i < len; i++) {
        if (!this.isSimpleParameter(params[i])) return false;
      }
      return true;
    }
    checkParams(
      node,
      allowDuplicates,
      isArrowFunction,
      strictModeChanged = true,
    ) {
      const checkClashes = !allowDuplicates && new Set();
      const formalParameters = { type: "FormalParameters" };
      for (const param of node.params) {
        this.checkLVal(param, {
          in: formalParameters,
          binding: 5,
          checkClashes: checkClashes,
          strictModeChanged: strictModeChanged,
        });
      }
    }
    parseExprList(close, allowEmpty, refExpressionErrors, nodeForExtra) {
      const elts = [];
      let first = true;
      while (!this.eat(close)) {
        if (first) {
          first = false;
        } else {
          this.expect(12);
          if (this.match(close)) {
            if (nodeForExtra) {
              this.addTrailingCommaExtraToNode(nodeForExtra);
            }
            this.next();
            break;
          }
        }
        elts.push(this.parseExprListItem(allowEmpty, refExpressionErrors));
      }
      return elts;
    }
    parseExprListItem(allowEmpty, refExpressionErrors, allowPlaceholder) {
      let elt;
      if (this.match(12)) {
        if (!allowEmpty) {
          this.raise(Errors.UnexpectedToken, this.state.curPosition(), {
            unexpected: ",",
          });
        }
        elt = null;
      } else if (this.match(21)) {
        const spreadNodeStartLoc = this.state.startLoc;
        elt = this.parseParenItem(
          this.parseSpread(refExpressionErrors),
          spreadNodeStartLoc,
        );
      } else if (this.match(17)) {
        this.expectPlugin("partialApplication");
        if (!allowPlaceholder) {
          this.raise(Errors.UnexpectedArgumentPlaceholder, this.state.startLoc);
        }
        const node = this.startNode();
        this.next();
        elt = this.finishNode(node, "ArgumentPlaceholder");
      } else {
        elt = this.parseMaybeAssignAllowIn(
          refExpressionErrors,
          this.parseParenItem,
        );
      }
      return elt;
    }
    parseIdentifier(liberal) {
      const node = this.startNode();
      const name = this.parseIdentifierName(liberal);
      return this.createIdentifier(node, name);
    }
    createIdentifier(node, name) {
      node.name = name;
      node.loc.identifierName = name;
      return this.finishNode(node, "Identifier");
    }
    parseIdentifierName(liberal) {
      let name;
      const { startLoc: startLoc, type: type } = this.state;
      if (tokenIsKeywordOrIdentifier(type)) {
        name = this.state.value;
      } else {
        this.unexpected();
      }
      const tokenIsKeyword = tokenKeywordOrIdentifierIsKeyword(type);
      if (liberal) {
        if (tokenIsKeyword) {
          this.replaceToken(132);
        }
      } else {
        this.checkReservedWord(name, startLoc, tokenIsKeyword, false);
      }
      this.next();
      return name;
    }
    checkReservedWord(word, startLoc, checkKeywords, isBinding) {
      if (word.length > 10) {
        return;
      }
      if (!canBeReservedWord(word)) {
        return;
      }
      if (checkKeywords && isKeyword(word)) {
        this.raise(Errors.UnexpectedKeyword, startLoc, { keyword: word });
        return;
      }
      const reservedTest = !this.state.strict
        ? isReservedWord
        : isBinding
          ? isStrictBindReservedWord
          : isStrictReservedWord;
      if (reservedTest(word, this.inModule)) {
        this.raise(Errors.UnexpectedReservedWord, startLoc, {
          reservedWord: word,
        });
        return;
      } else if (word === "yield") {
        if (this.prodParam.hasYield) {
          this.raise(Errors.YieldBindingIdentifier, startLoc);
          return;
        }
      } else if (word === "await") {
        if (this.prodParam.hasAwait) {
          this.raise(Errors.AwaitBindingIdentifier, startLoc);
          return;
        }
        if (this.scope.inStaticBlock) {
          this.raise(Errors.AwaitBindingIdentifierInStaticBlock, startLoc);
          return;
        }
        this.expressionScope.recordAsyncArrowParametersError(startLoc);
      } else if (word === "arguments") {
        if (this.scope.inClassAndNotInNonArrowFunction) {
          this.raise(Errors.ArgumentsInClass, startLoc);
          return;
        }
      }
    }
    isAwaitAllowed() {
      if (this.prodParam.hasAwait) return true;
      if (this.options.allowAwaitOutsideFunction && !this.scope.inFunction) {
        return true;
      }
      return false;
    }
    parseAwait(startLoc) {
      const node = this.startNodeAt(startLoc);
      this.expressionScope.recordParameterInitializerError(
        Errors.AwaitExpressionFormalParameter,
        node,
      );
      if (this.eat(55)) {
        this.raise(Errors.ObsoleteAwaitStar, node);
      }
      if (!this.scope.inFunction && !this.options.allowAwaitOutsideFunction) {
        if (this.isAmbiguousAwait()) {
          this.ambiguousScriptDifferentAst = true;
        } else {
          this.sawUnambiguousESM = true;
        }
      }
      if (!this.state.soloAwait) {
        node.argument = this.parseMaybeUnary(null, true);
      }
      return this.finishNode(node, "AwaitExpression");
    }
    isAmbiguousAwait() {
      if (this.hasPrecedingLineBreak()) return true;
      const { type: type } = this.state;
      return (
        type === 53 ||
        type === 10 ||
        type === 0 ||
        tokenIsTemplate(type) ||
        (type === 102 && !this.state.containsEsc) ||
        type === 137 ||
        type === 56 ||
        (this.hasPlugin("v8intrinsic") && type === 54)
      );
    }
    parseYield() {
      const node = this.startNode();
      this.expressionScope.recordParameterInitializerError(
        Errors.YieldInParameter,
        node,
      );
      this.next();
      let delegating = false;
      let argument = null;
      if (!this.hasPrecedingLineBreak()) {
        delegating = this.eat(55);
        switch (this.state.type) {
          case 13:
          case 139:
          case 8:
          case 11:
          case 3:
          case 9:
          case 14:
          case 12:
            if (!delegating) break;
          default:
            argument = this.parseMaybeAssign();
        }
      }
      node.delegate = delegating;
      node.argument = argument;
      return this.finishNode(node, "YieldExpression");
    }
    parseImportCall(node) {
      this.next();
      node.source = this.parseMaybeAssignAllowIn();
      if (
        this.hasPlugin("importAttributes") ||
        this.hasPlugin("importAssertions")
      ) {
        node.options = null;
      }
      if (this.eat(12)) {
        this.expectImportAttributesPlugin();
        if (!this.match(11)) {
          node.options = this.parseMaybeAssignAllowIn();
          this.eat(12);
        }
      }
      this.expect(11);
      return this.finishNode(node, "ImportExpression");
    }
    checkPipelineAtInfixOperator(left, leftStartLoc) {
      if (this.hasPlugin(["pipelineOperator", { proposal: "smart" }])) {
        if (left.type === "SequenceExpression") {
          this.raise(Errors.PipelineHeadSequenceExpression, leftStartLoc);
        }
      }
    }
    parseSmartPipelineBodyInStyle(childExpr, startLoc) {
      if (this.isSimpleReference(childExpr)) {
        const bodyNode = this.startNodeAt(startLoc);
        bodyNode.callee = childExpr;
        return this.finishNode(bodyNode, "PipelineBareFunction");
      } else {
        const bodyNode = this.startNodeAt(startLoc);
        this.checkSmartPipeTopicBodyEarlyErrors(startLoc);
        bodyNode.expression = childExpr;
        return this.finishNode(bodyNode, "PipelineTopicExpression");
      }
    }
    isSimpleReference(expression) {
      switch (expression.type) {
        case "MemberExpression":
          return (
            !expression.computed && this.isSimpleReference(expression.object)
          );
        case "Identifier":
          return true;
        default:
          return false;
      }
    }
    checkSmartPipeTopicBodyEarlyErrors(startLoc) {
      if (this.match(19)) {
        throw this.raise(Errors.PipelineBodyNoArrow, this.state.startLoc);
      }
      if (!this.topicReferenceWasUsedInCurrentContext()) {
        this.raise(Errors.PipelineTopicUnused, startLoc);
      }
    }
    withTopicBindingContext(callback) {
      const outerContextTopicState = this.state.topicContext;
      this.state.topicContext = {
        maxNumOfResolvableTopics: 1,
        maxTopicIndex: null,
      };
      try {
        return callback();
      } finally {
        this.state.topicContext = outerContextTopicState;
      }
    }
    withSmartMixTopicForbiddingContext(callback) {
      if (this.hasPlugin(["pipelineOperator", { proposal: "smart" }])) {
        const outerContextTopicState = this.state.topicContext;
        this.state.topicContext = {
          maxNumOfResolvableTopics: 0,
          maxTopicIndex: null,
        };
        try {
          return callback();
        } finally {
          this.state.topicContext = outerContextTopicState;
        }
      } else {
        return callback();
      }
    }
    withSoloAwaitPermittingContext(callback) {
      const outerContextSoloAwaitState = this.state.soloAwait;
      this.state.soloAwait = true;
      try {
        return callback();
      } finally {
        this.state.soloAwait = outerContextSoloAwaitState;
      }
    }
    allowInAnd(callback) {
      const flags = this.prodParam.currentFlags();
      const prodParamToSet = 8 & ~flags;
      if (prodParamToSet) {
        this.prodParam.enter(flags | 8);
        try {
          return callback();
        } finally {
          this.prodParam.exit();
        }
      }
      return callback();
    }
    disallowInAnd(callback) {
      const flags = this.prodParam.currentFlags();
      const prodParamToClear = 8 & flags;
      if (prodParamToClear) {
        this.prodParam.enter(flags & ~8);
        try {
          return callback();
        } finally {
          this.prodParam.exit();
        }
      }
      return callback();
    }
    registerTopicReference() {
      this.state.topicContext.maxTopicIndex = 0;
    }
    topicReferenceIsAllowedInCurrentContext() {
      return this.state.topicContext.maxNumOfResolvableTopics >= 1;
    }
    topicReferenceWasUsedInCurrentContext() {
      return (
        this.state.topicContext.maxTopicIndex != null &&
        this.state.topicContext.maxTopicIndex >= 0
      );
    }
    parseFSharpPipelineBody(prec) {
      const startLoc = this.state.startLoc;
      this.state.potentialArrowAt = this.state.start;
      const oldInFSharpPipelineDirectBody =
        this.state.inFSharpPipelineDirectBody;
      this.state.inFSharpPipelineDirectBody = true;
      const ret = this.parseExprOp(
        this.parseMaybeUnaryOrPrivate(),
        startLoc,
        prec,
      );
      this.state.inFSharpPipelineDirectBody = oldInFSharpPipelineDirectBody;
      return ret;
    }
    parseModuleExpression() {
      this.expectPlugin("moduleBlocks");
      const node = this.startNode();
      this.next();
      if (!this.match(5)) {
        this.unexpected(null, 5);
      }
      const program = this.startNodeAt(this.state.endLoc);
      this.next();
      const revertScopes = this.initializeScopes(true);
      this.enterInitialScopes();
      try {
        node.body = this.parseProgram(program, 8, "module");
      } finally {
        revertScopes();
      }
      return this.finishNode(node, "ModuleExpression");
    }
    parsePropertyNamePrefixOperator(prop) {}
  }
  const loopLabel = { kind: 1 },
    switchLabel = { kind: 2 };
  const loneSurrogate = /[\uD800-\uDFFF]/u;
  const keywordRelationalOperator = /in(?:stanceof)?/y;
  function babel7CompatTokens(tokens, input) {
    for (let i = 0; i < tokens.length; i++) {
      const token = tokens[i];
      const { type: type } = token;
      if (typeof type === "number") {
        {
          if (type === 138) {
            const { loc: loc, start: start, value: value, end: end } = token;
            const hashEndPos = start + 1;
            const hashEndLoc = createPositionWithColumnOffset(loc.start, 1);
            tokens.splice(
              i,
              1,
              new Token({
                type: getExportedToken(27),
                value: "#",
                start: start,
                end: hashEndPos,
                startLoc: loc.start,
                endLoc: hashEndLoc,
              }),
              new Token({
                type: getExportedToken(132),
                value: value,
                start: hashEndPos,
                end: end,
                startLoc: hashEndLoc,
                endLoc: loc.end,
              }),
            );
            i++;
            continue;
          }
          if (tokenIsTemplate(type)) {
            const { loc: loc, start: start, value: value, end: end } = token;
            const backquoteEnd = start + 1;
            const backquoteEndLoc = createPositionWithColumnOffset(
              loc.start,
              1,
            );
            let startToken;
            if (input.charCodeAt(start) === 96) {
              startToken = new Token({
                type: getExportedToken(22),
                value: "`",
                start: start,
                end: backquoteEnd,
                startLoc: loc.start,
                endLoc: backquoteEndLoc,
              });
            } else {
              startToken = new Token({
                type: getExportedToken(8),
                value: "}",
                start: start,
                end: backquoteEnd,
                startLoc: loc.start,
                endLoc: backquoteEndLoc,
              });
            }
            let templateValue,
              templateElementEnd,
              templateElementEndLoc,
              endToken;
            if (type === 24) {
              templateElementEnd = end - 1;
              templateElementEndLoc = createPositionWithColumnOffset(
                loc.end,
                -1,
              );
              templateValue = value === null ? null : value.slice(1, -1);
              endToken = new Token({
                type: getExportedToken(22),
                value: "`",
                start: templateElementEnd,
                end: end,
                startLoc: templateElementEndLoc,
                endLoc: loc.end,
              });
            } else {
              templateElementEnd = end - 2;
              templateElementEndLoc = createPositionWithColumnOffset(
                loc.end,
                -2,
              );
              templateValue = value === null ? null : value.slice(1, -2);
              endToken = new Token({
                type: getExportedToken(23),
                value: "${",
                start: templateElementEnd,
                end: end,
                startLoc: templateElementEndLoc,
                endLoc: loc.end,
              });
            }
            tokens.splice(
              i,
              1,
              startToken,
              new Token({
                type: getExportedToken(20),
                value: templateValue,
                start: backquoteEnd,
                end: templateElementEnd,
                startLoc: backquoteEndLoc,
                endLoc: templateElementEndLoc,
              }),
              endToken,
            );
            i += 2;
            continue;
          }
        }
        token.type = getExportedToken(type);
      }
    }
    return tokens;
  }
  class StatementParser extends ExpressionParser {
    parseTopLevel(file, program) {
      file.program = this.parseProgram(program);
      file.comments = this.comments;
      if (this.options.tokens) {
        file.tokens = babel7CompatTokens(this.tokens, this.input);
      }
      return this.finishNode(file, "File");
    }
    parseProgram(program, end = 139, sourceType = this.options.sourceType) {
      program.sourceType = sourceType;
      program.interpreter = this.parseInterpreterDirective();
      this.parseBlockBody(program, true, true, end);
      if (
        this.inModule &&
        !this.options.allowUndeclaredExports &&
        this.scope.undefinedExports.size > 0
      ) {
        for (const [localName, at] of Array.from(this.scope.undefinedExports)) {
          this.raise(Errors.ModuleExportUndefined, at, {
            localName: localName,
          });
        }
      }
      let finishedProgram;
      if (end === 139) {
        finishedProgram = this.finishNode(program, "Program");
      } else {
        finishedProgram = this.finishNodeAt(
          program,
          "Program",
          createPositionWithColumnOffset(this.state.startLoc, -1),
        );
      }
      return finishedProgram;
    }
    stmtToDirective(stmt) {
      const directive = stmt;
      directive.type = "Directive";
      directive.value = directive.expression;
      delete directive.expression;
      const directiveLiteral = directive.value;
      const expressionValue = directiveLiteral.value;
      const raw = this.input.slice(
        directiveLiteral.start,
        directiveLiteral.end,
      );
      const val = (directiveLiteral.value = raw.slice(1, -1));
      this.addExtra(directiveLiteral, "raw", raw);
      this.addExtra(directiveLiteral, "rawValue", val);
      this.addExtra(directiveLiteral, "expressionValue", expressionValue);
      directiveLiteral.type = "DirectiveLiteral";
      return directive;
    }
    parseInterpreterDirective() {
      if (!this.match(28)) {
        return null;
      }
      const node = this.startNode();
      node.value = this.state.value;
      this.next();
      return this.finishNode(node, "InterpreterDirective");
    }
    isLet() {
      if (!this.isContextual(100)) {
        return false;
      }
      return this.hasFollowingBindingAtom();
    }
    chStartsBindingIdentifier(ch, pos) {
      if (isIdentifierStart(ch)) {
        keywordRelationalOperator.lastIndex = pos;
        if (keywordRelationalOperator.test(this.input)) {
          const endCh = this.codePointAtPos(
            keywordRelationalOperator.lastIndex,
          );
          if (!isIdentifierChar(endCh) && endCh !== 92) {
            return false;
          }
        }
        return true;
      } else if (ch === 92) {
        return true;
      } else {
        return false;
      }
    }
    chStartsBindingPattern(ch) {
      return ch === 91 || ch === 123;
    }
    hasFollowingBindingAtom() {
      const next = this.nextTokenStart();
      const nextCh = this.codePointAtPos(next);
      return (
        this.chStartsBindingPattern(nextCh) ||
        this.chStartsBindingIdentifier(nextCh, next)
      );
    }
    hasInLineFollowingBindingIdentifier() {
      const next = this.nextTokenInLineStart();
      const nextCh = this.codePointAtPos(next);
      return this.chStartsBindingIdentifier(nextCh, next);
    }
    startsUsingForOf() {
      const { type: type, containsEsc: containsEsc } = this.lookahead();
      if (type === 102 && !containsEsc) {
        return false;
      } else if (tokenIsIdentifier(type) && !this.hasFollowingLineBreak()) {
        this.expectPlugin("explicitResourceManagement");
        return true;
      }
    }
    startsAwaitUsing() {
      let next = this.nextTokenInLineStart();
      if (this.isUnparsedContextual(next, "using")) {
        next = this.nextTokenInLineStartSince(next + 5);
        const nextCh = this.codePointAtPos(next);
        if (this.chStartsBindingIdentifier(nextCh, next)) {
          this.expectPlugin("explicitResourceManagement");
          return true;
        }
      }
      return false;
    }
    parseModuleItem() {
      return this.parseStatementLike(1 | 2 | 4 | 8);
    }
    parseStatementListItem() {
      return this.parseStatementLike(
        2 | 4 | (!this.options.annexB || this.state.strict ? 0 : 8),
      );
    }
    parseStatementOrSloppyAnnexBFunctionDeclaration(
      allowLabeledFunction = false,
    ) {
      let flags = 0;
      if (this.options.annexB && !this.state.strict) {
        flags |= 4;
        if (allowLabeledFunction) {
          flags |= 8;
        }
      }
      return this.parseStatementLike(flags);
    }
    parseStatement() {
      return this.parseStatementLike(0);
    }
    parseStatementLike(flags) {
      let decorators = null;
      if (this.match(26)) {
        decorators = this.parseDecorators(true);
      }
      return this.parseStatementContent(flags, decorators);
    }
    parseStatementContent(flags, decorators) {
      const starttype = this.state.type;
      const node = this.startNode();
      const allowDeclaration = !!(flags & 2);
      const allowFunctionDeclaration = !!(flags & 4);
      const topLevel = flags & 1;
      switch (starttype) {
        case 60:
          return this.parseBreakContinueStatement(node, true);
        case 63:
          return this.parseBreakContinueStatement(node, false);
        case 64:
          return this.parseDebuggerStatement(node);
        case 90:
          return this.parseDoWhileStatement(node);
        case 91:
          return this.parseForStatement(node);
        case 68:
          if (this.lookaheadCharCode() === 46) break;
          if (!allowFunctionDeclaration) {
            this.raise(
              this.state.strict
                ? Errors.StrictFunction
                : this.options.annexB
                  ? Errors.SloppyFunctionAnnexB
                  : Errors.SloppyFunction,
              this.state.startLoc,
            );
          }
          return this.parseFunctionStatement(
            node,
            false,
            !allowDeclaration && allowFunctionDeclaration,
          );
        case 80:
          if (!allowDeclaration) this.unexpected();
          return this.parseClass(
            this.maybeTakeDecorators(decorators, node),
            true,
          );
        case 69:
          return this.parseIfStatement(node);
        case 70:
          return this.parseReturnStatement(node);
        case 71:
          return this.parseSwitchStatement(node);
        case 72:
          return this.parseThrowStatement(node);
        case 73:
          return this.parseTryStatement(node);
        case 96:
          if (!this.state.containsEsc && this.startsAwaitUsing()) {
            if (!this.isAwaitAllowed()) {
              this.raise(Errors.AwaitUsingNotInAsyncContext, node);
            } else if (!allowDeclaration) {
              this.raise(Errors.UnexpectedLexicalDeclaration, node);
            }
            this.next();
            return this.parseVarStatement(node, "await using");
          }
          break;
        case 107:
          if (
            this.state.containsEsc ||
            !this.hasInLineFollowingBindingIdentifier()
          ) {
            break;
          }
          this.expectPlugin("explicitResourceManagement");
          if (!this.scope.inModule && this.scope.inTopLevel) {
            this.raise(Errors.UnexpectedUsingDeclaration, this.state.startLoc);
          } else if (!allowDeclaration) {
            this.raise(
              Errors.UnexpectedLexicalDeclaration,
              this.state.startLoc,
            );
          }
          return this.parseVarStatement(node, "using");
        case 100: {
          if (this.state.containsEsc) {
            break;
          }
          const next = this.nextTokenStart();
          const nextCh = this.codePointAtPos(next);
          if (nextCh !== 91) {
            if (!allowDeclaration && this.hasFollowingLineBreak()) break;
            if (
              !this.chStartsBindingIdentifier(nextCh, next) &&
              nextCh !== 123
            ) {
              break;
            }
          }
        }
        case 75: {
          if (!allowDeclaration) {
            this.raise(
              Errors.UnexpectedLexicalDeclaration,
              this.state.startLoc,
            );
          }
        }
        case 74: {
          const kind = this.state.value;
          return this.parseVarStatement(node, kind);
        }
        case 92:
          return this.parseWhileStatement(node);
        case 76:
          return this.parseWithStatement(node);
        case 5:
          return this.parseBlock();
        case 13:
          return this.parseEmptyStatement(node);
        case 83: {
          const nextTokenCharCode = this.lookaheadCharCode();
          if (nextTokenCharCode === 40 || nextTokenCharCode === 46) {
            break;
          }
        }
        case 82: {
          if (!this.options.allowImportExportEverywhere && !topLevel) {
            this.raise(Errors.UnexpectedImportExport, this.state.startLoc);
          }
          this.next();
          let result;
          if (starttype === 83) {
            result = this.parseImport(node);
            if (
              result.type === "ImportDeclaration" &&
              (!result.importKind || result.importKind === "value")
            ) {
              this.sawUnambiguousESM = true;
            }
          } else {
            result = this.parseExport(node, decorators);
            if (
              (result.type === "ExportNamedDeclaration" &&
                (!result.exportKind || result.exportKind === "value")) ||
              (result.type === "ExportAllDeclaration" &&
                (!result.exportKind || result.exportKind === "value")) ||
              result.type === "ExportDefaultDeclaration"
            ) {
              this.sawUnambiguousESM = true;
            }
          }
          this.assertModuleNodeAllowed(result);
          return result;
        }
        default: {
          if (this.isAsyncFunction()) {
            if (!allowDeclaration) {
              this.raise(
                Errors.AsyncFunctionInSingleStatementContext,
                this.state.startLoc,
              );
            }
            this.next();
            return this.parseFunctionStatement(
              node,
              true,
              !allowDeclaration && allowFunctionDeclaration,
            );
          }
        }
      }
      const maybeName = this.state.value;
      const expr = this.parseExpression();
      if (
        tokenIsIdentifier(starttype) &&
        expr.type === "Identifier" &&
        this.eat(14)
      ) {
        return this.parseLabeledStatement(node, maybeName, expr, flags);
      } else {
        return this.parseExpressionStatement(node, expr, decorators);
      }
    }
    assertModuleNodeAllowed(node) {
      if (!this.options.allowImportExportEverywhere && !this.inModule) {
        this.raise(Errors.ImportOutsideModule, node);
      }
    }
    decoratorsEnabledBeforeExport() {
      if (this.hasPlugin("decorators-legacy")) return true;
      return (
        this.hasPlugin("decorators") &&
        this.getPluginOption("decorators", "decoratorsBeforeExport") !== false
      );
    }
    maybeTakeDecorators(maybeDecorators, classNode, exportNode) {
      if (maybeDecorators) {
        if (classNode.decorators && classNode.decorators.length > 0) {
          if (
            typeof this.getPluginOption(
              "decorators",
              "decoratorsBeforeExport",
            ) !== "boolean"
          ) {
            this.raise(
              Errors.DecoratorsBeforeAfterExport,
              classNode.decorators[0],
            );
          }
          classNode.decorators.unshift(...maybeDecorators);
        } else {
          classNode.decorators = maybeDecorators;
        }
        this.resetStartLocationFromNode(classNode, maybeDecorators[0]);
        if (exportNode) this.resetStartLocationFromNode(exportNode, classNode);
      }
      return classNode;
    }
    canHaveLeadingDecorator() {
      return this.match(80);
    }
    parseDecorators(allowExport) {
      const decorators = [];
      do {
        decorators.push(this.parseDecorator());
      } while (this.match(26));
      if (this.match(82)) {
        if (!allowExport) {
          this.unexpected();
        }
        if (!this.decoratorsEnabledBeforeExport()) {
          this.raise(Errors.DecoratorExportClass, this.state.startLoc);
        }
      } else if (!this.canHaveLeadingDecorator()) {
        throw this.raise(
          Errors.UnexpectedLeadingDecorator,
          this.state.startLoc,
        );
      }
      return decorators;
    }
    parseDecorator() {
      this.expectOnePlugin(["decorators", "decorators-legacy"]);
      const node = this.startNode();
      this.next();
      if (this.hasPlugin("decorators")) {
        const startLoc = this.state.startLoc;
        let expr;
        if (this.match(10)) {
          const startLoc = this.state.startLoc;
          this.next();
          expr = this.parseExpression();
          this.expect(11);
          expr = this.wrapParenthesis(startLoc, expr);
          const paramsStartLoc = this.state.startLoc;
          node.expression = this.parseMaybeDecoratorArguments(expr);
          if (
            this.getPluginOption("decorators", "allowCallParenthesized") ===
              false &&
            node.expression !== expr
          ) {
            this.raise(
              Errors.DecoratorArgumentsOutsideParentheses,
              paramsStartLoc,
            );
          }
        } else {
          expr = this.parseIdentifier(false);
          while (this.eat(16)) {
            const node = this.startNodeAt(startLoc);
            node.object = expr;
            if (this.match(138)) {
              this.classScope.usePrivateName(
                this.state.value,
                this.state.startLoc,
              );
              node.property = this.parsePrivateName();
            } else {
              node.property = this.parseIdentifier(true);
            }
            node.computed = false;
            expr = this.finishNode(node, "MemberExpression");
          }
          node.expression = this.parseMaybeDecoratorArguments(expr);
        }
      } else {
        node.expression = this.parseExprSubscripts();
      }
      return this.finishNode(node, "Decorator");
    }
    parseMaybeDecoratorArguments(expr) {
      if (this.eat(10)) {
        const node = this.startNodeAtNode(expr);
        node.callee = expr;
        node.arguments = this.parseCallExpressionArguments(11, false);
        this.toReferencedList(node.arguments);
        return this.finishNode(node, "CallExpression");
      }
      return expr;
    }
    parseBreakContinueStatement(node, isBreak) {
      this.next();
      if (this.isLineTerminator()) {
        node.label = null;
      } else {
        node.label = this.parseIdentifier();
        this.semicolon();
      }
      this.verifyBreakContinue(node, isBreak);
      return this.finishNode(
        node,
        isBreak ? "BreakStatement" : "ContinueStatement",
      );
    }
    verifyBreakContinue(node, isBreak) {
      let i;
      for (i = 0; i < this.state.labels.length; ++i) {
        const lab = this.state.labels[i];
        if (node.label == null || lab.name === node.label.name) {
          if (lab.kind != null && (isBreak || lab.kind === 1)) {
            break;
          }
          if (node.label && isBreak) break;
        }
      }
      if (i === this.state.labels.length) {
        const type = isBreak ? "BreakStatement" : "ContinueStatement";
        this.raise(Errors.IllegalBreakContinue, node, { type: type });
      }
    }
    parseDebuggerStatement(node) {
      this.next();
      this.semicolon();
      return this.finishNode(node, "DebuggerStatement");
    }
    parseHeaderExpression() {
      this.expect(10);
      const val = this.parseExpression();
      this.expect(11);
      return val;
    }
    parseDoWhileStatement(node) {
      this.next();
      this.state.labels.push(loopLabel);
      node.body = this.withSmartMixTopicForbiddingContext(() =>
        this.parseStatement(),
      );
      this.state.labels.pop();
      this.expect(92);
      node.test = this.parseHeaderExpression();
      this.eat(13);
      return this.finishNode(node, "DoWhileStatement");
    }
    parseForStatement(node) {
      this.next();
      this.state.labels.push(loopLabel);
      let awaitAt = null;
      if (this.isAwaitAllowed() && this.eatContextual(96)) {
        awaitAt = this.state.lastTokStartLoc;
      }
      this.scope.enter(0);
      this.expect(10);
      if (this.match(13)) {
        if (awaitAt !== null) {
          this.unexpected(awaitAt);
        }
        return this.parseFor(node, null);
      }
      const startsWithLet = this.isContextual(100);
      {
        const startsWithAwaitUsing =
          this.isContextual(96) && this.startsAwaitUsing();
        const starsWithUsingDeclaration =
          startsWithAwaitUsing ||
          (this.isContextual(107) && this.startsUsingForOf());
        const isLetOrUsing =
          (startsWithLet && this.hasFollowingBindingAtom()) ||
          starsWithUsingDeclaration;
        if (this.match(74) || this.match(75) || isLetOrUsing) {
          const initNode = this.startNode();
          let kind;
          if (startsWithAwaitUsing) {
            kind = "await using";
            if (!this.isAwaitAllowed()) {
              this.raise(
                Errors.AwaitUsingNotInAsyncContext,
                this.state.startLoc,
              );
            }
            this.next();
          } else {
            kind = this.state.value;
          }
          this.next();
          this.parseVar(initNode, true, kind);
          const init = this.finishNode(initNode, "VariableDeclaration");
          const isForIn = this.match(58);
          if (isForIn && starsWithUsingDeclaration) {
            this.raise(Errors.ForInUsing, init);
          }
          if (
            (isForIn || this.isContextual(102)) &&
            init.declarations.length === 1
          ) {
            return this.parseForIn(node, init, awaitAt);
          }
          if (awaitAt !== null) {
            this.unexpected(awaitAt);
          }
          return this.parseFor(node, init);
        }
      }
      const startsWithAsync = this.isContextual(95);
      const refExpressionErrors = new ExpressionErrors();
      const init = this.parseExpression(true, refExpressionErrors);
      const isForOf = this.isContextual(102);
      if (isForOf) {
        if (startsWithLet) {
          this.raise(Errors.ForOfLet, init);
        }
        if (awaitAt === null && startsWithAsync && init.type === "Identifier") {
          this.raise(Errors.ForOfAsync, init);
        }
      }
      if (isForOf || this.match(58)) {
        this.checkDestructuringPrivate(refExpressionErrors);
        this.toAssignable(init, true);
        const type = isForOf ? "ForOfStatement" : "ForInStatement";
        this.checkLVal(init, { in: { type: type } });
        return this.parseForIn(node, init, awaitAt);
      } else {
        this.checkExpressionErrors(refExpressionErrors, true);
      }
      if (awaitAt !== null) {
        this.unexpected(awaitAt);
      }
      return this.parseFor(node, init);
    }
    parseFunctionStatement(node, isAsync, isHangingDeclaration) {
      this.next();
      return this.parseFunction(
        node,
        1 | (isHangingDeclaration ? 2 : 0) | (isAsync ? 8 : 0),
      );
    }
    parseIfStatement(node) {
      this.next();
      node.test = this.parseHeaderExpression();
      node.consequent = this.parseStatementOrSloppyAnnexBFunctionDeclaration();
      node.alternate = this.eat(66)
        ? this.parseStatementOrSloppyAnnexBFunctionDeclaration()
        : null;
      return this.finishNode(node, "IfStatement");
    }
    parseReturnStatement(node) {
      if (
        !this.prodParam.hasReturn &&
        !this.options.allowReturnOutsideFunction
      ) {
        this.raise(Errors.IllegalReturn, this.state.startLoc);
      }
      this.next();
      if (this.isLineTerminator()) {
        node.argument = null;
      } else {
        node.argument = this.parseExpression();
        this.semicolon();
      }
      return this.finishNode(node, "ReturnStatement");
    }
    parseSwitchStatement(node) {
      this.next();
      node.discriminant = this.parseHeaderExpression();
      const cases = (node.cases = []);
      this.expect(5);
      this.state.labels.push(switchLabel);
      this.scope.enter(0);
      let cur;
      for (let sawDefault; !this.match(8); ) {
        if (this.match(61) || this.match(65)) {
          const isCase = this.match(61);
          if (cur) this.finishNode(cur, "SwitchCase");
          cases.push((cur = this.startNode()));
          cur.consequent = [];
          this.next();
          if (isCase) {
            cur.test = this.parseExpression();
          } else {
            if (sawDefault) {
              this.raise(
                Errors.MultipleDefaultsInSwitch,
                this.state.lastTokStartLoc,
              );
            }
            sawDefault = true;
            cur.test = null;
          }
          this.expect(14);
        } else {
          if (cur) {
            cur.consequent.push(this.parseStatementListItem());
          } else {
            this.unexpected();
          }
        }
      }
      this.scope.exit();
      if (cur) this.finishNode(cur, "SwitchCase");
      this.next();
      this.state.labels.pop();
      return this.finishNode(node, "SwitchStatement");
    }
    parseThrowStatement(node) {
      this.next();
      if (this.hasPrecedingLineBreak()) {
        this.raise(Errors.NewlineAfterThrow, this.state.lastTokEndLoc);
      }
      node.argument = this.parseExpression();
      this.semicolon();
      return this.finishNode(node, "ThrowStatement");
    }
    parseCatchClauseParam() {
      const param = this.parseBindingAtom();
      this.scope.enter(
        this.options.annexB && param.type === "Identifier" ? 8 : 0,
      );
      this.checkLVal(param, { in: { type: "CatchClause" }, binding: 9 });
      return param;
    }
    parseTryStatement(node) {
      this.next();
      node.block = this.parseBlock();
      node.handler = null;
      if (this.match(62)) {
        const clause = this.startNode();
        this.next();
        if (this.match(10)) {
          this.expect(10);
          clause.param = this.parseCatchClauseParam();
          this.expect(11);
        } else {
          clause.param = null;
          this.scope.enter(0);
        }
        clause.body = this.withSmartMixTopicForbiddingContext(() =>
          this.parseBlock(false, false),
        );
        this.scope.exit();
        node.handler = this.finishNode(clause, "CatchClause");
      }
      node.finalizer = this.eat(67) ? this.parseBlock() : null;
      if (!node.handler && !node.finalizer) {
        this.raise(Errors.NoCatchOrFinally, node);
      }
      return this.finishNode(node, "TryStatement");
    }
    parseVarStatement(node, kind, allowMissingInitializer = false) {
      this.next();
      this.parseVar(node, false, kind, allowMissingInitializer);
      this.semicolon();
      return this.finishNode(node, "VariableDeclaration");
    }
    parseWhileStatement(node) {
      this.next();
      node.test = this.parseHeaderExpression();
      this.state.labels.push(loopLabel);
      node.body = this.withSmartMixTopicForbiddingContext(() =>
        this.parseStatement(),
      );
      this.state.labels.pop();
      return this.finishNode(node, "WhileStatement");
    }
    parseWithStatement(node) {
      if (this.state.strict) {
        this.raise(Errors.StrictWith, this.state.startLoc);
      }
      this.next();
      node.object = this.parseHeaderExpression();
      node.body = this.withSmartMixTopicForbiddingContext(() =>
        this.parseStatement(),
      );
      return this.finishNode(node, "WithStatement");
    }
    parseEmptyStatement(node) {
      this.next();
      return this.finishNode(node, "EmptyStatement");
    }
    parseLabeledStatement(node, maybeName, expr, flags) {
      for (const label of this.state.labels) {
        if (label.name === maybeName) {
          this.raise(Errors.LabelRedeclaration, expr, { labelName: maybeName });
        }
      }
      const kind = tokenIsLoop(this.state.type) ? 1 : this.match(71) ? 2 : null;
      for (let i = this.state.labels.length - 1; i >= 0; i--) {
        const label = this.state.labels[i];
        if (label.statementStart === node.start) {
          label.statementStart = this.state.start;
          label.kind = kind;
        } else {
          break;
        }
      }
      this.state.labels.push({
        name: maybeName,
        kind: kind,
        statementStart: this.state.start,
      });
      node.body =
        flags & 8
          ? this.parseStatementOrSloppyAnnexBFunctionDeclaration(true)
          : this.parseStatement();
      this.state.labels.pop();
      node.label = expr;
      return this.finishNode(node, "LabeledStatement");
    }
    parseExpressionStatement(node, expr, decorators) {
      node.expression = expr;
      this.semicolon();
      return this.finishNode(node, "ExpressionStatement");
    }
    parseBlock(
      allowDirectives = false,
      createNewLexicalScope = true,
      afterBlockParse,
    ) {
      const node = this.startNode();
      if (allowDirectives) {
        this.state.strictErrors.clear();
      }
      this.expect(5);
      if (createNewLexicalScope) {
        this.scope.enter(0);
      }
      this.parseBlockBody(node, allowDirectives, false, 8, afterBlockParse);
      if (createNewLexicalScope) {
        this.scope.exit();
      }
      return this.finishNode(node, "BlockStatement");
    }
    isValidDirective(stmt) {
      return (
        stmt.type === "ExpressionStatement" &&
        stmt.expression.type === "StringLiteral" &&
        !stmt.expression.extra.parenthesized
      );
    }
    parseBlockBody(node, allowDirectives, topLevel, end, afterBlockParse) {
      const body = (node.body = []);
      const directives = (node.directives = []);
      this.parseBlockOrModuleBlockBody(
        body,
        allowDirectives ? directives : undefined,
        topLevel,
        end,
        afterBlockParse,
      );
    }
    parseBlockOrModuleBlockBody(
      body,
      directives,
      topLevel,
      end,
      afterBlockParse,
    ) {
      const oldStrict = this.state.strict;
      let hasStrictModeDirective = false;
      let parsedNonDirective = false;
      while (!this.match(end)) {
        const stmt = topLevel
          ? this.parseModuleItem()
          : this.parseStatementListItem();
        if (directives && !parsedNonDirective) {
          if (this.isValidDirective(stmt)) {
            const directive = this.stmtToDirective(stmt);
            directives.push(directive);
            if (
              !hasStrictModeDirective &&
              directive.value.value === "use strict"
            ) {
              hasStrictModeDirective = true;
              this.setStrict(true);
            }
            continue;
          }
          parsedNonDirective = true;
          this.state.strictErrors.clear();
        }
        body.push(stmt);
      }
      afterBlockParse == null ||
        afterBlockParse.call(this, hasStrictModeDirective);
      if (!oldStrict) {
        this.setStrict(false);
      }
      this.next();
    }
    parseFor(node, init) {
      node.init = init;
      this.semicolon(false);
      node.test = this.match(13) ? null : this.parseExpression();
      this.semicolon(false);
      node.update = this.match(11) ? null : this.parseExpression();
      this.expect(11);
      node.body = this.withSmartMixTopicForbiddingContext(() =>
        this.parseStatement(),
      );
      this.scope.exit();
      this.state.labels.pop();
      return this.finishNode(node, "ForStatement");
    }
    parseForIn(node, init, awaitAt) {
      const isForIn = this.match(58);
      this.next();
      if (isForIn) {
        if (awaitAt !== null) this.unexpected(awaitAt);
      } else {
        node.await = awaitAt !== null;
      }
      if (
        init.type === "VariableDeclaration" &&
        init.declarations[0].init != null &&
        (!isForIn ||
          !this.options.annexB ||
          this.state.strict ||
          init.kind !== "var" ||
          init.declarations[0].id.type !== "Identifier")
      ) {
        this.raise(Errors.ForInOfLoopInitializer, init, {
          type: isForIn ? "ForInStatement" : "ForOfStatement",
        });
      }
      if (init.type === "AssignmentPattern") {
        this.raise(Errors.InvalidLhs, init, {
          ancestor: { type: "ForStatement" },
        });
      }
      node.left = init;
      node.right = isForIn
        ? this.parseExpression()
        : this.parseMaybeAssignAllowIn();
      this.expect(11);
      node.body = this.withSmartMixTopicForbiddingContext(() =>
        this.parseStatement(),
      );
      this.scope.exit();
      this.state.labels.pop();
      return this.finishNode(
        node,
        isForIn ? "ForInStatement" : "ForOfStatement",
      );
    }
    parseVar(node, isFor, kind, allowMissingInitializer = false) {
      const declarations = (node.declarations = []);
      node.kind = kind;
      for (;;) {
        const decl = this.startNode();
        this.parseVarId(decl, kind);
        decl.init = !this.eat(29)
          ? null
          : isFor
            ? this.parseMaybeAssignDisallowIn()
            : this.parseMaybeAssignAllowIn();
        if (decl.init === null && !allowMissingInitializer) {
          if (
            decl.id.type !== "Identifier" &&
            !(isFor && (this.match(58) || this.isContextual(102)))
          ) {
            this.raise(
              Errors.DeclarationMissingInitializer,
              this.state.lastTokEndLoc,
              { kind: "destructuring" },
            );
          } else if (
            (kind === "const" || kind === "using" || kind === "await using") &&
            !(this.match(58) || this.isContextual(102))
          ) {
            this.raise(
              Errors.DeclarationMissingInitializer,
              this.state.lastTokEndLoc,
              { kind: kind },
            );
          }
        }
        declarations.push(this.finishNode(decl, "VariableDeclarator"));
        if (!this.eat(12)) break;
      }
      return node;
    }
    parseVarId(decl, kind) {
      const id = this.parseBindingAtom();
      this.checkLVal(id, {
        in: { type: "VariableDeclarator" },
        binding: kind === "var" ? 5 : 8201,
      });
      decl.id = id;
    }
    parseAsyncFunctionExpression(node) {
      return this.parseFunction(node, 8);
    }
    parseFunction(node, flags = 0) {
      const hangingDeclaration = flags & 2;
      const isDeclaration = !!(flags & 1);
      const requireId = isDeclaration && !(flags & 4);
      const isAsync = !!(flags & 8);
      this.initFunction(node, isAsync);
      if (this.match(55)) {
        if (hangingDeclaration) {
          this.raise(
            Errors.GeneratorInSingleStatementContext,
            this.state.startLoc,
          );
        }
        this.next();
        node.generator = true;
      }
      if (isDeclaration) {
        node.id = this.parseFunctionId(requireId);
      }
      const oldMaybeInArrowParameters = this.state.maybeInArrowParameters;
      this.state.maybeInArrowParameters = false;
      this.scope.enter(2);
      this.prodParam.enter(functionFlags(isAsync, node.generator));
      if (!isDeclaration) {
        node.id = this.parseFunctionId();
      }
      this.parseFunctionParams(node, false);
      this.withSmartMixTopicForbiddingContext(() => {
        this.parseFunctionBodyAndFinish(
          node,
          isDeclaration ? "FunctionDeclaration" : "FunctionExpression",
        );
      });
      this.prodParam.exit();
      this.scope.exit();
      if (isDeclaration && !hangingDeclaration) {
        this.registerFunctionStatementId(node);
      }
      this.state.maybeInArrowParameters = oldMaybeInArrowParameters;
      return node;
    }
    parseFunctionId(requireId) {
      return requireId || tokenIsIdentifier(this.state.type)
        ? this.parseIdentifier()
        : null;
    }
    parseFunctionParams(node, isConstructor) {
      this.expect(10);
      this.expressionScope.enter(newParameterDeclarationScope());
      node.params = this.parseBindingList(11, 41, 2 | (isConstructor ? 4 : 0));
      this.expressionScope.exit();
    }
    registerFunctionStatementId(node) {
      if (!node.id) return;
      this.scope.declareName(
        node.id.name,
        !this.options.annexB ||
          this.state.strict ||
          node.generator ||
          node.async
          ? this.scope.treatFunctionsAsVar
            ? 5
            : 8201
          : 17,
        node.id.loc.start,
      );
    }
    parseClass(node, isStatement, optionalId) {
      this.next();
      const oldStrict = this.state.strict;
      this.state.strict = true;
      this.parseClassId(node, isStatement, optionalId);
      this.parseClassSuper(node);
      node.body = this.parseClassBody(!!node.superClass, oldStrict);
      return this.finishNode(
        node,
        isStatement ? "ClassDeclaration" : "ClassExpression",
      );
    }
    isClassProperty() {
      return this.match(29) || this.match(13) || this.match(8);
    }
    isClassMethod() {
      return this.match(10);
    }
    isNonstaticConstructor(method) {
      return (
        !method.computed &&
        !method.static &&
        (method.key.name === "constructor" ||
          method.key.value === "constructor")
      );
    }
    parseClassBody(hadSuperClass, oldStrict) {
      this.classScope.enter();
      const state = { hadConstructor: false, hadSuperClass: hadSuperClass };
      let decorators = [];
      const classBody = this.startNode();
      classBody.body = [];
      this.expect(5);
      this.withSmartMixTopicForbiddingContext(() => {
        while (!this.match(8)) {
          if (this.eat(13)) {
            if (decorators.length > 0) {
              throw this.raise(
                Errors.DecoratorSemicolon,
                this.state.lastTokEndLoc,
              );
            }
            continue;
          }
          if (this.match(26)) {
            decorators.push(this.parseDecorator());
            continue;
          }
          const member = this.startNode();
          if (decorators.length) {
            member.decorators = decorators;
            this.resetStartLocationFromNode(member, decorators[0]);
            decorators = [];
          }
          this.parseClassMember(classBody, member, state);
          if (
            member.kind === "constructor" &&
            member.decorators &&
            member.decorators.length > 0
          ) {
            this.raise(Errors.DecoratorConstructor, member);
          }
        }
      });
      this.state.strict = oldStrict;
      this.next();
      if (decorators.length) {
        throw this.raise(Errors.TrailingDecorator, this.state.startLoc);
      }
      this.classScope.exit();
      return this.finishNode(classBody, "ClassBody");
    }
    parseClassMemberFromModifier(classBody, member) {
      const key = this.parseIdentifier(true);
      if (this.isClassMethod()) {
        const method = member;
        method.kind = "method";
        method.computed = false;
        method.key = key;
        method.static = false;
        this.pushClassMethod(classBody, method, false, false, false, false);
        return true;
      } else if (this.isClassProperty()) {
        const prop = member;
        prop.computed = false;
        prop.key = key;
        prop.static = false;
        classBody.body.push(this.parseClassProperty(prop));
        return true;
      }
      this.resetPreviousNodeTrailingComments(key);
      return false;
    }
    parseClassMember(classBody, member, state) {
      const isStatic = this.isContextual(106);
      if (isStatic) {
        if (this.parseClassMemberFromModifier(classBody, member)) {
          return;
        }
        if (this.eat(5)) {
          this.parseClassStaticBlock(classBody, member);
          return;
        }
      }
      this.parseClassMemberWithIsStatic(classBody, member, state, isStatic);
    }
    parseClassMemberWithIsStatic(classBody, member, state, isStatic) {
      const publicMethod = member;
      const privateMethod = member;
      const publicProp = member;
      const privateProp = member;
      const accessorProp = member;
      const method = publicMethod;
      const publicMember = publicMethod;
      member.static = isStatic;
      this.parsePropertyNamePrefixOperator(member);
      if (this.eat(55)) {
        method.kind = "method";
        const isPrivateName = this.match(138);
        this.parseClassElementName(method);
        if (isPrivateName) {
          this.pushClassPrivateMethod(classBody, privateMethod, true, false);
          return;
        }
        if (this.isNonstaticConstructor(publicMethod)) {
          this.raise(Errors.ConstructorIsGenerator, publicMethod.key);
        }
        this.pushClassMethod(
          classBody,
          publicMethod,
          true,
          false,
          false,
          false,
        );
        return;
      }
      const isContextual =
        tokenIsIdentifier(this.state.type) && !this.state.containsEsc;
      const isPrivate = this.match(138);
      const key = this.parseClassElementName(member);
      const maybeQuestionTokenStartLoc = this.state.startLoc;
      this.parsePostMemberNameModifiers(publicMember);
      if (this.isClassMethod()) {
        method.kind = "method";
        if (isPrivate) {
          this.pushClassPrivateMethod(classBody, privateMethod, false, false);
          return;
        }
        const isConstructor = this.isNonstaticConstructor(publicMethod);
        let allowsDirectSuper = false;
        if (isConstructor) {
          publicMethod.kind = "constructor";
          if (state.hadConstructor && !this.hasPlugin("typescript")) {
            this.raise(Errors.DuplicateConstructor, key);
          }
          if (
            isConstructor &&
            this.hasPlugin("typescript") &&
            member.override
          ) {
            this.raise(Errors.OverrideOnConstructor, key);
          }
          state.hadConstructor = true;
          allowsDirectSuper = state.hadSuperClass;
        }
        this.pushClassMethod(
          classBody,
          publicMethod,
          false,
          false,
          isConstructor,
          allowsDirectSuper,
        );
      } else if (this.isClassProperty()) {
        if (isPrivate) {
          this.pushClassPrivateProperty(classBody, privateProp);
        } else {
          this.pushClassProperty(classBody, publicProp);
        }
      } else if (
        isContextual &&
        key.name === "async" &&
        !this.isLineTerminator()
      ) {
        this.resetPreviousNodeTrailingComments(key);
        const isGenerator = this.eat(55);
        if (publicMember.optional) {
          this.unexpected(maybeQuestionTokenStartLoc);
        }
        method.kind = "method";
        const isPrivate = this.match(138);
        this.parseClassElementName(method);
        this.parsePostMemberNameModifiers(publicMember);
        if (isPrivate) {
          this.pushClassPrivateMethod(
            classBody,
            privateMethod,
            isGenerator,
            true,
          );
        } else {
          if (this.isNonstaticConstructor(publicMethod)) {
            this.raise(Errors.ConstructorIsAsync, publicMethod.key);
          }
          this.pushClassMethod(
            classBody,
            publicMethod,
            isGenerator,
            true,
            false,
            false,
          );
        }
      } else if (
        isContextual &&
        (key.name === "get" || key.name === "set") &&
        !(this.match(55) && this.isLineTerminator())
      ) {
        this.resetPreviousNodeTrailingComments(key);
        method.kind = key.name;
        const isPrivate = this.match(138);
        this.parseClassElementName(publicMethod);
        if (isPrivate) {
          this.pushClassPrivateMethod(classBody, privateMethod, false, false);
        } else {
          if (this.isNonstaticConstructor(publicMethod)) {
            this.raise(Errors.ConstructorIsAccessor, publicMethod.key);
          }
          this.pushClassMethod(
            classBody,
            publicMethod,
            false,
            false,
            false,
            false,
          );
        }
        this.checkGetterSetterParams(publicMethod);
      } else if (
        isContextual &&
        key.name === "accessor" &&
        !this.isLineTerminator()
      ) {
        this.expectPlugin("decoratorAutoAccessors");
        this.resetPreviousNodeTrailingComments(key);
        const isPrivate = this.match(138);
        this.parseClassElementName(publicProp);
        this.pushClassAccessorProperty(classBody, accessorProp, isPrivate);
      } else if (this.isLineTerminator()) {
        if (isPrivate) {
          this.pushClassPrivateProperty(classBody, privateProp);
        } else {
          this.pushClassProperty(classBody, publicProp);
        }
      } else {
        this.unexpected();
      }
    }
    parseClassElementName(member) {
      const { type: type, value: value } = this.state;
      if (
        (type === 132 || type === 133) &&
        member.static &&
        value === "prototype"
      ) {
        this.raise(Errors.StaticPrototype, this.state.startLoc);
      }
      if (type === 138) {
        if (value === "constructor") {
          this.raise(Errors.ConstructorClassPrivateField, this.state.startLoc);
        }
        const key = this.parsePrivateName();
        member.key = key;
        return key;
      }
      return this.parsePropertyName(member);
    }
    parseClassStaticBlock(classBody, member) {
      var _member$decorators;
      this.scope.enter(64 | 128 | 16);
      const oldLabels = this.state.labels;
      this.state.labels = [];
      this.prodParam.enter(0);
      const body = (member.body = []);
      this.parseBlockOrModuleBlockBody(body, undefined, false, 8);
      this.prodParam.exit();
      this.scope.exit();
      this.state.labels = oldLabels;
      classBody.body.push(this.finishNode(member, "StaticBlock"));
      if (
        (_member$decorators = member.decorators) != null &&
        _member$decorators.length
      ) {
        this.raise(Errors.DecoratorStaticBlock, member);
      }
    }
    pushClassProperty(classBody, prop) {
      if (
        !prop.computed &&
        (prop.key.name === "constructor" || prop.key.value === "constructor")
      ) {
        this.raise(Errors.ConstructorClassField, prop.key);
      }
      classBody.body.push(this.parseClassProperty(prop));
    }
    pushClassPrivateProperty(classBody, prop) {
      const node = this.parseClassPrivateProperty(prop);
      classBody.body.push(node);
      this.classScope.declarePrivateName(
        this.getPrivateNameSV(node.key),
        0,
        node.key.loc.start,
      );
    }
    pushClassAccessorProperty(classBody, prop, isPrivate) {
      if (!isPrivate && !prop.computed) {
        const key = prop.key;
        if (key.name === "constructor" || key.value === "constructor") {
          this.raise(Errors.ConstructorClassField, key);
        }
      }
      const node = this.parseClassAccessorProperty(prop);
      classBody.body.push(node);
      if (isPrivate) {
        this.classScope.declarePrivateName(
          this.getPrivateNameSV(node.key),
          0,
          node.key.loc.start,
        );
      }
    }
    pushClassMethod(
      classBody,
      method,
      isGenerator,
      isAsync,
      isConstructor,
      allowsDirectSuper,
    ) {
      classBody.body.push(
        this.parseMethod(
          method,
          isGenerator,
          isAsync,
          isConstructor,
          allowsDirectSuper,
          "ClassMethod",
          true,
        ),
      );
    }
    pushClassPrivateMethod(classBody, method, isGenerator, isAsync) {
      const node = this.parseMethod(
        method,
        isGenerator,
        isAsync,
        false,
        false,
        "ClassPrivateMethod",
        true,
      );
      classBody.body.push(node);
      const kind =
        node.kind === "get"
          ? node.static
            ? 6
            : 2
          : node.kind === "set"
            ? node.static
              ? 5
              : 1
            : 0;
      this.declareClassPrivateMethodInScope(node, kind);
    }
    declareClassPrivateMethodInScope(node, kind) {
      this.classScope.declarePrivateName(
        this.getPrivateNameSV(node.key),
        kind,
        node.key.loc.start,
      );
    }
    parsePostMemberNameModifiers(methodOrProp) {}
    parseClassPrivateProperty(node) {
      this.parseInitializer(node);
      this.semicolon();
      return this.finishNode(node, "ClassPrivateProperty");
    }
    parseClassProperty(node) {
      this.parseInitializer(node);
      this.semicolon();
      return this.finishNode(node, "ClassProperty");
    }
    parseClassAccessorProperty(node) {
      this.parseInitializer(node);
      this.semicolon();
      return this.finishNode(node, "ClassAccessorProperty");
    }
    parseInitializer(node) {
      this.scope.enter(64 | 16);
      this.expressionScope.enter(newExpressionScope());
      this.prodParam.enter(0);
      node.value = this.eat(29) ? this.parseMaybeAssignAllowIn() : null;
      this.expressionScope.exit();
      this.prodParam.exit();
      this.scope.exit();
    }
    parseClassId(node, isStatement, optionalId, bindingType = 8331) {
      if (tokenIsIdentifier(this.state.type)) {
        node.id = this.parseIdentifier();
        if (isStatement) {
          this.declareNameFromIdentifier(node.id, bindingType);
        }
      } else {
        if (optionalId || !isStatement) {
          node.id = null;
        } else {
          throw this.raise(Errors.MissingClassName, this.state.startLoc);
        }
      }
    }
    parseClassSuper(node) {
      node.superClass = this.eat(81) ? this.parseExprSubscripts() : null;
    }
    parseExport(node, decorators) {
      const maybeDefaultIdentifier = this.parseMaybeImportPhase(node, true);
      const hasDefault = this.maybeParseExportDefaultSpecifier(
        node,
        maybeDefaultIdentifier,
      );
      const parseAfterDefault = !hasDefault || this.eat(12);
      const hasStar = parseAfterDefault && this.eatExportStar(node);
      const hasNamespace =
        hasStar && this.maybeParseExportNamespaceSpecifier(node);
      const parseAfterNamespace =
        parseAfterDefault && (!hasNamespace || this.eat(12));
      const isFromRequired = hasDefault || hasStar;
      if (hasStar && !hasNamespace) {
        if (hasDefault) this.unexpected();
        if (decorators) {
          throw this.raise(Errors.UnsupportedDecoratorExport, node);
        }
        this.parseExportFrom(node, true);
        return this.finishNode(node, "ExportAllDeclaration");
      }
      const hasSpecifiers = this.maybeParseExportNamedSpecifiers(node);
      if (hasDefault && parseAfterDefault && !hasStar && !hasSpecifiers) {
        this.unexpected(null, 5);
      }
      if (hasNamespace && parseAfterNamespace) {
        this.unexpected(null, 98);
      }
      let hasDeclaration;
      if (isFromRequired || hasSpecifiers) {
        hasDeclaration = false;
        if (decorators) {
          throw this.raise(Errors.UnsupportedDecoratorExport, node);
        }
        this.parseExportFrom(node, isFromRequired);
      } else {
        hasDeclaration = this.maybeParseExportDeclaration(node);
      }
      if (isFromRequired || hasSpecifiers || hasDeclaration) {
        var _node2$declaration;
        const node2 = node;
        this.checkExport(node2, true, false, !!node2.source);
        if (
          ((_node2$declaration = node2.declaration) == null
            ? void 0
            : _node2$declaration.type) === "ClassDeclaration"
        ) {
          this.maybeTakeDecorators(decorators, node2.declaration, node2);
        } else if (decorators) {
          throw this.raise(Errors.UnsupportedDecoratorExport, node);
        }
        return this.finishNode(node2, "ExportNamedDeclaration");
      }
      if (this.eat(65)) {
        const node2 = node;
        const decl = this.parseExportDefaultExpression();
        node2.declaration = decl;
        if (decl.type === "ClassDeclaration") {
          this.maybeTakeDecorators(decorators, decl, node2);
        } else if (decorators) {
          throw this.raise(Errors.UnsupportedDecoratorExport, node);
        }
        this.checkExport(node2, true, true);
        return this.finishNode(node2, "ExportDefaultDeclaration");
      }
      this.unexpected(null, 5);
    }
    eatExportStar(node) {
      return this.eat(55);
    }
    maybeParseExportDefaultSpecifier(node, maybeDefaultIdentifier) {
      if (maybeDefaultIdentifier || this.isExportDefaultSpecifier()) {
        this.expectPlugin(
          "exportDefaultFrom",
          maybeDefaultIdentifier == null
            ? void 0
            : maybeDefaultIdentifier.loc.start,
        );
        const id = maybeDefaultIdentifier || this.parseIdentifier(true);
        const specifier = this.startNodeAtNode(id);
        specifier.exported = id;
        node.specifiers = [
          this.finishNode(specifier, "ExportDefaultSpecifier"),
        ];
        return true;
      }
      return false;
    }
    maybeParseExportNamespaceSpecifier(node) {
      if (this.isContextual(93)) {
        if (!node.specifiers) node.specifiers = [];
        const specifier = this.startNodeAt(this.state.lastTokStartLoc);
        this.next();
        specifier.exported = this.parseModuleExportName();
        node.specifiers.push(
          this.finishNode(specifier, "ExportNamespaceSpecifier"),
        );
        return true;
      }
      return false;
    }
    maybeParseExportNamedSpecifiers(node) {
      if (this.match(5)) {
        if (!node.specifiers) node.specifiers = [];
        const isTypeExport = node.exportKind === "type";
        node.specifiers.push(...this.parseExportSpecifiers(isTypeExport));
        node.source = null;
        node.declaration = null;
        if (this.hasPlugin("importAssertions")) {
          node.assertions = [];
        }
        return true;
      }
      return false;
    }
    maybeParseExportDeclaration(node) {
      if (this.shouldParseExportDeclaration()) {
        node.specifiers = [];
        node.source = null;
        if (this.hasPlugin("importAssertions")) {
          node.assertions = [];
        }
        node.declaration = this.parseExportDeclaration(node);
        return true;
      }
      return false;
    }
    isAsyncFunction() {
      if (!this.isContextual(95)) return false;
      const next = this.nextTokenInLineStart();
      return this.isUnparsedContextual(next, "function");
    }
    parseExportDefaultExpression() {
      const expr = this.startNode();
      if (this.match(68)) {
        this.next();
        return this.parseFunction(expr, 1 | 4);
      } else if (this.isAsyncFunction()) {
        this.next();
        this.next();
        return this.parseFunction(expr, 1 | 4 | 8);
      }
      if (this.match(80)) {
        return this.parseClass(expr, true, true);
      }
      if (this.match(26)) {
        if (
          this.hasPlugin("decorators") &&
          this.getPluginOption("decorators", "decoratorsBeforeExport") === true
        ) {
          this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
        }
        return this.parseClass(
          this.maybeTakeDecorators(
            this.parseDecorators(false),
            this.startNode(),
          ),
          true,
          true,
        );
      }
      if (this.match(75) || this.match(74) || this.isLet()) {
        throw this.raise(Errors.UnsupportedDefaultExport, this.state.startLoc);
      }
      const res = this.parseMaybeAssignAllowIn();
      this.semicolon();
      return res;
    }
    parseExportDeclaration(node) {
      if (this.match(80)) {
        const node = this.parseClass(this.startNode(), true, false);
        return node;
      }
      return this.parseStatementListItem();
    }
    isExportDefaultSpecifier() {
      const { type: type } = this.state;
      if (tokenIsIdentifier(type)) {
        if ((type === 95 && !this.state.containsEsc) || type === 100) {
          return false;
        }
        if ((type === 130 || type === 129) && !this.state.containsEsc) {
          const { type: nextType } = this.lookahead();
          if (
            (tokenIsIdentifier(nextType) && nextType !== 98) ||
            nextType === 5
          ) {
            this.expectOnePlugin(["flow", "typescript"]);
            return false;
          }
        }
      } else if (!this.match(65)) {
        return false;
      }
      const next = this.nextTokenStart();
      const hasFrom = this.isUnparsedContextual(next, "from");
      if (
        this.input.charCodeAt(next) === 44 ||
        (tokenIsIdentifier(this.state.type) && hasFrom)
      ) {
        return true;
      }
      if (this.match(65) && hasFrom) {
        const nextAfterFrom = this.input.charCodeAt(
          this.nextTokenStartSince(next + 4),
        );
        return nextAfterFrom === 34 || nextAfterFrom === 39;
      }
      return false;
    }
    parseExportFrom(node, expect) {
      if (this.eatContextual(98)) {
        node.source = this.parseImportSource();
        this.checkExport(node);
        this.maybeParseImportAttributes(node);
        this.checkJSONModuleImport(node);
      } else if (expect) {
        this.unexpected();
      }
      this.semicolon();
    }
    shouldParseExportDeclaration() {
      const { type: type } = this.state;
      if (type === 26) {
        this.expectOnePlugin(["decorators", "decorators-legacy"]);
        if (this.hasPlugin("decorators")) {
          if (
            this.getPluginOption("decorators", "decoratorsBeforeExport") ===
            true
          ) {
            this.raise(Errors.DecoratorBeforeExport, this.state.startLoc);
          }
          return true;
        }
      }
      return (
        type === 74 ||
        type === 75 ||
        type === 68 ||
        type === 80 ||
        this.isLet() ||
        this.isAsyncFunction()
      );
    }
    checkExport(node, checkNames, isDefault, isFrom) {
      if (checkNames) {
        var _node$specifiers;
        if (isDefault) {
          this.checkDuplicateExports(node, "default");
          if (this.hasPlugin("exportDefaultFrom")) {
            var _declaration$extra;
            const declaration = node.declaration;
            if (
              declaration.type === "Identifier" &&
              declaration.name === "from" &&
              declaration.end - declaration.start === 4 &&
              !(
                (_declaration$extra = declaration.extra) != null &&
                _declaration$extra.parenthesized
              )
            ) {
              this.raise(Errors.ExportDefaultFromAsIdentifier, declaration);
            }
          }
        } else if (
          (_node$specifiers = node.specifiers) != null &&
          _node$specifiers.length
        ) {
          for (const specifier of node.specifiers) {
            const { exported: exported } = specifier;
            const exportName =
              exported.type === "Identifier" ? exported.name : exported.value;
            this.checkDuplicateExports(specifier, exportName);
            if (!isFrom && specifier.local) {
              const { local: local } = specifier;
              if (local.type !== "Identifier") {
                this.raise(Errors.ExportBindingIsString, specifier, {
                  localName: local.value,
                  exportName: exportName,
                });
              } else {
                this.checkReservedWord(
                  local.name,
                  local.loc.start,
                  true,
                  false,
                );
                this.scope.checkLocalExport(local);
              }
            }
          }
        } else if (node.declaration) {
          if (
            node.declaration.type === "FunctionDeclaration" ||
            node.declaration.type === "ClassDeclaration"
          ) {
            const id = node.declaration.id;
            if (!id) throw new Error("Assertion failure");
            this.checkDuplicateExports(node, id.name);
          } else if (node.declaration.type === "VariableDeclaration") {
            for (const declaration of node.declaration.declarations) {
              this.checkDeclaration(declaration.id);
            }
          }
        }
      }
    }
    checkDeclaration(node) {
      if (node.type === "Identifier") {
        this.checkDuplicateExports(node, node.name);
      } else if (node.type === "ObjectPattern") {
        for (const prop of node.properties) {
          this.checkDeclaration(prop);
        }
      } else if (node.type === "ArrayPattern") {
        for (const elem of node.elements) {
          if (elem) {
            this.checkDeclaration(elem);
          }
        }
      } else if (node.type === "ObjectProperty") {
        this.checkDeclaration(node.value);
      } else if (node.type === "RestElement") {
        this.checkDeclaration(node.argument);
      } else if (node.type === "AssignmentPattern") {
        this.checkDeclaration(node.left);
      }
    }
    checkDuplicateExports(node, exportName) {
      if (this.exportedIdentifiers.has(exportName)) {
        if (exportName === "default") {
          this.raise(Errors.DuplicateDefaultExport, node);
        } else {
          this.raise(Errors.DuplicateExport, node, { exportName: exportName });
        }
      }
      this.exportedIdentifiers.add(exportName);
    }
    parseExportSpecifiers(isInTypeExport) {
      const nodes = [];
      let first = true;
      this.expect(5);
      while (!this.eat(8)) {
        if (first) {
          first = false;
        } else {
          this.expect(12);
          if (this.eat(8)) break;
        }
        const isMaybeTypeOnly = this.isContextual(130);
        const isString = this.match(133);
        const node = this.startNode();
        node.local = this.parseModuleExportName();
        nodes.push(
          this.parseExportSpecifier(
            node,
            isString,
            isInTypeExport,
            isMaybeTypeOnly,
          ),
        );
      }
      return nodes;
    }
    parseExportSpecifier(node, isString, isInTypeExport, isMaybeTypeOnly) {
      if (this.eatContextual(93)) {
        node.exported = this.parseModuleExportName();
      } else if (isString) {
        node.exported = cloneStringLiteral(node.local);
      } else if (!node.exported) {
        node.exported = cloneIdentifier(node.local);
      }
      return this.finishNode(node, "ExportSpecifier");
    }
    parseModuleExportName() {
      if (this.match(133)) {
        const result = this.parseStringLiteral(this.state.value);
        const surrogate = result.value.match(loneSurrogate);
        if (surrogate) {
          this.raise(Errors.ModuleExportNameHasLoneSurrogate, result, {
            surrogateCharCode: surrogate[0].charCodeAt(0),
          });
        }
        return result;
      }
      return this.parseIdentifier(true);
    }
    isJSONModuleImport(node) {
      if (node.assertions != null) {
        return node.assertions.some(
          ({ key: key, value: value }) =>
            value.value === "json" &&
            (key.type === "Identifier"
              ? key.name === "type"
              : key.value === "type"),
        );
      }
      return false;
    }
    checkImportReflection(node) {
      const { specifiers: specifiers } = node;
      const singleBindingType =
        specifiers.length === 1 ? specifiers[0].type : null;
      if (node.phase === "source") {
        if (singleBindingType !== "ImportDefaultSpecifier") {
          this.raise(
            Errors.SourcePhaseImportRequiresDefault,
            specifiers[0].loc.start,
          );
        }
      } else if (node.phase === "defer") {
        if (singleBindingType !== "ImportNamespaceSpecifier") {
          this.raise(
            Errors.DeferImportRequiresNamespace,
            specifiers[0].loc.start,
          );
        }
      } else if (node.module) {
        var _node$assertions;
        if (singleBindingType !== "ImportDefaultSpecifier") {
          this.raise(
            Errors.ImportReflectionNotBinding,
            specifiers[0].loc.start,
          );
        }
        if (
          ((_node$assertions = node.assertions) == null
            ? void 0
            : _node$assertions.length) > 0
        ) {
          this.raise(
            Errors.ImportReflectionHasAssertion,
            specifiers[0].loc.start,
          );
        }
      }
    }
    checkJSONModuleImport(node) {
      if (
        this.isJSONModuleImport(node) &&
        node.type !== "ExportAllDeclaration"
      ) {
        const { specifiers: specifiers } = node;
        if (specifiers != null) {
          const nonDefaultNamedSpecifier = specifiers.find((specifier) => {
            let imported;
            if (specifier.type === "ExportSpecifier") {
              imported = specifier.local;
            } else if (specifier.type === "ImportSpecifier") {
              imported = specifier.imported;
            }
            if (imported !== undefined) {
              return imported.type === "Identifier"
                ? imported.name !== "default"
                : imported.value !== "default";
            }
          });
          if (nonDefaultNamedSpecifier !== undefined) {
            this.raise(
              Errors.ImportJSONBindingNotDefault,
              nonDefaultNamedSpecifier.loc.start,
            );
          }
        }
      }
    }
    isPotentialImportPhase(isExport) {
      if (isExport) return false;
      return (
        this.isContextual(105) ||
        this.isContextual(97) ||
        this.isContextual(127)
      );
    }
    applyImportPhase(node, isExport, phase, loc) {
      if (isExport) {
        return;
      }
      if (phase === "module") {
        this.expectPlugin("importReflection", loc);
        node.module = true;
      } else if (this.hasPlugin("importReflection")) {
        node.module = false;
      }
      if (phase === "source") {
        this.expectPlugin("sourcePhaseImports", loc);
        node.phase = "source";
      } else if (phase === "defer") {
        this.expectPlugin("deferredImportEvaluation", loc);
        node.phase = "defer";
      } else if (this.hasPlugin("sourcePhaseImports")) {
        node.phase = null;
      }
    }
    parseMaybeImportPhase(node, isExport) {
      if (!this.isPotentialImportPhase(isExport)) {
        this.applyImportPhase(node, isExport, null);
        return null;
      }
      const phaseIdentifier = this.parseIdentifier(true);
      const { type: type } = this.state;
      const isImportPhase = tokenIsKeywordOrIdentifier(type)
        ? type !== 98 || this.lookaheadCharCode() === 102
        : type !== 12;
      if (isImportPhase) {
        this.resetPreviousIdentifierLeadingComments(phaseIdentifier);
        this.applyImportPhase(
          node,
          isExport,
          phaseIdentifier.name,
          phaseIdentifier.loc.start,
        );
        return null;
      } else {
        this.applyImportPhase(node, isExport, null);
        return phaseIdentifier;
      }
    }
    isPrecedingIdImportPhase(phase) {
      const { type: type } = this.state;
      return tokenIsIdentifier(type)
        ? type !== 98 || this.lookaheadCharCode() === 102
        : type !== 12;
    }
    parseImport(node) {
      if (this.match(133)) {
        return this.parseImportSourceAndAttributes(node);
      }
      return this.parseImportSpecifiersAndAfter(
        node,
        this.parseMaybeImportPhase(node, false),
      );
    }
    parseImportSpecifiersAndAfter(node, maybeDefaultIdentifier) {
      node.specifiers = [];
      const hasDefault = this.maybeParseDefaultImportSpecifier(
        node,
        maybeDefaultIdentifier,
      );
      const parseNext = !hasDefault || this.eat(12);
      const hasStar = parseNext && this.maybeParseStarImportSpecifier(node);
      if (parseNext && !hasStar) this.parseNamedImportSpecifiers(node);
      this.expectContextual(98);
      return this.parseImportSourceAndAttributes(node);
    }
    parseImportSourceAndAttributes(node) {
      var _node$specifiers2;
      (_node$specifiers2 = node.specifiers) != null
        ? _node$specifiers2
        : (node.specifiers = []);
      node.source = this.parseImportSource();
      this.maybeParseImportAttributes(node);
      this.checkImportReflection(node);
      this.checkJSONModuleImport(node);
      this.semicolon();
      return this.finishNode(node, "ImportDeclaration");
    }
    parseImportSource() {
      if (!this.match(133)) this.unexpected();
      return this.parseExprAtom();
    }
    parseImportSpecifierLocal(node, specifier, type) {
      specifier.local = this.parseIdentifier();
      node.specifiers.push(this.finishImportSpecifier(specifier, type));
    }
    finishImportSpecifier(specifier, type, bindingType = 8201) {
      this.checkLVal(specifier.local, {
        in: { type: type },
        binding: bindingType,
      });
      return this.finishNode(specifier, type);
    }
    parseImportAttributes() {
      this.expect(5);
      const attrs = [];
      const attrNames = new Set();
      do {
        if (this.match(8)) {
          break;
        }
        const node = this.startNode();
        const keyName = this.state.value;
        if (attrNames.has(keyName)) {
          this.raise(
            Errors.ModuleAttributesWithDuplicateKeys,
            this.state.startLoc,
            { key: keyName },
          );
        }
        attrNames.add(keyName);
        if (this.match(133)) {
          node.key = this.parseStringLiteral(keyName);
        } else {
          node.key = this.parseIdentifier(true);
        }
        this.expect(14);
        if (!this.match(133)) {
          throw this.raise(
            Errors.ModuleAttributeInvalidValue,
            this.state.startLoc,
          );
        }
        node.value = this.parseStringLiteral(this.state.value);
        attrs.push(this.finishNode(node, "ImportAttribute"));
      } while (this.eat(12));
      this.expect(8);
      return attrs;
    }
    parseModuleAttributes() {
      const attrs = [];
      const attributes = new Set();
      do {
        const node = this.startNode();
        node.key = this.parseIdentifier(true);
        if (node.key.name !== "type") {
          this.raise(Errors.ModuleAttributeDifferentFromType, node.key);
        }
        if (attributes.has(node.key.name)) {
          this.raise(Errors.ModuleAttributesWithDuplicateKeys, node.key, {
            key: node.key.name,
          });
        }
        attributes.add(node.key.name);
        this.expect(14);
        if (!this.match(133)) {
          throw this.raise(
            Errors.ModuleAttributeInvalidValue,
            this.state.startLoc,
          );
        }
        node.value = this.parseStringLiteral(this.state.value);
        attrs.push(this.finishNode(node, "ImportAttribute"));
      } while (this.eat(12));
      return attrs;
    }
    maybeParseImportAttributes(node) {
      let attributes;
      let useWith = false;
      if (this.match(76)) {
        if (this.hasPrecedingLineBreak() && this.lookaheadCharCode() === 40) {
          return;
        }
        this.next();
        {
          if (this.hasPlugin("moduleAttributes")) {
            attributes = this.parseModuleAttributes();
          } else {
            this.expectImportAttributesPlugin();
            attributes = this.parseImportAttributes();
          }
        }
        useWith = true;
      } else if (this.isContextual(94) && !this.hasPrecedingLineBreak()) {
        if (this.hasPlugin("importAttributes")) {
          if (
            this.getPluginOption(
              "importAttributes",
              "deprecatedAssertSyntax",
            ) !== true
          ) {
            this.raise(Errors.ImportAttributesUseAssert, this.state.startLoc);
          }
          this.addExtra(node, "deprecatedAssertSyntax", true);
        } else {
          this.expectOnePlugin(["importAttributes", "importAssertions"]);
        }
        this.next();
        attributes = this.parseImportAttributes();
      } else if (
        this.hasPlugin("importAttributes") ||
        this.hasPlugin("importAssertions")
      ) {
        attributes = [];
      } else {
        if (this.hasPlugin("moduleAttributes")) {
          attributes =