import type { ActionFunction, ActionFunctionArgs, LoaderFunction, LoaderFunctionArgs } from "./routeModules";
/**
 * An object of unknown type for route loaders and actions provided by the
 * server's `getLoadContext()` function.  This is defined as an empty interface
 * specifically so apps can leverage declaration merging to augment this type
 * globally: https://www.typescriptlang.org/docs/handbook/declaration-merging.html
 */
export interface AppLoadContext {
    [key: string]: unknown;
}
/**
 * Data for a route that was returned from a `loader()`.
 */
export type AppData = unknown;
export declare function callRouteAction({ loadContext, action, params, request, routeId, singleFetch, }: {
    request: Request;
    action: ActionFunction;
    params: ActionFunctionArgs["params"];
    loadContext: AppLoadContext;
    routeId: string;
    singleFetch: boolean;
}): Promise<{} | Response | null>;
export declare function callRouteLoader({ loadContext, loader, params, request, routeId, singleFetch, }: {
    request: Request;
    loader: LoaderFunction;
    params: LoaderFunctionArgs["params"];
    loadContext: AppLoadContext;
    routeId: string;
    singleFetch: boolean;
}): Promise<{} | Response | null>;
