import React, { PropsWithChildren } from 'react';
import Themes from '../Utilities/Themes';
import Translations from '../Utilities/Translations';
export declare enum CalendarType {
    Gregorian = 0,
    Jalali = 1
}
export declare enum DateTimePickerMode {
    Date = 0,
    Time = 1,
    DateTime = 2
}
export declare enum PickerMode {
    Day = 0,
    Year = 1,
    Hour = 2,
    Minute = 3
}
interface DateTimePickerState {
    year: number;
    month: number;
    selectedDate: Date;
    calendar: CalendarType;
    persianNumber: boolean;
    pickerMode: PickerMode;
    theme: typeof Themes.Primary;
    translation: typeof Translations.DEFAULT;
}
export interface IDateTimePickerProvider extends DateTimePickerState {
    setYear: (year: number) => void;
    setMonth: (month: number) => void;
    setHour: (minute: number) => void;
    setMinute: (minute: number) => void;
    setSelectedDate: (date: Date) => void;
    setPickerMode: (mode: PickerMode) => void;
    setYearMonth: (year: number, month: number) => void;
}
export declare const DateTimePickerContext: React.Context<IDateTimePickerProvider>;
interface Props extends PropsWithChildren {
    initialDate?: Date;
    persianNumber?: boolean;
    calendar?: CalendarType;
    mode?: PickerMode;
    theme?: typeof Themes.Primary;
    translation?: typeof Translations.DEFAULT;
}
declare const DateTimePickerProvider: React.FC<Props>;
export default DateTimePickerProvider;
