import { StyleSheet } from "react-native";
export default StyleSheet.create({
    container: {
        alignItems: "center",
        flexDirection: "row",
    },
    iconImageStyle: {
        width: 10,
        height: 10,
    },
    textContainer: {
        flex: 1,
        marginLeft: 16,
    },
    iconContainer: (size, checked, fillColor, unFillColor) => ({
        width: size,
        height: size,
        borderRadius: size / 2,
        backgroundColor: checked ? fillColor : unFillColor,
        alignItems: "center",
        justifyContent: "center",
    }),
    innerIconContainer: (size, fillColor) => ({
        width: size,
        height: size,
        borderWidth: 1,
        borderColor: fillColor,
        borderRadius: size / 2,
        alignItems: "center",
        justifyContent: "center",
    }),
    textStyle: (checked) => ({
        fontSize: 16,
        color: "#757575",
        textDecorationLine: checked ? "line-through" : "none",
    }),
});
//# sourceMappingURL=BouncyCheckbox.style.js.map