import * as React from "react";
import { ViewStyle, StyleProp, PressableProps } from "react-native";
declare type CustomStyleProp = StyleProp<ViewStyle> | Array<StyleProp<ViewStyle>>;
export interface IRNBounceableProps extends PressableProps {
    onPress?: () => void;
    bounceEffectIn?: number;
    bounceEffectOut?: number;
    bounceVelocityIn?: number;
    bounceVelocityOut?: number;
    bouncinessIn?: number;
    bouncinessOut?: number;
    useNativeDriver?: boolean;
    children?: React.ReactNode;
    style?: CustomStyleProp;
}
interface IState {
    bounceValue: any;
}
export default class RNBounceable extends React.Component<IRNBounceableProps, IState> {
    constructor(props: IRNBounceableProps);
    bounceAnimation: (value: number, velocity: number, bounciness: number) => void;
    render(): JSX.Element;
}
export {};
