import React, { useMemo, useRef } from 'react';
import styles from './styles';
import Buttons from '../Components/Buttons';
import DayPicker from '../Components/DayPicker';
import YearPicker from '../Components/YearPicker';
import TimePicker from '../Components/TimePicker';
import DateHeader from '../Components/DateHeader';
import useDateTimePicker from '../Hooks/useDateTimePicker';
import { Animated, Modal, Pressable, View } from 'react-native';
import { CalendarType, DateTimePickerMode, PickerMode, } from '../Providers/DateTimePickerProvider';
import { convertGregorianToJalali, convertJalaliToGregorian, toPersianNumber, } from '../Utilities';
export default function GlobalDateTimePickerModal({ visible, onCancel, onSelect, mode, }) {
    const { pickerMode, calendar, selectedDate, persianNumber, setSelectedDate, setPickerMode, theme, } = useDateTimePicker();
    const fadeAnim = useRef(new Animated.Value(1)).current;
    const years = useMemo(() => Array.from({ length: 200 }, (_, k) => k + 1)
        .map((v) => v + (calendar === CalendarType.Gregorian ? 1900 : 1300))
        .map((i) => {
        return {
            value: i,
            label: persianNumber ? toPersianNumber(`${i}`) : `${i}`,
        };
    }), [calendar]);
    const onPressDay = (value) => {
        setSelectedDate(value);
    };
    const cancel = () => {
        if (onCancel)
            onCancel();
    };
    const onOk = () => {
        if (mode === DateTimePickerMode.DateTime && pickerMode === PickerMode.Day)
            setPickerMode(PickerMode.Hour);
        else {
            setPickerMode(mode === DateTimePickerMode.Time ? PickerMode.Hour : PickerMode.Day);
            if (onSelect) {
                if (calendar === CalendarType.Jalali)
                    onSelect(convertJalaliToGregorian(selectedDate), selectedDate);
                else
                    onSelect(selectedDate, convertGregorianToJalali(selectedDate));
            }
        }
    };
    let content = null;
    if (pickerMode == PickerMode.Day || pickerMode == PickerMode.Year) {
        let picker;
        switch (pickerMode) {
            case PickerMode.Day:
                picker = React.createElement(DayPicker, { onPressDay: onPressDay });
                break;
            case PickerMode.Year:
                picker = React.createElement(YearPicker, { years: years });
                break;
        }
        content = (React.createElement(React.Fragment, null,
            React.createElement(DateHeader, null),
            React.createElement(View, { style: [styles.content, { backgroundColor: theme.ContentBackground }] },
                React.createElement(Animated.View, { style: {
                        opacity: fadeAnim,
                    } }, picker),
                React.createElement(Buttons, { onOk: onOk, onCancel: cancel }))));
    }
    if (pickerMode == PickerMode.Hour || pickerMode == PickerMode.Minute) {
        content = (React.createElement(React.Fragment, null,
            React.createElement(TimePicker, null),
            React.createElement(View, { style: [styles.content, { backgroundColor: theme.ContentBackground }] },
                React.createElement(Buttons, { onOk: onOk, onCancel: cancel }))));
    }
    return (React.createElement(Modal, { visible: visible, transparent: true, onDismiss: cancel, animationType: "fade", onRequestClose: cancel },
        React.createElement(Pressable, { onPress: cancel, style: styles.container_pressable },
            React.createElement(View, { style: styles.container },
                React.createElement(Pressable, null, content)))));
}
//# sourceMappingURL=index.js.map