import React from 'react';
import { CalendarType, DateTimePickerMode } from './Providers/DateTimePickerProvider';
import Themes from './Utilities/Themes';
import Translations from './Utilities/Translations';
export interface Props {
    visible: boolean;
    initialDate?: Date;
    onCancel?: () => void;
    persianNumber?: boolean;
    calendar?: CalendarType;
    mode?: DateTimePickerMode;
    theme?: typeof Themes.Primary;
    translation?: typeof Translations.DEFAULT;
    onSelect?: (gregorianDate: Date, jalaliDate: Date) => void;
}
export default function GlobalDateTimePicker({ mode, theme, calendar, initialDate, translation, persianNumber, ...props }: Props): React.JSX.Element;
