module.exports = {
  AIRMapCalloutManager: {},
  AIRMapCalloutSubviewManager: {},
  AIRMapCircleManager: {},
  AIRMapLocalTileManager: {},
  AIRMapManager: {
    animateCamera: { type: 'function', functionType: 'async' },
    animateToRegion: { type: 'function', functionType: 'async' },
    coordinateForPoint: { type: 'function', functionType: 'promise' },
    fitToCoordinates: { type: 'function', functionType: 'async' },
    fitToElements: { type: 'function', functionType: 'async' },
    fitToSuppliedMarkers: { type: 'function', functionType: 'async' },
    getAddressFromCoordinates: { type: 'function', functionType: 'promise' },
    getCamera: { type: 'function', functionType: 'promise' },
    getConstants: { type: 'function' },
    getMapBoundaries: { type: 'function', functionType: 'promise' },
    getMarkersFrames: { type: 'function', functionType: 'promise' },
    pointForCoordinate: { type: 'function', functionType: 'promise' },
    setCamera: { type: 'function', functionType: 'async' },
    takeSnapshot: { type: 'function', functionType: 'async' },
  },
  AIRMapMarkerManager: {
    getConstants: { type: 'function' },
    hideCallout: { type: 'function', functionType: 'async' },
    redrawCallout: { type: 'function', functionType: 'async' },
    showCallout: { type: 'function', functionType: 'async' },
  },
  AIRMapOverlayManager: {},
  AIRMapPolygonManager: {},
  AIRMapPolylineManager: {},
  AIRMapUrlTileManager: {},
  AIRMapWMSTileManager: {},
  ExpoModulesCore: {
    getConstants: { type: 'function' },
    installModules: { type: 'function', functionType: 'sync' },
  },
  'ExpoModulesCore.ViewModuleWrapper': {},
  ExpoNativeModuleIntrospection: {
    getConstants: { type: 'function' },
    getNativeModuleNamesAsync: { type: 'function', functionType: 'promise' },
    introspectNativeModuleAsync: { type: 'function', functionType: 'promise' },
  },
  ExponentScopedModuleRegistry: {},
  ExponentTest: {
    action: { type: 'function', functionType: 'promise' },
    completed: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    isInCI: { type: 'number', mock: 0 },
    log: { type: 'function', functionType: 'async' },
    shouldSkipTestsRequiringPermissionsAsync: { type: 'function', functionType: 'promise' },
  },
  ExponentUtil: {},
  LottieAnimationView: {
    getConstants: { type: 'function' },
    pause: { type: 'function', functionType: 'async' },
    play: { type: 'function', functionType: 'async' },
    reset: { type: 'function', functionType: 'async' },
    resume: { type: 'function', functionType: 'async' },
    VERSION: { type: 'number', mock: 1 },
  },
  NativeUnimoduleProxy: {
    callMethod: { type: 'function', functionType: 'promise' },
    exportedMethods: {
      type: 'object',
      mock: {
        '': [],
        EASClient: [],
        ExpoAppleAuthentication: [
          { name: 'getCredentialStateAsync', argumentsCount: 1, key: 'getCredentialStateAsync' },
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'requestAsync', argumentsCount: 1, key: 'requestAsync' },
        ],
        ExpoApplication: [
          {
            name: 'getApplicationReleaseTypeAsync',
            argumentsCount: 0,
            key: 'getApplicationReleaseTypeAsync',
          },
          { name: 'getInstallationTimeAsync', argumentsCount: 0, key: 'getInstallationTimeAsync' },
          { name: 'getIosIdForVendorAsync', argumentsCount: 0, key: 'getIosIdForVendorAsync' },
          {
            name: 'getPushNotificationServiceEnvironmentAsync',
            argumentsCount: 0,
            key: 'getPushNotificationServiceEnvironmentAsync',
          },
        ],
        ExpoAsset: [{ name: 'downloadAsync', argumentsCount: 3, key: 'downloadAsync' }],
        ExpoAudio: [
          { name: 'setCategory', argumentsCount: 1, key: 'setCategory' },
          { name: 'setIsAudioActive', argumentsCount: 1, key: 'setIsAudioActive' },
        ],
        ExpoBackgroundFetch: [
          { name: 'getStatusAsync', argumentsCount: 0, key: 'getStatusAsync' },
          { name: 'registerTaskAsync', argumentsCount: 2, key: 'registerTaskAsync' },
          { name: 'setMinimumIntervalAsync', argumentsCount: 1, key: 'setMinimumIntervalAsync' },
          { name: 'unregisterTaskAsync', argumentsCount: 1, key: 'unregisterTaskAsync' },
        ],
        ExpoBackgroundNotificationTasksModule: [
          { name: 'unregisterTaskAsync', argumentsCount: 1, key: 0 },
          { name: 'registerTaskAsync', argumentsCount: 1, key: 1 },
        ],
        ExpoBadgeModule: [
          { name: 'setBadgeCountAsync', argumentsCount: 1, key: 0 },
          { name: 'getBadgeCountAsync', argumentsCount: 0, key: 1 },
        ],
        ExpoBarCodeScanner: [
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
          { name: 'scanFromURLAsync', argumentsCount: 2, key: 'scanFromURLAsync' },
        ],
        ExpoBarometer: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExpoBattery: [
          { name: 'getBatteryLevelAsync', argumentsCount: 0, key: 'getBatteryLevelAsync' },
          { name: 'getBatteryStateAsync', argumentsCount: 0, key: 'getBatteryStateAsync' },
          {
            name: 'isLowPowerModeEnabledAsync',
            argumentsCount: 0,
            key: 'isLowPowerModeEnabledAsync',
          },
        ],
        ExpoBlurView: [],
        ExpoBrightness: [
          { name: 'getBrightnessAsync', argumentsCount: 0, key: 'getBrightnessAsync' },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          { name: 'getSystemBrightnessAsync', argumentsCount: 0, key: 'getSystemBrightnessAsync' },
          {
            name: 'getSystemBrightnessModeAsync',
            argumentsCount: 0,
            key: 'getSystemBrightnessModeAsync',
          },
          {
            name: 'isUsingSystemBrightnessAsync',
            argumentsCount: 0,
            key: 'isUsingSystemBrightnessAsync',
          },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
          { name: 'setBrightnessAsync', argumentsCount: 1, key: 'setBrightnessAsync' },
          { name: 'setSystemBrightnessAsync', argumentsCount: 0, key: 'setSystemBrightnessAsync' },
          {
            name: 'setSystemBrightnessModeAsync',
            argumentsCount: 0,
            key: 'setSystemBrightnessModeAsync',
          },
          { name: 'useSystemBrightnessAsync', argumentsCount: 0, key: 'useSystemBrightnessAsync' },
        ],
        ExpoCalendar: [
          { name: 'deleteCalendarAsync', argumentsCount: 1, key: 'deleteCalendarAsync' },
          { name: 'deleteEventAsync', argumentsCount: 2, key: 'deleteEventAsync' },
          { name: 'deleteReminderAsync', argumentsCount: 1, key: 'deleteReminderAsync' },
          {
            name: 'getAttendeesForEventAsync',
            argumentsCount: 1,
            key: 'getAttendeesForEventAsync',
          },
          {
            name: 'getCalendarPermissionsAsync',
            argumentsCount: 0,
            key: 'getCalendarPermissionsAsync',
          },
          { name: 'getCalendarsAsync', argumentsCount: 1, key: 'getCalendarsAsync' },
          { name: 'getDefaultCalendarAsync', argumentsCount: 0, key: 'getDefaultCalendarAsync' },
          { name: 'getEventByIdAsync', argumentsCount: 2, key: 'getEventByIdAsync' },
          { name: 'getEventsAsync', argumentsCount: 3, key: 'getEventsAsync' },
          { name: 'getReminderByIdAsync', argumentsCount: 1, key: 'getReminderByIdAsync' },
          { name: 'getRemindersAsync', argumentsCount: 4, key: 'getRemindersAsync' },
          {
            name: 'getRemindersPermissionsAsync',
            argumentsCount: 0,
            key: 'getRemindersPermissionsAsync',
          },
          { name: 'getSourceByIdAsync', argumentsCount: 1, key: 'getSourceByIdAsync' },
          { name: 'getSourcesAsync', argumentsCount: 0, key: 'getSourcesAsync' },
          {
            name: 'requestCalendarPermissionsAsync',
            argumentsCount: 0,
            key: 'requestCalendarPermissionsAsync',
          },
          {
            name: 'requestRemindersPermissionsAsync',
            argumentsCount: 0,
            key: 'requestRemindersPermissionsAsync',
          },
          { name: 'saveCalendarAsync', argumentsCount: 1, key: 'saveCalendarAsync' },
          { name: 'saveEventAsync', argumentsCount: 2, key: 'saveEventAsync' },
          { name: 'saveReminderAsync', argumentsCount: 1, key: 'saveReminderAsync' },
        ],
        ExpoCamera: [
          { name: 'dismissScanner', argumentsCount: 0, key: 'dismissScanner' },
          {
            name: 'getAvailableVideoCodecsAsync',
            argumentsCount: 0,
            key: 'getAvailableVideoCodecsAsync',
          },
          {
            name: 'getCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'getCameraPermissionsAsync',
          },
          {
            name: 'getMicrophonePermissionsAsync',
            argumentsCount: 0,
            key: 'getMicrophonePermissionsAsync',
          },
          { name: 'launchScanner', argumentsCount: 1, key: 'launchScanner' },
          {
            name: 'requestCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'requestCameraPermissionsAsync',
          },
          {
            name: 'requestMicrophonePermissionsAsync',
            argumentsCount: 0,
            key: 'requestMicrophonePermissionsAsync',
          },
        ],
        ExpoCameraLegacy: [
          { name: 'getAvailablePictureSizes', argumentsCount: 2, key: 'getAvailablePictureSizes' },
          {
            name: 'getAvailableVideoCodecsAsync',
            argumentsCount: 0,
            key: 'getAvailableVideoCodecsAsync',
          },
          {
            name: 'getCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'getCameraPermissionsAsync',
          },
          {
            name: 'getMicrophonePermissionsAsync',
            argumentsCount: 0,
            key: 'getMicrophonePermissionsAsync',
          },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          { name: 'pausePreview', argumentsCount: 1, key: 'pausePreview' },
          { name: 'record', argumentsCount: 2, key: 'record' },
          {
            name: 'requestCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'requestCameraPermissionsAsync',
          },
          {
            name: 'requestMicrophonePermissionsAsync',
            argumentsCount: 0,
            key: 'requestMicrophonePermissionsAsync',
          },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
          { name: 'resumePreview', argumentsCount: 1, key: 'resumePreview' },
          { name: 'stopRecording', argumentsCount: 1, key: 'stopRecording' },
          { name: 'takePicture', argumentsCount: 2, key: 'takePicture' },
        ],
        ExpoCellular: [
          { name: 'allowsVoipAsync', argumentsCount: 0, key: 'allowsVoipAsync' },
          { name: 'getCarrierNameAsync', argumentsCount: 0, key: 'getCarrierNameAsync' },
          {
            name: 'getCellularGenerationAsync',
            argumentsCount: 0,
            key: 'getCellularGenerationAsync',
          },
          { name: 'getIsoCountryCodeAsync', argumentsCount: 0, key: 'getIsoCountryCodeAsync' },
          {
            name: 'getMobileCountryCodeAsync',
            argumentsCount: 0,
            key: 'getMobileCountryCodeAsync',
          },
          {
            name: 'getMobileNetworkCodeAsync',
            argumentsCount: 0,
            key: 'getMobileNetworkCodeAsync',
          },
        ],
        ExpoContacts: [
          { name: 'addContactAsync', argumentsCount: 2, key: 'addContactAsync' },
          {
            name: 'addExistingContactToGroupAsync',
            argumentsCount: 2,
            key: 'addExistingContactToGroupAsync',
          },
          {
            name: 'addExistingGroupToContainerAsync',
            argumentsCount: 2,
            key: 'addExistingGroupToContainerAsync',
          },
          { name: 'createGroupAsync', argumentsCount: 2, key: 'createGroupAsync' },
          { name: 'dismissFormAsync', argumentsCount: 0, key: 'dismissFormAsync' },
          { name: 'getContactsAsync', argumentsCount: 1, key: 'getContactsAsync' },
          { name: 'getContainersAsync', argumentsCount: 1, key: 'getContainersAsync' },
          {
            name: 'getDefaultContainerIdentifierAsync',
            argumentsCount: 0,
            key: 'getDefaultContainerIdentifierAsync',
          },
          { name: 'getGroupsAsync', argumentsCount: 1, key: 'getGroupsAsync' },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          {
            name: 'presentContactPickerAsync',
            argumentsCount: 0,
            key: 'presentContactPickerAsync',
          },
          { name: 'presentFormAsync', argumentsCount: 3, key: 'presentFormAsync' },
          { name: 'removeContactAsync', argumentsCount: 1, key: 'removeContactAsync' },
          {
            name: 'removeContactFromGroupAsync',
            argumentsCount: 2,
            key: 'removeContactFromGroupAsync',
          },
          { name: 'removeGroupAsync', argumentsCount: 1, key: 'removeGroupAsync' },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
          { name: 'updateContactAsync', argumentsCount: 1, key: 'updateContactAsync' },
          { name: 'updateGroupNameAsync', argumentsCount: 2, key: 'updateGroupNameAsync' },
          { name: 'writeContactToFileAsync', argumentsCount: 1, key: 'writeContactToFileAsync' },
        ],
        ExpoDevice: [
          { name: 'getDeviceTypeAsync', argumentsCount: 0, key: 'getDeviceTypeAsync' },
          { name: 'getUptimeAsync', argumentsCount: 0, key: 'getUptimeAsync' },
          {
            name: 'isRootedExperimentalAsync',
            argumentsCount: 0,
            key: 'isRootedExperimentalAsync',
          },
        ],
        ExpoDocumentPicker: [
          { name: 'getDocumentAsync', argumentsCount: 1, key: 'getDocumentAsync' },
        ],
        ExpoFontLoader: [{ name: 'loadAsync', argumentsCount: 2, key: 'loadAsync' }],
        ExpoGo: [],
        ExpoHaptics: [
          { name: 'impactAsync', argumentsCount: 1, key: 'impactAsync' },
          { name: 'notificationAsync', argumentsCount: 1, key: 'notificationAsync' },
          { name: 'selectionAsync', argumentsCount: 0, key: 'selectionAsync' },
        ],
        ExpoHead: [
          { name: 'clearActivitiesAsync', argumentsCount: 1, key: 'clearActivitiesAsync' },
          { name: 'createActivity', argumentsCount: 1, key: 'createActivity' },
          { name: 'getLaunchActivity', argumentsCount: 0, key: 'getLaunchActivity' },
          { name: 'revokeActivity', argumentsCount: 1, key: 'revokeActivity' },
          { name: 'suspendActivity', argumentsCount: 1, key: 'suspendActivity' },
        ],
        ExpoImage: [
          { name: 'clearDiskCache', argumentsCount: 0, key: 'clearDiskCache' },
          { name: 'clearMemoryCache', argumentsCount: 0, key: 'clearMemoryCache' },
          { name: 'generateBlurhashAsync', argumentsCount: 2, key: 'generateBlurhashAsync' },
          { name: 'getCachePathAsync', argumentsCount: 1, key: 'getCachePathAsync' },
          { name: 'prefetch', argumentsCount: 3, key: 'prefetch' },
        ],
        ExpoImageManipulator: [
          { name: 'manipulateAsync', argumentsCount: 3, key: 'manipulateAsync' },
        ],
        ExpoKeepAwake: [
          { name: 'activate', argumentsCount: 1, key: 'activate' },
          { name: 'deactivate', argumentsCount: 1, key: 'deactivate' },
          { name: 'isActivated', argumentsCount: 0, key: 'isActivated' },
        ],
        ExpoLinearGradient: [],
        ExpoLocalAuthentication: [
          { name: 'authenticateAsync', argumentsCount: 1, key: 'authenticateAsync' },
          { name: 'getEnrolledLevelAsync', argumentsCount: 0, key: 'getEnrolledLevelAsync' },
          { name: 'hasHardwareAsync', argumentsCount: 0, key: 'hasHardwareAsync' },
          { name: 'isEnrolledAsync', argumentsCount: 0, key: 'isEnrolledAsync' },
          {
            name: 'supportedAuthenticationTypesAsync',
            argumentsCount: 0,
            key: 'supportedAuthenticationTypesAsync',
          },
        ],
        ExpoLocalization: [
          { name: 'getCalendars', argumentsCount: 0, key: 'getCalendars' },
          { name: 'getLocales', argumentsCount: 0, key: 'getLocales' },
          { name: 'getLocalizationAsync', argumentsCount: 0, key: 'getLocalizationAsync' },
        ],
        ExpoLocation: [
          { name: 'watchPositionImplAsync', argumentsCount: 2, key: 0 },
          { name: 'watchDeviceHeading', argumentsCount: 1, key: 1 },
          { name: 'requestForegroundPermissionsAsync', argumentsCount: 0, key: 2 },
          { name: 'hasServicesEnabledAsync', argumentsCount: 0, key: 3 },
          { name: 'removeWatchAsync', argumentsCount: 1, key: 4 },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 5 },
          { name: 'reverseGeocodeAsync', argumentsCount: 1, key: 6 },
          { name: 'hasStartedGeofencingAsync', argumentsCount: 1, key: 7 },
          { name: 'startLocationUpdatesAsync', argumentsCount: 2, key: 8 },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 9 },
          { name: 'stopGeofencingAsync', argumentsCount: 1, key: 10 },
          { name: 'hasStartedLocationUpdatesAsync', argumentsCount: 1, key: 11 },
          { name: 'getProviderStatusAsync', argumentsCount: 0, key: 12 },
          { name: 'getBackgroundPermissionsAsync', argumentsCount: 0, key: 13 },
          { name: 'geocodeAsync', argumentsCount: 1, key: 14 },
          { name: 'stopLocationUpdatesAsync', argumentsCount: 1, key: 15 },
          { name: 'getLastKnownPositionAsync', argumentsCount: 1, key: 16 },
          { name: 'getForegroundPermissionsAsync', argumentsCount: 0, key: 17 },
          { name: 'getCurrentPositionAsync', argumentsCount: 1, key: 18 },
          { name: 'startGeofencingAsync', argumentsCount: 2, key: 19 },
          { name: 'requestBackgroundPermissionsAsync', argumentsCount: 0, key: 20 },
        ],
        ExpoMailComposer: [
          { name: 'composeAsync', argumentsCount: 1, key: 'composeAsync' },
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
        ],
        ExpoMediaLibrary: [
          { name: 'addAssetsToAlbumAsync', argumentsCount: 2, key: 'addAssetsToAlbumAsync' },
          { name: 'createAlbumAsync', argumentsCount: 2, key: 'createAlbumAsync' },
          { name: 'createAssetAsync', argumentsCount: 1, key: 'createAssetAsync' },
          { name: 'deleteAlbumsAsync', argumentsCount: 2, key: 'deleteAlbumsAsync' },
          { name: 'deleteAssetsAsync', argumentsCount: 1, key: 'deleteAssetsAsync' },
          { name: 'getAlbumAsync', argumentsCount: 1, key: 'getAlbumAsync' },
          { name: 'getAlbumsAsync', argumentsCount: 1, key: 'getAlbumsAsync' },
          { name: 'getAssetInfoAsync', argumentsCount: 2, key: 'getAssetInfoAsync' },
          { name: 'getAssetsAsync', argumentsCount: 1, key: 'getAssetsAsync' },
          { name: 'getMomentsAsync', argumentsCount: 0, key: 'getMomentsAsync' },
          { name: 'getPermissionsAsync', argumentsCount: 1, key: 'getPermissionsAsync' },
          {
            name: 'presentPermissionsPickerAsync',
            argumentsCount: 0,
            key: 'presentPermissionsPickerAsync',
          },
          {
            name: 'removeAssetsFromAlbumAsync',
            argumentsCount: 2,
            key: 'removeAssetsFromAlbumAsync',
          },
          { name: 'requestPermissionsAsync', argumentsCount: 1, key: 'requestPermissionsAsync' },
          { name: 'saveToLibraryAsync', argumentsCount: 1, key: 'saveToLibraryAsync' },
        ],
        ExponentAccelerometer: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExponentAV: [
          { name: 'getStatusForVideo', argumentsCount: 1, key: 0 },
          { name: 'setAudioMode', argumentsCount: 1, key: 1 },
          { name: 'unloadAudioRecorder', argumentsCount: 0, key: 2 },
          { name: 'stopAudioRecording', argumentsCount: 0, key: 3 },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 4 },
          { name: 'setInput', argumentsCount: 1, key: 5 },
          { name: 'loadForVideo', argumentsCount: 3, key: 6 },
          { name: 'setAudioIsEnabled', argumentsCount: 1, key: 7 },
          { name: 'prepareAudioRecorder', argumentsCount: 1, key: 8 },
          { name: 'replayVideo', argumentsCount: 2, key: 9 },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 10 },
          { name: 'unloadForSound', argumentsCount: 1, key: 11 },
          { name: 'setStatusForSound', argumentsCount: 2, key: 12 },
          { name: 'unloadForVideo', argumentsCount: 1, key: 13 },
          { name: 'replaySound', argumentsCount: 2, key: 14 },
          { name: 'getAvailableInputs', argumentsCount: 0, key: 15 },
          { name: 'getAudioRecordingStatus', argumentsCount: 0, key: 16 },
          { name: 'setStatusForVideo', argumentsCount: 2, key: 17 },
          { name: 'loadForSound', argumentsCount: 2, key: 18 },
          { name: 'pauseAudioRecording', argumentsCount: 0, key: 19 },
          { name: 'getStatusForSound', argumentsCount: 1, key: 20 },
          { name: 'getCurrentInput', argumentsCount: 0, key: 21 },
          { name: 'startAudioRecording', argumentsCount: 0, key: 22 },
        ],
        ExponentConstants: [
          { name: 'getWebViewUserAgentAsync', argumentsCount: 0, key: 'getWebViewUserAgentAsync' },
        ],
        ExponentDeviceMotion: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExponentFileSystem: [
          { name: 'copyAsync', argumentsCount: 1, key: 'copyAsync' },
          { name: 'deleteAsync', argumentsCount: 2, key: 'deleteAsync' },
          { name: 'downloadAsync', argumentsCount: 3, key: 'downloadAsync' },
          {
            name: 'downloadResumablePauseAsync',
            argumentsCount: 1,
            key: 'downloadResumablePauseAsync',
          },
          {
            name: 'downloadResumableStartAsync',
            argumentsCount: 5,
            key: 'downloadResumableStartAsync',
          },
          { name: 'getFreeDiskStorageAsync', argumentsCount: 0, key: 'getFreeDiskStorageAsync' },
          { name: 'getInfoAsync', argumentsCount: 2, key: 'getInfoAsync' },
          {
            name: 'getTotalDiskCapacityAsync',
            argumentsCount: 0,
            key: 'getTotalDiskCapacityAsync',
          },
          { name: 'makeDirectoryAsync', argumentsCount: 2, key: 'makeDirectoryAsync' },
          { name: 'moveAsync', argumentsCount: 1, key: 'moveAsync' },
          { name: 'networkTaskCancelAsync', argumentsCount: 1, key: 'networkTaskCancelAsync' },
          { name: 'readAsStringAsync', argumentsCount: 2, key: 'readAsStringAsync' },
          { name: 'readDirectoryAsync', argumentsCount: 1, key: 'readDirectoryAsync' },
          { name: 'uploadAsync', argumentsCount: 3, key: 'uploadAsync' },
          { name: 'uploadTaskStartAsync', argumentsCount: 4, key: 'uploadTaskStartAsync' },
          { name: 'writeAsStringAsync', argumentsCount: 3, key: 'writeAsStringAsync' },
        ],
        ExponentGLObjectManager: [
          { name: 'createContextAsync', argumentsCount: 0, key: 0 },
          { name: 'destroyContextAsync', argumentsCount: 1, key: 1 },
          { name: 'destroyObjectAsync', argumentsCount: 1, key: 2 },
          { name: 'createCameraTextureAsync', argumentsCount: 2, key: 3 },
          { name: 'takeSnapshotAsync', argumentsCount: 2, key: 4 },
        ],
        ExponentGLView: [],
        ExponentGyroscope: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExponentImagePicker: [
          {
            name: 'getCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'getCameraPermissionsAsync',
          },
          {
            name: 'getMediaLibraryPermissionsAsync',
            argumentsCount: 1,
            key: 'getMediaLibraryPermissionsAsync',
          },
          { name: 'launchCameraAsync', argumentsCount: 1, key: 'launchCameraAsync' },
          { name: 'launchImageLibraryAsync', argumentsCount: 1, key: 'launchImageLibraryAsync' },
          {
            name: 'requestCameraPermissionsAsync',
            argumentsCount: 0,
            key: 'requestCameraPermissionsAsync',
          },
          {
            name: 'requestMediaLibraryPermissionsAsync',
            argumentsCount: 1,
            key: 'requestMediaLibraryPermissionsAsync',
          },
        ],
        ExponentMagnetometer: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExponentMagnetometerUncalibrated: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'setUpdateInterval', argumentsCount: 1, key: 'setUpdateInterval' },
        ],
        ExponentPedometer: [
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          { name: 'getStepCountAsync', argumentsCount: 2, key: 'getStepCountAsync' },
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
        ],
        ExpoNetwork: [
          { name: 'getIpAddressAsync', argumentsCount: 0, key: 'getIpAddressAsync' },
          { name: 'getNetworkStateAsync', argumentsCount: 0, key: 'getNetworkStateAsync' },
        ],
        ExpoNotificationCategoriesModule: [
          { name: 'deleteNotificationCategoryAsync', argumentsCount: 1, key: 0 },
          { name: 'getNotificationCategoriesAsync', argumentsCount: 0, key: 1 },
          { name: 'setNotificationCategoryAsync', argumentsCount: 3, key: 2 },
        ],
        ExpoNotificationPermissionsModule: [
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 0 },
          { name: 'requestPermissionsAsync', argumentsCount: 1, key: 1 },
        ],
        ExpoNotificationPresenter: [
          { name: 'presentNotificationAsync', argumentsCount: 2, key: 0 },
          { name: 'dismissNotificationAsync', argumentsCount: 1, key: 1 },
          { name: 'getPresentedNotificationsAsync', argumentsCount: 0, key: 2 },
          { name: 'dismissAllNotificationsAsync', argumentsCount: 0, key: 3 },
        ],
        ExpoNotificationScheduler: [
          { name: 'cancelAllScheduledNotificationsAsync', argumentsCount: 0, key: 0 },
          { name: 'getNextTriggerDateAsync', argumentsCount: 1, key: 1 },
          { name: 'getAllScheduledNotificationsAsync', argumentsCount: 0, key: 2 },
          { name: 'scheduleNotificationAsync', argumentsCount: 3, key: 3 },
          { name: 'cancelScheduledNotificationAsync', argumentsCount: 1, key: 4 },
        ],
        ExpoNotificationsEmitter: [
          { name: 'getLastNotificationResponseAsync', argumentsCount: 0, key: 0 },
        ],
        ExpoNotificationsHandlerModule: [
          { name: 'handleNotificationAsync', argumentsCount: 2, key: 0 },
        ],
        ExpoPrint: [
          { name: 'print', argumentsCount: 1, key: 'print' },
          { name: 'printToFileAsync', argumentsCount: 1, key: 'printToFileAsync' },
          { name: 'selectPrinter', argumentsCount: 0, key: 'selectPrinter' },
        ],
        ExpoPushTokenManager: [
          { name: 'getDevicePushTokenAsync', argumentsCount: 0, key: 0 },
          { name: 'unregisterForNotificationsAsync', argumentsCount: 0, key: 1 },
        ],
        ExpoRandom: [
          { name: 'getRandomBase64String', argumentsCount: 1, key: 'getRandomBase64String' },
          {
            name: 'getRandomBase64StringAsync',
            argumentsCount: 1,
            key: 'getRandomBase64StringAsync',
          },
        ],
        ExpoScreenCapture: [
          { name: 'allowScreenCapture', argumentsCount: 0, key: 'allowScreenCapture' },
          { name: 'preventScreenCapture', argumentsCount: 0, key: 'preventScreenCapture' },
        ],
        ExpoScreenOrientation: [
          { name: 'getOrientationAsync', argumentsCount: 0, key: 'getOrientationAsync' },
          { name: 'getOrientationLockAsync', argumentsCount: 0, key: 'getOrientationLockAsync' },
          {
            name: 'getPlatformOrientationLockAsync',
            argumentsCount: 0,
            key: 'getPlatformOrientationLockAsync',
          },
          { name: 'lockAsync', argumentsCount: 1, key: 'lockAsync' },
          { name: 'lockPlatformAsync', argumentsCount: 1, key: 'lockPlatformAsync' },
          {
            name: 'supportsOrientationLockAsync',
            argumentsCount: 1,
            key: 'supportsOrientationLockAsync',
          },
        ],
        ExpoSecureStore: [
          {
            name: 'canUseBiometricAuthentication',
            argumentsCount: 0,
            key: 'canUseBiometricAuthentication',
          },
          { name: 'deleteValueWithKeyAsync', argumentsCount: 2, key: 'deleteValueWithKeyAsync' },
          { name: 'getValueWithKeyAsync', argumentsCount: 2, key: 'getValueWithKeyAsync' },
          { name: 'getValueWithKeySync', argumentsCount: 2, key: 'getValueWithKeySync' },
          { name: 'setValueWithKeyAsync', argumentsCount: 3, key: 'setValueWithKeyAsync' },
          { name: 'setValueWithKeySync', argumentsCount: 3, key: 'setValueWithKeySync' },
        ],
        ExpoSharing: [{ name: 'shareAsync', argumentsCount: 2, key: 'shareAsync' }],
        ExpoSMS: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'sendSMSAsync', argumentsCount: 3, key: 'sendSMSAsync' },
        ],
        ExpoSpeech: [
          { name: 'getVoices', argumentsCount: 0, key: 'getVoices' },
          { name: 'isSpeaking', argumentsCount: 0, key: 'isSpeaking' },
          { name: 'pause', argumentsCount: 0, key: 'pause' },
          { name: 'resume', argumentsCount: 0, key: 'resume' },
          { name: 'speak', argumentsCount: 3, key: 'speak' },
          { name: 'stop', argumentsCount: 0, key: 'stop' },
        ],
        ExpoSplashScreen: [
          { name: 'hideAsync', argumentsCount: 0, key: 0 },
          { name: 'preventAutoHideAsync', argumentsCount: 0, key: 1 },
        ],
        ExpoSQLite: [
          { name: 'close', argumentsCount: 1, key: 'close' },
          { name: 'closeSync', argumentsCount: 1, key: 'closeSync' },
          { name: 'deleteAsync', argumentsCount: 1, key: 'deleteAsync' },
          { name: 'exec', argumentsCount: 3, key: 'exec' },
        ],
        ExpoSQLiteNext: [
          { name: 'deleteDatabaseAsync', argumentsCount: 1, key: 'deleteDatabaseAsync' },
          { name: 'deleteDatabaseSync', argumentsCount: 1, key: 'deleteDatabaseSync' },
          { name: 'importAssetDatabaseAsync', argumentsCount: 3, key: 'importAssetDatabaseAsync' },
        ],
        ExpoStoreReview: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 'isAvailableAsync' },
          { name: 'requestReview', argumentsCount: 0, key: 'requestReview' },
        ],
        ExpoSystemUI: [
          { name: 'getBackgroundColorAsync', argumentsCount: 0, key: 'getBackgroundColorAsync' },
          { name: 'setBackgroundColorAsync', argumentsCount: 1, key: 'setBackgroundColorAsync' },
        ],
        ExpoTaskManager: [
          { name: 'isAvailableAsync', argumentsCount: 0, key: 0 },
          { name: 'notifyTaskFinishedAsync', argumentsCount: 2, key: 1 },
          { name: 'unregisterTaskAsync', argumentsCount: 1, key: 2 },
          { name: 'getTaskOptionsAsync', argumentsCount: 1, key: 3 },
          { name: 'unregisterAllTasksAsync', argumentsCount: 0, key: 4 },
          { name: 'isTaskRegisteredAsync', argumentsCount: 1, key: 5 },
          { name: 'getRegisteredTasksAsync', argumentsCount: 0, key: 6 },
        ],
        ExpoTrackingTransparency: [
          { name: 'getAdvertisingId', argumentsCount: 0, key: 'getAdvertisingId' },
          { name: 'getPermissionsAsync', argumentsCount: 0, key: 'getPermissionsAsync' },
          { name: 'requestPermissionsAsync', argumentsCount: 0, key: 'requestPermissionsAsync' },
        ],
        ExpoUpdates: [
          { name: 'checkForUpdateAsync', argumentsCount: 0, key: 'checkForUpdateAsync' },
          { name: 'clearLogEntriesAsync', argumentsCount: 0, key: 'clearLogEntriesAsync' },
          { name: 'fetchUpdateAsync', argumentsCount: 0, key: 'fetchUpdateAsync' },
          { name: 'getExtraParamsAsync', argumentsCount: 0, key: 'getExtraParamsAsync' },
          {
            name: 'getNativeStateMachineContextAsync',
            argumentsCount: 0,
            key: 'getNativeStateMachineContextAsync',
          },
          { name: 'readLogEntriesAsync', argumentsCount: 1, key: 'readLogEntriesAsync' },
          { name: 'reload', argumentsCount: 0, key: 'reload' },
          { name: 'setExtraParamAsync', argumentsCount: 2, key: 'setExtraParamAsync' },
        ],
        ExpoVideo: [
          {
            name: 'isPictureInPictureSupported',
            argumentsCount: 0,
            key: 'isPictureInPictureSupported',
          },
        ],
        ExpoVideoThumbnails: [{ name: 'getThumbnail', argumentsCount: 2, key: 'getThumbnail' }],
        ExpoVideoView: [{ name: 'setFullscreen', argumentsCount: 2, key: 'setFullscreen' }],
        ExpoWebBrowser: [
          { name: 'coolDownAsync', argumentsCount: 0, key: 'coolDownAsync' },
          { name: 'dismissAuthSession', argumentsCount: 0, key: 'dismissAuthSession' },
          { name: 'dismissBrowser', argumentsCount: 0, key: 'dismissBrowser' },
          {
            name: 'getCustomTabsSupportingBrowsers',
            argumentsCount: 0,
            key: 'getCustomTabsSupportingBrowsers',
          },
          { name: 'mayInitWithUrlAsync', argumentsCount: 0, key: 'mayInitWithUrlAsync' },
          { name: 'openAuthSessionAsync', argumentsCount: 3, key: 'openAuthSessionAsync' },
          { name: 'openBrowserAsync', argumentsCount: 2, key: 'openBrowserAsync' },
          { name: 'warmUpAsync', argumentsCount: 0, key: 'warmUpAsync' },
        ],
        NotificationsServerRegistrationModule: [
          { name: 'getRegistrationInfoAsync', argumentsCount: 0, key: 0 },
          { name: 'setRegistrationInfoAsync', argumentsCount: 1, key: 1 },
          { name: 'getInstallationIdAsync', argumentsCount: 0, key: 2 },
        ],
        SymbolModule: [],
      },
    },
    getConstants: { type: 'function' },
    modulesConstants: {
      type: 'mock',
      mockDefinition: {
        EASClient: {
          addListener: { type: 'function' },
          clientID: { type: 'string' },
          removeListeners: { type: 'function' },
        },
        ExpoAppleAuthentication: {
          addListener: { type: 'function' },
          getCredentialStateAsync: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestAsync: { type: 'function' },
        },
        ExpoApplication: {
          addListener: { type: 'function' },
          applicationId: { type: 'string' },
          applicationName: { type: 'string' },
          getApplicationReleaseTypeAsync: { type: 'function' },
          getInstallationTimeAsync: { type: 'function' },
          getIosIdForVendorAsync: { type: 'function' },
          getPushNotificationServiceEnvironmentAsync: { type: 'function' },
          nativeApplicationVersion: { type: 'string' },
          nativeBuildVersion: { type: 'string' },
          removeListeners: { type: 'function' },
        },
        ExpoAsset: {
          addListener: { type: 'function' },
          downloadAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoAudio: {
          addListener: { type: 'function' },
          removeListeners: { type: 'function' },
          setCategory: { type: 'function' },
          setIsAudioActive: { type: 'function' },
        },
        ExpoBackgroundFetch: {
          addListener: { type: 'function' },
          getStatusAsync: { type: 'function' },
          registerTaskAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setMinimumIntervalAsync: { type: 'function' },
          unregisterTaskAsync: { type: 'function' },
        },
        ExpoBarCodeScanner: {
          addListener: { type: 'function' },
          BarCodeType: { type: 'object' },
          getPermissionsAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          scanFromURLAsync: { type: 'function' },
          Type: { type: 'object' },
        },
        ExpoBarometer: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExpoBattery: {
          addListener: { type: 'function' },
          getBatteryLevelAsync: { type: 'function' },
          getBatteryStateAsync: { type: 'function' },
          isLowPowerModeEnabledAsync: { type: 'function' },
          isSupported: { type: 'boolean', mock: false },
          removeListeners: { type: 'function' },
        },
        ExpoBlurView: { addListener: { type: 'function' }, removeListeners: { type: 'function' } },
        ExpoBrightness: {
          addListener: { type: 'function' },
          getBrightnessAsync: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          getSystemBrightnessAsync: { type: 'function' },
          getSystemBrightnessModeAsync: { type: 'function' },
          isUsingSystemBrightnessAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          setBrightnessAsync: { type: 'function' },
          setSystemBrightnessAsync: { type: 'function' },
          setSystemBrightnessModeAsync: { type: 'function' },
          useSystemBrightnessAsync: { type: 'function' },
        },
        ExpoCalendar: {
          addListener: { type: 'function' },
          deleteCalendarAsync: { type: 'function' },
          deleteEventAsync: { type: 'function' },
          deleteReminderAsync: { type: 'function' },
          getAttendeesForEventAsync: { type: 'function' },
          getCalendarPermissionsAsync: { type: 'function' },
          getCalendarsAsync: { type: 'function' },
          getDefaultCalendarAsync: { type: 'function' },
          getEventByIdAsync: { type: 'function' },
          getEventsAsync: { type: 'function' },
          getReminderByIdAsync: { type: 'function' },
          getRemindersAsync: { type: 'function' },
          getRemindersPermissionsAsync: { type: 'function' },
          getSourceByIdAsync: { type: 'function' },
          getSourcesAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestCalendarPermissionsAsync: { type: 'function' },
          requestRemindersPermissionsAsync: { type: 'function' },
          saveCalendarAsync: { type: 'function' },
          saveEventAsync: { type: 'function' },
          saveReminderAsync: { type: 'function' },
        },
        ExpoCamera: {
          addListener: { type: 'function' },
          dismissScanner: { type: 'function' },
          getAvailableVideoCodecsAsync: { type: 'function' },
          getCameraPermissionsAsync: { type: 'function' },
          getMicrophonePermissionsAsync: { type: 'function' },
          launchScanner: { type: 'function' },
          removeListeners: { type: 'function' },
          requestCameraPermissionsAsync: { type: 'function' },
          requestMicrophonePermissionsAsync: { type: 'function' },
        },
        ExpoCameraLegacy: {
          addListener: { type: 'function' },
          AutoFocus: { type: 'object' },
          FlashMode: { type: 'object' },
          getAvailablePictureSizes: { type: 'function' },
          getAvailableVideoCodecsAsync: { type: 'function' },
          getCameraPermissionsAsync: { type: 'function' },
          getMicrophonePermissionsAsync: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          pausePreview: { type: 'function' },
          record: { type: 'function' },
          removeListeners: { type: 'function' },
          requestCameraPermissionsAsync: { type: 'function' },
          requestMicrophonePermissionsAsync: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          resumePreview: { type: 'function' },
          stopRecording: { type: 'function' },
          takePicture: { type: 'function' },
          Type: { type: 'object' },
          VideoCodec: { type: 'object' },
          VideoQuality: { type: 'object' },
          VideoStabilization: { type: 'object' },
          WhiteBalance: { type: 'object' },
        },
        ExpoCellular: {
          addListener: { type: 'function' },
          allowsVoip: { type: 'object', mock: null },
          allowsVoipAsync: { type: 'function' },
          carrier: { type: 'object', mock: null },
          generation: { type: 'number', mock: 0 },
          getCarrierNameAsync: { type: 'function' },
          getCellularGenerationAsync: { type: 'function' },
          getIsoCountryCodeAsync: { type: 'function' },
          getMobileCountryCodeAsync: { type: 'function' },
          getMobileNetworkCodeAsync: { type: 'function' },
          isoCountryCode: { type: 'object', mock: null },
          mobileCountryCode: { type: 'object', mock: null },
          mobileNetworkCode: { type: 'object', mock: null },
          removeListeners: { type: 'function' },
        },
        ExpoContacts: {
          addContactAsync: { type: 'function' },
          addExistingContactToGroupAsync: { type: 'function' },
          addExistingGroupToContainerAsync: { type: 'function' },
          addListener: { type: 'function' },
          createGroupAsync: { type: 'function' },
          dismissFormAsync: { type: 'function' },
          getContactsAsync: { type: 'function' },
          getContainersAsync: { type: 'function' },
          getDefaultContainerIdentifierAsync: { type: 'function' },
          getGroupsAsync: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          presentContactPickerAsync: { type: 'function' },
          presentFormAsync: { type: 'function' },
          removeContactAsync: { type: 'function' },
          removeContactFromGroupAsync: { type: 'function' },
          removeGroupAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          updateContactAsync: { type: 'function' },
          updateGroupNameAsync: { type: 'function' },
          writeContactToFileAsync: { type: 'function' },
        },
        ExpoDevice: {
          addListener: { type: 'function' },
          brand: { type: 'string' },
          deviceName: { type: 'string' },
          deviceType: { type: 'number', mock: 1 },
          deviceYearClass: { type: 'number', mock: 2024 },
          getDeviceTypeAsync: { type: 'function' },
          getUptimeAsync: { type: 'function' },
          isDevice: { type: 'boolean', mock: false },
          isRootedExperimentalAsync: { type: 'function' },
          manufacturer: { type: 'string' },
          modelId: { type: 'string' },
          modelName: { type: 'string' },
          osBuildId: { type: 'string' },
          osInternalBuildId: { type: 'string' },
          osName: { type: 'string' },
          osVersion: { type: 'string' },
          removeListeners: { type: 'function' },
          supportedCpuArchitectures: { type: 'array' },
          totalMemory: { type: 'number', mock: 34359738368 },
        },
        ExpoDocumentPicker: {
          addListener: { type: 'function' },
          getDocumentAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoFontLoader: {
          addListener: { type: 'function' },
          loadAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoGo: {
          addListener: { type: 'function' },
          expoVersion: { type: 'string' },
          projectConfig: { type: 'object' },
          removeListeners: { type: 'function' },
        },
        ExpoHaptics: {
          addListener: { type: 'function' },
          impactAsync: { type: 'function' },
          notificationAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          selectionAsync: { type: 'function' },
        },
        ExpoHead: {
          activities: { type: 'object' },
          addListener: { type: 'function' },
          clearActivitiesAsync: { type: 'function' },
          createActivity: { type: 'function' },
          getLaunchActivity: { type: 'function' },
          removeListeners: { type: 'function' },
          revokeActivity: { type: 'function' },
          suspendActivity: { type: 'function' },
        },
        ExpoImage: {
          addListener: { type: 'function' },
          clearDiskCache: { type: 'function' },
          clearMemoryCache: { type: 'function' },
          generateBlurhashAsync: { type: 'function' },
          getCachePathAsync: { type: 'function' },
          prefetch: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoImageManipulator: {
          addListener: { type: 'function' },
          manipulateAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoKeepAwake: {
          activate: { type: 'function' },
          addListener: { type: 'function' },
          deactivate: { type: 'function' },
          isActivated: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoLinearGradient: {
          addListener: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoLocalAuthentication: {
          addListener: { type: 'function' },
          authenticateAsync: { type: 'function' },
          getEnrolledLevelAsync: { type: 'function' },
          hasHardwareAsync: { type: 'function' },
          isEnrolledAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          supportedAuthenticationTypesAsync: { type: 'function' },
        },
        ExpoLocalization: {
          addListener: { type: 'function' },
          currency: { type: 'string' },
          decimalSeparator: { type: 'string' },
          digitGroupingSeparator: { type: 'string' },
          getCalendars: { type: 'function' },
          getLocales: { type: 'function' },
          getLocalizationAsync: { type: 'function' },
          isMetric: { type: 'boolean', mock: true },
          isoCurrencyCodes: { type: 'array' },
          isRTL: { type: 'boolean', mock: false },
          locale: { type: 'string' },
          locales: { type: 'array' },
          region: { type: 'string' },
          removeListeners: { type: 'function' },
          timezone: { type: 'string' },
        },
        ExpoMailComposer: {
          addListener: { type: 'function' },
          composeAsync: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoMediaLibrary: {
          addAssetsToAlbumAsync: { type: 'function' },
          addListener: { type: 'function' },
          CHANGE_LISTENER_NAME: { type: 'string' },
          createAlbumAsync: { type: 'function' },
          createAssetAsync: { type: 'function' },
          deleteAlbumsAsync: { type: 'function' },
          deleteAssetsAsync: { type: 'function' },
          getAlbumAsync: { type: 'function' },
          getAlbumsAsync: { type: 'function' },
          getAssetInfoAsync: { type: 'function' },
          getAssetsAsync: { type: 'function' },
          getMomentsAsync: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          MediaType: { type: 'object' },
          presentPermissionsPickerAsync: { type: 'function' },
          removeAssetsFromAlbumAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          saveToLibraryAsync: { type: 'function' },
          SortBy: { type: 'object' },
        },
        ExponentAccelerometer: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExponentAV: {
          addListener: { type: 'function' },
          getAudioRecordingStatus: { type: 'function' },
          getAvailableInputs: { type: 'function' },
          getCurrentInput: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          getStatusForSound: { type: 'function' },
          getStatusForVideo: { type: 'function' },
          loadForSound: { type: 'function' },
          loadForVideo: { type: 'function' },
          pauseAudioRecording: { type: 'function' },
          prepareAudioRecorder: { type: 'function' },
          Qualities: { type: 'object' },
          removeListeners: { type: 'function' },
          replaySound: { type: 'function' },
          replayVideo: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
          setAudioIsEnabled: { type: 'function' },
          setAudioMode: { type: 'function' },
          setInput: { type: 'function' },
          setStatusForSound: { type: 'function' },
          setStatusForVideo: { type: 'function' },
          startAudioRecording: { type: 'function' },
          stopAudioRecording: { type: 'function' },
          unloadAudioRecorder: { type: 'function' },
          unloadForSound: { type: 'function' },
          unloadForVideo: { type: 'function' },
        },
        ExponentConstants: {
          addListener: { type: 'function' },
          appOwnership: { type: 'string' },
          debugMode: { type: 'boolean', mock: true },
          deviceName: { type: 'string' },
          executionEnvironment: { type: 'string' },
          experienceUrl: { type: 'string' },
          expoRuntimeVersion: { type: 'string' },
          expoVersion: { type: 'string' },
          getWebViewUserAgentAsync: { type: 'function' },
          isDetached: { type: 'boolean', mock: false },
          isHeadless: { type: 'boolean', mock: false },
          linkingUri: { type: 'string' },
          manifest: { type: 'object' },
          platform: { type: 'object' },
          removeListeners: { type: 'function' },
          sessionId: { type: 'string' },
          statusBarHeight: { type: 'number', mock: 54 },
          supportedExpoSdks: { type: 'array' },
          systemFonts: { type: 'array' },
        },
        ExponentDeviceMotion: {
          addListener: { type: 'function' },
          Gravity: { type: 'number', mock: 9.80665 },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExponentFileSystem: {
          addListener: { type: 'function' },
          bundleDirectory: { type: 'string' },
          cacheDirectory: { type: 'string' },
          copyAsync: { type: 'function' },
          deleteAsync: { type: 'function' },
          documentDirectory: { type: 'string' },
          downloadAsync: { type: 'function' },
          downloadResumablePauseAsync: { type: 'function' },
          downloadResumableStartAsync: { type: 'function' },
          getFreeDiskStorageAsync: { type: 'function' },
          getInfoAsync: { type: 'function' },
          getTotalDiskCapacityAsync: { type: 'function' },
          makeDirectoryAsync: { type: 'function' },
          moveAsync: { type: 'function' },
          networkTaskCancelAsync: { type: 'function' },
          readAsStringAsync: { type: 'function' },
          readDirectoryAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          uploadAsync: { type: 'function' },
          uploadTaskStartAsync: { type: 'function' },
          writeAsStringAsync: { type: 'function' },
        },
        ExponentGLView: {
          addListener: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExponentGyroscope: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExponentImagePicker: {
          addListener: { type: 'function' },
          getCameraPermissionsAsync: { type: 'function' },
          getMediaLibraryPermissionsAsync: { type: 'function' },
          launchCameraAsync: { type: 'function' },
          launchImageLibraryAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestCameraPermissionsAsync: { type: 'function' },
          requestMediaLibraryPermissionsAsync: { type: 'function' },
        },
        ExponentMagnetometer: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExponentMagnetometerUncalibrated: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setUpdateInterval: { type: 'function' },
        },
        ExponentPedometer: {
          addListener: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          getStepCountAsync: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
        },
        ExpoNetwork: {
          addListener: { type: 'function' },
          getIpAddressAsync: { type: 'function' },
          getNetworkStateAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoPrint: {
          addListener: { type: 'function' },
          Orientation: { type: 'object' },
          print: { type: 'function' },
          printToFileAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          selectPrinter: { type: 'function' },
        },
        ExpoRandom: {
          addListener: { type: 'function' },
          getRandomBase64String: { type: 'function' },
          getRandomBase64StringAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoScreenCapture: {
          addListener: { type: 'function' },
          allowScreenCapture: { type: 'function' },
          preventScreenCapture: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoScreenOrientation: {
          addListener: { type: 'function' },
          getOrientationAsync: { type: 'function' },
          getOrientationLockAsync: { type: 'function' },
          getPlatformOrientationLockAsync: { type: 'function' },
          lockAsync: { type: 'function' },
          lockPlatformAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          supportsOrientationLockAsync: { type: 'function' },
        },
        ExpoSecureStore: {
          addListener: { type: 'function' },
          AFTER_FIRST_UNLOCK: { type: 'number', mock: 0 },
          AFTER_FIRST_UNLOCK_THIS_DEVICE_ONLY: { type: 'number', mock: 1 },
          ALWAYS: { type: 'number', mock: 2 },
          ALWAYS_THIS_DEVICE_ONLY: { type: 'number', mock: 4 },
          canUseBiometricAuthentication: { type: 'function' },
          deleteValueWithKeyAsync: { type: 'function' },
          getValueWithKeyAsync: { type: 'function' },
          getValueWithKeySync: { type: 'function' },
          removeListeners: { type: 'function' },
          setValueWithKeyAsync: { type: 'function' },
          setValueWithKeySync: { type: 'function' },
          WHEN_PASSCODE_SET_THIS_DEVICE_ONLY: { type: 'number', mock: 3 },
          WHEN_UNLOCKED: { type: 'number', mock: 5 },
          WHEN_UNLOCKED_THIS_DEVICE_ONLY: { type: 'number', mock: 6 },
        },
        ExpoSharing: {
          addListener: { type: 'function' },
          removeListeners: { type: 'function' },
          shareAsync: { type: 'function' },
        },
        ExpoSMS: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          sendSMSAsync: { type: 'function' },
        },
        ExpoSpeech: {
          addListener: { type: 'function' },
          getVoices: { type: 'function' },
          isSpeaking: { type: 'function' },
          pause: { type: 'function' },
          removeListeners: { type: 'function' },
          resume: { type: 'function' },
          speak: { type: 'function' },
          stop: { type: 'function' },
        },
        ExpoSQLite: {
          addListener: { type: 'function' },
          close: { type: 'function' },
          closeSync: { type: 'function' },
          deleteAsync: { type: 'function' },
          exec: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoSQLiteNext: {
          addListener: { type: 'function' },
          deleteDatabaseAsync: { type: 'function' },
          deleteDatabaseSync: { type: 'function' },
          importAssetDatabaseAsync: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoStoreReview: {
          addListener: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestReview: { type: 'function' },
        },
        ExpoSystemUI: {
          addListener: { type: 'function' },
          getBackgroundColorAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          setBackgroundColorAsync: { type: 'function' },
        },
        ExpoTaskManager: {
          addListener: { type: 'function' },
          EVENT_NAME: { type: 'string' },
          getRegisteredTasksAsync: { type: 'function' },
          getTaskOptionsAsync: { type: 'function' },
          isAvailableAsync: { type: 'function' },
          isTaskRegisteredAsync: { type: 'function' },
          notifyTaskFinishedAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          unregisterAllTasksAsync: { type: 'function' },
          unregisterTaskAsync: { type: 'function' },
        },
        ExpoTrackingTransparency: {
          addListener: { type: 'function' },
          getAdvertisingId: { type: 'function' },
          getPermissionsAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          requestPermissionsAsync: { type: 'function' },
        },
        ExpoUpdates: {
          addListener: { type: 'function' },
          channel: { type: 'string' },
          checkAutomatically: { type: 'string' },
          checkForUpdateAsync: { type: 'function' },
          clearLogEntriesAsync: { type: 'function' },
          emergencyLaunchReason: { type: 'object', mock: null },
          fetchUpdateAsync: { type: 'function' },
          getExtraParamsAsync: { type: 'function' },
          getNativeStateMachineContextAsync: { type: 'function' },
          isEmbeddedLaunch: { type: 'boolean', mock: false },
          isEmergencyLaunch: { type: 'boolean', mock: false },
          isEnabled: { type: 'boolean', mock: false },
          nativeDebug: { type: 'boolean', mock: false },
          readLogEntriesAsync: { type: 'function' },
          reload: { type: 'function' },
          removeListeners: { type: 'function' },
          runtimeVersion: { type: 'string' },
          setExtraParamAsync: { type: 'function' },
          shouldDeferToNativeForAPIMethodAvailabilityInDevelopment: { type: 'boolean', mock: true },
        },
        ExpoVideo: {
          addListener: { type: 'function' },
          isPictureInPictureSupported: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoVideoThumbnails: {
          addListener: { type: 'function' },
          getThumbnail: { type: 'function' },
          removeListeners: { type: 'function' },
        },
        ExpoVideoView: {
          addListener: { type: 'function' },
          removeListeners: { type: 'function' },
          ScaleAspectFill: { type: 'string' },
          ScaleAspectFit: { type: 'string' },
          ScaleNone: { type: 'string' },
          ScaleToFill: { type: 'string' },
          setFullscreen: { type: 'function' },
        },
        ExpoWebBrowser: {
          addListener: { type: 'function' },
          coolDownAsync: { type: 'function' },
          dismissAuthSession: { type: 'function' },
          dismissBrowser: { type: 'function' },
          getCustomTabsSupportingBrowsers: { type: 'function' },
          mayInitWithUrlAsync: { type: 'function' },
          openAuthSessionAsync: { type: 'function' },
          openBrowserAsync: { type: 'function' },
          removeListeners: { type: 'function' },
          warmUpAsync: { type: 'function' },
        },
        SymbolModule: { addListener: { type: 'function' }, removeListeners: { type: 'function' } },
      },
    },
    viewManagersMetadata: {
      type: 'object',
      mock: {
        ExpoAppleAuthentication: { propsNames: ['buttonStyle', 'buttonType', 'cornerRadius'] },
        ExpoBarCodeScanner: { propsNames: ['barCodeTypes', 'type'] },
        ExpoBlurView: { propsNames: ['intensity', 'tint'] },
        ExpoCamera: {
          propsNames: [
            'animateShutter',
            'barcodeScannerEnabled',
            'barcodeScannerSettings',
            'enableTorch',
            'facing',
            'flashMode',
            'mode',
            'mute',
            'pictureSize',
            'responsiveOrientationWhenOrientationLocked',
            'videoQuality',
            'zoom',
          ],
        },
        ExpoCameraLegacy: {
          propsNames: [
            'autoFocus',
            'barCodeScannerEnabled',
            'barCodeScannerSettings',
            'faceDetectorEnabled',
            'faceDetectorSettings',
            'flashMode',
            'focusDepth',
            'pictureSize',
            'responsiveOrientationWhenOrientationLocked',
            'type',
            'whiteBalance',
            'zoom',
          ],
        },
        ExpoClipboard: {
          propsNames: [
            'acceptedContentTypes',
            'backgroundColor',
            'cornerStyle',
            'displayMode',
            'foregroundColor',
            'imageOptions',
          ],
        },
        ExpoImage: {
          propsNames: [
            'accessibilityLabel',
            'accessible',
            'allowDownscaling',
            'autoplay',
            'blurRadius',
            'cachePolicy',
            'contentFit',
            'contentPosition',
            'enableLiveTextInteraction',
            'placeholder',
            'placeholderContentFit',
            'priority',
            'recyclingKey',
            'source',
            'tintColor',
            'transition',
          ],
        },
        ExpoLinearGradient: { propsNames: ['colors', 'endPoint', 'locations', 'startPoint'] },
        ExponentGLView: { propsNames: ['enableExperimentalWorkletSupport', 'msaaSamples'] },
        ExpoVideo: {
          propsNames: [
            'allowsFullscreen',
            'allowsPictureInPicture',
            'contentFit',
            'contentPosition',
            'nativeControls',
            'player',
            'requiresLinearPlayback',
            'showsTimecodes',
            'startsPictureInPictureAutomatically',
          ],
        },
        ExpoVideoView: { propsNames: ['resizeMode', 'source', 'status', 'useNativeControls'] },
        SymbolModule: {
          propsNames: [
            'animated',
            'animationSpec',
            'colors',
            'name',
            'resizeMode',
            'scale',
            'tintColor',
            'type',
            'weight',
          ],
        },
      },
    },
  },
  ReanimatedModule: {
    addListener: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    installTurboModule: { type: 'function', functionType: 'sync' },
    removeListeners: { type: 'function', functionType: 'async' },
  },
  RNAWSCognito: {
    computeModPow: { type: 'function', functionType: 'async' },
    computeS: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    getRandomBase64: { type: 'function', functionType: 'sync' },
  },
  RNCMaskedViewManager: {},
  RNCNetInfo: {
    addListener: { type: 'function', functionType: 'async' },
    configure: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    getCurrentState: { type: 'function', functionType: 'promise' },
    removeListeners: { type: 'function', functionType: 'async' },
  },
  RNCPickerManager: {},
  RNCSafeAreaContext: {
    getConstants: { type: 'function' },
    initialWindowMetrics: { type: 'object' },
  },
  RNCSafeAreaProvider: {},
  RNCSafeAreaView: {},
  RNCSegmentedControlManager: {},
  RNCSliderManager: {},
  RNCViewPager: {
    getConstants: { type: 'function' },
    setPage: { type: 'function', functionType: 'async' },
    setPageWithoutAnimation: { type: 'function', functionType: 'async' },
    setScrollEnabledImperatively: { type: 'function', functionType: 'async' },
  },
  RNCWebView: {
    clearCache: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    goBack: { type: 'function', functionType: 'async' },
    goForward: { type: 'function', functionType: 'async' },
    injectJavaScript: { type: 'function', functionType: 'async' },
    postMessage: { type: 'function', functionType: 'async' },
    reload: { type: 'function', functionType: 'async' },
    requestFocus: { type: 'function', functionType: 'async' },
    shouldStartLoadWithLockIdentifier: { type: 'function', functionType: 'async' },
    stopLoading: { type: 'function', functionType: 'async' },
  },
  RNDateTimePickerManager: {},
  RNGestureHandlerButton: {},
  RNGestureHandlerModule: {
    addListener: { type: 'function', functionType: 'async' },
    attachGestureHandler: { type: 'function', functionType: 'async' },
    createGestureHandler: { type: 'function', functionType: 'async' },
    Direction: { type: 'object' },
    dropGestureHandler: { type: 'function', functionType: 'async' },
    flushOperations: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    handleClearJSResponder: { type: 'function', functionType: 'async' },
    handleSetJSResponder: { type: 'function', functionType: 'async' },
    removeListeners: { type: 'function', functionType: 'async' },
    State: { type: 'object' },
    updateGestureHandler: { type: 'function', functionType: 'async' },
  },
  RNSFullWindowOverlayManager: {},
  RNSkiaModule: {
    getConstants: { type: 'function' },
    install: { type: 'function', functionType: 'sync' },
  },
  RNSModalScreenManager: {},
  RNSModule: {},
  RNSScreenContainerManager: {},
  RNSScreenManager: {},
  RNSScreenNavigationContainerManager: {},
  RNSScreenStackHeaderConfigManager: {},
  RNSScreenStackHeaderSubviewManager: {},
  RNSScreenStackManager: {},
  RNSSearchBarManager: {
    blur: { type: 'function', functionType: 'async' },
    cancelSearch: { type: 'function', functionType: 'async' },
    clearText: { type: 'function', functionType: 'async' },
    focus: { type: 'function', functionType: 'async' },
    getConstants: { type: 'function' },
    setText: { type: 'function', functionType: 'async' },
    toggleCancelButton: { type: 'function', functionType: 'async' },
  },
  RNSVGCircleManager: {},
  RNSVGClipPathManager: {},
  RNSVGDefsManager: {},
  RNSVGEllipseManager: {},
  RNSVGForeignObjectManager: {},
  RNSVGGroupManager: {},
  RNSVGImageManager: {},
  RNSVGLinearGradientManager: {},
  RNSVGLineManager: {},
  RNSVGMarkerManager: {},
  RNSVGMaskManager: {},
  RNSVGNodeManager: {},
  RNSVGPathManager: {},
  RNSVGPatternManager: {},
  RNSVGRadialGradientManager: {},
  RNSVGRectManager: {},
  RNSVGRenderableManager: {},
  RNSVGRenderableModule: {
    getBBox: { type: 'function', functionType: 'sync' },
    getConstants: { type: 'function' },
    getCTM: { type: 'function', functionType: 'sync' },
    getPointAtLength: { type: 'function', functionType: 'sync' },
    getScreenCTM: { type: 'function', functionType: 'sync' },
    getTotalLength: { type: 'function', functionType: 'sync' },
    isPointInFill: { type: 'function', functionType: 'sync' },
    isPointInStroke: { type: 'function', functionType: 'sync' },
  },
  RNSVGSvgViewManager: {},
  RNSVGSvgViewModule: {
    getConstants: { type: 'function' },
    toDataURL: { type: 'function', functionType: 'async' },
  },
  RNSVGSymbolManager: {},
  RNSVGTextManager: {},
  RNSVGTextPathManager: {},
  RNSVGTSpanManager: {},
  RNSVGUseManager: {},
  RNViewShot: {
    captureRef: { type: 'function', functionType: 'promise' },
    captureScreen: { type: 'function', functionType: 'promise' },
    getConstants: { type: 'function' },
    releaseCapture: { type: 'function', functionType: 'async' },
  },
};
