/**
 * @remix-run/server-runtime v2.14.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
import { matchRoutes } from '@remix-run/router';

function matchServerRoutes(routes, pathname, basename) {
  let matches = matchRoutes(routes, pathname, basename);
  if (!matches) return null;
  return matches.map(match => ({
    params: match.params,
    pathname: match.pathname,
    route: match.route
  }));
}

export { matchServerRoutes };
