// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'E'.
class PartE {
  /// Applies the EB Garamond font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/EB+Garamond
  static TextStyle ebGaramond({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7972e824546ea84fd60f287a863b9a3b8cfeb69ca63f2257e11d29d2699fb691',
        448340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7b1e8dac3abed1cd54a4fe6b18cfc6808a5265348239870134b01c28a23f93d1',
        450620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5266fb083bec2dd1e0765c5c8d1212f1543e9536bef73f14fd646631fc07eea3',
        450888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46e0c7e83e11811f3c06fe90cab849198ffc8d53c8a679c86f2a84d9be9ce2a5',
        450572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd0a686b415c97bc324856855f6087d20f9bbaad4c5e9d7cc81987023dbb5c9c3',
        450228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '74f086ad4858ccccb6f80fa7538487022bc63af13b4b41267f53ce46cf5ce6b2',
        378200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82ae0f6df6fa8faefefcd92e27c423b146b7520b80702b7783f29420bf30cc08',
        380620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c5bcf7f250d26b6eb3ce8b4366d6639e4f7ee9ca67aee1692a47614c08e8c2f5',
        381240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f8991de377fc086cd8d9822a1a40ca4af67cd8523fcd3dd76322632f138ad80',
        381060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '54448ed6b086964e17b0be680e217c3973ad01666d3228e137c6952b02d10462',
        380352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EBGaramond',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the EB Garamond font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/EB+Garamond
  static TextTheme ebGaramondTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ebGaramond(textStyle: textTheme.displayLarge),
      displayMedium: ebGaramond(textStyle: textTheme.displayMedium),
      displaySmall: ebGaramond(textStyle: textTheme.displaySmall),
      headlineLarge: ebGaramond(textStyle: textTheme.headlineLarge),
      headlineMedium: ebGaramond(textStyle: textTheme.headlineMedium),
      headlineSmall: ebGaramond(textStyle: textTheme.headlineSmall),
      titleLarge: ebGaramond(textStyle: textTheme.titleLarge),
      titleMedium: ebGaramond(textStyle: textTheme.titleMedium),
      titleSmall: ebGaramond(textStyle: textTheme.titleSmall),
      bodyLarge: ebGaramond(textStyle: textTheme.bodyLarge),
      bodyMedium: ebGaramond(textStyle: textTheme.bodyMedium),
      bodySmall: ebGaramond(textStyle: textTheme.bodySmall),
      labelLarge: ebGaramond(textStyle: textTheme.labelLarge),
      labelMedium: ebGaramond(textStyle: textTheme.labelMedium),
      labelSmall: ebGaramond(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Eagle Lake font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eagle+Lake
  static TextStyle eagleLake({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b858283e2e07d0e92bc56f64ebe091dc033af33de771cc010e2b533008a0dd4',
        75472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EagleLake',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Eagle Lake font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eagle+Lake
  static TextTheme eagleLakeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eagleLake(textStyle: textTheme.displayLarge),
      displayMedium: eagleLake(textStyle: textTheme.displayMedium),
      displaySmall: eagleLake(textStyle: textTheme.displaySmall),
      headlineLarge: eagleLake(textStyle: textTheme.headlineLarge),
      headlineMedium: eagleLake(textStyle: textTheme.headlineMedium),
      headlineSmall: eagleLake(textStyle: textTheme.headlineSmall),
      titleLarge: eagleLake(textStyle: textTheme.titleLarge),
      titleMedium: eagleLake(textStyle: textTheme.titleMedium),
      titleSmall: eagleLake(textStyle: textTheme.titleSmall),
      bodyLarge: eagleLake(textStyle: textTheme.bodyLarge),
      bodyMedium: eagleLake(textStyle: textTheme.bodyMedium),
      bodySmall: eagleLake(textStyle: textTheme.bodySmall),
      labelLarge: eagleLake(textStyle: textTheme.labelLarge),
      labelMedium: eagleLake(textStyle: textTheme.labelMedium),
      labelSmall: eagleLake(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the East Sea Dokdo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/East+Sea+Dokdo
  static TextStyle eastSeaDokdo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48e1272cecdde224dd5f109ba1bde3b5de7554ab0442b0e9683213acde02b410',
        3175636,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EastSeaDokdo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the East Sea Dokdo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/East+Sea+Dokdo
  static TextTheme eastSeaDokdoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eastSeaDokdo(textStyle: textTheme.displayLarge),
      displayMedium: eastSeaDokdo(textStyle: textTheme.displayMedium),
      displaySmall: eastSeaDokdo(textStyle: textTheme.displaySmall),
      headlineLarge: eastSeaDokdo(textStyle: textTheme.headlineLarge),
      headlineMedium: eastSeaDokdo(textStyle: textTheme.headlineMedium),
      headlineSmall: eastSeaDokdo(textStyle: textTheme.headlineSmall),
      titleLarge: eastSeaDokdo(textStyle: textTheme.titleLarge),
      titleMedium: eastSeaDokdo(textStyle: textTheme.titleMedium),
      titleSmall: eastSeaDokdo(textStyle: textTheme.titleSmall),
      bodyLarge: eastSeaDokdo(textStyle: textTheme.bodyLarge),
      bodyMedium: eastSeaDokdo(textStyle: textTheme.bodyMedium),
      bodySmall: eastSeaDokdo(textStyle: textTheme.bodySmall),
      labelLarge: eastSeaDokdo(textStyle: textTheme.labelLarge),
      labelMedium: eastSeaDokdo(textStyle: textTheme.labelMedium),
      labelSmall: eastSeaDokdo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Eater font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eater
  static TextStyle eater({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19fcfc23e45110c82c2f38020fd194ad2169fad9e64d62bf5b843efea45bf882',
        82152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Eater',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Eater font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eater
  static TextTheme eaterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eater(textStyle: textTheme.displayLarge),
      displayMedium: eater(textStyle: textTheme.displayMedium),
      displaySmall: eater(textStyle: textTheme.displaySmall),
      headlineLarge: eater(textStyle: textTheme.headlineLarge),
      headlineMedium: eater(textStyle: textTheme.headlineMedium),
      headlineSmall: eater(textStyle: textTheme.headlineSmall),
      titleLarge: eater(textStyle: textTheme.titleLarge),
      titleMedium: eater(textStyle: textTheme.titleMedium),
      titleSmall: eater(textStyle: textTheme.titleSmall),
      bodyLarge: eater(textStyle: textTheme.bodyLarge),
      bodyMedium: eater(textStyle: textTheme.bodyMedium),
      bodySmall: eater(textStyle: textTheme.bodySmall),
      labelLarge: eater(textStyle: textTheme.labelLarge),
      labelMedium: eater(textStyle: textTheme.labelMedium),
      labelSmall: eater(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Economica font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Economica
  static TextStyle economica({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c24ce23ab6599b28e3b0cc9e9ae30458d216cd9bc6c7cb916aad9d9d0ac0d8e6',
        24816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '931fb29df0380d5ece2163387988b13c7b43655686a49efb14a5438fc1d2d535',
        25764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9aa41b839712b5e1731268dc5b45b5cf8e088a4c0af363b219a5141a285918a3',
        25252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3a80a4adf7226a3c563bb2ff49ea5352101462206280ba393c8dc456f7d547f2',
        25060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Economica',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Economica font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Economica
  static TextTheme economicaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: economica(textStyle: textTheme.displayLarge),
      displayMedium: economica(textStyle: textTheme.displayMedium),
      displaySmall: economica(textStyle: textTheme.displaySmall),
      headlineLarge: economica(textStyle: textTheme.headlineLarge),
      headlineMedium: economica(textStyle: textTheme.headlineMedium),
      headlineSmall: economica(textStyle: textTheme.headlineSmall),
      titleLarge: economica(textStyle: textTheme.titleLarge),
      titleMedium: economica(textStyle: textTheme.titleMedium),
      titleSmall: economica(textStyle: textTheme.titleSmall),
      bodyLarge: economica(textStyle: textTheme.bodyLarge),
      bodyMedium: economica(textStyle: textTheme.bodyMedium),
      bodySmall: economica(textStyle: textTheme.bodySmall),
      labelLarge: economica(textStyle: textTheme.labelLarge),
      labelMedium: economica(textStyle: textTheme.labelMedium),
      labelSmall: economica(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Eczar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eczar
  static TextStyle eczar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e6a26bd0e657fcf2d277b0555a10ff523cabc7ce13644142bdaeb0a014d9592',
        248344,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5e418b97f8251482f63144fea8cc6fb26e1a918facebb8699479a2cbd036b4eb',
        249012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51df7a413eb2506022dd780c1d18b467a8b1690a980cdd9055136d6df31d73ab',
        249052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f27c484fa72222fb0472f9f5f8cdff14f5382b738afe09952997c768c3410c7',
        253600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1be553515c6c8a4712805e543d14ce491d0a8f4943118b4e6c331bd5a03eab77',
        253888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Eczar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Eczar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Eczar
  static TextTheme eczarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eczar(textStyle: textTheme.displayLarge),
      displayMedium: eczar(textStyle: textTheme.displayMedium),
      displaySmall: eczar(textStyle: textTheme.displaySmall),
      headlineLarge: eczar(textStyle: textTheme.headlineLarge),
      headlineMedium: eczar(textStyle: textTheme.headlineMedium),
      headlineSmall: eczar(textStyle: textTheme.headlineSmall),
      titleLarge: eczar(textStyle: textTheme.titleLarge),
      titleMedium: eczar(textStyle: textTheme.titleMedium),
      titleSmall: eczar(textStyle: textTheme.titleSmall),
      bodyLarge: eczar(textStyle: textTheme.bodyLarge),
      bodyMedium: eczar(textStyle: textTheme.bodyMedium),
      bodySmall: eczar(textStyle: textTheme.bodySmall),
      labelLarge: eczar(textStyle: textTheme.labelLarge),
      labelMedium: eczar(textStyle: textTheme.labelMedium),
      labelSmall: eczar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu AU VIC WA NT Hand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+AU+VIC+WA+NT+Hand
  static TextStyle eduAuVicWaNtHand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51999db0d64452b52d46a2088f3c3f00747dbbf6189e1fa9fbc54f3551a4de5d',
        189236,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b028a1c11852f19aa8ff7355fef9bb369d95d3236dbc1fa10cfe028088d7f9c',
        189316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e40602b7fddf78df5efb8ccbc709b4edce2514fb72396b81211ef521118fa156',
        189284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb258821054ee40ab44702bfcfb8679eab02e676cfb2e7873224418474e78bbc',
        189024,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduAUVICWANTHand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu AU VIC WA NT Hand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+AU+VIC+WA+NT+Hand
  static TextTheme eduAuVicWaNtHandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduAuVicWaNtHand(textStyle: textTheme.displayLarge),
      displayMedium: eduAuVicWaNtHand(textStyle: textTheme.displayMedium),
      displaySmall: eduAuVicWaNtHand(textStyle: textTheme.displaySmall),
      headlineLarge: eduAuVicWaNtHand(textStyle: textTheme.headlineLarge),
      headlineMedium: eduAuVicWaNtHand(textStyle: textTheme.headlineMedium),
      headlineSmall: eduAuVicWaNtHand(textStyle: textTheme.headlineSmall),
      titleLarge: eduAuVicWaNtHand(textStyle: textTheme.titleLarge),
      titleMedium: eduAuVicWaNtHand(textStyle: textTheme.titleMedium),
      titleSmall: eduAuVicWaNtHand(textStyle: textTheme.titleSmall),
      bodyLarge: eduAuVicWaNtHand(textStyle: textTheme.bodyLarge),
      bodyMedium: eduAuVicWaNtHand(textStyle: textTheme.bodyMedium),
      bodySmall: eduAuVicWaNtHand(textStyle: textTheme.bodySmall),
      labelLarge: eduAuVicWaNtHand(textStyle: textTheme.labelLarge),
      labelMedium: eduAuVicWaNtHand(textStyle: textTheme.labelMedium),
      labelSmall: eduAuVicWaNtHand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu NSW ACT Foundation font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+NSW+ACT+Foundation
  static TextStyle eduNswActFoundation({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12419c2e84c7f2625f31c9e53ae5804c6e7a0cf7e4d00955442aeeeb27c2c4d8',
        21208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68f712d02407b882932967928f32e4e18e4061b7ceb976dc75827045ce145ca1',
        21432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d7d38c1a9bf42850252ba714f721db20cb1af4117266234a4132468d143b502',
        21464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8e6d5a1e91ba065a11ea96e99e73d2700a9c53c072b4921b72245aef624d38f6',
        21384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduNSWACTFoundation',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu NSW ACT Foundation font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+NSW+ACT+Foundation
  static TextTheme eduNswActFoundationTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduNswActFoundation(textStyle: textTheme.displayLarge),
      displayMedium: eduNswActFoundation(textStyle: textTheme.displayMedium),
      displaySmall: eduNswActFoundation(textStyle: textTheme.displaySmall),
      headlineLarge: eduNswActFoundation(textStyle: textTheme.headlineLarge),
      headlineMedium: eduNswActFoundation(textStyle: textTheme.headlineMedium),
      headlineSmall: eduNswActFoundation(textStyle: textTheme.headlineSmall),
      titleLarge: eduNswActFoundation(textStyle: textTheme.titleLarge),
      titleMedium: eduNswActFoundation(textStyle: textTheme.titleMedium),
      titleSmall: eduNswActFoundation(textStyle: textTheme.titleSmall),
      bodyLarge: eduNswActFoundation(textStyle: textTheme.bodyLarge),
      bodyMedium: eduNswActFoundation(textStyle: textTheme.bodyMedium),
      bodySmall: eduNswActFoundation(textStyle: textTheme.bodySmall),
      labelLarge: eduNswActFoundation(textStyle: textTheme.labelLarge),
      labelMedium: eduNswActFoundation(textStyle: textTheme.labelMedium),
      labelSmall: eduNswActFoundation(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu QLD Beginner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+QLD+Beginner
  static TextStyle eduQldBeginner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e68ac554d376d0be4102c6d0a5697662844d25fc31591e9065f9ea6c658efc3c',
        21300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c497a35a9d6f2c8062c155e04c85b6334c6786c0f4852b4aa350a7a5742271d',
        21424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3105f370bd4245b51fa81b547e811bf18d44850e6be5cab1780dcb50479fa1d6',
        21428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9a0a2cf40a72a69229f962ca6fd62f9d151922cdf4cc587778934eb8ecd75ad',
        21256,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduQLDBeginner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu QLD Beginner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+QLD+Beginner
  static TextTheme eduQldBeginnerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduQldBeginner(textStyle: textTheme.displayLarge),
      displayMedium: eduQldBeginner(textStyle: textTheme.displayMedium),
      displaySmall: eduQldBeginner(textStyle: textTheme.displaySmall),
      headlineLarge: eduQldBeginner(textStyle: textTheme.headlineLarge),
      headlineMedium: eduQldBeginner(textStyle: textTheme.headlineMedium),
      headlineSmall: eduQldBeginner(textStyle: textTheme.headlineSmall),
      titleLarge: eduQldBeginner(textStyle: textTheme.titleLarge),
      titleMedium: eduQldBeginner(textStyle: textTheme.titleMedium),
      titleSmall: eduQldBeginner(textStyle: textTheme.titleSmall),
      bodyLarge: eduQldBeginner(textStyle: textTheme.bodyLarge),
      bodyMedium: eduQldBeginner(textStyle: textTheme.bodyMedium),
      bodySmall: eduQldBeginner(textStyle: textTheme.bodySmall),
      labelLarge: eduQldBeginner(textStyle: textTheme.labelLarge),
      labelMedium: eduQldBeginner(textStyle: textTheme.labelMedium),
      labelSmall: eduQldBeginner(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu SA Beginner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+SA+Beginner
  static TextStyle eduSaBeginner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4195f037ad3de44a106b5160fdda5f9242989fdfbe7badec1b8a2e65fa0522bb',
        19820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b81931e8671acea0500fbea4be7134528b9e37333928f80b76c22352beb5c297',
        19852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79a6e4adcdf5f036c437e5ddefcfdcb48b72e5949efd151a9e54c01f8976b44b',
        19860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92e228cb02155243722f45a42e523d044e8fda6f799b7524b194d98c61651599',
        19780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduSABeginner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu SA Beginner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+SA+Beginner
  static TextTheme eduSaBeginnerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduSaBeginner(textStyle: textTheme.displayLarge),
      displayMedium: eduSaBeginner(textStyle: textTheme.displayMedium),
      displaySmall: eduSaBeginner(textStyle: textTheme.displaySmall),
      headlineLarge: eduSaBeginner(textStyle: textTheme.headlineLarge),
      headlineMedium: eduSaBeginner(textStyle: textTheme.headlineMedium),
      headlineSmall: eduSaBeginner(textStyle: textTheme.headlineSmall),
      titleLarge: eduSaBeginner(textStyle: textTheme.titleLarge),
      titleMedium: eduSaBeginner(textStyle: textTheme.titleMedium),
      titleSmall: eduSaBeginner(textStyle: textTheme.titleSmall),
      bodyLarge: eduSaBeginner(textStyle: textTheme.bodyLarge),
      bodyMedium: eduSaBeginner(textStyle: textTheme.bodyMedium),
      bodySmall: eduSaBeginner(textStyle: textTheme.bodySmall),
      labelLarge: eduSaBeginner(textStyle: textTheme.labelLarge),
      labelMedium: eduSaBeginner(textStyle: textTheme.labelMedium),
      labelSmall: eduSaBeginner(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu TAS Beginner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+TAS+Beginner
  static TextStyle eduTasBeginner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d1d5ba124b10b56e9721a80854dccf76726df4a9485e78747393bb91afebdff',
        20116,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11e99202abf736bd6261a740aa1d6aecb61473f7c2c487093a2c4f431ca89354',
        20140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31d6bdf42b46bebf1eaa234ffaf47349aeb1b4f29a4a9619115febc504f79d33',
        20144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'afe49cec3acbf9250888c096c8596b6847dd8d2cd1f0a834d65cb6fee5eb299d',
        20056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduTASBeginner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu TAS Beginner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+TAS+Beginner
  static TextTheme eduTasBeginnerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduTasBeginner(textStyle: textTheme.displayLarge),
      displayMedium: eduTasBeginner(textStyle: textTheme.displayMedium),
      displaySmall: eduTasBeginner(textStyle: textTheme.displaySmall),
      headlineLarge: eduTasBeginner(textStyle: textTheme.headlineLarge),
      headlineMedium: eduTasBeginner(textStyle: textTheme.headlineMedium),
      headlineSmall: eduTasBeginner(textStyle: textTheme.headlineSmall),
      titleLarge: eduTasBeginner(textStyle: textTheme.titleLarge),
      titleMedium: eduTasBeginner(textStyle: textTheme.titleMedium),
      titleSmall: eduTasBeginner(textStyle: textTheme.titleSmall),
      bodyLarge: eduTasBeginner(textStyle: textTheme.bodyLarge),
      bodyMedium: eduTasBeginner(textStyle: textTheme.bodyMedium),
      bodySmall: eduTasBeginner(textStyle: textTheme.bodySmall),
      labelLarge: eduTasBeginner(textStyle: textTheme.labelLarge),
      labelMedium: eduTasBeginner(textStyle: textTheme.labelMedium),
      labelSmall: eduTasBeginner(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Edu VIC WA NT Beginner font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+VIC+WA+NT+Beginner
  static TextStyle eduVicWaNtBeginner({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba8ec1690b2af4728f6929a23045cf8b5b0ed1ecf6b34b3f9396e161cb97fb39',
        20196,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6942edbe9906d81ea89b247ae2aed1d6fe57c113933c92ecf3e83bb01722762c',
        20272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb17f0fcffc5b049843e2e13b189b25921103c1949d7fa54aa6a0d298d45a6ee',
        20272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a86048ad05defe2c58137d22dd619409d753db184f9a6fb90865e688914d1ebf',
        20156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EduVICWANTBeginner',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Edu VIC WA NT Beginner font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Edu+VIC+WA+NT+Beginner
  static TextTheme eduVicWaNtBeginnerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: eduVicWaNtBeginner(textStyle: textTheme.displayLarge),
      displayMedium: eduVicWaNtBeginner(textStyle: textTheme.displayMedium),
      displaySmall: eduVicWaNtBeginner(textStyle: textTheme.displaySmall),
      headlineLarge: eduVicWaNtBeginner(textStyle: textTheme.headlineLarge),
      headlineMedium: eduVicWaNtBeginner(textStyle: textTheme.headlineMedium),
      headlineSmall: eduVicWaNtBeginner(textStyle: textTheme.headlineSmall),
      titleLarge: eduVicWaNtBeginner(textStyle: textTheme.titleLarge),
      titleMedium: eduVicWaNtBeginner(textStyle: textTheme.titleMedium),
      titleSmall: eduVicWaNtBeginner(textStyle: textTheme.titleSmall),
      bodyLarge: eduVicWaNtBeginner(textStyle: textTheme.bodyLarge),
      bodyMedium: eduVicWaNtBeginner(textStyle: textTheme.bodyMedium),
      bodySmall: eduVicWaNtBeginner(textStyle: textTheme.bodySmall),
      labelLarge: eduVicWaNtBeginner(textStyle: textTheme.labelLarge),
      labelMedium: eduVicWaNtBeginner(textStyle: textTheme.labelMedium),
      labelSmall: eduVicWaNtBeginner(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the El Messiri font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/El+Messiri
  static TextStyle elMessiri({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a571d8e136af17339c2811184197254fd371d7d1042c9fc2e6e0d08a1349cb3b',
        83700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3937c674b40c2a27a0e78e738dab1cef40d94148c9a70041f7d37ae1c3fc288a',
        84120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f16151cd5d65891079d4b262cd7801000fba7046ad09176c8759832b50f4240e',
        84244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb22fb98f0cf472083ac102ccf94ed5279d330395c67a659beca6cc22928467b',
        83860,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ElMessiri',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the El Messiri font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/El+Messiri
  static TextTheme elMessiriTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: elMessiri(textStyle: textTheme.displayLarge),
      displayMedium: elMessiri(textStyle: textTheme.displayMedium),
      displaySmall: elMessiri(textStyle: textTheme.displaySmall),
      headlineLarge: elMessiri(textStyle: textTheme.headlineLarge),
      headlineMedium: elMessiri(textStyle: textTheme.headlineMedium),
      headlineSmall: elMessiri(textStyle: textTheme.headlineSmall),
      titleLarge: elMessiri(textStyle: textTheme.titleLarge),
      titleMedium: elMessiri(textStyle: textTheme.titleMedium),
      titleSmall: elMessiri(textStyle: textTheme.titleSmall),
      bodyLarge: elMessiri(textStyle: textTheme.bodyLarge),
      bodyMedium: elMessiri(textStyle: textTheme.bodyMedium),
      bodySmall: elMessiri(textStyle: textTheme.bodySmall),
      labelLarge: elMessiri(textStyle: textTheme.labelLarge),
      labelMedium: elMessiri(textStyle: textTheme.labelMedium),
      labelSmall: elMessiri(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Electrolize font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Electrolize
  static TextStyle electrolize({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '061301864f942cec3206f6216be568aaee5d02f9f297633ffc8d9142da1d0b1b',
        23228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Electrolize',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Electrolize font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Electrolize
  static TextTheme electrolizeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: electrolize(textStyle: textTheme.displayLarge),
      displayMedium: electrolize(textStyle: textTheme.displayMedium),
      displaySmall: electrolize(textStyle: textTheme.displaySmall),
      headlineLarge: electrolize(textStyle: textTheme.headlineLarge),
      headlineMedium: electrolize(textStyle: textTheme.headlineMedium),
      headlineSmall: electrolize(textStyle: textTheme.headlineSmall),
      titleLarge: electrolize(textStyle: textTheme.titleLarge),
      titleMedium: electrolize(textStyle: textTheme.titleMedium),
      titleSmall: electrolize(textStyle: textTheme.titleSmall),
      bodyLarge: electrolize(textStyle: textTheme.bodyLarge),
      bodyMedium: electrolize(textStyle: textTheme.bodyMedium),
      bodySmall: electrolize(textStyle: textTheme.bodySmall),
      labelLarge: electrolize(textStyle: textTheme.labelLarge),
      labelMedium: electrolize(textStyle: textTheme.labelMedium),
      labelSmall: electrolize(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Elsie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Elsie
  static TextStyle elsie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3fb309aabca6cfccee5f7d6f98c5af435d1e41461f5268d3a09b0d1ddfad5104',
        34260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b55c736bb96753da69b0608cda78127720d486287ff7222d161559a8e7ece2bc',
        35008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Elsie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Elsie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Elsie
  static TextTheme elsieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: elsie(textStyle: textTheme.displayLarge),
      displayMedium: elsie(textStyle: textTheme.displayMedium),
      displaySmall: elsie(textStyle: textTheme.displaySmall),
      headlineLarge: elsie(textStyle: textTheme.headlineLarge),
      headlineMedium: elsie(textStyle: textTheme.headlineMedium),
      headlineSmall: elsie(textStyle: textTheme.headlineSmall),
      titleLarge: elsie(textStyle: textTheme.titleLarge),
      titleMedium: elsie(textStyle: textTheme.titleMedium),
      titleSmall: elsie(textStyle: textTheme.titleSmall),
      bodyLarge: elsie(textStyle: textTheme.bodyLarge),
      bodyMedium: elsie(textStyle: textTheme.bodyMedium),
      bodySmall: elsie(textStyle: textTheme.bodySmall),
      labelLarge: elsie(textStyle: textTheme.labelLarge),
      labelMedium: elsie(textStyle: textTheme.labelMedium),
      labelSmall: elsie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Elsie Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Elsie+Swash+Caps
  static TextStyle elsieSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7bc1b06fa9a799ffb0c6a69b0d860b03d61783e535fc3c66b97a9be9cc8365a',
        35956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9c93d2befdb49aa4d140260f06b38dcc48d6cda6ffcf0e0510fcb60666af9f4',
        36248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ElsieSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Elsie Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Elsie+Swash+Caps
  static TextTheme elsieSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: elsieSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium: elsieSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall: elsieSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge: elsieSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: elsieSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: elsieSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: elsieSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: elsieSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: elsieSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: elsieSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: elsieSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: elsieSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: elsieSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: elsieSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: elsieSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Emblema One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Emblema+One
  static TextStyle emblemaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d31f4b48de9ab1b609f7b65cbd09b91d66eb8c1650df95299970243afaf747d',
        56192,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EmblemaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Emblema One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Emblema+One
  static TextTheme emblemaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: emblemaOne(textStyle: textTheme.displayLarge),
      displayMedium: emblemaOne(textStyle: textTheme.displayMedium),
      displaySmall: emblemaOne(textStyle: textTheme.displaySmall),
      headlineLarge: emblemaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: emblemaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: emblemaOne(textStyle: textTheme.headlineSmall),
      titleLarge: emblemaOne(textStyle: textTheme.titleLarge),
      titleMedium: emblemaOne(textStyle: textTheme.titleMedium),
      titleSmall: emblemaOne(textStyle: textTheme.titleSmall),
      bodyLarge: emblemaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: emblemaOne(textStyle: textTheme.bodyMedium),
      bodySmall: emblemaOne(textStyle: textTheme.bodySmall),
      labelLarge: emblemaOne(textStyle: textTheme.labelLarge),
      labelMedium: emblemaOne(textStyle: textTheme.labelMedium),
      labelSmall: emblemaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Emilys Candy font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Emilys+Candy
  static TextStyle emilysCandy({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '345aa4c6d86de050ba87f4721f42ca6edf7788f833fb8b74872c98341c9d0daa',
        234812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EmilysCandy',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Emilys Candy font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Emilys+Candy
  static TextTheme emilysCandyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: emilysCandy(textStyle: textTheme.displayLarge),
      displayMedium: emilysCandy(textStyle: textTheme.displayMedium),
      displaySmall: emilysCandy(textStyle: textTheme.displaySmall),
      headlineLarge: emilysCandy(textStyle: textTheme.headlineLarge),
      headlineMedium: emilysCandy(textStyle: textTheme.headlineMedium),
      headlineSmall: emilysCandy(textStyle: textTheme.headlineSmall),
      titleLarge: emilysCandy(textStyle: textTheme.titleLarge),
      titleMedium: emilysCandy(textStyle: textTheme.titleMedium),
      titleSmall: emilysCandy(textStyle: textTheme.titleSmall),
      bodyLarge: emilysCandy(textStyle: textTheme.bodyLarge),
      bodyMedium: emilysCandy(textStyle: textTheme.bodyMedium),
      bodySmall: emilysCandy(textStyle: textTheme.bodySmall),
      labelLarge: emilysCandy(textStyle: textTheme.labelLarge),
      labelMedium: emilysCandy(textStyle: textTheme.labelMedium),
      labelSmall: emilysCandy(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans
  static TextStyle encodeSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1786d06d7ebe6f5a17494ce5a5cc2adc50680938731c2ebcbebc18d0e5337ffd',
        79620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e0177e677798b477c083d2a4bd455fe1dfe686ff12a9ebb6acf1644df1e3eb9',
        80036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b31686d9d8999948862168cc0f27b21c10cf4e5d403611a1fae163254b3af0a',
        80140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfa43a134be926e1220e3cbff4974a0a27611e828dc60b08f2efefab3b9b6742',
        80168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '86eb91f4d9294fa3bbc3af3c7931cf0b75630e17ac71c19da8b2d10bf725b25d',
        80248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '200f33a76616573b41b800316d2a717e3d7ad54f715d9edbfb4aa11dd3e66dfa',
        80380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '384165cb98c576eddd7dab4c383af0e6414d54eefc5de13537412e6276f67336',
        80632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da3da0e6b932f90b840d45ec4035f077c89ada05a4a945d25c8b219a0deeba8b',
        80880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09d2516fd05b5c6752ea157cc983e127e8de5184fc88071284c44ecddc185455',
        80560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans
  static TextTheme encodeSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSans(textStyle: textTheme.displayLarge),
      displayMedium: encodeSans(textStyle: textTheme.displayMedium),
      displaySmall: encodeSans(textStyle: textTheme.displaySmall),
      headlineLarge: encodeSans(textStyle: textTheme.headlineLarge),
      headlineMedium: encodeSans(textStyle: textTheme.headlineMedium),
      headlineSmall: encodeSans(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSans(textStyle: textTheme.titleLarge),
      titleMedium: encodeSans(textStyle: textTheme.titleMedium),
      titleSmall: encodeSans(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSans(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSans(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSans(textStyle: textTheme.bodySmall),
      labelLarge: encodeSans(textStyle: textTheme.labelLarge),
      labelMedium: encodeSans(textStyle: textTheme.labelMedium),
      labelSmall: encodeSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Condensed
  static TextStyle encodeSansCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32a4d643beae836e02495e4359ca73851bc62d3b2c6627c061971ed2ccedd512',
        80192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4707b802a294e2869f197f4872c380c450e87e19ff5733f4a8c84ebd8365faa6',
        81696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98a097efa087c6a845bfb8dd8118f055ea3d07fd29902eb41861f5fecd0f1cdc',
        81404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf2e49c42240256e5299657666aba1e2e68698c55dab2578bc2f135c0c792b72',
        81360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ab89dab84826394290148ec707d5e265ecc2d5c8dd4222fe294d0334611d8d2',
        81280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '704fe1038026f8b9d49ade91acfb1d1f202652cb27681c4bef74e81372755690',
        81088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba516c62a09769502a8c80635ffb54126b1d44b1a5af06942609c0e57748e253',
        81492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ce8a15df6961e1d3a5be8b76b195c5454a59a1b262cba772cf80ec2c2234e88',
        81976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '959dbf80c7f97a9b3bedfc3b3eefe14ffc1b49de2e54bc36dde5be7665aef9db',
        81064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSansCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Condensed
  static TextTheme encodeSansCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSansCondensed(textStyle: textTheme.displayLarge),
      displayMedium: encodeSansCondensed(textStyle: textTheme.displayMedium),
      displaySmall: encodeSansCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: encodeSansCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: encodeSansCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: encodeSansCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSansCondensed(textStyle: textTheme.titleLarge),
      titleMedium: encodeSansCondensed(textStyle: textTheme.titleMedium),
      titleSmall: encodeSansCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSansCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSansCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSansCondensed(textStyle: textTheme.bodySmall),
      labelLarge: encodeSansCondensed(textStyle: textTheme.labelLarge),
      labelMedium: encodeSansCondensed(textStyle: textTheme.labelMedium),
      labelSmall: encodeSansCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Expanded
  static TextStyle encodeSansExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3167c0972395baee92aede3b1f9ff7c41768d92132ce650e8d2b5ac67865f7bc',
        80520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '76b4c679c36680a29a304d9d3be38ea108f9d7dde793334e0b3524277f081679',
        81552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '393853b7750153821b84eb8e5a00674fc382b507cf362e3d530b44b5d48e020e',
        81448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1ab763f7aa1d4ee4486a538fa590f6f43447c3dd4c27e3b616daf3cad12e22a',
        81428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5ee0cd555e630f1791d365acd73827424898dca6b457e6e085e01c6500feed9',
        81476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c55ccc220aec42f27c676b7b9d3d5ce20010a3322e5aae8d3242dcfa6c462afd',
        81576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c78a8901681de4d3cbca7734c6b676ea5a19fb70f71c4e4455d55a59aae2b0b',
        81856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7ec3ea72590b5b97698de613aa4fb9150721a76e2bed9217c50d37f812e4a87',
        82056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79eb9cb36d91e7070d2979961365f39c0c471a38f47cd865d219207ab4e8b82d',
        81328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSansExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Expanded
  static TextTheme encodeSansExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSansExpanded(textStyle: textTheme.displayLarge),
      displayMedium: encodeSansExpanded(textStyle: textTheme.displayMedium),
      displaySmall: encodeSansExpanded(textStyle: textTheme.displaySmall),
      headlineLarge: encodeSansExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium: encodeSansExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall: encodeSansExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSansExpanded(textStyle: textTheme.titleLarge),
      titleMedium: encodeSansExpanded(textStyle: textTheme.titleMedium),
      titleSmall: encodeSansExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSansExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSansExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSansExpanded(textStyle: textTheme.bodySmall),
      labelLarge: encodeSansExpanded(textStyle: textTheme.labelLarge),
      labelMedium: encodeSansExpanded(textStyle: textTheme.labelMedium),
      labelSmall: encodeSansExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+SC
  static TextStyle encodeSansSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ab09044ec8f72d95459741d94deaf801444474b571bc1ecd440acd383146cdc',
        69040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d071a3abc874ed2b54c933a95d144a2352ecfca1b3774c98078b291d129315b',
        69280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '350ad4d895ac4197334dec7b303602867dd9d737599fd2c9710ad8a8eef25ef4',
        69436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ad63ce575fefecb78820ab2fd01f1498e41be056f595c93c7a780a4d7203603',
        69488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4afac9bbd6c3eb614f212da8fe8c55289b2c1444c5327cb56cf5cf84b42f4b7',
        69556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95672c5952dd4818807878395914f248898750ddc3d7cf594fcd5db38b2e2360',
        69676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfdfd9406a2d9e8646bab70e2592083c2772b2d40687ee49cd58d3d015a3634a',
        69900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d0c922332fcda62ea0b62a3996fa267a71f6a4e5a3f3a056f82fbf2a88cb9d6',
        70052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0e95f676e426636159b70e0a8723c0fe1395a3cbf9751b018fa561d10d3b6eb',
        69724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSansSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+SC
  static TextTheme encodeSansScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSansSc(textStyle: textTheme.displayLarge),
      displayMedium: encodeSansSc(textStyle: textTheme.displayMedium),
      displaySmall: encodeSansSc(textStyle: textTheme.displaySmall),
      headlineLarge: encodeSansSc(textStyle: textTheme.headlineLarge),
      headlineMedium: encodeSansSc(textStyle: textTheme.headlineMedium),
      headlineSmall: encodeSansSc(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSansSc(textStyle: textTheme.titleLarge),
      titleMedium: encodeSansSc(textStyle: textTheme.titleMedium),
      titleSmall: encodeSansSc(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSansSc(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSansSc(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSansSc(textStyle: textTheme.bodySmall),
      labelLarge: encodeSansSc(textStyle: textTheme.labelLarge),
      labelMedium: encodeSansSc(textStyle: textTheme.labelMedium),
      labelSmall: encodeSansSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans Semi Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Semi+Condensed
  static TextStyle encodeSansSemiCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '632d6a8a3a3b6070ecc562fd0a3756e3b38f57733591df51477e5282451c19aa',
        80156,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1865faabd988f44ada35843f28cf05194e69fddd65497550670da5266b14f2c',
        81832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '177da5b781e416c9084fd7c4d21b2299cca65987d8f2913f1850c0bf3deb56ab',
        81624,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4a0ba17a56bd6ed75176b03b6572bc41ed7fb01bed84936af108d1afe3d5c9ea',
        81636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b39b05f83be1bc32339f483bf98b6d222e1c7e4eebb41e156f565f3885b375a9',
        81276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f6c0f5b469cf3aeceb4301270c1e03a0b3d9f434fdeb8939f04c3d23c36c2cb',
        81452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9760fdfa30fd4e220c21577703c55c62cf6a304b9f456a7645e38a455c28066f',
        81816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3025eade51c77fd7410a14c586248db6ad12055f1c859c460541e71d3587ab72',
        82160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30feb8bd88c81e54fa9b51d0c4859400e8b74d93574608a397f43dc979111623',
        81440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSansSemiCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans Semi Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Semi+Condensed
  static TextTheme encodeSansSemiCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSansSemiCondensed(textStyle: textTheme.displayLarge),
      displayMedium:
          encodeSansSemiCondensed(textStyle: textTheme.displayMedium),
      displaySmall: encodeSansSemiCondensed(textStyle: textTheme.displaySmall),
      headlineLarge:
          encodeSansSemiCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium:
          encodeSansSemiCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall:
          encodeSansSemiCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSansSemiCondensed(textStyle: textTheme.titleLarge),
      titleMedium: encodeSansSemiCondensed(textStyle: textTheme.titleMedium),
      titleSmall: encodeSansSemiCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSansSemiCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSansSemiCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSansSemiCondensed(textStyle: textTheme.bodySmall),
      labelLarge: encodeSansSemiCondensed(textStyle: textTheme.labelLarge),
      labelMedium: encodeSansSemiCondensed(textStyle: textTheme.labelMedium),
      labelSmall: encodeSansSemiCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Encode Sans Semi Expanded font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Semi+Expanded
  static TextStyle encodeSansSemiExpanded({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24cf5f96ebfab8974e9d22281b222ec0b53fd93a239f9c7678011413d65d178e',
        80288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd94b3681c6f145427679b00dd007c89e33f0645afae87cee56f02ff509e3182',
        81904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21fa95fec27006f0dd478162275fc7cb8d194018d6880741c1fc4450921c3ac6',
        81760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57d9c98c58e5acb342059f847b7e6fda31afc5a1e3fcd96159e1777d7611bdc2',
        81844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '884d05f8245e0d582416499f4dccc6f2232d6c78583a0f79d17bb6123a5231a2',
        81508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ebaacf4111bc020a52fb29ea96f5258da27806287800aaa287b1f76b15e4e23',
        81736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fc544d86c906e765d26f18446b10d056868d7f1e0da85f81f1824bef961b834',
        81996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '986ba3f6c742ae86cec8b92d009b1d0f5ccbb37f97cc3083844abf0bfdae5688',
        82260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '334b41368d45e746af2945a52cb48b412194d1db6d4feaef5024ae089f32eedb',
        81528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EncodeSansSemiExpanded',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Encode Sans Semi Expanded font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Encode+Sans+Semi+Expanded
  static TextTheme encodeSansSemiExpandedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: encodeSansSemiExpanded(textStyle: textTheme.displayLarge),
      displayMedium: encodeSansSemiExpanded(textStyle: textTheme.displayMedium),
      displaySmall: encodeSansSemiExpanded(textStyle: textTheme.displaySmall),
      headlineLarge: encodeSansSemiExpanded(textStyle: textTheme.headlineLarge),
      headlineMedium:
          encodeSansSemiExpanded(textStyle: textTheme.headlineMedium),
      headlineSmall: encodeSansSemiExpanded(textStyle: textTheme.headlineSmall),
      titleLarge: encodeSansSemiExpanded(textStyle: textTheme.titleLarge),
      titleMedium: encodeSansSemiExpanded(textStyle: textTheme.titleMedium),
      titleSmall: encodeSansSemiExpanded(textStyle: textTheme.titleSmall),
      bodyLarge: encodeSansSemiExpanded(textStyle: textTheme.bodyLarge),
      bodyMedium: encodeSansSemiExpanded(textStyle: textTheme.bodyMedium),
      bodySmall: encodeSansSemiExpanded(textStyle: textTheme.bodySmall),
      labelLarge: encodeSansSemiExpanded(textStyle: textTheme.labelLarge),
      labelMedium: encodeSansSemiExpanded(textStyle: textTheme.labelMedium),
      labelSmall: encodeSansSemiExpanded(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Engagement font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Engagement
  static TextStyle engagement({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '062895711bee7ca63df3999cf6656f0ab2435ba2091861d21428c1b523c2d83c',
        73016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Engagement',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Engagement font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Engagement
  static TextTheme engagementTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: engagement(textStyle: textTheme.displayLarge),
      displayMedium: engagement(textStyle: textTheme.displayMedium),
      displaySmall: engagement(textStyle: textTheme.displaySmall),
      headlineLarge: engagement(textStyle: textTheme.headlineLarge),
      headlineMedium: engagement(textStyle: textTheme.headlineMedium),
      headlineSmall: engagement(textStyle: textTheme.headlineSmall),
      titleLarge: engagement(textStyle: textTheme.titleLarge),
      titleMedium: engagement(textStyle: textTheme.titleMedium),
      titleSmall: engagement(textStyle: textTheme.titleSmall),
      bodyLarge: engagement(textStyle: textTheme.bodyLarge),
      bodyMedium: engagement(textStyle: textTheme.bodyMedium),
      bodySmall: engagement(textStyle: textTheme.bodySmall),
      labelLarge: engagement(textStyle: textTheme.labelLarge),
      labelMedium: engagement(textStyle: textTheme.labelMedium),
      labelSmall: engagement(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Englebert font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Englebert
  static TextStyle englebert({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '99cf4ba03fd06ea1dadc9be8da121bd3c4311a3002116e9ef88f121ed52b65b8',
        50444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Englebert',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Englebert font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Englebert
  static TextTheme englebertTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: englebert(textStyle: textTheme.displayLarge),
      displayMedium: englebert(textStyle: textTheme.displayMedium),
      displaySmall: englebert(textStyle: textTheme.displaySmall),
      headlineLarge: englebert(textStyle: textTheme.headlineLarge),
      headlineMedium: englebert(textStyle: textTheme.headlineMedium),
      headlineSmall: englebert(textStyle: textTheme.headlineSmall),
      titleLarge: englebert(textStyle: textTheme.titleLarge),
      titleMedium: englebert(textStyle: textTheme.titleMedium),
      titleSmall: englebert(textStyle: textTheme.titleSmall),
      bodyLarge: englebert(textStyle: textTheme.bodyLarge),
      bodyMedium: englebert(textStyle: textTheme.bodyMedium),
      bodySmall: englebert(textStyle: textTheme.bodySmall),
      labelLarge: englebert(textStyle: textTheme.labelLarge),
      labelMedium: englebert(textStyle: textTheme.labelMedium),
      labelSmall: englebert(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Enriqueta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Enriqueta
  static TextStyle enriqueta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9100f07ac8715b8945f82a9ab2e632126b79351b5a7ff837b937844a5674e134',
        44204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82a44f7df6c429b383636323c1375f420dea8bf53bb953f00eb745357f8f2746',
        44752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09dcb35c96ec6c906a017497f8b280debc73b021016c38f0a23f0d928816dc90',
        44380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f52d639d7593820a9c96b0d28fa7c967323dfc10f81d562f1508c7e1a64e28cb',
        44556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Enriqueta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Enriqueta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Enriqueta
  static TextTheme enriquetaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: enriqueta(textStyle: textTheme.displayLarge),
      displayMedium: enriqueta(textStyle: textTheme.displayMedium),
      displaySmall: enriqueta(textStyle: textTheme.displaySmall),
      headlineLarge: enriqueta(textStyle: textTheme.headlineLarge),
      headlineMedium: enriqueta(textStyle: textTheme.headlineMedium),
      headlineSmall: enriqueta(textStyle: textTheme.headlineSmall),
      titleLarge: enriqueta(textStyle: textTheme.titleLarge),
      titleMedium: enriqueta(textStyle: textTheme.titleMedium),
      titleSmall: enriqueta(textStyle: textTheme.titleSmall),
      bodyLarge: enriqueta(textStyle: textTheme.bodyLarge),
      bodyMedium: enriqueta(textStyle: textTheme.bodyMedium),
      bodySmall: enriqueta(textStyle: textTheme.bodySmall),
      labelLarge: enriqueta(textStyle: textTheme.labelLarge),
      labelMedium: enriqueta(textStyle: textTheme.labelMedium),
      labelSmall: enriqueta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ephesis font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ephesis
  static TextStyle ephesis({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '42a02de01e8cbc58acf379f32757e65902e312e7f5225f7658a98f85a4098e17',
        89276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ephesis',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ephesis font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ephesis
  static TextTheme ephesisTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ephesis(textStyle: textTheme.displayLarge),
      displayMedium: ephesis(textStyle: textTheme.displayMedium),
      displaySmall: ephesis(textStyle: textTheme.displaySmall),
      headlineLarge: ephesis(textStyle: textTheme.headlineLarge),
      headlineMedium: ephesis(textStyle: textTheme.headlineMedium),
      headlineSmall: ephesis(textStyle: textTheme.headlineSmall),
      titleLarge: ephesis(textStyle: textTheme.titleLarge),
      titleMedium: ephesis(textStyle: textTheme.titleMedium),
      titleSmall: ephesis(textStyle: textTheme.titleSmall),
      bodyLarge: ephesis(textStyle: textTheme.bodyLarge),
      bodyMedium: ephesis(textStyle: textTheme.bodyMedium),
      bodySmall: ephesis(textStyle: textTheme.bodySmall),
      labelLarge: ephesis(textStyle: textTheme.labelLarge),
      labelMedium: ephesis(textStyle: textTheme.labelMedium),
      labelSmall: ephesis(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Epilogue font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Epilogue
  static TextStyle epilogue({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f51e229dd565aa0ae565b3c4bc782e585961c60f67d8b8ff42646fb62d3eab9',
        69580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98e48c072ec741339f5d7ab94e0c1d72ee6c0ccb9b8372a39e385d018c2ef205',
        69700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02edb2e1951433b87c040480c9d39fc66f5c04e98166c891ca03571b731e075e',
        69696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89fa3111e07b2fd0ce0654b4162c63501ae0bd6dab54fe8c48735aca30633362',
        69720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f986152a602a4b255cc587775522ee854fb2356e37407fa918798b310b7f5087',
        69828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f69dc2350a2d9e0b0205d8a1059dd94ae2e384ad3d6f68de0e35ad6c305958d3',
        70020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05b9f07ef1c18dd00732e7ef35809313c9d6d935ab6e9f620140b46510520d72',
        69944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbe57ac5c61c162a1e1c71057d30ac3d9df786e0d43622c99a9677e8a73c3e67',
        70128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d05593a3e0a1a5c17d04178b18efaecca02379efbb035b1fc30df4a9362a206',
        70132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b4f11f4928feb631ce5a0737580ce351545c0bcaf7927415a259b945e3a56696',
        69960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bc1c12351f2a94faeb25a7629c3fdf8b39a9566856c50df95e9afdd6a4b509a3',
        70068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '247e50a0b59cd3d283b0bc0600d61efff94dfc6fadafa8a3103be2e301b90c4a',
        69988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b7140afc275f270dd862eb177d29d032a720c329ad9a9abedb960ff625185683',
        69856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '516cb327e7cb068a3703f79f7ef869db98eca188c67f2159c2a8fa76b07af630',
        70052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '92fb8d745eae09724f4f95a319c3fd4d76952cee20acc50c552ced8e97d066e6',
        70128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ea364d7178f875b1624caecc3ad07f671aabaaefca535be2ab4351db1c36d88f',
        70160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f6c94addfea4c1e81794c426fdbec9e5717c3db88c0009280abe36e9ab01095b',
        70376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b90961f94b327db4d422381e9b2ae897e310767f0347755f8b069c7be50654e8',
        70260,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Epilogue',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Epilogue font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Epilogue
  static TextTheme epilogueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: epilogue(textStyle: textTheme.displayLarge),
      displayMedium: epilogue(textStyle: textTheme.displayMedium),
      displaySmall: epilogue(textStyle: textTheme.displaySmall),
      headlineLarge: epilogue(textStyle: textTheme.headlineLarge),
      headlineMedium: epilogue(textStyle: textTheme.headlineMedium),
      headlineSmall: epilogue(textStyle: textTheme.headlineSmall),
      titleLarge: epilogue(textStyle: textTheme.titleLarge),
      titleMedium: epilogue(textStyle: textTheme.titleMedium),
      titleSmall: epilogue(textStyle: textTheme.titleSmall),
      bodyLarge: epilogue(textStyle: textTheme.bodyLarge),
      bodyMedium: epilogue(textStyle: textTheme.bodyMedium),
      bodySmall: epilogue(textStyle: textTheme.bodySmall),
      labelLarge: epilogue(textStyle: textTheme.labelLarge),
      labelMedium: epilogue(textStyle: textTheme.labelMedium),
      labelSmall: epilogue(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Erica One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Erica+One
  static TextStyle ericaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a624a4cacea2af9dd29569150c252c0f220c1e5d9f4cf7ec754b6f4240d25578',
        24332,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EricaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Erica One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Erica+One
  static TextTheme ericaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ericaOne(textStyle: textTheme.displayLarge),
      displayMedium: ericaOne(textStyle: textTheme.displayMedium),
      displaySmall: ericaOne(textStyle: textTheme.displaySmall),
      headlineLarge: ericaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: ericaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: ericaOne(textStyle: textTheme.headlineSmall),
      titleLarge: ericaOne(textStyle: textTheme.titleLarge),
      titleMedium: ericaOne(textStyle: textTheme.titleMedium),
      titleSmall: ericaOne(textStyle: textTheme.titleSmall),
      bodyLarge: ericaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: ericaOne(textStyle: textTheme.bodyMedium),
      bodySmall: ericaOne(textStyle: textTheme.bodySmall),
      labelLarge: ericaOne(textStyle: textTheme.labelLarge),
      labelMedium: ericaOne(textStyle: textTheme.labelMedium),
      labelSmall: ericaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Esteban font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Esteban
  static TextStyle esteban({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33469ddbf2f8b25aa9577a76ed3191c10ba359c06541da8ff214fbbb6968d6a6',
        41436,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Esteban',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Esteban font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Esteban
  static TextTheme estebanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: esteban(textStyle: textTheme.displayLarge),
      displayMedium: esteban(textStyle: textTheme.displayMedium),
      displaySmall: esteban(textStyle: textTheme.displaySmall),
      headlineLarge: esteban(textStyle: textTheme.headlineLarge),
      headlineMedium: esteban(textStyle: textTheme.headlineMedium),
      headlineSmall: esteban(textStyle: textTheme.headlineSmall),
      titleLarge: esteban(textStyle: textTheme.titleLarge),
      titleMedium: esteban(textStyle: textTheme.titleMedium),
      titleSmall: esteban(textStyle: textTheme.titleSmall),
      bodyLarge: esteban(textStyle: textTheme.bodyLarge),
      bodyMedium: esteban(textStyle: textTheme.bodyMedium),
      bodySmall: esteban(textStyle: textTheme.bodySmall),
      labelLarge: esteban(textStyle: textTheme.labelLarge),
      labelMedium: esteban(textStyle: textTheme.labelMedium),
      labelSmall: esteban(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Estonia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Estonia
  static TextStyle estonia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b003ff269142fecb56aa0db798a61c6cba8f997fe1bd5f6081fab3e56133cbc8',
        383840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Estonia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Estonia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Estonia
  static TextTheme estoniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: estonia(textStyle: textTheme.displayLarge),
      displayMedium: estonia(textStyle: textTheme.displayMedium),
      displaySmall: estonia(textStyle: textTheme.displaySmall),
      headlineLarge: estonia(textStyle: textTheme.headlineLarge),
      headlineMedium: estonia(textStyle: textTheme.headlineMedium),
      headlineSmall: estonia(textStyle: textTheme.headlineSmall),
      titleLarge: estonia(textStyle: textTheme.titleLarge),
      titleMedium: estonia(textStyle: textTheme.titleMedium),
      titleSmall: estonia(textStyle: textTheme.titleSmall),
      bodyLarge: estonia(textStyle: textTheme.bodyLarge),
      bodyMedium: estonia(textStyle: textTheme.bodyMedium),
      bodySmall: estonia(textStyle: textTheme.bodySmall),
      labelLarge: estonia(textStyle: textTheme.labelLarge),
      labelMedium: estonia(textStyle: textTheme.labelMedium),
      labelSmall: estonia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Euphoria Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Euphoria+Script
  static TextStyle euphoriaScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88fa800fab0455764681712d008ac1dba9ac05747e7fd28f652934d143f205bb',
        36452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'EuphoriaScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Euphoria Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Euphoria+Script
  static TextTheme euphoriaScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: euphoriaScript(textStyle: textTheme.displayLarge),
      displayMedium: euphoriaScript(textStyle: textTheme.displayMedium),
      displaySmall: euphoriaScript(textStyle: textTheme.displaySmall),
      headlineLarge: euphoriaScript(textStyle: textTheme.headlineLarge),
      headlineMedium: euphoriaScript(textStyle: textTheme.headlineMedium),
      headlineSmall: euphoriaScript(textStyle: textTheme.headlineSmall),
      titleLarge: euphoriaScript(textStyle: textTheme.titleLarge),
      titleMedium: euphoriaScript(textStyle: textTheme.titleMedium),
      titleSmall: euphoriaScript(textStyle: textTheme.titleSmall),
      bodyLarge: euphoriaScript(textStyle: textTheme.bodyLarge),
      bodyMedium: euphoriaScript(textStyle: textTheme.bodyMedium),
      bodySmall: euphoriaScript(textStyle: textTheme.bodySmall),
      labelLarge: euphoriaScript(textStyle: textTheme.labelLarge),
      labelMedium: euphoriaScript(textStyle: textTheme.labelMedium),
      labelSmall: euphoriaScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ewert font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ewert
  static TextStyle ewert({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'da115b98d7d8742466f888773008e288c7baf8d3e0b85546f4d4427044d972cf',
        68836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ewert',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ewert font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ewert
  static TextTheme ewertTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ewert(textStyle: textTheme.displayLarge),
      displayMedium: ewert(textStyle: textTheme.displayMedium),
      displaySmall: ewert(textStyle: textTheme.displaySmall),
      headlineLarge: ewert(textStyle: textTheme.headlineLarge),
      headlineMedium: ewert(textStyle: textTheme.headlineMedium),
      headlineSmall: ewert(textStyle: textTheme.headlineSmall),
      titleLarge: ewert(textStyle: textTheme.titleLarge),
      titleMedium: ewert(textStyle: textTheme.titleMedium),
      titleSmall: ewert(textStyle: textTheme.titleSmall),
      bodyLarge: ewert(textStyle: textTheme.bodyLarge),
      bodyMedium: ewert(textStyle: textTheme.bodyMedium),
      bodySmall: ewert(textStyle: textTheme.bodySmall),
      labelLarge: ewert(textStyle: textTheme.labelLarge),
      labelMedium: ewert(textStyle: textTheme.labelMedium),
      labelSmall: ewert(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Exo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Exo
  static TextStyle exo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b82093a8173e1bb714f37200b0d2897dbcdaaa6b694964a9bbd3ca3f624aed14',
        58348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46daef230571ceeb9ec39718efd7f9a85f5a2ba9ccc340ee25a70976f16d7c6f',
        58472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60c12f10904ac7f85fec030baf1b711fed6a089586c346bc9b1945f136ad5be1',
        58444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '192bd1e8dbe8ebbc6546e0013f436a9bc0f51e6ebf9d07ebda3389f06896d6c4',
        58384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31b294f84ecf9551f1a16a5d9f3131ebaa786a4e6fc9ad8a3c9a4c03a96670c1',
        58404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7acbd7d0ce9c627a6291f43270a07bff91a95bd6c6c85840dd05098f07f5d464',
        58416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a728138571b31d80f6289dbc5a0982b35841ebffba30b0e2c019991570ac0d0',
        58292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '838504da739d1e6de275ae188e33d5e77cde3422a59b718813331c16a8dc53ba',
        58328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cf28630ad9211a81b81f73f5a890303a6b2ce75667a0a19d6a9b8f4ce9591ed',
        58180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c11a7ed6c2be53ba5a907762a332fae285d972234725a971b78de5e4bd0e9a1d',
        59676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd9c17b8e02b120d4f21a93f59c516538f0b846e0c12c5d2140c99d13a58fe278',
        59844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f86cca1296c12550628b00bb8b57fb7dc74a6b53de82241a502b0f791fde3bce',
        59804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2e325f4047bf00bf9c874b40ef6530b7c860602c0ea6e1a948f8198ee170f00b',
        59688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab4be5bd4302fb81902bfbc667a46dd09db9bdfce70657d8e3e5f8bdde72794c',
        59764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '852b63b526d61e193f96fd89f112f0858faeaea3fa09651357830dc87c018a6e',
        59776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'aee5d100510f8f4820355614a3f8348280dda0be359d39918086d9c0ded54e6f',
        59688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0387a052b9472f33dd7969a3b2d23a1861faebdc61878ecb6fcd6b838a88b359',
        59732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b5b7b96ce4f204cd6d02a9a3a4466fcf3ea1b99daec93f902b13a4953422449d',
        59556,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Exo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Exo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Exo
  static TextTheme exoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: exo(textStyle: textTheme.displayLarge),
      displayMedium: exo(textStyle: textTheme.displayMedium),
      displaySmall: exo(textStyle: textTheme.displaySmall),
      headlineLarge: exo(textStyle: textTheme.headlineLarge),
      headlineMedium: exo(textStyle: textTheme.headlineMedium),
      headlineSmall: exo(textStyle: textTheme.headlineSmall),
      titleLarge: exo(textStyle: textTheme.titleLarge),
      titleMedium: exo(textStyle: textTheme.titleMedium),
      titleSmall: exo(textStyle: textTheme.titleSmall),
      bodyLarge: exo(textStyle: textTheme.bodyLarge),
      bodyMedium: exo(textStyle: textTheme.bodyMedium),
      bodySmall: exo(textStyle: textTheme.bodySmall),
      labelLarge: exo(textStyle: textTheme.labelLarge),
      labelMedium: exo(textStyle: textTheme.labelMedium),
      labelSmall: exo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Exo 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Exo+2
  static TextStyle exo2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6da67e349af29b457c0a3a988a4001384c85d362264b784070a5fc93415d08f4',
        124816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e490f83f339927c56e2b3e8162bae38a767b81b3332acb9cd2d0d3abaaf0c70',
        125048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73689ed8fa0e3731c99e8c70019d31348bcb6d4a0c92bbb95737d72a9a2a514f',
        125068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd40384c64c9929b96a3908d20eb38e019d32a75810cfb3695d868eb6b103f38d',
        125056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9569393e4fb27c674ccbe76dfdf79ae699d0e2a5b39da09f0c8e439a1546a4af',
        125152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2709d298589f56f9bdc49e9d975b059356477484e3390524c11423d92e3c14a',
        125188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a1d998b767e12260d03971bf35a53ac86c15e84d7c7002132ae91be402be08d1',
        127524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1cd11ffbb4fd893273d8103b9cad127659d3babf23290c7d784846d82e8e6838',
        127592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8d88186d114ab735ff45caf0fb77957afa7c62152ab56e712dad2f1156a4b16',
        127452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '820c969277799480a97c823db019222b663983963d89af90605be61d6e23455c',
        124092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dc6e1d5a0c426d57ad652b94b0dfe905e7eb4419992116d5a9d83c56dd96ac6e',
        124388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b198bc8dd98727480ab1404a5b58ba9659f02c43fcd3147e308030c265a9f359',
        124404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd6440bb923b8fee2159295f19e6e09a69f556462289ae867913b7fa13e375e28',
        124276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '583481f7303d6167d8f3e480585942233ce2e342bea4ba730c481cf099c3d6cd',
        124416,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8a3cb638cc91445ce34dfb8baeffba9a52db5ce02ca499cb7534e83c08242537',
        124492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd2931aeec30d12012a59ce2e95935036fa2d9b2fc0367420acc10018bbc0fc78',
        126808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '33ee4090aa3d49342b1377653635c9da397411283ecaa3cb19224ad9887e4d8d',
        126912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4a3fa486c344f57fb64f6947c93cad5741e5c4a476f58018cef151a974187ec',
        126812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Exo2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Exo 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Exo+2
  static TextTheme exo2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: exo2(textStyle: textTheme.displayLarge),
      displayMedium: exo2(textStyle: textTheme.displayMedium),
      displaySmall: exo2(textStyle: textTheme.displaySmall),
      headlineLarge: exo2(textStyle: textTheme.headlineLarge),
      headlineMedium: exo2(textStyle: textTheme.headlineMedium),
      headlineSmall: exo2(textStyle: textTheme.headlineSmall),
      titleLarge: exo2(textStyle: textTheme.titleLarge),
      titleMedium: exo2(textStyle: textTheme.titleMedium),
      titleSmall: exo2(textStyle: textTheme.titleSmall),
      bodyLarge: exo2(textStyle: textTheme.bodyLarge),
      bodyMedium: exo2(textStyle: textTheme.bodyMedium),
      bodySmall: exo2(textStyle: textTheme.bodySmall),
      labelLarge: exo2(textStyle: textTheme.labelLarge),
      labelMedium: exo2(textStyle: textTheme.labelMedium),
      labelSmall: exo2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Expletus Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Expletus+Sans
  static TextStyle expletusSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '016c31d99f1f5b0ce53eb46b7e1b90946be2566cd38a5ca3bd0ebdae5e18e85f',
        23420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de5e6fb6867bfc7811497bed8a4e32f5ead84c7f1e647b1595ec0e4978d050d3',
        23456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31763336e10d913df125d065ac8e8a5253b6683bf8a2b644f2e252d2c10625aa',
        23532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '35f757f2eb7125564e33fd84620d45dde487680ecd6df26d3994ee115026b713',
        23420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a98eba81a948c725f24ffa8144e3916cd1139d10211abbefebcf31c50e6073f6',
        24220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f47a959a340c573db311fdbb46f2854af3fd11a9e60641adc6f9cc4cbcad8e6a',
        24400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7f8297ebd77ddcd2a58fbb06d9d1d29e83711486adaf05f6ae3a282859a5f99f',
        24432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6f0015ff3bdde7389b16aae368f17aff48e5b372fadaa68d1250602955ef08f7',
        24280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ExpletusSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Expletus Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Expletus+Sans
  static TextTheme expletusSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: expletusSans(textStyle: textTheme.displayLarge),
      displayMedium: expletusSans(textStyle: textTheme.displayMedium),
      displaySmall: expletusSans(textStyle: textTheme.displaySmall),
      headlineLarge: expletusSans(textStyle: textTheme.headlineLarge),
      headlineMedium: expletusSans(textStyle: textTheme.headlineMedium),
      headlineSmall: expletusSans(textStyle: textTheme.headlineSmall),
      titleLarge: expletusSans(textStyle: textTheme.titleLarge),
      titleMedium: expletusSans(textStyle: textTheme.titleMedium),
      titleSmall: expletusSans(textStyle: textTheme.titleSmall),
      bodyLarge: expletusSans(textStyle: textTheme.bodyLarge),
      bodyMedium: expletusSans(textStyle: textTheme.bodyMedium),
      bodySmall: expletusSans(textStyle: textTheme.bodySmall),
      labelLarge: expletusSans(textStyle: textTheme.labelLarge),
      labelMedium: expletusSans(textStyle: textTheme.labelMedium),
      labelSmall: expletusSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Explora font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Explora
  static TextStyle explora({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0b87b25365b691c60856306ef4ac279098a4aea55c8e7258f27194e1da1903c',
        124340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Explora',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Explora font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Explora
  static TextTheme exploraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: explora(textStyle: textTheme.displayLarge),
      displayMedium: explora(textStyle: textTheme.displayMedium),
      displaySmall: explora(textStyle: textTheme.displaySmall),
      headlineLarge: explora(textStyle: textTheme.headlineLarge),
      headlineMedium: explora(textStyle: textTheme.headlineMedium),
      headlineSmall: explora(textStyle: textTheme.headlineSmall),
      titleLarge: explora(textStyle: textTheme.titleLarge),
      titleMedium: explora(textStyle: textTheme.titleMedium),
      titleSmall: explora(textStyle: textTheme.titleSmall),
      bodyLarge: explora(textStyle: textTheme.bodyLarge),
      bodyMedium: explora(textStyle: textTheme.bodyMedium),
      bodySmall: explora(textStyle: textTheme.bodySmall),
      labelLarge: explora(textStyle: textTheme.labelLarge),
      labelMedium: explora(textStyle: textTheme.labelMedium),
      labelSmall: explora(textStyle: textTheme.labelSmall),
    );
  }
}
