# OnePlus Flash Control

OnePlus Flash Control is an Android application designed **specifically for OnePlus devices** with dual-tone LED flashes, providing precise control over flashlight brightness.

**For rooted OnePlus devices**, the app leverages root access to directly modify system-level files, enabling full control over individual white and yellow LED brightnesses with advanced features.

**For non-rooted devices** (Android 13+), the app offers a fallback mode using the CameraManager API with basic flashlight control. While designed for OnePlus, **this mode may work on other Android 13+ devices** as a bonus feature.

## Support project

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://buymeacoffee.com/bartixxx32)
## Features

### Rooted Devices (Full Features)
- **Master Brightness Control:** Adjust overall LED brightness (0-500) with a single slider.
- **Individual LED Control:** Independently control the brightness of white and yellow LEDs.
- **"Eye Destroyer" Mode:** A feature to momentarily turn on the LEDs at maximum brightness for both white and yellow LEDs.
- ⚠️ Use with caution as it emits very intense light and generates significant heat! ⚠️
- Safety features to prevent prolonged high brightness usage:
  - If brightness exceeds 120 (on a scale of 0-255) for more than 20 seconds, it automatically reduces back to the default Android brightness value to prevent overheating or damage.
  - "Eye Destroyer" Mode enforces a 5-second cooldown between uses to ensure safety and prevent excessive heat buildup.

### Non-Rooted Devices (Android 13+)
- **Basic Brightness Control:** Adjust flashlight using available torch strength levels (typically 1-5 levels).
- **Simplified UI:** Only essential controls are shown for easier use.
- **Limited Features:** Individual LED control, Eye Destroyer mode, and advanced settings are not available without root.

### Common Features
- **Compatibility:** 
  - **OnePlus devices (rooted):** Full feature access with dual-LED control
  - **OnePlus devices (non-rooted, Android 13+):** Basic flashlight control with torch levels
  - **Other Android 13+ devices (non-rooted):** May also work, but not officially supported
- **Quick Settings Tile:** Conveniently control LED brightness and state using a Quick Settings tile:
  - Single tap cycles through brightness levels.
  - Double tap when LEDs are off to turn them on at 80% brightness.
  - Double tap when LEDs are on to turn them off.
- **Secret Action:** Unlock hidden features by tapping the app's title 5 times within 5 seconds, enabling a fun experimental mode.

## Usage

### Rooted Devices
Once installed on your rooted OnePlus device, you have full access to all features. The main screen provides sliders for adjusting the master brightness (0-500), as well as the brightness of the white and yellow LEDs individually. You can turn the flashlight on and off, and access the "Eye Destroyer" mode for maximum brightness.

### Non-Rooted Devices (Android 13+)
On non-rooted devices, the app provides a simplified interface with a single brightness control slider mapped to your device's available torch strength levels (typically 1-5). Individual LED controls and advanced features are automatically hidden.

The Quick Settings tile provides a convenient way to control the flashlight without opening the app. You can cycle through brightness levels with a single tap, and turn the flashlight on or off with a double tap.

## Preview Screenshot

[![Preview Screenshot](https://ik.imagekit.io/bartixxx32/ghmirror/tr:w-0.2,r-26/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot1.png)](https://ik.imagekit.io/bartixxx32/ghmirror/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot1.png)
[![Preview Screenshot](https://ik.imagekit.io/bartixxx32/ghmirror/tr:w-0.2,r-26/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot2.png)](https://ik.imagekit.io/bartixxx32/ghmirror/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot2.png)



## Download



[<img src="https://github.com/ImranR98/Obtainium/blob/main/assets/graphics/badge_obtainium.png"
alt="Get it on Obtainium"
height="80">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22com.bartixxx.opflashcontrol%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2FBartixxx32%2FOpflashcontrol-app%22%2C%22author%22%3A%22Bartixxx32%22%2C%22name%22%3A%22OnePlus%20Flash%20Control%22%2C%22preferredApkIndex%22%3A0%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Atrue%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22releaseTitleAsVersion%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22allowInsecure%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22%5C%22%2C%5C%22refreshBeforeDownload%5C%22%3Afalse%7D%22%2C%22overrideSource%22%3Anull%7D)

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/com.bartixxx.opflashcontrol/)

Or download the latest APK from the [Releases Section](https://github.com/Bartixxx32/Opflashcontrol-app/releases/latest).
