# OnePlus Flash Control

OnePlus Flash Control is an Android application designed specifically for rooted OnePlus devices, providing users with precise control over the brightness of the dual-tone LED flashes. The app offers a user-friendly interface to easily adjust the master brightness and independently control the brightness of the white, yellow.

By leveraging root access, the app allows direct modification of system-level files to control the LED behavior, enabling a customized and enhanced flashlight experience on your OnePlus device.

## Support project

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://buymeacoffee.com/bartixxx32)
## Features

- **Master Brightness Control:** Adjust overall LED brightness with a single slider.
- **Individual LED Control:** Independently control the brightness of white and yellow LEDs.
- **"Eye Destroyer" Mode:** A feature to momentarily turn on the LEDs at maximum brightness for both white and yellow LEDs.
- ⚠️ Use with caution as it emits very intense light and generates significant heat! ⚠️
- Safety features to prevent prolonged high brightness usage:
  - If brightness exceeds 120 (on a scale of 0-255) for more than 20 seconds, it automatically reduces back to the default Android brightness value to prevent overheating or damage.
  - "Eye Destroyer" Mode enforces a 5-second cooldown between uses to ensure safety and prevent excessive heat buildup.

- **Compatibility:** Designed for rooted OnePlus devices only.
- **Quick Settings Tile:** Conveniently control LED brightness and state using a Quick Settings tile:
  - Single tap cycles through brightness levels.
  - Double tap when LEDs are off to turn them on at 80% brightness.
  - Double tap when LEDs are on to turn them off.
- **Secret Action:** Unlock hidden features by tapping the app's title 5 times within 5 seconds, enabling a fun experimental mode.

## Setup

To build and run the OnePlus Flash Control application from the source code, you'll need the following:

- A rooted OnePlus device
- Android Studio IDE
- USB debugging enabled on your device

### Steps

1. **Clone the repository:**

   ```bash
   git clone https://github.com/Bartixxx32/Opflashcontrol-app.git
   ```

2. **Open the project in Android Studio:**
   - Launch Android Studio.
   - Select "Open an existing Android Studio project".
   - Navigate to the cloned repository and select the `Opflashcontrol-app` folder.

3. **Build the project:**
   - Once the project is open, Android Studio will automatically sync the project with Gradle.
   - To build the project, go to `Build > Make Project` or click the "Make Project" icon in the toolbar.

4. **Run the application:**
   - Connect your rooted OnePlus device to your computer via USB.
   - In Android Studio, select your device from the dropdown menu and click the "Run" button.

## Usage

Once the application is installed on your rooted OnePlus device, you can use it to control the flashlight LEDs. The main screen provides sliders for adjusting the master brightness, as well as the brightness of the white and yellow LEDs individually. You can also turn the flashlight on and off, and access the "Eye Destroyer" mode for maximum brightness.

The Quick Settings tile provides a convenient way to control the flashlight without opening the app. You can cycle through brightness levels with a single tap, and turn the flashlight on or off with a double tap.

## Preview Screenshot

[![Preview Screenshot](https://ik.imagekit.io/bartixxx32/ghmirror/tr:w-0.2,r-26/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot1.png)](https://ik.imagekit.io/bartixxx32/ghmirror/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot1.png)
[![Preview Screenshot](https://ik.imagekit.io/bartixxx32/ghmirror/tr:w-0.2,r-26/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot2.png)](https://ik.imagekit.io/bartixxx32/ghmirror/Bartixxx32/Opflashcontrol-app/master/metadata/en-US/images/phoneScreenshots/screenshot2.png)



## Download



[<img src="https://github.com/ImranR98/Obtainium/blob/main/assets/graphics/badge_obtainium.png"
alt="Get it on Obtainium"
height="80">](https://apps.obtainium.imranr.dev/redirect?r=obtainium://app/%7B%22id%22%3A%22com.bartixxx.opflashcontrol%22%2C%22url%22%3A%22https%3A%2F%2Fgithub.com%2FBartixxx32%2FOpflashcontrol-app%22%2C%22author%22%3A%22Bartixxx32%22%2C%22name%22%3A%22OnePlus%20Flash%20Control%22%2C%22preferredApkIndex%22%3A0%2C%22additionalSettings%22%3A%22%7B%5C%22includePrereleases%5C%22%3Atrue%2C%5C%22fallbackToOlderReleases%5C%22%3Atrue%2C%5C%22filterReleaseTitlesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22filterReleaseNotesByRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22verifyLatestTag%5C%22%3Afalse%2C%5C%22dontSortReleasesList%5C%22%3Afalse%2C%5C%22useLatestAssetDateAsReleaseDate%5C%22%3Afalse%2C%5C%22releaseTitleAsVersion%5C%22%3Afalse%2C%5C%22trackOnly%5C%22%3Afalse%2C%5C%22versionExtractionRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22matchGroupToUse%5C%22%3A%5C%22%5C%22%2C%5C%22versionDetection%5C%22%3Atrue%2C%5C%22releaseDateAsVersion%5C%22%3Afalse%2C%5C%22useVersionCodeAsOSVersion%5C%22%3Afalse%2C%5C%22apkFilterRegEx%5C%22%3A%5C%22%5C%22%2C%5C%22invertAPKFilter%5C%22%3Afalse%2C%5C%22autoApkFilterByArch%5C%22%3Atrue%2C%5C%22appName%5C%22%3A%5C%22%5C%22%2C%5C%22shizukuPretendToBeGooglePlay%5C%22%3Afalse%2C%5C%22allowInsecure%5C%22%3Afalse%2C%5C%22exemptFromBackgroundUpdates%5C%22%3Afalse%2C%5C%22skipUpdateNotifications%5C%22%3Afalse%2C%5C%22about%5C%22%3A%5C%22%5C%22%2C%5C%22refreshBeforeDownload%5C%22%3Afalse%7D%22%2C%22overrideSource%22%3Anull%7D)

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/com.bartixxx.opflashcontrol/)

Or download the latest APK from the [Releases Section](https://github.com/Bartixxx32/Opflashcontrol-app/releases/latest).
