/*
 * Copyright (C) 2021.  Aravind Chowdary (@kamaravichow)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.aravi.dot.activities.log.database;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.aravi.dot.model.Logs;

import java.util.List;

@Dao
public interface LogsDao {

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    void insert(Logs logs);

    @Query("DELETE FROM logs_database")
    void clearAllLogs();

    @Query("SELECT * FROM logs_database ORDER BY timestamp DESC")
    LiveData<List<Logs>> getOrderedLogs();
}
