package com.appengine.paranoid_android.lost;

import android.content.Context;
import android.preference.Preference;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.TextView;

public class LongTextPreference extends Preference {
  private TextView mText;
  protected int mGravity = Gravity.NO_GRAVITY;

  public LongTextPreference(Context context) {
    this(context, null);
  }

  public LongTextPreference(Context context, AttributeSet attrs) {
    super(context, attrs);

    setLayoutResource(R.layout.long_text_preference);

    setShouldDisableView(false);
    setEnabled(false);
    setSelectable(false);
  }

  @Override
  protected void onBindView(View view) {
    super.onBindView(view);

    // Retrieve the title TextView.
    mText = (TextView) view.findViewById(android.R.id.title);
    mText.setGravity(mGravity);
  }

  public void setGravity(int gravity) {
    mGravity = gravity;
    if (mText != null) {
      mText.setGravity(gravity);
    }
  }
}
