package com.appengine.paranoid_android.lost;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class InfoBroadcastReceiver extends BroadcastReceiver {
  private static final boolean DEBUG = false;
  private static final String TAG = "Info.BroadcastReceiver";

  @Override
  public void onReceive(Context context, Intent intent) {
    String action = intent.getAction();
    if (InfoService.ACTION_ALARM_CHANGED.equals(action) ||
        Intent.ACTION_SCREEN_ON.equals(action) ||
        Intent.ACTION_SCREEN_OFF.equals(action) ||
        InfoService.ACTION_POWER_CONNECTED.equals(action) ||
        Intent.ACTION_BOOT_COMPLETED.equals(action)) {
      if (DEBUG) Log.d(TAG, "Broadcast notification received: " + action);
      Intent service = new Intent(context, InfoService.class);
      service.setAction(action);
      context.startService(service);
    } else {
      if (DEBUG) Log.d(TAG, "Unexpected broadcast intent received: " + intent);
    }
  }
}
