package com.app.dockeep.di

import android.content.Context
import com.app.dockeep.data.files.FilesRepository
import com.app.dockeep.data.files.FilesRepositoryImpl
import com.app.dockeep.data.preferences.DataStoreRepository
import com.app.dockeep.data.preferences.DataStoreRepositoryImpl
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import javax.inject.Singleton


@Module
@InstallIn(SingletonComponent::class)
object AppModule {

    @Singleton
    @Provides
    fun provideDataStoreRepository(
        @ApplicationContext app: Context
    ): DataStoreRepository = DataStoreRepositoryImpl(app)


    @Singleton
    @Provides
    fun provideFilesRepository(
        @ApplicationContext app: Context
    ): FilesRepository = FilesRepositoryImpl(app)

}