package com.anysoftkeyboard.utils;

import static androidx.test.core.app.ApplicationProvider.getApplicationContext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.anysoftkeyboard.AnySoftKeyboardRobolectricTestRunner;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.robolectric.annotation.Config;

@RunWith(AnySoftKeyboardRobolectricTestRunner.class)
public class LocaleToolsTest {
  private Context mContext;

  @Before
  public void setUpLocale() {
    Locale.setDefault(Locale.US);
    mContext = getApplicationContext();
  }

  @After
  public void tearDownLocale() {
    Locale.setDefault(Locale.US);
  }

  @Test
  @Config(sdk = Build.VERSION_CODES.LOLLIPOP)
  public void testSetAndResetValueAPI21() {
    Assert.assertEquals(
        "English (United States)",
        mContext.getResources().getConfiguration().locale.getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "ru");

    Assert.assertEquals("ru", mContext.getResources().getConfiguration().locale.getLanguage());
    Assert.assertEquals(
        "Russian", mContext.getResources().getConfiguration().locale.getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "");

    Assert.assertEquals(
        Locale.getDefault().getLanguage(),
        mContext.getResources().getConfiguration().locale.getLanguage());

    LocaleTools.applyLocaleToContext(mContext, "NONE_EXISTING");
    // in this API level, Android is more strict, we can not set invalid values.
    Assert.assertEquals("en", mContext.getResources().getConfiguration().locale.getLanguage());
  }

  @SuppressLint("UseSdkSuppress")
  @RequiresApi(api = Build.VERSION_CODES.N)
  @Test
  @Config(sdk = Build.VERSION_CODES.N)
  public void testSetAndResetValueAPI24() {
    Assert.assertEquals(
        "English (United States)",
        mContext.getResources().getConfiguration().locale.getDisplayName());
    Assert.assertEquals(1, mContext.getResources().getConfiguration().getLocales().size());
    Assert.assertEquals(
        Locale.getDefault().getDisplayName(),
        mContext.getResources().getConfiguration().getLocales().get(0).getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "ru");

    Assert.assertEquals("ru", mContext.getResources().getConfiguration().locale.getLanguage());
    Assert.assertEquals(
        "Russian", mContext.getResources().getConfiguration().locale.getDisplayName());
    Assert.assertEquals(1, mContext.getResources().getConfiguration().getLocales().size());
    Assert.assertEquals(
        "Russian", mContext.getResources().getConfiguration().getLocales().get(0).getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "");

    Assert.assertEquals(
        Locale.getDefault().getLanguage(),
        mContext.getResources().getConfiguration().locale.getLanguage());
    Assert.assertEquals(1, mContext.getResources().getConfiguration().getLocales().size());
    Assert.assertEquals(
        Locale.getDefault().getDisplayName(),
        mContext.getResources().getConfiguration().getLocales().get(0).getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "NONE_EXISTING");
    // in this API level, Android is more strict, we can not set invalid values.
    Assert.assertEquals("en", mContext.getResources().getConfiguration().locale.getLanguage());
  }

  @Test
  @Config(sdk = Build.VERSION_CODES.N)
  public void testSetEmptyValue() {
    Assert.assertEquals(
        Locale.getDefault().getDisplayName(),
        mContext.getResources().getConfiguration().locale.getDisplayName());

    LocaleTools.applyLocaleToContext(mContext, "");
    // should default
    Assert.assertEquals(
        Locale.getDefault().getLanguage(),
        mContext.getResources().getConfiguration().locale.getLanguage());
    Assert.assertFalse(
        TextUtils.isEmpty(mContext.getResources().getConfiguration().locale.getLanguage()));
  }
}
