package com.anysoftkeyboard.api;

public class KeyCodes {

  public static final int SPACE = 32;
  public static final int ENTER = 10;
  public static final int TAB = 9;
  public static final int ESCAPE = 27;

  public static final int DELETE = -5;
  public static final int DELETE_WORD = -7;
  public static final int FORWARD_DELETE = -8;

  public static final int QUICK_TEXT = -10;
  public static final int QUICK_TEXT_POPUP = -102;
  public static final int CLEAR_QUICK_TEXT_HISTORY = -103;
  public static final int DOMAIN = -9;

  public static final int SHIFT = -1;
  public static final int ALT = -6;
  public static final int CTRL = -11;
  public static final int SHIFT_LOCK = -14;
  public static final int CTRL_LOCK = -15;

  public static final int MODE_SYMBOLS = -2;
  public static final int MODE_ALPHABET = -99;
  public static final int MODE_ALPHABET_POPUP = -98;
  public static final int KEYBOARD_CYCLE = -97;
  public static final int KEYBOARD_REVERSE_CYCLE = -96;
  public static final int KEYBOARD_CYCLE_INSIDE_MODE = -95;
  public static final int KEYBOARD_MODE_CHANGE = -94;

  public static final int ARROW_LEFT = -20;
  public static final int ARROW_RIGHT = -21;
  public static final int ARROW_UP = -22;
  public static final int ARROW_DOWN = -23;
  public static final int MOVE_HOME = -24;
  public static final int MOVE_END = -25;

  public static final int SETTINGS = -100;
  public static final int CANCEL = -3;
  public static final int CLEAR_INPUT = -13;
  public static final int VOICE_INPUT = -4;

  public static final int DISABLED = 0;

  public static final int SPLIT_LAYOUT = -110;
  public static final int MERGE_LAYOUT = -111;
  public static final int COMPACT_LAYOUT_TO_LEFT = -112;
  public static final int COMPACT_LAYOUT_TO_RIGHT = -113;

  public static final int UTILITY_KEYBOARD = -120;

  public static final int CLIPBOARD_COPY = -130;
  public static final int CLIPBOARD_CUT = -131;
  public static final int CLIPBOARD_PASTE = -132;
  public static final int CLIPBOARD_PASTE_POPUP = -133;
  public static final int CLIPBOARD_SELECT = -134;
  public static final int CLIPBOARD_SELECT_ALL = -135;

  public static final int UNDO = -136;
  public static final int REDO = -137;

  public static final int IMAGE_MEDIA_POPUP = -140;

  public static final int PRE_PREPARED_ABBREVIATIONS_POPUP = -150;
  public static final int PRE_PREPARED_TEXT_POPUP = -151;
  public static final int PRE_PREPARED_EMAILS_POPUP = -152;

  public static final int EXTERNAL_INTEGRATION = -200;

  public static boolean isOutputKeyCode(final int code) {
    if (code > 0) {
      return true;
    } else {
      return switch (code) {
        case DELETE, DELETE_WORD, FORWARD_DELETE -> true;
        default -> false;
      };
    }
  }
}
