/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.view.MenuInflater;
import android.view.MenuItem;
import com.android.talkback.contextmenu.RadialMenu;
import com.android.talkback.contextmenu.RadialMenuItem;

import java.util.ArrayList;
import java.util.List;

/**
 * Acts as an extension of {@link MenuInflater} for {@link RadialMenu}s by
 * allowing inflated {@link RadialMenuItem}s from XML to be returned directly to
 * a caller.
 */
class RadialMenuInflater extends MenuInflater {
    private final DummyRadialMenu mHolderMenu;

    public RadialMenuInflater(Context context) {
        super(context);
        mHolderMenu = new DummyRadialMenu(context);
    }

    /**
     * Returns a list of {@link MenuItem}s as generated by the inflater.
     *
     * @param menuRes The resource ID of the menu to inflate.
     * @return a {@link List} of the menu items in the main content area of the
     *         menu.
     */
    public List<RadialMenuItem> inflate(int menuRes) {
        // TODO: See if supporting corners is feasible.
        mHolderMenu.clear();
        inflate(menuRes, mHolderMenu);
        final ArrayList<RadialMenuItem> items = new ArrayList<>(mHolderMenu.size());

        for (int i = 0; i < mHolderMenu.size(); ++i) {
            items.add(mHolderMenu.getItem(i));
        }

        return items;
    }

    private static class DummyRadialMenu extends RadialMenu {

        public DummyRadialMenu(Context context) {
            super(context, new DialogInterface() {

                @Override
                public void dismiss() {
                    // Do nothing.
                }

                @Override
                public void cancel() {
                    // Do nothing.
                }
            });
        }
    }
}
