/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.talkback.tutorial.exercise;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.android.talkback.R;

public class EditTextExercise extends Exercise {

    @Override
    public View getContentView(final LayoutInflater inflater, ViewGroup parent) {
        View view = inflater.inflate(R.layout.tutorial_content_edit_text, parent, false);
        EditText textView = (EditText) view.findViewById(R.id.edit);
        textView.setText(getText(inflater.getContext()));
        return view;
    }

    public CharSequence getText(Context context) {
        return "";
    }

    @Override
    public boolean needScrollableContainer() {
        return true;
    }
}
