/*
 *
 *   Copyright 2023 Einstein Blanco
 *
 *   Licensed under the GNU General Public License v3.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       https://www.gnu.org/licenses/gpl-3.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
package com.android.geto.designsystem.theme

import androidx.compose.ui.graphics.Color

internal object Green {
    val primaryLight = Color(0xFF4C662B)
    val onPrimaryLight = Color(0xFFFFFFFF)
    val primaryContainerLight = Color(0xFFCDEDA3)
    val onPrimaryContainerLight = Color(0xFF102000)
    val secondaryLight = Color(0xFF586249)
    val onSecondaryLight = Color(0xFFFFFFFF)
    val secondaryContainerLight = Color(0xFFDCE7C8)
    val onSecondaryContainerLight = Color(0xFF151E0B)
    val tertiaryLight = Color(0xFF386663)
    val onTertiaryLight = Color(0xFFFFFFFF)
    val tertiaryContainerLight = Color(0xFFBCECE7)
    val onTertiaryContainerLight = Color(0xFF00201E)
    val errorLight = Color(0xFFBA1A1A)
    val onErrorLight = Color(0xFFFFFFFF)
    val errorContainerLight = Color(0xFFFFDAD6)
    val onErrorContainerLight = Color(0xFF410002)
    val backgroundLight = Color(0xFFF9FAEF)
    val onBackgroundLight = Color(0xFF1A1C16)
    val surfaceLight = Color(0xFFF9FAEF)
    val onSurfaceLight = Color(0xFF1A1C16)
    val surfaceVariantLight = Color(0xFFE1E4D5)
    val onSurfaceVariantLight = Color(0xFF44483D)
    val outlineLight = Color(0xFF75796C)
    val outlineVariantLight = Color(0xFFC5C8BA)
    val scrimLight = Color(0xFF000000)
    val inverseSurfaceLight = Color(0xFF2F312A)
    val inverseOnSurfaceLight = Color(0xFFF1F2E6)
    val inversePrimaryLight = Color(0xFFB1D18A)
    val surfaceDimLight = Color(0xFFDADBD0)
    val surfaceBrightLight = Color(0xFFF9FAEF)
    val surfaceContainerLowestLight = Color(0xFFFFFFFF)
    val surfaceContainerLowLight = Color(0xFFF3F4E9)
    val surfaceContainerLight = Color(0xFFEEEFE3)
    val surfaceContainerHighLight = Color(0xFFE8E9DE)
    val surfaceContainerHighestLight = Color(0xFFE2E3D8)

    val primaryDark = Color(0xFFB1D18A)
    val onPrimaryDark = Color(0xFF1F3701)
    val primaryContainerDark = Color(0xFF354E16)
    val onPrimaryContainerDark = Color(0xFFCDEDA3)
    val secondaryDark = Color(0xFFBFCBAD)
    val onSecondaryDark = Color(0xFF2A331E)
    val secondaryContainerDark = Color(0xFF404A33)
    val onSecondaryContainerDark = Color(0xFFDCE7C8)
    val tertiaryDark = Color(0xFFA0D0CB)
    val onTertiaryDark = Color(0xFF003735)
    val tertiaryContainerDark = Color(0xFF1F4E4B)
    val onTertiaryContainerDark = Color(0xFFBCECE7)
    val errorDark = Color(0xFFFFB4AB)
    val onErrorDark = Color(0xFF690005)
    val errorContainerDark = Color(0xFF93000A)
    val onErrorContainerDark = Color(0xFFFFDAD6)
    val backgroundDark = Color(0xFF12140E)
    val onBackgroundDark = Color(0xFFE2E3D8)
    val surfaceDark = Color(0xFF12140E)
    val onSurfaceDark = Color(0xFFE2E3D8)
    val surfaceVariantDark = Color(0xFF44483D)
    val onSurfaceVariantDark = Color(0xFFC5C8BA)
    val outlineDark = Color(0xFF8F9285)
    val outlineVariantDark = Color(0xFF44483D)
    val scrimDark = Color(0xFF000000)
    val inverseSurfaceDark = Color(0xFFE2E3D8)
    val inverseOnSurfaceDark = Color(0xFF2F312A)
    val inversePrimaryDark = Color(0xFF4C662B)
    val surfaceDimDark = Color(0xFF12140E)
    val surfaceBrightDark = Color(0xFF383A32)
    val surfaceContainerLowestDark = Color(0xFF0C0F09)
    val surfaceContainerLowDark = Color(0xFF1A1C16)
    val surfaceContainerDark = Color(0xFF1E201A)
    val surfaceContainerHighDark = Color(0xFF282B24)
    val surfaceContainerHighestDark = Color(0xFF33362E)
}

internal object Purple {
    val primaryLight = Color(0xFF755085)
    val onPrimaryLight = Color(0xFFFFFFFF)
    val primaryContainerLight = Color(0xFFF7D8FF)
    val onPrimaryContainerLight = Color(0xFF2D0B3D)
    val secondaryLight = Color(0xFF69596D)
    val onSecondaryLight = Color(0xFFFFFFFF)
    val secondaryContainerLight = Color(0xFFF1DCF4)
    val onSecondaryContainerLight = Color(0xFF231728)
    val tertiaryLight = Color(0xFF815251)
    val onTertiaryLight = Color(0xFFFFFFFF)
    val tertiaryContainerLight = Color(0xFFFFDAD8)
    val onTertiaryContainerLight = Color(0xFF331111)
    val errorLight = Color(0xFFBA1A1A)
    val onErrorLight = Color(0xFFFFFFFF)
    val errorContainerLight = Color(0xFFFFDAD6)
    val onErrorContainerLight = Color(0xFF410002)
    val backgroundLight = Color(0xFFFFF7FB)
    val onBackgroundLight = Color(0xFF1E1A1F)
    val surfaceLight = Color(0xFFFFF7FB)
    val onSurfaceLight = Color(0xFF1E1A1F)
    val surfaceVariantLight = Color(0xFFEBDFEA)
    val onSurfaceVariantLight = Color(0xFF4C444D)
    val outlineLight = Color(0xFF7D747E)
    val outlineVariantLight = Color(0xFFCEC3CD)
    val scrimLight = Color(0xFF000000)
    val inverseSurfaceLight = Color(0xFF342F34)
    val inverseOnSurfaceLight = Color(0xFFF8EEF5)
    val inversePrimaryLight = Color(0xFFE3B7F3)
    val surfaceDimLight = Color(0xFFE1D7DF)
    val surfaceBrightLight = Color(0xFFFFF7FB)
    val surfaceContainerLowestLight = Color(0xFFFFFFFF)
    val surfaceContainerLowLight = Color(0xFFFBF1F8)
    val surfaceContainerLight = Color(0xFFF5EBF3)
    val surfaceContainerHighLight = Color(0xFFEFE5ED)
    val surfaceContainerHighestLight = Color(0xFFE9E0E7)

    val primaryDark = Color(0xFFE3B7F3)
    val onPrimaryDark = Color(0xFF442254)
    val primaryContainerDark = Color(0xFF5C396C)
    val onPrimaryContainerDark = Color(0xFFF7D8FF)
    val secondaryDark = Color(0xFFD4C0D7)
    val onSecondaryDark = Color(0xFF392C3E)
    val secondaryContainerDark = Color(0xFF504255)
    val onSecondaryContainerDark = Color(0xFFF1DCF4)
    val tertiaryDark = Color(0xFFF5B7B5)
    val onTertiaryDark = Color(0xFF4C2525)
    val tertiaryContainerDark = Color(0xFF663B3A)
    val onTertiaryContainerDark = Color(0xFFFFDAD8)
    val errorDark = Color(0xFFFFB4AB)
    val onErrorDark = Color(0xFF690005)
    val errorContainerDark = Color(0xFF93000A)
    val onErrorContainerDark = Color(0xFFFFDAD6)
    val backgroundDark = Color(0xFF161217)
    val onBackgroundDark = Color(0xFFE9E0E7)
    val surfaceDark = Color(0xFF161217)
    val onSurfaceDark = Color(0xFFE9E0E7)
    val surfaceVariantDark = Color(0xFF4C444D)
    val onSurfaceVariantDark = Color(0xFFCEC3CD)
    val outlineDark = Color(0xFF978E97)
    val outlineVariantDark = Color(0xFF4C444D)
    val scrimDark = Color(0xFF000000)
    val inverseSurfaceDark = Color(0xFFE9E0E7)
    val inverseOnSurfaceDark = Color(0xFF342F34)
    val inversePrimaryDark = Color(0xFF755085)
    val surfaceDimDark = Color(0xFF161217)
    val surfaceBrightDark = Color(0xFF3D373D)
    val surfaceContainerLowestDark = Color(0xFF110D12)
    val surfaceContainerLowDark = Color(0xFF1E1A1F)
    val surfaceContainerDark = Color(0xFF231E23)
    val surfaceContainerHighDark = Color(0xFF2D282E)
    val surfaceContainerHighestDark = Color(0xFF383339)
}
