package com.amrdeveloper.linkhub.ui

import android.content.Intent
import android.os.Bundle
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.app.AppCompatDelegate
import androidx.core.os.bundleOf
import com.amrdeveloper.linkhub.R
import com.amrdeveloper.linkhub.data.Theme
import com.amrdeveloper.linkhub.util.ACTION_CREATE_FOLDER
import com.amrdeveloper.linkhub.util.ACTION_CREATE_LINK
import com.amrdeveloper.linkhub.util.UiPreferences
import com.amrdeveloper.linkhub.util.findNavHostController
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class MainActivity : AppCompatActivity() {

    @Inject
    lateinit var uiPreferences: UiPreferences

    override fun onCreate(savedInstanceState: Bundle?) {
        enableEdgeToEdge()
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        handleMultiThemeOption()

        if (uiPreferences.isPasswordEnabled()) {
            findNavHostController(R.id.nav_host_fragment).navigate(R.id.checkPasswordFragment)
        } else {
            handleLinkHubIntent()
        }
    }

    fun handleLinkHubIntent() {
        when (intent.action) {
            Intent.ACTION_VIEW -> return
            Intent.ACTION_SEND -> {
                val sharedLink = intent.getStringExtra(Intent.EXTRA_TEXT)
                val sharedLinkSubject = intent.getStringExtra(Intent.EXTRA_SUBJECT) ?: ""
                val bundle = bundleOf("shared_link" to sharedLink, "shared_link_subject" to sharedLinkSubject)
                findNavHostController(R.id.nav_host_fragment).navigate(R.id.linkFragment, bundle)
                return
            }

            Intent.ACTION_PROCESS_TEXT -> {
                val sharedLink =
                    intent.getCharSequenceExtra(Intent.EXTRA_PROCESS_TEXT).toString()
                val bundle = bundleOf("shared_link" to sharedLink)
                findNavHostController(R.id.nav_host_fragment).navigate(
                    R.id.linkFragment,
                    bundle
                )
            }

            ACTION_CREATE_LINK -> {
                findNavHostController(R.id.nav_host_fragment).navigate(R.id.linkFragment)
            }

            ACTION_CREATE_FOLDER -> {
                findNavHostController(R.id.nav_host_fragment).navigate(R.id.folderFragment)
            }
        }
    }

    private fun handleMultiThemeOption() {
        val theme = uiPreferences.getThemeType()
        val themeMode = if (theme == Theme.DARK) AppCompatDelegate.MODE_NIGHT_YES
        else AppCompatDelegate.MODE_NIGHT_NO
        AppCompatDelegate.setDefaultNightMode(themeMode)
    }
}