(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_pages_main_pages_search_search_module_ts"],{

/***/ 81846:
/*!*************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/add-feed-button/add-feed-button.component.ts ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddFeedButtonComponent": () => (/* binding */ AddFeedButtonComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _add_feed_button_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-feed-button.component.html?ngResource */ 24891);
/* harmony import */ var _add_feed_button_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-feed-button.component.scss?ngResource */ 82643);
/* harmony import */ var _add_feed_button_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_add_feed_button_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_components_add_feed_modal_add_feed_modal_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/components/add-feed-modal/add-feed-modal.component */ 21843);

var _class;






let AddFeedButtonComponent = (_class = class AddFeedButtonComponent {
  constructor(modalCtrl) {
    this.modalCtrl = modalCtrl;
    this.feedsIds = [];
    this.updateFeedIds = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
  }
  ngOnInit() {}
  ngOnChanges() {
    this.exists = this.feedsIds?.indexOf(this.feed.feedId) !== -1;
  }
  handleButtonAction() {
    if (this.feedsIds?.indexOf(this.feed.feedId) === -1) {
      this.handleAddFeed();
    }
  }
  handleAddFeed() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this.modalCtrl.create({
        component: src_app_components_add_feed_modal_add_feed_modal_component__WEBPACK_IMPORTED_MODULE_3__.AddFeedModalComponent,
        componentProps: {
          feedObject: {
            feedId: _this.feed.feedId,
            title: _this.feed.title,
            visualUrl: _this.feed.visualUrl,
            iconUrl: _this.feed.iconUrl,
            index: null
          }
        },
        breakpoints: [0, 0.5, 0.7, 1],
        initialBreakpoint: 0.7
      });
      modal.onDidDismiss().then(data => {
        if (data.data.collection) {
          _this.feedsIds.push(_this.feed.feedId);
          _this.updateFeedIds.emit(true);
        }
      });
      yield modal.present();
    })();
  }
}, _class.ctorParameters = () => [{
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ModalController
}], _class.propDecorators = {
  feed: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  feedsIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  color: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  updateFeedIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Output
  }]
}, _class);
AddFeedButtonComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-add-feed-button',
  template: _add_feed_button_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_add_feed_button_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AddFeedButtonComponent);


/***/ }),

/***/ 70625:
/*!***********************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/discover/discover.component.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DiscoverComponent": () => (/* binding */ DiscoverComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _discover_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./discover.component.html?ngResource */ 59236);
/* harmony import */ var _discover_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./discover.component.scss?ngResource */ 97049);
/* harmony import */ var _discover_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_discover_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_services_feedly_feedly_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/feedly/feedly.service */ 84250);

var _class;






let DiscoverComponent = (_class = class DiscoverComponent {
  constructor(feedlyService, toastCtrl, changeDetector) {
    this.feedlyService = feedlyService;
    this.toastCtrl = toastCtrl;
    this.changeDetector = changeDetector;
    this.updateFeedIds = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
    this.swiperConfig = {
      slidesPerView: 1,
      navigation: false
    };
    this.currentSlide = 0;
  }
  ngOnInit() {
    this.loadFeatured();
    this.loadTrending();
  }
  onSlideChange([swiper]) {
    this.currentSlide = swiper.activeIndex;
    this.changeDetector.detectChanges();
  }
  loadFeatured() {
    this.feedlyService.search('Technology', 10, 'en').then(data => {
      let sorted = data.results.sort((a, b) => {
        return a.score + b.score;
      });
      sorted = sorted.filter(item => {
        if (!item.title.toLowerCase().includes('google')) {
          if (item.visualUrl) {
            return true;
          }
        }
      });
      this.featured = sorted.slice(0, 5);
      //alert(JSON.stringify(this.featured, null, 2));
    }).catch(error => {
      this.showToast('Error loading featured', 'danger');
    });
  }
  loadTrending() {
    this.feedlyService.search('World', 25, 'en').then(data => {
      let sorted = data.results.sort((a, b) => {
        return a.subscribers + b.subscribers;
      });
      this.trending = sorted;
    }).catch(error => {
      this.showToast('Error loading trending', 'danger');
    });
  }
  doUpdateFeedIds() {
    this.updateFeedIds.emit(true);
  }
  showToast(message, color) {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const toast = yield _this.toastCtrl.create({
        message: message,
        duration: 2000,
        color: color,
        position: 'bottom'
      });
      yield toast.present();
    })();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_feedly_feedly_service__WEBPACK_IMPORTED_MODULE_3__.FeedlyService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController
}, {
  type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.ChangeDetectorRef
}], _class.propDecorators = {
  feedIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  updateFeedIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Output
  }]
}, _class);
DiscoverComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-discover',
  template: _discover_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_discover_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], DiscoverComponent);


/***/ }),

/***/ 58158:
/*!***********************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/search-results/search-results.component.ts ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchResultsComponent": () => (/* binding */ SearchResultsComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _search_results_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./search-results.component.html?ngResource */ 49779);
/* harmony import */ var _search_results_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./search-results.component.scss?ngResource */ 26221);
/* harmony import */ var _search_results_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_search_results_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_services_feedly_feedly_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/feedly/feedly.service */ 84250);

var _class;






let SearchResultsComponent = (_class = class SearchResultsComponent {
  constructor(feedlyService, toastCtrl) {
    this.feedlyService = feedlyService;
    this.toastCtrl = toastCtrl;
    this.updateFeedIds = new _angular_core__WEBPACK_IMPORTED_MODULE_4__.EventEmitter();
  }
  ngOnInit() {}
  ngOnChanges() {
    if (this.searchQuery) {
      this.feedlyService.search(this.searchQuery).then(data => {
        this.searchResults = data.results;
      }).catch(error => {
        this.showToast('Error fetching data, try again.', 'danger');
      });
    }
  }
  doUpdateFeedIds() {
    this.updateFeedIds.emit(true);
  }
  showToast(message, color) {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const toast = yield _this.toastCtrl.create({
        message: message,
        duration: 2000,
        color: color,
        position: 'bottom'
      });
      yield toast.present();
    })();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_feedly_feedly_service__WEBPACK_IMPORTED_MODULE_3__.FeedlyService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController
}], _class.propDecorators = {
  searchQuery: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  feedIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Input
  }],
  updateFeedIds: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_4__.Output
  }]
}, _class);
SearchResultsComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
  selector: 'app-search-results',
  template: _search_results_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_search_results_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SearchResultsComponent);


/***/ }),

/***/ 96910:
/*!******************************************************************!*\
  !*** ./src/app/pages/main/pages/search/search-routing.module.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPageRoutingModule": () => (/* binding */ SearchPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var _search_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search.page */ 60355);




const routes = [{
  path: '',
  component: _search_page__WEBPACK_IMPORTED_MODULE_0__.SearchPage
}];
let SearchPageRoutingModule = class SearchPageRoutingModule {};
SearchPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], SearchPageRoutingModule);


/***/ }),

/***/ 35806:
/*!**********************************************************!*\
  !*** ./src/app/pages/main/pages/search/search.module.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPageModule": () => (/* binding */ SearchPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ 2508);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _search_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search-routing.module */ 96910);
/* harmony import */ var _search_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./search.page */ 60355);
/* harmony import */ var _components_search_results_search_results_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/search-results/search-results.component */ 58158);
/* harmony import */ var _components_discover_discover_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/discover/discover.component */ 70625);
/* harmony import */ var swiper_angular__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! swiper/angular */ 341);
/* harmony import */ var src_app_components_components_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! src/app/components/components.module */ 45642);
/* harmony import */ var src_app_pipes_pipes_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! src/app/pipes/pipes.module */ 35503);
/* harmony import */ var _components_add_feed_button_add_feed_button_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/add-feed-button/add-feed-button.component */ 81846);













let SearchPageModule = class SearchPageModule {};
SearchPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_11__.IonicModule, _search_routing_module__WEBPACK_IMPORTED_MODULE_0__.SearchPageRoutingModule, swiper_angular__WEBPACK_IMPORTED_MODULE_12__.SwiperModule, src_app_components_components_module__WEBPACK_IMPORTED_MODULE_4__.ComponentsModule, src_app_pipes_pipes_module__WEBPACK_IMPORTED_MODULE_5__.PipesModule],
  declarations: [_search_page__WEBPACK_IMPORTED_MODULE_1__.SearchPage, _components_search_results_search_results_component__WEBPACK_IMPORTED_MODULE_2__.SearchResultsComponent, _components_discover_discover_component__WEBPACK_IMPORTED_MODULE_3__.DiscoverComponent, _components_add_feed_button_add_feed_button_component__WEBPACK_IMPORTED_MODULE_6__.AddFeedButtonComponent]
})], SearchPageModule);


/***/ }),

/***/ 60355:
/*!********************************************************!*\
  !*** ./src/app/pages/main/pages/search/search.page.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPage": () => (/* binding */ SearchPage)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _search_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./search.page.html?ngResource */ 69872);
/* harmony import */ var _search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./search.page.scss?ngResource */ 12882);
/* harmony import */ var _search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! rxjs */ 61555);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! rxjs/operators */ 80823);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! rxjs/operators */ 53298);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);

var _class;







let SearchPage = (_class = class SearchPage {
  constructor(storageService) {
    this.storageService = storageService;
    this.searchQuery$ = new rxjs__WEBPACK_IMPORTED_MODULE_4__.ReplaySubject();
  }
  ionViewWillEnter() {
    this.searchQuery$.pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_5__.debounceTime)(400),
    // discard emitted values that take less than the specified time between output
    (0,rxjs_operators__WEBPACK_IMPORTED_MODULE_6__.distinctUntilChanged)() // only emit when value has changed
    ).subscribe(term => {
      this.query = term;
    });
    this.getExistingFeedIds();
  }
  updateSearchQuery(event) {
    this.searchQuery$.next(event.target.value);
  }
  getExistingFeedIds() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.feedIds = yield _this.storageService.getAllFeedIds();
    })();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}], _class);
SearchPage = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
  selector: 'app-search',
  template: _search_page_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], SearchPage);


/***/ }),

/***/ 80823:
/*!***********************************************************************!*\
  !*** ./node_modules/rxjs/_esm2015/internal/operators/debounceTime.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "debounceTime": () => (/* binding */ debounceTime)
/* harmony export */ });
/* harmony import */ var _Subscriber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Subscriber */ 60014);
/* harmony import */ var _scheduler_async__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scheduler/async */ 10328);


function debounceTime(dueTime, scheduler = _scheduler_async__WEBPACK_IMPORTED_MODULE_0__.async) {
  return source => source.lift(new DebounceTimeOperator(dueTime, scheduler));
}
class DebounceTimeOperator {
  constructor(dueTime, scheduler) {
    this.dueTime = dueTime;
    this.scheduler = scheduler;
  }
  call(subscriber, source) {
    return source.subscribe(new DebounceTimeSubscriber(subscriber, this.dueTime, this.scheduler));
  }
}
class DebounceTimeSubscriber extends _Subscriber__WEBPACK_IMPORTED_MODULE_1__.Subscriber {
  constructor(destination, dueTime, scheduler) {
    super(destination);
    this.dueTime = dueTime;
    this.scheduler = scheduler;
    this.debouncedSubscription = null;
    this.lastValue = null;
    this.hasValue = false;
  }
  _next(value) {
    this.clearDebounce();
    this.lastValue = value;
    this.hasValue = true;
    this.add(this.debouncedSubscription = this.scheduler.schedule(dispatchNext, this.dueTime, this));
  }
  _complete() {
    this.debouncedNext();
    this.destination.complete();
  }
  debouncedNext() {
    this.clearDebounce();
    if (this.hasValue) {
      const {
        lastValue
      } = this;
      this.lastValue = null;
      this.hasValue = false;
      this.destination.next(lastValue);
    }
  }
  clearDebounce() {
    const debouncedSubscription = this.debouncedSubscription;
    if (debouncedSubscription !== null) {
      this.remove(debouncedSubscription);
      debouncedSubscription.unsubscribe();
      this.debouncedSubscription = null;
    }
  }
}
function dispatchNext(subscriber) {
  subscriber.debouncedNext();
}

/***/ }),

/***/ 82643:
/*!**************************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/add-feed-button/add-feed-button.component.scss?ngResource ***!
  \**************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".light {\n  color: var(--fixed-light) !important;\n}", "",{"version":3,"sources":["webpack://./src/app/pages/main/pages/search/components/add-feed-button/add-feed-button.component.scss"],"names":[],"mappings":"AAAA;EACE,oCAAA;AACF","sourcesContent":[".light {\n  color: var(--fixed-light) !important;\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 97049:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/discover/discover.component.scss?ngResource ***!
  \************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "@font-face {\n  font-family: \"swiper-icons\";\n  src: url(\"data:application/font-woff;charset=utf-8;base64, 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\") format(\"woff\");\n  font-weight: 400;\n  font-style: normal;\n}\n:root {\n  --swiper-theme-color: #007aff;\n}\n\n.swiper {\n  margin-left: auto;\n  margin-right: auto;\n  position: relative;\n  overflow: hidden;\n  list-style: none;\n  padding: 0;\n  /* Fix of Webkit flickering */\n  z-index: 1;\n}\n\n.swiper-vertical > .swiper-wrapper {\n  flex-direction: column;\n}\n\n.swiper-wrapper {\n  position: relative;\n  width: 100%;\n  height: 100%;\n  z-index: 1;\n  display: flex;\n  transition-property: transform;\n  box-sizing: content-box;\n}\n\n.swiper-android .swiper-slide,\n.swiper-wrapper {\n  transform: translate3d(0px, 0, 0);\n}\n\n.swiper-pointer-events {\n  touch-action: pan-y;\n}\n.swiper-pointer-events.swiper-vertical {\n  touch-action: pan-x;\n}\n\n.swiper-slide {\n  flex-shrink: 0;\n  width: 100%;\n  height: 100%;\n  position: relative;\n  transition-property: transform;\n}\n\n.swiper-slide-invisible-blank {\n  visibility: hidden;\n}\n\n/* Auto Height */\n.swiper-autoheight,\n.swiper-autoheight .swiper-slide {\n  height: auto;\n}\n.swiper-autoheight .swiper-wrapper {\n  align-items: flex-start;\n  transition-property: transform, height;\n}\n\n.swiper-backface-hidden .swiper-slide {\n  transform: translateZ(0);\n  -webkit-backface-visibility: hidden;\n          backface-visibility: hidden;\n}\n\n/* 3D Effects */\n.swiper-3d, .swiper-3d.swiper-css-mode .swiper-wrapper {\n  perspective: 1200px;\n}\n.swiper-3d .swiper-wrapper,\n.swiper-3d .swiper-slide,\n.swiper-3d .swiper-slide-shadow,\n.swiper-3d .swiper-slide-shadow-left,\n.swiper-3d .swiper-slide-shadow-right,\n.swiper-3d .swiper-slide-shadow-top,\n.swiper-3d .swiper-slide-shadow-bottom,\n.swiper-3d .swiper-cube-shadow {\n  transform-style: preserve-3d;\n}\n.swiper-3d .swiper-slide-shadow,\n.swiper-3d .swiper-slide-shadow-left,\n.swiper-3d .swiper-slide-shadow-right,\n.swiper-3d .swiper-slide-shadow-top,\n.swiper-3d .swiper-slide-shadow-bottom {\n  position: absolute;\n  left: 0;\n  top: 0;\n  width: 100%;\n  height: 100%;\n  pointer-events: none;\n  z-index: 10;\n}\n.swiper-3d .swiper-slide-shadow {\n  background: rgba(0, 0, 0, 0.15);\n}\n.swiper-3d .swiper-slide-shadow-left {\n  background-image: linear-gradient(to left, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n}\n.swiper-3d .swiper-slide-shadow-right {\n  background-image: linear-gradient(to right, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n}\n.swiper-3d .swiper-slide-shadow-top {\n  background-image: linear-gradient(to top, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n}\n.swiper-3d .swiper-slide-shadow-bottom {\n  background-image: linear-gradient(to bottom, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n}\n\n/* CSS Mode */\n.swiper-css-mode > .swiper-wrapper {\n  overflow: auto;\n  scrollbar-width: none; /* For Firefox */\n  -ms-overflow-style: none; /* For Internet Explorer and Edge */\n}\n.swiper-css-mode > .swiper-wrapper::-webkit-scrollbar {\n  display: none;\n}\n.swiper-css-mode > .swiper-wrapper > .swiper-slide {\n  scroll-snap-align: start start;\n}\n\n.swiper-horizontal.swiper-css-mode > .swiper-wrapper {\n  scroll-snap-type: x mandatory;\n}\n\n.swiper-vertical.swiper-css-mode > .swiper-wrapper {\n  scroll-snap-type: y mandatory;\n}\n\n.swiper-centered > .swiper-wrapper::before {\n  content: \"\";\n  flex-shrink: 0;\n  order: 9999;\n}\n.swiper-centered.swiper-horizontal > .swiper-wrapper > .swiper-slide:first-child {\n  margin-inline-start: var(--swiper-centered-offset-before);\n}\n.swiper-centered.swiper-horizontal > .swiper-wrapper::before {\n  height: 100%;\n  width: var(--swiper-centered-offset-after);\n}\n.swiper-centered.swiper-vertical > .swiper-wrapper > .swiper-slide:first-child {\n  margin-block-start: var(--swiper-centered-offset-before);\n}\n.swiper-centered.swiper-vertical > .swiper-wrapper::before {\n  width: 100%;\n  height: var(--swiper-centered-offset-after);\n}\n.swiper-centered > .swiper-wrapper > .swiper-slide {\n  scroll-snap-align: center center;\n}\n\n:root {\n  --swiper-navigation-size: 44px;\n  /*\n  --swiper-navigation-color: var(--swiper-theme-color);\n  */\n}\n\n.swiper-button-prev,\n.swiper-button-next {\n  position: absolute;\n  top: 50%;\n  width: calc(var(--swiper-navigation-size) / 44 * 27);\n  height: var(--swiper-navigation-size);\n  margin-top: calc(0px - var(--swiper-navigation-size) / 2);\n  z-index: 10;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  color: var(--swiper-navigation-color, var(--swiper-theme-color));\n}\n.swiper-button-prev.swiper-button-disabled,\n.swiper-button-next.swiper-button-disabled {\n  opacity: 0.35;\n  cursor: auto;\n  pointer-events: none;\n}\n.swiper-button-prev:after,\n.swiper-button-next:after {\n  font-family: swiper-icons;\n  font-size: var(--swiper-navigation-size);\n  letter-spacing: 0;\n  text-transform: none;\n  font-variant: initial;\n  line-height: 1;\n}\n\n.swiper-button-prev,\n.swiper-rtl .swiper-button-next {\n  left: 10px;\n  right: auto;\n}\n.swiper-button-prev:after,\n.swiper-rtl .swiper-button-next:after {\n  content: \"prev\";\n}\n\n.swiper-button-next,\n.swiper-rtl .swiper-button-prev {\n  right: 10px;\n  left: auto;\n}\n.swiper-button-next:after,\n.swiper-rtl .swiper-button-prev:after {\n  content: \"next\";\n}\n\n.swiper-button-lock {\n  display: none;\n}\n\n:root {\n  /*\n  --swiper-pagination-color: var(--swiper-theme-color);\n  --swiper-pagination-bullet-size: 8px;\n  --swiper-pagination-bullet-width: 8px;\n  --swiper-pagination-bullet-height: 8px;\n  --swiper-pagination-bullet-inactive-color: #000;\n  --swiper-pagination-bullet-inactive-opacity: 0.2;\n  --swiper-pagination-bullet-opacity: 1;\n  --swiper-pagination-bullet-horizontal-gap: 4px;\n  --swiper-pagination-bullet-vertical-gap: 6px;\n  */\n}\n\n.swiper-pagination {\n  position: absolute;\n  text-align: center;\n  transition: 300ms opacity;\n  transform: translate3d(0, 0, 0);\n  z-index: 10;\n}\n.swiper-pagination.swiper-pagination-hidden {\n  opacity: 0;\n}\n\n/* Common Styles */\n.swiper-pagination-fraction,\n.swiper-pagination-custom,\n.swiper-horizontal > .swiper-pagination-bullets,\n.swiper-pagination-bullets.swiper-pagination-horizontal {\n  bottom: 10px;\n  left: 0;\n  width: 100%;\n}\n\n/* Bullets */\n.swiper-pagination-bullets-dynamic {\n  overflow: hidden;\n  font-size: 0;\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet {\n  transform: scale(0.33);\n  position: relative;\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active {\n  transform: scale(1);\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-main {\n  transform: scale(1);\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-prev {\n  transform: scale(0.66);\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-prev-prev {\n  transform: scale(0.33);\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-next {\n  transform: scale(0.66);\n}\n.swiper-pagination-bullets-dynamic .swiper-pagination-bullet-active-next-next {\n  transform: scale(0.33);\n}\n\n.swiper-pagination-bullet {\n  width: var(--swiper-pagination-bullet-width, var(--swiper-pagination-bullet-size, 8px));\n  height: var(--swiper-pagination-bullet-height, var(--swiper-pagination-bullet-size, 8px));\n  display: inline-block;\n  border-radius: 50%;\n  background: var(--swiper-pagination-bullet-inactive-color, #000);\n  opacity: var(--swiper-pagination-bullet-inactive-opacity, 0.2);\n}\nbutton.swiper-pagination-bullet {\n  border: none;\n  margin: 0;\n  padding: 0;\n  box-shadow: none;\n  -webkit-appearance: none;\n          appearance: none;\n}\n\n.swiper-pagination-clickable .swiper-pagination-bullet {\n  cursor: pointer;\n}\n.swiper-pagination-bullet:only-child {\n  display: none !important;\n}\n\n.swiper-pagination-bullet-active {\n  opacity: var(--swiper-pagination-bullet-opacity, 1);\n  background: var(--swiper-pagination-color, var(--swiper-theme-color));\n}\n\n.swiper-vertical > .swiper-pagination-bullets,\n.swiper-pagination-vertical.swiper-pagination-bullets {\n  right: 10px;\n  top: 50%;\n  transform: translate3d(0px, -50%, 0);\n}\n.swiper-vertical > .swiper-pagination-bullets .swiper-pagination-bullet,\n.swiper-pagination-vertical.swiper-pagination-bullets .swiper-pagination-bullet {\n  margin: var(--swiper-pagination-bullet-vertical-gap, 6px) 0;\n  display: block;\n}\n.swiper-vertical > .swiper-pagination-bullets.swiper-pagination-bullets-dynamic,\n.swiper-pagination-vertical.swiper-pagination-bullets.swiper-pagination-bullets-dynamic {\n  top: 50%;\n  transform: translateY(-50%);\n  width: 8px;\n}\n.swiper-vertical > .swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet,\n.swiper-pagination-vertical.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet {\n  display: inline-block;\n  transition: 200ms transform, 200ms top;\n}\n\n.swiper-horizontal > .swiper-pagination-bullets .swiper-pagination-bullet,\n.swiper-pagination-horizontal.swiper-pagination-bullets .swiper-pagination-bullet {\n  margin: 0 var(--swiper-pagination-bullet-horizontal-gap, 4px);\n}\n.swiper-horizontal > .swiper-pagination-bullets.swiper-pagination-bullets-dynamic,\n.swiper-pagination-horizontal.swiper-pagination-bullets.swiper-pagination-bullets-dynamic {\n  left: 50%;\n  transform: translateX(-50%);\n  white-space: nowrap;\n}\n.swiper-horizontal > .swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet,\n.swiper-pagination-horizontal.swiper-pagination-bullets.swiper-pagination-bullets-dynamic .swiper-pagination-bullet {\n  transition: 200ms transform, 200ms left;\n}\n\n.swiper-horizontal.swiper-rtl > .swiper-pagination-bullets-dynamic .swiper-pagination-bullet {\n  transition: 200ms transform, 200ms right;\n}\n\n/* Progress */\n.swiper-pagination-progressbar {\n  background: rgba(0, 0, 0, 0.25);\n  position: absolute;\n}\n.swiper-pagination-progressbar .swiper-pagination-progressbar-fill {\n  background: var(--swiper-pagination-color, var(--swiper-theme-color));\n  position: absolute;\n  left: 0;\n  top: 0;\n  width: 100%;\n  height: 100%;\n  transform: scale(0);\n  transform-origin: left top;\n}\n.swiper-rtl .swiper-pagination-progressbar .swiper-pagination-progressbar-fill {\n  transform-origin: right top;\n}\n.swiper-horizontal > .swiper-pagination-progressbar, .swiper-pagination-progressbar.swiper-pagination-horizontal, .swiper-vertical > .swiper-pagination-progressbar.swiper-pagination-progressbar-opposite, .swiper-pagination-progressbar.swiper-pagination-vertical.swiper-pagination-progressbar-opposite {\n  width: 100%;\n  height: 4px;\n  left: 0;\n  top: 0;\n}\n.swiper-vertical > .swiper-pagination-progressbar, .swiper-pagination-progressbar.swiper-pagination-vertical, .swiper-horizontal > .swiper-pagination-progressbar.swiper-pagination-progressbar-opposite, .swiper-pagination-progressbar.swiper-pagination-horizontal.swiper-pagination-progressbar-opposite {\n  width: 4px;\n  height: 100%;\n  left: 0;\n  top: 0;\n}\n\n.swiper-pagination-lock {\n  display: none;\n}\n\n.header {\n  background-color: var(--main-toolbar-background);\n}\n.header .swiper {\n  height: 100%;\n  display: inline-flex;\n}\n.header .swiper ::ng-deep.swiper-wrapper {\n  height: 100%;\n  display: inline-flex;\n}\n.header .swiper ::ng-deep.swiper-wrapper .swiper-slide {\n  height: 100% !important;\n}\n\n.paginator-active {\n  background-color: rgb(148, 163, 184) !important;\n}", "",{"version":3,"sources":["webpack://./node_modules/swiper/swiper.scss","webpack://./src/app/pages/main/pages/search/components/discover/discover.component.scss","webpack://./node_modules/swiper/modules/navigation/navigation.scss","webpack://./node_modules/swiper/modules/pagination/pagination.scss"],"names":[],"mappings":"AAEE;EACE,2BAAA;EACA,4sEAAA;EAEA,gBAAA;EACA,kBAAA;ACFJ;ADME;EACE,6BAAA;ACJJ;;ADOA;EACE,iBAAA;EACA,kBAAA;EACA,kBAAA;EACA,gBAAA;EACA,gBAAA;EACA,UAAA;EACA,6BAAA;EACA,UAAA;ACJF;;ADMA;EACE,sBAAA;ACHF;;ADKA;EACE,kBAAA;EACA,WAAA;EACA,YAAA;EACA,UAAA;EACA,aAAA;EACA,8BAAA;EACA,uBAAA;ACFF;;ADIA;;EAEE,iCAAA;ACDF;;ADGA;EACE,mBAAA;ACAF;ADCE;EACE,mBAAA;ACCJ;;ADEA;EACE,cAAA;EACA,WAAA;EACA,YAAA;EACA,kBAAA;EACA,8BAAA;ACCF;;ADCA;EACE,kBAAA;ACEF;;ADAA,gBAAA;AAEE;;EAEE,YAAA;ACEJ;ADCE;EACE,uBAAA;EACA,sCAAA;ACCJ;;ADEA;EACE,wBAAA;EACA,mCAAA;UAAA,2BAAA;ACCF;;ADCA,eAAA;AAEE;EAEE,mBAAA;ACAJ;ADEE;;;;;;;;EAQE,4BAAA;ACAJ;ADEE;;;;;EAKE,kBAAA;EACA,OAAA;EACA,MAAA;EACA,WAAA;EACA,YAAA;EACA,oBAAA;EACA,WAAA;ACAJ;ADEE;EACE,+BAAA;ACAJ;ADEE;EACE,gFAAA;ACAJ;ADEE;EACE,iFAAA;ACAJ;ADEE;EACE,+EAAA;ACAJ;ADEE;EACE,kFAAA;ACAJ;;ADIA,aAAA;AAEE;EACE,cAAA;EACA,qBAAA,EAAA,gBAAA;EACA,wBAAA,EAAA,mCAAA;ACFJ;ADGI;EACE,aAAA;ACDN;ADIE;EACE,8BAAA;ACFJ;;ADME;EACE,6BAAA;ACHJ;;ADOE;EACE,6BAAA;ACJJ;;ADQE;EACE,WAAA;EACA,cAAA;EACA,WAAA;ACLJ;ADQI;EACE,yDAAA;ACNN;ADQI;EACE,YAAA;EACA,0CAAA;ACNN;ADUI;EACE,wDAAA;ACRN;ADUI;EACE,WAAA;EACA,2CAAA;ACRN;ADYE;EACE,gCAAA;ACVJ;;AC7JE;EACE,8BAAA;EACA;;GAAA;ADkKJ;;AC7JA;;EAEE,kBAAA;EACA,QAAA;EACA,oDAAA;EACA,qCAAA;EACA,yDAAA;EACA,WAAA;EACA,eAAA;EACA,aAAA;EACA,mBAAA;EACA,uBAAA;EACA,gEAAA;ADgKF;AC/JE;;EACE,aAAA;EACA,YAAA;EACA,oBAAA;ADkKJ;AChKE;;EACE,yBAAA;EACA,wCAAA;EAEA,iBAAA;EACA,oBAAA;EACA,qBAAA;EACA,cAAA;ADmKJ;;AChKA;;EAKE,UAAA;EACA,WAAA;ADgKF;ACpKE;;EACE,eAAA;ADuKJ;;AClKA;;EAKE,WAAA;EACA,UAAA;ADkKF;ACtKE;;EACE,eAAA;ADyKJ;;ACnKA;EACE,aAAA;ADsKF;;AE3NE;EACE;;;;;;;;;;GAAA;AFwOJ;;AE3NA;EACE,kBAAA;EACA,kBAAA;EACA,yBAAA;EACA,+BAAA;EACA,WAAA;AF8NF;AE7NE;EACE,UAAA;AF+NJ;;AE5NA,kBAAA;AACA;;;;EAIE,YAAA;EACA,OAAA;EACA,WAAA;AF+NF;;AE7NA,YAAA;AACA;EACE,gBAAA;EACA,YAAA;AFgOF;AE/NE;EACE,sBAAA;EACA,kBAAA;AFiOJ;AE/NE;EACE,mBAAA;AFiOJ;AE/NE;EACE,mBAAA;AFiOJ;AE/NE;EACE,sBAAA;AFiOJ;AE/NE;EACE,sBAAA;AFiOJ;AE/NE;EACE,sBAAA;AFiOJ;AE/NE;EACE,sBAAA;AFiOJ;;AE9NA;EACE,uFAAA;EACA,yFAAA;EACA,qBAAA;EACA,kBAAA;EACA,gEAAA;EACA,8DAAA;AFiOF;AEhOW;EACP,YAAA;EACA,SAAA;EACA,UAAA;EACA,gBAAA;EACA,wBAAA;UAAA,gBAAA;AFkOJ;;AEhOE;EACE,eAAA;AFmOJ;AEhOE;EACE,wBAAA;AFkOJ;;AE/NA;EACE,mDAAA;EACA,qEAAA;AFkOF;;AE/NA;;EAEE,WAAA;EACA,QAAA;EACA,oCAAA;AFkOF;AEjOE;;EACE,2DAAA;EACA,cAAA;AFoOJ;AElOE;;EACE,QAAA;EACA,2BAAA;EACA,UAAA;AFqOJ;AEpOI;;EACE,qBAAA;EACA,sCAAA;AFuON;;AEjOE;;EACE,6DAAA;AFqOJ;AEnOE;;EACE,SAAA;EACA,2BAAA;EACA,mBAAA;AFsOJ;AErOI;;EACE,uCAAA;AFwON;;AEpOA;EACE,wCAAA;AFuOF;;AErOA,aAAA;AACA;EACE,+BAAA;EACA,kBAAA;AFwOF;AEvOE;EACE,qEAAA;EACA,kBAAA;EACA,OAAA;EACA,MAAA;EACA,WAAA;EACA,YAAA;EACA,mBAAA;EACA,0BAAA;AFyOJ;AEvOE;EACE,2BAAA;AFyOJ;AEvOE;EAIE,WAAA;EACA,WAAA;EACA,OAAA;EACA,MAAA;AFsOJ;AEpOE;EAIE,UAAA;EACA,YAAA;EACA,OAAA;EACA,MAAA;AFmOJ;;AEhOA;EACE,aAAA;AFmOF;;AAjYA;EACE,gDAAA;AAoYF;AAlYE;EACE,YAAA;EACA,oBAAA;AAoYJ;AAnYI;EACE,YAAA;EACA,oBAAA;AAqYN;AApYM;EACE,uBAAA;AAsYR;;AAjYA;EACE,+CAAA;AAoYF","sourcesContent":["@import 'swiper-vars.scss';\n@at-root {\n  @font-face {\n    font-family: 'swiper-icons';\n    src: url('data:application/font-woff;charset=utf-8;base64, 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')\n      format('woff');\n    font-weight: 400;\n    font-style: normal;\n  }\n}\n@at-root {\n  :root {\n    --swiper-theme-color: #{$themeColor};\n  }\n}\n.swiper {\n  margin-left: auto;\n  margin-right: auto;\n  position: relative;\n  overflow: hidden;\n  list-style: none;\n  padding: 0;\n  /* Fix of Webkit flickering */\n  z-index: 1;\n}\n.swiper-vertical > .swiper-wrapper {\n  flex-direction: column;\n}\n.swiper-wrapper {\n  position: relative;\n  width: 100%;\n  height: 100%;\n  z-index: 1;\n  display: flex;\n  transition-property: transform;\n  box-sizing: content-box;\n}\n.swiper-android .swiper-slide,\n.swiper-wrapper {\n  transform: translate3d(0px, 0, 0);\n}\n.swiper-pointer-events {\n  touch-action: pan-y;\n  &.swiper-vertical {\n    touch-action: pan-x;\n  }\n}\n.swiper-slide {\n  flex-shrink: 0;\n  width: 100%;\n  height: 100%;\n  position: relative;\n  transition-property: transform;\n}\n.swiper-slide-invisible-blank {\n  visibility: hidden;\n}\n/* Auto Height */\n.swiper-autoheight {\n  &,\n  .swiper-slide {\n    height: auto;\n  }\n\n  .swiper-wrapper {\n    align-items: flex-start;\n    transition-property: transform, height;\n  }\n}\n.swiper-backface-hidden .swiper-slide {\n  transform: translateZ(0);\n  backface-visibility: hidden;\n}\n/* 3D Effects */\n.swiper-3d {\n  &,\n  &.swiper-css-mode .swiper-wrapper {\n    perspective: 1200px;\n  }\n  .swiper-wrapper,\n  .swiper-slide,\n  .swiper-slide-shadow,\n  .swiper-slide-shadow-left,\n  .swiper-slide-shadow-right,\n  .swiper-slide-shadow-top,\n  .swiper-slide-shadow-bottom,\n  .swiper-cube-shadow {\n    transform-style: preserve-3d;\n  }\n  .swiper-slide-shadow,\n  .swiper-slide-shadow-left,\n  .swiper-slide-shadow-right,\n  .swiper-slide-shadow-top,\n  .swiper-slide-shadow-bottom {\n    position: absolute;\n    left: 0;\n    top: 0;\n    width: 100%;\n    height: 100%;\n    pointer-events: none;\n    z-index: 10;\n  }\n  .swiper-slide-shadow {\n    background: rgba(0, 0, 0, 0.15);\n  }\n  .swiper-slide-shadow-left {\n    background-image: linear-gradient(to left, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n  }\n  .swiper-slide-shadow-right {\n    background-image: linear-gradient(to right, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n  }\n  .swiper-slide-shadow-top {\n    background-image: linear-gradient(to top, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n  }\n  .swiper-slide-shadow-bottom {\n    background-image: linear-gradient(to bottom, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0));\n  }\n}\n\n/* CSS Mode */\n.swiper-css-mode {\n  > .swiper-wrapper {\n    overflow: auto;\n    scrollbar-width: none; /* For Firefox */\n    -ms-overflow-style: none; /* For Internet Explorer and Edge */\n    &::-webkit-scrollbar {\n      display: none;\n    }\n  }\n  > .swiper-wrapper > .swiper-slide {\n    scroll-snap-align: start start;\n  }\n}\n.swiper-horizontal.swiper-css-mode {\n  > .swiper-wrapper {\n    scroll-snap-type: x mandatory;\n  }\n}\n.swiper-vertical.swiper-css-mode {\n  > .swiper-wrapper {\n    scroll-snap-type: y mandatory;\n  }\n}\n.swiper-centered {\n  > .swiper-wrapper::before {\n    content: '';\n    flex-shrink: 0;\n    order: 9999;\n  }\n  &.swiper-horizontal {\n    > .swiper-wrapper > .swiper-slide:first-child {\n      margin-inline-start: var(--swiper-centered-offset-before);\n    }\n    > .swiper-wrapper::before {\n      height: 100%;\n      width: var(--swiper-centered-offset-after);\n    }\n  }\n  &.swiper-vertical {\n    > .swiper-wrapper > .swiper-slide:first-child {\n      margin-block-start: var(--swiper-centered-offset-before);\n    }\n    > .swiper-wrapper::before {\n      width: 100%;\n      height: var(--swiper-centered-offset-after);\n    }\n  }\n\n  > .swiper-wrapper > .swiper-slide {\n    scroll-snap-align: center center;\n  }\n}\n\n\n\n","@import 'swiper/scss';\n@import 'swiper/scss/navigation';\n@import 'swiper/scss/pagination';\n\n.header {\n  background-color: var(--main-toolbar-background);\n\n  .swiper {\n    height: 100%;\n    display:inline-flex;\n    ::ng-deep.swiper-wrapper {\n      height: 100%;\n      display:inline-flex;\n      .swiper-slide {\n        height: 100% !important;\n      }\n    }\n  }\n}\n.paginator-active {\n  background-color: rgb(148 163 184) !important;\n}","@import '../../swiper-vars.scss';\n@at-root {\n  :root {\n    --swiper-navigation-size: 44px;\n    /*\n  --swiper-navigation-color: var(--swiper-theme-color);\n  */\n  }\n}\n.swiper-button-prev,\n.swiper-button-next {\n  position: absolute;\n  top: 50%;\n  width: calc(var(--swiper-navigation-size) / 44 * 27);\n  height: var(--swiper-navigation-size);\n  margin-top: calc(0px - (var(--swiper-navigation-size) / 2));\n  z-index: 10;\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  color: var(--swiper-navigation-color, var(--swiper-theme-color));\n  &.swiper-button-disabled {\n    opacity: 0.35;\n    cursor: auto;\n    pointer-events: none;\n  }\n  &:after {\n    font-family: swiper-icons;\n    font-size: var(--swiper-navigation-size);\n    text-transform: none !important;\n    letter-spacing: 0;\n    text-transform: none;\n    font-variant: initial;\n    line-height: 1;\n  }\n}\n.swiper-button-prev,\n.swiper-rtl .swiper-button-next {\n  &:after {\n    content: 'prev';\n  }\n  left: 10px;\n  right: auto;\n}\n.swiper-button-next,\n.swiper-rtl .swiper-button-prev {\n  &:after {\n    content: 'next';\n  }\n  right: 10px;\n  left: auto;\n}\n\n.swiper-button-lock {\n  display: none;\n}\n","@import '../../swiper-vars.scss';\n@at-root {\n  :root {\n    /*\n  --swiper-pagination-color: var(--swiper-theme-color);\n  --swiper-pagination-bullet-size: 8px;\n  --swiper-pagination-bullet-width: 8px;\n  --swiper-pagination-bullet-height: 8px;\n  --swiper-pagination-bullet-inactive-color: #000;\n  --swiper-pagination-bullet-inactive-opacity: 0.2;\n  --swiper-pagination-bullet-opacity: 1;\n  --swiper-pagination-bullet-horizontal-gap: 4px;\n  --swiper-pagination-bullet-vertical-gap: 6px;\n  */\n  }\n}\n.swiper-pagination {\n  position: absolute;\n  text-align: center;\n  transition: 300ms opacity;\n  transform: translate3d(0, 0, 0);\n  z-index: 10;\n  &.swiper-pagination-hidden {\n    opacity: 0;\n  }\n}\n/* Common Styles */\n.swiper-pagination-fraction,\n.swiper-pagination-custom,\n.swiper-horizontal > .swiper-pagination-bullets,\n.swiper-pagination-bullets.swiper-pagination-horizontal {\n  bottom: 10px;\n  left: 0;\n  width: 100%;\n}\n/* Bullets */\n.swiper-pagination-bullets-dynamic {\n  overflow: hidden;\n  font-size: 0;\n  .swiper-pagination-bullet {\n    transform: scale(0.33);\n    position: relative;\n  }\n  .swiper-pagination-bullet-active {\n    transform: scale(1);\n  }\n  .swiper-pagination-bullet-active-main {\n    transform: scale(1);\n  }\n  .swiper-pagination-bullet-active-prev {\n    transform: scale(0.66);\n  }\n  .swiper-pagination-bullet-active-prev-prev {\n    transform: scale(0.33);\n  }\n  .swiper-pagination-bullet-active-next {\n    transform: scale(0.66);\n  }\n  .swiper-pagination-bullet-active-next-next {\n    transform: scale(0.33);\n  }\n}\n.swiper-pagination-bullet {\n  width: var(--swiper-pagination-bullet-width, var(--swiper-pagination-bullet-size, 8px));\n  height: var(--swiper-pagination-bullet-height, var(--swiper-pagination-bullet-size, 8px));\n  display: inline-block;\n  border-radius: 50%;\n  background: var(--swiper-pagination-bullet-inactive-color, #000);\n  opacity: var(--swiper-pagination-bullet-inactive-opacity, 0.2);\n  @at-root button#{&} {\n    border: none;\n    margin: 0;\n    padding: 0;\n    box-shadow: none;\n    appearance: none;\n  }\n  .swiper-pagination-clickable & {\n    cursor: pointer;\n  }\n\n  &:only-child {\n    display: none !important;\n  }\n}\n.swiper-pagination-bullet-active {\n  opacity: var(--swiper-pagination-bullet-opacity, 1);\n  background: var(--swiper-pagination-color, var(--swiper-theme-color));\n}\n\n.swiper-vertical > .swiper-pagination-bullets,\n.swiper-pagination-vertical.swiper-pagination-bullets {\n  right: 10px;\n  top: 50%;\n  transform: translate3d(0px, -50%, 0);\n  .swiper-pagination-bullet {\n    margin: var(--swiper-pagination-bullet-vertical-gap, 6px) 0;\n    display: block;\n  }\n  &.swiper-pagination-bullets-dynamic {\n    top: 50%;\n    transform: translateY(-50%);\n    width: 8px;\n    .swiper-pagination-bullet {\n      display: inline-block;\n      transition: 200ms transform, 200ms top;\n    }\n  }\n}\n.swiper-horizontal > .swiper-pagination-bullets,\n.swiper-pagination-horizontal.swiper-pagination-bullets {\n  .swiper-pagination-bullet {\n    margin: 0 var(--swiper-pagination-bullet-horizontal-gap, 4px);\n  }\n  &.swiper-pagination-bullets-dynamic {\n    left: 50%;\n    transform: translateX(-50%);\n    white-space: nowrap;\n    .swiper-pagination-bullet {\n      transition: 200ms transform, 200ms left;\n    }\n  }\n}\n.swiper-horizontal.swiper-rtl > .swiper-pagination-bullets-dynamic .swiper-pagination-bullet {\n  transition: 200ms transform, 200ms right;\n}\n/* Progress */\n.swiper-pagination-progressbar {\n  background: rgba(0, 0, 0, 0.25);\n  position: absolute;\n  .swiper-pagination-progressbar-fill {\n    background: var(--swiper-pagination-color, var(--swiper-theme-color));\n    position: absolute;\n    left: 0;\n    top: 0;\n    width: 100%;\n    height: 100%;\n    transform: scale(0);\n    transform-origin: left top;\n  }\n  .swiper-rtl & .swiper-pagination-progressbar-fill {\n    transform-origin: right top;\n  }\n  .swiper-horizontal > &,\n  &.swiper-pagination-horizontal,\n  .swiper-vertical > &.swiper-pagination-progressbar-opposite,\n  &.swiper-pagination-vertical.swiper-pagination-progressbar-opposite {\n    width: 100%;\n    height: 4px;\n    left: 0;\n    top: 0;\n  }\n  .swiper-vertical > &,\n  &.swiper-pagination-vertical,\n  .swiper-horizontal > &.swiper-pagination-progressbar-opposite,\n  &.swiper-pagination-horizontal.swiper-pagination-progressbar-opposite {\n    width: 4px;\n    height: 100%;\n    left: 0;\n    top: 0;\n  }\n}\n.swiper-pagination-lock {\n  display: none;\n}\n"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 26221:
/*!************************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/search-results/search-results.component.scss?ngResource ***!
  \************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "", "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 12882:
/*!*********************************************************************!*\
  !*** ./src/app/pages/main/pages/search/search.page.scss?ngResource ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".main-toolbar {\n  --background: var(--main-toolbar-background);\n}", "",{"version":3,"sources":["webpack://./src/app/pages/main/pages/search/search.page.scss"],"names":[],"mappings":"AAAA;EACE,4CAAA;AACF","sourcesContent":[".main-toolbar {\n  --background: var(--main-toolbar-background);\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 24891:
/*!**************************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/add-feed-button/add-feed-button.component.html?ngResource ***!
  \**************************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "\n<ion-button fill=\"clear\" (click)=\"handleButtonAction()\" [class]=\"color\" [disabled]=\"exists\">\n  <ion-icon slot=\"icon-only\" name=\"add\" *ngIf=\"!exists\"></ion-icon>\n  <ion-icon slot=\"icon-only\" name=\"checkmark-circle-outline\" color=\"primary\" *ngIf=\"exists\"></ion-icon>\n</ion-button>\n";

/***/ }),

/***/ 59236:
/*!************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/discover/discover.component.html?ngResource ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<!-- Header -->\n<div class=\"header w-full h-42 border-b-1 border-slate-500 shadow-sm\">\n  <swiper [config]=\"swiperConfig\" (slideChange)=\"onSlideChange($event)\" class=\"h-full w-full\">\n    <ng-template swiperSlide *ngFor=\"let feed of featured\">\n      <div class=\"w-full h-full flex p-5\">\n        <div class=\"w-1/2 h-full flex items-center justify-center\">\n          <img [src]=\"feed.visualUrl\" class=\"h-full w-full rounded-lg ml-1 mr-4 shadow-md\">\n        </div>\n        <div class=\"w-1/2 h-full text-white flex items-center justify-center\">\n          <div class=\"w-full\">\n            <div class=\"flex w-full mb-2\">\n              <div class=\"w-5/6\">\n                <div class=\"bg-slate-500 text-slate-200 font-bold rounded-full px-2 shadow-md h-fit w-fit\">\n                  <span class=\"text-xs uppercase tracking-widest\">Featured</span>\n                </div>\n              </div>\n              <div class=\"w-1/6\">\n                <div class=\"w-8 h-8 active:bg-slate-500 rounded-full flex items-center justify-center -mt-1\">\n                  <app-add-feed-button [feed]=\"feed\" [feedsIds]=\"feedIds\" color=\"light\" (updateFeedIds)=\"doUpdateFeedIds()\"></app-add-feed-button>\n                </div>\n              </div>\n            </div>\n            <h1 class=\"font-bold line-clamp-2 text-xl drop-shadow-md\">{{ feed.title }}</h1>\n            <div class=\"flex flex-wrap w-full\">\n              <div class=\"rounded-full bg-slate-600 text-slate-100 py-1 px-2 m-1 font-normal text-xs shadow-sm\" *ngFor=\"let topic of feed.topics | slice:0:2\">\n                {{ topic }}\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </ng-template>\n  </swiper>\n</div>\n\n<!-- Paginator -->\n<div class=\"w-full h-4 flex items-center justify-center mt-2\">\n  <div class=\"w-fit flex flex-row\">\n    <div\n    *ngFor=\"let item of featured; let i = index\" \n    [ngClass]=\"{'paginator-active': currentSlide === i}\"\n    class=\"w-2 h-2 rounded-full bg-slate-200 dark:!bg-slate-700 mx-1\"></div>\n  </div> \n</div>\n\n<!-- Trending content -->\n\n<div class=\"w-full mb-14\">\n  <ion-list-header mode=\"ios\">\n    Trending\n  </ion-list-header>\n  \n  <ion-list>\n    <ion-item *ngFor=\"let feed of trending\" lines=\"none\">\n      <ion-thumbnail slot=\"start\">\n        <img [src]=\"feed.visualUrl ?? feed.iconUrl\">\n        <ion-skeleton-text *ngIf=\"!feed.visualUrl && !feed.iconUrl\"></ion-skeleton-text>\n      </ion-thumbnail>\n      <ion-label>\n        <h2>{{feed.title}}</h2>\n        <p>{{feed.description}}</p>\n      </ion-label>\n      <ion-buttons slot=\"end\">\n        <app-add-feed-button [feed]=\"feed\" [feedsIds]=\"feedIds\" (updateFeedIds)=\"doUpdateFeedIds()\"></app-add-feed-button>\n      </ion-buttons>\n    </ion-item>\n  </ion-list>\n\n  <!-- Skeleton items (for loading) -->\n  <ion-list *ngIf=\"!trending\">\n    <ion-item *ngFor=\"let skeleton of [1,2,3,4]\">\n      <ion-thumbnail slot=\"start\">\n        <ion-skeleton-text animated></ion-skeleton-text>\n      </ion-thumbnail>\n      <ion-label>\n        <h3>\n          <ion-skeleton-text animated style=\"width: 50%\"></ion-skeleton-text>\n        </h3>\n        <p>\n          <ion-skeleton-text animated style=\"width: 80%\"></ion-skeleton-text>\n        </p>\n        <p>\n          <ion-skeleton-text animated style=\"width: 60%\"></ion-skeleton-text>\n        </p>\n      </ion-label>\n    </ion-item>\n  </ion-list>\n</div>\n";

/***/ }),

/***/ 49779:
/*!************************************************************************************************************!*\
  !*** ./src/app/pages/main/pages/search/components/search-results/search-results.component.html?ngResource ***!
  \************************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<div class=\"w-full mb-14\">\n  <ion-list>\n    <ion-item *ngFor=\"let searchResult of searchResults\" lines=\"full\">\n      <ion-thumbnail slot=\"start\">\n        <img [src]=\"searchResult.visualUrl ?? searchResult.iconUrl\">\n        <ion-skeleton-text *ngIf=\"!searchResult.visualUrl && !searchResult.iconUrl\"></ion-skeleton-text>\n      </ion-thumbnail>\n      <ion-label>\n        <h2>{{searchResult.title}}</h2>\n        <p>{{searchResult.description}}</p>\n      </ion-label>\n      <ion-buttons slot=\"end\">\n        <app-add-feed-button [feed]=\"searchResult\" [feedsIds]=\"feedIds\" (updateFeedIds)=\"doUpdateFeedIds()\"></app-add-feed-button>\n      </ion-buttons>\n    </ion-item>\n  </ion-list>\n\n\n  <!-- Skeleton content -->\n  <ion-list *ngIf=\"!searchResults\">\n    <ion-item *ngFor=\"let skeleton of [1,2,3,4,5]\">\n      <ion-thumbnail slot=\"start\">\n        <ion-skeleton-text animated></ion-skeleton-text>\n      </ion-thumbnail>\n      <ion-label>\n        <h3>\n          <ion-skeleton-text animated style=\"width: 50%\"></ion-skeleton-text>\n        </h3>\n        <p>\n          <ion-skeleton-text animated style=\"width: 80%\"></ion-skeleton-text>\n        </p>\n        <p>\n          <ion-skeleton-text animated style=\"width: 60%\"></ion-skeleton-text>\n        </p>\n      </ion-label>\n    </ion-item>\n  </ion-list>\n\n\n  <!-- No results -->\n  <div class=\"w-full\"\n    *ngIf=\"searchResults && searchResults.length === 0\">\n    <div class=\"mt-20 px-10 w-full flex items-center justify-center\">\n      <div class=\"w-fit h-fit\">\n        <img src=\"assets/images/undraw_search.svg\" class=\"w-1/2 m-auto\">\n        <div class=\"text-center mt-10\">\n          <p class=\"text-xl font-semibold\">No results</p>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>";

/***/ }),

/***/ 69872:
/*!*********************************************************************!*\
  !*** ./src/app/pages/main/pages/search/search.page.html?ngResource ***!
  \*********************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar class=\"main-toolbar\">\n    <ion-title>\n      <span class=\"font-bold text-white drop-shadow-sm\">Discover</span>\n    </ion-title>\n  </ion-toolbar>\n  <ion-toolbar class=\"main-toolbar h-20 flex items-center justify-center\">\n    <!-- Custom searchbar -->\n    <div class=\"w-full px-3\">\n      <div class=\"bg-slate-700 w-full h-14 rounded-lg text-white\">\n        <div class=\"h-full w-10 absolute left-5 top-0\">\n          <div class=\"h-full w-full flex items-center justify-center text-2xl hover:bg-slate-800 rounded-full\" *ngIf=\"!query\">\n            <ion-icon name=\"search\"></ion-icon>\n          </div>\n          <div class=\"h-full w-full flex items-center justify-center text-2xl hover:bg-slate-800 rounded-full\" *ngIf=\"query\"\n          (click)=\"searchQuery$.next(null);query=null\">\n            <ion-icon name=\"close\"></ion-icon>\n          </div>\n        </div>\n        <div class=\"h-full w-full pl-14 pr-5\">\n          <input\n          type=\"text\"\n          class=\"w-full h-full bg-transparent outline-none placeholder-white\" \n          placeholder=\"Search feeds\"\n          [value]=\"query??null\"\n          (input)=\"updateSearchQuery($event)\">\n        </div>\n      </div>\n    </div>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  \n  <!-- Search results -->\n  <ng-container *ngIf=\"query\">\n    <app-search-results [feedIds]=\"feedIds\" [searchQuery]=\"query\" (updateFeedIds)=\"getExistingFeedIds()\"></app-search-results>\n  </ng-container>\n\n  <!-- Discover content -->\n  <ng-container *ngIf=\"!query\">\n    <app-discover [feedIds]=\"feedIds\" (updateFeedIds)=\"getExistingFeedIds()\"></app-discover>\n  </ng-container>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_pages_main_pages_search_search_module_ts.js.map