"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["node_modules_capacitor-community_http_dist_esm_web_js"],{

/***/ 8021:
/*!*******************************************************************!*\
  !*** ./node_modules/@capacitor-community/http/dist/esm/cookie.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearCookies": () => (/* binding */ clearCookies),
/* harmony export */   "deleteCookie": () => (/* binding */ deleteCookie),
/* harmony export */   "getCookie": () => (/* binding */ getCookie),
/* harmony export */   "getCookies": () => (/* binding */ getCookies),
/* harmony export */   "setCookie": () => (/* binding */ setCookie)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ 1829);

/**
 * Set a cookie
 * @param key The key to set
 * @param value The value to set
 * @param options Optional additional parameters
 */
const setCookie = (key, value, options = {}) => {
  // Safely Encoded Key/Value
  const encodedKey = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.encode)(key);
  const encodedValue = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.encode)(value);
  // Clean & sanitize options
  const expires = `; expires=${(options.expires || '').replace('expires=', '')}`; // Default is "; expires="
  const path = (options.path || '/').replace('path=', ''); // Default is "path=/"
  document.cookie = `${encodedKey}=${encodedValue || ''}${expires}; path=${path}`;
};
/**
 * Gets all HttpCookies
 */
const getCookies = () => {
  const output = [];
  const map = {};
  if (!document.cookie) {
    return output;
  }
  const cookies = document.cookie.split(';') || [];
  for (const cookie of cookies) {
    // Replace first "=" with CAP_COOKIE to prevent splitting on additional "="
    let [k, v] = cookie.replace(/=/, 'CAP_COOKIE').split('CAP_COOKIE');
    k = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.decode)(k).trim();
    v = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.decode)(v).trim();
    map[k] = v;
  }
  const entries = Object.entries(map);
  for (const [key, value] of entries) {
    output.push({
      key,
      value
    });
  }
  return output;
};
/**
 * Gets a single HttpCookie given a key
 */
const getCookie = key => {
  const cookies = getCookies();
  for (const cookie of cookies) {
    if (cookie.key === key) {
      return cookie;
    }
  }
  return {
    key,
    value: ''
  };
};
/**
 * Deletes a cookie given a key
 * @param key The key of the cookie to delete
 */
const deleteCookie = key => {
  document.cookie = `${key}=; Max-Age=0`;
};
/**
 * Clears out cookies by setting them to expire immediately
 */
const clearCookies = () => {
  const cookies = document.cookie.split(';') || [];
  for (const cookie of cookies) {
    document.cookie = cookie.replace(/^ +/, '').replace(/=.*/, `=;expires=${new Date().toUTCString()};path=/`);
  }
};

/***/ }),

/***/ 69313:
/*!********************************************************************!*\
  !*** ./node_modules/@capacitor-community/http/dist/esm/request.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "buildRequestInit": () => (/* binding */ buildRequestInit),
/* harmony export */   "del": () => (/* binding */ del),
/* harmony export */   "get": () => (/* binding */ get),
/* harmony export */   "patch": () => (/* binding */ patch),
/* harmony export */   "post": () => (/* binding */ post),
/* harmony export */   "put": () => (/* binding */ put),
/* harmony export */   "request": () => (/* binding */ request)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ 1829);


/**
 * Normalize an HttpHeaders map by lowercasing all of the values
 * @param headers The HttpHeaders object to normalize
 */
const normalizeHttpHeaders = (headers = {}) => {
  const originalKeys = Object.keys(headers);
  const loweredKeys = Object.keys(headers).map(k => k.toLocaleLowerCase());
  const normalized = loweredKeys.reduce((acc, key, index) => {
    acc[key] = headers[originalKeys[index]];
    return acc;
  }, {});
  return normalized;
};
/**
 * Builds a string of url parameters that
 * @param params A map of url parameters
 * @param shouldEncode true if you should encodeURIComponent() the values (true by default)
 */
const buildUrlParams = (params, shouldEncode = true) => {
  if (!params) return null;
  const output = Object.entries(params).reduce((accumulator, entry) => {
    const [key, value] = entry;
    let encodedValue;
    let item;
    if (Array.isArray(value)) {
      item = '';
      value.forEach(str => {
        encodedValue = shouldEncode ? encodeURIComponent(str) : str;
        item += `${key}=${encodedValue}&`;
      });
      // last character will always be "&" so slice it off
      item.slice(0, -1);
    } else {
      encodedValue = shouldEncode ? encodeURIComponent(value) : value;
      item = `${key}=${encodedValue}`;
    }
    return `${accumulator}&${item}`;
  }, '');
  // Remove initial "&" from the reduce
  return output.substr(1);
};
/**
 * Build the RequestInit object based on the options passed into the initial request
 * @param options The Http plugin options
 * @param extra Any extra RequestInit values
 */
const buildRequestInit = (options, extra = {}) => {
  const output = Object.assign({
    method: options.method || 'GET',
    headers: options.headers
  }, extra);
  // Get the content-type
  const headers = normalizeHttpHeaders(options.headers);
  const type = headers['content-type'] || '';
  // If body is already a string, then pass it through as-is.
  if (typeof options.data === 'string') {
    output.body = options.data;
  }
  // Build request initializers based off of content-type
  else if (type.includes('application/x-www-form-urlencoded')) {
    const params = new URLSearchParams();
    for (const [key, value] of Object.entries(options.data || {})) {
      params.set(key, value);
    }
    output.body = params.toString();
  } else if (type.includes('multipart/form-data')) {
    const form = new FormData();
    if (options.data instanceof FormData) {
      options.data.forEach((value, key) => {
        form.append(key, value);
      });
    } else {
      for (let key of Object.keys(options.data)) {
        form.append(key, options.data[key]);
      }
    }
    output.body = form;
    const headers = new Headers(output.headers);
    headers.delete('content-type'); // content-type will be set by `window.fetch` to includy boundary
    output.headers = headers;
  } else if (type.includes('application/json') || typeof options.data === 'object') {
    output.body = JSON.stringify(options.data);
  }
  return output;
};
/**
 * Perform an Http request given a set of options
 * @param options Options to build the HTTP request
 */
const request = /*#__PURE__*/function () {
  var _ref = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    const requestInit = buildRequestInit(options, options.webFetchExtra);
    const urlParams = buildUrlParams(options.params, options.shouldEncodeUrlParams);
    const url = urlParams ? `${options.url}?${urlParams}` : options.url;
    const response = yield fetch(url, requestInit);
    const contentType = response.headers.get('content-type') || '';
    // Default to 'text' responseType so no parsing happens
    let {
      responseType = 'text'
    } = response.ok ? options : {};
    // If the response content-type is json, force the response to be json
    if (contentType.includes('application/json')) {
      responseType = 'json';
    }
    let data;
    switch (responseType) {
      case 'arraybuffer':
      case 'blob':
        const blob = yield response.blob();
        data = yield (0,_utils__WEBPACK_IMPORTED_MODULE_1__.readBlobAsBase64)(blob);
        break;
      case 'json':
        data = yield response.json();
        break;
      case 'document':
      case 'text':
      default:
        data = yield response.text();
    }
    // Convert fetch headers to Capacitor HttpHeaders
    const headers = {};
    response.headers.forEach((value, key) => {
      headers[key] = value;
    });
    return {
      data,
      headers,
      status: response.status,
      url: response.url
    };
  });
  return function request(_x) {
    return _ref.apply(this, arguments);
  };
}();
/**
 * Perform an Http GET request given a set of options
 * @param options Options to build the HTTP request
 */
const get = /*#__PURE__*/function () {
  var _ref2 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    return request(Object.assign(Object.assign({}, options), {
      method: 'GET'
    }));
  });
  return function get(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
/**
 * Perform an Http POST request given a set of options
 * @param options Options to build the HTTP request
 */
const post = /*#__PURE__*/function () {
  var _ref3 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    return request(Object.assign(Object.assign({}, options), {
      method: 'POST'
    }));
  });
  return function post(_x3) {
    return _ref3.apply(this, arguments);
  };
}();
/**
 * Perform an Http PUT request given a set of options
 * @param options Options to build the HTTP request
 */
const put = /*#__PURE__*/function () {
  var _ref4 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    return request(Object.assign(Object.assign({}, options), {
      method: 'PUT'
    }));
  });
  return function put(_x4) {
    return _ref4.apply(this, arguments);
  };
}();
/**
 * Perform an Http PATCH request given a set of options
 * @param options Options to build the HTTP request
 */
const patch = /*#__PURE__*/function () {
  var _ref5 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    return request(Object.assign(Object.assign({}, options), {
      method: 'PATCH'
    }));
  });
  return function patch(_x5) {
    return _ref5.apply(this, arguments);
  };
}();
/**
 * Perform an Http DELETE request given a set of options
 * @param options Options to build the HTTP request
 */
const del = /*#__PURE__*/function () {
  var _ref6 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
    return request(Object.assign(Object.assign({}, options), {
      method: 'DELETE'
    }));
  });
  return function del(_x6) {
    return _ref6.apply(this, arguments);
  };
}();

/***/ }),

/***/ 1829:
/*!******************************************************************!*\
  !*** ./node_modules/@capacitor-community/http/dist/esm/utils.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "decode": () => (/* binding */ decode),
/* harmony export */   "encode": () => (/* binding */ encode),
/* harmony export */   "readBlobAsBase64": () => (/* binding */ readBlobAsBase64)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);

/**
 * Read in a Blob value and return it as a base64 string
 * @param blob The blob value to convert to a base64 string
 */
const readBlobAsBase64 = /*#__PURE__*/function () {
  var _ref = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (blob) {
    return new Promise((resolve, reject) => {
      const reader = new FileReader();
      reader.onload = () => {
        const base64String = reader.result;
        const base64StringWithoutTags = base64String.substr(base64String.indexOf(',') + 1); // remove prefix "data:application/pdf;base64,"
        resolve(base64StringWithoutTags);
      };
      reader.onerror = error => reject(error);
      reader.readAsDataURL(blob);
    });
  });
  return function readBlobAsBase64(_x) {
    return _ref.apply(this, arguments);
  };
}();
/**
 * Safely web encode a string value (inspired by js-cookie)
 * @param str The string value to encode
 */
const encode = str => encodeURIComponent(str).replace(/%(2[346B]|5E|60|7C)/g, decodeURIComponent).replace(/[()]/g, escape);
/**
 * Safely web decode a string value (inspired by js-cookie)
 * @param str The string value to decode
 */
const decode = str => str.replace(/(%[\dA-F]{2})+/gi, decodeURIComponent);

/***/ }),

/***/ 82575:
/*!****************************************************************!*\
  !*** ./node_modules/@capacitor-community/http/dist/esm/web.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HttpWeb": () => (/* binding */ HttpWeb)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var _capacitor_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/core */ 97123);
/* harmony import */ var _cookie__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./cookie */ 8021);
/* harmony import */ var _request__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./request */ 69313);




class HttpWeb extends _capacitor_core__WEBPACK_IMPORTED_MODULE_1__.WebPlugin {
  constructor() {
    var _this;
    super();
    _this = this;
    /**
     * Perform an Http request given a set of options
     * @param options Options to build the HTTP request
     */
    this.request = /*#__PURE__*/function () {
      var _ref = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.request(options);
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }();
    /**
     * Perform an Http GET request given a set of options
     * @param options Options to build the HTTP request
     */
    this.get = /*#__PURE__*/function () {
      var _ref2 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.get(options);
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }();
    /**
     * Perform an Http POST request given a set of options
     * @param options Options to build the HTTP request
     */
    this.post = /*#__PURE__*/function () {
      var _ref3 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.post(options);
      });
      return function (_x3) {
        return _ref3.apply(this, arguments);
      };
    }();
    /**
     * Perform an Http PUT request given a set of options
     * @param options Options to build the HTTP request
     */
    this.put = /*#__PURE__*/function () {
      var _ref4 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.put(options);
      });
      return function (_x4) {
        return _ref4.apply(this, arguments);
      };
    }();
    /**
     * Perform an Http PATCH request given a set of options
     * @param options Options to build the HTTP request
     */
    this.patch = /*#__PURE__*/function () {
      var _ref5 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.patch(options);
      });
      return function (_x5) {
        return _ref5.apply(this, arguments);
      };
    }();
    /**
     * Perform an Http DELETE request given a set of options
     * @param options Options to build the HTTP request
     */
    this.del = /*#__PURE__*/function () {
      var _ref6 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _request__WEBPACK_IMPORTED_MODULE_3__.del(options);
      });
      return function (_x6) {
        return _ref6.apply(this, arguments);
      };
    }();
    /**
     * Gets all HttpCookies as a Map
     */
    this.getCookiesMap = /*#__PURE__*/function () {
      var _ref7 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (
      // @ts-ignore
      options) {
        const cookies = _cookie__WEBPACK_IMPORTED_MODULE_2__.getCookies();
        const output = {};
        for (const cookie of cookies) {
          output[cookie.key] = cookie.value;
        }
        return output;
      });
      return function (_x7) {
        return _ref7.apply(this, arguments);
      };
    }();
    /**
     * Get all HttpCookies as an object with the values as an HttpCookie[]
     */
    this.getCookies = /*#__PURE__*/function () {
      var _ref8 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        // @ts-ignore
        const {
          url
        } = options;
        const cookies = _cookie__WEBPACK_IMPORTED_MODULE_2__.getCookies();
        return {
          cookies
        };
      });
      return function (_x8) {
        return _ref8.apply(this, arguments);
      };
    }();
    /**
     * Set a cookie
     * @param key The key to set
     * @param value The value to set
     * @param options Optional additional parameters
     */
    this.setCookie = /*#__PURE__*/function () {
      var _ref9 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        const {
          key,
          value,
          expires = '',
          path = ''
        } = options;
        _cookie__WEBPACK_IMPORTED_MODULE_2__.setCookie(key, value, {
          expires,
          path
        });
      });
      return function (_x9) {
        return _ref9.apply(this, arguments);
      };
    }();
    /**
     * Gets all cookie values unless a key is specified, then return only that value
     * @param key The key of the cookie value to get
     */
    this.getCookie = /*#__PURE__*/function () {
      var _ref10 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _cookie__WEBPACK_IMPORTED_MODULE_2__.getCookie(options.key);
      });
      return function (_x10) {
        return _ref10.apply(this, arguments);
      };
    }();
    /**
     * Deletes a cookie given a key
     * @param key The key of the cookie to delete
     */
    this.deleteCookie = /*#__PURE__*/function () {
      var _ref11 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        return _cookie__WEBPACK_IMPORTED_MODULE_2__.deleteCookie(options.key);
      });
      return function (_x11) {
        return _ref11.apply(this, arguments);
      };
    }();
    /**
     * Clears out cookies by setting them to expire immediately
     */
    this.clearCookies = /*#__PURE__*/function () {
      var _ref12 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (
      // @ts-ignore
      options) {
        return _cookie__WEBPACK_IMPORTED_MODULE_2__.clearCookies();
      });
      return function (_x12) {
        return _ref12.apply(this, arguments);
      };
    }();
    /**
     * Clears out cookies by setting them to expire immediately
     */
    this.clearAllCookies = /*#__PURE__*/(0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      return _cookie__WEBPACK_IMPORTED_MODULE_2__.clearCookies();
    });
    /**
     * Uploads a file through a POST request
     * @param options TODO
     */
    this.uploadFile = /*#__PURE__*/function () {
      var _ref14 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        const formData = new FormData();
        formData.append(options.name, options.blob || 'undefined');
        const fetchOptions = Object.assign(Object.assign({}, options), {
          body: formData,
          method: 'POST'
        });
        return _this.post(fetchOptions);
      });
      return function (_x13) {
        return _ref14.apply(this, arguments);
      };
    }();
    /**
     * Downloads a file
     * @param options TODO
     */
    this.downloadFile = /*#__PURE__*/function () {
      var _ref15 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (options) {
        const requestInit = _request__WEBPACK_IMPORTED_MODULE_3__.buildRequestInit(options, options.webFetchExtra);
        const response = yield fetch(options.url, requestInit);
        let blob;
        if (!(options === null || options === void 0 ? void 0 : options.progress)) blob = yield response.blob();else if (!(response === null || response === void 0 ? void 0 : response.body)) blob = new Blob();else {
          const reader = response.body.getReader();
          let bytes = 0;
          let chunks = [];
          const contentType = response.headers.get('content-type');
          const contentLength = parseInt(response.headers.get('content-length') || '0', 10);
          while (true) {
            const {
              done,
              value
            } = yield reader.read();
            if (done) break;
            chunks.push(value);
            bytes += (value === null || value === void 0 ? void 0 : value.length) || 0;
            const status = {
              type: 'DOWNLOAD',
              url: options.url,
              bytes,
              contentLength
            };
            _this.notifyListeners('progress', status);
          }
          let allChunks = new Uint8Array(bytes);
          let position = 0;
          for (const chunk of chunks) {
            if (typeof chunk === 'undefined') continue;
            allChunks.set(chunk, position);
            position += chunk.length;
          }
          blob = new Blob([allChunks.buffer], {
            type: contentType || undefined
          });
        }
        return {
          blob
        };
      });
      return function (_x14) {
        return _ref15.apply(this, arguments);
      };
    }();
  }
}

/***/ })

}]);
//# sourceMappingURL=node_modules_capacitor-community_http_dist_esm_web_js.js.map