(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["main"],{

/***/ 90158:
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppRoutingModule": () => (/* binding */ AppRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var _guards_intro_intro_guard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./guards/intro/intro.guard */ 21585);




const routes = [{
  path: '',
  redirectTo: 'main',
  pathMatch: 'full'
}, {
  path: 'main',
  loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_pages_main_main_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./pages/main/main.module */ 79582)).then(m => m.MainPageModule),
  canActivate: [_guards_intro_intro_guard__WEBPACK_IMPORTED_MODULE_0__.IntroGuard]
}, {
  path: 'entry',
  loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("default-src_app_components_components_module_ts"), __webpack_require__.e("default-src_app_services_feedly_feedly_service_ts"), __webpack_require__.e("common"), __webpack_require__.e("src_app_pages_entry_entry_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/entry/entry.module */ 84218)).then(m => m.EntryPageModule)
}, {
  path: 'collections',
  loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("default-src_app_components_components_module_ts"), __webpack_require__.e("src_app_pages_collections_collections_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/collections/collections.module */ 45997)).then(m => m.CollectionsPageModule)
}, {
  path: 'intro',
  loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("default-node_modules_swiper_angular_fesm2015_swiper_angular_mjs"), __webpack_require__.e("src_app_pages_intro_intro_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./pages/intro/intro.module */ 88557)).then(m => m.IntroPageModule)
}];
let AppRoutingModule = class AppRoutingModule {};
AppRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
  imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forRoot(routes, {
    preloadingStrategy: _angular_router__WEBPACK_IMPORTED_MODULE_3__.PreloadAllModules
  })],
  exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule]
})], AppRoutingModule);


/***/ }),

/***/ 55041:
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppComponent": () => (/* binding */ AppComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app.component.html?ngResource */ 33383);
/* harmony import */ var _app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app.component.scss?ngResource */ 79595);
/* harmony import */ var _app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./services/storage/storage.service */ 86578);

var _class;





let AppComponent = (_class = class AppComponent {
  constructor(storageService) {
    this.storageService = storageService;
  }
  ngOnInit() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      yield _this.storageService.initialize();
      const settings = yield _this.storageService.getSettings();
      if (settings.theme === 'dark') {
        document.body.classList.add('dark');
      }
    })();
  }
}, _class.ctorParameters = () => [{
  type: _services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}], _class);
AppComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
  selector: 'app-root',
  template: _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AppComponent);


/***/ }),

/***/ 36747:
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppModule": () => (/* binding */ AppModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/platform-browser */ 34497);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app.component */ 55041);
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app-routing.module */ 90158);







let AppModule = class AppModule {};
AppModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
  declarations: [_app_component__WEBPACK_IMPORTED_MODULE_0__.AppComponent],
  imports: [_angular_platform_browser__WEBPACK_IMPORTED_MODULE_4__.BrowserModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.IonicModule.forRoot(), _app_routing_module__WEBPACK_IMPORTED_MODULE_1__.AppRoutingModule],
  providers: [{
    provide: _angular_router__WEBPACK_IMPORTED_MODULE_6__.RouteReuseStrategy,
    useClass: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.IonicRouteStrategy
  }],
  bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_0__.AppComponent]
})], AppModule);


/***/ }),

/***/ 21585:
/*!*********************************************!*\
  !*** ./src/app/guards/intro/intro.guard.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "IntroGuard": () => (/* binding */ IntroGuard)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);
var _class;




let IntroGuard = (_class = class IntroGuard {
  constructor(storageService, router) {
    this.storageService = storageService;
    this.router = router;
  }
  canActivate(route, state) {
    return new Promise(resolve => {
      this.storageService.getSettings().then(settings => {
        if (settings.introVersion && settings.introVersion >= 1) {
          resolve(true);
        } else {
          resolve(this.router.createUrlTree(['/intro']));
        }
      });
    });
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_0__.StorageService
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_1__.Router
}], _class);
IntroGuard = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
  providedIn: 'root'
})], IntroGuard);


/***/ }),

/***/ 86578:
/*!*****************************************************!*\
  !*** ./src/app/services/storage/storage.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StorageService": () => (/* binding */ StorageService)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @capacitor/preferences */ 85191);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! uuid */ 62535);

var _class;





let StorageService = (_class = class StorageService {
  constructor() {}
  initialize() {
    return new Promise( /*#__PURE__*/function () {
      var _ref = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        console.log('Initializing storage...');
        const settings = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'settings'
        });
        if (!settings.value) yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'settings',
          value: JSON.stringify({
            theme: 'light',
            cacheTimeout: 3600,
            collectionLastReloads: []
          })
        });
        const collections = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'collections'
        });
        if (!collections.value) {
          const defaultCollection = {
            id: (0,uuid__WEBPACK_IMPORTED_MODULE_3__["default"])(),
            name: 'Home',
            feedList: [],
            index: 0
          };
          yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
            key: 'collections',
            value: JSON.stringify([defaultCollection])
          });
        }
        const readEntries = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'readEntries'
        });
        if (!readEntries.value) yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'readEntries',
          value: JSON.stringify([])
        });
        const bookmarks = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'bookmarks'
        });
        if (!bookmarks.value) yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'bookmarks',
          value: JSON.stringify([])
        });
        resolve(true);
      });
      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());
  }
  getSettings() {
    return new Promise( /*#__PURE__*/function () {
      var _ref2 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const settings = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'settings'
        });
        resolve(JSON.parse(settings.value));
      });
      return function (_x2) {
        return _ref2.apply(this, arguments);
      };
    }());
  }
  setSettings(settings) {
    return new Promise( /*#__PURE__*/function () {
      var _ref3 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'settings',
          value: JSON.stringify(settings)
        });
        resolve(settings);
      });
      return function (_x3) {
        return _ref3.apply(this, arguments);
      };
    }());
  }
  getCollections() {
    return new Promise( /*#__PURE__*/function () {
      var _ref4 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'collections'
        });
        resolve(JSON.parse(collections.value));
      });
      return function (_x4) {
        return _ref4.apply(this, arguments);
      };
    }());
  }
  getCollectionByFeedId(feedId) {
    var _this = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref5 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _this.getCollections();
        const collection = collections.find(collection => collection.feedList.some(feedIdItem => feedIdItem.feedId === feedId));
        resolve(collection);
      });
      return function (_x5) {
        return _ref5.apply(this, arguments);
      };
    }());
  }
  setCollections(collections) {
    return new Promise( /*#__PURE__*/function () {
      var _ref6 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'collections',
          value: JSON.stringify(collections)
        });
        resolve(collections);
      });
      return function (_x6) {
        return _ref6.apply(this, arguments);
      };
    }());
  }
  addCollection(collection) {
    var _this2 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref7 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _this2.getCollections();
        collections.push(collection);
        yield _this2.setCollections(collections);
        resolve(collection);
      });
      return function (_x7) {
        return _ref7.apply(this, arguments);
      };
    }());
  }
  updateCollection(collection) {
    var _this3 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref8 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _this3.getCollections();
        const index = collections.findIndex(item => item.id === collection.id);
        collections[index] = collection;
        yield _this3.setCollections(collections);
        resolve(collection);
      });
      return function (_x8) {
        return _ref8.apply(this, arguments);
      };
    }());
  }
  deleteCollection(collection) {
    var _this4 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref9 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _this4.getCollections();
        const index = collections.findIndex(item => item.id === collection.id);
        collections.splice(index, 1);
        yield _this4.setCollections(collections);
        resolve(collection);
      });
      return function (_x9) {
        return _ref9.apply(this, arguments);
      };
    }());
  }
  getAllFeedIds() {
    var _this5 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref10 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const collections = yield _this5.getCollections();
        const feedIds = [];
        collections.forEach(collection => {
          collection.feedList.forEach(collectionFeed => {
            if (!feedIds.includes(collectionFeed.feedId)) feedIds.push(collectionFeed.feedId);
          });
        });
        resolve(feedIds);
      });
      return function (_x10) {
        return _ref10.apply(this, arguments);
      };
    }());
  }
  getCacheByFeedId(feedId) {
    return new Promise( /*#__PURE__*/function () {
      var _ref11 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const feedCache = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: `cache_${feedId}`
        });
        resolve(JSON.parse(feedCache.value));
      });
      return function (_x11) {
        return _ref11.apply(this, arguments);
      };
    }());
  }
  setCacheByFeedId(feedId, content) {
    return new Promise( /*#__PURE__*/function () {
      var _ref12 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const cache = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: `cache_${feedId}`
        });
        let cacheItem = JSON.parse(cache.value);
        // If cache is empty, create new cache item
        if (!cacheItem) {
          cacheItem = {
            feedId,
            fetchedAt: moment__WEBPACK_IMPORTED_MODULE_2__().unix(),
            content
          };
        } else {
          // If cache is not empty, update cache item
          cacheItem.content = content;
          cacheItem.fetchedAt = moment__WEBPACK_IMPORTED_MODULE_2__().unix();
        }
        // Save cache item
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: `cache_${feedId}`,
          value: JSON.stringify(cacheItem)
        });
        resolve(cacheItem);
      });
      return function (_x12) {
        return _ref12.apply(this, arguments);
      };
    }());
  }
  deleteCacheByFeedId(feedId) {
    return new Promise( /*#__PURE__*/function () {
      var _ref13 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.remove({
          key: `cache_${feedId}`
        });
        resolve(true);
      });
      return function (_x13) {
        return _ref13.apply(this, arguments);
      };
    }());
  }
  deleteCache() {
    return new Promise( /*#__PURE__*/function () {
      var _ref14 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'cache',
          value: JSON.stringify([])
        });
        resolve(true);
      });
      return function (_x14) {
        return _ref14.apply(this, arguments);
      };
    }());
  }
  getReadEntries() {
    return new Promise( /*#__PURE__*/function () {
      var _ref15 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const readEntries = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'readEntries'
        });
        resolve(JSON.parse(readEntries.value));
      });
      return function (_x15) {
        return _ref15.apply(this, arguments);
      };
    }());
  }
  setReadEntries(readEntries) {
    return new Promise( /*#__PURE__*/function () {
      var _ref16 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'readEntries',
          value: JSON.stringify(readEntries)
        });
        resolve(readEntries);
      });
      return function (_x16) {
        return _ref16.apply(this, arguments);
      };
    }());
  }
  addReadEntry(entryId) {
    var _this6 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref17 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const readEntries = yield _this6.getReadEntries();
        if (!readEntries.includes(entryId)) {
          // Add entry
          readEntries.push(entryId);
          // If readEntries is more than 100, remove the oldest entry
          if (readEntries.length > 100) readEntries.shift();
          yield _this6.setReadEntries(readEntries);
        }
        resolve(readEntries);
      });
      return function (_x17) {
        return _ref17.apply(this, arguments);
      };
    }());
  }
  setBookmarks(bookmarks) {
    return new Promise( /*#__PURE__*/function () {
      var _ref18 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.set({
          key: 'bookmarks',
          value: JSON.stringify(bookmarks)
        });
        resolve(bookmarks);
      });
      return function (_x18) {
        return _ref18.apply(this, arguments);
      };
    }());
  }
  getBookmarks() {
    return new Promise( /*#__PURE__*/function () {
      var _ref19 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const bookmarks = yield _capacitor_preferences__WEBPACK_IMPORTED_MODULE_1__.Preferences.get({
          key: 'bookmarks'
        });
        resolve(JSON.parse(bookmarks.value));
      });
      return function (_x19) {
        return _ref19.apply(this, arguments);
      };
    }());
  }
  addBookmark(bookmark) {
    var _this7 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref20 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const bookmarks = yield _this7.getBookmarks();
        bookmarks.push(bookmark);
        // If bookmarks is more than 100, remove the oldest bookmark
        if (bookmarks.length > 100) bookmarks.shift();
        yield _this7.setBookmarks(bookmarks);
        resolve(bookmark);
      });
      return function (_x20) {
        return _ref20.apply(this, arguments);
      };
    }());
  }
  deleteBookmark(bookmark) {
    var _this8 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref21 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const bookmarks = yield _this8.getBookmarks();
        const index = bookmarks.findIndex(item => item.entryId === bookmark.entryId);
        bookmarks.splice(index, 1);
        yield _this8.setBookmarks(bookmarks);
        resolve(bookmark);
      });
      return function (_x21) {
        return _ref21.apply(this, arguments);
      };
    }());
  }
  deleteBookmarkByEntryId(entryId) {
    var _this9 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref22 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const bookmarks = yield _this9.getBookmarks();
        const index = bookmarks.findIndex(item => item.entryId === entryId);
        bookmarks.splice(index, 1);
        yield _this9.setBookmarks(bookmarks);
        resolve(bookmarks[index]);
      });
      return function (_x22) {
        return _ref22.apply(this, arguments);
      };
    }());
  }
  bookmarkExists(entryId) {
    var _this10 = this;
    return new Promise( /*#__PURE__*/function () {
      var _ref23 = (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* (resolve) {
        const bookmarks = yield _this10.getBookmarks();
        resolve(bookmarks.findIndex(item => item.entryId === entryId) > -1);
      });
      return function (_x23) {
        return _ref23.apply(this, arguments);
      };
    }());
  }
}, _class.ctorParameters = () => [], _class);
StorageService = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Injectable)({
  providedIn: 'root'
})], StorageService);


/***/ }),

/***/ 92340:
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
  production: false
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.

/***/ }),

/***/ 14431:
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/platform-browser-dynamic */ 76057);
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app/app.module */ 36747);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./environments/environment */ 92340);




if (_environments_environment__WEBPACK_IMPORTED_MODULE_1__.environment.production) {
  (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.enableProdMode)();
}
(0,_angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__.platformBrowserDynamic)().bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_0__.AppModule).catch(err => console.log(err));

/***/ }),

/***/ 50863:
/*!******************************************************************************************************************************************!*\
  !*** ./node_modules/@ionic/core/dist/esm/ lazy ^\.\/.*\.entry\.js$ include: \.entry\.js$ exclude: \.system\.entry\.js$ namespace object ***!
  \******************************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./ion-accordion_2.entry.js": [
		70079,
		"common",
		"node_modules_ionic_core_dist_esm_ion-accordion_2_entry_js"
	],
	"./ion-action-sheet.entry.js": [
		25593,
		"common",
		"node_modules_ionic_core_dist_esm_ion-action-sheet_entry_js"
	],
	"./ion-alert.entry.js": [
		13225,
		"common",
		"node_modules_ionic_core_dist_esm_ion-alert_entry_js"
	],
	"./ion-app_8.entry.js": [
		4812,
		"common",
		"node_modules_ionic_core_dist_esm_ion-app_8_entry_js"
	],
	"./ion-avatar_3.entry.js": [
		86655,
		"node_modules_ionic_core_dist_esm_ion-avatar_3_entry_js"
	],
	"./ion-back-button.entry.js": [
		44856,
		"common",
		"node_modules_ionic_core_dist_esm_ion-back-button_entry_js"
	],
	"./ion-backdrop.entry.js": [
		13059,
		"node_modules_ionic_core_dist_esm_ion-backdrop_entry_js"
	],
	"./ion-breadcrumb_2.entry.js": [
		58648,
		"common",
		"node_modules_ionic_core_dist_esm_ion-breadcrumb_2_entry_js"
	],
	"./ion-button_2.entry.js": [
		98308,
		"node_modules_ionic_core_dist_esm_ion-button_2_entry_js"
	],
	"./ion-card_5.entry.js": [
		44690,
		"node_modules_ionic_core_dist_esm_ion-card_5_entry_js"
	],
	"./ion-checkbox.entry.js": [
		64090,
		"node_modules_ionic_core_dist_esm_ion-checkbox_entry_js"
	],
	"./ion-chip.entry.js": [
		36214,
		"node_modules_ionic_core_dist_esm_ion-chip_entry_js"
	],
	"./ion-col_3.entry.js": [
		69447,
		"node_modules_ionic_core_dist_esm_ion-col_3_entry_js"
	],
	"./ion-datetime-button.entry.js": [
		17950,
		"default-node_modules_ionic_core_dist_esm_data-caf38df0_js-node_modules_ionic_core_dist_esm_th-d3ab8e",
		"node_modules_ionic_core_dist_esm_ion-datetime-button_entry_js"
	],
	"./ion-datetime_3.entry.js": [
		79689,
		"default-node_modules_ionic_core_dist_esm_data-caf38df0_js-node_modules_ionic_core_dist_esm_th-d3ab8e",
		"common",
		"node_modules_ionic_core_dist_esm_ion-datetime_3_entry_js"
	],
	"./ion-fab_3.entry.js": [
		18840,
		"common",
		"node_modules_ionic_core_dist_esm_ion-fab_3_entry_js"
	],
	"./ion-img.entry.js": [
		40749,
		"node_modules_ionic_core_dist_esm_ion-img_entry_js"
	],
	"./ion-infinite-scroll_2.entry.js": [
		69667,
		"common",
		"node_modules_ionic_core_dist_esm_ion-infinite-scroll_2_entry_js"
	],
	"./ion-input.entry.js": [
		83288,
		"common",
		"node_modules_ionic_core_dist_esm_ion-input_entry_js"
	],
	"./ion-item-option_3.entry.js": [
		35473,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item-option_3_entry_js"
	],
	"./ion-item_8.entry.js": [
		53634,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item_8_entry_js"
	],
	"./ion-loading.entry.js": [
		22855,
		"node_modules_ionic_core_dist_esm_ion-loading_entry_js"
	],
	"./ion-menu_3.entry.js": [
		495,
		"common",
		"node_modules_ionic_core_dist_esm_ion-menu_3_entry_js"
	],
	"./ion-modal.entry.js": [
		58737,
		"common",
		"node_modules_ionic_core_dist_esm_ion-modal_entry_js"
	],
	"./ion-nav_2.entry.js": [
		99632,
		"common",
		"node_modules_ionic_core_dist_esm_ion-nav_2_entry_js"
	],
	"./ion-picker-column-internal.entry.js": [
		54446,
		"common",
		"node_modules_ionic_core_dist_esm_ion-picker-column-internal_entry_js"
	],
	"./ion-picker-internal.entry.js": [
		32275,
		"node_modules_ionic_core_dist_esm_ion-picker-internal_entry_js"
	],
	"./ion-popover.entry.js": [
		48050,
		"common",
		"node_modules_ionic_core_dist_esm_ion-popover_entry_js"
	],
	"./ion-progress-bar.entry.js": [
		18994,
		"node_modules_ionic_core_dist_esm_ion-progress-bar_entry_js"
	],
	"./ion-radio_2.entry.js": [
		23592,
		"node_modules_ionic_core_dist_esm_ion-radio_2_entry_js"
	],
	"./ion-range.entry.js": [
		35454,
		"common",
		"node_modules_ionic_core_dist_esm_ion-range_entry_js"
	],
	"./ion-refresher_2.entry.js": [
		290,
		"common",
		"node_modules_ionic_core_dist_esm_ion-refresher_2_entry_js"
	],
	"./ion-reorder_2.entry.js": [
		92666,
		"common",
		"node_modules_ionic_core_dist_esm_ion-reorder_2_entry_js"
	],
	"./ion-ripple-effect.entry.js": [
		64816,
		"node_modules_ionic_core_dist_esm_ion-ripple-effect_entry_js"
	],
	"./ion-route_4.entry.js": [
		45534,
		"node_modules_ionic_core_dist_esm_ion-route_4_entry_js"
	],
	"./ion-searchbar.entry.js": [
		94902,
		"common",
		"node_modules_ionic_core_dist_esm_ion-searchbar_entry_js"
	],
	"./ion-segment_2.entry.js": [
		91938,
		"common",
		"node_modules_ionic_core_dist_esm_ion-segment_2_entry_js"
	],
	"./ion-select_3.entry.js": [
		78179,
		"node_modules_ionic_core_dist_esm_ion-select_3_entry_js"
	],
	"./ion-slide_2.entry.js": [
		90668,
		"node_modules_ionic_core_dist_esm_ion-slide_2_entry_js"
	],
	"./ion-spinner.entry.js": [
		61624,
		"common",
		"node_modules_ionic_core_dist_esm_ion-spinner_entry_js"
	],
	"./ion-split-pane.entry.js": [
		19989,
		"node_modules_ionic_core_dist_esm_ion-split-pane_entry_js"
	],
	"./ion-tab-bar_2.entry.js": [
		28902,
		"common",
		"node_modules_ionic_core_dist_esm_ion-tab-bar_2_entry_js"
	],
	"./ion-tab_2.entry.js": [
		70199,
		"common",
		"node_modules_ionic_core_dist_esm_ion-tab_2_entry_js"
	],
	"./ion-text.entry.js": [
		48395,
		"node_modules_ionic_core_dist_esm_ion-text_entry_js"
	],
	"./ion-textarea.entry.js": [
		96357,
		"node_modules_ionic_core_dist_esm_ion-textarea_entry_js"
	],
	"./ion-toast.entry.js": [
		38268,
		"node_modules_ionic_core_dist_esm_ion-toast_entry_js"
	],
	"./ion-toggle.entry.js": [
		15269,
		"common",
		"node_modules_ionic_core_dist_esm_ion-toggle_entry_js"
	],
	"./ion-virtual-scroll.entry.js": [
		32875,
		"node_modules_ionic_core_dist_esm_ion-virtual-scroll_entry_js"
	]
};
function webpackAsyncContext(req) {
	if(!__webpack_require__.o(map, req)) {
		return Promise.resolve().then(() => {
			var e = new Error("Cannot find module '" + req + "'");
			e.code = 'MODULE_NOT_FOUND';
			throw e;
		});
	}

	var ids = map[req], id = ids[0];
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(() => {
		return __webpack_require__(id);
	});
}
webpackAsyncContext.keys = () => (Object.keys(map));
webpackAsyncContext.id = 50863;
module.exports = webpackAsyncContext;

/***/ }),

/***/ 79595:
/*!***********************************************!*\
  !*** ./src/app/app.component.scss?ngResource ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "", "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 46700:
/*!***************************************************!*\
  !*** ./node_modules/moment/locale/ sync ^\.\/.*$ ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./af": 58685,
	"./af.js": 58685,
	"./ar": 254,
	"./ar-dz": 4312,
	"./ar-dz.js": 4312,
	"./ar-kw": 32614,
	"./ar-kw.js": 32614,
	"./ar-ly": 18630,
	"./ar-ly.js": 18630,
	"./ar-ma": 28674,
	"./ar-ma.js": 28674,
	"./ar-sa": 49032,
	"./ar-sa.js": 49032,
	"./ar-tn": 24730,
	"./ar-tn.js": 24730,
	"./ar.js": 254,
	"./az": 53052,
	"./az.js": 53052,
	"./be": 60150,
	"./be.js": 60150,
	"./bg": 63069,
	"./bg.js": 63069,
	"./bm": 13466,
	"./bm.js": 13466,
	"./bn": 18516,
	"./bn-bd": 90557,
	"./bn-bd.js": 90557,
	"./bn.js": 18516,
	"./bo": 26273,
	"./bo.js": 26273,
	"./br": 9588,
	"./br.js": 9588,
	"./bs": 19815,
	"./bs.js": 19815,
	"./ca": 83331,
	"./ca.js": 83331,
	"./cs": 21320,
	"./cs.js": 21320,
	"./cv": 72219,
	"./cv.js": 72219,
	"./cy": 68266,
	"./cy.js": 68266,
	"./da": 66427,
	"./da.js": 66427,
	"./de": 67435,
	"./de-at": 52871,
	"./de-at.js": 52871,
	"./de-ch": 12994,
	"./de-ch.js": 12994,
	"./de.js": 67435,
	"./dv": 82357,
	"./dv.js": 82357,
	"./el": 95649,
	"./el.js": 95649,
	"./en-au": 59961,
	"./en-au.js": 59961,
	"./en-ca": 19878,
	"./en-ca.js": 19878,
	"./en-gb": 3924,
	"./en-gb.js": 3924,
	"./en-ie": 70864,
	"./en-ie.js": 70864,
	"./en-il": 91579,
	"./en-il.js": 91579,
	"./en-in": 30940,
	"./en-in.js": 30940,
	"./en-nz": 16181,
	"./en-nz.js": 16181,
	"./en-sg": 44301,
	"./en-sg.js": 44301,
	"./eo": 85291,
	"./eo.js": 85291,
	"./es": 54529,
	"./es-do": 53764,
	"./es-do.js": 53764,
	"./es-mx": 12584,
	"./es-mx.js": 12584,
	"./es-us": 63425,
	"./es-us.js": 63425,
	"./es.js": 54529,
	"./et": 35203,
	"./et.js": 35203,
	"./eu": 70678,
	"./eu.js": 70678,
	"./fa": 83483,
	"./fa.js": 83483,
	"./fi": 96262,
	"./fi.js": 96262,
	"./fil": 52521,
	"./fil.js": 52521,
	"./fo": 34555,
	"./fo.js": 34555,
	"./fr": 63131,
	"./fr-ca": 88239,
	"./fr-ca.js": 88239,
	"./fr-ch": 21702,
	"./fr-ch.js": 21702,
	"./fr.js": 63131,
	"./fy": 267,
	"./fy.js": 267,
	"./ga": 23821,
	"./ga.js": 23821,
	"./gd": 71753,
	"./gd.js": 71753,
	"./gl": 4074,
	"./gl.js": 4074,
	"./gom-deva": 92762,
	"./gom-deva.js": 92762,
	"./gom-latn": 5969,
	"./gom-latn.js": 5969,
	"./gu": 82809,
	"./gu.js": 82809,
	"./he": 45402,
	"./he.js": 45402,
	"./hi": 315,
	"./hi.js": 315,
	"./hr": 10410,
	"./hr.js": 10410,
	"./hu": 38288,
	"./hu.js": 38288,
	"./hy-am": 67928,
	"./hy-am.js": 67928,
	"./id": 71334,
	"./id.js": 71334,
	"./is": 86959,
	"./is.js": 86959,
	"./it": 34864,
	"./it-ch": 51124,
	"./it-ch.js": 51124,
	"./it.js": 34864,
	"./ja": 36141,
	"./ja.js": 36141,
	"./jv": 29187,
	"./jv.js": 29187,
	"./ka": 42136,
	"./ka.js": 42136,
	"./kk": 94332,
	"./kk.js": 94332,
	"./km": 18607,
	"./km.js": 18607,
	"./kn": 84305,
	"./kn.js": 84305,
	"./ko": 70234,
	"./ko.js": 70234,
	"./ku": 16003,
	"./ku.js": 16003,
	"./ky": 75061,
	"./ky.js": 75061,
	"./lb": 32786,
	"./lb.js": 32786,
	"./lo": 66183,
	"./lo.js": 66183,
	"./lt": 50029,
	"./lt.js": 50029,
	"./lv": 24169,
	"./lv.js": 24169,
	"./me": 68577,
	"./me.js": 68577,
	"./mi": 68177,
	"./mi.js": 68177,
	"./mk": 50337,
	"./mk.js": 50337,
	"./ml": 65260,
	"./ml.js": 65260,
	"./mn": 52325,
	"./mn.js": 52325,
	"./mr": 14695,
	"./mr.js": 14695,
	"./ms": 75334,
	"./ms-my": 37151,
	"./ms-my.js": 37151,
	"./ms.js": 75334,
	"./mt": 63570,
	"./mt.js": 63570,
	"./my": 97963,
	"./my.js": 97963,
	"./nb": 88028,
	"./nb.js": 88028,
	"./ne": 86638,
	"./ne.js": 86638,
	"./nl": 50302,
	"./nl-be": 66782,
	"./nl-be.js": 66782,
	"./nl.js": 50302,
	"./nn": 33501,
	"./nn.js": 33501,
	"./oc-lnc": 50563,
	"./oc-lnc.js": 50563,
	"./pa-in": 50869,
	"./pa-in.js": 50869,
	"./pl": 65302,
	"./pl.js": 65302,
	"./pt": 49687,
	"./pt-br": 74884,
	"./pt-br.js": 74884,
	"./pt.js": 49687,
	"./ro": 79107,
	"./ro.js": 79107,
	"./ru": 33627,
	"./ru.js": 33627,
	"./sd": 30355,
	"./sd.js": 30355,
	"./se": 83427,
	"./se.js": 83427,
	"./si": 11848,
	"./si.js": 11848,
	"./sk": 54590,
	"./sk.js": 54590,
	"./sl": 20184,
	"./sl.js": 20184,
	"./sq": 56361,
	"./sq.js": 56361,
	"./sr": 78965,
	"./sr-cyrl": 81287,
	"./sr-cyrl.js": 81287,
	"./sr.js": 78965,
	"./ss": 25456,
	"./ss.js": 25456,
	"./sv": 70451,
	"./sv.js": 70451,
	"./sw": 77558,
	"./sw.js": 77558,
	"./ta": 51356,
	"./ta.js": 51356,
	"./te": 73693,
	"./te.js": 73693,
	"./tet": 21243,
	"./tet.js": 21243,
	"./tg": 42500,
	"./tg.js": 42500,
	"./th": 55768,
	"./th.js": 55768,
	"./tk": 77761,
	"./tk.js": 77761,
	"./tl-ph": 35780,
	"./tl-ph.js": 35780,
	"./tlh": 29590,
	"./tlh.js": 29590,
	"./tr": 33807,
	"./tr.js": 33807,
	"./tzl": 93857,
	"./tzl.js": 93857,
	"./tzm": 60654,
	"./tzm-latn": 8806,
	"./tzm-latn.js": 8806,
	"./tzm.js": 60654,
	"./ug-cn": 30845,
	"./ug-cn.js": 30845,
	"./uk": 19232,
	"./uk.js": 19232,
	"./ur": 47052,
	"./ur.js": 47052,
	"./uz": 77967,
	"./uz-latn": 32233,
	"./uz-latn.js": 32233,
	"./uz.js": 77967,
	"./vi": 98615,
	"./vi.js": 98615,
	"./x-pseudo": 12320,
	"./x-pseudo.js": 12320,
	"./yo": 31313,
	"./yo.js": 31313,
	"./zh-cn": 64490,
	"./zh-cn.js": 64490,
	"./zh-hk": 55910,
	"./zh-hk.js": 55910,
	"./zh-mo": 98262,
	"./zh-mo.js": 98262,
	"./zh-tw": 44223,
	"./zh-tw.js": 44223
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 46700;

/***/ }),

/***/ 33383:
/*!***********************************************!*\
  !*** ./src/app/app.component.html?ngResource ***!
  \***********************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-app>\n  <ion-router-outlet></ion-router-outlet>\n</ion-app>\n";

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendor"], () => (__webpack_exec__(14431)));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=main.js.map