"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tailwindInit = void 0;
const child_process_1 = require("child_process");
const rxjs_1 = require("rxjs");
// You don't have to export the function as default. You can also have more than one rule factory
// per file.
function tailwindInit(_options) {
    return (host, _context) => {
        _context.logger.info('Initialized Tailwind');
        return new rxjs_1.Observable((subscriber) => {
            const child = (0, child_process_1.exec)('npx tailwindcss init');
            child.on('error', (error) => {
                subscriber.error(error);
            });
            child.on('close', () => {
                subscriber.next(host);
                subscriber.complete();
            });
            return () => {
                child.kill();
                return host;
            };
        });
    };
}
exports.tailwindInit = tailwindInit;
//# sourceMappingURL=index.js.map