"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ngAdd = void 0;
const core_1 = require("@angular-devkit/core");
const schematics_1 = require("@angular-devkit/schematics");
const schematics_2 = require("@angular/cdk/schematics");
const tasks_1 = require("@angular-devkit/schematics/tasks");
const dependencies_1 = require("@schematics/angular/utility/dependencies");
const workspace_1 = require("@schematics/angular/utility/workspace");
const change_1 = require("@schematics/angular/utility/change");
const has_tailwind_support_1 = require("../util/has-tailwind-support");
function ngAdd(_options) {
    return (host) => __awaiter(this, void 0, void 0, function* () {
        const workspace = yield (0, workspace_1.getWorkspace)(host);
        const project = (0, schematics_2.getProjectFromWorkspace)(workspace, _options.project);
        const projectName = _options.project || Object.keys(workspace.projects)[0];
        if (!project) {
            throw new schematics_1.SchematicsException(`Project ${projectName} is not defined in this workspace.`);
        }
        // FIXME project.projectType not available anymore with angular 11
        // if (project.projectType !== 'application') {
        //   throw new SchematicsException(
        //     `ngx-tailwind requires a project type of "application" but ${projectName} isn't.`,
        //   );
        // }
        const tailwindPlugins = _options.tailwindPlugins || [];
        const tailwindPluginDependencies = tailwindPlugins === null || tailwindPlugins === void 0 ? void 0 : tailwindPlugins.map((plugin) => `@tailwindcss/${plugin}`);
        const requireTailwindPlugins = tailwindPluginDependencies.map((plugin) => `require('${plugin}')\n`);
        if ((0, has_tailwind_support_1.hasTailwindSupport)(host)) {
            return (0, schematics_1.chain)([
                addDependenciesWithTailwindSupport(_options),
                addTailwindPlugins(tailwindPluginDependencies),
                updateStyles(_options, workspace),
                generateTailwindConfig(_options, requireTailwindPlugins),
                install(),
            ]);
        }
        else {
            throw new schematics_1.SchematicsException('Current version only supports Angular 11.2 or higher. Use previous version for Angular 11.1 or lower: ng add ngx-tailwind@2.3.0');
        }
    });
}
exports.ngAdd = ngAdd;
function addDependenciesWithTailwindSupport(_options) {
    return (host) => {
        (0, dependencies_1.addPackageJsonDependency)(host, {
            type: dependencies_1.NodeDependencyType.Dev,
            name: 'tailwindcss',
            version: _options.tailwindVersion,
        });
        (0, dependencies_1.addPackageJsonDependency)(host, {
            type: dependencies_1.NodeDependencyType.Dev,
            name: 'autoprefixer',
            version: _options.autoprefixerVersion,
        });
        (0, dependencies_1.addPackageJsonDependency)(host, {
            type: dependencies_1.NodeDependencyType.Dev,
            name: 'postcss',
            version: _options.postcssVersion,
        });
    };
}
function addTailwindPlugins(tailwindPlugins) {
    return (tree) => {
        tailwindPlugins.forEach((plugin) => (0, dependencies_1.addPackageJsonDependency)(tree, {
            type: dependencies_1.NodeDependencyType.Dev,
            name: plugin,
            version: 'latest',
        }));
    };
}
function updateStyles(options, workspace) {
    return (tree, context) => {
        const project = (0, schematics_2.getProjectFromWorkspace)(workspace, options.project);
        const stylePath = (0, schematics_2.getProjectStyleFile)(project, options.cssFormat);
        if (!stylePath) {
            context.logger.error(`Cannot update project styles file: Style path not found`);
            return tree;
        }
        const insertion = new change_1.InsertChange(stylePath, 0, options.cssFormat === 'css'
            ? getTailwindDirectives()
            : getTailwindImports());
        const recorder = tree.beginUpdate(stylePath);
        recorder.insertLeft(0, insertion.toAdd);
        tree.commitUpdate(recorder);
        return tree;
    };
}
/**
 * Used for css stylesheets
 */
function getTailwindDirectives() {
    return `@tailwind base;\n
@tailwind components;\n
@tailwind utilities;\n`;
}
/**
 * Used for scss stylesheets
 */
function getTailwindImports() {
    return `@import 'tailwindcss/base';\n
@import 'tailwindcss/components';\n
@import 'tailwindcss/utilities';\n`;
}
/**
 * Generate webpack and tailwind config.
 *
 * @param options
 */
function generateTailwindConfig(options, requireTailwindPlugins) {
    return (_host) => __awaiter(this, void 0, void 0, function* () {
        const sourceTemplates = (0, schematics_1.url)(`./templates/tailwind`);
        const sourceParametrizedTemplates = (0, schematics_1.apply)(sourceTemplates, [
            (0, schematics_1.template)(Object.assign(Object.assign(Object.assign({}, options), { requireTailwindPlugins: requireTailwindPlugins }), core_1.strings)),
        ]);
        return (0, schematics_1.mergeWith)(sourceParametrizedTemplates);
    });
}
function install() {
    return (_host, context) => __awaiter(this, void 0, void 0, function* () {
        // Install the dependency
        context.addTask(new tasks_1.NodePackageInstallTask());
    });
}
//# sourceMappingURL=index.js.map