!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("pako")):"function"==typeof define&&define.amd?define(["exports","pako"],e):e((t=t||self).hdr={},t.pako)}(this,(function(exports,pako){"use strict";const{pow:pow,floor:floor}=Math,TWO_POW_32=pow(2,32);class ByteBuffer{constructor(t){this.position=0,this.data=t,this.int32ArrayForConvert=new Uint32Array(1),this.int8ArrayForConvert=new Uint8Array(this.int32ArrayForConvert.buffer)}static allocate(t=16){return new ByteBuffer(new Uint8Array(t))}put(t){if(this.position===this.data.length){const t=this.data;this.data=new Uint8Array(2*this.data.length),this.data.set(t)}this.data[this.position]=t,this.position++}putInt32(t){if(this.data.length-this.position<4){const t=this.data;this.data=new Uint8Array(2*this.data.length+4),this.data.set(t)}this.int32ArrayForConvert[0]=t,this.data.set(this.int8ArrayForConvert.reverse(),this.position),this.position+=4}putInt64(t){this.putInt32(floor(t/TWO_POW_32)),this.putInt32(t)}putArray(t){if(this.data.length-this.position<t.byteLength){const e=this.data;this.data=new Uint8Array(this.position+t.byteLength),this.data.set(e)}this.data.set(t,this.position),this.position+=t.byteLength}get(){const t=this.data[this.position];return this.position++,t}getInt32(){this.int8ArrayForConvert.set(this.data.slice(this.position,this.position+4).reverse());const t=this.int32ArrayForConvert[0];return this.position+=4,t}getInt64(){const t=this.getInt32(),e=this.getInt32();return t*TWO_POW_32+e}resetPosition(){this.position=0}}class HistogramIterationValue{constructor(){this.reset()}reset(){this.valueIteratedTo=0,this.valueIteratedFrom=0,this.countAtValueIteratedTo=0,this.countAddedInThisIterationStep=0,this.totalCountToThisValue=0,this.totalValueToThisValue=0,this.percentile=0,this.percentileLevelIteratedTo=0}}class JsHistogramIterator{constructor(){this.currentIterationValue=new HistogramIterationValue}resetIterator(t){this.histogram=t,this.savedHistogramTotalRawCount=t.totalCount,this.arrayTotalCount=t.totalCount,this.currentIndex=0,this.currentValueAtIndex=0,this.nextValueAtIndex=Math.pow(2,t.unitMagnitude),this.prevValueIteratedTo=0,this.totalCountToPrevIndex=0,this.totalCountToCurrentIndex=0,this.totalValueToCurrentIndex=0,this.countAtThisValue=0,this.freshSubBucket=!0,this.currentIterationValue.reset()}hasNext(){if(this.histogram.totalCount!==this.savedHistogramTotalRawCount)throw"Concurrent Modification Exception";return this.totalCountToCurrentIndex<this.arrayTotalCount}next(){for(;!this.exhaustedSubBuckets();){if(this.countAtThisValue=this.histogram.getCountAtIndex(this.currentIndex),this.freshSubBucket&&(this.totalCountToCurrentIndex+=this.countAtThisValue,this.totalValueToCurrentIndex+=this.countAtThisValue*this.histogram.highestEquivalentValue(this.currentValueAtIndex),this.freshSubBucket=!1),this.reachedIterationLevel()){const t=this.getValueIteratedTo();if(Object.assign(this.currentIterationValue,{valueIteratedTo:t,valueIteratedFrom:this.prevValueIteratedTo,countAtValueIteratedTo:this.countAtThisValue,countAddedInThisIterationStep:this.totalCountToCurrentIndex-this.totalCountToPrevIndex,totalCountToThisValue:this.totalCountToCurrentIndex,totalValueToThisValue:this.totalValueToCurrentIndex,percentile:100*this.totalCountToCurrentIndex/this.arrayTotalCount,percentileLevelIteratedTo:this.getPercentileIteratedTo()}),this.prevValueIteratedTo=t,this.totalCountToPrevIndex=this.totalCountToCurrentIndex,this.incrementIterationLevel(),this.histogram.totalCount!==this.savedHistogramTotalRawCount)throw new Error("Concurrent Modification Exception");return this.currentIterationValue}this.incrementSubBucket()}throw new Error("Index Out Of Bounds Exception")}getPercentileIteratedTo(){return 100*this.totalCountToCurrentIndex/this.arrayTotalCount}getPercentileIteratedFrom(){return 100*this.totalCountToPrevIndex/this.arrayTotalCount}getValueIteratedTo(){return this.histogram.highestEquivalentValue(this.currentValueAtIndex)}exhaustedSubBuckets(){return this.currentIndex>=this.histogram.countsArrayLength}incrementSubBucket(){this.freshSubBucket=!0,this.currentIndex++,this.currentValueAtIndex=this.histogram.valueFromIndex(this.currentIndex),this.nextValueAtIndex=this.histogram.valueFromIndex(this.currentIndex+1)}}class RecordedValuesIterator extends JsHistogramIterator{constructor(t){super(),this.doReset(t)}reset(){this.doReset(this.histogram)}doReset(t){super.resetIterator(t),this.visitedIndex=-1}incrementIterationLevel(){this.visitedIndex=this.currentIndex}reachedIterationLevel(){return 0!=this.histogram.getCountAtIndex(this.currentIndex)&&this.visitedIndex!==this.currentIndex}}const{pow:pow$1,floor:floor$1,log2:log2}=Math;class PercentileIterator extends JsHistogramIterator{constructor(t,e){super(),this.percentileTicksPerHalfDistance=0,this.percentileLevelToIterateTo=0,this.percentileLevelToIterateFrom=0,this.reachedLastRecordedValue=!1,this.doReset(t,e)}reset(t){this.doReset(this.histogram,t)}doReset(t,e){super.resetIterator(t),this.percentileTicksPerHalfDistance=e,this.percentileLevelToIterateTo=0,this.percentileLevelToIterateFrom=0,this.reachedLastRecordedValue=!1}hasNext(){return!!super.hasNext()||!this.reachedLastRecordedValue&&this.arrayTotalCount>0&&(this.percentileLevelToIterateTo=100,this.reachedLastRecordedValue=!0,!0)}incrementIterationLevel(){this.percentileLevelToIterateFrom=this.percentileLevelToIterateTo;const t=this.percentileTicksPerHalfDistance*pow$1(2,floor$1(log2(100/(100-this.percentileLevelToIterateTo)))+1);this.percentileLevelToIterateTo+=100/t}reachedIterationLevel(){if(0===this.countAtThisValue)return!1;return 100*this.totalCountToCurrentIndex/this.arrayTotalCount>=this.percentileLevelToIterateTo}getPercentileIteratedTo(){return this.percentileLevelToIterateTo}getPercentileIteratedFrom(){return this.percentileLevelToIterateFrom}}const leftPadding=t=>e=>e.length<t?" ".repeat(t-e.length)+e:e,integerFormatter=t=>{const e=leftPadding(t);return t=>e(""+t)},{floor:floor$2,log10:log10,pow:pow$2}=Math,numberOfDigits=t=>floor$2(log10(t)+1),keepSignificantDigits=t=>e=>{const r=numberOfDigits(e);if(r>t){return e-e%pow$2(10,r-t)}return e},floatFormatter=(t,e)=>{const r=new Intl.NumberFormat("en-US",{maximumFractionDigits:e,minimumFractionDigits:e,useGrouping:!1}),n=leftPadding(t);return t=>n(r.format(t))},ulp=t=>Math.pow(2,Math.floor(Math.log2(t))-52),NO_TAG="NO TAG",toSummary=t=>{const{totalCount:e,maxValue:r,numberOfSignificantValueDigits:n}=t,i=keepSignificantDigits(n);return{p50:i(t.getValueAtPercentile(50)),p75:i(t.getValueAtPercentile(75)),p90:i(t.getValueAtPercentile(90)),p97_5:i(t.getValueAtPercentile(97.5)),p99:i(t.getValueAtPercentile(99)),p99_9:i(t.getValueAtPercentile(99.9)),p99_99:i(t.getValueAtPercentile(99.99)),p99_999:i(t.getValueAtPercentile(99.999)),max:r,totalCount:e}},{pow:pow$3,floor:floor$3,ceil:ceil,log2:log2$1,max:max,min:min}=Math;class JsHistogram{constructor(t,e,r){if(this.autoResize=!1,this.startTimeStampMsec=Number.MAX_SAFE_INTEGER,this.endTimeStampMsec=0,this.tag=NO_TAG,this.maxValue=0,this.minNonZeroValue=Number.MAX_SAFE_INTEGER,this.identity=0,this.highestTrackableValue=0,this.lowestDiscernibleValue=0,this.numberOfSignificantValueDigits=0,this.bucketCount=0,this.subBucketCount=0,this.countsArrayLength=0,this.wordSizeInBytes=0,t<1)throw new Error("lowestDiscernibleValue must be >= 1");if(e<2*t)throw new Error(`highestTrackableValue must be >= 2 * lowestDiscernibleValue ( 2 * ${t} )`);if(r<0||r>5)throw new Error("numberOfSignificantValueDigits must be between 0 and 5");this.identity=JsHistogram.identityBuilder++,this.init(t,e,r)}incrementTotalCount(){this._totalCount++}addToTotalCount(t){this._totalCount+=t}setTotalCount(t){this._totalCount=t}get totalCount(){return this._totalCount}updatedMaxValue(t){const e=t+this.unitMagnitudeMask;this.maxValue=e}updateMinNonZeroValue(t){if(t<=this.unitMagnitudeMask)return;const e=floor$3(t/this.lowestDiscernibleValueRounded)*this.lowestDiscernibleValueRounded;this.minNonZeroValue=e}init(t,e,r){this.lowestDiscernibleValue=t,this.highestTrackableValue=e,this.numberOfSignificantValueDigits=r;const n=2*floor$3(pow$3(10,r));this.unitMagnitude=floor$3(log2$1(t)),this.lowestDiscernibleValueRounded=pow$3(2,this.unitMagnitude),this.unitMagnitudeMask=this.lowestDiscernibleValueRounded-1;const i=ceil(log2$1(n));this.subBucketHalfCountMagnitude=(i>1?i:1)-1,this.subBucketCount=pow$3(2,this.subBucketHalfCountMagnitude+1),this.subBucketHalfCount=this.subBucketCount/2,this.subBucketMask=(floor$3(this.subBucketCount)-1)*pow$3(2,this.unitMagnitude),this.establishSize(e),this.leadingZeroCountBase=53-this.unitMagnitude-this.subBucketHalfCountMagnitude-1,this.percentileIterator=new PercentileIterator(this,1),this.recordedValuesIterator=new RecordedValuesIterator(this)}establishSize(t){this.countsArrayLength=this.determineArrayLengthNeeded(t),this.bucketCount=this.getBucketsNeededToCoverValue(t),this.highestTrackableValue=t}determineArrayLengthNeeded(t){if(t<2*this.lowestDiscernibleValue)throw new Error("highestTrackableValue ("+t+") cannot be < (2 * lowestDiscernibleValue)");return this.getLengthForNumberOfBuckets(this.getBucketsNeededToCoverValue(t))}getLengthForNumberOfBuckets(t){return(t+1)*(this.subBucketCount/2)}getBucketsNeededToCoverValue(t){let e=this.subBucketCount*pow$3(2,this.unitMagnitude),r=1;for(;e<=t;){if(e>Number.MAX_SAFE_INTEGER/2)return r+1;e*=2,r++}return r}recordValue(t){this.recordSingleValue(t)}recordSingleValue(t){const e=this.countsArrayIndex(t);e>=this.countsArrayLength?this.handleRecordException(1,t):this.incrementCountAtIndex(e),this.updateMinAndMax(t),this.incrementTotalCount()}handleRecordException(t,e){if(!this.autoResize)throw new Error("Value "+e+" is outside of histogram covered range");this.resize(e);var r=this.countsArrayIndex(e);this.addToCountAtIndex(r,t),this.highestTrackableValue=this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength-1))}countsArrayIndex(t){if(t<0)throw new Error("Histogram recorded value cannot be negative.");const e=this.getBucketIndex(t),r=this.getSubBucketIndex(t,e);return this.computeCountsArrayIndex(e,r)}computeCountsArrayIndex(t,e){return(t+1)*pow$3(2,this.subBucketHalfCountMagnitude)+(e-this.subBucketHalfCount)}getBucketIndex(t){return max(floor$3(log2$1(t))-this.subBucketHalfCountMagnitude-this.unitMagnitude,0)}getSubBucketIndex(t,e){return floor$3(t/pow$3(2,e+this.unitMagnitude))}updateMinAndMax(t){t>this.maxValue&&this.updatedMaxValue(t),t<this.minNonZeroValue&&0!==t&&this.updateMinNonZeroValue(t)}getValueAtPercentile(t){const e=min(t,100)/100*this.totalCount,r=max(ceil(e-ulp(e)),1);let n=0;for(let e=0;e<this.countsArrayLength;e++)if(n+=this.getCountAtIndex(e),n>=r){var i=this.valueFromIndex(e);return 0===t?this.lowestEquivalentValue(i):this.highestEquivalentValue(i)}return 0}valueFromIndexes(t,e){return e*pow$3(2,t+this.unitMagnitude)}valueFromIndex(t){let e=floor$3(t/this.subBucketHalfCount)-1,r=t%this.subBucketHalfCount+this.subBucketHalfCount;return e<0&&(r-=this.subBucketHalfCount,e=0),this.valueFromIndexes(e,r)}lowestEquivalentValue(t){const e=this.getBucketIndex(t),r=this.getSubBucketIndex(t,e);return this.valueFromIndexes(e,r)}highestEquivalentValue(t){return this.nextNonEquivalentValue(t)-1}nextNonEquivalentValue(t){return this.lowestEquivalentValue(t)+this.sizeOfEquivalentValueRange(t)}sizeOfEquivalentValueRange(t){const e=this.getBucketIndex(t),r=this.getSubBucketIndex(t,e);return pow$3(2,this.unitMagnitude+(r>=this.subBucketCount?e+1:e))}medianEquivalentValue(t){return this.lowestEquivalentValue(t)+floor$3(this.sizeOfEquivalentValueRange(t)/2)}get mean(){if(0===this.totalCount)return 0;this.recordedValuesIterator.reset();let t=0;for(;this.recordedValuesIterator.hasNext();){const e=this.recordedValuesIterator.next();t+=this.medianEquivalentValue(e.valueIteratedTo)*e.countAtValueIteratedTo}return t/this.totalCount}getStdDeviation(t=this.mean){if(0===this.totalCount)return 0;let e=0;for(this.recordedValuesIterator.reset();this.recordedValuesIterator.hasNext();){const r=this.recordedValuesIterator.next(),n=this.medianEquivalentValue(r.valueIteratedTo)-t;e+=n*n*r.countAddedInThisIterationStep}return Math.sqrt(e/this.totalCount)}get stdDeviation(){if(0===this.totalCount)return 0;const t=this.mean;let e=0;for(this.recordedValuesIterator.reset();this.recordedValuesIterator.hasNext();){const r=this.recordedValuesIterator.next(),n=this.medianEquivalentValue(r.valueIteratedTo)-t;e+=n*n*r.countAddedInThisIterationStep}return Math.sqrt(e/this.totalCount)}outputPercentileDistribution(t=5,e=1,r=!1){let n="";n+=r?'"Value","Percentile","TotalCount","1/(1-Percentile)"\n':"       Value     Percentile TotalCount 1/(1-Percentile)\n\n";const i=this.percentileIterator;let o,s;if(i.reset(t),r){const t=floatFormatter(0,this.numberOfSignificantValueDigits),r=floatFormatter(0,12),n=floatFormatter(0,2);o=i=>t(i.valueIteratedTo/e)+","+r(i.percentileLevelIteratedTo/100)+","+i.totalCountToThisValue+","+n(1/(1-i.percentileLevelIteratedTo/100))+"\n",s=n=>t(n.valueIteratedTo/e)+","+r(n.percentileLevelIteratedTo/100)+","+n.totalCountToThisValue+",Infinity\n"}else{const t=floatFormatter(12,this.numberOfSignificantValueDigits),r=floatFormatter(2,12),n=integerFormatter(10),i=floatFormatter(14,2);o=o=>t(o.valueIteratedTo/e)+" "+r(o.percentileLevelIteratedTo/100)+" "+n(o.totalCountToThisValue)+" "+i(1/(1-o.percentileLevelIteratedTo/100))+"\n",s=i=>t(i.valueIteratedTo/e)+" "+r(i.percentileLevelIteratedTo/100)+" "+n(i.totalCountToThisValue)+"\n"}for(;i.hasNext();){const t=i.next();t.percentileLevelIteratedTo<100?n+=o(t):n+=s(t)}if(!r){const t=floatFormatter(12,this.numberOfSignificantValueDigits),r=this.mean,i=t(r/e),o=t(this.getStdDeviation(r)/e),s=t(this.maxValue/e),a=integerFormatter(12);n+=`#[Mean    = ${i}, StdDeviation   = ${o}]\n#[Max     = ${s}, Total count    = ${a(this.totalCount)}]\n#[Buckets = ${a(this.bucketCount)}, SubBuckets     = ${a(this.subBucketCount)}]\n`}return n}get summary(){return toSummary(this)}toJSON(){return this.summary}inspect(){return this.toString()}[Symbol.for("nodejs.util.inspect.custom")](){return this.toString()}get estimatedFootprintInBytes(){return this._getEstimatedFootprintInBytes()}recordSingleValueWithExpectedInterval(t,e){if(this.recordSingleValue(t),!(e<=0))for(let r=t-e;r>=e;r-=e)this.recordSingleValue(r)}recordCountAtValue(t,e){const r=this.countsArrayIndex(e);r>=this.countsArrayLength?this.handleRecordException(t,e):this.addToCountAtIndex(r,t),this.updateMinAndMax(e),this.addToTotalCount(t)}recordValueWithCount(t,e){this.recordCountAtValue(e,t)}recordValueWithExpectedInterval(t,e){this.recordSingleValueWithExpectedInterval(t,e)}recordValueWithCountAndExpectedInterval(t,e,r){if(this.recordCountAtValue(e,t),!(r<=0))for(let n=t-r;n>=r;n-=r)this.recordCountAtValue(e,n)}addWhileCorrectingForCoordinatedOmission(t,e){const r=this,n=new RecordedValuesIterator(t);for(;n.hasNext();){const t=n.next();r.recordValueWithCountAndExpectedInterval(t.valueIteratedTo,t.countAtValueIteratedTo,e)}}add(t){if(!(t instanceof JsHistogram))throw new Error("Cannot add a WASM histogram to a regular JS histogram");if(this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength-1))<t.maxValue){if(!this.autoResize)throw new Error("The other histogram includes values that do not fit in this histogram's range.");this.resize(t.maxValue)}if(this.bucketCount===t.bucketCount&&this.subBucketCount===t.subBucketCount&&this.unitMagnitude===t.unitMagnitude){let e=0;for(let r=0;r<t.countsArrayLength;r++){const n=t.getCountAtIndex(r);n>0&&(this.addToCountAtIndex(r,n),e+=n)}this.setTotalCount(this.totalCount+e),this.updatedMaxValue(max(this.maxValue,t.maxValue)),this.updateMinNonZeroValue(min(this.minNonZeroValue,t.minNonZeroValue))}else{const e=t.countsArrayIndex(t.maxValue);let r=t.getCountAtIndex(e);this.recordCountAtValue(r,t.valueFromIndex(e));for(let n=0;n<e;n++)r=t.getCountAtIndex(n),r>0&&this.recordCountAtValue(r,t.valueFromIndex(n))}this.startTimeStampMsec=min(this.startTimeStampMsec,t.startTimeStampMsec),this.endTimeStampMsec=max(this.endTimeStampMsec,t.endTimeStampMsec)}getCountAtValue(t){const e=min(max(0,this.countsArrayIndex(t)),this.countsArrayLength-1);return this.getCountAtIndex(e)}subtract(t){const e=this.valueFromIndex(this.countsArrayLength-1);if(!(t instanceof JsHistogram))throw new Error("Cannot subtract a WASM histogram to a regular JS histogram");if(e<t.maxValue){if(!this.autoResize)throw new Error("The other histogram includes values that do not fit in this histogram's range.");this.resize(t.maxValue)}if(this.bucketCount===t.bucketCount&&this.subBucketCount===t.subBucketCount&&this.unitMagnitude===t.unitMagnitude){let e=0;for(let r=0;r<t.countsArrayLength;r++){const n=t.getCountAtIndex(r);n>0&&(this.addToCountAtIndex(r,-n),e+=n)}this.setTotalCount(this.totalCount-e)}else for(let e=0;e<t.countsArrayLength;e++){const r=t.getCountAtIndex(e);if(r>0){const n=t.valueFromIndex(e);if(this.getCountAtValue(n)<r)throw new Error("otherHistogram count ("+r+") at value "+n+" is larger than this one's ("+this.getCountAtValue(n)+")");this.recordCountAtValue(-r,n)}}(this.getCountAtValue(this.maxValue)<=0||this.getCountAtValue(this.minNonZeroValue)<=0)&&this.establishInternalTackingValues()}establishInternalTackingValues(t=this.countsArrayLength){this.maxValue=0,this.minNonZeroValue=Number.MAX_VALUE;let e=-1,r=-1,n=0;for(let i=0;i<t;i++){const t=this.getCountAtIndex(i);t>0&&(n+=t,e=i,-1==r&&0!=i&&(r=i))}e>=0&&this.updatedMaxValue(this.highestEquivalentValue(this.valueFromIndex(e))),r>=0&&this.updateMinNonZeroValue(this.valueFromIndex(r)),this.setTotalCount(n)}reset(){this.clearCounts(),this.setTotalCount(0),this.startTimeStampMsec=0,this.endTimeStampMsec=0,this.tag=NO_TAG,this.maxValue=0,this.minNonZeroValue=Number.MAX_SAFE_INTEGER}destroy(){}}
/*! *****************************************************************************
  Copyright (c) Microsoft Corporation.

  Permission to use, copy, modify, and/or distribute this software for any
  purpose with or without fee is hereby granted.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
  REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
  AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
  INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
  OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
  PERFORMANCE OF THIS SOFTWARE.
  ***************************************************************************** */function __awaiter(t,e,r,n){return new(r||(r=Promise))((function(i,o){function s(t){try{u(n.next(t))}catch(t){o(t)}}function a(t){try{u(n.throw(t))}catch(t){o(t)}}function u(t){var e;t.done?i(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(s,a)}u((n=n.apply(t,e||[])).next())}))}const BINARY="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";for(var toByteArray_1=toByteArray,fromByteArray_1=fromByteArray,lookup=[],revLookup=[],Arr="undefined"!=typeof Uint8Array?Uint8Array:Array,code="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",i=0,len=code.length;i<len;++i)lookup[i]=code[i],revLookup[code.charCodeAt(i)]=i;function getLens(t){var e=t.length;if(e%4>0)throw new Error("Invalid string. Length must be a multiple of 4");var r=t.indexOf("=");return-1===r&&(r=e),[r,r===e?0:4-r%4]}function _byteLength(t,e,r){return 3*(e+r)/4-r}function toByteArray(t){var e,r,n=getLens(t),i=n[0],o=n[1],s=new Arr(_byteLength(t,i,o)),a=0,u=o>0?i-4:i;for(r=0;r<u;r+=4)e=revLookup[t.charCodeAt(r)]<<18|revLookup[t.charCodeAt(r+1)]<<12|revLookup[t.charCodeAt(r+2)]<<6|revLookup[t.charCodeAt(r+3)],s[a++]=e>>16&255,s[a++]=e>>8&255,s[a++]=255&e;return 2===o&&(e=revLookup[t.charCodeAt(r)]<<2|revLookup[t.charCodeAt(r+1)]>>4,s[a++]=255&e),1===o&&(e=revLookup[t.charCodeAt(r)]<<10|revLookup[t.charCodeAt(r+1)]<<4|revLookup[t.charCodeAt(r+2)]>>2,s[a++]=e>>8&255,s[a++]=255&e),s}function tripletToBase64(t){return lookup[t>>18&63]+lookup[t>>12&63]+lookup[t>>6&63]+lookup[63&t]}function encodeChunk(t,e,r){for(var n,i=[],o=e;o<r;o+=3)n=(t[o]<<16&16711680)+(t[o+1]<<8&65280)+(255&t[o+2]),i.push(tripletToBase64(n));return i.join("")}function fromByteArray(t){for(var e,r=t.length,n=r%3,i=[],o=0,s=r-n;o<s;o+=16383)i.push(encodeChunk(t,o,o+16383>s?s:o+16383));return 1===n?(e=t[r-1],i.push(lookup[e>>2]+lookup[e<<4&63]+"==")):2===n&&(e=(t[r-2]<<8)+t[r-1],i.push(lookup[e>>10]+lookup[e>>4&63]+lookup[e<<2&63]+"=")),i.join("")}revLookup["-".charCodeAt(0)]=62,revLookup["_".charCodeAt(0)]=63;const ID_OFFSET=-8,SIZE_OFFSET=-4,ARRAYBUFFER_ID=0,STRING_ID=1,ARRAYBUFFERVIEW=1,ARRAY=2,STATICARRAY=4,VAL_ALIGN_OFFSET=6,VAL_SIGNED=2048,VAL_FLOAT=4096,VAL_MANAGED=16384,ARRAYBUFFERVIEW_BUFFER_OFFSET=0,ARRAYBUFFERVIEW_DATASTART_OFFSET=4,ARRAYBUFFERVIEW_DATALENGTH_OFFSET=8,ARRAYBUFFERVIEW_SIZE=12,ARRAY_LENGTH_OFFSET=12,ARRAY_SIZE=16,BIGINT="undefined"!=typeof BigUint64Array,THIS=Symbol(),CHUNKSIZE=1024;function getStringImpl(t,e){const r=new Uint32Array(t),n=new Uint16Array(t);let i=r[e+SIZE_OFFSET>>>2]>>>1,o=e>>>1;if(i<=CHUNKSIZE)return String.fromCharCode.apply(String,n.subarray(o,o+i));const s=[];do{const t=n[o+CHUNKSIZE-1],e=t>=55296&&t<56320?CHUNKSIZE-1:CHUNKSIZE;s.push(String.fromCharCode.apply(String,n.subarray(o,o+=e))),i-=e}while(i>CHUNKSIZE);return s.join("")+String.fromCharCode.apply(String,n.subarray(o,o+i))}function preInstantiate(t){const e={};function r(t,e){return t?getStringImpl(t.buffer,e):"<yet unknown>"}const n=t.env=t.env||{};return n.abort=n.abort||function(t,i,o,s){const a=e.memory||n.memory;throw Error("abort: "+r(a,t)+" at "+r(a,i)+":"+o+":"+s)},n.trace=n.trace||function(t,i){const o=e.memory||n.memory;console.log("trace: "+r(o,t)+(i?" ":"")+Array.prototype.slice.call(arguments,2,2+i).join(", "))},n.seed=n.seed||function(){return Date.now()},t.Math=t.Math||Math,t.Date=t.Date||Date,e}function postInstantiate(t,e){const r=e.exports,n=r.memory,i=r.table,o=r.__alloc,s=r.__retain,a=r.__rtti_base||-1;function u(t){const e=new Uint32Array(n.buffer);if((t>>>=0)>=e[a>>>2])throw Error("invalid id: "+t);return e[(a+4>>>2)+2*t]}function l(t){const e=new Uint32Array(n.buffer);if((t>>>=0)>=e[a>>>2])throw Error("invalid id: "+t);return e[(a+4>>>2)+2*t+1]}function h(t){return 31-Math.clz32(t>>>VAL_ALIGN_OFFSET&31)}function c(t,e,r){const i=n.buffer;if(r)switch(t){case 2:return new Float32Array(i);case 3:return new Float64Array(i)}else switch(t){case 0:return new(e?Int8Array:Uint8Array)(i);case 1:return new(e?Int16Array:Uint16Array)(i);case 2:return new(e?Int32Array:Uint32Array)(i);case 3:return new(e?BigInt64Array:BigUint64Array)(i)}throw Error("unsupported align: "+t)}function d(t){const e=new Uint32Array(n.buffer),r=e[t+ID_OFFSET>>>2],i=u(r);if(!(i&(ARRAYBUFFERVIEW|ARRAY|STATICARRAY)))throw Error("not an array: "+r+", flags="+i);const o=h(i);let s=i&STATICARRAY?t:e[t+ARRAYBUFFERVIEW_DATASTART_OFFSET>>>2];const a=i&ARRAY?e[t+ARRAY_LENGTH_OFFSET>>>2]:e[s+SIZE_OFFSET>>>2]>>>o;return c(o,i&VAL_SIGNED,i&VAL_FLOAT).subarray(s>>>=o,s+a)}function m(t,e,r){return new t(g(t,e,r))}function g(t,e,r){const i=n.buffer,o=new Uint32Array(i),s=o[r+ARRAYBUFFERVIEW_DATASTART_OFFSET>>>2];return new t(i,s,o[s+SIZE_OFFSET>>>2]>>>e)}function f(e,r,n){t["__get"+r]=m.bind(null,e,n),t["__get"+r+"View"]=g.bind(null,e,n)}return t.__allocString=function(t){const e=t.length,r=o(e<<1,STRING_ID),i=new Uint16Array(n.buffer);for(var s=0,a=r>>>1;s<e;++s)i[a+s]=t.charCodeAt(s);return r},t.__getString=function(t){const e=n.buffer;if(new Uint32Array(e)[t+ID_OFFSET>>>2]!==STRING_ID)throw Error("not a string: "+t);return getStringImpl(e,t)},t.__allocArray=function(t,e){const r=u(t);if(!(r&(ARRAYBUFFERVIEW|ARRAY|STATICARRAY)))throw Error("not an array: "+t+", flags= "+r);const i=h(r),a=e.length,l=o(a<<i,r&STATICARRAY?t:ARRAYBUFFER_ID);let d;if(r&STATICARRAY)d=l;else{const e=o(r&ARRAY?ARRAY_SIZE:ARRAYBUFFERVIEW_SIZE,t),u=new Uint32Array(n.buffer);u[e+ARRAYBUFFERVIEW_BUFFER_OFFSET>>>2]=s(l),u[e+ARRAYBUFFERVIEW_DATASTART_OFFSET>>>2]=l,u[e+ARRAYBUFFERVIEW_DATALENGTH_OFFSET>>>2]=a<<i,r&ARRAY&&(u[e+ARRAY_LENGTH_OFFSET>>>2]=a),d=e}const m=c(i,r&VAL_SIGNED,r&VAL_FLOAT);if(r&VAL_MANAGED)for(let t=0;t<a;++t)m[(l>>>i)+t]=s(e[t]);else m.set(e,l>>>i);return d},t.__getArrayView=d,t.__getArray=function(t){const e=d(t),r=e.length,n=new Array(r);for(let t=0;t<r;t++)n[t]=e[t];return n},t.__getArrayBuffer=function(t){const e=n.buffer,r=new Uint32Array(e)[t+SIZE_OFFSET>>>2];return e.slice(t,t+r)},[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array].forEach(t=>{f(t,t.name,31-Math.clz32(t.BYTES_PER_ELEMENT))}),BIGINT&&[BigUint64Array,BigInt64Array].forEach(t=>{f(t,t.name.slice(3),3)}),t.__instanceof=function(t,e){const r=new Uint32Array(n.buffer);let i=r[t+ID_OFFSET>>>2];if(i<=r[a>>>2])do{if(i==e)return!0;i=l(i)}while(i);return!1},t.memory=t.memory||n,t.table=t.table||i,demangle(r,t)}function isResponse(t){return"undefined"!=typeof Response&&t instanceof Response}function isModule(t){return t instanceof WebAssembly.Module}async function instantiate(t,e={}){if(isResponse(t=await t))return instantiateStreaming(t,e);const r=isModule(t)?t:await WebAssembly.compile(t),n=preInstantiate(e),i=await WebAssembly.instantiate(r,e);return{module:r,instance:i,exports:postInstantiate(n,i)}}var instantiate_1=instantiate;function instantiateSync(t,e={}){const r=isModule(t)?t:new WebAssembly.Module(t),n=preInstantiate(e),i=new WebAssembly.Instance(r,e);return{module:r,instance:i,exports:postInstantiate(n,i)}}var instantiateSync_1=instantiateSync;async function instantiateStreaming(t,e={}){if(!WebAssembly.instantiateStreaming)return instantiate(isResponse(t=await t)?t.arrayBuffer():t,e);const r=preInstantiate(e),n=await WebAssembly.instantiateStreaming(t,e),i=postInstantiate(r,n.instance);return{...n,exports:i}}function demangle(t,e={}){e=Object.create(e);const r=t.__argumentsLength?e=>{t.__argumentsLength.value=e}:t.__setArgumentsLength||t.__setargc||(()=>{});for(let n in t){if(!Object.prototype.hasOwnProperty.call(t,n))continue;const i=t[n];let o=n.split("."),s=e;for(;o.length>1;){let t=o.shift();Object.prototype.hasOwnProperty.call(s,t)||(s[t]={}),s=s[t]}let a=o[0],u=a.indexOf("#");if(u>=0){const e=a.substring(0,u),o=s[e];if(void 0===o||!o.prototype){const t=function(...e){return t.wrap(t.prototype.constructor(0,...e))};t.prototype={valueOf:function(){return this[THIS]}},t.wrap=function(e){return Object.create(t.prototype,{[THIS]:{value:e,writable:!1}})},o&&Object.getOwnPropertyNames(o).forEach(e=>Object.defineProperty(t,e,Object.getOwnPropertyDescriptor(o,e))),s[e]=t}if(a=a.substring(u+1),s=s[e].prototype,/^(get|set):/.test(a)){if(!Object.prototype.hasOwnProperty.call(s,a=a.substring(4))){let e=t[n.replace("set:","get:")],r=t[n.replace("get:","set:")];Object.defineProperty(s,a,{get:function(){return e(this[THIS])},set:function(t){r(this[THIS],t)},enumerable:!0})}}else"constructor"===a?(s[a]=(...t)=>(r(t.length),i(...t))).original=i:(s[a]=function(...t){return r(t.length),i(this[THIS],...t)}).original=i}else/^(get|set):/.test(a)?Object.prototype.hasOwnProperty.call(s,a=a.substring(4))||Object.defineProperty(s,a,{get:t[n.replace("set:","get:")],set:t[n.replace("get:","set:")],enumerable:!0}):"function"==typeof i&&i!==r?(s[a]=(...t)=>(r(t.length),i(...t))).original=i:s[a]=i}return e}const isNode="undefined"!=typeof process&&process.version,isWorker="function"==typeof importScripts,webAssemblyAvailable=(()=>{let t=!1;return t=isNode?"WebAssembly"in global:isWorker||"WebAssembly"in window,t})();let wasm=void 0;const initWebAssembly=()=>__awaiter(void 0,void 0,void 0,(function*(){if(!webAssemblyAvailable)throw new Error("WebAssembly not available here!");if(!wasm)return instantiate_1(pako.inflate(toByteArray_1(BINARY))).then(t=>wasm=t.exports||t)})),initWebAssemblySync=()=>{if(wasm)return;const t=instantiateSync_1(pako.inflate(toByteArray_1(BINARY)));wasm=t.exports||t},webAssemblyReady=()=>!!wasm,defaultRequest={bitBucketSize:32,autoResize:!0,lowestDiscernibleValue:1,highestTrackableValue:2,numberOfSignificantValueDigits:3},remoteHistogramClassFor=t=>"packed"===t?"PackedHistogram":"Histogram"+t,destroyedWasmHistogram=new Proxy({},{get:function(t,e){throw new Error("Cannot use a destroyed histogram")}});class WasmHistogram{constructor(t,e){this._wasmHistogram=t,this._remoteHistogramClass=e,this.tag=NO_TAG}static build(t=defaultRequest){if(!webAssemblyReady())throw new Error("WebAssembly is not ready yet!");const e=Object.assign({},defaultRequest,t),r=remoteHistogramClassFor(e.bitBucketSize);return new WasmHistogram(new wasm[r](e.lowestDiscernibleValue,e.highestTrackableValue,e.numberOfSignificantValueDigits,e.autoResize),r)}static decode(t,e=32,r=0){if(!webAssemblyReady())throw new Error("WebAssembly is not ready yet!");const n=remoteHistogramClassFor(e),i="decode"+n,o=wasm.__retain(wasm.__allocArray(wasm.UINT8ARRAY_ID,t)),s=new WasmHistogram(wasm[n].wrap(wasm[i](o,r)),n);return wasm.__release(o),s}get numberOfSignificantValueDigits(){return this._wasmHistogram.numberOfSignificantValueDigits}get autoResize(){return!!this._wasmHistogram.autoResize}set autoResize(t){this._wasmHistogram.autoResize=t}get highestTrackableValue(){return this._wasmHistogram.highestTrackableValue}set highestTrackableValue(t){this._wasmHistogram.highestTrackableValue=t}get startTimeStampMsec(){return this._wasmHistogram.startTimeStampMsec}set startTimeStampMsec(t){this._wasmHistogram.startTimeStampMsec=t}get endTimeStampMsec(){return this._wasmHistogram.endTimeStampMsec}set endTimeStampMsec(t){this._wasmHistogram.endTimeStampMsec=t}get totalCount(){return this._wasmHistogram.totalCount}get stdDeviation(){return this._wasmHistogram.stdDeviation}get mean(){return this._wasmHistogram.mean}get estimatedFootprintInBytes(){return 192+this._wasmHistogram.estimatedFootprintInBytes}get minNonZeroValue(){return this._wasmHistogram.minNonZeroValue}get maxValue(){return this._wasmHistogram.maxValue}recordValue(t){this._wasmHistogram.recordValue(t)}recordValueWithCount(t,e){this._wasmHistogram.recordValueWithCount(t,e)}recordValueWithExpectedInterval(t,e){this._wasmHistogram.recordValueWithExpectedInterval(t,e)}getValueAtPercentile(t){return this._wasmHistogram.getValueAtPercentile(t)}outputPercentileDistribution(t=5,e=1,r=!1){if(r)throw new Error("CSV output not supported by wasm histograms");return wasm.__getString(this._wasmHistogram.outputPercentileDistribution(t,e))}isDestroyed(){return this._wasmHistogram===destroyedWasmHistogram}get summary(){return toSummary(this)}toJSON(){return this.summary}toString(){return this.isDestroyed()?"Destroyed WASM histogram":`WASM ${this._remoteHistogramClass} ${JSON.stringify(this,null,2)}`}inspect(){return this.toString()}[Symbol.for("nodejs.util.inspect.custom")](){return this.toString()}addWhileCorrectingForCoordinatedOmission(t,e){this._wasmHistogram.addWhileCorrectingForCoordinatedOmission(t,e)}copyCorrectedForCoordinatedOmission(t){return new WasmHistogram(wasm[this._remoteHistogramClass].wrap(this._wasmHistogram.copyCorrectedForCoordinatedOmission(t)),this._remoteHistogramClass)}add(t){if(!(t instanceof WasmHistogram))throw new Error("Cannot add a regular JS histogram to a WASM histogram");this._wasmHistogram["add"+t._remoteHistogramClass](t._wasmHistogram)}subtract(t){if(!(t instanceof WasmHistogram))throw new Error("Cannot subtract a regular JS histogram to a WASM histogram");this._wasmHistogram["subtract"+t._remoteHistogramClass](t._wasmHistogram)}encode(){const t=this._wasmHistogram.encode(),e=wasm.__getUint8Array(t);return wasm.__release(t),e}reset(){this.tag=NO_TAG,this._wasmHistogram.reset()}destroy(){wasm.__release(this._wasmHistogram),this._wasmHistogram=destroyedWasmHistogram}}const MINIMUM_INITIAL_PACKED_ARRAY_CAPACITY=16,MAX_SUPPORTED_PACKED_COUNTS_ARRAY_LENGTH=Math.pow(2,13)-1,SET_0_START_INDEX=0,NUMBER_OF_SETS=8,LEAF_LEVEL_SHIFT=3,NON_LEAF_ENTRY_SLOT_INDICATORS_OFFSET=0,NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS=1,PACKED_ARRAY_GROWTH_INCREMENT=16,PACKED_ARRAY_GROWTH_FRACTION_POW2=4,{pow:pow$4,ceil:ceil$1,log2:log2$2,max:max$1}=Math,bitCount=t=>{for(var e=0;0!==t;)e+=bitCount32(0|t),t/=4294967296;return e},bitCount32=t=>16843009*((t=(858993459&(t-=t>>1&1431655765))+(t>>2&858993459))+(t>>4)&252645135)>>24;class PackedArrayContext{constructor(t,e){this.populatedShortLength=0,this.topLevelShift=Number.MAX_VALUE,this.physicalLength=Math.max(e,MINIMUM_INITIAL_PACKED_ARRAY_CAPACITY),this.isPacked=this.physicalLength<=MAX_SUPPORTED_PACKED_COUNTS_ARRAY_LENGTH,this.isPacked||(this.physicalLength=t),this.array=new ArrayBuffer(8*this.physicalLength),this.initArrayViews(this.array),this.init(t)}initArrayViews(t){this.byteArray=new Uint8Array(t),this.shortArray=new Uint16Array(t),this.longArray=new Float64Array(t)}init(t){if(this.isPacked){this.populatedShortLength=SET_0_START_INDEX+8;for(let t=0;t<NUMBER_OF_SETS;t++)this.setAtShortIndex(SET_0_START_INDEX+t,0);this.setVirtualLength(t)}else this.virtualLength=t}clear(){this.byteArray.fill(0),this.init(this.virtualLength)}copyAndIncreaseSize(t,e){const r=new PackedArrayContext(e,t);return this.isPacked&&r.populateEquivalentEntriesWithEntriesFromOther(this),r}getPopulatedShortLength(){return this.populatedShortLength}getPopulatedLongLength(){return this.getPopulatedShortLength()+3>>2}setAtByteIndex(t,e){this.byteArray[t]=e}getAtByteIndex(t){return this.byteArray[t]}addAtByteIndex(t,e){const r=this.byteArray[t]+e;return this.byteArray[t]=r,r}setPopulatedLongLength(t){this.populatedShortLength=t<<2}getVirtualLength(){return this.virtualLength}length(){return this.physicalLength}setAtShortIndex(t,e){this.shortArray[t]=e}setAtLongIndex(t,e){this.longArray[t]=e}getAtShortIndex(t){return this.shortArray[t]}getIndexAtShortIndex(t){return this.shortArray[t]}setPackedSlotIndicators(t,e){this.setAtShortIndex(t+NON_LEAF_ENTRY_SLOT_INDICATORS_OFFSET,e)}getPackedSlotIndicators(t){return 65535&this.shortArray[t+NON_LEAF_ENTRY_SLOT_INDICATORS_OFFSET]}getIndexAtEntrySlot(t,e){return this.getAtShortIndex(t+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+e)}setIndexAtEntrySlot(t,e,r){this.setAtShortIndex(t+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+e,r)}expandArrayIfNeeded(t){const e=this.length();if(e<this.getPopulatedLongLength()+t){const r=max$1(t,PACKED_ARRAY_GROWTH_INCREMENT,this.getPopulatedLongLength()>>PACKED_ARRAY_GROWTH_FRACTION_POW2);this.resizeArray(e+r)}}newEntry(t){const e=this.populatedShortLength;this.expandArrayIfNeeded(1+(t>>2)),this.populatedShortLength=e+t;for(let r=0;r<t;r++)this.setAtShortIndex(e+r,-1);return e}newLeafEntry(){let t;return t=this.getPopulatedLongLength(),this.expandArrayIfNeeded(1),this.setPopulatedLongLength(t+1),this.setAtLongIndex(t,0),t}consolidateEntry(t,e){const r=this.getPackedSlotIndicators(e),n=this.getPackedSlotIndicators(t),i=bitCount(n&(n^r)-1),o=bitCount(n);let s=0;for(let r=0;r<o;r++)if(r!==i){const n=this.getIndexAtEntrySlot(e,s);0!==n&&this.setIndexAtEntrySlot(t,r,n),s++}}expandEntry(t,e,r,n,i){let o=65535&this.getAtShortIndex(t);o|=n;const s=bitCount(o);if(r>=s)throw new Error("inserted slot index is out of range given provided masks");const a=s+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS;let u=0;i?u=this.newLeafEntry():(u=this.newEntry(NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS),this.setPackedSlotIndicators(u,0));const l=u,h=this.newEntry(a);return this.setPackedSlotIndicators(h,o),this.setIndexAtEntrySlot(h,r,l),this.setAtShortIndex(e,h),this.consolidateEntry(h,t),h}getRootEntry(t,e=!1){const r=SET_0_START_INDEX+t;let n=this.getIndexAtShortIndex(r);if(0==n){if(!e)return 0;n=this.newEntry(NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS),this.setPackedSlotIndicators(n,0),this.setAtShortIndex(r,n)}return n}getPackedIndex(t,e,r){if(e>=this.virtualLength)throw new Error(`Attempting access at index ${e}, beyond virtualLength ${this.virtualLength}`);let n=SET_0_START_INDEX+t,i=this.getRootEntry(t,r);if(0==i)return-1;for(let t=this.topLevelShift;t>=LEAF_LEVEL_SHIFT;t-=4){const o=t===LEAF_LEVEL_SHIFT,s=this.getPackedSlotIndicators(i),a=1<<(e/pow$4(2,t)&15),u=bitCount(s&a-1);if(0==(s&a)){if(!r)return-1;i=this.expandEntry(i,n,u,a,o)}n=i+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+u,i=this.getIndexAtShortIndex(n)}return(i<<3)+(7&e)}determineTopLevelShiftForVirtualLength(t){const e=ceil$1(log2$2(t));let r=4*ceil$1((e-3)/4);r=max$1(r,8);return r-4+3}setVirtualLength(t){if(!this.isPacked)throw new Error("Should never be adjusting the virtual size of a non-packed context");this.topLevelShift=this.determineTopLevelShiftForVirtualLength(t),this.virtualLength=t}getTopLevelShift(){return this.topLevelShift}resizeArray(t){const e=new Uint8Array(8*t);e.set(this.byteArray),this.array=e.buffer,this.initArrayViews(this.array),this.physicalLength=t}populateEquivalentEntriesWithEntriesFromOther(t){if(this.virtualLength<t.getVirtualLength())throw new Error("Cannot populate array of smaller virtual length");for(let e=0;e<NUMBER_OF_SETS;e++){const r=t.getAtShortIndex(SET_0_START_INDEX+e);if(0==r)continue;let n=SET_0_START_INDEX+e;for(let e=this.topLevelShift;e>t.topLevelShift;e-=4){const t=NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+1,e=this.newEntry(t);this.setAtShortIndex(n,e),this.setPackedSlotIndicators(e,1),n=e+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS}this.copyEntriesAtLevelFromOther(t,r,n,t.topLevelShift)}}copyEntriesAtLevelFromOther(t,e,r,n){const i=n==LEAF_LEVEL_SHIFT,o=t.getPackedSlotIndicators(e),s=bitCount(o),a=NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+s,u=this.newEntry(a);this.setAtShortIndex(r,u),this.setAtShortIndex(u+NON_LEAF_ENTRY_SLOT_INDICATORS_OFFSET,o);for(let r=0;r<s;r++)if(i){const n=this.newLeafEntry();this.setIndexAtEntrySlot(u,r,n);const i=t.getIndexAtEntrySlot(e,r);this.longArray[n]=t.longArray[i]}else{const i=t.getIndexAtEntrySlot(e,r);this.copyEntriesAtLevelFromOther(t,i,u+NON_LEAF_ENTRY_HEADER_SIZE_IN_SHORTS+r,n-4)}}getAtUnpackedIndex(t){return this.longArray[t]}setAtUnpackedIndex(t,e){this.longArray[t]=e}lazysetAtUnpackedIndex(t,e){this.longArray[t]=e}incrementAndGetAtUnpackedIndex(t){return this.longArray[t]++,this.longArray[t]}addAndGetAtUnpackedIndex(t,e){return this.longArray[t]+=e,this.longArray[t]}nonLeafEntryToString(t,e,r){let n="";for(let t=0;t<r;t++)n+="  ";try{const i=this.getPackedSlotIndicators(t);n+=`slotIndiators: 0x${toHex(i)}, prevVersionIndex: 0: [ `;const o=bitCount(i);for(let e=0;e<o;e++)n+=this.getIndexAtEntrySlot(t,e),e<o-1&&(n+=", ");n+=` ] (indexShift = ${e})\n`;const s=e==LEAF_LEVEL_SHIFT;for(let i=0;i<o;i++){const o=this.getIndexAtEntrySlot(t,i);n+=s?this.leafEntryToString(o,r+4):this.nonLeafEntryToString(o,e-4,r+4)}}catch(r){n+=`Exception thrown at nonLeafEnty at index ${t} with indexShift ${e}\n`}return n}leafEntryToString(t,e){let r="";for(let t=0;t<e;t++)r+="  ";try{r+="Leaf bytes : ";for(let e=0;e<8;e++)r+=`0x${toHex(this.byteArray[8*t+e])} `;r+="\n"}catch(e){r+=`Exception thrown at leafEnty at index ${t}\n`}return r}toString(){let t="PackedArrayContext:\n";if(!this.isPacked)return t+"Context is unpacked:\n";for(let e=0;e<NUMBER_OF_SETS;e++)try{const r=SET_0_START_INDEX+e,n=this.getIndexAtShortIndex(r);if(t+=`Set ${e}: root = ${n} \n`,0==n)continue;t+=this.nonLeafEntryToString(n,this.topLevelShift,4)}catch(r){t+=`Exception thrown in set ${e}%d\n`}return t}}const toHex=t=>Number(t).toString(16).padStart(2,"0"),NUMBER_OF_SETS$1=8,{pow:pow$5,floor:floor$4}=Math;class PackedArray{constructor(t,e=MINIMUM_INITIAL_PACKED_ARRAY_CAPACITY){this.arrayContext=new PackedArrayContext(t,e)}setVirtualLength(t){if(t<this.length())throw new Error("Cannot set virtual length, as requested length "+t+" is smaller than the current virtual length "+this.length());const e=this.arrayContext;e.isPacked&&e.determineTopLevelShiftForVirtualLength(t)==e.getTopLevelShift()?e.setVirtualLength(t):this.arrayContext=e.copyAndIncreaseSize(this.getPhysicalLength(),t)}get(t){let e=0;for(let r=0;r<NUMBER_OF_SETS$1;r++){let n=0;if(!this.arrayContext.isPacked)return this.arrayContext.getAtUnpackedIndex(t);const i=this.arrayContext.getPackedIndex(r,t,!1);if(i<0)return e;n=this.arrayContext.getAtByteIndex(i)*pow$5(2,r<<3),e+=n}return e}increment(t){this.add(t,1)}safeGetPackedIndexgetPackedIndex(t,e){return this.arrayContext.getPackedIndex(t,e,!0)}add(t,e){let r=e;for(let n=0,i=0;n<NUMBER_OF_SETS$1;n++,i+=8){if(!this.arrayContext.isPacked)return void this.arrayContext.addAndGetAtUnpackedIndex(t,e);const i=this.safeGetPackedIndexgetPackedIndex(n,t),o=255&r,s=this.arrayContext.addAtByteIndex(i,o);if(r-=o,r/=pow$5(2,8),r+=floor$4(s/pow$5(2,8)),0==r)return}}set(t,e){let r=0,n=e;for(let i=0;i<NUMBER_OF_SETS$1;i++){if(!this.arrayContext.isPacked)return void this.arrayContext.setAtUnpackedIndex(t,e);if(0==n){if(this.arrayContext.getPackedIndex(i,t,!1)<0)return}const o=this.arrayContext.getPackedIndex(i,t,!0),s=255&n;n=floor$4(n/pow$5(2,8)),i<r||(this.arrayContext.setAtByteIndex(o,s),r++)}}getPhysicalLength(){return this.arrayContext.physicalLength}length(){return this.arrayContext.getVirtualLength()}clear(){this.arrayContext.clear()}toString(){let t="PackedArray:\n";return t+=this.arrayContext.toString(),t}}class PackedHistogram extends JsHistogram{constructor(t,e,r){super(t,e,r),this._totalCount=0,this.packedCounts=new PackedArray(this.countsArrayLength)}clearCounts(){this.packedCounts.clear()}incrementCountAtIndex(t){this.packedCounts.increment(t)}addToCountAtIndex(t,e){this.packedCounts.add(t,e)}setCountAtIndex(t,e){this.packedCounts.set(t,e)}resize(t){this.establishSize(t),this.packedCounts.setVirtualLength(this.countsArrayLength)}getCountAtIndex(t){return this.packedCounts.get(t)}_getEstimatedFootprintInBytes(){return 192+8*this.packedCounts.getPhysicalLength()}copyCorrectedForCoordinatedOmission(t){const e=new PackedHistogram(this.lowestDiscernibleValue,this.highestTrackableValue,this.numberOfSignificantValueDigits);return e.addWhileCorrectingForCoordinatedOmission(this,t),e}toString(){return"PackedHistogram "+JSON.stringify(this,null,2)}}class TypedArrayHistogram extends JsHistogram{constructor(t,e,r,n){super(e,r,n),this.arrayCtr=t,this._totalCount=0,this._counts=new t(this.countsArrayLength)}clearCounts(){this._counts.fill(0)}incrementCountAtIndex(t){const e=this._counts[t]+1;if(e<0)throw e+" would overflow short integer count";this._counts[t]=e}addToCountAtIndex(t,e){const r=this._counts[t]+e;if(r<Number.MIN_SAFE_INTEGER||r>Number.MAX_SAFE_INTEGER)throw r+" would overflow integer count";this._counts[t]=r}setCountAtIndex(t,e){if(e<Number.MIN_SAFE_INTEGER||e>Number.MAX_SAFE_INTEGER)throw e+" would overflow integer count";this._counts[t]=e}resize(t){this.establishSize(t);const e=new this.arrayCtr(this.countsArrayLength);e.set(this._counts),this._counts=e}getCountAtIndex(t){return this._counts[t]}_getEstimatedFootprintInBytes(){return 1024+this._counts.BYTES_PER_ELEMENT*this._counts.length}copyCorrectedForCoordinatedOmission(t){const e=new TypedArrayHistogram(this.arrayCtr,this.lowestDiscernibleValue,this.highestTrackableValue,this.numberOfSignificantValueDigits);return e.addWhileCorrectingForCoordinatedOmission(this,t),e}toString(){return`Histogram ${8*this._counts.BYTES_PER_ELEMENT}b ${JSON.stringify(this,null,2)}`}}class Int8Histogram extends TypedArrayHistogram{constructor(t,e,r){super(Uint8Array,t,e,r)}}class Int16Histogram extends TypedArrayHistogram{constructor(t,e,r){super(Uint16Array,t,e,r)}}class Int32Histogram extends TypedArrayHistogram{constructor(t,e,r){super(Uint32Array,t,e,r)}}class Float64Histogram extends TypedArrayHistogram{constructor(t,e,r){super(Float64Array,t,e,r)}}function constructorFromBucketSize(t){switch(t){case"packed":return PackedHistogram;case 8:return Int8Histogram;case 16:return Int16Histogram;case 32:return Int32Histogram;case 64:return Float64Histogram;default:throw new Error("Incorrect parameter bitBucketSize")}}const{pow:pow$6,floor:floor$5}=Math,TWO_POW_7=pow$6(2,7),TWO_POW_14=pow$6(2,14),TWO_POW_21=pow$6(2,21),TWO_POW_28=pow$6(2,28),TWO_POW_35=pow$6(2,35),TWO_POW_42=pow$6(2,42),TWO_POW_49=pow$6(2,49),TWO_POW_56=pow$6(2,56);class ZigZagEncoding{static encode(t,e){e>=0?e*=2:e=2*-e-1,e<TWO_POW_7?t.put(e):(t.put(128|e),e<TWO_POW_14?t.put(floor$5(e/TWO_POW_7)):(t.put(128|floor$5(e/TWO_POW_7)),e<TWO_POW_21?t.put(floor$5(e/TWO_POW_14)):(t.put(128|floor$5(e/TWO_POW_14)),e<TWO_POW_28?t.put(floor$5(e/TWO_POW_21)):(t.put(128|floor$5(e/TWO_POW_21)),e<TWO_POW_35?t.put(floor$5(e/TWO_POW_28)):(t.put(128|floor$5(e/TWO_POW_28)),e<TWO_POW_42?t.put(floor$5(e/TWO_POW_35)):(t.put(128|floor$5(e/TWO_POW_35)),e<TWO_POW_49?t.put(floor$5(e/TWO_POW_42)):(t.put(128|floor$5(e/TWO_POW_42)),e<TWO_POW_56?t.put(floor$5(e/TWO_POW_49)):(t.put(floor$5(e/TWO_POW_49)+128),t.put(floor$5(e/TWO_POW_56))))))))))}static decode(t){let e=t.get(),r=127&e;return 0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_7,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_14,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_21,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_28,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_35,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_42,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_49,0!=(128&e)&&(e=t.get(),r+=(127&e)*TWO_POW_56)))))))),r%2==0?r/=2:r=-(r+1)/2,r}}const{max:max$2}=Math,V2EncodingCookieBase=478450435,V2CompressedEncodingCookieBase=478450436,V2maxWordSizeInBytes=9,encodingCookie=16|V2EncodingCookieBase,compressedEncodingCookie=16|V2CompressedEncodingCookieBase;function fillBufferFromCountsArray(t,e){const r=t.countsArrayIndex(t.maxValue)+1;let n=0;for(;n<r;){const i=t.getCountAtIndex(n++);if(i<0)throw new Error("Cannot encode histogram containing negative counts ("+i+") at index "+n+", corresponding the value range ["+t.lowestEquivalentValue(t.valueFromIndex(n))+","+t.nextNonEquivalentValue(t.valueFromIndex(n))+")");let o=0;if(0==i)for(o=1;n<r&&0==t.getCountAtIndex(n);)o++,n++;o>1?ZigZagEncoding.encode(e,-o):ZigZagEncoding.encode(e,i)}}function encodeIntoByteBuffer(t,e){const r=e.position;e.putInt32(encodingCookie),e.putInt32(0),e.putInt32(1),e.putInt32(t.numberOfSignificantValueDigits),e.putInt64(t.lowestDiscernibleValue),e.putInt64(t.highestTrackableValue),e.putInt64(1);const n=e.position;fillBufferFromCountsArray(t,e);const i=e.position;return e.position=r+4,e.putInt32(i-n),e.position=i,i-r}function fillCountsArrayFromSourceBuffer(t,e,r,n){if(2!=n&&4!=n&&8!=n&&n!=V2maxWordSizeInBytes)throw new Error("word size must be 2, 4, 8, or V2maxWordSizeInBytes ("+V2maxWordSizeInBytes+") bytes");let i=0;const o=e.position+r;for(;e.position<o;){let r=0,n=ZigZagEncoding.decode(e);n<0?(r=-n,i+=r):t.setCountAtIndex(i++,n)}return i}function getCookieBase(t){return-241&t}function getWordSizeInBytesFromCookie(t){if(getCookieBase(t)==V2EncodingCookieBase||getCookieBase(t)==V2CompressedEncodingCookieBase)return V2maxWordSizeInBytes;return 14&(240&t)>>4}function findDeflateFunction(){try{return eval('require("zlib").deflateSync')}catch(t){return pako?pako.deflate:()=>{throw new Error("pako library is mandatory for encoding/deconding on the browser side")}}}function findInflateFunction(){try{return eval('require("zlib").inflateSync')}catch(t){return pako?pako.inflate:()=>{throw new Error("pako library is mandatory for encoding/deconding on the browser side")}}}const deflate=findDeflateFunction(),inflate=findInflateFunction();function doDecode(t,e=32,r=0){const n=new ByteBuffer(t),i=n.getInt32();let o,s,a,u;if(getCookieBase(i)!==V2EncodingCookieBase)throw new Error("The buffer does not contain a Histogram (no valid V2 encoding cookie found)");if(getWordSizeInBytesFromCookie(i)!=V2maxWordSizeInBytes)throw new Error("The buffer does not contain a Histogram (no valid cookie found)");o=n.getInt32(),n.getInt32(),s=n.getInt32(),a=n.getInt64(),u=n.getInt64(),n.getInt64(),u=max$2(u,r);const l=new(constructorFromBucketSize(e))(a,u,s),h=fillCountsArrayFromSourceBuffer(l,n,o,V2maxWordSizeInBytes);return l.establishInternalTackingValues(h),l}function doEncodeIntoCompressedBase64(t){const e=t?{level:t}:{},r=ByteBuffer.allocate();r.putInt32(compressedEncodingCookie);const n=ByteBuffer.allocate(),i=encodeIntoByteBuffer(this,n),o=n.data.slice(0,i),s=deflate(o,e);return r.putInt32(s.byteLength),r.putArray(s),fromByteArray_1(r.data)}JsHistogram.decode=doDecode,JsHistogram.prototype.encodeIntoCompressedBase64=doEncodeIntoCompressedBase64;const V2CompressedEncodingCookieBase$1=478450436,compressedEncodingCookie$1=16|V2CompressedEncodingCookieBase$1;function decompress(t){const e=new ByteBuffer(t),r=e.position;if((-241&e.getInt32())!==V2CompressedEncodingCookieBase$1)throw new Error("Encoding not supported, only V2 is supported");const n=e.getInt32();return inflate(e.data.slice(r+8,r+8+n))}const decodeFromCompressedBase64=(t,e=32,r=!1,n=0)=>{const i=decompress(toByteArray_1(t.trim()));return r?WasmHistogram.decode(i,e,n):JsHistogram.decode(i,e,n)};function encodeWasmIntoCompressedBase64(t){const e=t?{level:t}:{},r=ByteBuffer.allocate();r.putInt32(compressedEncodingCookie$1);const n=this.encode(),i=deflate(n,e);return r.putInt32(i.byteLength),r.putArray(i),fromByteArray_1(r.data)}WasmHistogram.prototype.encodeIntoCompressedBase64=encodeWasmIntoCompressedBase64;const encodeIntoCompressedBase64=(t,e)=>{if(t instanceof WasmHistogram)return t.encodeIntoCompressedBase64(e);if(t instanceof JsHistogram)return t.encodeIntoCompressedBase64(e);throw new Error("Unsupported Histogram implementation")},TAG_PREFIX="Tag=",TAG_PREFIX_LENGTH="Tag=".length;class HistogramLogReader{constructor(t,e=32,r=!1){this.lines=splitLines(t),this.currentLineIndex=0,this.bitBucketSize=e,this.useWebAssembly=r}nextIntervalHistogram(t=0,e=Number.MAX_VALUE){for(;this.currentLineIndex<this.lines.length;){const r=this.lines[this.currentLineIndex];if(this.currentLineIndex++,r.startsWith("#[StartTime:"))this.parseStartTimeFromLine(r);else if(r.startsWith("#[BaseTime:"))this.parseBaseTimeFromLine(r);else if(r.startsWith("#")||r.startsWith('"StartTimestamp"'));else if(r.includes(",")){const n=r.split(","),[i]=n;let o;i.startsWith(TAG_PREFIX)?(o=i.substring(TAG_PREFIX_LENGTH),n.shift()):o=NO_TAG;const[s,a,,u]=n,l=Number.parseFloat(s);if(this.baseTimeSec||(l<this.startTimeSec-31536e3?this.baseTimeSec=this.startTimeSec:this.baseTimeSec=0),e<l)return null;if(l<t)continue;const h=decodeFromCompressedBase64(u,this.bitBucketSize,this.useWebAssembly);h.startTimeStampMsec=1e3*(this.baseTimeSec+l);const c=Number.parseFloat(a);return h.endTimeStampMsec=1e3*(this.baseTimeSec+l+c),h.tag=o,h}}return null}parseStartTimeFromLine(t){this.startTimeSec=Number.parseFloat(t.split(" ")[1])}parseBaseTimeFromLine(t){this.baseTimeSec=Number.parseFloat(t.split(" ")[1])}}const splitLines=t=>t.split(/\r\n|\r|\n/g),shouldIncludeNoTag=t=>t.find(t=>!t.startsWith("#")&&!t.startsWith('"')&&!t.startsWith(TAG_PREFIX)&&t.includes(",")),listTags=t=>{const e=splitLines(t),r=e.filter(t=>t.includes(",")&&t.startsWith(TAG_PREFIX)).map(t=>t.substring(TAG_PREFIX_LENGTH,t.indexOf(","))),n=new Set(r),i=Array.from(n);return shouldIncludeNoTag(e)&&i.unshift("NO TAG"),i},HISTOGRAM_LOG_FORMAT_VERSION="1.3",timeFormatter=floatFormatter(5,3);class HistogramLogWriter{constructor(t){this.log=t,this.baseTime=0}outputIntervalHistogram(t,e=(t.startTimeStampMsec-this.baseTime)/1e3,r=(t.endTimeStampMsec-this.baseTime)/1e3,n=1e3){const i=encodeIntoCompressedBase64(t),o=`${timeFormatter(e)},${timeFormatter(r-e)},${timeFormatter(t.maxValue/n)},${i}\n`;t.tag&&t.tag!==NO_TAG?this.log(`Tag=${t.tag},${o}`):this.log(o)}outputComment(t){this.log(`#${t}\n`)}outputStartTime(t){this.outputComment(`[StartTime: ${floatFormatter(5,3)(t/1e3)} (seconds since epoch), ${new Date(t)}]\n`)}outputLegend(){this.log('"StartTimestamp","Interval_Length","Interval_Max","Interval_Compressed_Histogram"\n')}outputLogFormatVersion(){this.outputComment("[Histogram log format version "+HISTOGRAM_LOG_FORMAT_VERSION+"]")}}const defaultRequest$1={bitBucketSize:32,autoResize:!0,lowestDiscernibleValue:1,highestTrackableValue:2,numberOfSignificantValueDigits:3,useWebAssembly:!1},build=(t=defaultRequest$1)=>{const e=Object.assign({},defaultRequest$1,t);if(t.useWebAssembly&&webAssemblyAvailable)return WasmHistogram.build(e);const r=new(constructorFromBucketSize(e.bitBucketSize))(e.lowestDiscernibleValue,e.highestTrackableValue,e.numberOfSignificantValueDigits);return r.autoResize=e.autoResize,r};class Recorder{constructor(t=defaultRequest$1,e=(()=>(new Date).getTime())){this.histogramBuildRequest=t,this.clock=e,this.activeHistogram=build(this.histogramBuildRequest),Recorder.idGenerator++,this.activeHistogram.containingInstanceId=Recorder.idGenerator,this.activeHistogram.startTimeStampMsec=e()}recordValue(t){this.activeHistogram.recordValue(t)}recordValueWithCount(t,e){this.activeHistogram.recordValueWithCount(t,e)}recordValueWithExpectedInterval(t,e){this.activeHistogram.recordValueWithExpectedInterval(t,e)}getIntervalHistogram(t){if(t){if(t.containingInstanceId!==this.activeHistogram.containingInstanceId)throw"replacement histogram must have been obtained via a previous getIntervalHistogram() call from this Recorder"}this.inactiveHistogram=t,this.performIntervalSample();const e=this.inactiveHistogram;return this.inactiveHistogram=null,e}getIntervalHistogramInto(t){this.performIntervalSample(),this.inactiveHistogram&&(t.add(this.inactiveHistogram),t.startTimeStampMsec=this.inactiveHistogram.startTimeStampMsec,t.endTimeStampMsec=this.inactiveHistogram.endTimeStampMsec)}reset(){this.activeHistogram.reset(),this.activeHistogram.startTimeStampMsec=this.clock()}performIntervalSample(){this.inactiveHistogram||(this.inactiveHistogram=build(this.histogramBuildRequest),this.inactiveHistogram.containingInstanceId=this.activeHistogram.containingInstanceId),this.inactiveHistogram.reset();const t=this.activeHistogram;this.activeHistogram=this.inactiveHistogram,this.inactiveHistogram=t;const e=this.clock();this.inactiveHistogram.endTimeStampMsec=e,this.activeHistogram.startTimeStampMsec=e}destroy(){var t;this.activeHistogram.destroy(),null===(t=this.inactiveHistogram)||void 0===t||t.destroy()}}Recorder.idGenerator=0,exports.ByteBuffer=ByteBuffer,exports.Float64Histogram=Float64Histogram,exports.HistogramLogReader=HistogramLogReader,exports.HistogramLogWriter=HistogramLogWriter,exports.Int16Histogram=Int16Histogram,exports.Int32Histogram=Int32Histogram,exports.Int8Histogram=Int8Histogram,exports.JsHistogram=JsHistogram,exports.PackedHistogram=PackedHistogram,exports.Recorder=Recorder,exports.WasmHistogram=WasmHistogram,exports.build=build,exports.decodeFromCompressedBase64=decodeFromCompressedBase64,exports.encodeIntoCompressedBase64=encodeIntoCompressedBase64,exports.initWebAssembly=initWebAssembly,exports.initWebAssemblySync=initWebAssemblySync,exports.listTags=listTags,Object.defineProperty(exports,"__esModule",{value:!0})}));
