"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeJsonFile = exports.readJsonFile = void 0;
const json_1 = require("./json");
const fs_1 = require("fs");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
/**
 * Reads a JSON file and returns the object the JSON content represents.
 *
 * @param path A path to a file.
 * @param options JSON parse options
 * @returns Object the JSON content of the file represents
 */
function readJsonFile(path, options) {
    const content = fs_1.readFileSync(path, 'utf-8');
    if (options) {
        options.endsWithNewline = content.charCodeAt(content.length - 1) === 10;
    }
    try {
        return json_1.parseJson(content, options);
    }
    catch (e) {
        e.message = e.message.replace('JSON', path);
        throw e;
    }
}
exports.readJsonFile = readJsonFile;
/**
 * Serializes the given data to JSON and writes it to a file.
 *
 * @param path A path to a file.
 * @param data data which should be serialized to JSON and written to the file
 * @param options JSON serialize options
 */
function writeJsonFile(path, data, options) {
    fs_extra_1.ensureDirSync(path_1.dirname(path));
    const serializedJson = json_1.serializeJson(data, options);
    const content = (options === null || options === void 0 ? void 0 : options.appendNewLine)
        ? `${serializedJson}\n`
        : serializedJson;
    fs_1.writeFileSync(path, content, { encoding: 'utf-8' });
}
exports.writeJsonFile = writeJsonFile;
//# sourceMappingURL=fileutils.js.map