/**
 * The Nx Devkit is the underlying technology used to customize Nx to support
 * different technologies and custom use-cases. It contains many utility
 * functions for reading and writing files, updating configuration,
 * working with Abstract Syntax Trees(ASTs), and more.
 *
 * As with most things in Nx, the core of Nx Devkit is very simple.
 * It only uses language primitives and immutable objects
 * (the tree being the only exception).
 */
/**
 * @category Tree
 */
export type { Tree, FileChange } from '@nrwl/tao/src/shared/tree';
/**
 * @category Workspace
 */
export type { WorkspaceJsonConfiguration, TargetDependencyConfig, TargetConfiguration, ProjectConfiguration, ProjectType, Generator, GeneratorCallback, Executor, ExecutorContext, TaskGraphExecutor, Workspace, } from '@nrwl/tao/src/shared/workspace';
/**
 * @category Workspace
 */
export type { Task, TaskGraph } from '@nrwl/tao/src/shared/tasks';
/**
 * @category Workspace
 */
export type { ImplicitDependencyEntry, ImplicitJsonSubsetDependency, NxJsonConfiguration, NxJsonProjectConfiguration, NxAffectedConfig, } from '@nrwl/tao/src/shared/nx';
/**
 * @category Logger
 */
export { logger } from '@nrwl/tao/src/shared/logger';
/**
 * @category Package Manager
 */
export type { PackageManager } from '@nrwl/tao/src/shared/package-manager';
/**
 * @category Package Manager
 */
export { getPackageManagerCommand, detectPackageManager, getPackageManagerVersion, } from '@nrwl/tao/src/shared/package-manager';
/**
 * @category Commands
 */
export type { Target } from '@nrwl/tao/src/commands/run';
/**
 * @category Commands
 */
export { runExecutor } from '@nrwl/tao/src/commands/run';
/**
 * @category Generators
 */
export { formatFiles } from './src/generators/format-files';
/**
 * @category Generators
 */
export { generateFiles } from './src/generators/generate-files';
/**
 * @category Generators
 */
export type { WorkspaceConfiguration } from './src/generators/project-configuration';
/**
 * @category Generators
 */
export { addProjectConfiguration, readProjectConfiguration, removeProjectConfiguration, updateProjectConfiguration, readWorkspaceConfiguration, updateWorkspaceConfiguration, getProjects, isStandaloneProject, } from './src/generators/project-configuration';
/**
 * @category Generators
 */
export { toJS } from './src/generators/to-js';
/**
 * @category Generators
 */
export { updateTsConfigsToJs } from './src/generators/update-ts-configs-to-js';
/**
 * @category Generators
 */
export { visitNotIgnoredFiles } from './src/generators/visit-not-ignored-files';
/**
 * @category Executors
 */
export { parseTargetString, targetToTargetString, } from './src/executors/parse-target-string';
/**
 * @category Executors
 */
export { readTargetOptions } from './src/executors/read-target-options';
/**
 * @category Project Graph
 */
export type { ProjectFileMap, FileData, ProjectGraph, ProjectGraphDependency, ProjectGraphNode, ProjectGraphProjectNode, ProjectGraphExternalNode, NxPlugin, ProjectGraphProcessorContext, } from './src/project-graph/interfaces';
/**
 * @category Project Graph
 */
export { DependencyType } from './src/project-graph/interfaces';
/**
 * @category Project Graph
 */
export { ProjectGraphBuilder } from './src/project-graph/project-graph-builder';
/**
 * @category Utils
 */
export { readJson, writeJson, updateJson } from './src/utils/json';
/**
 * @category Utils
 */
export { parseJson, serializeJson, stripJsonComments, } from '@nrwl/tao/src/utils/json';
/**
 * @category Utils
 */
export type { JsonParseOptions, JsonSerializeOptions, } from '@nrwl/tao/src/utils/json';
/**
 * @category Utils
 */
export { readJsonFile, writeJsonFile } from '@nrwl/tao/src/utils/fileutils';
/**
 * @category Utils
 */
export { addDependenciesToPackageJson, removeDependenciesFromPackageJson, } from './src/utils/package-json';
/**
 * @category Utils
 */
export { installPackagesTask } from './src/tasks/install-packages-task';
/**
 * @category Utils
 */
export { names } from './src/utils/names';
/**
 * @category Utils
 */
export { getWorkspaceLayout, getWorkspacePath, } from './src/utils/get-workspace-layout';
/**
 * @category Utils
 */
export type { StringChange, StringDeletion, StringInsertion, } from './src/utils/string-change';
/**
 * @category Utils
 */
export { applyChangesToString, ChangeType } from './src/utils/string-change';
/**
 * @category Utils
 */
export { offsetFromRoot } from './src/utils/offset-from-root';
/**
 * @category Utils
 */
export { convertNxGenerator } from './src/utils/invoke-nx-generator';
/**
 * @category Utils
 */
export { convertNxExecutor } from './src/utils/convert-nx-executor';
/**
 * @category Utils
 */
export { stripIndents } from './src/utils/strip-indents';
/**
 * @category Utils
 */
export { joinPathFragments, normalizePath } from './src/utils/path';
/**
 * @category Utils
 */
export { moveFilesToNewDirectory } from './src/utils/move-dir';
