import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
export class DomController {
    /**
     * Schedules a task to run during the READ phase of the next frame.
     * This task should only read the DOM, but never modify it.
     */
    read(cb) {
        getQueue().read(cb);
    }
    /**
     * Schedules a task to run during the WRITE phase of the next frame.
     * This task should write the DOM, but never READ it.
     */
    write(cb) {
        getQueue().write(cb);
    }
}
/** @nocollapse */ DomController.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: DomController, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ DomController.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: DomController, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: DomController, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
const getQueue = () => {
    const win = typeof window !== 'undefined' ? window : null;
    if (win != null) {
        const Ionic = win.Ionic;
        if (Ionic === null || Ionic === void 0 ? void 0 : Ionic.queue) {
            return Ionic.queue;
        }
        return {
            read: (cb) => win.requestAnimationFrame(cb),
            write: (cb) => win.requestAnimationFrame(cb),
        };
    }
    return {
        read: (cb) => cb(),
        write: (cb) => cb(),
    };
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9tLWNvbnRyb2xsZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcHJvdmlkZXJzL2RvbS1jb250cm9sbGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7O0FBSzNDLE1BQU0sT0FBTyxhQUFhO0lBQ3hCOzs7T0FHRztJQUNILElBQUksQ0FBQyxFQUFlO1FBQ2xCLFFBQVEsRUFBRSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsS0FBSyxDQUFDLEVBQWU7UUFDbkIsUUFBUSxFQUFFLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQ3ZCLENBQUM7OzhIQWZVLGFBQWE7a0lBQWIsYUFBYSxjQUZaLE1BQU07NEZBRVAsYUFBYTtrQkFIekIsVUFBVTttQkFBQztvQkFDVixVQUFVLEVBQUUsTUFBTTtpQkFDbkI7O0FBbUJELE1BQU0sUUFBUSxHQUFHLEdBQUcsRUFBRTtJQUNwQixNQUFNLEdBQUcsR0FBRyxPQUFRLE1BQWMsS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUUsSUFBWSxDQUFDO0lBRTVFLElBQUksR0FBRyxJQUFJLElBQUksRUFBRTtRQUNmLE1BQU0sS0FBSyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUM7UUFDeEIsSUFBSSxLQUFLLGFBQUwsS0FBSyx1QkFBTCxLQUFLLENBQUUsS0FBSyxFQUFFO1lBQ2hCLE9BQU8sS0FBSyxDQUFDLEtBQUssQ0FBQztTQUNwQjtRQUVELE9BQU87WUFDTCxJQUFJLEVBQUUsQ0FBQyxFQUFPLEVBQUUsRUFBRSxDQUFDLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxFQUFFLENBQUM7WUFDaEQsS0FBSyxFQUFFLENBQUMsRUFBTyxFQUFFLEVBQUUsQ0FBQyxHQUFHLENBQUMscUJBQXFCLENBQUMsRUFBRSxDQUFDO1NBQ2xELENBQUM7S0FDSDtJQUVELE9BQU87UUFDTCxJQUFJLEVBQUUsQ0FBQyxFQUFPLEVBQUUsRUFBRSxDQUFDLEVBQUUsRUFBRTtRQUN2QixLQUFLLEVBQUUsQ0FBQyxFQUFPLEVBQUUsRUFBRSxDQUFDLEVBQUUsRUFBRTtLQUN6QixDQUFDO0FBQ0osQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuXG5ASW5qZWN0YWJsZSh7XG4gIHByb3ZpZGVkSW46ICdyb290Jyxcbn0pXG5leHBvcnQgY2xhc3MgRG9tQ29udHJvbGxlciB7XG4gIC8qKlxuICAgKiBTY2hlZHVsZXMgYSB0YXNrIHRvIHJ1biBkdXJpbmcgdGhlIFJFQUQgcGhhc2Ugb2YgdGhlIG5leHQgZnJhbWUuXG4gICAqIFRoaXMgdGFzayBzaG91bGQgb25seSByZWFkIHRoZSBET00sIGJ1dCBuZXZlciBtb2RpZnkgaXQuXG4gICAqL1xuICByZWFkKGNiOiBSYWZDYWxsYmFjayk6IHZvaWQge1xuICAgIGdldFF1ZXVlKCkucmVhZChjYik7XG4gIH1cblxuICAvKipcbiAgICogU2NoZWR1bGVzIGEgdGFzayB0byBydW4gZHVyaW5nIHRoZSBXUklURSBwaGFzZSBvZiB0aGUgbmV4dCBmcmFtZS5cbiAgICogVGhpcyB0YXNrIHNob3VsZCB3cml0ZSB0aGUgRE9NLCBidXQgbmV2ZXIgUkVBRCBpdC5cbiAgICovXG4gIHdyaXRlKGNiOiBSYWZDYWxsYmFjayk6IHZvaWQge1xuICAgIGdldFF1ZXVlKCkud3JpdGUoY2IpO1xuICB9XG59XG5cbmNvbnN0IGdldFF1ZXVlID0gKCkgPT4ge1xuICBjb25zdCB3aW4gPSB0eXBlb2YgKHdpbmRvdyBhcyBhbnkpICE9PSAndW5kZWZpbmVkJyA/IHdpbmRvdyA6IChudWxsIGFzIGFueSk7XG5cbiAgaWYgKHdpbiAhPSBudWxsKSB7XG4gICAgY29uc3QgSW9uaWMgPSB3aW4uSW9uaWM7XG4gICAgaWYgKElvbmljPy5xdWV1ZSkge1xuICAgICAgcmV0dXJuIElvbmljLnF1ZXVlO1xuICAgIH1cblxuICAgIHJldHVybiB7XG4gICAgICByZWFkOiAoY2I6IGFueSkgPT4gd2luLnJlcXVlc3RBbmltYXRpb25GcmFtZShjYiksXG4gICAgICB3cml0ZTogKGNiOiBhbnkpID0+IHdpbi5yZXF1ZXN0QW5pbWF0aW9uRnJhbWUoY2IpLFxuICAgIH07XG4gIH1cblxuICByZXR1cm4ge1xuICAgIHJlYWQ6IChjYjogYW55KSA9PiBjYigpLFxuICAgIHdyaXRlOiAoY2I6IGFueSkgPT4gY2IoKSxcbiAgfTtcbn07XG5cbmV4cG9ydCB0eXBlIFJhZkNhbGxiYWNrID0gKHRpbWVTdGFtcD86IG51bWJlcikgPT4gdm9pZDtcbiJdfQ==