import { CommonModule, DOCUMENT } from '@angular/common';
import { APP_INITIALIZER, NgModule, NgZone } from '@angular/core';
import { appInitialize } from './app-initialize';
import { BooleanValueAccessorDirective } from './directives/control-value-accessors/boolean-value-accessor';
import { NumericValueAccessorDirective } from './directives/control-value-accessors/numeric-value-accessor';
import { RadioValueAccessorDirective } from './directives/control-value-accessors/radio-value-accessor';
import { SelectValueAccessorDirective } from './directives/control-value-accessors/select-value-accessor';
import { TextValueAccessorDirective } from './directives/control-value-accessors/text-value-accessor';
import { IonBackButtonDelegateDirective } from './directives/navigation/ion-back-button';
import { IonRouterOutlet } from './directives/navigation/ion-router-outlet';
import { IonTabs } from './directives/navigation/ion-tabs';
import { NavDelegate } from './directives/navigation/nav-delegate';
import { RouterLinkDelegateDirective, RouterLinkWithHrefDelegateDirective, } from './directives/navigation/router-link-delegate';
import { IonModal } from './directives/overlays/modal';
import { IonPopover } from './directives/overlays/popover';
import { DIRECTIVES } from './directives/proxies-list';
import { VirtualFooter } from './directives/virtual-scroll/virtual-footer';
import { VirtualHeader } from './directives/virtual-scroll/virtual-header';
import { VirtualItem } from './directives/virtual-scroll/virtual-item';
import { IonVirtualScroll } from './directives/virtual-scroll/virtual-scroll';
import { AngularDelegate } from './providers/angular-delegate';
import { ConfigToken } from './providers/config';
import { ModalController } from './providers/modal-controller';
import { PopoverController } from './providers/popover-controller';
import * as i0 from "@angular/core";
import * as i1 from "./directives/proxies";
const DECLARATIONS = [
    // generated proxies
    ...DIRECTIVES,
    // manual proxies
    IonModal,
    IonPopover,
    // ngModel accessors
    BooleanValueAccessorDirective,
    NumericValueAccessorDirective,
    RadioValueAccessorDirective,
    SelectValueAccessorDirective,
    TextValueAccessorDirective,
    // navigation
    IonTabs,
    IonRouterOutlet,
    IonBackButtonDelegateDirective,
    NavDelegate,
    RouterLinkDelegateDirective,
    RouterLinkWithHrefDelegateDirective,
    // virtual scroll
    VirtualFooter,
    VirtualHeader,
    VirtualItem,
    IonVirtualScroll,
];
export class IonicModule {
    static forRoot(config) {
        return {
            ngModule: IonicModule,
            providers: [
                {
                    provide: ConfigToken,
                    useValue: config,
                },
                {
                    provide: APP_INITIALIZER,
                    useFactory: appInitialize,
                    multi: true,
                    deps: [ConfigToken, DOCUMENT, NgZone],
                },
            ],
        };
    }
}
/** @nocollapse */ IonicModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonicModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
/** @nocollapse */ IonicModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonicModule, declarations: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonApp, i1.IonAvatar, i1.IonBackButton, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNav, i1.IonNavLink, i1.IonNote, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSelect, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSlide, i1.IonSlides, i1.IonSpinner, i1.IonSplitPane, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToggle, i1.IonToolbar, 
        // manual proxies
        IonModal,
        IonPopover,
        // ngModel accessors
        BooleanValueAccessorDirective,
        NumericValueAccessorDirective,
        RadioValueAccessorDirective,
        SelectValueAccessorDirective,
        TextValueAccessorDirective,
        // navigation
        IonTabs,
        IonRouterOutlet,
        IonBackButtonDelegateDirective,
        NavDelegate,
        RouterLinkDelegateDirective,
        RouterLinkWithHrefDelegateDirective,
        // virtual scroll
        VirtualFooter,
        VirtualHeader,
        VirtualItem,
        IonVirtualScroll], imports: [CommonModule], exports: [i1.IonAccordion, i1.IonAccordionGroup, i1.IonApp, i1.IonAvatar, i1.IonBackButton, i1.IonBackdrop, i1.IonBadge, i1.IonBreadcrumb, i1.IonBreadcrumbs, i1.IonButton, i1.IonButtons, i1.IonCard, i1.IonCardContent, i1.IonCardHeader, i1.IonCardSubtitle, i1.IonCardTitle, i1.IonCheckbox, i1.IonChip, i1.IonCol, i1.IonContent, i1.IonDatetime, i1.IonDatetimeButton, i1.IonFab, i1.IonFabButton, i1.IonFabList, i1.IonFooter, i1.IonGrid, i1.IonHeader, i1.IonIcon, i1.IonImg, i1.IonInfiniteScroll, i1.IonInfiniteScrollContent, i1.IonInput, i1.IonItem, i1.IonItemDivider, i1.IonItemGroup, i1.IonItemOption, i1.IonItemOptions, i1.IonItemSliding, i1.IonLabel, i1.IonList, i1.IonListHeader, i1.IonMenu, i1.IonMenuButton, i1.IonMenuToggle, i1.IonNav, i1.IonNavLink, i1.IonNote, i1.IonProgressBar, i1.IonRadio, i1.IonRadioGroup, i1.IonRange, i1.IonRefresher, i1.IonRefresherContent, i1.IonReorder, i1.IonReorderGroup, i1.IonRippleEffect, i1.IonRow, i1.IonSearchbar, i1.IonSegment, i1.IonSegmentButton, i1.IonSelect, i1.IonSelectOption, i1.IonSkeletonText, i1.IonSlide, i1.IonSlides, i1.IonSpinner, i1.IonSplitPane, i1.IonTabBar, i1.IonTabButton, i1.IonText, i1.IonTextarea, i1.IonThumbnail, i1.IonTitle, i1.IonToggle, i1.IonToolbar, 
        // manual proxies
        IonModal,
        IonPopover,
        // ngModel accessors
        BooleanValueAccessorDirective,
        NumericValueAccessorDirective,
        RadioValueAccessorDirective,
        SelectValueAccessorDirective,
        TextValueAccessorDirective,
        // navigation
        IonTabs,
        IonRouterOutlet,
        IonBackButtonDelegateDirective,
        NavDelegate,
        RouterLinkDelegateDirective,
        RouterLinkWithHrefDelegateDirective,
        // virtual scroll
        VirtualFooter,
        VirtualHeader,
        VirtualItem,
        IonVirtualScroll] });
/** @nocollapse */ IonicModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonicModule, providers: [AngularDelegate, ModalController, PopoverController], imports: [[CommonModule]] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonicModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: DECLARATIONS,
                    exports: DECLARATIONS,
                    providers: [AngularDelegate, ModalController, PopoverController],
                    imports: [CommonModule],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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