export const insertView = (views, view, direction) => {
    if (direction === 'root') {
        return setRoot(views, view);
    }
    else if (direction === 'forward') {
        return setForward(views, view);
    }
    else {
        return setBack(views, view);
    }
};
const setRoot = (views, view) => {
    views = views.filter((v) => v.stackId !== view.stackId);
    views.push(view);
    return views;
};
const setForward = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        views = views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        views.push(view);
    }
    return views;
};
const setBack = (views, view) => {
    const index = views.indexOf(view);
    if (index >= 0) {
        return views.filter((v) => v.stackId !== view.stackId || v.id <= view.id);
    }
    else {
        return setRoot(views, view);
    }
};
export const getUrl = (router, activatedRoute) => {
    const urlTree = router.createUrlTree(['.'], { relativeTo: activatedRoute });
    return router.serializeUrl(urlTree);
};
export const isTabSwitch = (enteringView, leavingView) => {
    if (!leavingView) {
        return true;
    }
    return enteringView.stackId !== leavingView.stackId;
};
export const computeStackId = (prefixUrl, url) => {
    if (!prefixUrl) {
        return undefined;
    }
    const segments = toSegments(url);
    for (let i = 0; i < segments.length; i++) {
        if (i >= prefixUrl.length) {
            return segments[i];
        }
        if (segments[i] !== prefixUrl[i]) {
            return undefined;
        }
    }
    return undefined;
};
export const toSegments = (path) => {
    return path
        .split('/')
        .map((s) => s.trim())
        .filter((s) => s !== '');
};
export const destroyView = (view) => {
    if (view) {
        view.ref.destroy();
        view.unlistenEvents();
    }
};
//# sourceMappingURL=data:application/json;base64,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