import { Directive, HostListener } from '@angular/core';
import { NgControl } from '@angular/forms';
import { raf } from '../../util/util';
import * as i0 from "@angular/core";
// TODO(FW-2827): types
export class ValueAccessor {
    constructor(injector, el) {
        this.injector = injector;
        this.el = el;
        this.onChange = () => {
            /**/
        };
        this.onTouched = () => {
            /**/
        };
    }
    writeValue(value) {
        /**
         * TODO FW-2646
         * Change `value == null ? '' : value;`
         * to `value`. This was a fix for IE9, but IE9
         * is no longer supported; however, this change
         * is potentially a breaking change
         */
        this.el.nativeElement.value = this.lastValue = value == null ? '' : value;
        setIonicClasses(this.el);
    }
    handleChangeEvent(el, value) {
        if (el === this.el.nativeElement) {
            if (value !== this.lastValue) {
                this.lastValue = value;
                this.onChange(value);
            }
            setIonicClasses(this.el);
        }
    }
    _handleBlurEvent(el) {
        if (el === this.el.nativeElement) {
            this.onTouched();
            setIonicClasses(this.el);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    setDisabledState(isDisabled) {
        this.el.nativeElement.disabled = isDisabled;
    }
    ngOnDestroy() {
        if (this.statusChanges) {
            this.statusChanges.unsubscribe();
        }
    }
    ngAfterViewInit() {
        let ngControl;
        try {
            ngControl = this.injector.get(NgControl);
        }
        catch (_a) {
            /* No FormControl or ngModel binding */
        }
        if (!ngControl) {
            return;
        }
        // Listen for changes in validity, disabled, or pending states
        if (ngControl.statusChanges) {
            this.statusChanges = ngControl.statusChanges.subscribe(() => setIonicClasses(this.el));
        }
        /**
         * TODO FW-2787: Remove this in favor of https://github.com/angular/angular/issues/10887
         * whenever it is implemented.
         */
        const formControl = ngControl.control;
        if (formControl) {
            const methodsToPatch = ['markAsTouched', 'markAllAsTouched', 'markAsUntouched', 'markAsDirty', 'markAsPristine'];
            methodsToPatch.forEach((method) => {
                if (typeof formControl[method] !== 'undefined') {
                    const oldFn = formControl[method].bind(formControl);
                    formControl[method] = (...params) => {
                        oldFn(...params);
                        setIonicClasses(this.el);
                    };
                }
            });
        }
    }
}
/** @nocollapse */ ValueAccessor.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: ValueAccessor, deps: [{ token: i0.Injector }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ ValueAccessor.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.10", type: ValueAccessor, host: { listeners: { "ionBlur": "_handleBlurEvent($event.target)" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: ValueAccessor, decorators: [{
            type: Directive
        }], ctorParameters: function () { return [{ type: i0.Injector }, { type: i0.ElementRef }]; }, propDecorators: { _handleBlurEvent: [{
                type: HostListener,
                args: ['ionBlur', ['$event.target']]
            }] } });
export const setIonicClasses = (element) => {
    raf(() => {
        const input = element.nativeElement;
        const hasValue = input.value != null && input.value.toString().length > 0;
        const classes = getClasses(input);
        setClasses(input, classes);
        const item = input.closest('ion-item');
        if (item) {
            if (hasValue) {
                setClasses(item, [...classes, 'item-has-value']);
            }
            else {
                setClasses(item, classes);
            }
        }
    });
};
const getClasses = (element) => {
    const classList = element.classList;
    const classes = [];
    for (let i = 0; i < classList.length; i++) {
        const item = classList.item(i);
        if (item !== null && startsWith(item, 'ng-')) {
            classes.push(`ion-${item.substring(3)}`);
        }
    }
    return classes;
};
const setClasses = (element, classes) => {
    const classList = element.classList;
    classList.remove('ion-valid', 'ion-invalid', 'ion-touched', 'ion-untouched', 'ion-dirty', 'ion-pristine');
    classList.add(...classes);
};
const startsWith = (input, search) => {
    return input.substring(0, search.length) === search;
};
//# sourceMappingURL=data:application/json;base64,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