"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteFolderRecursive = exports.convertToUnixPath = void 0;
const utils_fs_1 = require("@ionic/utils-fs");
const path_1 = require("path");
const convertToUnixPath = (path) => {
    return path.replace(/\\/g, '/');
};
exports.convertToUnixPath = convertToUnixPath;
const deleteFolderRecursive = (directoryPath) => {
    if (utils_fs_1.existsSync(directoryPath)) {
        utils_fs_1.readdirSync(directoryPath).forEach(file => {
            const curPath = path_1.join(directoryPath, file);
            if (utils_fs_1.lstatSync(curPath).isDirectory()) {
                exports.deleteFolderRecursive(curPath);
            }
            else {
                utils_fs_1.unlinkSync(curPath);
            }
        });
        utils_fs_1.rmdirSync(directoryPath);
    }
};
exports.deleteFolderRecursive = deleteFolderRecursive;
