"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.inlineSourceMaps = void 0;
const utils_fs_1 = require("@ionic/utils-fs");
const path_1 = require("path");
const log_1 = require("../log");
function walkDirectory(dirPath) {
    const files = utils_fs_1.readdirSync(dirPath);
    files.forEach(file => {
        const targetFile = path_1.join(dirPath, file);
        if (utils_fs_1.existsSync(targetFile) && utils_fs_1.lstatSync(targetFile).isDirectory()) {
            walkDirectory(targetFile);
        }
        else {
            const mapFile = path_1.join(dirPath, `${file}.map`);
            if (path_1.extname(file) === '.js' && utils_fs_1.existsSync(mapFile)) {
                const bufMap = utils_fs_1.readFileSync(mapFile).toString('base64');
                const bufFile = utils_fs_1.readFileSync(targetFile, 'utf8');
                const result = bufFile.replace(`sourceMappingURL=${file}.map`, 'sourceMappingURL=data:application/json;charset=utf-8;base64,' +
                    bufMap);
                utils_fs_1.writeFileSync(targetFile, result);
                utils_fs_1.unlinkSync(mapFile);
            }
        }
    });
}
async function inlineSourceMaps(config, platformName) {
    let buildDir = '';
    if (platformName == config.ios.name) {
        buildDir = await config.ios.webDirAbs;
    }
    if (platformName == config.android.name) {
        buildDir = await config.android.webDirAbs;
    }
    if (buildDir) {
        log_1.logger.info('Inlining sourcemaps');
        walkDirectory(buildDir);
    }
}
exports.inlineSourceMaps = inlineSourceMaps;
